/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.util;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;

class DialogoFiltroFaturas
extends JDialog
implements ActionListener {
    private static final String SELECIONADO = "selecionado";
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", '\u0000', this);
    private JButton buttonDesmarcarTodos = ComponenteFactory.novoJButton("Desmarcar Todos", 'D', this);
    private JButton buttonMarcarTodos = ComponenteFactory.novoJButton("Selecionar Todos", 'S', this);
    private JButton buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JButton buttonDataIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private TTextField textDataIni = new TTextField(0, 4);
    private TTextField textDataFin = new TTextField(0, 4);
    private ModeloResultSet modFat = new ModeloResultSet("Fatura", "fat_codigo", "Conv\u00eanio", "con_fantasia", "Emiss\u00e3o", "fat_dtemis", "", "selecionado");
    private CheckItemFiltro itemConvenio;
    private boolean ok;

    public static DialogoFiltroFaturas novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new DialogoFiltroFaturas((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new DialogoFiltroFaturas((Dialog)pai);
        }
        return null;
    }

    public DialogoFiltroFaturas(Frame pai) {
        super(pai, "Sele\u00e7\u00e3o de faturas", true);
        this.iniciar();
        this.setLocationRelativeTo(pai);
    }

    public DialogoFiltroFaturas(Dialog pai) {
        super(pai, "Sele\u00e7\u00e3o faturas", true);
        this.iniciar();
        this.setLocationRelativeTo(pai);
    }

    public boolean getOk() {
        return this.ok;
    }

    public List<Registro> getFaturasSelecionadas() {
        ArrayList<Registro> sel = new ArrayList<Registro>();
        for (Registro reg : this.modFat.getRegistros()) {
            if (!reg.getBoolean(SELECIONADO)) continue;
            sel.add(reg);
        }
        return sel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOK || o == this.buttonCancelar) {
            this.ok = o == this.buttonOK;
            this.dispose();
        } else if (o == this.buttonMarcarTodos || o == this.buttonDesmarcarTodos) {
            boolean marcar = o == this.buttonMarcarTodos;
            for (Registro reg : this.modFat.getRegistros()) {
                reg.setValor(SELECIONADO, marcar);
            }
            this.modFat.fireTableDataChanged();
        } else if (o == this.buttonDataIni) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, (JPanel)this.buttonDataIni.getParent(), true);
        } else if (o == this.buttonDataFin) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, (JPanel)this.buttonDataFin.getParent(), true);
        } else if (o == this.buttonConsultar) {
            this.consultarRequisicoes();
        }
    }

    private void consultarRequisicoes() {
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                this.modFat.limpar();
                ResultSet res = Conexao.executeQuery(st, this.getSelect());
                while (res.next()) {
                    Registro reg = new Registro(res);
                    reg.setValor("fat_dtemis", Funcoes.formataData("dd/MM/yyyy", res.getDate("fat_dtemis")));
                    this.modFat.addRegistro(reg);
                }
                this.modFat.fireTableDataChanged();
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoFiltroFaturas (437)");
            }
        }
    }

    private String getSelect() {
        StringBuilder bui = new StringBuilder();
        try {
            bui.append(" select a.fat_codigo ");
            bui.append("       ,a.fat_dtemis ");
            bui.append("       ,b.con_fantasia ");
            bui.append("       ,false as ").append(SELECIONADO).append(" ");
            bui.append("   from fatura a ");
            bui.append("   left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
            bui.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
            bui.append("    and a.fat_datacancelamento is null ");
            bui.append("    and (a.fil_codigo, a.fat_codigo) not in (select fnf.fil_codigo ");
            bui.append("                                                   ,fnf.fat_codigo ");
            bui.append("                                               from faturanotafiscal fnf, ");
            bui.append("                                                    notafiscal nfi ");
            bui.append("                                              where fnf.fil_codigo = nfi.fil_codigo ");
            bui.append("                                                and fnf.nfi_codigo = nfi.nfi_codigo ");
            bui.append("                                                and ((nfi.nfi_numerorps IS NULL and nfi.nfi_situacao IN ('").append("A").append("', '").append("I").append("')) ");
            bui.append("                                                  or (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao = '").append("A").append("')) ");
            if (Funcoes.verificaData(this.textDataIni.getText())) {
                bui.append("and \n a.fat_dtemis >= '");
                bui.append(Funcoes.formataData("MM/dd/yyyy", this.textDataIni.getText())).append("' ");
            }
            if (Funcoes.verificaData(this.textDataFin.getText())) {
                bui.append("and \n  a.fat_dtemis <= '");
                bui.append(Funcoes.formataData("MM/dd/yyyy", this.textDataFin.getText())).append("' ");
            }
            if (this.itemConvenio.isSelected()) {
                this.addExpressao(bui, "a.con_codigo", this.itemConvenio, false);
            }
            bui.append(" order by a.fat_dtemis ");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DialogoFiltroFatuas (493)");
        }
        return bui.toString();
    }

    private void addExpressao(StringBuilder bui, String campo, CheckItemFiltro itemFiltro, boolean aspas) {
        if (itemFiltro.getSelecionados(0) != null && itemFiltro.getSelecionados(0).length > 0) {
            bui.append("and \n  ");
            bui.append(ImpressaoResultados.getExpressao(campo, itemFiltro.getSelecionados(0), aspas));
            bui.append(" ");
        }
    }

    private void iniciar() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelAux = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)panelAux, "South");
        panelAux.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, this.buttonMarcarTodos, this.buttonDesmarcarTodos), "West");
        panelAux.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonOK, this.buttonCancelar), "East");
        panelAux = ComponenteFactory.novoJPanel(new BorderLayout(), BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.getContentPane().add((Component)panelAux, "Center");
        this.modFat.setColunaEditavel(SELECIONADO);
        JTable table = ComponenteFactory.novoJTable((TableModel)this.modFat, 75, 0, 85, 25);
        table.setDefaultRenderer(String.class, CorTableCellRenderer.novaInstancia(4, -1, 4));
        JScrollPane scroll = new JScrollPane(table);
        scroll.setPreferredSize(new Dimension(scroll.getPreferredSize().width, 250));
        panelAux.add((Component)scroll, "Center");
        panelAux = ComponenteFactory.novoJPanel(new GridBagLayout(), BorderFactory.createTitledBorder("Filtros"));
        this.getContentPane().add((Component)panelAux, "North");
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        cons.gridx = 0;
        cons.gridy = 0;
        this.textDataIni.setPreferredSize(new Dimension(90, 20));
        this.buttonDataIni.setFocusable(false);
        panelAux.add((Component)ComponenteFactory.novoJPanelBorderLayout(this.textDataIni, null, null, this.buttonDataIni, ComponenteFactory.novoJLabel("Data Inicial:", new Dimension(100, 20))), cons);
        cons.gridx = 1;
        this.textDataFin.setPreferredSize(new Dimension(90, 20));
        this.buttonDataFin.setFocusable(false);
        panelAux.add((Component)ComponenteFactory.novoJPanelBorderLayout(this.textDataFin, null, null, this.buttonDataFin, ComponenteFactory.novoJLabel("Data Final:", new Dimension(100, 20))), cons);
        cons.gridx = 0;
        cons.gridy = 1;
        cons.gridwidth = 2;
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        panelAux.add((Component)this.itemConvenio, cons);
        cons.gridy = 2;
        cons.insets = new Insets(0, 0, 0, 0);
        JPanel panel = new JPanel(new FlowLayout(2, 0, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 1));
        panel.add(this.buttonConsultar);
        panelAux.add((Component)panel, cons);
        Funcoes.montaEnter((JComponent)this.getContentPane());
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(113, 0, true), "F2", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogoFiltroFaturas.this.textDataIni.hasFocus()) {
                    Funcoes.mostraData(DialogoFiltroFaturas.this.textDataIni, DialogoFiltroFaturas.this.buttonDataIni, (JPanel)DialogoFiltroFaturas.this.buttonDataIni.getParent(), true);
                } else if (DialogoFiltroFaturas.this.textDataFin.hasFocus()) {
                    Funcoes.mostraData(DialogoFiltroFaturas.this.textDataFin, DialogoFiltroFaturas.this.buttonDataFin, (JPanel)DialogoFiltroFaturas.this.buttonDataFin.getParent(), true);
                }
            }
        });
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setResizable(false);
        ScreenUtil.centralizar(this);
    }
}

