/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos.componente;

import jalis.laboratorio.financeiro.lancamentos.componente.PanelPlanoContaCentroCusto;
import jalis.model.bean.financeiro.LancamentoPlanoContaBean;
import jalis.model.bean.financeiro.ReceberPagarPlanoContaBean;
import jalis.model.vo.cadastro.financeiro.PlanoContaVO;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class PlanoContaRenderer
extends DefaultTableCellRenderer {
    private JTable tablePlanoConta = null;
    private int tipoTela = PanelPlanoContaCentroCusto.TIPO_LANCAMENTO;

    public PlanoContaRenderer(int tipoTela, JTable tablePlanoConta) {
        this.tablePlanoConta = tablePlanoConta;
        this.tipoTela = tipoTela;
    }

    @Override
    public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
        Component c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
        this.setValue(value);
        row = table.getRowSorter().convertRowIndexToModel(row);
        c.setForeground(Color.BLACK);
        if (this.tablePlanoConta == null || this.tablePlanoConta.getModel() == null || this.tablePlanoConta.getModel().getRowCount() < 0 || row < 0) {
            return c;
        }
        if (this.tipoTela == PanelPlanoContaCentroCusto.TIPO_LANCAMENTO) {
            LancamentoPlanoContaBean pc = (LancamentoPlanoContaBean)this.tablePlanoConta.getModel().getValueAt(row, 5);
            PlanoContaVO plano = pc.getPlanoConta();
            if (plano != null && plano.getOperacao() != null && plano.getOperacao().equalsIgnoreCase("S")) {
                c.setForeground(Color.RED);
            }
        } else {
            ReceberPagarPlanoContaBean pc = (ReceberPagarPlanoContaBean)this.tablePlanoConta.getModel().getValueAt(row, 5);
            PlanoContaVO plano = pc.getPlanoConta();
            if (plano != null && plano.getOperacao() != null && plano.getOperacao().equalsIgnoreCase("S")) {
                c.setForeground(Color.RED);
            }
        }
        return c;
    }
}

