/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos.componente;

import jalis.comum.Acesso;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.lancamentos.componente.BuscaBeanPreenchido;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.financeiro.CentroCustoPlanoContaBean;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.model.bean.financeiro.LancamentoCentroCustoBean;
import jalis.model.bean.financeiro.LancamentoPlanoContaBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.bean.financeiro.ReceberPagarCentroCustoBean;
import jalis.model.bean.financeiro.ReceberPagarPlanoContaBean;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.financeiro.CentroCustoVO;
import jalis.model.vo.cadastro.financeiro.OrigemVO;
import jalis.model.vo.cadastro.financeiro.PlanoContaVO;
import jalis.model.vo.financeiro.LancamentoVO;
import jalis.service.AbstractThreadService;
import jalis.service.cadastro.financeiro.CentroCustoPlanoContaService;
import jalis.service.cadastro.financeiro.CentroCustoService;
import jalis.service.cadastro.financeiro.OrigemService;
import jalis.service.cadastro.financeiro.PlanoContaService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class PanelPlanoContaCentroCusto
extends JPanel {
    public static int TIPO_LANCAMENTO = 1;
    public static int TIPO_RECEBER_PAGAR = 2;
    private JPanel panelPlanoConta = new JPanel(new GridBagLayout());
    private DefaultTableModel modelPlanoConta;
    private JTable tablePlanoConta;
    private JScrollPane scrollPlanoConta;
    private JLabel labelPlanoConta = new JLabel("Plano de Contas");
    private JLabel labelValorPlano = new JLabel("Valor");
    private JLabel labelComboPlano = new JLabel("Origem");
    private TTextField textCodigoPlanoConta = new TTextField(5, 1);
    private JButton buttonBuscaPlanoConta = new JButton();
    private TTextField textDescricaoPlanoConta = new TTextField();
    private TTextField textValorPlano = new TTextField(10, 2, 2);
    private JComboBox comboPlano = new JComboBox();
    private JButton buttonAdicionarPlanoConta = new JButton("OK");
    private JLabel labelTotalPlano = new JLabel("Total:");
    private JLabel labelValorTotalPlano = new JLabel(Funcoes.formataDecimal(0.0));
    private JPanel panelCentroCusto = new JPanel(new GridBagLayout());
    private DefaultTableModel modelCentroCusto;
    private JTable tableCentroCusto;
    private JScrollPane scrollCentroCusto;
    private JLabel labelCentroCusto = new JLabel("Centro de Custo");
    private JLabel labelValorCentro = new JLabel("Valor");
    private JLabel labelComboCentro = new JLabel("Origem");
    private TTextField textCodigoCentroCusto = new TTextField(10, 1);
    private JButton buttonBuscaCentroCusto = new JButton();
    private TTextField textDescricaoCentroCusto = new TTextField();
    private TTextField textValorCentro = new TTextField(10, 2, 2);
    private JComboBox comboCentro = new JComboBox();
    private JButton buttonAdicionarCentroCusto = new JButton("OK");
    private JLabel labelTotalCentro = new JLabel("Total:");
    private JLabel labelValorTotalCentro = new JLabel(Funcoes.formataDecimal(0.0));
    private PlanoContaService planoContaService = new PlanoContaService();
    private ArrayList<AbstractThreadBean> planosContas;
    private CentroCustoService centroCustoService = new CentroCustoService();
    private ArrayList<AbstractThreadBean> centrosCusto;
    private OrigemService origemService = new OrigemService();
    private AbstractThreadBean centro = null;
    private AbstractThreadBean bean = null;
    private AbstractThreadService tService = null;
    private long acessoAlterarPlanoContas;
    private long acessoAlterarCentrosCusto;
    private int tipoTela = 1;
    private BuscaBeanPreenchido tela;
    private boolean somenteLeitura = false;
    private Date dataBaixa = null;
    private boolean alterandoPlanoConta = false;
    private boolean alterandoCentroCusto = false;
    private String tipoDebitoCredito = null;
    private boolean haPlanosContasCadastrados;
    private boolean haCentrosCustoCadastrados;
    private String filialTransferencia;
    private String filialPadrao = null;

    public PanelPlanoContaCentroCusto(BuscaBeanPreenchido tela, int tipo, long acessoAlterarPlanoContas, long acessoAlterarCentrosCusto, String filialPadrao) {
        this.filialTransferencia = null;
        this.filialPadrao = filialPadrao;
        this.montaTela(tela, tipo, acessoAlterarPlanoContas, acessoAlterarCentrosCusto);
    }

    public PanelPlanoContaCentroCusto(BuscaBeanPreenchido tela, int tipo, long acessoAlterarPlanoContas, long acessoAlterarCentrosCusto, String filialTransf, String filialPadrao) {
        this.filialTransferencia = filialTransf;
        this.filialPadrao = filialPadrao;
        this.montaTela(tela, tipo, acessoAlterarPlanoContas, acessoAlterarCentrosCusto);
    }

    private void montaTela(BuscaBeanPreenchido tela, int tipo, long acessoAlterarPlanoContas, long acessoAlterarCentrosCusto) {
        this.tipoTela = tipo;
        this.tela = tela;
        this.setLayout(new GridBagLayout());
        this.acessoAlterarPlanoContas = acessoAlterarPlanoContas;
        this.acessoAlterarCentrosCusto = acessoAlterarCentrosCusto;
        try {
            this.haPlanosContasCadastrados = new PlanoContaService().haPlanosContas(this.getFilial());
            this.haCentrosCustoCadastrados = new CentroCustoService().haCentrosCusto(this.getFilial());
        }
        catch (SQLException e2) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel consultar informa\u00e7\u00f5es de centro de custo e plano de contas.", e2.getStackTrace());
        }
        this.carregarCombo(this.filialPadrao);
        Dimension d = null;
        d = new Dimension(60, 20);
        this.textCodigoPlanoConta.setSize(d);
        this.textCodigoPlanoConta.setPreferredSize(d);
        this.textCodigoPlanoConta.setMinimumSize(d);
        this.textCodigoPlanoConta.setMaximumSize(d);
        this.textCodigoPlanoConta.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    PanelPlanoContaCentroCusto.this.buscaPlanoConta();
                }
            }
        });
        this.textCodigoPlanoConta.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanelPlanoContaCentroCusto.this.buscaPlanoConta(PanelPlanoContaCentroCusto.this.textCodigoPlanoConta.getText());
            }
        });
        this.buttonBuscaPlanoConta.setFocusable(false);
        this.buttonBuscaPlanoConta.setText("");
        d = new Dimension(20, 20);
        this.buttonBuscaPlanoConta.setSize(d);
        this.buttonBuscaPlanoConta.setPreferredSize(d);
        this.buttonBuscaPlanoConta.setMinimumSize(d);
        this.buttonBuscaPlanoConta.setMaximumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaPlanoConta);
        this.buttonBuscaPlanoConta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelPlanoContaCentroCusto.this.buscaPlanoConta();
            }
        });
        d = new Dimension(100, 20);
        this.textDescricaoPlanoConta.setSize(d);
        this.textDescricaoPlanoConta.setPreferredSize(d);
        this.textDescricaoPlanoConta.setMinimumSize(d);
        this.textDescricaoPlanoConta.setEditable(false);
        this.textDescricaoPlanoConta.setFocusable(false);
        d = new Dimension(60, 20);
        this.comboPlano.setSize(d);
        this.comboPlano.setPreferredSize(d);
        this.comboPlano.setMinimumSize(d);
        this.comboPlano.setMaximumSize(d);
        d = new Dimension(70, 20);
        this.textValorPlano.setSize(d);
        this.textValorPlano.setPreferredSize(d);
        this.textValorPlano.setMinimumSize(d);
        this.textValorPlano.setMaximumSize(d);
        this.textValorPlano.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                double valor = PanelPlanoContaCentroCusto.this.buscaValorTituloPlano();
                if (valor > 0.0) {
                    PanelPlanoContaCentroCusto.this.textValorPlano.setText(Funcoes.formataDecimal("#,##0.00", valor));
                }
            }
        });
        d = new Dimension(30, 20);
        this.buttonAdicionarPlanoConta.setSize(d);
        this.buttonAdicionarPlanoConta.setPreferredSize(d);
        this.buttonAdicionarPlanoConta.setMinimumSize(d);
        this.buttonAdicionarPlanoConta.setMaximumSize(d);
        this.buttonAdicionarPlanoConta.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAdicionarPlanoConta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelPlanoContaCentroCusto.this.adicionarPlanoConta(null, true, true);
                PanelPlanoContaCentroCusto.this.setAlterarPlanoConta(false);
                PanelPlanoContaCentroCusto.this.controlaCampos(true);
                if (PanelPlanoContaCentroCusto.this.textCodigoPlanoConta.isFocusable()) {
                    PanelPlanoContaCentroCusto.this.textCodigoPlanoConta.grabFocus();
                }
            }
        });
        d = new Dimension(60, 20);
        this.textCodigoCentroCusto.setSize(d);
        this.textCodigoCentroCusto.setPreferredSize(d);
        this.textCodigoCentroCusto.setMinimumSize(d);
        this.textCodigoCentroCusto.setMaximumSize(d);
        this.textCodigoCentroCusto.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    PanelPlanoContaCentroCusto.this.buscaCentroCusto();
                }
            }
        });
        this.textCodigoCentroCusto.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PanelPlanoContaCentroCusto.this.buscaCentroCusto(PanelPlanoContaCentroCusto.this.textCodigoCentroCusto.getText());
            }
        });
        this.buttonBuscaCentroCusto.setFocusable(false);
        this.buttonBuscaCentroCusto.setText("");
        d = new Dimension(20, 20);
        this.buttonBuscaCentroCusto.setSize(d);
        this.buttonBuscaCentroCusto.setPreferredSize(d);
        this.buttonBuscaCentroCusto.setMinimumSize(d);
        this.buttonBuscaCentroCusto.setMaximumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaCentroCusto);
        this.buttonBuscaCentroCusto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelPlanoContaCentroCusto.this.buscaCentroCusto();
            }
        });
        d = new Dimension(100, 20);
        this.textDescricaoCentroCusto.setSize(d);
        this.textDescricaoCentroCusto.setPreferredSize(d);
        this.textDescricaoCentroCusto.setMinimumSize(d);
        this.textDescricaoCentroCusto.setEditable(false);
        this.textDescricaoCentroCusto.setFocusable(false);
        d = new Dimension(60, 20);
        this.comboCentro.setSize(d);
        this.comboCentro.setPreferredSize(d);
        this.comboCentro.setMinimumSize(d);
        this.comboCentro.setMaximumSize(d);
        d = new Dimension(70, 20);
        this.textValorCentro.setSize(d);
        this.textValorCentro.setPreferredSize(d);
        this.textValorCentro.setMinimumSize(d);
        this.textValorCentro.setMaximumSize(d);
        this.textValorCentro.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PanelPlanoContaCentroCusto.this.buscaValorTituloCentro();
            }
        });
        d = new Dimension(30, 20);
        this.buttonAdicionarCentroCusto.setSize(d);
        this.buttonAdicionarCentroCusto.setPreferredSize(d);
        this.buttonAdicionarCentroCusto.setMinimumSize(d);
        this.buttonAdicionarCentroCusto.setMaximumSize(d);
        this.buttonAdicionarCentroCusto.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAdicionarCentroCusto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelPlanoContaCentroCusto.this.adicionarCentroCusto(null, true);
                PanelPlanoContaCentroCusto.this.setAlterarCentroCusto(false);
                PanelPlanoContaCentroCusto.this.controlaCampos(true);
                if (PanelPlanoContaCentroCusto.this.textCodigoCentroCusto.isFocusable()) {
                    PanelPlanoContaCentroCusto.this.textCodigoCentroCusto.grabFocus();
                }
            }
        });
        this.panelPlanoConta.setBorder(new TitledBorder("Plano de Contas"));
        this.panelCentroCusto.setBorder(new TitledBorder("Centros de Custo"));
        this.modelPlanoConta = new DefaultTableModel(new Object[0][], new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Conta", "Org", "Valor", "Objeto"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            public Class getColumnClass(int column) {
                Class returnValue = Object.class;
                if (this.getRowCount() > 0 && column >= 0 && column < this.getColumnCount() && this.getValueAt(0, column) != null) {
                    returnValue = this.getValueAt(0, column).getClass();
                }
                return returnValue;
            }
        };
        this.tablePlanoConta = new JTable(this.modelPlanoConta);
        TableRowSorter<TableModel> sorterPlanos = new TableRowSorter<TableModel>(this.tablePlanoConta.getModel());
        ArrayList<RowSorter.SortKey> listaPlanos = new ArrayList<RowSorter.SortKey>();
        listaPlanos.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        ((RowSorter)sorterPlanos).setSortKeys(listaPlanos);
        this.tablePlanoConta.setRowSorter(sorterPlanos);
        this.tablePlanoConta.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (PanelPlanoContaCentroCusto.this.tablePlanoConta.isEnabled()) {
                    if (e.getKeyCode() == 127) {
                        PanelPlanoContaCentroCusto.this.removerPlanoConta();
                    } else if (e.getKeyCode() == 32) {
                        PanelPlanoContaCentroCusto.this.alterarPlanoConta();
                    }
                    PanelPlanoContaCentroCusto.this.tableCentroCusto.revalidate();
                    PanelPlanoContaCentroCusto.this.tableCentroCusto.repaint();
                }
            }
        });
        this.tablePlanoConta.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PanelPlanoContaCentroCusto.this.tablePlanoConta.isEnabled()) {
                    if (e.getClickCount() == 2) {
                        PanelPlanoContaCentroCusto.this.alterarPlanoConta();
                    }
                    PanelPlanoContaCentroCusto.this.tableCentroCusto.revalidate();
                    PanelPlanoContaCentroCusto.this.tableCentroCusto.repaint();
                }
            }
        });
        this.tablePlanoConta.getColumnModel().getColumn(0).setMinWidth(60);
        this.tablePlanoConta.getColumnModel().getColumn(0).setMaxWidth(60);
        this.tablePlanoConta.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.tablePlanoConta.getColumnModel().getColumn(0).setWidth(60);
        this.tablePlanoConta.getColumnModel().getColumn(2).setMinWidth(75);
        this.tablePlanoConta.getColumnModel().getColumn(2).setMaxWidth(75);
        this.tablePlanoConta.getColumnModel().getColumn(2).setPreferredWidth(75);
        this.tablePlanoConta.getColumnModel().getColumn(2).setWidth(75);
        this.tablePlanoConta.getColumnModel().getColumn(3).setMinWidth(50);
        this.tablePlanoConta.getColumnModel().getColumn(3).setMaxWidth(50);
        this.tablePlanoConta.getColumnModel().getColumn(3).setPreferredWidth(50);
        this.tablePlanoConta.getColumnModel().getColumn(3).setWidth(50);
        this.tablePlanoConta.getColumnModel().getColumn(4).setMinWidth(75);
        this.tablePlanoConta.getColumnModel().getColumn(4).setMaxWidth(75);
        this.tablePlanoConta.getColumnModel().getColumn(4).setPreferredWidth(75);
        this.tablePlanoConta.getColumnModel().getColumn(4).setWidth(75);
        this.tablePlanoConta.removeColumn(this.tablePlanoConta.getColumnModel().getColumn(5));
        this.scrollPlanoConta = new JScrollPane(this.tablePlanoConta);
        this.modelCentroCusto = new DefaultTableModel(new Object[0][], new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Centro", "Org", "Valor", "Objeto"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            public Class getColumnClass(int column) {
                Class returnValue = Object.class;
                if (this.getRowCount() > 0 && column >= 0 && column < this.getColumnCount() && this.getValueAt(0, column) != null) {
                    returnValue = this.getValueAt(0, column).getClass();
                }
                return returnValue;
            }
        };
        this.tableCentroCusto = new JTable(this.modelCentroCusto);
        TableRowSorter<TableModel> sorterCentro = new TableRowSorter<TableModel>(this.tableCentroCusto.getModel());
        ArrayList<RowSorter.SortKey> listaCentros = new ArrayList<RowSorter.SortKey>();
        listaCentros.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        ((RowSorter)sorterCentro).setSortKeys(listaCentros);
        this.tableCentroCusto.setRowSorter(sorterCentro);
        this.tableCentroCusto.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (PanelPlanoContaCentroCusto.this.tableCentroCusto.isEnabled()) {
                    if (e.getKeyCode() == 127) {
                        PanelPlanoContaCentroCusto.this.removerCentroCusto();
                    } else if (e.getKeyCode() == 32) {
                        PanelPlanoContaCentroCusto.this.alterarCentroCusto();
                    }
                }
            }
        });
        this.tableCentroCusto.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PanelPlanoContaCentroCusto.this.tableCentroCusto.isEnabled() && e.getClickCount() == 2) {
                    PanelPlanoContaCentroCusto.this.alterarCentroCusto();
                }
            }
        });
        this.tableCentroCusto.getColumnModel().getColumn(0).setMinWidth(60);
        this.tableCentroCusto.getColumnModel().getColumn(0).setMaxWidth(60);
        this.tableCentroCusto.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.tableCentroCusto.getColumnModel().getColumn(0).setWidth(60);
        this.tableCentroCusto.getColumnModel().getColumn(2).setMinWidth(75);
        this.tableCentroCusto.getColumnModel().getColumn(2).setMaxWidth(75);
        this.tableCentroCusto.getColumnModel().getColumn(2).setPreferredWidth(75);
        this.tableCentroCusto.getColumnModel().getColumn(2).setWidth(75);
        this.tableCentroCusto.getColumnModel().getColumn(3).setMinWidth(50);
        this.tableCentroCusto.getColumnModel().getColumn(3).setMaxWidth(50);
        this.tableCentroCusto.getColumnModel().getColumn(3).setPreferredWidth(50);
        this.tableCentroCusto.getColumnModel().getColumn(3).setWidth(50);
        this.tableCentroCusto.getColumnModel().getColumn(4).setMinWidth(75);
        this.tableCentroCusto.getColumnModel().getColumn(4).setMaxWidth(75);
        this.tableCentroCusto.getColumnModel().getColumn(4).setPreferredWidth(75);
        this.tableCentroCusto.getColumnModel().getColumn(4).setWidth(75);
        this.tableCentroCusto.removeColumn(this.tableCentroCusto.getColumnModel().getColumn(5));
        this.scrollCentroCusto = new JScrollPane(this.tableCentroCusto);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.anchor = 17;
        c.gridwidth = 3;
        this.panelPlanoConta.add((Component)this.labelPlanoConta, c);
        c.gridwidth = 1;
        c.gridx += 3;
        this.panelPlanoConta.add((Component)this.labelComboPlano, c);
        ++c.gridx;
        this.panelPlanoConta.add((Component)this.labelValorPlano, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelPlanoConta.add((Component)this.textCodigoPlanoConta, c);
        ++c.gridx;
        this.panelPlanoConta.add((Component)this.buttonBuscaPlanoConta, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelPlanoConta.add((Component)this.textDescricaoPlanoConta, c);
        c.weightx = 0.0;
        c.fill = 0;
        ++c.gridx;
        this.panelPlanoConta.add((Component)this.comboPlano, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.panelPlanoConta.add((Component)this.textValorPlano, c);
        c.gridx += 2;
        c.gridwidth = 1;
        this.panelPlanoConta.add((Component)this.buttonAdicionarPlanoConta, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 7;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panelPlanoConta.add((Component)this.scrollPlanoConta, c);
        ++c.gridy;
        c.gridx = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.panelPlanoConta.add((Component)this.labelTotalPlano, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.anchor = 13;
        this.panelPlanoConta.add((Component)this.labelValorTotalPlano, c);
        c = new GridBagConstraints();
        c.gridy = 0;
        c.anchor = 17;
        c.gridwidth = 3;
        this.panelCentroCusto.add((Component)this.labelCentroCusto, c);
        c.gridwidth = 1;
        c.gridx += 4;
        this.panelCentroCusto.add((Component)this.labelComboCentro, c);
        ++c.gridx;
        this.panelCentroCusto.add((Component)this.labelValorCentro, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelCentroCusto.add((Component)this.textCodigoCentroCusto, c);
        ++c.gridx;
        this.panelCentroCusto.add((Component)this.buttonBuscaCentroCusto, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelCentroCusto.add((Component)this.textDescricaoCentroCusto, c);
        c.weightx = 0.0;
        c.fill = 0;
        ++c.gridx;
        this.panelCentroCusto.add((Component)this.comboCentro, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.panelCentroCusto.add((Component)this.textValorCentro, c);
        c.gridx += 2;
        c.gridwidth = 1;
        this.panelCentroCusto.add((Component)this.buttonAdicionarCentroCusto, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 7;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panelCentroCusto.add((Component)this.scrollCentroCusto, c);
        ++c.gridy;
        c.gridx = 4;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.panelCentroCusto.add((Component)this.labelTotalCentro, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.anchor = 13;
        this.panelCentroCusto.add((Component)this.labelValorTotalCentro, c);
        c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.4;
        c.weighty = 1.0;
        if (this.haPlanosContasCadastrados) {
            this.add((Component)this.panelPlanoConta, c);
        }
        ++c.gridx;
        c.weightx = 0.5;
        if (this.haCentrosCustoCadastrados) {
            this.add((Component)this.panelCentroCusto, c);
        }
    }

    public void carregarCombo(String filial) {
        try {
            this.comboPlano.removeAllItems();
            this.comboCentro.removeAllItems();
            Set origens = this.origemService.loadVOTransferencia(this.getFilial());
            for (Object o : origens) {
                this.comboPlano.addItem(o);
                this.comboCentro.addItem(o);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private String getFilial() {
        return this.filialTransferencia == null ? (Funcoes.textoVazio(this.filialPadrao) ? Variaveis.filialPadrao : this.filialPadrao) : this.filialTransferencia;
    }

    public void limparSelecaoPlanoContas() {
        this.tablePlanoConta.getSelectionModel().clearSelection();
    }

    public void limparSelecaoCentroCusto() {
        this.tableCentroCusto.getSelectionModel().clearSelection();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        if (this.tablePlanoConta != null && this.tablePlanoConta.getSelectionModel() != null) {
            this.tablePlanoConta.getSelectionModel().addListSelectionListener(listener);
        }
        if (this.tableCentroCusto != null && this.tableCentroCusto.getSelectionModel() != null) {
            this.tableCentroCusto.getSelectionModel().addListSelectionListener(listener);
        }
    }

    public LancamentoPlanoContaBean getLancamentoPlanoContaSelecionado() {
        if (this.modelPlanoConta != null && this.tablePlanoConta != null) {
            if (this.tablePlanoConta.getSelectedRow() >= 0) {
                int row = this.tablePlanoConta.getRowSorter().convertRowIndexToModel(this.tablePlanoConta.getSelectedRow());
                if (row >= 0) {
                    LancamentoPlanoContaBean lancto = (LancamentoPlanoContaBean)this.modelPlanoConta.getValueAt(row, 5);
                    lancto.setLancamento((LancamentoVO)((LancamentoBean)this.tela.buscaBeanPreenchido(null)).toVO());
                    return lancto;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public LancamentoCentroCustoBean getLancamentoCentroCustoSelecionado() {
        if (this.modelCentroCusto != null && this.tableCentroCusto != null) {
            if (this.tableCentroCusto.getSelectedRow() >= 0) {
                int row = this.tableCentroCusto.getRowSorter().convertRowIndexToModel(this.tableCentroCusto.getSelectedRow());
                if (row >= 0) {
                    LancamentoCentroCustoBean centro = (LancamentoCentroCustoBean)this.modelCentroCusto.getValueAt(row, 5);
                    centro.setLancamento((LancamentoVO)((LancamentoBean)this.tela.buscaBeanPreenchido(null)).toVO());
                    return centro;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public void setTipoDebitoCredito(String tipoDebitoCredito) {
        this.tipoDebitoCredito = tipoDebitoCredito;
    }

    public void setDataBaixa(Date dataBaixa) {
        this.dataBaixa = dataBaixa;
    }

    public void removerTodosPlanosContas() {
        if (this.getPlanoContas() != null) {
            for (int i = 0; i < this.getPlanoContas().size(); ++i) {
                AbstractThreadBean aux = this.getPlanoContas().get(i);
                if (aux instanceof ReceberPagarPlanoContaBean) {
                    ((ReceberPagarPlanoContaBean)aux).setRemover(true);
                    continue;
                }
                if (!(aux instanceof LancamentoPlanoContaBean)) continue;
                ((LancamentoPlanoContaBean)aux).setRemover(true);
            }
        }
        this.limparPlanoConta();
    }

    public void removerTodosCentrosCusto() {
        if (this.getCentrosCusto() != null) {
            for (int i = 0; i < this.getCentrosCusto().size(); ++i) {
                AbstractThreadBean aux = this.getCentrosCusto().get(i);
                if (aux instanceof ReceberPagarCentroCustoBean) {
                    ((ReceberPagarCentroCustoBean)aux).setRemover(true);
                    continue;
                }
                if (!(aux instanceof LancamentoCentroCustoBean)) continue;
                ((LancamentoCentroCustoBean)aux).setRemover(true);
            }
        }
        this.limparCentroCusto();
    }

    public void controlaCampos(boolean habilitar) {
        boolean aux = habilitar && Acesso.getAcesso(this.acessoAlterarPlanoContas);
        this.textCodigoPlanoConta.setEnabled(aux);
        this.buttonBuscaPlanoConta.setEnabled(aux);
        this.textDescricaoPlanoConta.setEnabled(aux);
        this.comboPlano.setEnabled(aux);
        this.textValorPlano.setEnabled(aux);
        this.buttonAdicionarPlanoConta.setEnabled(aux);
        aux = habilitar && Acesso.getAcesso(this.acessoAlterarCentrosCusto);
        this.textCodigoCentroCusto.setEnabled(aux);
        this.buttonBuscaCentroCusto.setEnabled(aux);
        this.textDescricaoCentroCusto.setEnabled(aux);
        this.comboCentro.setEnabled(aux);
        this.textValorCentro.setEnabled(aux);
        this.buttonAdicionarCentroCusto.setEnabled(aux);
        this.tablePlanoConta.setEnabled(aux);
        this.tableCentroCusto.setEnabled(aux);
    }

    private int getIndiceOrigemPadrao(JComboBox combo) {
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(this.getFilial()));
        OrigemVO origem = FinanceiroUtil.getOrigemPadrao(filial);
        if (origem == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Origem financeira padr\u00e3o n\u00e3o est\u00e1 configurada para a filial.", 2);
            ScreenUtil.requisitarFoco(combo);
            return -1;
        }
        String codigoOrigem = origem.getCodigo();
        for (int i = 0; i < combo.getItemCount(); ++i) {
            OrigemVO aux = (OrigemVO)combo.getItemAt(i);
            if (!aux.getCodigo().equals(codigoOrigem)) continue;
            return i;
        }
        return -1;
    }

    public void limparCampos() {
        this.bean = null;
        this.textCodigoPlanoConta.setText("");
        this.textDescricaoPlanoConta.setText("");
        this.comboPlano.setSelectedIndex(this.getIndiceOrigemPadrao(this.comboPlano));
        this.textValorPlano.setText("");
        this.textCodigoCentroCusto.setText("");
        this.textDescricaoCentroCusto.setText("");
        this.comboCentro.setSelectedIndex(this.getIndiceOrigemPadrao(this.comboCentro));
        this.textValorCentro.setText("");
        this.limparPlanoConta();
        this.limparCentroCusto();
        this.planosContas = new ArrayList();
        this.centrosCusto = new ArrayList();
        this.centro = null;
        this.labelValorTotalCentro.setText("");
        this.labelValorTotalPlano.setText("");
    }

    public void setPlanoContas(Set planoContas) {
        this.planosContas = new ArrayList(planoContas);
    }

    public void setCentrosCusto(Set centrosCusto) {
        this.centrosCusto = new ArrayList(centrosCusto);
    }

    public ArrayList<AbstractThreadBean> getPlanoContas() {
        return this.planosContas;
    }

    public ArrayList<AbstractThreadBean> getCentrosCusto() {
        return this.centrosCusto;
    }

    public void atualizar(AbstractThreadBean bean) {
        this.bean = bean;
        this.planosContas = null;
        this.planosContas = this.tipoTela == TIPO_LANCAMENTO ? new ArrayList(((LancamentoBean)bean).getPlanosContas()) : new ArrayList(((ReceberPagarBean)bean).getPlanosContas());
        if (this.planosContas != null && this.planosContas.size() > 0) {
            this.limparPlanoConta();
            this.popularPlanoConta();
        }
        this.centrosCusto = null;
        this.centrosCusto = this.tipoTela == TIPO_LANCAMENTO ? new ArrayList(((LancamentoBean)bean).getCentrosCusto()) : new ArrayList(((ReceberPagarBean)bean).getCentrosCusto());
        if (this.centrosCusto != null && this.centrosCusto.size() > 0) {
            this.limparCentroCusto();
            this.popularCentroCusto();
        }
    }

    public boolean verificaCentroCustoSemApropriacao() {
        double totalCentro = 0.0;
        for (AbstractThreadBean c : this.centrosCusto) {
            if (this.tipoTela == TIPO_LANCAMENTO) {
                if (((LancamentoCentroCustoBean)c).isRemover()) continue;
                if (((LancamentoCentroCustoBean)c).getCentroCusto().getOperacao().equalsIgnoreCase("A")) {
                    totalCentro += ((LancamentoCentroCustoBean)c).getValor().doubleValue();
                    continue;
                }
                totalCentro -= ((LancamentoCentroCustoBean)c).getValor().doubleValue();
                continue;
            }
            if (((ReceberPagarCentroCustoBean)c).isRemover()) continue;
            if (((ReceberPagarCentroCustoBean)c).getCentroCusto().getOperacao().equalsIgnoreCase("A")) {
                totalCentro += ((ReceberPagarCentroCustoBean)c).getValor().doubleValue();
                continue;
            }
            totalCentro -= ((ReceberPagarCentroCustoBean)c).getValor().doubleValue();
        }
        return totalCentro == 0.0 && this.haCentrosCustoCadastrados;
    }

    public boolean verificaPlanoContaSemApropriacao() {
        double totalPlano = 0.0;
        for (AbstractThreadBean c : this.planosContas) {
            if (this.tipoTela == TIPO_LANCAMENTO) {
                if (((LancamentoPlanoContaBean)c).isRemover()) continue;
                if (((LancamentoPlanoContaBean)c).getPlanoConta().getOperacao().equalsIgnoreCase("A")) {
                    totalPlano += ((LancamentoPlanoContaBean)c).getValor().doubleValue();
                    continue;
                }
                totalPlano -= ((LancamentoPlanoContaBean)c).getValor().doubleValue();
                continue;
            }
            if (((ReceberPagarPlanoContaBean)c).isRemover()) continue;
            if (((ReceberPagarPlanoContaBean)c).getPlanoConta().getOperacao().equalsIgnoreCase("A")) {
                totalPlano += ((ReceberPagarPlanoContaBean)c).getValor().doubleValue();
                continue;
            }
            totalPlano -= ((ReceberPagarPlanoContaBean)c).getValor().doubleValue();
        }
        return totalPlano == 0.0 && this.haPlanosContasCadastrados;
    }

    public boolean validar() {
        double totalPlano = 0.0;
        for (AbstractThreadBean c : this.planosContas) {
            if (this.tipoTela == TIPO_LANCAMENTO) {
                if (((LancamentoPlanoContaBean)c).isRemover()) continue;
                if (((LancamentoPlanoContaBean)c).getPlanoConta().getOperacao().equalsIgnoreCase("A")) {
                    totalPlano += ((LancamentoPlanoContaBean)c).getValor().doubleValue();
                    continue;
                }
                totalPlano -= ((LancamentoPlanoContaBean)c).getValor().doubleValue();
                continue;
            }
            if (((ReceberPagarPlanoContaBean)c).isRemover()) continue;
            if (((ReceberPagarPlanoContaBean)c).getPlanoConta().getOperacao().equalsIgnoreCase("A")) {
                totalPlano += ((ReceberPagarPlanoContaBean)c).getValor().doubleValue();
                continue;
            }
            totalPlano -= ((ReceberPagarPlanoContaBean)c).getValor().doubleValue();
        }
        this.bean = this.tela.buscaBeanPreenchido(this);
        double valorTotal = 0.0;
        if (this.tipoTela == TIPO_LANCAMENTO) {
            valorTotal = ((LancamentoBean)this.bean).getValorTotal();
        } else {
            valorTotal = ((ReceberPagarBean)this.bean).getValorTotal() + ((ReceberPagarBean)this.bean).getValorIcms() + ((ReceberPagarBean)this.bean).getValorIpi();
            valorTotal = new BigDecimal(valorTotal).setScale(2, RoundingMode.HALF_DOWN).doubleValue();
        }
        return !(totalPlano > 0.0) || totalPlano == valorTotal;
    }

    public boolean validarOrigem() {
        for (AbstractThreadBean c : this.planosContas) {
            if (!(this.tipoTela == TIPO_LANCAMENTO ? !((LancamentoPlanoContaBean)c).isRemover() && ((LancamentoPlanoContaBean)c).getOrigem() == null : !((ReceberPagarPlanoContaBean)c).isRemover() && ((ReceberPagarPlanoContaBean)c).getOrigem() == null)) continue;
            return false;
        }
        for (AbstractThreadBean c : this.centrosCusto) {
            if (!(this.tipoTela == TIPO_LANCAMENTO ? !((LancamentoCentroCustoBean)c).isRemover() && ((LancamentoCentroCustoBean)c).getOrigem() == null : !((ReceberPagarCentroCustoBean)c).isRemover() && ((ReceberPagarCentroCustoBean)c).getOrigem() == null)) continue;
            return false;
        }
        return true;
    }

    public void alterarCentroCusto() {
        if (!this.somenteLeitura && Acesso.getAcesso(this.acessoAlterarCentrosCusto) && this.tableCentroCusto.getSelectedRowCount() > 0) {
            int row = this.tableCentroCusto.getRowSorter().convertRowIndexToModel(this.tableCentroCusto.getSelectedRow());
            this.centro = (AbstractThreadBean)this.modelCentroCusto.getValueAt(row, 5);
            if (this.tipoTela == TIPO_LANCAMENTO) {
                LancamentoCentroCustoBean centro = (LancamentoCentroCustoBean)this.centro;
                this.textCodigoCentroCusto.setText(Integer.toString(centro.getCentroCusto().getReduzido()));
                this.textDescricaoCentroCusto.setText(centro.getCentroCusto().getDescricao());
                this.comboCentro.setSelectedItem(centro.getOrigem());
                this.carregarValorCentroCusto(centro.getValor());
                this.textCodigoCentroCusto.setEnabled(false);
            } else {
                ReceberPagarCentroCustoBean centro = (ReceberPagarCentroCustoBean)this.centro;
                this.textCodigoCentroCusto.setText(Integer.toString(centro.getCentroCusto().getReduzido()));
                this.textDescricaoCentroCusto.setText(centro.getCentroCusto().getDescricao());
                this.comboCentro.setSelectedItem(centro.getOrigem());
                this.carregarValorCentroCusto(centro.getValor());
                this.textCodigoCentroCusto.setEnabled(false);
            }
            this.setAlterarCentroCusto(true);
        }
    }

    private void carregarValorCentroCusto(Double valor) {
        if (valor > 0.0) {
            this.textValorCentro.setText(Funcoes.formataDecimal("#,##0.00", valor));
        } else {
            this.textValorCentro.setText("");
        }
    }

    private void removerCentroCusto() {
        if (Acesso.getAcesso(this.acessoAlterarCentrosCusto) && this.tableCentroCusto.getSelectedRowCount() >= 0 && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            int row = this.tableCentroCusto.getRowSorter().convertRowIndexToModel(this.tableCentroCusto.getSelectedRow());
            this.centro = (AbstractThreadBean)this.modelCentroCusto.getValueAt(row, 5);
            if (this.tipoTela == TIPO_LANCAMENTO) {
                ((LancamentoCentroCustoBean)this.centro).setRemover(true);
            } else {
                ((ReceberPagarCentroCustoBean)this.centro).setRemover(true);
            }
            this.centro = null;
            this.setAlterarCentroCusto(false);
            this.controlaCampos(true);
            this.limparCentroCusto();
            this.popularCentroCusto();
            if (this.textCodigoCentroCusto.isFocusable()) {
                this.textCodigoCentroCusto.grabFocus();
            }
        }
    }

    private void buscaCentroCusto(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoCentroCusto.setText("");
            this.textDescricaoCentroCusto.setText("");
            return;
        }
        try {
            CentroCustoVO centro = (CentroCustoVO)this.centroCustoService.getVO(this.getFilial(), codigo);
            if (centro != null) {
                this.textCodigoCentroCusto.setText(centro.getReduzido().toString());
                this.textDescricaoCentroCusto.setText(centro.getDescricao());
            } else {
                this.textDescricaoCentroCusto.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PanelPlanoContaCentroCusto:467");
        }
    }

    private void buscaCentroCusto() {
        try {
            CentroCustoVO centro;
            this.textCodigoCentroCusto.setText("");
            this.textDescricaoCentroCusto.setText("");
            if (this.tela != null) {
                this.bean = this.tela.buscaBeanPreenchido(this);
            }
            if ((centro = (CentroCustoVO)this.centroCustoService.pesquisaVO(this.getTopLevelAncestor(), new CentroCustoVO(), "Pesquisando centros de custo", true, this.getFilial())) != null) {
                this.textCodigoCentroCusto.setText(centro.getReduzido().toString());
                this.textDescricaoCentroCusto.setText(centro.getDescricao());
            } else {
                this.textDescricaoCentroCusto.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PanelPlanoContaCentroCusto:483");
        }
        finally {
            if (this.textCodigoCentroCusto.isFocusable()) {
                this.textCodigoCentroCusto.grabFocus();
            }
        }
    }

    private boolean isDadosTelaOkCentroCusto() {
        return !Funcoes.textoVazio(this.textCodigoCentroCusto.getText()) && !Funcoes.textoVazio(this.textDescricaoCentroCusto.getText()) && !this.textDescricaoCentroCusto.getText().equalsIgnoreCase("N\u00e3o cadastrado") && !Funcoes.textoVazio(this.textValorCentro.getText());
    }

    private AbstractThreadBean getBeanPreenchidoCentroCusto(AbstractThreadBean bean) {
        if (!this.isDadosTelaOkCentroCusto()) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Todas as informa\u00e7\u00f5es sobre o centro de custo devem ser preenchidas.", 2);
            return null;
        }
        if (bean instanceof LancamentoCentroCustoBean) {
            return this.getBeanPreenchidoCentroCusto((LancamentoCentroCustoBean)bean);
        }
        if (bean instanceof ReceberPagarCentroCustoBean) {
            return this.getBeanPreenchidoCentroCusto((ReceberPagarCentroCustoBean)bean);
        }
        return null;
    }

    private LancamentoCentroCustoBean getBeanPreenchidoCentroCusto(LancamentoCentroCustoBean bean) {
        if (bean == null) {
            bean = new LancamentoCentroCustoBean();
        }
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(this.getFilial()));
        EstacaoVO estacao = null;
        if (this.bean != null && ((LancamentoBean)this.bean).getEstacao() != null) {
            estacao = ((LancamentoBean)this.bean).getEstacao();
        } else {
            estacao = new EstacaoVO();
            estacao.setCodigo(Integer.parseInt(Variaveis.codigoEstacao));
        }
        CentroCustoVO cc = null;
        try {
            cc = (CentroCustoVO)this.centroCustoService.getVO(this.getFilial(), this.textCodigoCentroCusto.getText());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PanelPlanoContaCentroCusto:getBeanPreenchido(LancamentoCentroCustoBean):779");
        }
        if (cc == null || cc.getConta() == null) {
            Funcoes.mensagem(this, "Centro de Custo n\u00e3o encontrado.", 2);
            return null;
        }
        if (!this.validaUltimoNivelCentroCusto(cc.getConta())) {
            Funcoes.mensagem(this, "Somente centros do \u00faltimo n\u00edvel podem ser adicionados!", 2);
            if (this.textCodigoCentroCusto.isFocusable()) {
                this.textCodigoCentroCusto.grabFocus();
            }
            return null;
        }
        Double valor = Double.valueOf(Funcoes.limpaDecimal(this.textValorCentro.getText()));
        if (valor <= 0.0) {
            Funcoes.mensagem(this, "Insira um valor MAIOR que zero.", 2);
            if (this.textValorCentro.isFocusable()) {
                this.textValorCentro.grabFocus();
            }
            return null;
        }
        bean.setFilial(filial);
        bean.setEstacao(estacao);
        bean.setCentroCusto(cc);
        bean.setOrigem(this.comboCentro.getSelectedIndex() >= 0 ? (OrigemVO)this.comboCentro.getSelectedItem() : null);
        bean.setValor(valor);
        return bean;
    }

    private ReceberPagarCentroCustoBean getBeanPreenchidoCentroCusto(ReceberPagarCentroCustoBean bean) {
        if (bean == null) {
            bean = new ReceberPagarCentroCustoBean();
        }
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(this.getFilial()));
        EstacaoVO estacao = new EstacaoVO();
        estacao.setCodigo(Integer.parseInt(Variaveis.codigoEstacao));
        CentroCustoVO cc = null;
        try {
            cc = (CentroCustoVO)this.centroCustoService.getVO(this.getFilial(), this.textCodigoCentroCusto.getText());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PanelPlanoContaCentroCusto:getBeanPreenchido(ReceberPagarCentroCustoBean):810");
        }
        if (cc != null && !this.validaUltimoNivelCentroCusto(cc.getConta())) {
            Funcoes.mensagem(this, "Somente centros do \u00faltimo n\u00edvel podem ser adicionados!", 2);
            if (this.textCodigoCentroCusto.isFocusable()) {
                this.textCodigoCentroCusto.grabFocus();
            }
            return null;
        }
        Double valor = Double.valueOf(Funcoes.limpaDecimal(this.textValorCentro.getText()));
        if (valor <= 0.0) {
            Funcoes.mensagem(this, "Insira um valor MAIOR que zero.", 2);
            if (this.textValorCentro.isFocusable()) {
                this.textValorCentro.grabFocus();
            }
            return null;
        }
        bean.setFilial(filial);
        bean.setCentroCusto(cc);
        bean.setOrigem(this.comboCentro.getSelectedIndex() >= 0 ? (OrigemVO)this.comboCentro.getSelectedItem() : null);
        bean.setValor(valor);
        return bean;
    }

    public void adicionarCentroCusto(AbstractThreadBean bean, boolean somarValor) {
        LancamentoCentroCustoBean lBean = null;
        ReceberPagarCentroCustoBean rBean = null;
        if (bean == null && Funcoes.textoVazio(this.textCodigoCentroCusto.getText())) {
            Funcoes.mensagem(this, "Insira o c\u00f3digo do Centro de Custo.", 2);
            if (this.textCodigoCentroCusto.isFocusable()) {
                this.textCodigoCentroCusto.grabFocus();
            }
            return;
        }
        if (bean == null && Funcoes.textoVazio(this.textValorCentro.getText())) {
            Funcoes.mensagem(this, "Insira o valor do Centro de Custo.", 2);
            if (this.textValorCentro.isFocusable()) {
                this.textValorCentro.grabFocus();
            }
            return;
        }
        if (this.centrosCusto == null) {
            this.centrosCusto = new ArrayList();
        }
        if (bean == null) {
            if (this.tipoTela == TIPO_LANCAMENTO) {
                bean = new LancamentoCentroCustoBean();
                lBean = (LancamentoCentroCustoBean)bean;
                bean = this.getBeanPreenchidoCentroCusto(lBean);
                lBean.setInserir(true);
            } else {
                bean = new ReceberPagarCentroCustoBean();
                rBean = (ReceberPagarCentroCustoBean)bean;
                bean = this.getBeanPreenchidoCentroCusto(rBean);
                rBean.setInserir(true);
            }
        } else if (this.tipoTela == TIPO_LANCAMENTO) {
            lBean = (LancamentoCentroCustoBean)bean;
        } else {
            rBean = (ReceberPagarCentroCustoBean)bean;
        }
        if (bean == null) {
            return;
        }
        Iterator<AbstractThreadBean> it = this.centrosCusto.iterator();
        boolean inserirBean = true;
        while (it.hasNext()) {
            AbstractThreadBean aux;
            if (this.tipoTela == TIPO_LANCAMENTO) {
                aux = (LancamentoCentroCustoBean)it.next();
                if (lBean == null || ((LancamentoCentroCustoBean)aux).getCentroCusto().getReduzido().intValue() != lBean.getCentroCusto().getReduzido().intValue() || !((LancamentoCentroCustoBean)aux).getOrigem().getCodigo().toString().equals(lBean.getOrigem().toString())) continue;
                if (!((LancamentoCentroCustoBean)aux).isRemover()) {
                    BigDecimal valor = new BigDecimal(lBean.getValor());
                    if (somarValor && !this.isAlterandoCentroCusto() && !this.isAlterandoPlanoConta()) {
                        BigDecimal somaValor = new BigDecimal(Double.valueOf(Funcoes.limpaDecimal(((LancamentoCentroCustoBean)aux).getValor())));
                        valor = valor.add(somaValor, new MathContext(valor.precision() >= somaValor.precision() ? valor.precision() + 1 : somaValor.precision() + 1, RoundingMode.HALF_UP));
                    }
                    if (!((LancamentoCentroCustoBean)aux).isInserir()) {
                        ((LancamentoCentroCustoBean)aux).setAlterar(true);
                    }
                    ((LancamentoCentroCustoBean)aux).setRemover(false);
                    ((LancamentoCentroCustoBean)aux).setValor(valor.doubleValue());
                    ((LancamentoCentroCustoBean)aux).setPlanoConta(lBean.getPlanoConta());
                } else {
                    ((LancamentoCentroCustoBean)aux).setRemover(false);
                    ((LancamentoCentroCustoBean)aux).setValor(lBean.getValor());
                }
                inserirBean = false;
                break;
            }
            if (this.tipoTela != TIPO_RECEBER_PAGAR) continue;
            aux = (ReceberPagarCentroCustoBean)it.next();
            if (rBean == null || ((ReceberPagarCentroCustoBean)aux).getCentroCusto().getReduzido().intValue() != rBean.getCentroCusto().getReduzido().intValue() || !((ReceberPagarCentroCustoBean)aux).getOrigem().getCodigo().toString().equals(rBean.getOrigem().toString())) continue;
            if (!((ReceberPagarCentroCustoBean)aux).isRemover()) {
                BigDecimal valor = new BigDecimal(rBean.getValor());
                if (somarValor && !this.isAlterandoCentroCusto() && !this.isAlterandoPlanoConta()) {
                    BigDecimal somaValor = new BigDecimal(Double.valueOf(Funcoes.limpaDecimal(((ReceberPagarCentroCustoBean)aux).getValor())));
                    valor = valor.add(somaValor, new MathContext(valor.precision() >= somaValor.precision() ? valor.precision() + 1 : somaValor.precision() + 1, RoundingMode.HALF_UP));
                }
                if (!((ReceberPagarCentroCustoBean)aux).isInserir()) {
                    ((ReceberPagarCentroCustoBean)aux).setAlterar(true);
                }
                ((ReceberPagarCentroCustoBean)aux).setRemover(false);
                ((ReceberPagarCentroCustoBean)aux).setValor(valor.doubleValue());
                ((ReceberPagarCentroCustoBean)aux).setPlanoConta(rBean.getPlanoConta());
            } else {
                ((ReceberPagarCentroCustoBean)aux).setRemover(false);
                ((ReceberPagarCentroCustoBean)aux).setValor(rBean.getValor());
            }
            inserirBean = false;
            break;
        }
        if (inserirBean) {
            if (this.tipoTela == TIPO_LANCAMENTO) {
                if (lBean != null) {
                    lBean.setInserir(true);
                    this.centrosCusto.add(lBean);
                }
            } else if (rBean != null) {
                rBean.setInserir(true);
                this.centrosCusto.add(rBean);
            }
        }
        this.limparCentroCusto();
        this.popularCentroCusto();
        this.textCodigoCentroCusto.setText("");
        this.textDescricaoCentroCusto.setText("");
        this.textValorCentro.setText("");
        this.comboCentro.setSelectedIndex(this.getIndiceOrigemPadrao(this.comboCentro));
    }

    public void popularCentroCusto() {
        if (this.bean == null) {
            return;
        }
        if (this.tipoDebitoCredito == null && this.bean != null) {
            this.tipoDebitoCredito = this.bean instanceof ReceberPagarBean ? (((ReceberPagarBean)this.bean).getTipo().equalsIgnoreCase("R") ? "C" : "D") : ((LancamentoBean)this.bean).getTipo();
        }
        double total = 0.0;
        for (AbstractThreadBean centro : this.centrosCusto) {
            if (this.tipoTela == TIPO_LANCAMENTO) {
                LancamentoCentroCustoBean lCentro = (LancamentoCentroCustoBean)centro;
                if (lCentro.isRemover()) continue;
                this.modelCentroCusto.addRow(new Object[]{lCentro.getCentroCusto().getReduzido().toString(), lCentro.getCentroCusto().getDescricao(), lCentro.getCentroCusto().getConta(), lCentro.getOrigem(), Funcoes.formataDecimal(lCentro.getValor()), lCentro});
                if (lCentro.getCentroCusto() != null && lCentro.getCentroCusto().getOperacao() != null && lCentro.getCentroCusto().getOperacao().equalsIgnoreCase("S")) {
                    if (this.tipoDebitoCredito.equalsIgnoreCase("C")) {
                        total -= lCentro.getValor().doubleValue();
                        continue;
                    }
                    total += lCentro.getValor().doubleValue();
                    continue;
                }
                if (this.tipoDebitoCredito.equalsIgnoreCase("C")) {
                    total += lCentro.getValor().doubleValue();
                    continue;
                }
                total -= lCentro.getValor().doubleValue();
                continue;
            }
            ReceberPagarCentroCustoBean rCentro = (ReceberPagarCentroCustoBean)centro;
            if (rCentro.isRemover() || rCentro.getCentroCusto() == null) continue;
            this.modelCentroCusto.addRow(new Object[]{rCentro.getCentroCusto().getReduzido().toString(), rCentro.getCentroCusto().getDescricao(), rCentro.getCentroCusto().getConta(), rCentro.getOrigem(), Funcoes.formataDecimal(rCentro.getValor()), rCentro});
            if (rCentro.getCentroCusto() != null && rCentro.getCentroCusto().getOperacao() != null && rCentro.getCentroCusto().getOperacao().equalsIgnoreCase("S")) {
                if (this.tipoDebitoCredito.equalsIgnoreCase("C")) {
                    total -= rCentro.getValor().doubleValue();
                    continue;
                }
                total += rCentro.getValor().doubleValue();
                continue;
            }
            if (this.tipoDebitoCredito.equalsIgnoreCase("C")) {
                total += rCentro.getValor().doubleValue();
                continue;
            }
            total -= rCentro.getValor().doubleValue();
        }
        this.labelValorTotalCentro.setText(Funcoes.formataDecimal(total));
    }

    private void limparCentroCusto() {
        while (this.modelCentroCusto.getRowCount() > 0) {
            this.modelCentroCusto.removeRow(0);
        }
    }

    private void setAlterarPlanoConta(boolean alterandoPlanoConta) {
        this.alterandoPlanoConta = alterandoPlanoConta;
    }

    private void setAlterarCentroCusto(boolean alterandoCentroCusto) {
        this.alterandoCentroCusto = alterandoCentroCusto;
    }

    private boolean isAlterandoPlanoConta() {
        return this.alterandoPlanoConta;
    }

    private boolean isAlterandoCentroCusto() {
        return this.alterandoCentroCusto;
    }

    public void alterarPlanoConta() {
        if (!this.somenteLeitura && Acesso.getAcesso(this.acessoAlterarPlanoContas) && this.tablePlanoConta.getSelectedRowCount() > 0) {
            int row = this.tablePlanoConta.getRowSorter().convertRowIndexToModel(this.tablePlanoConta.getSelectedRow());
            AbstractThreadBean plano = (AbstractThreadBean)this.modelPlanoConta.getValueAt(row, 5);
            if (this.tipoTela == TIPO_LANCAMENTO) {
                this.textCodigoPlanoConta.setText(Integer.toString(((LancamentoPlanoContaBean)plano).getPlanoConta().getReduzido()));
                this.textDescricaoPlanoConta.setText(((LancamentoPlanoContaBean)plano).getPlanoConta().getDescricao());
                this.comboPlano.setSelectedItem(((LancamentoPlanoContaBean)plano).getOrigem());
                this.textValorPlano.setText(Funcoes.formataDecimal("#,##0.00", ((LancamentoPlanoContaBean)plano).getValor()));
                this.textCodigoPlanoConta.setEnabled(false);
            } else {
                this.textCodigoPlanoConta.setText(Integer.toString(((ReceberPagarPlanoContaBean)plano).getPlanoConta().getReduzido()));
                this.textDescricaoPlanoConta.setText(((ReceberPagarPlanoContaBean)plano).getPlanoConta().getDescricao());
                this.comboPlano.setSelectedItem(((ReceberPagarPlanoContaBean)plano).getOrigem());
                this.textValorPlano.setText(Funcoes.formataDecimal("#,##0.00", ((ReceberPagarPlanoContaBean)plano).getValor()));
                this.textCodigoPlanoConta.setEnabled(false);
            }
            this.setAlterarPlanoConta(true);
        }
    }

    private void removerPlanoConta() {
        if (Acesso.getAcesso(this.acessoAlterarPlanoContas) && this.tablePlanoConta.getSelectedRowCount() > 0 && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            int row = this.tablePlanoConta.getRowSorter().convertRowIndexToModel(this.tablePlanoConta.getSelectedRow());
            AbstractThreadBean plano = (AbstractThreadBean)this.modelPlanoConta.getValueAt(row, 5);
            if (this.tipoTela == TIPO_LANCAMENTO) {
                ((LancamentoPlanoContaBean)plano).setRemover(true);
                if (this.centrosCusto != null && this.centrosCusto.size() > 0) {
                    for (AbstractThreadBean c : this.centrosCusto) {
                        if (((LancamentoCentroCustoBean)c).getPlanoConta() == null || ((LancamentoCentroCustoBean)c).getPlanoConta().getReduzido().intValue() != ((LancamentoPlanoContaBean)plano).getPlanoConta().getReduzido().intValue()) continue;
                        ((LancamentoCentroCustoBean)c).setRemover(true);
                    }
                }
            } else {
                ((ReceberPagarPlanoContaBean)plano).setRemover(true);
                if (this.centrosCusto != null && this.centrosCusto.size() > 0) {
                    for (AbstractThreadBean c : this.centrosCusto) {
                        if (((ReceberPagarCentroCustoBean)c).getPlanoConta() == null || ((ReceberPagarCentroCustoBean)c).getPlanoConta().getReduzido().intValue() != ((ReceberPagarPlanoContaBean)plano).getPlanoConta().getReduzido().intValue()) continue;
                        ((ReceberPagarCentroCustoBean)c).setRemover(true);
                    }
                }
            }
            this.limparPlanoConta();
            this.popularPlanoConta();
            this.limparCentroCusto();
            this.popularCentroCusto();
            this.setAlterarPlanoConta(false);
            this.controlaCampos(true);
            if (this.textCodigoPlanoConta.isFocusable()) {
                this.textCodigoPlanoConta.grabFocus();
            }
        }
    }

    private void buscaPlanoConta(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoPlanoConta.setText("");
            this.textDescricaoPlanoConta.setText("");
            return;
        }
        try {
            PlanoContaVO plano;
            if (this.tela != null) {
                this.bean = this.tela.buscaBeanPreenchido(this);
            }
            if ((plano = (PlanoContaVO)this.planoContaService.getVO(this.getFilial(), codigo)) != null) {
                this.textCodigoPlanoConta.setText(plano.getReduzido().toString());
                this.textDescricaoPlanoConta.setText(plano.getDescricao());
            } else {
                this.textDescricaoPlanoConta.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PanelPlanoContaCentroCusto:606");
        }
    }

    private void buscaPlanoConta() {
        try {
            PlanoContaVO plano;
            this.textCodigoPlanoConta.setText("");
            this.textDescricaoPlanoConta.setText("");
            if (this.tela != null) {
                this.bean = this.tela.buscaBeanPreenchido(this);
            }
            if ((plano = (PlanoContaVO)this.planoContaService.pesquisaVO(this.getTopLevelAncestor(), new PlanoContaVO(), "Pesquisando planos de contas", true, this.getFilial())) != null) {
                this.textCodigoPlanoConta.setText(plano.getReduzido().toString());
                this.textDescricaoPlanoConta.setText(plano.getDescricao());
            } else {
                this.textDescricaoPlanoConta.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PanelPlanoContaCentroCusto:626");
        }
        finally {
            if (this.textCodigoPlanoConta.isFocusable()) {
                this.textCodigoPlanoConta.grabFocus();
            }
        }
    }

    private boolean isDadosTelaOkPlanoConta() {
        return !Funcoes.textoVazio(this.textCodigoPlanoConta.getText()) && !Funcoes.textoVazio(this.textDescricaoPlanoConta.getText()) && !this.textDescricaoPlanoConta.getText().equalsIgnoreCase("N\u00e3o cadastrado") && !Funcoes.textoVazio(this.textValorPlano.getText());
    }

    private AbstractThreadBean getBeanPreenchidoPlanoConta(AbstractThreadBean bean) {
        if (!this.isDadosTelaOkPlanoConta()) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Todas as informa\u00e7\u00f5es sobre o plano de contas devem ser preenchidas.", 2);
            return null;
        }
        if (bean instanceof LancamentoPlanoContaBean) {
            return this.getBeanPreenchidoPlanoConta((LancamentoPlanoContaBean)bean);
        }
        if (bean instanceof ReceberPagarPlanoContaBean) {
            return this.getBeanPreenchidoPlanoConta((ReceberPagarPlanoContaBean)bean);
        }
        return null;
    }

    private LancamentoPlanoContaBean getBeanPreenchidoPlanoConta(LancamentoPlanoContaBean bean) {
        if (bean == null) {
            bean = new LancamentoPlanoContaBean();
        }
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(this.getFilial()));
        EstacaoVO estacao = null;
        if (((LancamentoBean)this.bean).getEstacao() != null) {
            estacao = ((LancamentoBean)this.bean).getEstacao();
        } else {
            estacao = new EstacaoVO();
            estacao.setCodigo(Integer.parseInt(Variaveis.codigoEstacao));
        }
        PlanoContaVO pc = null;
        try {
            pc = (PlanoContaVO)this.planoContaService.getVO(this.getFilial(), this.textCodigoPlanoConta.getText());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PanelPlanoContaCentroCusto:getBeanPreenchidoPlanoConta(LancamentoPlanoContaBean):779");
        }
        if (pc == null) {
            Funcoes.mensagem(this, "Plano de Contas n\u00e3o encontrado.", 2);
            return null;
        }
        if (!this.validaUltimoNivelPlanoConta(pc.getConta())) {
            Funcoes.mensagem(this, "Somente planos de contas do \u00faltimo n\u00edvel podem ser adicionados!", 2);
            if (this.textCodigoPlanoConta.isFocusable()) {
                this.textCodigoPlanoConta.grabFocus();
            }
            return null;
        }
        Double valor = Double.valueOf(Funcoes.limpaDecimal(this.textValorPlano.getText()));
        if (valor <= 0.0) {
            Funcoes.mensagem(this, "Insira um valor MAIOR que zero.", 2);
            if (this.textValorPlano.isFocusable()) {
                this.textValorPlano.grabFocus();
            }
            return null;
        }
        bean.setFilial(filial);
        bean.setEstacao(estacao);
        bean.setPlanoConta(pc);
        bean.setOrigem(this.comboPlano.getSelectedIndex() >= 0 ? (OrigemVO)this.comboPlano.getSelectedItem() : null);
        bean.setValor(valor);
        return bean;
    }

    private ReceberPagarPlanoContaBean getBeanPreenchidoPlanoConta(ReceberPagarPlanoContaBean bean) {
        if (bean == null) {
            bean = new ReceberPagarPlanoContaBean();
        }
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(this.getFilial()));
        EstacaoVO estacao = new EstacaoVO();
        estacao.setCodigo(Integer.parseInt(Variaveis.codigoEstacao));
        PlanoContaVO pc = null;
        try {
            pc = (PlanoContaVO)this.planoContaService.getVO(this.getFilial(), this.textCodigoPlanoConta.getText());
        }
        catch (Exception e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel encontrar o Plano de Contas selecionado.", 2);
            return null;
        }
        if (pc == null || pc.getConta() == null) {
            Funcoes.mensagem(this, "Plano de conta n\u00e3o encontrado.", 2);
            return null;
        }
        if (!this.validaUltimoNivelPlanoConta(pc.getConta())) {
            Funcoes.mensagem(this, "Somente planos de contas do \u00faltimo n\u00edvel podem ser adicionados!", 2);
            if (this.textCodigoPlanoConta.isFocusable()) {
                this.textCodigoPlanoConta.grabFocus();
            }
            return null;
        }
        Double valor = Double.valueOf(Funcoes.limpaDecimal(this.textValorPlano.getText()));
        if (valor <= 0.0) {
            Funcoes.mensagem(this, "Insira um valor MAIOR que zero.", 2);
            if (this.textValorPlano.isFocusable()) {
                this.textValorPlano.grabFocus();
            }
            return null;
        }
        bean.setFilial(filial);
        bean.setPlanoConta(pc);
        bean.setOrigem(this.comboPlano.getSelectedIndex() >= 0 ? (OrigemVO)this.comboPlano.getSelectedItem() : null);
        bean.setValor(valor);
        return bean;
    }

    public boolean haPlanoConta(int reduzidoPlanoConta, String origem) {
        if (this.planosContas != null) {
            for (AbstractThreadBean aux : this.planosContas) {
                ReceberPagarPlanoContaBean rBean;
                LancamentoPlanoContaBean lBean;
                if (!(aux instanceof LancamentoPlanoContaBean ? (lBean = (LancamentoPlanoContaBean)aux).getPlanoConta() != null && lBean.getOrigem() != null && lBean.getPlanoConta().getReduzido() != null && lBean.getOrigem().getCodigo() != null && lBean.getPlanoConta().getReduzido() == reduzidoPlanoConta && lBean.getOrigem().getCodigo().equalsIgnoreCase(origem) : (rBean = (ReceberPagarPlanoContaBean)aux).getPlanoConta() != null && rBean.getOrigem() != null && rBean.getPlanoConta().getReduzido() != null && rBean.getOrigem().getCodigo() != null && rBean.getPlanoConta().getReduzido() == reduzidoPlanoConta && rBean.getOrigem().getCodigo().equalsIgnoreCase(origem))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean haCentroCusto(int reduzidoCentroCusto, String origem) {
        if (this.centrosCusto != null) {
            for (AbstractThreadBean aux : this.centrosCusto) {
                ReceberPagarCentroCustoBean rBean;
                LancamentoCentroCustoBean lBean;
                if (!(aux instanceof LancamentoCentroCustoBean ? (lBean = (LancamentoCentroCustoBean)aux).getCentroCusto() != null && lBean.getOrigem() != null && lBean.getCentroCusto().getReduzido() != null && lBean.getOrigem().getCodigo() != null && lBean.getCentroCusto().getReduzido() == reduzidoCentroCusto && lBean.getOrigem().getCodigo().equalsIgnoreCase(origem) : (rBean = (ReceberPagarCentroCustoBean)aux).getCentroCusto() != null && rBean.getOrigem() != null && rBean.getCentroCusto().getReduzido() != null && rBean.getOrigem().getCodigo() != null && rBean.getCentroCusto().getReduzido() == reduzidoCentroCusto && rBean.getOrigem().getCodigo().equalsIgnoreCase(origem))) continue;
                return true;
            }
        }
        return false;
    }

    public void removerPlanoConta(int reduzidoPlanoConta, String origem) {
        if (this.planosContas != null) {
            for (AbstractThreadBean aux : this.planosContas) {
                if (aux instanceof LancamentoPlanoContaBean) {
                    LancamentoPlanoContaBean lBean = (LancamentoPlanoContaBean)aux;
                    if (lBean.getPlanoConta() == null || lBean.getOrigem() == null || lBean.getPlanoConta().getReduzido() == null || lBean.getOrigem().getCodigo() == null || lBean.getPlanoConta().getReduzido() != reduzidoPlanoConta || !lBean.getOrigem().getCodigo().equalsIgnoreCase(origem)) continue;
                    lBean.setRemover(true);
                    return;
                }
                ReceberPagarPlanoContaBean rBean = (ReceberPagarPlanoContaBean)aux;
                if (rBean.getPlanoConta() == null || rBean.getOrigem() == null || rBean.getPlanoConta().getReduzido() == null || rBean.getOrigem().getCodigo() == null || rBean.getPlanoConta().getReduzido() != reduzidoPlanoConta || !rBean.getOrigem().getCodigo().equalsIgnoreCase(origem)) continue;
                rBean.setRemover(true);
                return;
            }
        }
    }

    public void removerCentroCusto(int reduzidoCentroCusto, String origem, Double valor) {
        if (this.centrosCusto != null) {
            for (AbstractThreadBean aux : this.centrosCusto) {
                if (aux instanceof LancamentoCentroCustoBean) {
                    LancamentoCentroCustoBean lBean = (LancamentoCentroCustoBean)aux;
                    if (lBean.getCentroCusto() == null || lBean.getOrigem() == null || lBean.getCentroCusto().getReduzido() == null || lBean.getOrigem().getCodigo() == null || lBean.getCentroCusto().getReduzido() != reduzidoCentroCusto || !lBean.getOrigem().getCodigo().equalsIgnoreCase(origem)) continue;
                    if (lBean.getValor() - valor == 0.0 || valor == Double.MAX_VALUE) {
                        lBean.setRemover(true);
                    } else {
                        LancamentoCentroCustoBean beanAux = (LancamentoCentroCustoBean)lBean.clonar();
                        beanAux.setValor(valor * -1.0);
                        this.adicionarCentroCusto(beanAux, true);
                    }
                    return;
                }
                ReceberPagarCentroCustoBean rBean = (ReceberPagarCentroCustoBean)aux;
                if (rBean.getCentroCusto() == null || rBean.getOrigem() == null || rBean.getCentroCusto().getReduzido() == null || rBean.getOrigem().getCodigo() == null || rBean.getCentroCusto().getReduzido() != reduzidoCentroCusto || !rBean.getOrigem().getCodigo().equalsIgnoreCase(origem)) continue;
                if (rBean.getValor() - valor == 0.0 || valor == Double.MAX_VALUE) {
                    rBean.setRemover(true);
                } else {
                    ReceberPagarCentroCustoBean beanAux = (ReceberPagarCentroCustoBean)rBean.clonar();
                    beanAux.setValor(valor * -1.0);
                    this.adicionarCentroCusto(beanAux, true);
                }
                return;
            }
        }
    }

    public void adicionarPlanoConta(AbstractThreadBean bean, boolean gerarCentroCusto, boolean somarValor) {
        LancamentoPlanoContaBean lBean = null;
        ReceberPagarPlanoContaBean rBean = null;
        if (bean == null && Funcoes.textoVazio(this.textCodigoPlanoConta.getText())) {
            Funcoes.mensagem(this, "Insira o c\u00f3digo do Plano de Contas", 2);
            if (this.textCodigoPlanoConta.isFocusable()) {
                this.textCodigoPlanoConta.grabFocus();
            }
            return;
        }
        if (bean == null && Funcoes.textoVazio(this.textValorPlano.getText())) {
            Funcoes.mensagem(this, "Insira o valor do Plano de Contas", 2);
            if (this.textValorPlano.isFocusable()) {
                this.textValorPlano.grabFocus();
            }
            return;
        }
        if (this.planosContas == null) {
            this.planosContas = new ArrayList();
        }
        if (bean == null) {
            if (this.tipoTela == TIPO_LANCAMENTO) {
                bean = new LancamentoPlanoContaBean();
                lBean = (LancamentoPlanoContaBean)bean;
                bean = this.getBeanPreenchidoPlanoConta(lBean);
                lBean.setInserir(true);
            } else {
                bean = new ReceberPagarPlanoContaBean();
                rBean = (ReceberPagarPlanoContaBean)bean;
                bean = this.getBeanPreenchidoPlanoConta(rBean);
                rBean.setInserir(true);
            }
        } else if (this.tipoTela == TIPO_LANCAMENTO) {
            lBean = (LancamentoPlanoContaBean)bean;
        } else {
            rBean = (ReceberPagarPlanoContaBean)bean;
        }
        if (bean == null) {
            return;
        }
        Iterator<AbstractThreadBean> it = this.planosContas.iterator();
        boolean inserirBean = true;
        while (it.hasNext()) {
            AbstractThreadBean aux;
            if (this.tipoTela == TIPO_LANCAMENTO) {
                aux = (LancamentoPlanoContaBean)it.next();
                if (lBean == null || ((LancamentoPlanoContaBean)aux).getPlanoConta().getReduzido().intValue() != lBean.getPlanoConta().getReduzido().intValue() || !((LancamentoPlanoContaBean)aux).getOrigem().getCodigo().toString().equals(lBean.getOrigem().toString())) continue;
                if (!((LancamentoPlanoContaBean)aux).isRemover()) {
                    BigDecimal valor = new BigDecimal(lBean.getValor());
                    if (somarValor && !this.isAlterandoPlanoConta()) {
                        BigDecimal somaValor = new BigDecimal(Double.valueOf(Funcoes.limpaDecimal(((LancamentoPlanoContaBean)aux).getValor())));
                        valor = valor.add(somaValor, new MathContext(valor.precision() >= somaValor.precision() ? valor.precision() + 1 : somaValor.precision() + 1, RoundingMode.HALF_UP));
                    }
                    if (!((LancamentoPlanoContaBean)aux).isInserir()) {
                        ((LancamentoPlanoContaBean)aux).setAlterar(true);
                    }
                    ((LancamentoPlanoContaBean)aux).setRemover(false);
                    ((LancamentoPlanoContaBean)aux).setValor(valor.doubleValue());
                } else {
                    ((LancamentoPlanoContaBean)aux).setRemover(false);
                    ((LancamentoPlanoContaBean)aux).setValor(lBean.getValor());
                }
                inserirBean = false;
                break;
            }
            if (this.tipoTela != TIPO_RECEBER_PAGAR) continue;
            aux = (ReceberPagarPlanoContaBean)it.next();
            if (rBean == null || ((ReceberPagarPlanoContaBean)aux).getPlanoConta().getReduzido().intValue() != rBean.getPlanoConta().getReduzido().intValue() || !((ReceberPagarPlanoContaBean)aux).getOrigem().getCodigo().toString().equals(rBean.getOrigem().toString())) continue;
            if (!((ReceberPagarPlanoContaBean)aux).isRemover()) {
                BigDecimal valor = new BigDecimal(rBean.getValor());
                if (somarValor && !this.isAlterandoPlanoConta()) {
                    BigDecimal somaValor = new BigDecimal(Double.valueOf(Funcoes.limpaDecimal(((ReceberPagarPlanoContaBean)aux).getValor())));
                    valor = valor.add(somaValor, new MathContext(valor.precision() >= somaValor.precision() ? valor.precision() + 1 : somaValor.precision() + 1, RoundingMode.HALF_UP));
                }
                if (!((ReceberPagarPlanoContaBean)aux).isInserir()) {
                    ((ReceberPagarPlanoContaBean)aux).setAlterar(true);
                }
                ((ReceberPagarPlanoContaBean)aux).setRemover(false);
                ((ReceberPagarPlanoContaBean)aux).setValor(valor.doubleValue());
            } else {
                ((ReceberPagarPlanoContaBean)aux).setRemover(false);
                ((ReceberPagarPlanoContaBean)aux).setValor(rBean.getValor());
            }
            inserirBean = false;
            break;
        }
        if (inserirBean) {
            if (this.tipoTela == TIPO_LANCAMENTO) {
                this.planosContas.add(lBean);
            } else {
                this.planosContas.add(rBean);
            }
        }
        this.limparPlanoConta();
        this.popularPlanoConta();
        this.textCodigoPlanoConta.setText("");
        this.textDescricaoPlanoConta.setText("");
        this.textValorPlano.setText("");
        this.comboPlano.setSelectedIndex(this.getIndiceOrigemPadrao(this.comboPlano));
        if (gerarCentroCusto) {
            if (this.tipoTela == TIPO_LANCAMENTO) {
                this.gerarCentroCusto(lBean, somarValor);
            } else {
                this.gerarCentroCusto(rBean, somarValor);
            }
        }
    }

    private void gerarCentroCusto(AbstractThreadBean bean, boolean somarValor) {
        if (bean == null) {
            return;
        }
        class DadosCCustoPConta {
            private CentroCustoVO centroCusto;
            private double percentual;
            private double valorOriginal;
            private double valor;

            public DadosCCustoPConta(FilialVO filial, PlanoContaVO planoConta, CentroCustoVO centroCusto, double percentual, double valorOriginal) {
                this.centroCusto = centroCusto;
                this.percentual = percentual;
                this.valorOriginal = valorOriginal;
                this.calculaValor();
            }

            private void calculaValor() {
                BigDecimal valorOriginal = new BigDecimal(this.valorOriginal);
                BigDecimal percentual = new BigDecimal(this.percentual);
                percentual = percentual.divide(new BigDecimal(100), new MathContext(4, RoundingMode.HALF_UP));
                valorOriginal = valorOriginal.multiply(percentual, new MathContext(valorOriginal.precision() + 2, RoundingMode.HALF_UP));
                this.valor = valorOriginal.doubleValue();
            }

            public double getValor() {
                return this.valor;
            }

            public CentroCustoVO getCentroCusto() {
                return this.centroCusto;
            }
        }
        ArrayList<DadosCCustoPConta> dados = new ArrayList<DadosCCustoPConta>();
        HashSet setCCustoPConta = null;
        LancamentoPlanoContaBean lBean = null;
        ReceberPagarPlanoContaBean rBean = null;
        if (this.tipoTela == TIPO_LANCAMENTO) {
            lBean = (LancamentoPlanoContaBean)bean;
            setCCustoPConta = (HashSet)new CentroCustoPlanoContaService().getBean(lBean.getFilial().getCodigo().toString(), lBean.getPlanoConta().getReduzido().toString());
        } else if (this.tipoTela == TIPO_RECEBER_PAGAR) {
            rBean = (ReceberPagarPlanoContaBean)bean;
            setCCustoPConta = (HashSet)new CentroCustoPlanoContaService().getBean(rBean.getFilial().getCodigo().toString(), rBean.getPlanoConta().getReduzido().toString());
        }
        Iterator it = null;
        if (setCCustoPConta != null) {
            for (CentroCustoPlanoContaBean centroCustoPlanoContaBean : setCCustoPConta) {
                DadosCCustoPConta item = null;
                if (this.tipoTela == TIPO_LANCAMENTO) {
                    if (lBean != null) {
                        item = new DadosCCustoPConta(centroCustoPlanoContaBean.getFilial(), centroCustoPlanoContaBean.getPlanoConta(), centroCustoPlanoContaBean.getCentroCusto(), centroCustoPlanoContaBean.getPercentual(), lBean.getValor());
                    }
                } else if (this.tipoTela == TIPO_RECEBER_PAGAR && rBean != null) {
                    item = new DadosCCustoPConta(centroCustoPlanoContaBean.getFilial(), centroCustoPlanoContaBean.getPlanoConta(), centroCustoPlanoContaBean.getCentroCusto(), centroCustoPlanoContaBean.getPercentual(), rBean.getValor());
                }
                dados.add(item);
            }
        }
        for (DadosCCustoPConta dadosCCustoPConta : dados) {
            if (this.tipoTela == TIPO_LANCAMENTO) {
                LancamentoCentroCustoBean lCentro = new LancamentoCentroCustoBean();
                if (lBean != null) {
                    lCentro.setFilial(lBean.getFilial());
                    lCentro.setEstacao(lBean.getEstacao());
                    lCentro.setOrigem(lBean.getOrigem());
                    lCentro.setPlanoConta(lBean.getPlanoConta());
                }
                lCentro.setCentroCusto(dadosCCustoPConta.getCentroCusto());
                lCentro.setValor(dadosCCustoPConta.getValor());
                this.adicionarCentroCusto(lCentro, somarValor);
                continue;
            }
            if (this.tipoTela != TIPO_RECEBER_PAGAR) continue;
            ReceberPagarCentroCustoBean rCentro = new ReceberPagarCentroCustoBean();
            if (rBean != null) {
                rCentro.setFilial(rBean.getFilial());
                rCentro.setOrigem(rBean.getOrigem());
                rCentro.setPlanoConta(rBean.getPlanoConta());
            }
            rCentro.setCentroCusto(dadosCCustoPConta.getCentroCusto());
            rCentro.setValor(dadosCCustoPConta.getValor());
            this.adicionarCentroCusto(rCentro, somarValor);
        }
        this.tableCentroCusto.revalidate();
        this.tableCentroCusto.repaint();
    }

    public void popularPlanoConta() {
        if (this.bean == null) {
            return;
        }
        double total = 0.0;
        if (this.tipoDebitoCredito == null && this.bean != null) {
            this.tipoDebitoCredito = this.bean instanceof ReceberPagarBean ? (((ReceberPagarBean)this.bean).getTipo().equalsIgnoreCase("R") ? "C" : "D") : ((LancamentoBean)this.bean).getTipo();
        }
        if (this.tipoTela == TIPO_LANCAMENTO) {
            for (AbstractThreadBean pc : this.planosContas) {
                LancamentoPlanoContaBean plano = (LancamentoPlanoContaBean)pc;
                if (plano.isRemover()) continue;
                this.modelPlanoConta.addRow(new Object[]{Integer.toString(plano.getPlanoConta().getReduzido()), plano.getPlanoConta().getDescricao(), plano.getPlanoConta().getConta(), plano.getOrigem(), Funcoes.formataDecimal(plano.getValor()), plano});
                if (plano.getPlanoConta() != null && plano.getPlanoConta().getOperacao() != null && plano.getPlanoConta().getOperacao().equalsIgnoreCase("S")) {
                    if (this.tipoDebitoCredito.equalsIgnoreCase("C")) {
                        total -= plano.getValor().doubleValue();
                        continue;
                    }
                    total += plano.getValor().doubleValue();
                    continue;
                }
                if (this.tipoDebitoCredito.equalsIgnoreCase("C")) {
                    total += plano.getValor().doubleValue();
                    continue;
                }
                total -= plano.getValor().doubleValue();
            }
        } else {
            for (AbstractThreadBean pc : this.planosContas) {
                ReceberPagarPlanoContaBean plano = (ReceberPagarPlanoContaBean)pc;
                if (plano.isRemover()) continue;
                this.modelPlanoConta.addRow(new Object[]{Integer.toString(plano.getPlanoConta().getReduzido()), plano.getPlanoConta().getDescricao(), plano.getPlanoConta().getConta(), plano.getOrigem(), Funcoes.formataDecimal(plano.getValor()), plano});
                if (plano.getPlanoConta() != null && plano.getPlanoConta().getOperacao() != null && plano.getPlanoConta().getOperacao().equalsIgnoreCase("S")) {
                    if (this.tipoDebitoCredito.equalsIgnoreCase("C")) {
                        total -= plano.getValor().doubleValue();
                        continue;
                    }
                    total += plano.getValor().doubleValue();
                    continue;
                }
                if (this.tipoDebitoCredito.equalsIgnoreCase("C")) {
                    total += plano.getValor().doubleValue();
                    continue;
                }
                total -= plano.getValor().doubleValue();
            }
        }
        this.labelValorTotalPlano.setText(Funcoes.formataDecimal(total));
    }

    private void limparPlanoConta() {
        while (this.modelPlanoConta.getRowCount() > 0) {
            this.modelPlanoConta.removeRow(0);
        }
    }

    private boolean validaUltimoNivelPlanoConta(String conta) {
        int sM;
        int sP = conta.split("\\.").length;
        return sP == (sM = ParametrosGerais.getMascaraPlanoConta().split("\\.").length);
    }

    private boolean validaUltimoNivelCentroCusto(String conta) {
        int sM;
        int sP = conta.split("\\.").length;
        return sP == (sM = ParametrosGerais.getMascaraCentroCusto().split("\\.").length);
    }

    public void setBean(AbstractThreadBean bean) {
        this.bean = bean;
    }

    public void setService(AbstractThreadService service) {
        this.tService = service;
    }

    public void setSomenteLeitura(boolean somenteLeitura) {
        this.somenteLeitura = somenteLeitura;
    }

    public double buscaValorTituloPlano() {
        double valor = 0.0;
        if (this.bean == null || !Funcoes.textoVazio(this.textValorPlano.getText())) {
            Double valorInformado = Double.valueOf(Funcoes.limpaDecimal(this.textValorPlano.getText()));
            if (valorInformado > 0.0) {
                return valorInformado;
            }
            return 0.0;
        }
        this.bean = this.tela.buscaBeanPreenchido(this);
        if (this.bean instanceof ReceberPagarBean) {
            this.bean = FinanceiroUtil.atualizaTotalSemRecalculo((ReceberPagarBean)this.bean);
            valor = ((ReceberPagarBean)this.bean).getValorTotal();
        } else {
            this.bean = FinanceiroUtil.atualizaTotalSemRecalculo((LancamentoBean)this.bean);
            this.bean = FinanceiroUtil.atualizaTotal(this.bean);
            valor = ((LancamentoBean)this.bean).getValorTotal();
        }
        if (this.planosContas != null && this.planosContas.size() > 0) {
            for (AbstractThreadBean o : this.planosContas) {
                PlanoContaVO planoAux;
                if (this.tipoTela == TIPO_LANCAMENTO) {
                    LancamentoPlanoContaBean lanctoPlanoAux = (LancamentoPlanoContaBean)o;
                    if (lanctoPlanoAux.isRemover() || (planoAux = lanctoPlanoAux.getPlanoConta()) == null) continue;
                    if (planoAux.getOperacao().equalsIgnoreCase("A")) {
                        if (this.tipoDebitoCredito.equalsIgnoreCase("C")) {
                            valor -= ((LancamentoPlanoContaBean)o).getValor().doubleValue();
                            continue;
                        }
                        valor += ((LancamentoPlanoContaBean)o).getValor().doubleValue();
                        continue;
                    }
                    if (this.tipoDebitoCredito.equalsIgnoreCase("C")) {
                        valor += ((LancamentoPlanoContaBean)o).getValor().doubleValue();
                        continue;
                    }
                    valor -= ((LancamentoPlanoContaBean)o).getValor().doubleValue();
                    continue;
                }
                ReceberPagarPlanoContaBean recPagPlanoAux = (ReceberPagarPlanoContaBean)o;
                if (recPagPlanoAux.isRemover() || (planoAux = recPagPlanoAux.getPlanoConta()) == null) continue;
                if (planoAux.getOperacao().equalsIgnoreCase("A")) {
                    if (this.tipoDebitoCredito.equalsIgnoreCase("C")) {
                        valor -= ((ReceberPagarPlanoContaBean)o).getValor().doubleValue();
                        continue;
                    }
                    valor += ((ReceberPagarPlanoContaBean)o).getValor().doubleValue();
                    continue;
                }
                if (this.tipoDebitoCredito.equalsIgnoreCase("C")) {
                    valor += ((ReceberPagarPlanoContaBean)o).getValor().doubleValue();
                    continue;
                }
                valor -= ((ReceberPagarPlanoContaBean)o).getValor().doubleValue();
            }
        }
        if (valor < 0.0 && !Funcoes.textoVazio(this.textCodigoPlanoConta)) {
            PlanoContaVO plano = null;
            try {
                plano = (PlanoContaVO)new PlanoContaService().getVO(this.getFilial(), this.textCodigoPlanoConta.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (plano != null && plano.getOperacao() != null && plano.getOperacao().equalsIgnoreCase("S")) {
                valor *= -1.0;
            }
        }
        return valor;
    }

    public void buscaValorTituloCentro() {
        double valor = 0.0;
        if (this.bean == null || !Funcoes.textoVazio(this.textValorCentro.getText())) {
            return;
        }
        this.bean = this.tela.buscaBeanPreenchido(this);
        if (this.bean instanceof ReceberPagarBean) {
            this.bean = FinanceiroUtil.atualizaTotalSemRecalculo((ReceberPagarBean)this.bean);
            valor = ((ReceberPagarBean)this.bean).getValorTotal();
        } else {
            this.bean = FinanceiroUtil.atualizaValores(this.bean, this.dataBaixa == null ? GregorianCalendar.getInstance().getTime() : this.dataBaixa);
            this.bean = FinanceiroUtil.atualizaTotal(this.bean);
            valor = ((LancamentoBean)this.bean).getValorTotal();
        }
        if (this.centrosCusto != null && this.centrosCusto.size() > 0) {
            for (AbstractThreadBean o : this.centrosCusto) {
                CentroCustoVO centroAux;
                if (this.tipoTela == TIPO_LANCAMENTO) {
                    LancamentoCentroCustoBean lanctoCentroAux = (LancamentoCentroCustoBean)o;
                    if (lanctoCentroAux.isRemover() || (centroAux = lanctoCentroAux.getCentroCusto()) == null) continue;
                    if (centroAux.getOperacao().equalsIgnoreCase("A")) {
                        if (this.tipoDebitoCredito.equalsIgnoreCase("C")) {
                            valor -= ((LancamentoCentroCustoBean)o).getValor().doubleValue();
                            continue;
                        }
                        valor += ((LancamentoCentroCustoBean)o).getValor().doubleValue();
                        continue;
                    }
                    if (this.tipoDebitoCredito.equalsIgnoreCase("C")) {
                        valor += ((LancamentoCentroCustoBean)o).getValor().doubleValue();
                        continue;
                    }
                    valor -= ((LancamentoCentroCustoBean)o).getValor().doubleValue();
                    continue;
                }
                ReceberPagarCentroCustoBean recPagCentroAux = (ReceberPagarCentroCustoBean)o;
                if (recPagCentroAux.isRemover() || (centroAux = recPagCentroAux.getCentroCusto()) == null) continue;
                if (centroAux.getOperacao().equalsIgnoreCase("A")) {
                    if (this.tipoDebitoCredito.equalsIgnoreCase("C")) {
                        valor -= ((ReceberPagarCentroCustoBean)o).getValor().doubleValue();
                        continue;
                    }
                    valor += ((ReceberPagarCentroCustoBean)o).getValor().doubleValue();
                    continue;
                }
                if (this.tipoDebitoCredito.equalsIgnoreCase("C")) {
                    valor += ((ReceberPagarCentroCustoBean)o).getValor().doubleValue();
                    continue;
                }
                valor -= ((ReceberPagarCentroCustoBean)o).getValor().doubleValue();
            }
        }
        if (valor < 0.0 && !Funcoes.textoVazio(this.textCodigoCentroCusto)) {
            CentroCustoVO centro = null;
            try {
                centro = (CentroCustoVO)new CentroCustoService().getVO(this.getFilial(), this.textCodigoCentroCusto.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (centro != null && centro.getOperacao().equalsIgnoreCase("S")) {
                valor *= -1.0;
            }
        }
        this.carregarValorCentroCusto(valor);
    }

    public void focalizarPlanoContas() {
        if (this.textCodigoPlanoConta.isEnabled()) {
            ScreenUtil.requisitarFoco(this.textCodigoPlanoConta);
        }
    }

    public void focalizarCentroCusto() {
        if (this.textCodigoCentroCusto.isEnabled()) {
            ScreenUtil.requisitarFoco(this.textCodigoCentroCusto);
        }
    }

    public void setTituloPlanoContas(String titulo) {
        if (titulo == null) {
            this.panelPlanoConta.setBorder(null);
        } else {
            this.panelPlanoConta.setBorder(new TitledBorder(titulo));
        }
    }

    public void setTituloCentroCusto(String titulo) {
        if (titulo == null) {
            this.panelCentroCusto.setBorder(null);
        } else {
            this.panelCentroCusto.setBorder(new TitledBorder(titulo));
        }
    }

    public void setPainelPlanoContaVisivel(boolean isVisivel) {
        this.panelPlanoConta.setVisible(isVisivel);
    }

    public void setPainelCentroCustoVisivel(boolean isVisivel) {
        this.panelCentroCusto.setVisible(isVisivel);
    }

    public void setFilial(String filialDestino) {
        this.filialTransferencia = filialDestino;
    }
}

