/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos.componente;

import jalis.comum.Tipos;
import jalis.laboratorio.financeiro.faturamento.DialogComposicao;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.service.financeiro.NotaFiscalService;
import jalis.service.financeiro.ReceberPagarService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class AlterarTituloBaixa
extends JDialog {
    private JPanel pnlCentral = new JPanel(new GridBagLayout());
    private JPanel pnlBotoes = new JPanel(new FlowLayout(2));
    private JButton buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', null);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', null);
    private JLabel lblValor = new JLabel("Valor Bruto:");
    private TTextField textValor = new TTextField(10, 2, 2);
    private JLabel lblTaxa = new JLabel(" (+) Taxa:");
    private TTextField textTaxa = new TTextField(10, 2, 2);
    private JLabel lblValorMulta = new JLabel(" (+) Multa:");
    private JLabel lblPercentualMulta = new JLabel("%");
    private TTextField textValorMulta = new TTextField(10, 2, 2);
    private TTextField textPercentualMulta = new TTextField(8, 2, 4);
    private JCheckBox chkJuroMulta = new JCheckBox("Considerar no c\u00e1lculo do juros");
    private JLabel lblValorJuro = new JLabel(" (+) Juros:");
    private JLabel lblPercentualJuro = new JLabel("%");
    private TTextField textValorJuro = new TTextField(10, 2, 2);
    private TTextField textPercentualJuro = new TTextField(8, 2, 4);
    private JComboBox cbxTipoJuro = new JComboBox<String>(new String[]{Tipos.tipoJuros("V"), Tipos.tipoJuros("D"), Tipos.tipoJuros("M"), Tipos.tipoJuros("A")});
    private JLabel lblValorAcrescimo = new JLabel(" (+) Acr\u00e9scimo:");
    private JLabel lblPercentualAcrescimo = new JLabel("%");
    private TTextField textValorAcrescimo = new TTextField(10, 2, 2);
    private TTextField textPercentualAcrescimo = new TTextField(8, 2, 4);
    private JLabel lblValorDesconto = new JLabel(" (-) Desconto:");
    private JLabel lblPercentualDesconto = new JLabel("%");
    private TTextField textValorDesconto = new TTextField(10, 2, 2);
    private TTextField textPercentualDesconto = new TTextField(8, 2, 4);
    private JLabel lblValorTotal = new JLabel("Valor L\u00edquido:");
    private JLabel lblVlrValorTotal = new JLabel("");
    private ReceberPagarBean titulo = null;
    private ReceberPagarService service = null;
    private Date dataConciliacao = null;
    private JPanel pnlImpostos = new JPanel(new GridBagLayout());
    private JPanel pnlImpostosRetidos = new JPanel(new GridBagLayout());
    private JPanel panelComposicao = new JPanel(new GridBagLayout());
    private JLabel labelComposicao = new JLabel("Valor:");
    private JLabel labelComposicao2 = new JLabel("");
    private JLabel labelVlrComposicao = new JLabel();
    private JLabel labelMostraComposicao = new JLabel("[Composi\u00e7\u00e3o]");
    private JLabel lblValorIrrf = new JLabel("IRRF:");
    private JLabel lblPercentualIrrf = new JLabel("%");
    private TTextField textValorIrrf = new TTextField(10, 2, 2);
    private TTextField textPercentualIrrf = new TTextField(8, 2, 4);
    private JLabel lblValorIss = new JLabel("ISS:");
    private JLabel lblPercentualIss = new JLabel("%");
    private TTextField textValorIss = new TTextField(10, 2, 2);
    private TTextField textPercentualIss = new TTextField(8, 2, 4);
    private JLabel lblValorIssRetido = new JLabel("ISS:");
    private JLabel lblPercentualIssRetido = new JLabel("%");
    private TTextField textValorIssRetido = new TTextField(10, 2, 2);
    private TTextField textPercentualIssRetido = new TTextField(8, 2, 4);
    private JLabel lblValorInssRetido = new JLabel("INSS:");
    private JLabel lblPercentualInssRetido = new JLabel("%");
    private TTextField textValorInssRetido = new TTextField(10, 2, 2);
    private TTextField textPercentualInssRetido = new TTextField(8, 2, 4);
    private JLabel lblValorCofinsRetido = new JLabel("COFINS:");
    private JLabel lblPercentualCofinsRetido = new JLabel("%");
    private TTextField textValorCofinsRetido = new TTextField(10, 2, 2);
    private TTextField textPercentualCofinsRetido = new TTextField(8, 2, 4);
    private JLabel lblValorCsllRetido = new JLabel("CSLL:");
    private JLabel lblPercentualCsllRetido = new JLabel("%");
    private TTextField textValorCsllRetido = new TTextField(10, 2, 2);
    private TTextField textPercentualCsllRetido = new TTextField(8, 2, 4);
    private JLabel lblValorIrrfRetido = new JLabel("IRRF:");
    private JLabel lblPercentualIrrfRetido = new JLabel("%");
    private TTextField textValorIrrfRetido = new TTextField(10, 2, 2);
    private TTextField textPercentualIrrfRetido = new TTextField(8, 2, 4);
    private JLabel lblValorPisRetido = new JLabel("PIS:");
    private JLabel lblPercentualPisRetido = new JLabel("%");
    private TTextField textValorPisRetido = new TTextField(10, 2, 2);
    private TTextField textPercentualPisRetido = new TTextField(8, 2, 4);
    private JLabel lblValorPis = new JLabel("PIS:");
    private JLabel lblPercentualPis = new JLabel("%");
    private TTextField textValorPis = new TTextField(10, 2, 2);
    private TTextField textPercentualPis = new TTextField(8, 2, 4);
    private JLabel lblValorCsll = new JLabel("CSLL:");
    private JLabel lblPercentualCsll = new JLabel("%");
    private TTextField textValorCsll = new TTextField(10, 2, 2);
    private TTextField textPercentualCsll = new TTextField(8, 2, 4);
    private JLabel lblValorCofins = new JLabel("COFINS:");
    private JLabel lblPercentualCofins = new JLabel("%");
    private TTextField textValorCofins = new TTextField(10, 2, 2);
    private TTextField textPercentualCofins = new TTextField(8, 2, 4);
    private JLabel lblValorInss = new JLabel("INSS:");
    private JLabel lblPercentualInss = new JLabel("%");
    private TTextField textValorInss = new TTextField(10, 2, 2);
    private TTextField textPercentualInss = new TTextField(8, 2, 4);
    private JLabel lblValorTotalSemImp = new JLabel("Valor Parcial:");
    private JLabel lblVlrValorTotalSemImp = new JLabel("");

    public AlterarTituloBaixa(JFrame owner) {
        super(owner);
        this.setTitle("Alterar dados do t\u00edtulo");
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(500, 480));
        this.setLocationRelativeTo(owner);
        this.setResizable(false);
        ScreenUtil.setBorda(new Component[]{this.lblVlrValorTotal, this.lblVlrValorTotalSemImp, this.labelVlrComposicao}, new TitledBorder(""));
        Dimension d = null;
        KeyAdapter listenerKey = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 9) {
                    return;
                }
                AlterarTituloBaixa.this.recalculaValores();
                if (e.getSource() == AlterarTituloBaixa.this.textValorMulta || e.getSource() == AlterarTituloBaixa.this.textValorDesconto || e.getSource() == AlterarTituloBaixa.this.textValorAcrescimo) {
                    AlterarTituloBaixa.this.calculaPercentual();
                } else if (e.getSource() == AlterarTituloBaixa.this.textValorJuro) {
                    AlterarTituloBaixa.this.calculaPercentualJuro();
                } else if (e.getSource() == AlterarTituloBaixa.this.textPercentualMulta) {
                    AlterarTituloBaixa.this.calcularValorMulta();
                    AlterarTituloBaixa.this.calcularValorJuros();
                } else if (e.getSource() == AlterarTituloBaixa.this.textPercentualJuro) {
                    AlterarTituloBaixa.this.calcularValorJuros();
                } else if (e.getSource() == AlterarTituloBaixa.this.textPercentualAcrescimo) {
                    AlterarTituloBaixa.this.calculaValorAcrescimo();
                } else if (e.getSource() == AlterarTituloBaixa.this.textPercentualDesconto) {
                    AlterarTituloBaixa.this.calculaValorDesconto();
                }
                AlterarTituloBaixa.this.recalculaTotal();
            }
        };
        FocusAdapter listenerFocus = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getSource() instanceof TTextField) {
                    ((TTextField)e.getSource()).selectAll();
                }
            }
        };
        KeyAdapter listernerKeyValorImpostos = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 9) {
                    return;
                }
                AlterarTituloBaixa.this.calculaPercentualImposto();
                AlterarTituloBaixa.this.recalculaTotal();
            }
        };
        KeyAdapter listenerKeyPercImpostos = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 9) {
                    return;
                }
                AlterarTituloBaixa.this.calculaValorImposto();
                AlterarTituloBaixa.this.recalculaTotal();
            }
        };
        d = new Dimension(85, 20);
        this.textValor.setPreferredSize(d);
        this.textValor.setMinimumSize(d);
        this.textValor.addKeyListener(listenerKey);
        this.textValor.addFocusListener(listenerFocus);
        this.textTaxa.setPreferredSize(d);
        this.textTaxa.setMinimumSize(d);
        this.textTaxa.addKeyListener(listenerKey);
        this.textTaxa.addFocusListener(listenerFocus);
        this.textValorMulta.setPreferredSize(d);
        this.textValorMulta.setMinimumSize(d);
        this.textValorMulta.addKeyListener(listenerKey);
        this.textValorMulta.addFocusListener(listenerFocus);
        this.textValorJuro.setPreferredSize(d);
        this.textValorJuro.setMinimumSize(d);
        this.textValorJuro.addKeyListener(listenerKey);
        this.textValorJuro.addFocusListener(listenerFocus);
        this.textValorDesconto.setPreferredSize(d);
        this.textValorDesconto.setMinimumSize(d);
        this.textValorDesconto.addKeyListener(listenerKey);
        this.textValorDesconto.addFocusListener(listenerFocus);
        this.textValorAcrescimo.setPreferredSize(d);
        this.textValorAcrescimo.setMinimumSize(d);
        this.textValorAcrescimo.addKeyListener(listenerKey);
        this.textValorAcrescimo.addFocusListener(listenerFocus);
        this.lblVlrValorTotal.setPreferredSize(d);
        this.lblVlrValorTotal.setMinimumSize(d);
        this.lblVlrValorTotal.setHorizontalAlignment(4);
        this.lblVlrValorTotalSemImp.setPreferredSize(d);
        this.lblVlrValorTotalSemImp.setMinimumSize(d);
        this.lblVlrValorTotalSemImp.setHorizontalAlignment(4);
        this.textValorIrrf.setPreferredSize(d);
        this.textValorIrrf.setMinimumSize(d);
        this.textValorIrrf.addKeyListener(listernerKeyValorImpostos);
        this.textValorIrrf.addFocusListener(listenerFocus);
        this.textValorIss.setPreferredSize(d);
        this.textValorIss.setMinimumSize(d);
        this.textValorIss.addKeyListener(listernerKeyValorImpostos);
        this.textValorIss.addFocusListener(listenerFocus);
        this.textValorIssRetido.setPreferredSize(d);
        this.textValorIssRetido.setMinimumSize(d);
        this.textValorIssRetido.addKeyListener(listernerKeyValorImpostos);
        this.textValorIssRetido.addFocusListener(listenerFocus);
        this.textValorInssRetido.setPreferredSize(d);
        this.textValorInssRetido.setMinimumSize(d);
        this.textValorInssRetido.addKeyListener(listernerKeyValorImpostos);
        this.textValorInssRetido.addFocusListener(listenerFocus);
        this.textValorCofinsRetido.setPreferredSize(d);
        this.textValorCofinsRetido.setMinimumSize(d);
        this.textValorCofinsRetido.addKeyListener(listernerKeyValorImpostos);
        this.textValorCofinsRetido.addFocusListener(listenerFocus);
        this.textValorCsllRetido.setPreferredSize(d);
        this.textValorCsllRetido.setMinimumSize(d);
        this.textValorCsllRetido.addKeyListener(listernerKeyValorImpostos);
        this.textValorCsllRetido.addFocusListener(listenerFocus);
        this.textValorIrrfRetido.setPreferredSize(d);
        this.textValorIrrfRetido.setMinimumSize(d);
        this.textValorIrrfRetido.addKeyListener(listernerKeyValorImpostos);
        this.textValorIrrfRetido.addFocusListener(listenerFocus);
        this.textValorPisRetido.setPreferredSize(d);
        this.textValorPisRetido.setMinimumSize(d);
        this.textValorPisRetido.addKeyListener(listernerKeyValorImpostos);
        this.textValorPisRetido.addFocusListener(listenerFocus);
        this.textValorPis.setPreferredSize(d);
        this.textValorPis.setMinimumSize(d);
        this.textValorPis.addKeyListener(listernerKeyValorImpostos);
        this.textValorPis.addFocusListener(listenerFocus);
        this.textValorCsll.setPreferredSize(d);
        this.textValorCsll.setMinimumSize(d);
        this.textValorCsll.addKeyListener(listernerKeyValorImpostos);
        this.textValorCsll.addFocusListener(listenerFocus);
        this.textValorCofins.setPreferredSize(d);
        this.textValorCofins.setMinimumSize(d);
        this.textValorCofins.addKeyListener(listernerKeyValorImpostos);
        this.textValorCofins.addFocusListener(listenerFocus);
        this.textValorInss.setPreferredSize(d);
        this.textValorInss.setMinimumSize(d);
        this.textValorInss.addKeyListener(listernerKeyValorImpostos);
        this.textValorInss.addFocusListener(listenerFocus);
        this.labelVlrComposicao.setPreferredSize(d);
        this.labelVlrComposicao.setMinimumSize(d);
        d = new Dimension(65, 20);
        this.textPercentualMulta.setPreferredSize(d);
        this.textPercentualMulta.setMinimumSize(d);
        this.textPercentualMulta.addKeyListener(listenerKey);
        this.textPercentualMulta.addFocusListener(listenerFocus);
        this.textPercentualJuro.setPreferredSize(d);
        this.textPercentualJuro.setMinimumSize(d);
        this.textPercentualJuro.addKeyListener(listenerKey);
        this.textPercentualJuro.addFocusListener(listenerFocus);
        this.textPercentualDesconto.setPreferredSize(d);
        this.textPercentualDesconto.setMinimumSize(d);
        this.textPercentualDesconto.addKeyListener(listenerKey);
        this.textPercentualDesconto.addFocusListener(listenerFocus);
        this.textPercentualAcrescimo.setPreferredSize(d);
        this.textPercentualAcrescimo.setMinimumSize(d);
        this.textPercentualAcrescimo.addKeyListener(listenerKey);
        this.textPercentualAcrescimo.addFocusListener(listenerFocus);
        this.textPercentualIrrf.setPreferredSize(d);
        this.textPercentualIrrf.setMinimumSize(d);
        this.textPercentualIrrf.addKeyListener(listenerKeyPercImpostos);
        this.textPercentualIrrf.addFocusListener(listenerFocus);
        this.textPercentualIss.setPreferredSize(d);
        this.textPercentualIss.setMinimumSize(d);
        this.textPercentualIss.addKeyListener(listenerKeyPercImpostos);
        this.textPercentualIss.addFocusListener(listenerFocus);
        this.textPercentualIssRetido.setPreferredSize(d);
        this.textPercentualIssRetido.setMinimumSize(d);
        this.textPercentualIssRetido.addKeyListener(listenerKeyPercImpostos);
        this.textPercentualIssRetido.addFocusListener(listenerFocus);
        this.textPercentualInssRetido.setPreferredSize(d);
        this.textPercentualInssRetido.setMinimumSize(d);
        this.textPercentualInssRetido.addKeyListener(listenerKeyPercImpostos);
        this.textPercentualInssRetido.addFocusListener(listenerFocus);
        this.textPercentualCofinsRetido.setPreferredSize(d);
        this.textPercentualCofinsRetido.setMinimumSize(d);
        this.textPercentualCofinsRetido.addKeyListener(listenerKeyPercImpostos);
        this.textPercentualCofinsRetido.addFocusListener(listenerFocus);
        this.textPercentualCsllRetido.setPreferredSize(d);
        this.textPercentualCsllRetido.setMinimumSize(d);
        this.textPercentualCsllRetido.addKeyListener(listenerKeyPercImpostos);
        this.textPercentualCsllRetido.addFocusListener(listenerFocus);
        this.textPercentualIrrfRetido.setPreferredSize(d);
        this.textPercentualIrrfRetido.setMinimumSize(d);
        this.textPercentualIrrfRetido.addKeyListener(listenerKeyPercImpostos);
        this.textPercentualIrrfRetido.addFocusListener(listenerFocus);
        this.textPercentualPisRetido.setPreferredSize(d);
        this.textPercentualPisRetido.setMinimumSize(d);
        this.textPercentualPisRetido.addKeyListener(listenerKeyPercImpostos);
        this.textPercentualPisRetido.addFocusListener(listenerFocus);
        this.textPercentualPis.setPreferredSize(d);
        this.textPercentualPis.setMinimumSize(d);
        this.textPercentualPis.addKeyListener(listenerKeyPercImpostos);
        this.textPercentualPis.addFocusListener(listenerFocus);
        this.textPercentualCsll.setPreferredSize(d);
        this.textPercentualCsll.setMinimumSize(d);
        this.textPercentualCsll.addKeyListener(listenerKeyPercImpostos);
        this.textPercentualCsll.addFocusListener(listenerFocus);
        this.textPercentualCofins.setPreferredSize(d);
        this.textPercentualCofins.setMinimumSize(d);
        this.textPercentualCofins.addKeyListener(listenerKeyPercImpostos);
        this.textPercentualCofins.addFocusListener(listenerFocus);
        this.textPercentualInss.setPreferredSize(d);
        this.textPercentualInss.setMinimumSize(d);
        this.textPercentualInss.addKeyListener(listenerKeyPercImpostos);
        this.textPercentualInss.addFocusListener(listenerFocus);
        d = new Dimension(80, 20);
        this.cbxTipoJuro.setPreferredSize(d);
        this.cbxTipoJuro.setMinimumSize(d);
        this.cbxTipoJuro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AlterarTituloBaixa.this.cbxTipoJuro.getSelectedItem().equals(Tipos.tipoJuros("A"))) {
                    AlterarTituloBaixa.this.titulo.setTipoJuro("A");
                } else if (AlterarTituloBaixa.this.cbxTipoJuro.getSelectedItem().equals(Tipos.tipoJuros("M"))) {
                    AlterarTituloBaixa.this.titulo.setTipoJuro("M");
                } else if (AlterarTituloBaixa.this.cbxTipoJuro.getSelectedItem().equals(Tipos.tipoJuros("D"))) {
                    AlterarTituloBaixa.this.titulo.setTipoJuro("D");
                } else if (AlterarTituloBaixa.this.cbxTipoJuro.getSelectedItem().equals(Tipos.tipoJuros("V"))) {
                    AlterarTituloBaixa.this.titulo.setTipoJuro("V");
                }
            }
        });
        this.cbxTipoJuro.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AlterarTituloBaixa.this.calcularValorJuros();
                AlterarTituloBaixa.this.recalculaTotal();
            }
        });
        this.chkJuroMulta.setFont(this.chkJuroMulta.getFont().deriveFont(11.0f));
        this.chkJuroMulta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlterarTituloBaixa.this.calcularValorJuros();
                AlterarTituloBaixa.this.recalculaTotal();
            }
        });
        this.labelMostraComposicao.setForeground(Color.RED);
        this.labelMostraComposicao.setCursor(new Cursor(12));
        this.labelMostraComposicao.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AlterarTituloBaixa.this.titulo != null && AlterarTituloBaixa.this.titulo.getNotaFiscal() != null) {
                    NotaFiscalBean beanNota = null;
                    try {
                        beanNota = (NotaFiscalBean)new NotaFiscalService().get(AlterarTituloBaixa.this.titulo.getFilial().getCodigo().toString(), AlterarTituloBaixa.this.titulo.getNotaFiscal().getCodigo().toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    DialogComposicao.invocaTela(AlterarTituloBaixa.this, beanNota);
                }
            }
        });
        this.pnlImpostos.setBorder(ComponenteFactory.novoTitledEtchedBorder("Impostos"));
        this.pnlImpostosRetidos.setBorder(ComponenteFactory.novoTitledEtchedBorder("Impostos retidos"));
        this.panelComposicao.setBorder(ComponenteFactory.novoTitledEtchedBorder("Valor base de impostos"));
        this.add((Component)this.pnlCentral, "Center");
        this.add((Component)this.pnlBotoes, "South");
        this.buttonSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlterarTituloBaixa.this.salvar();
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlterarTituloBaixa.this.cancelar();
            }
        });
        this.labelVlrComposicao.setHorizontalAlignment(4);
        this.pnlBotoes.add(this.buttonSalvar);
        this.pnlBotoes.add(this.buttonCancelar);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.gridwidth = 1;
        this.panelComposicao.add((Component)this.labelComposicao, c);
        ++c.gridx;
        this.panelComposicao.add((Component)this.labelVlrComposicao, c);
        ++c.gridx;
        this.panelComposicao.add((Component)this.labelMostraComposicao, c);
        c.weightx = 5.0;
        ++c.gridx;
        this.panelComposicao.add((Component)this.labelComposicao2, c);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.gridwidth = 1;
        this.pnlCentral.add((Component)this.lblValor, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.pnlCentral.add((Component)this.textValor, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        JPanel aux2 = new JPanel();
        d = new Dimension(20, 10);
        aux2.setPreferredSize(d);
        this.pnlCentral.add((Component)aux2, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 14;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.pnlCentral.add((Component)this.panelComposicao, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 2.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.fill = 13;
        this.pnlCentral.add((Component)this.pnlImpostos, c);
        c.gridx = 7;
        c.gridwidth = 7;
        c.fill = 2;
        this.pnlCentral.add((Component)this.pnlImpostosRetidos, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 0;
        c.fill = 17;
        this.pnlCentral.add((Component)this.lblValorTotalSemImp, c);
        ++c.gridx;
        this.pnlCentral.add((Component)this.lblVlrValorTotalSemImp, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 0;
        c.fill = 0;
        this.pnlCentral.add((Component)this.lblTaxa, c);
        ++c.gridx;
        this.pnlCentral.add((Component)this.textTaxa, c);
        ++c.gridy;
        c.gridx = 0;
        this.pnlCentral.add((Component)this.lblValorMulta, c);
        c.gridx = 1;
        this.pnlCentral.add((Component)this.textValorMulta, c);
        c.gridx = 2;
        c.gridwidth = 3;
        this.pnlCentral.add((Component)this.textPercentualMulta, c);
        c.gridx = 5;
        this.pnlCentral.add((Component)this.lblPercentualMulta, c);
        c.gridx = 8;
        c.gridwidth = 0;
        this.pnlCentral.add((Component)this.chkJuroMulta, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.pnlCentral.add((Component)this.lblValorJuro, c);
        ++c.gridx;
        this.pnlCentral.add((Component)this.textValorJuro, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.pnlCentral.add((Component)this.textPercentualJuro, c);
        c.gridx = 5;
        this.pnlCentral.add((Component)this.lblPercentualJuro, c);
        c.gridx = 8;
        c.gridwidth = 2;
        this.pnlCentral.add((Component)this.cbxTipoJuro, c);
        c.gridwidth = 0;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.pnlCentral.add((Component)this.lblValorAcrescimo, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.pnlCentral.add((Component)this.textValorAcrescimo, c);
        ++c.gridx;
        c.gridwidth = 0;
        this.pnlCentral.add((Component)this.textPercentualAcrescimo, c);
        ++c.gridx;
        this.pnlCentral.add((Component)this.lblPercentualAcrescimo, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.pnlCentral.add((Component)this.lblValorDesconto, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.pnlCentral.add((Component)this.textValorDesconto, c);
        ++c.gridx;
        c.gridwidth = 1;
        this.pnlCentral.add((Component)this.textPercentualDesconto, c);
        ++c.gridx;
        c.gridwidth = 0;
        this.pnlCentral.add((Component)this.lblPercentualDesconto, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        JPanel aux3 = new JPanel();
        d = new Dimension(20, 5);
        aux3.setPreferredSize(d);
        this.pnlCentral.add((Component)aux3, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        this.pnlCentral.add((Component)this.lblValorTotal, c);
        ++c.gridx;
        c.gridwidth = 1;
        this.pnlCentral.add((Component)this.lblVlrValorTotal, c);
        c.gridx = 0;
        c.gridwidth = 1;
        ++c.gridy;
        this.pnlImpostos.add((Component)this.lblValorIrrf, c);
        ++c.gridx;
        this.pnlImpostos.add((Component)this.textValorIrrf, c);
        ++c.gridx;
        this.pnlImpostos.add((Component)this.textPercentualIrrf, c);
        ++c.gridx;
        this.pnlImpostos.add((Component)this.lblPercentualIrrf, c);
        ++c.gridx;
        JLabel lll = new JLabel("   ");
        this.pnlImpostos.add((Component)lll, c);
        --c.gridx;
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 0;
        c1.gridy = 0;
        c1.anchor = 17;
        c1.insets = new Insets(1, 1, 1, 1);
        c1.weightx = 0.0;
        c1.weighty = 0.0;
        c1.fill = 0;
        c1.gridwidth = 1;
        ++c.gridy;
        c.gridwidth = 1;
        c.gridx += 2;
        this.pnlImpostosRetidos.add((Component)this.lblValorIrrfRetido, c);
        ++c.gridx;
        this.pnlImpostosRetidos.add((Component)this.textValorIrrfRetido, c);
        ++c.gridx;
        this.pnlImpostosRetidos.add((Component)this.textPercentualIrrfRetido, c);
        ++c.gridx;
        this.pnlImpostosRetidos.add((Component)this.lblPercentualIrrfRetido, c);
        c.gridx = 0;
        ++c.gridy;
        this.pnlImpostos.add((Component)this.lblValorIss, c);
        ++c.gridx;
        this.pnlImpostos.add((Component)this.textValorIss, c);
        ++c.gridx;
        this.pnlImpostos.add((Component)this.textPercentualIss, c);
        ++c.gridx;
        this.pnlImpostos.add((Component)this.lblPercentualIss, c);
        c.gridx += 2;
        this.lblValorIssRetido.setToolTipText("ISS Retido");
        this.pnlImpostosRetidos.add((Component)this.lblValorIssRetido, c);
        ++c.gridx;
        this.pnlImpostosRetidos.add((Component)this.textValorIssRetido, c);
        ++c.gridx;
        this.pnlImpostosRetidos.add((Component)this.textPercentualIssRetido, c);
        ++c.gridx;
        this.pnlImpostosRetidos.add((Component)this.lblPercentualIssRetido, c);
        c.gridx = 0;
        ++c.gridy;
        this.pnlImpostos.add((Component)this.lblValorPis, c);
        ++c.gridx;
        this.pnlImpostos.add((Component)this.textValorPis, c);
        ++c.gridx;
        this.pnlImpostos.add((Component)this.textPercentualPis, c);
        ++c.gridx;
        this.pnlImpostos.add((Component)this.lblPercentualPis, c);
        c.gridx += 2;
        this.lblValorPisRetido.setToolTipText("PIS Retido");
        this.pnlImpostosRetidos.add((Component)this.lblValorPisRetido, c);
        ++c.gridx;
        this.pnlImpostosRetidos.add((Component)this.textValorPisRetido, c);
        ++c.gridx;
        this.pnlImpostosRetidos.add((Component)this.textPercentualPisRetido, c);
        ++c.gridx;
        this.pnlImpostosRetidos.add((Component)this.lblPercentualPisRetido, c);
        ++c.gridy;
        c.gridx = 0;
        this.pnlImpostos.add((Component)this.lblValorCsll, c);
        ++c.gridx;
        this.pnlImpostos.add((Component)this.textValorCsll, c);
        ++c.gridx;
        this.pnlImpostos.add((Component)this.textPercentualCsll, c);
        ++c.gridx;
        this.pnlImpostos.add((Component)this.lblPercentualCsll, c);
        c.gridx += 2;
        this.lblValorCsllRetido.setToolTipText("Csll Retido");
        this.pnlImpostosRetidos.add((Component)this.lblValorCsllRetido, c);
        ++c.gridx;
        this.pnlImpostosRetidos.add((Component)this.textValorCsllRetido, c);
        ++c.gridx;
        this.pnlImpostosRetidos.add((Component)this.textPercentualCsllRetido, c);
        ++c.gridx;
        this.pnlImpostosRetidos.add((Component)this.lblPercentualCsllRetido, c);
        c.gridx = 0;
        ++c.gridy;
        this.pnlImpostos.add((Component)this.lblValorCofins, c);
        ++c.gridx;
        this.pnlImpostos.add((Component)this.textValorCofins, c);
        ++c.gridx;
        this.pnlImpostos.add((Component)this.textPercentualCofins, c);
        ++c.gridx;
        this.pnlImpostos.add((Component)this.lblPercentualCofins, c);
        c.gridx += 2;
        this.lblValorCofinsRetido.setToolTipText("Cofins Retido");
        this.pnlImpostosRetidos.add((Component)this.lblValorCofinsRetido, c);
        ++c.gridx;
        this.pnlImpostosRetidos.add((Component)this.textValorCofinsRetido, c);
        ++c.gridx;
        this.pnlImpostosRetidos.add((Component)this.textPercentualCofinsRetido, c);
        ++c.gridx;
        this.pnlImpostosRetidos.add((Component)this.lblPercentualCofinsRetido, c);
        c.gridx = 0;
        ++c.gridy;
        this.pnlImpostos.add((Component)this.lblValorInss, c);
        ++c.gridx;
        this.pnlImpostos.add((Component)this.textValorInss, c);
        ++c.gridx;
        this.pnlImpostos.add((Component)this.textPercentualInss, c);
        ++c.gridx;
        this.pnlImpostos.add((Component)this.lblPercentualInss, c);
        c.gridx += 2;
        this.lblValorInssRetido.setToolTipText("Inss Retido");
        this.pnlImpostosRetidos.add((Component)this.lblValorInssRetido, c);
        ++c.gridx;
        this.pnlImpostosRetidos.add((Component)this.textValorInssRetido, c);
        ++c.gridx;
        this.pnlImpostosRetidos.add((Component)this.textPercentualInssRetido, c);
        ++c.gridx;
        this.pnlImpostosRetidos.add((Component)this.lblPercentualInssRetido, c);
        Funcoes.montaEnter((JComponent)this.pnlCentral);
        Funcoes.montaEnter((JComponent)this.pnlImpostos);
    }

    public void setTitulo(ReceberPagarBean titulo) {
        this.titulo = titulo;
        this.popularValores(titulo);
    }

    public ReceberPagarBean getTitulo() {
        return this.titulo;
    }

    public void setService(ReceberPagarService service) {
        this.service = service;
    }

    public void setDataConciliacao(Date dataConciliacao) {
        this.dataConciliacao = dataConciliacao;
    }

    private void calculaPercentual() {
        this.titulo.setValorMulta(Funcoes.textoVazio(this.textValorMulta.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValorMulta.getText())));
        this.titulo.setValorAcrescimo(Funcoes.textoVazio(this.textValorAcrescimo.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValorAcrescimo.getText())));
        this.titulo.setValorDesconto(Funcoes.textoVazio(this.textValorDesconto.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValorDesconto.getText())));
        this.titulo = (ReceberPagarBean)FinanceiroUtil.calculaPercentuais(this.titulo);
        this.popularValores(this.titulo);
    }

    private void calcularValorJuros() {
        this.titulo.setUsarValorMulta(new Boolean(this.chkJuroMulta.isSelected()));
        try {
            this.titulo.setPercentualJuro(this.textPercentualJuro.getText() == null || this.textPercentualJuro.getText().equals("") ? 0.0 : Double.parseDouble(this.textPercentualJuro.getText()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.service == null) {
            this.service = new ReceberPagarService();
        }
        this.titulo = (ReceberPagarBean)FinanceiroUtil.calculaJuros((AbstractThreadBean)this.titulo, this.dataConciliacao);
        this.popularValores(this.titulo);
    }

    private void calcularValorMulta() {
        try {
            this.titulo.setPercentualMulta(this.textPercentualMulta.getText() == null || this.textPercentualMulta.getText().equals("") ? 0.0 : Double.parseDouble(this.textPercentualMulta.getText()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.titulo = (ReceberPagarBean)FinanceiroUtil.calculaMulta((AbstractThreadBean)this.titulo, this.dataConciliacao);
        this.popularValores(this.titulo);
    }

    private void calculaPercentualJuro() {
        try {
            this.titulo.setValorJuro(this.textValorJuro.getText() == null || this.textValorJuro.getText().equals("") ? 0.0 : Double.parseDouble(this.textValorJuro.getText()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.titulo = (ReceberPagarBean)FinanceiroUtil.calculaPercentualJuro((AbstractThreadBean)this.titulo, this.dataConciliacao);
        this.popularValores(this.titulo);
    }

    private void calculaValorAcrescimo() {
        try {
            this.titulo.setPercentualAcrescimo(this.textPercentualAcrescimo.getText() == null || this.textPercentualAcrescimo.getText().equals("") ? 0.0 : Double.parseDouble(this.textPercentualAcrescimo.getText()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.titulo = (ReceberPagarBean)FinanceiroUtil.calculaAcrescimo((AbstractThreadBean)this.titulo, this.dataConciliacao);
        this.popularValores(this.titulo);
    }

    private void calculaValorDesconto() {
        try {
            this.titulo.setPercentualDesconto(this.textPercentualDesconto.getText() == null || this.textPercentualDesconto.getText().equals("") ? 0.0 : Double.parseDouble(this.textPercentualDesconto.getText()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.titulo = (ReceberPagarBean)FinanceiroUtil.calculaDesconto((AbstractThreadBean)this.titulo);
        this.popularValores(this.titulo);
    }

    private void popularValores(ReceberPagarBean titulo) {
        if (titulo == null) {
            return;
        }
        this.chkJuroMulta.setSelected(titulo.getUsarValorMulta() == null ? false : titulo.getUsarValorMulta());
        if (!this.textPercentualJuro.hasFocus() && !this.textValorJuro.hasFocus()) {
            this.cbxTipoJuro.setSelectedItem(Tipos.tipoJuros(titulo.getTipoJuro()));
        }
        if (this.cbxTipoJuro.getSelectedItem().equals("V")) {
            this.textPercentualJuro.setText("0.00");
        }
        if (!this.textValor.hasFocus()) {
            this.textValor.setText(titulo.getValor() == null ? "0,00" : Funcoes.formataDecimal(this.textValor.getMaskDecimal(), titulo.getValor()));
        }
        if (!this.textTaxa.hasFocus()) {
            this.textTaxa.setText(titulo.getTaxa() == null ? "0,00" : Funcoes.formataDecimal(this.textTaxa.getMaskDecimal(), titulo.getTaxa()));
        }
        if (!this.textValorMulta.hasFocus()) {
            this.textValorMulta.setText(titulo.getValorMulta() == null ? "0,00" : Funcoes.formataDecimal(this.textValorMulta.getMaskDecimal(), titulo.getValorMulta()));
        }
        if (!this.textValorJuro.hasFocus()) {
            this.textValorJuro.setText(titulo.getValorJuro() == null ? "0,00" : Funcoes.formataDecimal(this.textValorJuro.getMaskDecimal(), titulo.getValorJuro()));
        }
        if (!this.textValorDesconto.hasFocus()) {
            this.textValorDesconto.setText(titulo.getValorDesconto() == null ? "0,00" : Funcoes.formataDecimal(this.textValorDesconto.getMaskDecimal(), titulo.getValorDesconto()));
        }
        if (!this.textValorAcrescimo.hasFocus()) {
            this.textValorAcrescimo.setText(titulo.getValorAcrescimo() == null ? "0,00" : Funcoes.formataDecimal(this.textValorAcrescimo.getMaskDecimal(), titulo.getValorAcrescimo()));
        }
        if (!this.textPercentualMulta.hasFocus()) {
            this.textPercentualMulta.setText(titulo.getPercentualMulta() == null ? "0,0000" : Funcoes.formataDecimal("0.0000", titulo.getPercentualMulta()));
        }
        if (!this.textPercentualJuro.hasFocus()) {
            this.textPercentualJuro.setText(titulo.getPercentualJuro() == null ? "0,0000" : Funcoes.formataDecimal("0.0000", titulo.getPercentualJuro()));
        }
        if (!this.textPercentualDesconto.hasFocus()) {
            this.textPercentualDesconto.setText(titulo.getPercentualDesconto() == null ? "0,0000" : Funcoes.formataDecimal("0.0000", titulo.getPercentualDesconto()));
        }
        if (!this.textPercentualAcrescimo.hasFocus()) {
            this.textPercentualAcrescimo.setText(titulo.getPercentualAcrescimo() == null ? "0,0000" : Funcoes.formataDecimal("0.0000", titulo.getPercentualAcrescimo()));
        }
        double total = 0.0;
        total += titulo.getValor() == null ? 0.0 : titulo.getValor();
        total -= titulo.getIrrfValor() == null ? 0.0 : titulo.getIrrfValor();
        total -= titulo.getIssRetidoValor() == null ? 0.0 : titulo.getIssRetidoValor();
        total -= titulo.getPisValor() == null ? 0.0 : titulo.getPisValor();
        total -= titulo.getCsllValor() == null ? 0.0 : titulo.getCsllValor();
        total -= titulo.getCofinsValor() == null ? 0.0 : titulo.getCofinsValor();
        this.lblVlrValorTotalSemImp.setText(Funcoes.formataDecimal(total -= titulo.getInssValor() == null ? 0.0 : titulo.getInssValor()));
        this.lblVlrValorTotal.setText(Funcoes.formataDecimal(titulo.getValorTotal()));
        if (!this.textPercentualIrrf.hasFocus()) {
            this.textPercentualIrrf.setText(titulo.getIrrfPercentual() == null ? "0,0000" : Funcoes.formataDecimal("0.0000", titulo.getIrrfPercentual()));
        }
        if (!this.textValorIrrf.hasFocus()) {
            this.textValorIrrf.setText(titulo.getIrrfValor() == null ? "0,00" : Funcoes.formataDecimal(this.textValorIrrf.getMaskDecimal(), titulo.getIrrfValor()));
        }
        if (!this.textPercentualIss.hasFocus()) {
            this.textPercentualIss.setText(titulo.getIssPercentual() == null ? "0,0000" : Funcoes.formataDecimal(this.textPercentualIss.getMaskDecimal(), titulo.getIssPercentual()));
        }
        if (!this.textValorIss.hasFocus()) {
            this.textValorIss.setText(titulo.getIssValor() == null ? "0,00" : Funcoes.formataDecimal(this.textValorIss.getMaskDecimal(), titulo.getIssValor()));
        }
        if (!this.textPercentualIssRetido.hasFocus()) {
            this.textPercentualIssRetido.setText(titulo.getIssRetidoPercentual() == null ? "0,0000" : Funcoes.formataDecimal(this.textPercentualIssRetido.getMaskDecimal(), titulo.getIssRetidoPercentual()));
        }
        if (!this.textValorIssRetido.hasFocus()) {
            this.textValorIssRetido.setText(titulo.getIssRetidoValor() == null ? "0,00" : Funcoes.formataDecimal(this.textValorIssRetido.getMaskDecimal(), titulo.getIssRetidoValor()));
        }
        if (!this.textValorCofinsRetido.hasFocus()) {
            this.textValorCofinsRetido.setText(titulo.getCofinsRetidoValor() == null ? "0,00" : Funcoes.formataDecimal(this.textValorCofinsRetido.getMaskDecimal(), titulo.getCofinsRetidoValor()));
        }
        if (!this.textValorInssRetido.hasFocus()) {
            this.textValorInssRetido.setText(titulo.getInssRetidoValor() == null ? "0,00" : Funcoes.formataDecimal(this.textValorInssRetido.getMaskDecimal(), titulo.getInssRetidoValor()));
        }
        if (!this.textValorCsllRetido.hasFocus()) {
            this.textValorCsllRetido.setText(titulo.getCsllRetidoValor() == null ? "0,00" : Funcoes.formataDecimal(this.textValorCsllRetido.getMaskDecimal(), titulo.getCsllRetidoValor()));
        }
        if (!this.textValorIrrfRetido.hasFocus()) {
            this.textValorIrrfRetido.setText(titulo.getIrrfRetidoValor() == null ? "0,00" : Funcoes.formataDecimal(this.textValorIrrfRetido.getMaskDecimal(), titulo.getIrrfRetidoValor()));
        }
        if (!this.textValorPisRetido.hasFocus()) {
            this.textValorPisRetido.setText(titulo.getPisRetidoValor() == null ? "0,00" : Funcoes.formataDecimal(this.textValorPisRetido.getMaskDecimal(), titulo.getPisRetidoValor()));
        }
        if (!this.textPercentualPis.hasFocus()) {
            this.textPercentualPis.setText(titulo.getPisPercentual() == null ? "0,0000" : Funcoes.formataDecimal("0.0000", titulo.getPisPercentual()));
        }
        if (!this.textValorPis.hasFocus()) {
            this.textValorPis.setText(titulo.getPisValor() == null ? "0,00" : Funcoes.formataDecimal(this.textValorPis.getMaskDecimal(), titulo.getPisValor()));
        }
        if (!this.textPercentualCsll.hasFocus()) {
            this.textPercentualCsll.setText(titulo.getCsllPercentual() == null ? "0,0000" : Funcoes.formataDecimal("0.0000", titulo.getCsllPercentual()));
        }
        if (!this.textValorCsll.hasFocus()) {
            this.textValorCsll.setText(titulo.getCsllValor() == null ? "0,00" : Funcoes.formataDecimal(this.textValorCsll.getMaskDecimal(), titulo.getCsllValor()));
        }
        if (!this.textPercentualCofins.hasFocus()) {
            this.textPercentualCofins.setText(titulo.getIrrfPercentual() == null ? "0,0000" : Funcoes.formataDecimal("0.0000", titulo.getCofinsPercentual()));
        }
        if (!this.textValorCofins.hasFocus()) {
            this.textValorCofins.setText(titulo.getCofinsValor() == null ? "0,00" : Funcoes.formataDecimal(this.textValorCofins.getMaskDecimal(), titulo.getCofinsValor()));
        }
        if (!this.textPercentualInss.hasFocus()) {
            this.textPercentualInss.setText(titulo.getInssPercentual() == null ? "0,0000" : Funcoes.formataDecimal("0.0000", titulo.getInssPercentual()));
        }
        if (!this.textPercentualInssRetido.hasFocus()) {
            this.textPercentualInssRetido.setText(titulo.getInssRetidoPercentual() == null ? "0,0000" : Funcoes.formataDecimal("0.0000", titulo.getInssRetidoPercentual()));
        }
        if (!this.textPercentualCofinsRetido.hasFocus()) {
            this.textPercentualCofinsRetido.setText(titulo.getCofinsRetidoPercentual() == null ? "0,0000" : Funcoes.formataDecimal("0.0000", titulo.getCofinsRetidoPercentual()));
        }
        if (!this.textPercentualCsllRetido.hasFocus()) {
            this.textPercentualCsllRetido.setText(titulo.getCsllRetidoPercentual() == null ? "0,0000" : Funcoes.formataDecimal("0.0000", titulo.getCsllRetidoPercentual()));
        }
        if (!this.textPercentualIrrfRetido.hasFocus()) {
            this.textPercentualIrrfRetido.setText(titulo.getIrrfRetidoPercentual() == null ? "0,0000" : Funcoes.formataDecimal("0.0000", titulo.getIrrfRetidoPercentual()));
        }
        if (!this.textPercentualPisRetido.hasFocus()) {
            this.textPercentualPisRetido.setText(titulo.getPisRetidoPercentual() == null ? "0,0000" : Funcoes.formataDecimal("0.0000", titulo.getPisRetidoPercentual()));
        }
        if (!this.textValorInss.hasFocus()) {
            this.textValorInss.setText(titulo.getInssValor() == null ? "0,00" : Funcoes.formataDecimal(this.textValorInss.getMaskDecimal(), titulo.getInssValor()));
        }
        if (titulo.getNotaFiscal() == null) {
            this.labelComposicao.setVisible(false);
            this.labelVlrComposicao.setVisible(false);
            this.labelMostraComposicao.setVisible(false);
            this.panelComposicao.setVisible(false);
            this.setSize(new Dimension(500, 430));
        } else {
            this.labelVlrComposicao.setText(Funcoes.formataDecimal(titulo.getNotaFiscal().getImpostoAcumulado() == null ? 0.0 : titulo.getNotaFiscal().getImpostoAcumulado()));
        }
    }

    private void recalculaValores() {
        this.titulo.setValor(Funcoes.textoVazio(this.textValor.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValor.getText())));
        this.titulo.setTaxa(Funcoes.textoVazio(this.textTaxa.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textTaxa.getText())));
        this.titulo = (ReceberPagarBean)FinanceiroUtil.atualizaValores(this.titulo, this.dataConciliacao);
        this.popularValores(this.titulo);
    }

    private void recalculaTotal() {
        this.titulo = (ReceberPagarBean)FinanceiroUtil.atualizaTotal((AbstractThreadBean)this.titulo);
        this.popularValores(this.titulo);
    }

    private void cancelar() {
        this.titulo = null;
        this.setVisible(false);
    }

    private void salvar() {
        this.setVisible(false);
    }

    private void calculaPercentualImposto() {
        this.titulo.setIrrfValor(Funcoes.textoVazio(this.textValorIrrf.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValorIrrf.getText())));
        this.titulo.setIssValor(Funcoes.textoVazio(this.textValorIss.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValorIss.getText())));
        this.titulo.setIssRetidoValor(Funcoes.textoVazio(this.textValorIssRetido.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValorIssRetido.getText())));
        this.titulo.setInssRetidoValor(Funcoes.textoVazio(this.textValorInssRetido.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValorInssRetido.getText())));
        this.titulo.setCofinsRetidoValor(Funcoes.textoVazio(this.textValorCofinsRetido.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValorCofinsRetido.getText())));
        this.titulo.setCsllRetidoValor(Funcoes.textoVazio(this.textValorCsllRetido.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValorCsllRetido.getText())));
        this.titulo.setIrrfRetidoValor(Funcoes.textoVazio(this.textValorIrrfRetido.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValorIrrfRetido.getText())));
        this.titulo.setPisRetidoValor(Funcoes.textoVazio(this.textValorPisRetido.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValorPisRetido.getText())));
        this.titulo.setPisValor(Funcoes.textoVazio(this.textValorPis.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValorPis.getText())));
        this.titulo.setCsllValor(Funcoes.textoVazio(this.textValorCsll.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValorCsll.getText())));
        this.titulo.setCofinsValor(Funcoes.textoVazio(this.textValorCofins.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValorCofins.getText())));
        this.titulo.setInssValor(Funcoes.textoVazio(this.textValorInss.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValorInss.getText())));
        this.titulo = FinanceiroUtil.calculaPercentualImpostoSemNota(this.titulo);
        this.popularValores(this.titulo);
    }

    private void calculaValorImposto() {
        this.titulo.setIrrfPercentual(Funcoes.textoVazio(this.textPercentualIrrf.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textPercentualIrrf.getText())));
        this.titulo.setIssPercentual(Funcoes.textoVazio(this.textPercentualIss.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textPercentualIss.getText())));
        this.titulo.setIssRetidoPercentual(Funcoes.textoVazio(this.textPercentualIssRetido.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textPercentualIssRetido.getText())));
        this.titulo.setInssRetidoPercentual(Funcoes.textoVazio(this.textPercentualInssRetido.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textPercentualInssRetido.getText())));
        this.titulo.setCofinsRetidoPercentual(Funcoes.textoVazio(this.textPercentualCofinsRetido.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textPercentualCofinsRetido.getText())));
        this.titulo.setCsllRetidoPercentual(Funcoes.textoVazio(this.textPercentualCsllRetido.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textPercentualCsllRetido.getText())));
        this.titulo.setIrrfRetidoPercentual(Funcoes.textoVazio(this.textPercentualIrrfRetido.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textPercentualIrrfRetido.getText())));
        this.titulo.setPisRetidoPercentual(Funcoes.textoVazio(this.textPercentualPisRetido.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textPercentualPisRetido.getText())));
        this.titulo.setPisPercentual(Funcoes.textoVazio(this.textPercentualPis.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textPercentualPis.getText())));
        this.titulo.setCsllPercentual(Funcoes.textoVazio(this.textPercentualCsll.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textPercentualCsll.getText())));
        this.titulo.setCofinsPercentual(Funcoes.textoVazio(this.textPercentualCofins.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textPercentualCofins.getText())));
        this.titulo.setInssPercentual(Funcoes.textoVazio(this.textPercentualInss.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textPercentualInss.getText())));
        this.titulo = FinanceiroUtil.calculaValorImpostoSemNota(this.titulo);
        this.popularValores(this.titulo);
    }
}

