/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

public class PlanoContas
extends FrmCadPadrao {
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private TTextField txtCodigo = new TTextField(5, 1);
    private JFormattedTextField txtConta = new JFormattedTextField();
    private TTextField txtDescricao = new TTextField(100);
    private JLabel labelTipo = new JLabel("Tipo:");
    private JComboBox comboTipo = new JComboBox<String>(new String[]{"Receita", "Despesa", "Custos"});
    private JLabel labelConta = new JLabel("Nr. conta:");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private JComboBox comboApropriar = new JComboBox();
    private JLabel labelApropriar = new JLabel("Apropriar:");
    private String retornoParaPesquisa = "";

    public PlanoContas() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "PlanoContas");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public void jbInit() throws Exception {
        this.setLabelDescricao("Cadastro de plano de contas para detalhamento financeiro");
        this.setLabelFormulario("Cadastro de plano de contas");
        this.setIcone(ImagemUtils.carregaImagemJalis("plano_contas.jpg"));
        this.labelCodigo.setDisplayedMnemonic('D');
        this.labelCodigo.setLabelFor(this.txtCodigo);
        this.labelCodigo.setText("C\u00f3digo:");
        this.labelCodigo.setBounds(new Rectangle(7, 9, 55, 14));
        this.txtCodigo.setText("");
        this.txtCodigo.setBounds(new Rectangle(72, 7, 69, 20));
        this.txtConta.setBounds(new Rectangle(72, 28, 200, 20));
        this.labelConta.setBounds(new Rectangle(7, 30, 63, 14));
        this.labelConta.setDisplayedMnemonic('o');
        this.labelConta.setLabelFor(this.txtConta);
        this.labelDescricao.setBounds(new Rectangle(7, 51, 63, 14));
        this.txtDescricao.setBounds(new Rectangle(72, 49, 400, 20));
        this.labelTipo.setBounds(new Rectangle(7, 72, 63, 14));
        this.comboTipo.setBounds(new Rectangle(72, 70, 150, 20));
        this.labelApropriar.setBounds(new Rectangle(7, 93, 63, 14));
        this.comboApropriar.setBounds(new Rectangle(72, 91, 400, 20));
        this.txtConta.setFormatterFactory(new DefaultFormatterFactory(new MaskFormatter("##.##.###")));
        this.txtConta.setFocusLostBehavior(0);
        this.controlaCampos();
        this.painelCentral.add(this.labelCodigo);
        this.painelCentral.add(this.labelConta);
        this.painelCentral.add(this.txtCodigo);
        this.painelCentral.add(this.txtConta);
        this.painelCentral.add(this.labelDescricao);
        this.painelCentral.add(this.txtDescricao);
        this.painelCentral.add(this.labelTipo);
        this.painelCentral.add(this.comboTipo);
        this.painelCentral.add(this.labelApropriar);
        this.painelCentral.add(this.comboApropriar);
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (PlanoContas.this.txtCodigo.getText().trim().length() > 0) {
                    Statement st = PlanoContas.this.getStatement();
                    try {
                        if (st != null) {
                            StringBuffer buf = new StringBuffer("select plc_reduzido, plc_descricao, plc_conta, plc_tipo, plc_apropriar ");
                            buf.append("from planoconta ");
                            buf.append("where fil_codigo = ");
                            buf.append(Variaveis.filialPadrao);
                            buf.append(" and plc_reduzido = ");
                            buf.append(PlanoContas.this.txtCodigo.getTextDB());
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs != null && rs.next()) {
                                PlanoContas.this.txtConta.setValue(rs.getString("plc_conta"));
                                PlanoContas.this.txtDescricao.setText(rs.getString("plc_descricao"));
                                PlanoContas.this.comboTipo.setSelectedItem(Tipos.tipoPlanoContas(rs.getString("plc_tipo")));
                                if (!DBUtil.campoNull(rs.getString("plc_apropriar"))) {
                                    PlanoContas.this.comboApropriar.setSelectedItem(0);
                                }
                                if (PlanoContas.this.getStatus() == 2) {
                                    PlanoContas.this.setStatus(3);
                                }
                                PlanoContas.this.txtCodigo.setEnabled(false);
                                PlanoContas.this.txtConta.grabFocus();
                            } else if (PlanoContas.this.getStatus() == 3) {
                                Funcoes.mensagem(PlanoContas.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                PlanoContas.this.setStatus(1);
                                PlanoContas.this.controlaCampos();
                            }
                        }
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(PlanoContas.this, sqlex.getMessage(), sqlex.getStackTrace(), "PlanoContas");
                    }
                    Conexao.fecharStatement(st);
                }
            }
        });
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(PlanoContas.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0600300101"));
        this.setModuloEdita(Long.parseLong("0600300102"));
        this.setModuloApaga(Long.parseLong("0600300103"));
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.planoContas(this.getTopLevelAncestor(), "", false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("plc_reduzido").toString());
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("planoconta", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("plc_reduzido", 2, false, true, this.txtCodigo.getTextDB());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaPlanoConta());
                    Conexao.arquivaSQL();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "PlanoContas");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtConta.grabFocus();
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                String codigo = this.txtCodigo.getText();
                if (this.getStatus() == 2) {
                    codigo = DBUtil.getSequencia(statement, "planoconta", true);
                }
                String tipo = "R";
                switch (this.comboTipo.getSelectedIndex()) {
                    case 1: {
                        tipo = "D";
                        break;
                    }
                    default: {
                        tipo = "C";
                    }
                }
                SalvaDados salvar = new SalvaDados("planoconta", this.getStatus() == 2 ? 0 : 2);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("plc_reduzido", 2, false, true, codigo);
                salvar.adicionaCampo("plc_conta", 0, true, false, StringUtil.textoDB(this.txtConta.getText()));
                salvar.adicionaCampo("plc_descricao", 0, true, false, this.txtDescricao.getTextDB());
                salvar.adicionaCampo("plc_tipo", 0, true, false, tipo);
                salvar.adicionaCampo("plc_apropriar", 2, true, false, null);
                salvar.adicionaCampo("plc_nivel", 2, true, false, String.valueOf(Funcoes.contaNivelPlanoContas(this.txtConta.getText())));
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaPlanoConta(), "planoconta", Integer.parseInt(codigo));
                this.retornoParaPesquisa = codigo;
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "PlanoContas");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        this.txtCodigo.setEnabled(this.getStatus() == 3);
        this.txtConta.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboTipo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    private void limparCampos() {
        this.txtCodigo.clear();
        this.txtConta.setText("");
        this.txtDescricao.clear();
        this.comboTipo.setSelectedIndex(0);
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.txtCodigo.getText()) && this.getStatus() == 3) {
            Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
            this.txtCodigo.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtConta.getText())) {
            Funcoes.mensagem(this, "Campo conta n\u00e3o informado", 1);
            this.txtConta.selectAll();
            this.txtConta.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtDescricao.getText())) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.txtDescricao.selectAll();
            this.txtDescricao.grabFocus();
            return false;
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600300100");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "plc_reduzido";
    }
}

