/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.model.bean.financeiro.LancamentoCentroCustoBean;
import jalis.model.bean.financeiro.LancamentoPlanoContaBean;
import jalis.model.bean.recepcao.RequisicaoLanctoCaixaBean;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.HistoricoPadraoVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.financeiro.ContaCorrenteVO;
import jalis.model.vo.financeiro.LancamentoVO;
import jalis.service.cadastro.auxiliares.HistoricoPadraoService;
import jalis.service.cadastro.financeiro.ContaCorrenteService;
import jalis.service.configuracao.UsuarioService;
import jalis.service.financeiro.LancamentoService;
import jalis.service.recepcao.RequisicaoLanctoCaixaService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class TransferenciaPagamento
extends FrmCadPadraoBean
implements ActionListener {
    private final int COLUNA_SEL_CHEQUE_CAUCAO = 6;
    private final int COLUNA_SEL_CHEQUE_PRE = 7;
    private final int COLUNA_SEL_CHEQUE_TERCEIRO = 7;
    private final int COLUNA_SEL_CARTAO_DEBITO_CREDITO = 5;
    private final int COLUNA_SEL_DINHEIRO = 3;
    private final int COLUNA_SEL_PROMISSORIA = 3;
    private final int COLUNA_SEL_DEPOSITO_BANCARIO = 6;
    private final int COLUNA_SEL_BOLETO = 4;
    private final int COLUNA_SEL_PIX = 6;
    private final int COLUNA_SEL_AUTORIZACAO_DEBITO = 3;
    private JLabel labelConta = new JLabel("Conta de Origem:");
    private JLabel labelDescConta = new JLabel();
    private JLabel labelDataInicial = new JLabel("Data Inicial");
    private JLabel labelDataFinal = new JLabel("Data Final");
    private JLabel labelTipoPagamento = new JLabel("Pagamento");
    private JLabel labelContaDestino = new JLabel("Conta de Destino:");
    private JLabel labelDescContaDestino = new JLabel();
    private JLabel labelHistoricoDestino = new JLabel("Hist\u00f3rico Padr\u00e3o:");
    private JLabel labelDescHistoricoDestino = new JLabel();
    private JLabel labelDescricaoHistoricoDestino = new JLabel("Descri\u00e7\u00e3o Hist\u00f3rico:");
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio");
    private JLabel labelFiltrar = new JLabel();
    private JLabel labelHoraInicial = new JLabel("Hora Inicial");
    private JLabel labelHoraFinal = new JLabel("Hora Final");
    private JLabel labelDescUsuario = new JLabel();
    private JLabel labelQtdeSelecionada = new JLabel("Qtde. Selecionada: ");
    private JLabel labelVlrQtdeSelecionada = new JLabel();
    private JLabel labelValorSelecionado = new JLabel("Valor Selecionado: ");
    private JLabel labelVlrValorSelecionado = new JLabel();
    private JButton buttonConta = new JButton();
    private JButton buttonDataInicial = new JButton();
    private JButton buttonDataFinal = new JButton();
    private JButton buttonContaDestino = new JButton();
    private JButton buttonHistoricoDestino = new JButton();
    private JButton buttonBuscar = new JButton("Filtrar");
    private JButton buttonUsuario = new JButton();
    private TTextField textConta = new TTextField(8, 1);
    private TTextField textDataInicial = new TTextField(10, 4);
    private TTextField textDataFinal = new TTextField(10, 4);
    private TTextField textContaDestino = new TTextField(8, 1);
    private TTextField textHistoricoDestino = new TTextField(8, 1);
    private TTextField textDescricaoHistoricoDestino = new TTextField(60, 3);
    private TTextField textUsuario = new TTextField(20, 3);
    private TTextField textHoraInicial = new TTextField(5, 6);
    private TTextField textHoraFinal = new TTextField(5, 6);
    private JComboBox comboTipoPagamento = new JComboBox<TiposPagamento>(TiposPagamento.values());
    private JCheckBox checkIntervaloHora = new JCheckBox("Intervalo de Hora");
    private JPanel panelContaOrigem = new JPanel(new GridBagLayout());
    private JPanel panelFiltros = new JPanel(new GridBagLayout());
    private JPanel panelDetalhesTransferencia = new JPanel(new GridBagLayout());
    private JPanel panelDetalhesDestino = new JPanel(new GridBagLayout());
    private JPanel panelSelecionados = new JPanel(new FlowLayout(2));
    private ModeloGridTable modeloChequeCaucao = new ModeloGridTable(new String[]{"Data/Hora", "Valor Total", "Banco", "Ag\u00eancia", "Conta", "Cheque", ""}){

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 6;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Object[] classes = new Object[]{String.class, String.class, Integer.class, String.class, String.class, String.class, Boolean.class};
            return (Class)classes[columnIndex];
        }
    };
    private ModeloGridTable modeloTransferencia = new ModeloGridTable(new String[]{"Data/Hora", "Valor Total", "Banco", "Ag\u00eancia", "Conta", "Transfer\u00eancia", ""}){

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 6;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Object[] classes = new Object[]{String.class, String.class, Integer.class, String.class, String.class, String.class, Boolean.class};
            return (Class)classes[columnIndex];
        }
    };
    private ModeloGridTable modeloChequePre = new ModeloGridTable(new String[]{"Data/Hora", "Valor Total", "Banco", "Ag\u00eancia", "Conta", "Cheque", "Vencimento", ""}){

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 7;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Object[] classes = new Object[]{String.class, String.class, Integer.class, String.class, String.class, String.class, String.class, Boolean.class};
            return (Class)classes[columnIndex];
        }
    };
    private ModeloGridTable modeloChequeTerceiro = new ModeloGridTable(new String[]{"Data/Hora", "Valor Total", "Banco", "Ag\u00eancia", "Conta", "Cheque", "Vencimento", ""}){

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 7;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Object[] classes = new Object[]{String.class, String.class, Integer.class, String.class, String.class, String.class, String.class, Boolean.class};
            return (Class)classes[columnIndex];
        }
    };
    private ModeloGridTable modeloCartaoDebitoCredito = new ModeloGridTable(new String[]{"Data/Hora", "Valor Total", "Bandeira", "N\u00famero Cart\u00e3o", "Validade", ""}){

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 5;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Object[] classes = new Object[]{String.class, String.class, String.class, String.class, String.class, Boolean.class};
            return (Class)classes[columnIndex];
        }
    };
    private ModeloGridTable modeloPromissoria = new ModeloGridTable(new String[]{"Data/Hora", "Valor Total", "N\u00famero Promiss\u00f3ria", ""}){

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 3;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Object[] classes = new Object[]{String.class, String.class, String.class, Boolean.class};
            return (Class)classes[columnIndex];
        }
    };
    private ModeloGridTable modeloAutorizacaoDebito = new ModeloGridTable(new String[]{"Data/Hora", "Valor Total", "N\u00famero Documento", ""}){

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 3;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Object[] classes = new Object[]{String.class, String.class, String.class, Boolean.class};
            return (Class)classes[columnIndex];
        }
    };
    private ModeloGridTable modeloDinheiro = new ModeloGridTable(new String[]{"Data/Hora", "Valor Total", "Usu\u00e1rio", ""}){

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 3;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Object[] classes = new Object[]{String.class, String.class, String.class, Boolean.class};
            return (Class)classes[columnIndex];
        }
    };
    private ModeloGridTable modeloDepositoBancario = new ModeloGridTable(new String[]{"Data/Hora", "Valor Total", "Banco", "Ag\u00eancia", "Conta", "Data", ""}){

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 6;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Object[] classes = new Object[]{String.class, String.class, Integer.class, String.class, String.class, String.class, Boolean.class};
            return (Class)classes[columnIndex];
        }
    };
    private ModeloGridTable modeloBoleto = new ModeloGridTable(new String[]{"Data/Hora", "Valor Total", "Documento", "Vencimento", ""}){

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 4;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Object[] classes = new Object[]{String.class, String.class, String.class, String.class, Boolean.class};
            return (Class)classes[columnIndex];
        }
    };
    private ModeloGridTable modeloPix = new ModeloGridTable(new String[]{"Data/Hora", "Valor Total", "Banco", "Ag\u00eancia", "Conta", "Pix", ""}){

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 6;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Object[] classes = new Object[]{String.class, String.class, Integer.class, String.class, String.class, String.class, Boolean.class};
            return (Class)classes[columnIndex];
        }
    };
    private JTable tablePagamentos;
    private JScrollPane scrollPagamentos;
    private ContaCorrenteVO contaOrigemAux = null;
    private ContaCorrenteVO contaDestinoAux = null;
    private HistoricoPadraoVO historicoDestinoAux = null;

    public TransferenciaPagamento() {
        this.montaTela();
        this.controlaCampos();
        this.atualizaTotalizadores();
        ScreenUtil.requisitarFoco(this.botaoNovo);
    }

    private void atualizaTotalizadores() {
        Integer casas = ParametrosGerais.getCasasPrecoExame();
        RoundingMode round = ParametrosGerais.getArredondamentoPrecoExame();
        ModeloGridTable modelo = (ModeloGridTable)this.tablePagamentos.getModel();
        if (modelo != null && modelo.getColumnCount() > 0) {
            BigDecimal valor = BigDecimal.ZERO;
            int qtde = 0;
            if (this.tablePagamentos.getModel() == this.modeloChequeCaucao) {
                for (int i = 0; i < this.modeloChequeCaucao.getRowCount(); ++i) {
                    if (!((Boolean)this.modeloChequeCaucao.getValueAt(i, 6)).booleanValue()) continue;
                    ++qtde;
                    valor = valor.add(((BigDecimal)this.modeloChequeCaucao.getValueAt(i, 9)).setScale((int)casas, round));
                }
            } else if (this.tablePagamentos.getModel() == this.modeloChequePre) {
                for (int i = 0; i < this.modeloChequePre.getRowCount(); ++i) {
                    if (!((Boolean)this.modeloChequePre.getValueAt(i, 7)).booleanValue()) continue;
                    ++qtde;
                    valor = valor.add(((BigDecimal)this.modeloChequePre.getValueAt(i, 10)).setScale((int)casas, round));
                }
            } else if (this.tablePagamentos.getModel() == this.modeloChequeTerceiro) {
                for (int i = 0; i < this.modeloChequeTerceiro.getRowCount(); ++i) {
                    if (!((Boolean)this.modeloChequeTerceiro.getValueAt(i, 7)).booleanValue()) continue;
                    ++qtde;
                    valor = valor.add(((BigDecimal)this.modeloChequeTerceiro.getValueAt(i, 10)).setScale((int)casas, round));
                }
            } else if (this.tablePagamentos.getModel() == this.modeloCartaoDebitoCredito) {
                for (int i = 0; i < this.modeloCartaoDebitoCredito.getRowCount(); ++i) {
                    if (!((Boolean)this.modeloCartaoDebitoCredito.getValueAt(i, 5)).booleanValue()) continue;
                    ++qtde;
                    valor = valor.add(((BigDecimal)this.modeloCartaoDebitoCredito.getValueAt(i, 8)).setScale((int)casas, round));
                }
            } else if (this.tablePagamentos.getModel() == this.modeloPromissoria) {
                for (int i = 0; i < this.modeloPromissoria.getRowCount(); ++i) {
                    if (!((Boolean)this.modeloPromissoria.getValueAt(i, 3)).booleanValue()) continue;
                    ++qtde;
                    valor = valor.add(((BigDecimal)this.modeloPromissoria.getValueAt(i, 6)).setScale((int)casas, round));
                }
            } else if (this.tablePagamentos.getModel() == this.modeloAutorizacaoDebito) {
                for (int i = 0; i < this.modeloAutorizacaoDebito.getRowCount(); ++i) {
                    if (!((Boolean)this.modeloAutorizacaoDebito.getValueAt(i, 3)).booleanValue()) continue;
                    ++qtde;
                    valor = valor.add(((BigDecimal)this.modeloAutorizacaoDebito.getValueAt(i, 6)).setScale((int)casas, round));
                }
            } else if (this.tablePagamentos.getModel() == this.modeloDinheiro) {
                for (int i = 0; i < this.modeloDinheiro.getRowCount(); ++i) {
                    if (!((Boolean)this.modeloDinheiro.getValueAt(i, 3)).booleanValue()) continue;
                    ++qtde;
                    valor = valor.add(((BigDecimal)this.modeloDinheiro.getValueAt(i, 6)).setScale((int)casas, round));
                }
            } else if (this.tablePagamentos.getModel() == this.modeloDepositoBancario) {
                for (int i = 0; i < this.modeloDepositoBancario.getRowCount(); ++i) {
                    if (!((Boolean)this.modeloDepositoBancario.getValueAt(i, 6)).booleanValue()) continue;
                    ++qtde;
                    valor = valor.add(((BigDecimal)this.modeloDepositoBancario.getValueAt(i, 9)).setScale((int)casas, round));
                }
            } else if (this.tablePagamentos.getModel() == this.modeloBoleto) {
                for (int i = 0; i < this.modeloBoleto.getRowCount(); ++i) {
                    if (!((Boolean)this.modeloBoleto.getValueAt(i, 4)).booleanValue()) continue;
                    ++qtde;
                    valor = valor.add(((BigDecimal)this.modeloBoleto.getValueAt(i, 7)).setScale((int)casas, round));
                }
            } else if (this.tablePagamentos.getModel() == this.modeloTransferencia) {
                for (int i = 0; i < this.modeloTransferencia.getRowCount(); ++i) {
                    if (!((Boolean)this.modeloTransferencia.getValueAt(i, 6)).booleanValue()) continue;
                    ++qtde;
                    valor = valor.add(((BigDecimal)this.modeloTransferencia.getValueAt(i, 9)).setScale((int)casas, round));
                }
            } else if (this.tablePagamentos.getModel() == this.modeloPix) {
                for (int i = 0; i < this.modeloPix.getRowCount(); ++i) {
                    if (!((Boolean)this.modeloPix.getValueAt(i, 6)).booleanValue()) continue;
                    ++qtde;
                    valor = valor.add(((BigDecimal)this.modeloPix.getValueAt(i, 9)).setScale((int)casas, round));
                }
            }
            this.labelVlrQtdeSelecionada.setText("" + qtde);
            this.labelVlrValorSelecionado.setText(Funcoes.formataDecimal(valor.doubleValue()));
        } else {
            this.labelVlrQtdeSelecionada.setText("0");
            this.labelVlrValorSelecionado.setText(Funcoes.formataDecimal(0));
        }
    }

    private void montaTela() {
        Funcoes.criaBarraDescricao(this, "Transfer\u00eancia de Pagamentos", "Transfer\u00eancia de pagamentos entre contas por tipo", "financeiro/transf_conta.jpg");
        ScreenUtil.setBorda(new Component[]{this.labelDescConta, this.labelDescContaDestino, this.labelDescHistoricoDestino, this.labelFiltrar, this.labelDescUsuario}, new TitledBorder(""));
        this.botaoSalvar.setText("Transferir");
        this.painelBotoes.remove(this.botaoEditar);
        this.painelBotoes.remove(this.botaoExcluir);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 0, 1, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.painelCentral.add((Component)this.panelContaOrigem, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.panelFiltros, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        this.tablePagamentos = new JTable(new ModeloGridTable(new String[0]));
        this.scrollPagamentos = new JScrollPane(this.tablePagamentos);
        this.tablePagamentos.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = TransferenciaPagamento.this.tablePagamentos.getSelectedRow();
                if (row >= 0 && e.getKeyCode() == 32) {
                    if (TransferenciaPagamento.this.tablePagamentos.getModel() == TransferenciaPagamento.this.modeloCartaoDebitoCredito) {
                        if (TransferenciaPagamento.this.tablePagamentos.getSelectedColumn() == 5) {
                            return;
                        }
                        boolean valor = (Boolean)TransferenciaPagamento.this.tablePagamentos.getValueAt(row, 5);
                        TransferenciaPagamento.this.tablePagamentos.setValueAt(!valor, row, 5);
                    } else if (TransferenciaPagamento.this.tablePagamentos.getModel() == TransferenciaPagamento.this.modeloChequeCaucao) {
                        if (TransferenciaPagamento.this.tablePagamentos.getSelectedColumn() == 6) {
                            return;
                        }
                        boolean valor = (Boolean)TransferenciaPagamento.this.tablePagamentos.getValueAt(row, 6);
                        TransferenciaPagamento.this.tablePagamentos.setValueAt(!valor, row, 6);
                    } else if (TransferenciaPagamento.this.tablePagamentos.getModel() == TransferenciaPagamento.this.modeloChequePre) {
                        if (TransferenciaPagamento.this.tablePagamentos.getSelectedColumn() == 7) {
                            return;
                        }
                        boolean valor = (Boolean)TransferenciaPagamento.this.tablePagamentos.getValueAt(row, 7);
                        TransferenciaPagamento.this.tablePagamentos.setValueAt(!valor, row, 7);
                    } else if (TransferenciaPagamento.this.tablePagamentos.getModel() == TransferenciaPagamento.this.modeloChequeTerceiro) {
                        if (TransferenciaPagamento.this.tablePagamentos.getSelectedColumn() == 7) {
                            return;
                        }
                        boolean valor = (Boolean)TransferenciaPagamento.this.tablePagamentos.getValueAt(row, 7);
                        TransferenciaPagamento.this.tablePagamentos.setValueAt(!valor, row, 7);
                    } else if (TransferenciaPagamento.this.tablePagamentos.getModel() == TransferenciaPagamento.this.modeloPromissoria) {
                        if (TransferenciaPagamento.this.tablePagamentos.getSelectedColumn() == 3) {
                            return;
                        }
                        boolean valor = (Boolean)TransferenciaPagamento.this.tablePagamentos.getValueAt(row, 3);
                        TransferenciaPagamento.this.tablePagamentos.setValueAt(!valor, row, 3);
                    } else if (TransferenciaPagamento.this.tablePagamentos.getModel() == TransferenciaPagamento.this.modeloAutorizacaoDebito) {
                        if (TransferenciaPagamento.this.tablePagamentos.getSelectedColumn() == 3) {
                            return;
                        }
                        boolean valor = (Boolean)TransferenciaPagamento.this.tablePagamentos.getValueAt(row, 3);
                        TransferenciaPagamento.this.tablePagamentos.setValueAt(!valor, row, 3);
                    } else if (TransferenciaPagamento.this.tablePagamentos.getModel() == TransferenciaPagamento.this.modeloDinheiro) {
                        if (TransferenciaPagamento.this.tablePagamentos.getSelectedColumn() == 3) {
                            return;
                        }
                        boolean valor = (Boolean)TransferenciaPagamento.this.tablePagamentos.getValueAt(row, 3);
                        TransferenciaPagamento.this.tablePagamentos.setValueAt(!valor, row, 3);
                    } else if (TransferenciaPagamento.this.tablePagamentos.getModel() == TransferenciaPagamento.this.modeloDepositoBancario) {
                        if (TransferenciaPagamento.this.tablePagamentos.getSelectedColumn() == 6) {
                            return;
                        }
                        boolean valor = (Boolean)TransferenciaPagamento.this.tablePagamentos.getValueAt(row, 6);
                        TransferenciaPagamento.this.tablePagamentos.setValueAt(!valor, row, 6);
                    } else if (TransferenciaPagamento.this.tablePagamentos.getModel() == TransferenciaPagamento.this.modeloBoleto) {
                        if (TransferenciaPagamento.this.tablePagamentos.getSelectedColumn() == 4) {
                            return;
                        }
                        boolean valor = (Boolean)TransferenciaPagamento.this.tablePagamentos.getValueAt(row, 4);
                        TransferenciaPagamento.this.tablePagamentos.setValueAt(!valor, row, 4);
                    } else if (TransferenciaPagamento.this.tablePagamentos.getModel() == TransferenciaPagamento.this.modeloTransferencia) {
                        if (TransferenciaPagamento.this.tablePagamentos.getSelectedColumn() == 6) {
                            return;
                        }
                        boolean valor = (Boolean)TransferenciaPagamento.this.tablePagamentos.getValueAt(row, 6);
                        TransferenciaPagamento.this.tablePagamentos.setValueAt(!valor, row, 6);
                    } else if (TransferenciaPagamento.this.tablePagamentos.getModel() == TransferenciaPagamento.this.modeloPix) {
                        if (TransferenciaPagamento.this.tablePagamentos.getSelectedColumn() == 6) {
                            return;
                        }
                        boolean valor = (Boolean)TransferenciaPagamento.this.tablePagamentos.getValueAt(row, 6);
                        TransferenciaPagamento.this.tablePagamentos.setValueAt(!valor, row, 6);
                    }
                }
                TransferenciaPagamento.this.atualizaTotalizadores();
            }
        });
        this.painelCentral.add((Component)this.scrollPagamentos, c);
        ++c.gridy;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.painelCentral.add((Component)this.panelSelecionados, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.panelDetalhesTransferencia, c);
        this.panelSelecionados.add(this.labelQtdeSelecionada);
        this.panelSelecionados.add(this.labelVlrQtdeSelecionada);
        this.panelSelecionados.add(new JLabel("  -  "));
        this.panelSelecionados.add(this.labelValorSelecionado);
        this.panelSelecionados.add(this.labelVlrValorSelecionado);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 0, 1, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelConta.setDisplayedMnemonic('o');
        this.labelConta.setLabelFor(this.textConta);
        this.panelContaOrigem.add((Component)this.labelConta, c);
        ++c.gridx;
        Dimension d = new Dimension(80, 20);
        this.textConta.setPreferredSize(d);
        this.textConta.setMinimumSize(d);
        this.textConta.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    TransferenciaPagamento.this.buttonConta.doClick();
                }
            }
        });
        this.textConta.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TransferenciaPagamento.this.getContaOrigem();
            }
        });
        this.panelContaOrigem.add((Component)this.textConta, c);
        ++c.gridx;
        d = new Dimension(20, 20);
        this.buttonConta.setPreferredSize(d);
        this.buttonConta.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonConta);
        this.buttonConta.setFocusable(false);
        this.buttonConta.addActionListener(this);
        this.panelContaOrigem.add((Component)this.buttonConta, c);
        ++c.gridx;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.fill = 2;
        d = new Dimension(20, 20);
        this.labelDescConta.setPreferredSize(d);
        this.labelDescConta.setMinimumSize(d);
        this.panelContaOrigem.add((Component)this.labelDescConta, c);
        JPanel panelFiltroData = new JPanel(new GridBagLayout());
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 0, 1, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        this.labelDataInicial.setDisplayedMnemonic('D');
        this.labelDataInicial.setLabelFor(this.textDataInicial);
        panelFiltroData.add((Component)this.labelDataInicial, c);
        c.gridx += 2;
        c.insets = new Insets(1, 20, 1, 0);
        this.labelDataFinal.setDisplayedMnemonic('i');
        this.labelDataFinal.setLabelFor(this.textDataFinal);
        panelFiltroData.add((Component)this.labelDataFinal, c);
        c.gridx += 2;
        c.gridwidth = 1;
        this.labelHoraInicial.setDisplayedMnemonic('r');
        this.labelHoraInicial.setLabelFor(this.textHoraInicial);
        panelFiltroData.add((Component)this.labelHoraInicial, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.labelHoraFinal.setDisplayedMnemonic('a');
        this.labelHoraFinal.setLabelFor(this.textHoraFinal);
        panelFiltroData.add((Component)this.labelHoraFinal, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = new Insets(1, 0, 1, 0);
        d = new Dimension(90, 20);
        this.textDataInicial.setPreferredSize(d);
        this.textDataInicial.setMinimumSize(d);
        this.textDataInicial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    TransferenciaPagamento.this.buttonDataInicial.doClick();
                }
            }
        });
        panelFiltroData.add((Component)this.textDataInicial, c);
        ++c.gridx;
        d = new Dimension(20, 20);
        this.buttonDataInicial.setPreferredSize(d);
        this.buttonDataInicial.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonDataInicial);
        this.buttonDataInicial.setFocusable(false);
        this.buttonDataInicial.addActionListener(this);
        panelFiltroData.add((Component)this.buttonDataInicial, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 1, 0);
        d = new Dimension(90, 20);
        this.textDataFinal.setPreferredSize(d);
        this.textDataFinal.setMinimumSize(d);
        this.textDataFinal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    TransferenciaPagamento.this.buttonDataFinal.doClick();
                }
            }
        });
        panelFiltroData.add((Component)this.textDataFinal, c);
        ++c.gridx;
        c.insets = new Insets(1, 0, 1, 0);
        d = new Dimension(20, 20);
        this.buttonDataFinal.setPreferredSize(d);
        this.buttonDataFinal.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonDataFinal);
        this.buttonDataFinal.setFocusable(false);
        this.buttonDataFinal.addActionListener(this);
        panelFiltroData.add((Component)this.buttonDataFinal, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 1, 0);
        d = new Dimension(60, 20);
        this.textHoraInicial.setPreferredSize(d);
        this.textHoraInicial.setMinimumSize(d);
        panelFiltroData.add((Component)this.textHoraInicial, c);
        ++c.gridx;
        c.gridwidth = 2;
        d = new Dimension(60, 20);
        this.textHoraFinal.setPreferredSize(d);
        this.textHoraFinal.setMinimumSize(d);
        panelFiltroData.add((Component)this.textHoraFinal, c);
        c.gridx += 2;
        c.gridwidth = 1;
        this.checkIntervaloHora.setMnemonic('v');
        panelFiltroData.add((Component)this.checkIntervaloHora, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        panelFiltroData.add((Component)new JLabel(), c);
        JPanel panelFiltroOutros = new JPanel(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.insets = new Insets(1, 0, 1, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.anchor = 17;
        this.labelTipoPagamento.setDisplayedMnemonic('g');
        this.labelTipoPagamento.setLabelFor(this.comboTipoPagamento);
        panelFiltroOutros.add((Component)this.labelTipoPagamento, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 1, 0);
        this.labelUsuario.setDisplayedMnemonic('U');
        this.labelUsuario.setLabelFor(this.textUsuario);
        panelFiltroOutros.add((Component)this.labelUsuario, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.insets = new Insets(1, 0, 1, 0);
        d = new Dimension(150, 20);
        this.comboTipoPagamento.setPreferredSize(d);
        this.comboTipoPagamento.setMinimumSize(d);
        panelFiltroOutros.add((Component)this.comboTipoPagamento, c);
        ++c.gridx;
        c.fill = 0;
        c.insets = new Insets(1, 20, 1, 0);
        d = new Dimension(100, 20);
        this.textUsuario.setPreferredSize(d);
        this.textUsuario.setMinimumSize(d);
        panelFiltroOutros.add((Component)this.textUsuario, c);
        this.textUsuario.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    TransferenciaPagamento.this.buttonUsuario.doClick();
                }
            }
        });
        this.textUsuario.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TransferenciaPagamento.this.carregaUsuario();
            }
        });
        ++c.gridx;
        c.insets = new Insets(1, 0, 1, 0);
        d = new Dimension(20, 20);
        this.buttonUsuario.setPreferredSize(d);
        this.buttonUsuario.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonUsuario);
        this.buttonUsuario.setFocusable(false);
        this.buttonUsuario.addActionListener(this);
        panelFiltroOutros.add((Component)this.buttonUsuario, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        d = new Dimension(20, 20);
        this.labelDescUsuario.setPreferredSize(d);
        this.labelDescUsuario.setMinimumSize(d);
        panelFiltroOutros.add((Component)this.labelDescUsuario, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.buttonBuscar.setMnemonic('l');
        this.buttonBuscar.setPreferredSize(new Dimension(100, 20));
        this.buttonBuscar.addActionListener(this);
        panelFiltroOutros.add((Component)this.buttonBuscar, c);
        this.panelFiltros.setBorder(new TitledBorder("Filtros"));
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.panelFiltros.add((Component)panelFiltroData, c);
        ++c.gridy;
        this.panelFiltros.add((Component)panelFiltroOutros, c);
        this.panelDetalhesTransferencia.setBorder(new TitledBorder("Detalhes da Transfer\u00eancia"));
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.panelDetalhesTransferencia.add((Component)this.panelDetalhesDestino, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 0, 1, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelContaDestino.setDisplayedMnemonic('t');
        this.labelContaDestino.setLabelFor(this.textContaDestino);
        this.panelDetalhesDestino.add((Component)this.labelContaDestino, c);
        ++c.gridx;
        d = new Dimension(80, 20);
        this.textContaDestino.setPreferredSize(d);
        this.textContaDestino.setMinimumSize(d);
        this.textContaDestino.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    TransferenciaPagamento.this.buttonContaDestino.doClick();
                }
            }
        });
        this.textContaDestino.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TransferenciaPagamento.this.getContaDestino();
            }
        });
        this.panelDetalhesDestino.add((Component)this.textContaDestino, c);
        ++c.gridx;
        d = new Dimension(20, 20);
        this.buttonContaDestino.setPreferredSize(d);
        this.buttonContaDestino.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonContaDestino);
        this.buttonContaDestino.setFocusable(false);
        this.buttonContaDestino.addActionListener(this);
        this.panelDetalhesDestino.add((Component)this.buttonContaDestino, c);
        ++c.gridx;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.fill = 2;
        d = new Dimension(20, 20);
        this.labelDescContaDestino.setPreferredSize(d);
        this.labelDescContaDestino.setMinimumSize(d);
        this.panelDetalhesDestino.add((Component)this.labelDescContaDestino, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.gridx = 0;
        c.weightx = 0.0;
        this.labelHistoricoDestino.setDisplayedMnemonic('H');
        this.labelHistoricoDestino.setLabelFor(this.textHistoricoDestino);
        this.panelDetalhesDestino.add((Component)this.labelHistoricoDestino, c);
        ++c.gridx;
        d = new Dimension(80, 20);
        this.textHistoricoDestino.setPreferredSize(d);
        this.textHistoricoDestino.setMinimumSize(d);
        this.textHistoricoDestino.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    TransferenciaPagamento.this.buttonHistoricoDestino.doClick();
                }
            }
        });
        this.textHistoricoDestino.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TransferenciaPagamento.this.getHistoricoDestino();
            }
        });
        this.panelDetalhesDestino.add((Component)this.textHistoricoDestino, c);
        ++c.gridx;
        d = new Dimension(20, 20);
        this.buttonHistoricoDestino.setPreferredSize(d);
        this.buttonHistoricoDestino.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonHistoricoDestino);
        this.buttonHistoricoDestino.setFocusable(false);
        this.buttonHistoricoDestino.addActionListener(this);
        this.panelDetalhesDestino.add((Component)this.buttonHistoricoDestino, c);
        ++c.gridx;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.fill = 2;
        d = new Dimension(20, 20);
        this.labelDescHistoricoDestino.setPreferredSize(d);
        this.labelDescHistoricoDestino.setMinimumSize(d);
        this.panelDetalhesDestino.add((Component)this.labelDescHistoricoDestino, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.gridx = 0;
        c.weightx = 0.0;
        this.labelDescricaoHistoricoDestino.setDisplayedMnemonic('e');
        this.labelDescricaoHistoricoDestino.setLabelFor(this.textDescricaoHistoricoDestino);
        this.panelDetalhesDestino.add((Component)this.labelDescricaoHistoricoDestino, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 3;
        d = new Dimension(20, 20);
        this.textDescricaoHistoricoDestino.setPreferredSize(d);
        this.textDescricaoHistoricoDestino.setMinimumSize(d);
        this.panelDetalhesDestino.add((Component)this.textDescricaoHistoricoDestino, c);
        TableModelListener tableListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TransferenciaPagamento.this.atualizaTotalizadores();
            }
        };
        this.modeloCartaoDebitoCredito.addTableModelListener(tableListener);
        this.modeloChequeCaucao.addTableModelListener(tableListener);
        this.modeloChequeTerceiro.addTableModelListener(tableListener);
        this.modeloChequePre.addTableModelListener(tableListener);
        this.modeloDinheiro.addTableModelListener(tableListener);
        this.modeloPromissoria.addTableModelListener(tableListener);
        this.modeloAutorizacaoDebito.addTableModelListener(tableListener);
        this.modeloDepositoBancario.addTableModelListener(tableListener);
        this.modeloBoleto.addTableModelListener(tableListener);
        this.modeloTransferencia.addTableModelListener(tableListener);
        this.modeloPix.addTableModelListener(tableListener);
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    @Override
    protected void controlaCampos() {
        boolean enabled = this.getStatus() == 2;
        this.textConta.setEnabled(enabled);
        this.buttonConta.setEnabled(enabled);
        this.textDataInicial.setEditable(enabled);
        this.textDataFinal.setEnabled(enabled);
        this.comboTipoPagamento.setEnabled(enabled);
        this.buttonBuscar.setEnabled(enabled);
        this.textContaDestino.setEnabled(enabled);
        this.textHistoricoDestino.setEnabled(enabled);
        this.buttonDataInicial.setEnabled(enabled);
        this.buttonDataFinal.setEnabled(enabled);
        this.buttonContaDestino.setEnabled(enabled);
        this.buttonHistoricoDestino.setEnabled(enabled);
        this.textHoraInicial.setEnabled(enabled);
        this.textHoraFinal.setEnabled(enabled);
        this.textUsuario.setEnabled(enabled);
        this.buttonUsuario.setEnabled(enabled);
        this.checkIntervaloHora.setEnabled(enabled);
        boolean ativaDescricaoHistorico = enabled && this.historicoDestinoAux != null && this.historicoDestinoAux.getPermiteDescrever() != null && this.historicoDestinoAux.getPermiteDescrever() != false;
        this.textDescricaoHistoricoDestino.setEnabled(ativaDescricaoHistorico);
        if (!ativaDescricaoHistorico && this.textDescricaoHistoricoDestino.isFocusable()) {
            this.textDescricaoHistoricoDestino.transferFocus();
        }
    }

    private void buscaUsuario(String filial, String codUsuario) {
        if (Funcoes.textoVazio(codUsuario) || Funcoes.textoVazio(filial)) {
            this.textUsuario.clear();
            this.labelDescUsuario.setText("");
            return;
        }
        try {
            UsuarioVO vo = (UsuarioVO)new UsuarioService().getVO(filial, codUsuario);
            if (vo != null) {
                this.textUsuario.setText(String.valueOf(vo.getCodigo()));
                this.labelDescUsuario.setText(vo.getNome());
            } else {
                this.labelDescUsuario.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Usu\u00e1rio n\u00e3o reconhecido", e.getStackTrace());
            this.textUsuario.clear();
            this.labelDescUsuario.setText("");
            ScreenUtil.requisitarFoco(this.textUsuario);
        }
    }

    @Override
    protected void limparCampos() {
        this.textConta.clear();
        this.textDataInicial.clear();
        this.textDataFinal.clear();
        this.labelDescConta.setText("");
        this.comboTipoPagamento.setSelectedIndex(0);
        this.textContaDestino.clear();
        this.labelDescContaDestino.setText("");
        this.textHistoricoDestino.clear();
        this.labelDescHistoricoDestino.setText("");
        this.textDescricaoHistoricoDestino.clear();
        this.textHoraFinal.setText("");
        this.textHoraInicial.setText("");
        this.textUsuario.setText("");
        this.labelDescUsuario.setText("");
        this.checkIntervaloHora.setSelected(false);
        this.textUsuario.clear();
        this.labelDescUsuario.setText("");
        this.contaOrigemAux = null;
        this.contaDestinoAux = null;
        this.historicoDestinoAux = null;
        this.modeloCartaoDebitoCredito.clear();
        this.modeloChequeCaucao.clear();
        this.modeloChequeTerceiro.clear();
        this.modeloChequePre.clear();
        this.modeloPromissoria.clear();
        this.modeloAutorizacaoDebito.clear();
        this.modeloDinheiro.clear();
        this.modeloDepositoBancario.clear();
        this.modeloBoleto.clear();
        this.modeloTransferencia.clear();
        this.modeloPix.clear();
    }

    @Override
    @Deprecated
    protected AbstractThreadBean pesquisar() {
        return null;
    }

    @Override
    @Deprecated
    protected AbstractThreadBean getBeanPreenchido() {
        return null;
    }

    @Override
    @Deprecated
    protected void preencherCampos(AbstractThreadBean bean) {
    }

    @Override
    @Deprecated
    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    public boolean validaCampos() {
        if (this.contaOrigemAux == null) {
            Funcoes.mensagem(this, "A conta de origem deve ser selecionada.", 2);
            ScreenUtil.requisitarFoco(this.textConta);
            return false;
        }
        if (this.contaDestinoAux == null) {
            Funcoes.mensagem(this, "A conta de destino deve ser selecionada.", 2);
            ScreenUtil.requisitarFoco(this.textContaDestino);
            return false;
        }
        if (this.historicoDestinoAux == null) {
            Funcoes.mensagem(this, "O hist\u00f3rico padr\u00e3o deve ser selecionado.", 2);
            ScreenUtil.requisitarFoco(this.textHistoricoDestino);
            return false;
        }
        if (this.tablePagamentos.getModel().getRowCount() == 0) {
            Funcoes.mensagem(this, "Nenhum pagamento selecionado para transfer\u00eancia.", 2);
            return false;
        }
        boolean algumSelecionado = false;
        if (this.tablePagamentos.getModel() == this.modeloChequeCaucao) {
            for (int i = 0; i < this.modeloChequeCaucao.getRowCount(); ++i) {
                if (!((Boolean)this.modeloChequeCaucao.getValueAt(i, 6)).booleanValue()) continue;
                algumSelecionado = true;
                break;
            }
        } else if (this.tablePagamentos.getModel() == this.modeloChequeTerceiro) {
            for (int i = 0; i < this.modeloChequeTerceiro.getRowCount(); ++i) {
                if (!((Boolean)this.modeloChequeTerceiro.getValueAt(i, 7)).booleanValue()) continue;
                algumSelecionado = true;
                break;
            }
        } else if (this.tablePagamentos.getModel() == this.modeloChequePre) {
            for (int i = 0; i < this.modeloChequePre.getRowCount(); ++i) {
                if (!((Boolean)this.modeloChequePre.getValueAt(i, 7)).booleanValue()) continue;
                algumSelecionado = true;
                break;
            }
        } else if (this.tablePagamentos.getModel() == this.modeloCartaoDebitoCredito) {
            for (int i = 0; i < this.modeloCartaoDebitoCredito.getRowCount(); ++i) {
                if (!((Boolean)this.modeloCartaoDebitoCredito.getValueAt(i, 5)).booleanValue()) continue;
                algumSelecionado = true;
                break;
            }
        } else if (this.tablePagamentos.getModel() == this.modeloPromissoria) {
            for (int i = 0; i < this.modeloPromissoria.getRowCount(); ++i) {
                if (!((Boolean)this.modeloPromissoria.getValueAt(i, 3)).booleanValue()) continue;
                algumSelecionado = true;
                break;
            }
        } else if (this.tablePagamentos.getModel() == this.modeloAutorizacaoDebito) {
            for (int i = 0; i < this.modeloAutorizacaoDebito.getRowCount(); ++i) {
                if (!((Boolean)this.modeloAutorizacaoDebito.getValueAt(i, 3)).booleanValue()) continue;
                algumSelecionado = true;
                break;
            }
        } else if (this.tablePagamentos.getModel() == this.modeloDinheiro) {
            for (int i = 0; i < this.modeloDinheiro.getRowCount(); ++i) {
                if (!((Boolean)this.modeloDinheiro.getValueAt(i, 3)).booleanValue()) continue;
                algumSelecionado = true;
                break;
            }
        } else if (this.tablePagamentos.getModel() == this.modeloDepositoBancario) {
            for (int i = 0; i < this.modeloDepositoBancario.getRowCount(); ++i) {
                if (!((Boolean)this.modeloDepositoBancario.getValueAt(i, 6)).booleanValue()) continue;
                algumSelecionado = true;
                break;
            }
        } else if (this.tablePagamentos.getModel() == this.modeloBoleto) {
            for (int i = 0; i < this.modeloBoleto.getRowCount(); ++i) {
                if (!((Boolean)this.modeloBoleto.getValueAt(i, 4)).booleanValue()) continue;
                algumSelecionado = true;
                break;
            }
        } else if (this.tablePagamentos.getModel() == this.modeloTransferencia) {
            for (int i = 0; i < this.modeloTransferencia.getRowCount(); ++i) {
                if (!((Boolean)this.modeloTransferencia.getValueAt(i, 6)).booleanValue()) continue;
                algumSelecionado = true;
                break;
            }
        } else if (this.tablePagamentos.getModel() == this.modeloPix) {
            for (int i = 0; i < this.modeloPix.getRowCount(); ++i) {
                if (!((Boolean)this.modeloPix.getValueAt(i, 6)).booleanValue()) continue;
                algumSelecionado = true;
                break;
            }
        }
        if (!algumSelecionado) {
            Funcoes.mensagem(this, "Nenhum pagamento selecionado para transfer\u00eancia.", 2);
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    @Deprecated
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.textConta);
    }

    @Override
    public void cancelar() {
        this.limparCampos();
        this.setStatus(1);
        this.controlaCampos();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonConta) {
            this.pesquisaContaOrigem();
        } else if (e.getSource() == this.buttonDataInicial) {
            Funcoes.mostraData(this.textDataInicial, this.buttonDataInicial, this.panelFiltros, true);
        } else if (e.getSource() == this.buttonDataFinal) {
            Funcoes.mostraData(this.textDataFinal, this.buttonDataFinal, this.panelFiltros, true);
        } else if (e.getSource() == this.buttonBuscar) {
            this.pesquisaLancamentos();
        } else if (e.getSource() == this.buttonContaDestino) {
            this.pesquisaContaDestino();
        } else if (e.getSource() == this.buttonHistoricoDestino) {
            this.pesquisaHistoricoDestino();
        } else if (e.getSource() == this.buttonUsuario) {
            this.pesquisaUsuario();
        }
    }

    private void pesquisaUsuario() {
        UsuarioVO usuario = (UsuarioVO)new UsuarioService().pesquisaVO(Laboratorio.getInstancia(), new UsuarioVO(), "Pesquisando usu\u00e1rios", false);
        if (usuario != null) {
            this.textUsuario.setText(usuario.getCodigo());
            this.labelDescUsuario.setText(usuario.getDescricao());
        } else {
            this.textUsuario.clear();
            this.labelDescUsuario.setText("");
        }
    }

    private void carregaUsuario() {
        if (Funcoes.textoVazio(this.textUsuario)) {
            this.labelDescUsuario.setText("");
        } else {
            try {
                UsuarioVO usuario = new UsuarioService().buscaCodigo(this.textUsuario.getText());
                if (usuario != null && !Funcoes.textoVazio(usuario.getCodigo())) {
                    this.labelDescUsuario.setText(usuario.getNome());
                    this.textUsuario.setText(usuario.getCodigo());
                } else {
                    this.labelDescUsuario.setText("N\u00e3o cadastrado");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar usu\u00e1rio.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    private void getHistoricoDestino() {
        if (Funcoes.textoVazio(this.textHistoricoDestino)) {
            this.labelDescHistoricoDestino.setText("");
            this.historicoDestinoAux = null;
        } else {
            try {
                this.historicoDestinoAux = (HistoricoPadraoVO)new HistoricoPadraoService().getVO(Variaveis.filialPadrao.toString(), this.textHistoricoDestino.getText());
                if (this.historicoDestinoAux == null) {
                    this.labelDescHistoricoDestino.setText("N\u00e3o cadastrado");
                    this.textDescricaoHistoricoDestino.setText("");
                } else {
                    this.labelDescHistoricoDestino.setText(this.historicoDestinoAux.getDescricao());
                }
                this.controlaCampos();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar hist\u00f3rico de destino.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    private void pesquisaHistoricoDestino() {
        try {
            HistoricoPadraoVO historico = (HistoricoPadraoVO)new HistoricoPadraoService().pesquisaVO(this.getTopLevelAncestor(), new HistoricoPadraoVO(), "Pesquisando hist\u00f3ricos", true);
            if (historico != null) {
                this.textHistoricoDestino.setText(historico.getCodigo().toString());
                this.labelDescHistoricoDestino.setText(historico.getDescricao());
                this.historicoDestinoAux = historico;
            }
            this.controlaCampos();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel pesquisar hist\u00f3rico padr\u00e3o.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void getContaDestino() {
        if (Funcoes.textoVazio(this.textContaDestino)) {
            this.labelDescContaDestino.setText("");
            this.contaDestinoAux = null;
        } else {
            try {
                this.contaDestinoAux = (ContaCorrenteVO)new ContaCorrenteService().getVO(Variaveis.filialPadrao.toString(), this.textContaDestino.getText());
                if (this.contaDestinoAux == null) {
                    this.labelDescContaDestino.setText("N\u00e3o cadastrado");
                } else {
                    if (this.contaOrigemAux != null && this.contaOrigemAux.getReduzido().intValue() == this.contaDestinoAux.getReduzido().intValue()) {
                        Funcoes.mensagem(this, "A conta de destino deve ser diferente da conta de origem.", 2);
                        this.textContaDestino.clear();
                        this.labelDescContaDestino.setText("");
                        this.contaDestinoAux = null;
                        ScreenUtil.requisitarFoco(this.textContaDestino);
                        return;
                    }
                    this.textContaDestino.setText(this.contaDestinoAux.getReduzido().toString());
                    this.labelDescContaDestino.setText(this.contaDestinoAux.getConta());
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar conta de destino.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    private void pesquisaContaDestino() {
        try {
            ContaCorrenteVO conta = (ContaCorrenteVO)new ContaCorrenteService().pesquisaVO(Laboratorio.getInstancia(), new ContaCorrenteVO(), "Pesquisando Conta Corrente", true);
            if (conta != null) {
                if (this.contaOrigemAux != null && this.contaOrigemAux.getReduzido().intValue() == conta.getReduzido().intValue()) {
                    Funcoes.mensagem(this, "A conta de destino deve ser diferente da conta de origem.", 2);
                    return;
                }
                this.contaDestinoAux = conta;
                this.textContaDestino.setText(conta.getReduzido().toString());
                this.labelDescContaDestino.setText(conta.getConta());
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel pesquisar conta de destino.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void getContaOrigem() {
        if (Funcoes.textoVazio(this.textConta)) {
            this.labelDescConta.setText("");
            this.contaOrigemAux = null;
        } else {
            try {
                this.contaOrigemAux = (ContaCorrenteVO)new ContaCorrenteService().getVO(Variaveis.filialPadrao.toString(), this.textConta.getText());
                if (this.contaOrigemAux == null) {
                    this.labelDescConta.setText("N\u00e3o cadastrado");
                } else {
                    if (this.contaDestinoAux != null && this.contaDestinoAux.getReduzido().intValue() == this.contaOrigemAux.getReduzido().intValue()) {
                        Funcoes.mensagem(this, "A conta de origem deve ser diferente da conta de destino.", 2);
                        this.textConta.clear();
                        this.labelDescConta.setText("");
                        this.contaOrigemAux = null;
                        ScreenUtil.requisitarFoco(this.textConta);
                        return;
                    }
                    this.textConta.setText(this.contaOrigemAux.getReduzido().toString());
                    this.labelDescConta.setText(this.contaOrigemAux.getConta());
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar conta de origem.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    private void pesquisaContaOrigem() {
        try {
            ContaCorrenteVO conta = (ContaCorrenteVO)new ContaCorrenteService().pesquisaVO(Laboratorio.getInstancia(), new ContaCorrenteVO(), "Pesquisando Conta Corrente", true);
            if (conta != null) {
                if (this.contaDestinoAux != null && this.contaDestinoAux.getReduzido().intValue() == conta.getReduzido().intValue()) {
                    Funcoes.mensagem(this, "A conta de origem deve ser diferente da conta de destino.", 2);
                    return;
                }
                this.contaOrigemAux = conta;
                this.textConta.setText(conta.getReduzido().toString());
                this.labelDescConta.setText(conta.getConta());
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel pesquisar conta de origem.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pesquisaLancamentos() {
        if (this.contaOrigemAux == null) {
            Funcoes.mensagem(this, "\u00c9 necess\u00e1rio selecionar a conta de origem.", 2);
            ScreenUtil.requisitarFoco(this.textConta);
            return;
        }
        if (this.labelDescUsuario.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Usu\u00e1rio n\u00e3o cadastrado.", 2);
            ScreenUtil.requisitarFoco(this.textUsuario);
            return;
        }
        if (Funcoes.textoVazio(this.textDataInicial)) {
            Funcoes.mensagem(this, "\u00c9 necess\u00e1rio informar a data inicial.", 2);
            ScreenUtil.requisitarFoco(this.textDataInicial);
            return;
        }
        if (!Funcoes.textoVazio(this.textDataFinal) && Funcoes.getData("dd/MM/yyyy", this.textDataFinal.getText()).compareTo(Funcoes.getData("dd/MM/yyyy", this.textDataInicial.getText())) < 0) {
            Funcoes.mensagem(this, "A data final n\u00e3o pode ser anterior \u00e0 data inicial.", 2);
            ScreenUtil.requisitarFoco(this.textDataFinal);
            return;
        }
        TiposPagamento pagamento = (TiposPagamento)((Object)this.comboTipoPagamento.getSelectedItem());
        this.atualizaModelo(pagamento);
        StringBuilder buf = new StringBuilder();
        buf.append(" select lcx.lcx_datahora as  datahora ");
        buf.append("       ,lcx.usr_codigo as usuario ");
        buf.append("       ,lcx.lcx_valortotal as valortotal ");
        buf.append("       ,COALESCE(req.req_codigo, bxa.bxa_codigo) as codigoorigem ");
        buf.append("       ,lcx.lcx_banco as bancocheque ");
        buf.append("       ,lcx.lcx_agencia as agenciacheque ");
        buf.append("       ,lcx.lcx_conta as contacheque ");
        buf.append("       ,lcx.lcx_nrcheque as numerocheque ");
        buf.append("       ,lcx.lcx_vencimento as vencimentocheque ");
        buf.append("       ,lcx.lcx_cartaocredito as bandeiracartao ");
        buf.append("       ,lcx.lcx_nrcartao as numerocartao ");
        buf.append("       ,lcx.lcx_validadecartao as validadecartao ");
        buf.append("       ,lcx.lcx_documento as numeropromissoria ");
        buf.append("       ,lcx.lcx_codigo as codigoLancamento ");
        buf.append("       ,lcx.est_codigo as codigoEstacao ");
        buf.append("       ,lcx.lcx_tipotransferencia as transferencia ");
        buf.append("       ,lcx.lcx_pix as pix ");
        buf.append("   from lanctocaixa lcx ");
        buf.append("   left join requisicaolanctocaixa rlc on lcx.fil_codigo = rlc.fil_codigo and lcx.lcx_codigo = rlc.lcx_codigo and lcx.est_codigo = rlc.est_codigo ");
        buf.append("   left join requisicao req on rlc.fil_codigo = req.fil_codigo and rlc.req_codigo = req.req_codigo and not req.req_excluida ");
        buf.append("   left join baixalanctocaixa blc on lcx.fil_codigo = blc.fil_codigo and lcx.lcx_codigo = blc.lcx_codigo and lcx.est_codigo = blc.est_codigo ");
        buf.append("   left join baixa bxa on blc.fil_codigo = bxa.fil_codigo and blc.bxa_codigo = bxa.bxa_codigo and bxa.bxa_datacancelado IS NULL ");
        buf.append("  where lcx.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("    and lcx.lcx_tipo = '").append("C").append("' ");
        buf.append("    and lcx.lcx_datacancelado IS NULL ");
        if (pagamento != TiposPagamento.Dinheiro && pagamento != TiposPagamento.Automatico && pagamento != TiposPagamento.OnLine && pagamento != TiposPagamento.DescontoFolha) {
            buf.append("    and lcx.lcx_situacao = '").append("A").append("' ");
        }
        buf.append("    and lcx.lcx_tipopagamento = '").append(pagamento.getCodigo()).append("' ");
        buf.append("    and cco_reduzido = ").append(this.contaOrigemAux.getReduzido());
        String dataInicial = this.textDataInicial.getText();
        String dataFinal = this.textDataFinal.getText();
        String horaInicial = this.textHoraInicial.getText();
        String horaFinal = this.textHoraFinal.getText();
        if (this.checkIntervaloHora.isSelected()) {
            if (Funcoes.verificaData(dataInicial) && Funcoes.verificaHora(horaInicial)) {
                buf.append(" and date_trunc('minute', lcx.lcx_datahora) >= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append(" ").append(horaInicial);
                buf.append("'");
            }
            if (Funcoes.verificaData(dataFinal) && Funcoes.verificaHora(horaFinal)) {
                buf.append(" and date_trunc('minute', lcx.lcx_datahora) <= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append(" ").append(horaFinal);
                buf.append("'");
            }
        } else {
            if (Funcoes.verificaData(dataInicial)) {
                buf.append(" and cast(lcx.lcx_datahora as date) >= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", dataInicial));
                buf.append("'");
            }
            if (Funcoes.verificaData(dataFinal)) {
                buf.append(" and cast(lcx.lcx_datahora as date) <= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", dataFinal));
                buf.append("'");
            }
            if (Funcoes.verificaHora(horaInicial)) {
                buf.append(" and cast(lcx.lcx_datahora as time) >= '");
                buf.append(horaInicial);
                buf.append("'");
            }
            if (Funcoes.verificaHora(horaFinal)) {
                buf.append(" and cast(lcx.lcx_datahora as time) <= '");
                buf.append(horaFinal);
                buf.append("'");
            }
        }
        if (!Funcoes.textoVazio(this.textUsuario)) {
            buf.append("    and lcx.usr_codigo = '").append(this.textUsuario.getText()).append("' ");
        }
        buf.append("  order by lcx.lcx_codigo ");
        Statement st = Conexao.getStatement();
        try {
            this.preencheDados(pagamento, Conexao.executeQuery(st, buf.toString()));
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os pagamentos.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private void preencheDados(TiposPagamento pagamento, ResultSet rs) {
        this.modeloChequeCaucao.clear();
        this.modeloChequePre.clear();
        this.modeloChequeTerceiro.clear();
        this.modeloCartaoDebitoCredito.clear();
        this.modeloPromissoria.clear();
        this.modeloAutorizacaoDebito.clear();
        this.modeloDinheiro.clear();
        this.modeloDepositoBancario.clear();
        this.modeloBoleto.clear();
        this.modeloTransferencia.clear();
        this.modeloPix.clear();
        if (pagamento == null) {
            return;
        }
        try {
            while (rs.next()) {
                if (pagamento.equals((Object)TiposPagamento.Cheque) || pagamento.equals((Object)TiposPagamento.ChequeCaucao)) {
                    this.modeloChequeCaucao.addLine(new Object[]{Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("datahora")), Funcoes.formataDecimal(rs.getDouble("valortotal")), rs.getInt("bancocheque"), rs.getString("agenciacheque"), rs.getString("contacheque"), rs.getString("numerocheque"), false, rs.getInt("codigoLancamento"), rs.getInt("codigoEstacao"), rs.getBigDecimal("valortotal")});
                    continue;
                }
                if (pagamento.equals((Object)TiposPagamento.CHEQUETERCEIRO)) {
                    this.modeloChequeTerceiro.addLine(new Object[]{Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("datahora")), Funcoes.formataDecimal(rs.getDouble("valortotal")), rs.getInt("bancocheque"), rs.getString("agenciacheque"), rs.getString("contacheque"), rs.getString("numerocheque"), Funcoes.formataData(rs.getDate("vencimentocheque")), false, rs.getInt("codigoLancamento"), rs.getInt("codigoEstacao"), rs.getBigDecimal("valortotal")});
                    continue;
                }
                if (pagamento.equals((Object)TiposPagamento.ChequePreDatado)) {
                    this.modeloChequePre.addLine(new Object[]{Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("datahora")), Funcoes.formataDecimal(rs.getDouble("valortotal")), rs.getInt("bancocheque"), rs.getString("agenciacheque"), rs.getString("contacheque"), rs.getString("numerocheque"), Funcoes.formataData(rs.getDate("vencimentocheque")), false, rs.getInt("codigoLancamento"), rs.getInt("codigoEstacao"), rs.getBigDecimal("valortotal")});
                    continue;
                }
                if (pagamento.equals((Object)TiposPagamento.CartaoDebito) || pagamento.equals((Object)TiposPagamento.CartaoCredito)) {
                    this.modeloCartaoDebitoCredito.addLine(new Object[]{Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("datahora")), Funcoes.formataDecimal(rs.getDouble("valortotal")), rs.getString("bandeiracartao"), rs.getString("numerocartao"), Funcoes.formataData("MM/yy", rs.getDate("validadecartao")), false, rs.getInt("codigoLancamento"), rs.getInt("codigoEstacao"), rs.getBigDecimal("valortotal")});
                    continue;
                }
                if (pagamento.equals((Object)TiposPagamento.Promissoria)) {
                    this.modeloPromissoria.addLine(new Object[]{Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("datahora")), Funcoes.formataDecimal(rs.getDouble("valortotal")), rs.getString("numeropromissoria"), false, rs.getInt("codigoLancamento"), rs.getInt("codigoEstacao"), rs.getBigDecimal("valortotal")});
                    continue;
                }
                if (pagamento.equals((Object)TiposPagamento.AUTORIZACAODEBITO)) {
                    this.modeloAutorizacaoDebito.addLine(new Object[]{Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("datahora")), Funcoes.formataDecimal(rs.getDouble("valortotal")), rs.getString("numeropromissoria"), false, rs.getInt("codigoLancamento"), rs.getInt("codigoEstacao"), rs.getBigDecimal("valortotal")});
                    continue;
                }
                if (pagamento.equals((Object)TiposPagamento.Dinheiro) || pagamento.equals((Object)TiposPagamento.Automatico) || pagamento.equals((Object)TiposPagamento.OnLine) || pagamento.equals((Object)TiposPagamento.DescontoFolha)) {
                    this.modeloDinheiro.addLine(new Object[]{Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("datahora")), Funcoes.formataDecimal(rs.getDouble("valortotal")), rs.getString("usuario"), false, rs.getInt("codigoLancamento"), rs.getInt("codigoEstacao"), rs.getBigDecimal("valortotal")});
                    continue;
                }
                if (pagamento.equals((Object)TiposPagamento.DEPOSITO)) {
                    this.modeloDepositoBancario.addLine(new Object[]{Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("datahora")), Funcoes.formataDecimal(rs.getDouble("valortotal")), rs.getInt("bancocheque"), rs.getString("agenciacheque"), rs.getString("contacheque"), Funcoes.formataData("dd/MM/yyyy", rs.getDate("vencimentocheque")), false, rs.getInt("codigoLancamento"), rs.getInt("codigoEstacao"), rs.getBigDecimal("valortotal")});
                    continue;
                }
                if (pagamento.equals((Object)TiposPagamento.BOLETO)) {
                    this.modeloBoleto.addLine(new Object[]{Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("datahora")), Funcoes.formataDecimal(rs.getDouble("valortotal")), rs.getString("numeropromissoria"), Funcoes.formataData("dd/MM/yyyy", rs.getDate("vencimentocheque")), false, rs.getInt("codigoLancamento"), rs.getInt("codigoEstacao"), rs.getBigDecimal("valortotal")});
                    continue;
                }
                if (pagamento.equals((Object)TiposPagamento.TRANSFERENCIA)) {
                    this.modeloTransferencia.addLine(new Object[]{Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("datahora")), Funcoes.formataDecimal(rs.getDouble("valortotal")), rs.getInt("bancocheque"), rs.getString("agenciacheque"), rs.getString("contacheque"), rs.getString("transferencia"), false, rs.getInt("codigoLancamento"), rs.getInt("codigoEstacao"), rs.getBigDecimal("valortotal")});
                    continue;
                }
                if (!pagamento.equals((Object)TiposPagamento.PIX)) continue;
                this.modeloPix.addLine(new Object[]{Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("datahora")), Funcoes.formataDecimal(rs.getDouble("valortotal")), rs.getInt("bancocheque"), rs.getString("agenciacheque"), rs.getString("contacheque"), rs.getString("pix"), false, rs.getInt("codigoLancamento"), rs.getInt("codigoEstacao"), rs.getBigDecimal("valortotal")});
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel preencher dados dos pagamentos.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void atualizaModelo(TiposPagamento pagamento) {
        this.tablePagamentos.getTableHeader().removeMouseListener(this.modeloChequeCaucao);
        this.tablePagamentos.getTableHeader().removeMouseListener(this.modeloChequePre);
        this.tablePagamentos.getTableHeader().removeMouseListener(this.modeloChequeTerceiro);
        this.tablePagamentos.getTableHeader().removeMouseListener(this.modeloCartaoDebitoCredito);
        this.tablePagamentos.getTableHeader().removeMouseListener(this.modeloPromissoria);
        this.tablePagamentos.getTableHeader().removeMouseListener(this.modeloAutorizacaoDebito);
        this.tablePagamentos.getTableHeader().removeMouseListener(this.modeloDinheiro);
        this.tablePagamentos.getTableHeader().removeMouseListener(this.modeloDepositoBancario);
        this.tablePagamentos.getTableHeader().removeMouseListener(this.modeloBoleto);
        this.tablePagamentos.getTableHeader().removeMouseListener(this.modeloTransferencia);
        this.tablePagamentos.getTableHeader().removeMouseListener(this.modeloPix);
        if (pagamento == null) {
            this.tablePagamentos.setModel(new ModeloGridTable(new String[0]));
        } else if (pagamento.equals((Object)TiposPagamento.Cheque) || pagamento.equals((Object)TiposPagamento.ChequeCaucao)) {
            this.tablePagamentos.setModel(this.modeloChequeCaucao);
            this.modeloChequeCaucao.setColumnSize(new int[]{135, 80, 70, 0, 0, 0, 20}, this.tablePagamentos);
            this.tablePagamentos.getTableHeader().addMouseListener(this.modeloChequeCaucao);
        } else if (pagamento.equals((Object)TiposPagamento.ChequePreDatado)) {
            this.tablePagamentos.setModel(this.modeloChequePre);
            this.modeloChequePre.setColumnSize(new int[]{135, 80, 70, 0, 0, 0, 90, 20}, this.tablePagamentos);
            this.tablePagamentos.getTableHeader().addMouseListener(this.modeloChequePre);
        } else if (pagamento.equals((Object)TiposPagamento.CHEQUETERCEIRO)) {
            this.tablePagamentos.setModel(this.modeloChequeTerceiro);
            this.modeloChequeTerceiro.setColumnSize(new int[]{135, 80, 70, 0, 0, 0, 90, 20}, this.tablePagamentos);
            this.tablePagamentos.getTableHeader().addMouseListener(this.modeloChequeTerceiro);
        } else if (pagamento.equals((Object)TiposPagamento.CartaoDebito) || pagamento.equals((Object)TiposPagamento.CartaoCredito)) {
            this.tablePagamentos.setModel(this.modeloCartaoDebitoCredito);
            this.modeloCartaoDebitoCredito.setColumnSize(new int[]{135, 80, 0, 0, 80, 20}, this.tablePagamentos);
            this.tablePagamentos.getTableHeader().addMouseListener(this.modeloCartaoDebitoCredito);
        } else if (pagamento.equals((Object)TiposPagamento.Promissoria)) {
            this.tablePagamentos.setModel(this.modeloPromissoria);
            this.modeloPromissoria.setColumnSize(new int[]{135, 80, 0, 20}, this.tablePagamentos);
            this.tablePagamentos.getTableHeader().addMouseListener(this.modeloPromissoria);
        } else if (pagamento.equals((Object)TiposPagamento.AUTORIZACAODEBITO)) {
            this.tablePagamentos.setModel(this.modeloAutorizacaoDebito);
            this.modeloAutorizacaoDebito.setColumnSize(new int[]{135, 80, 0, 20}, this.tablePagamentos);
            this.tablePagamentos.getTableHeader().addMouseListener(this.modeloAutorizacaoDebito);
        } else if (pagamento.equals((Object)TiposPagamento.Dinheiro) || pagamento.equals((Object)TiposPagamento.OnLine) || pagamento.equals((Object)TiposPagamento.Automatico) || pagamento.equals((Object)TiposPagamento.DescontoFolha)) {
            this.tablePagamentos.setModel(this.modeloDinheiro);
            this.modeloDinheiro.setColumnSize(new int[]{135, 80, 0, 20}, this.tablePagamentos);
            this.tablePagamentos.getTableHeader().addMouseListener(this.modeloDinheiro);
        } else if (pagamento.equals((Object)TiposPagamento.DEPOSITO)) {
            this.tablePagamentos.setModel(this.modeloDepositoBancario);
            this.modeloDepositoBancario.setColumnSize(new int[]{135, 80, 70, 0, 0, 90, 20}, this.tablePagamentos);
            this.tablePagamentos.getTableHeader().addMouseListener(this.modeloDepositoBancario);
        } else if (pagamento.equals((Object)TiposPagamento.BOLETO)) {
            this.tablePagamentos.setModel(this.modeloBoleto);
            this.modeloBoleto.setColumnSize(new int[]{135, 80, 0, 90, 20}, this.tablePagamentos);
            this.tablePagamentos.getTableHeader().addMouseListener(this.modeloBoleto);
        } else if (pagamento.equals((Object)TiposPagamento.TRANSFERENCIA)) {
            this.tablePagamentos.setModel(this.modeloTransferencia);
            this.modeloTransferencia.setColumnSize(new int[]{135, 80, 70, 0, 0, 95, 20}, this.tablePagamentos);
            this.tablePagamentos.getTableHeader().addMouseListener(this.modeloTransferencia);
        } else if (pagamento.equals((Object)TiposPagamento.PIX)) {
            this.tablePagamentos.setModel(this.modeloPix);
            this.modeloPix.setColumnSize(new int[]{135, 80, 70, 0, 0, 95, 20}, this.tablePagamentos);
            this.tablePagamentos.getTableHeader().addMouseListener(this.modeloPix);
        }
    }

    private ArrayList<Point> getLancamentosSelecionados() {
        ArrayList<Point> lancamentos;
        block12: {
            block21: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        block14: {
                                            block13: {
                                                block11: {
                                                    lancamentos = new ArrayList<Point>();
                                                    if (this.tablePagamentos.getModel() != this.modeloChequeCaucao) break block11;
                                                    for (int i = 0; i < this.modeloChequeCaucao.getRowCount(); ++i) {
                                                        if (!((Boolean)this.modeloChequeCaucao.getValueAt(i, 6)).booleanValue()) continue;
                                                        lancamentos.add(new Point((Integer)this.modeloChequeCaucao.getValueAt(i, 7), (Integer)this.modeloChequeCaucao.getValueAt(i, 8)));
                                                    }
                                                    break block12;
                                                }
                                                if (this.tablePagamentos.getModel() != this.modeloChequePre) break block13;
                                                for (int i = 0; i < this.modeloChequePre.getRowCount(); ++i) {
                                                    if (!((Boolean)this.modeloChequePre.getValueAt(i, 7)).booleanValue()) continue;
                                                    lancamentos.add(new Point((Integer)this.modeloChequePre.getValueAt(i, 8), (Integer)this.modeloChequePre.getValueAt(i, 9)));
                                                }
                                                break block12;
                                            }
                                            if (this.tablePagamentos.getModel() != this.modeloChequeTerceiro) break block14;
                                            for (int i = 0; i < this.modeloChequeTerceiro.getRowCount(); ++i) {
                                                if (!((Boolean)this.modeloChequeTerceiro.getValueAt(i, 7)).booleanValue()) continue;
                                                lancamentos.add(new Point((Integer)this.modeloChequeTerceiro.getValueAt(i, 8), (Integer)this.modeloChequeTerceiro.getValueAt(i, 9)));
                                            }
                                            break block12;
                                        }
                                        if (this.tablePagamentos.getModel() != this.modeloCartaoDebitoCredito) break block15;
                                        for (int i = 0; i < this.modeloCartaoDebitoCredito.getRowCount(); ++i) {
                                            if (!((Boolean)this.modeloCartaoDebitoCredito.getValueAt(i, 5)).booleanValue()) continue;
                                            lancamentos.add(new Point((Integer)this.modeloCartaoDebitoCredito.getValueAt(i, 6), (Integer)this.modeloCartaoDebitoCredito.getValueAt(i, 7)));
                                        }
                                        break block12;
                                    }
                                    if (this.tablePagamentos.getModel() != this.modeloPromissoria) break block16;
                                    for (int i = 0; i < this.modeloPromissoria.getRowCount(); ++i) {
                                        if (!((Boolean)this.modeloPromissoria.getValueAt(i, 3)).booleanValue()) continue;
                                        lancamentos.add(new Point((Integer)this.modeloPromissoria.getValueAt(i, 4), (Integer)this.modeloPromissoria.getValueAt(i, 5)));
                                    }
                                    break block12;
                                }
                                if (this.tablePagamentos.getModel() != this.modeloAutorizacaoDebito) break block17;
                                for (int i = 0; i < this.modeloAutorizacaoDebito.getRowCount(); ++i) {
                                    if (!((Boolean)this.modeloAutorizacaoDebito.getValueAt(i, 3)).booleanValue()) continue;
                                    lancamentos.add(new Point((Integer)this.modeloAutorizacaoDebito.getValueAt(i, 4), (Integer)this.modeloAutorizacaoDebito.getValueAt(i, 5)));
                                }
                                break block12;
                            }
                            if (this.tablePagamentos.getModel() != this.modeloDinheiro) break block18;
                            for (int i = 0; i < this.modeloDinheiro.getRowCount(); ++i) {
                                if (!((Boolean)this.modeloDinheiro.getValueAt(i, 3)).booleanValue()) continue;
                                lancamentos.add(new Point((Integer)this.modeloDinheiro.getValueAt(i, 4), (Integer)this.modeloDinheiro.getValueAt(i, 5)));
                            }
                            break block12;
                        }
                        if (this.tablePagamentos.getModel() != this.modeloDepositoBancario) break block19;
                        for (int i = 0; i < this.modeloDepositoBancario.getRowCount(); ++i) {
                            if (!((Boolean)this.modeloDepositoBancario.getValueAt(i, 6)).booleanValue()) continue;
                            lancamentos.add(new Point((Integer)this.modeloDepositoBancario.getValueAt(i, 7), (Integer)this.modeloDepositoBancario.getValueAt(i, 8)));
                        }
                        break block12;
                    }
                    if (this.tablePagamentos.getModel() != this.modeloBoleto) break block20;
                    for (int i = 0; i < this.modeloBoleto.getRowCount(); ++i) {
                        if (!((Boolean)this.modeloBoleto.getValueAt(i, 4)).booleanValue()) continue;
                        lancamentos.add(new Point((Integer)this.modeloBoleto.getValueAt(i, 5), (Integer)this.modeloBoleto.getValueAt(i, 6)));
                    }
                    break block12;
                }
                if (this.tablePagamentos.getModel() != this.modeloTransferencia) break block21;
                for (int i = 0; i < this.modeloTransferencia.getRowCount(); ++i) {
                    if (!((Boolean)this.modeloTransferencia.getValueAt(i, 6)).booleanValue()) continue;
                    lancamentos.add(new Point((Integer)this.modeloTransferencia.getValueAt(i, 7), (Integer)this.modeloTransferencia.getValueAt(i, 8)));
                }
                break block12;
            }
            if (this.tablePagamentos.getModel() != this.modeloPix) break block12;
            for (int i = 0; i < this.modeloPix.getRowCount(); ++i) {
                if (!((Boolean)this.modeloPix.getValueAt(i, 6)).booleanValue()) continue;
                lancamentos.add(new Point((Integer)this.modeloPix.getValueAt(i, 7), (Integer)this.modeloPix.getValueAt(i, 8)));
            }
        }
        return lancamentos;
    }

    @Override
    public void salvar() {
        if (this.validaCampos()) {
            LancamentoService lanctoService = new LancamentoService();
            RequisicaoLanctoCaixaService reqLanctoService = new RequisicaoLanctoCaixaService();
            ArrayList<LancamentoBean> lancamentos = new ArrayList<LancamentoBean>();
            ArrayList<Point> lancamentosCodigos = this.getLancamentosSelecionados();
            if (lancamentosCodigos != null) {
                for (Point codigo : lancamentosCodigos) {
                    try {
                        lancamentos.add((LancamentoBean)lanctoService.get(Variaveis.filialPadrao.toString(), String.valueOf(codigo.x), String.valueOf(codigo.y)));
                    }
                    catch (Exception e) {
                        ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar informa\u00e7\u00f5es dos lan\u00e7amentos.\n" + e.getMessage(), e.getStackTrace());
                    }
                }
            }
            try {
                UsuarioVO usuarioCancelamento = new UsuarioVO();
                usuarioCancelamento.setCodigo(Variaveis.login);
                Date data = new Date();
                for (LancamentoBean aux : lancamentos) {
                    Integer codigoRequisicao = lanctoService.getRequisicaoOrigem(aux);
                    String situacaoAnterior = aux.getSituacao();
                    Integer codigoLancamento = aux.getCodigo();
                    Integer codigoLancamentoComplemento = aux.getComplementarCodigo();
                    Integer codigoEstacao = aux.getEstacao().getCodigo();
                    EstacaoVO ComplementarEstacao = aux.getComplementarEstacao();
                    lanctoService.estornoCancelamento(aux, "P", false, null);
                    Integer codigoAux = aux.getCodigo();
                    EstacaoVO estacaoAux = aux.getEstacao();
                    aux.setCodigo(null);
                    if (codigoLancamentoComplemento != null && codigoLancamentoComplemento > 0) {
                        aux.setComplementarCodigo(codigoLancamentoComplemento);
                    } else {
                        aux.setComplementarCodigo(codigoLancamento);
                    }
                    if (ComplementarEstacao != null) {
                        aux.setComplementarEstacao(ComplementarEstacao);
                    } else {
                        aux.setComplementarEstacao(estacaoAux);
                    }
                    aux.setDataHora(data);
                    aux.setContaCorrente(this.contaDestinoAux);
                    aux.setDescricaoHistorico(this.textDescricaoHistoricoDestino.getText());
                    aux.setHistoricoPadrao(this.historicoDestinoAux);
                    aux.setTipoOrigem("P");
                    aux.setDataCancelado(null);
                    aux.setUsuarioCancelado(null);
                    aux.setSituacao(situacaoAnterior);
                    aux.setDescricaoCancelado(null);
                    Set lanctoPlanos = aux.getPlanosContas();
                    HashSet<Object> novosLanctosPlanos = new HashSet<Object>();
                    for (LancamentoPlanoContaBean lanctoPlano : lanctoPlanos) {
                        LancamentoPlanoContaBean novoLanctoPlano = new LancamentoPlanoContaBean();
                        novoLanctoPlano.setFilial(lanctoPlano.getFilial());
                        novoLanctoPlano.setLancamento(lanctoPlano.getLancamento());
                        novoLanctoPlano.setOrigem(lanctoPlano.getOrigem());
                        novoLanctoPlano.setEstacao(lanctoPlano.getEstacao());
                        novoLanctoPlano.setPlanoConta(lanctoPlano.getPlanoConta());
                        novoLanctoPlano.setValor(lanctoPlano.getValor());
                        novoLanctoPlano.setInserir(true);
                        novosLanctosPlanos.add(novoLanctoPlano);
                    }
                    aux.setPlanosContas(novosLanctosPlanos);
                    Set lanctoCentros = aux.getCentrosCusto();
                    HashSet<LancamentoCentroCustoBean> novosLanctosCentros = new HashSet<LancamentoCentroCustoBean>();
                    for (LancamentoCentroCustoBean lanctoCentro : lanctoCentros) {
                        LancamentoCentroCustoBean novoLanctoCentro = new LancamentoCentroCustoBean();
                        novoLanctoCentro.setFilial(lanctoCentro.getFilial());
                        novoLanctoCentro.setLancamento(lanctoCentro.getLancamento());
                        novoLanctoCentro.setOrigem(lanctoCentro.getOrigem());
                        novoLanctoCentro.setEstacao(lanctoCentro.getEstacao());
                        novoLanctoCentro.setPlanoConta(lanctoCentro.getPlanoConta());
                        novoLanctoCentro.setValor(lanctoCentro.getValor());
                        novoLanctoCentro.setCentroCusto(lanctoCentro.getCentroCusto());
                        novoLanctoCentro.setInserir(true);
                        novosLanctosCentros.add(novoLanctoCentro);
                    }
                    aux.setCentrosCusto(novosLanctosCentros);
                    lanctoService.gravaAutoCopiaSemCommit(aux, 0, Variaveis.filialPadrao, null);
                    if (codigoRequisicao == null) continue;
                    RequisicaoLanctoCaixaBean reqLancto = new RequisicaoLanctoCaixaBean();
                    reqLancto.setFilial(aux.getFilial());
                    reqLancto.setLancamento((LancamentoVO)aux.toVO());
                    reqLancto.setEstacao(aux.getEstacao());
                    reqLancto.setRequisicao(codigoRequisicao);
                    reqLanctoService.insert(reqLancto, null, Variaveis.filialPadrao, null);
                }
                Funcoes.mensagem(this, "Transfer\u00eancia realizada com sucesso", 5);
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel transferir pagamentos.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600401200");
    }

    private static enum TiposPagamento {
        CartaoCredito("O"),
        CartaoDebito("I"),
        Cheque("H"),
        ChequeCaucao("A"),
        ChequePreDatado("P"),
        Dinheiro("D"),
        Automatico("U"),
        OnLine("N"),
        DescontoFolha("F"),
        Promissoria("S"),
        DEPOSITO("E"),
        BOLETO("B"),
        TRANSFERENCIA("W"),
        PIX("Y"),
        CHEQUETERCEIRO("T"),
        AUTORIZACAODEBITO("Z");

        String descricao = null;
        String codigo = null;

        private TiposPagamento(String codigo) {
            this.codigo = codigo;
            this.descricao = Tipos.tipoPagamento(codigo);
        }

        public String toString() {
            return this.descricao;
        }

        public String getCodigo() {
            return this.codigo;
        }
    }
}

