/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.lancamentos.componente.BuscaBeanPreenchido;
import jalis.laboratorio.financeiro.lancamentos.componente.PanelPlanoContaCentroCusto;
import jalis.laboratorio.util.BandeirasCartoes;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.financeiro.ContaCorrenteBean;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.model.bean.financeiro.LancamentoCentroCustoBean;
import jalis.model.bean.financeiro.LancamentoPlanoContaBean;
import jalis.model.dao.cadastro.financeiro.ContaCorrenteDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.HistoricoPadraoVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.financeiro.ContaCorrenteVO;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.auxiliares.HistoricoPadraoService;
import jalis.service.cadastro.financeiro.CentroCustoService;
import jalis.service.cadastro.financeiro.ContaCorrenteService;
import jalis.service.cadastro.financeiro.PlanoContaService;
import jalis.service.financeiro.LancamentoService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class TransferenciaEntreFiliais
extends FrmCadPadraoBean
implements ActionListener,
BuscaBeanPreenchido {
    private static long ACESSO_ALTERAR_PLANO_CONTAS = Long.parseLong("0600401304");
    private static long ACESSO_ALTERAR_CENTRO_CUSTO = Long.parseLong("0600401305");
    private LancamentoBean lancamentoOrigem = new LancamentoBean();
    private LancamentoBean lancamentoDestino = new LancamentoBean();
    private PanelPlanoContaCentroCusto panelPlanoCustoOrigem = new PanelPlanoContaCentroCusto(new BuscaBeanPreenchidoOrigem(), PanelPlanoContaCentroCusto.TIPO_LANCAMENTO, ACESSO_ALTERAR_PLANO_CONTAS, ACESSO_ALTERAR_CENTRO_CUSTO, Variaveis.filialPadrao);
    private PanelPlanoContaCentroCusto panelPlanoCustoDestino = new PanelPlanoContaCentroCusto(new BuscaBeanPreenchidoDestino(), PanelPlanoContaCentroCusto.TIPO_LANCAMENTO, ACESSO_ALTERAR_PLANO_CONTAS, ACESSO_ALTERAR_CENTRO_CUSTO, Variaveis.filialPadrao);
    private JLabel labelContaOrigem = new JLabel("Conta Origem:");
    private JLabel labelHistoricoOrigem = new JLabel("Hist\u00f3rico Origem:");
    private JLabel labelDescHistoricoOrigem = new JLabel("Desc. Hist\u00f3rico:");
    private JLabel labelContaDestino = new JLabel("Conta Destino:");
    private JLabel labelHistoricoDestino = new JLabel("Hist\u00f3rico Destino:");
    private JLabel labelDescHistoricoDestino = new JLabel("Desc. Hist\u00f3rico:");
    private JLabel labelValor = new JLabel("Valor:");
    private JLabel labelFilialDestino = new JLabel("Filial Destino:");
    private JLabel labelData = new JLabel("Data:");
    private JLabel labelTipoPagamento = new JLabel("Tipo Pagamento:");
    private JLabel labelDescVlrContaOrigem = new JLabel();
    private JLabel labelDescVlrHistoricoOrigem = new JLabel();
    private JLabel labelDescVlrContaDestino = new JLabel();
    private JLabel labelDescVlrHistoricoDestino = new JLabel();
    private JLabel labelDescVlrFilialDestino = new JLabel();
    private JLabel labelBanco = new JLabel("Banco:");
    private JLabel labelAgencia = new JLabel("Ag\u00eancia:");
    private JLabel labelContaCheque = new JLabel("Conta:");
    private JLabel labelNumeroCheque = new JLabel("Cheque:");
    private JLabel labelSacado = new JLabel("Sacado:");
    private JLabel labelValidadeCartao = new JLabel("Validade:");
    private JLabel labelNumeroCartao = new JLabel("N\u00famero:");
    private JLabel labelCartaoCredito = new JLabel("Bandeira:");
    private JLabel labelAutDebito = new JLabel("C\u00f3digo Autoriza\u00e7\u00e3o:");
    private JLabel labelNomeFuncionario = new JLabel("Nome Funcion\u00e1rio:");
    private JLabel labelTransferencia = new JLabel("Transfer\u00eancia:");
    private JLabel labelPix = new JLabel("Pix:");
    private TTextField textCodFilial = new TTextField(15, 1);
    private TTextField textCodContaOrigem = new TTextField(15, 1);
    private TTextField textCodHistoricoOrigem = new TTextField(15, 1);
    private TTextField textDescHistoricoOrigem = new TTextField();
    private TTextField textCodContaDestino = new TTextField(15, 1);
    private TTextField textCodHistoricoDestino = new TTextField(15, 1);
    private TTextField textDescHistoricoDestino = new TTextField();
    private TTextField textValor = new TTextField(15, 2);
    private TTextField textData = new TTextField(10, 4);
    private TTextField textBanco = new TTextField(5, 1);
    private TTextField textAgencia = new TTextField(10, 3);
    private TTextField textContaCheque = new TTextField(20, 3);
    private TTextField textNumeroCheque = new TTextField(20, 3);
    private TTextField textSacado = new TTextField(80, 3);
    private TTextField textValidadeCartao = new TTextField(10, 4);
    private TTextField textNumeroCartao = new TTextField(16, 3);
    private TTextField textAutDebito = new TTextField(50, 3);
    private TTextField textNomeFuncionario = new TTextField(50, 3);
    private TTextField textTransferencia = new TTextField(3, 3);
    private TTextField textPix = new TTextField(50, 3);
    private JButton buttonContaOrigem = ComponenteFactory.novoJButton(this, true);
    private JButton buttonHistoricoOrigem = ComponenteFactory.novoJButton(this, true);
    private JButton buttonContaDestino = ComponenteFactory.novoJButton(this, true);
    private JButton buttonHistoricoDestino = ComponenteFactory.novoJButton(this, true);
    private JButton buttonData = ComponenteFactory.novoJButton(this, true);
    private JButton buttonFilial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonFormasPagamento = ComponenteFactory.novoJButton(this, true);
    private JPanel panelTela = new JPanel(new GridBagLayout());
    private JPanel panelTipoPagamento = new JPanel(new BorderLayout());
    private JPanel panelCheque = new JPanel(new GridBagLayout());
    private JPanel panelCartao = new JPanel(new GridBagLayout());
    private JPanel panelAutDebito = new JPanel(new GridBagLayout());
    private JPanel panelDescontoFolha = new JPanel(new GridBagLayout());
    private JPanel panelTransferencia = new JPanel(new GridBagLayout());
    private JPanel panelPix = new JPanel(new GridBagLayout());
    private JComboBox comboTipoPagamento = new JComboBox<Object>(new Object[]{Tipos.tipoPagamento("D"), Tipos.tipoPagamento("H"), Tipos.tipoPagamento("I"), Tipos.tipoPagamento("O"), Tipos.tipoPagamento("P"), Tipos.tipoPagamento("A"), Tipos.tipoPagamento("T"), Tipos.tipoPagamento("B"), Tipos.tipoPagamento("E"), Tipos.tipoPagamento("Z"), Tipos.tipoPagamento("S"), Tipos.tipoPagamento("U"), Tipos.tipoPagamento("N"), Tipos.tipoPagamento("W"), Tipos.tipoPagamento("Y")});
    private JComboBox cbxCartaoCredito = new JComboBox<BandeirasCartoes>(FinanceiroUtil.getCartoesCredito());
    private HistoricoPadraoService historicoPadraoService = new HistoricoPadraoService();
    private FilialService filialService = new FilialService();
    private ContaCorrenteService contaCorrenteService = new ContaCorrenteService();
    private LancamentoService lancamentoService = new LancamentoService();
    private JPanel panelValorPagamento = new JPanel(new GridBagLayout());
    private PlanoContaService planoContaService = new PlanoContaService();
    private CentroCustoService centroCustoService = new CentroCustoService();

    public TransferenciaEntreFiliais() {
        this.setModuloAcesso(TransferenciaEntreFiliais.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0600401301"));
        this.setModuloEdita(Long.parseLong("0600401302"));
        this.setModuloApaga(Long.parseLong("0600401303"));
        this.setLabelDescricao("Realiza a transfer\u00eancia de valores entre filiais");
        this.setLabelFormulario("Transfer\u00eancia entre Filiais");
        this.setIcone(ImagemUtils.carregaImagemJalis("financeiro/transf_conta.jpg"));
        try {
            this.jbInit();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel iniciar a tela de transfer\u00eancia entre filiais.", e.getStackTrace());
        }
    }

    private void jbInit() {
        this.botaoSalvar.setText("Transferir");
        ScreenUtil.setBorda(new Component[]{this.labelDescVlrContaOrigem, this.labelDescVlrHistoricoOrigem, this.labelDescVlrFilialDestino, this.labelDescVlrHistoricoDestino, this.labelDescVlrContaDestino}, new TitledBorder(""));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 17;
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 0, 0, 0);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.panelTela.add((Component)this.labelContaOrigem, gbc);
        this.panelTela.setBorder(ScreenUtil.criarBordaVazia());
        ++gbc.gridx;
        this.textCodContaOrigem.setPreferredSize(new Dimension(80, 20));
        this.textCodContaOrigem.setMinimumSize(new Dimension(80, 20));
        this.panelTela.add((Component)this.textCodContaOrigem, gbc);
        ++gbc.gridx;
        this.buttonContaOrigem.setPreferredSize(new Dimension(20, 20));
        this.buttonContaOrigem.setMinimumSize(new Dimension(20, 20));
        this.panelTela.add((Component)this.buttonContaOrigem, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(1, 0, 0, 1);
        this.labelDescVlrContaOrigem.setPreferredSize(new Dimension(100, 20));
        this.labelDescVlrContaOrigem.setMinimumSize(new Dimension(100, 20));
        gbc.fill = 2;
        this.panelTela.add((Component)this.labelDescVlrContaOrigem, gbc);
        gbc.fill = 17;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(1, 0, 0, 0);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.labelHistoricoOrigem.setPreferredSize(new Dimension(110, 20));
        this.labelHistoricoOrigem.setMinimumSize(new Dimension(110, 20));
        this.panelTela.add((Component)this.labelHistoricoOrigem, gbc);
        ++gbc.gridx;
        this.textCodHistoricoOrigem.setPreferredSize(new Dimension(80, 20));
        this.textCodHistoricoOrigem.setMinimumSize(new Dimension(80, 20));
        this.panelTela.add((Component)this.textCodHistoricoOrigem, gbc);
        ++gbc.gridx;
        this.buttonHistoricoOrigem.setPreferredSize(new Dimension(20, 20));
        this.buttonHistoricoOrigem.setMinimumSize(new Dimension(20, 20));
        this.panelTela.add((Component)this.buttonHistoricoOrigem, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(1, 0, 0, 1);
        this.labelDescVlrHistoricoOrigem.setPreferredSize(new Dimension(100, 20));
        this.labelDescVlrHistoricoOrigem.setMinimumSize(new Dimension(100, 20));
        gbc.fill = 2;
        this.panelTela.add((Component)this.labelDescVlrHistoricoOrigem, gbc);
        gbc.fill = 17;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(1, 0, 0, 0);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.labelDescHistoricoOrigem.setPreferredSize(new Dimension(100, 20));
        this.labelDescHistoricoOrigem.setMinimumSize(new Dimension(100, 20));
        this.panelTela.add((Component)this.labelDescHistoricoOrigem, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(1, 0, 0, 1);
        this.textDescHistoricoOrigem.setPreferredSize(new Dimension(110, 20));
        this.textDescHistoricoOrigem.setMinimumSize(new Dimension(110, 20));
        gbc.fill = 2;
        this.panelTela.add((Component)this.textDescHistoricoOrigem, gbc);
        gbc.fill = 17;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.weightx = 0.0;
        gbc.gridwidth = 0;
        ++gbc.gridy;
        gbc.gridx = 0;
        this.labelValor.setPreferredSize(new Dimension(110, 20));
        this.labelValor.setMinimumSize(new Dimension(110, 20));
        this.panelTela.add((Component)this.labelValor, gbc);
        GridBagConstraints gbcValorPag = new GridBagConstraints();
        gbcValorPag.fill = 17;
        gbcValorPag.anchor = 17;
        gbcValorPag.gridx = 0;
        gbcValorPag.gridy = 0;
        gbcValorPag.insets = new Insets(0, 0, 0, 0);
        gbcValorPag.weightx = 0.0;
        gbcValorPag.weighty = 0.0;
        gbcValorPag.insets = new Insets(1, 0, 1, 20);
        this.textValor.setPreferredSize(new Dimension(80, 20));
        this.textValor.setMinimumSize(new Dimension(80, 20));
        this.panelValorPagamento.add((Component)this.textValor, gbcValorPag);
        gbcValorPag.insets = new Insets(0, 0, 0, 0);
        ++gbcValorPag.gridx;
        this.labelData.setPreferredSize(new Dimension(36, 20));
        this.labelData.setMinimumSize(new Dimension(36, 20));
        this.panelValorPagamento.add((Component)this.labelData, gbcValorPag);
        ++gbcValorPag.gridx;
        this.textData.setPreferredSize(new Dimension(100, 20));
        this.textData.setMinimumSize(new Dimension(100, 20));
        this.panelValorPagamento.add((Component)this.textData, gbcValorPag);
        gbcValorPag.insets = new Insets(0, 0, 0, 20);
        ++gbcValorPag.gridx;
        this.buttonData.setPreferredSize(new Dimension(20, 20));
        this.buttonData.setMinimumSize(new Dimension(20, 20));
        this.panelValorPagamento.add((Component)this.buttonData, gbcValorPag);
        gbcValorPag.insets = new Insets(0, 0, 0, 0);
        ++gbcValorPag.gridx;
        this.labelTipoPagamento.setPreferredSize(new Dimension(110, 20));
        this.labelTipoPagamento.setMinimumSize(new Dimension(110, 20));
        this.panelValorPagamento.add((Component)this.labelTipoPagamento, gbcValorPag);
        ++gbcValorPag.gridx;
        this.comboTipoPagamento.setPreferredSize(new Dimension(150, 20));
        this.comboTipoPagamento.setMinimumSize(new Dimension(150, 20));
        this.panelValorPagamento.add((Component)this.comboTipoPagamento, gbcValorPag);
        ++gbcValorPag.gridx;
        gbcValorPag.weightx = 1.0;
        gbcValorPag.insets = new Insets(0, 0, 0, 0);
        this.buttonFormasPagamento.setPreferredSize(new Dimension(20, 20));
        this.panelValorPagamento.add((Component)this.buttonFormasPagamento, gbcValorPag);
        gbcValorPag.insets = new Insets(0, 0, 0, 0);
        ++gbcValorPag.gridx;
        gbcValorPag.weightx = 1.0;
        gbcValorPag.fill = 2;
        this.panelValorPagamento.add((Component)new JLabel(), gbcValorPag);
        ++gbc.gridx;
        gbc.gridwidth = 5;
        gbc.weightx = 1.0;
        gbcValorPag.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 2;
        this.panelTela.add((Component)this.panelValorPagamento, gbc);
        gbc.insets = new Insets(1, 0, 0, 0);
        gbc.gridx = 0;
        boolean haCentrosCusto = false;
        boolean haPlanoConta = false;
        try {
            haCentrosCusto = this.centroCustoService.haCentrosCusto(this.getFilialPadrao());
            haPlanoConta = this.planoContaService.haPlanosContas(this.getFilialPadrao());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((Acesso.getAcesso(ACESSO_ALTERAR_CENTRO_CUSTO) || Acesso.getAcesso(ACESSO_ALTERAR_PLANO_CONTAS)) && (haCentrosCusto || haPlanoConta)) {
            gbc.gridwidth = 0;
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            this.panelTela.add((Component)this.panelPlanoCustoOrigem, gbc);
            this.panelPlanoCustoOrigem.setTipoDebitoCredito("D");
            this.panelPlanoCustoOrigem.setTituloPlanoContas("Plano de Contas (Origem)");
            this.panelPlanoCustoOrigem.setTituloCentroCusto("Centros de Custo (Origem)");
            this.panelPlanoCustoOrigem.setBean(this.lancamentoOrigem);
        }
        gbc.fill = 17;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.labelFilialDestino.setPreferredSize(new Dimension(110, 20));
        this.labelFilialDestino.setMinimumSize(new Dimension(110, 20));
        this.panelTela.add((Component)this.labelFilialDestino, gbc);
        ++gbc.gridx;
        this.textCodFilial.setPreferredSize(new Dimension(80, 20));
        this.textCodFilial.setMinimumSize(new Dimension(80, 20));
        this.panelTela.add((Component)this.textCodFilial, gbc);
        ++gbc.gridx;
        this.buttonFilial.setPreferredSize(new Dimension(20, 20));
        this.buttonFilial.setMinimumSize(new Dimension(20, 20));
        this.panelTela.add((Component)this.buttonFilial, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(1, 0, 0, 1);
        this.labelDescVlrFilialDestino.setPreferredSize(new Dimension(100, 20));
        this.labelDescVlrFilialDestino.setMinimumSize(new Dimension(100, 20));
        gbc.fill = 2;
        this.panelTela.add((Component)this.labelDescVlrFilialDestino, gbc);
        gbc.fill = 17;
        gbc.insets = new Insets(1, 0, 0, 0);
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.labelContaDestino.setPreferredSize(new Dimension(110, 20));
        this.labelContaDestino.setMinimumSize(new Dimension(110, 20));
        this.panelTela.add((Component)this.labelContaDestino, gbc);
        ++gbc.gridx;
        this.textCodContaDestino.setPreferredSize(new Dimension(80, 20));
        this.textCodContaDestino.setMinimumSize(new Dimension(80, 20));
        this.panelTela.add((Component)this.textCodContaDestino, gbc);
        ++gbc.gridx;
        this.buttonContaDestino.setPreferredSize(new Dimension(20, 20));
        this.buttonContaDestino.setMinimumSize(new Dimension(20, 20));
        this.panelTela.add((Component)this.buttonContaDestino, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(1, 0, 0, 1);
        this.labelDescVlrContaDestino.setPreferredSize(new Dimension(100, 20));
        this.labelDescVlrContaDestino.setMinimumSize(new Dimension(100, 20));
        gbc.fill = 2;
        this.panelTela.add((Component)this.labelDescVlrContaDestino, gbc);
        gbc.fill = 17;
        gbc.insets = new Insets(1, 0, 0, 0);
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.labelHistoricoDestino.setPreferredSize(new Dimension(125, 20));
        this.labelHistoricoDestino.setMinimumSize(new Dimension(125, 20));
        this.panelTela.add((Component)this.labelHistoricoDestino, gbc);
        ++gbc.gridx;
        this.textCodHistoricoDestino.setPreferredSize(new Dimension(80, 20));
        this.textCodHistoricoDestino.setMinimumSize(new Dimension(80, 20));
        this.panelTela.add((Component)this.textCodHistoricoDestino, gbc);
        ++gbc.gridx;
        this.buttonHistoricoDestino.setPreferredSize(new Dimension(20, 20));
        this.buttonHistoricoDestino.setMinimumSize(new Dimension(20, 20));
        this.panelTela.add((Component)this.buttonHistoricoDestino, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(1, 0, 0, 1);
        this.labelDescVlrHistoricoDestino.setPreferredSize(new Dimension(100, 20));
        this.labelDescVlrHistoricoDestino.setMinimumSize(new Dimension(100, 20));
        gbc.fill = 2;
        this.panelTela.add((Component)this.labelDescVlrHistoricoDestino, gbc);
        gbc.fill = 17;
        gbc.insets = new Insets(1, 0, 0, 0);
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.labelDescHistoricoDestino.setPreferredSize(new Dimension(100, 20));
        this.labelDescHistoricoDestino.setMinimumSize(new Dimension(100, 20));
        this.panelTela.add((Component)this.labelDescHistoricoDestino, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(1, 0, 0, 1);
        this.textDescHistoricoDestino.setPreferredSize(new Dimension(110, 20));
        this.textDescHistoricoDestino.setMinimumSize(new Dimension(110, 20));
        gbc.fill = 2;
        this.panelTela.add((Component)this.textDescHistoricoDestino, gbc);
        gbc.fill = 17;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(1, 0, 0, 0);
        gbc.gridwidth = 0;
        if (Acesso.getAcesso(ACESSO_ALTERAR_CENTRO_CUSTO) || Acesso.getAcesso(ACESSO_ALTERAR_PLANO_CONTAS)) {
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            this.panelTela.add((Component)this.panelPlanoCustoDestino, gbc);
            this.panelPlanoCustoDestino.setTipoDebitoCredito("C");
            this.panelPlanoCustoDestino.setTituloPlanoContas("Plano de Contas (Destino)");
            this.panelPlanoCustoDestino.setTituloCentroCusto("Centros de Custo (Destino)");
            this.panelPlanoCustoDestino.setBean(this.lancamentoDestino);
            this.panelPlanoCustoDestino.controlaCampos(false);
            gbc.weighty = 0.0;
            gbc.fill = 2;
        } else {
            gbc.gridx = 0;
            ++gbc.gridy;
            this.labelValor.setPreferredSize(new Dimension(100, 20));
            this.labelValor.setMinimumSize(new Dimension(100, 20));
            this.panelTela.add((Component)this.labelValor, gbc);
            ++gbc.gridx;
            gbc.gridwidth = 3;
            this.textValor.setPreferredSize(new Dimension(121, 20));
            this.textValor.setMinimumSize(new Dimension(121, 20));
            this.panelTela.add((Component)this.textValor, gbc);
            gbc.gridwidth = 0;
            gbc.gridx = 0;
            ++gbc.gridy;
            this.labelData.setPreferredSize(new Dimension(100, 20));
            this.labelData.setMinimumSize(new Dimension(100, 20));
            this.panelTela.add((Component)this.labelData, gbc);
            ++gbc.gridx;
            gbc.gridwidth = 3;
            this.textData.setPreferredSize(new Dimension(100, 20));
            this.textData.setMinimumSize(new Dimension(100, 20));
            this.panelTela.add((Component)this.textData, gbc);
            gbc.gridwidth = 0;
            ++gbc.gridx;
            ++gbc.gridx;
            this.buttonData.setPreferredSize(new Dimension(20, 20));
            this.buttonData.setMinimumSize(new Dimension(20, 20));
            this.panelTela.add((Component)this.buttonData, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            this.panelTela.add((Component)this.labelTipoPagamento, gbc);
            ++gbc.gridx;
            this.comboTipoPagamento.setPreferredSize(new Dimension(170, 20));
            this.comboTipoPagamento.setMinimumSize(new Dimension(170, 20));
            this.panelTela.add((Component)this.comboTipoPagamento, gbc);
            ++gbc.gridy;
            gbc.gridx = 1;
        }
        gbc.gridwidth = 4;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.panelTela.add((Component)new JLabel(), gbc);
        this.textValor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String valor = Funcoes.limpaDecimal(TransferenciaEntreFiliais.this.textValor.getText());
                if (!Funcoes.textoVazio(valor)) {
                    TransferenciaEntreFiliais.this.lancamentoOrigem.setValor(Double.parseDouble(valor));
                    TransferenciaEntreFiliais.this.lancamentoDestino.setValor(Double.parseDouble(valor));
                }
            }
        });
        this.montaPanelCheque(true);
        this.montaPanelCartao(true);
        this.montaPanelAutDebito(true);
        this.controlaCampos();
        this.iniciaFocusListener();
        this.iniciaKeyListener();
        this.iniciaActionListener();
        this.add(this.panelTela);
    }

    private void montaPanelAutDebito(boolean limpar) {
        this.panelAutDebito.setBorder(BorderFactory.createTitledBorder("Dados Autoriza\u00e7\u00e3o de D\u00e9bito"));
        this.panelAutDebito.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 0, 0, 1);
        this.panelAutDebito.add((Component)this.labelAutDebito, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.textAutDebito.setPreferredSize(new Dimension(200, 20));
        this.textAutDebito.setMinimumSize(new Dimension(200, 20));
        this.panelAutDebito.add((Component)this.textAutDebito, c);
        c.gridwidth = 1;
        this.panelAutDebito.add((Component)new JLabel(""), c);
        if (limpar) {
            this.textAutDebito.setText("");
        }
    }

    private void montaPanelTransferencia(boolean limpar) {
        this.panelTransferencia.removeAll();
        this.panelTransferencia.setBorder(BorderFactory.createTitledBorder("Dados Transfer\u00eancia"));
        GridBagConstraints c = new GridBagConstraints();
        this.textBanco = new TTextField(3, 1);
        this.textAgencia = new TTextField(5, 1);
        this.textContaCheque = new TTextField(15, 1);
        this.textBanco = new TTextField(3, 1);
        this.textTransferencia.setHorizontalAlignment(4);
        Funcoes.montaEnter((JComponent)this.panelTransferencia);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 0, 0, 1);
        this.panelTransferencia.add((Component)this.labelBanco, c);
        ++c.gridx;
        this.textBanco.setPreferredSize(new Dimension(110, 20));
        this.textBanco.setMinimumSize(new Dimension(110, 20));
        this.panelTransferencia.add((Component)this.textBanco, c);
        ++c.gridx;
        this.panelCheque.add((Component)new JLabel("  "), c);
        ++c.gridx;
        this.panelTransferencia.add((Component)this.labelAgencia, c);
        ++c.gridx;
        this.textAgencia.setPreferredSize(new Dimension(110, 20));
        this.textAgencia.setMinimumSize(new Dimension(110, 20));
        this.panelTransferencia.add((Component)this.textAgencia, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelTransferencia.add((Component)this.labelContaCheque, c);
        ++c.gridx;
        this.textContaCheque.setPreferredSize(new Dimension(110, 20));
        this.textContaCheque.setMinimumSize(new Dimension(110, 20));
        this.panelTransferencia.add((Component)this.textContaCheque, c);
        ++c.gridx;
        this.panelTransferencia.add((Component)new JLabel("  "), c);
        ++c.gridx;
        this.panelTransferencia.add((Component)this.labelTransferencia, c);
        ++c.gridx;
        this.textTransferencia.setPreferredSize(new Dimension(110, 20));
        this.textTransferencia.setMinimumSize(new Dimension(110, 20));
        this.panelTransferencia.add((Component)this.textTransferencia, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelTransferencia.add((Component)this.labelData, c);
        ++c.gridx;
        this.textData.setPreferredSize(new Dimension(110, 20));
        this.textData.setMinimumSize(new Dimension(110, 20));
        this.panelTransferencia.add((Component)this.textData, c);
        this.labelNumeroCheque.setText("Sacado:");
        ++c.gridy;
        c.gridx = 0;
        this.panelTransferencia.add((Component)this.labelSacado, c);
        ++c.gridx;
        c.gridwidth = 4;
        c.fill = 2;
        this.textNumeroCheque.setPreferredSize(new Dimension(300, 20));
        this.textNumeroCheque.setMinimumSize(new Dimension(300, 20));
        this.panelTransferencia.add((Component)this.textSacado, c);
        if (limpar) {
            this.textSacado.setText("");
            this.textNumeroCheque.setText("");
            this.textContaCheque.setText("");
            this.textAgencia.setText("");
            this.textBanco.setText("");
            this.textTransferencia.setText("");
            this.textData.setText("");
        }
        this.preencheDadosBanco(limpar);
    }

    private void montaPanelPix(boolean limpar) {
        this.panelPix.removeAll();
        this.panelPix.setBorder(BorderFactory.createTitledBorder("Dados Pix"));
        GridBagConstraints c = new GridBagConstraints();
        this.textBanco = new TTextField(3, 1);
        this.textAgencia = new TTextField(5, 1);
        this.textContaCheque = new TTextField(15, 1);
        this.textPix.setHorizontalAlignment(4);
        Funcoes.montaEnter((JComponent)this.panelPix);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 0, 0, 1);
        this.panelPix.add((Component)this.labelBanco, c);
        ++c.gridx;
        this.textBanco.setPreferredSize(new Dimension(110, 20));
        this.textBanco.setMinimumSize(new Dimension(110, 20));
        this.panelPix.add((Component)this.textBanco, c);
        ++c.gridx;
        this.panelPix.add((Component)this.labelAgencia, c);
        ++c.gridx;
        this.textAgencia.setPreferredSize(new Dimension(110, 20));
        this.textAgencia.setMinimumSize(new Dimension(110, 20));
        this.panelPix.add((Component)this.textAgencia, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelPix.add((Component)this.labelContaCheque, c);
        ++c.gridx;
        this.textContaCheque.setPreferredSize(new Dimension(110, 20));
        this.textContaCheque.setMinimumSize(new Dimension(110, 20));
        this.panelPix.add((Component)this.textContaCheque, c);
        ++c.gridx;
        this.panelPix.add((Component)this.labelPix, c);
        ++c.gridx;
        this.textPix.setPreferredSize(new Dimension(110, 20));
        this.textPix.setMinimumSize(new Dimension(110, 20));
        this.panelPix.add((Component)this.textPix, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelPix.add((Component)this.labelData, c);
        ++c.gridx;
        this.textData.setPreferredSize(new Dimension(110, 20));
        this.textData.setMinimumSize(new Dimension(110, 20));
        this.panelPix.add((Component)this.textData, c);
        this.labelNumeroCheque.setText("Sacado:");
        ++c.gridy;
        c.gridx = 0;
        this.panelPix.add((Component)this.labelSacado, c);
        ++c.gridx;
        c.gridwidth = 4;
        c.fill = 2;
        this.textNumeroCheque.setPreferredSize(new Dimension(300, 20));
        this.textNumeroCheque.setMinimumSize(new Dimension(300, 20));
        this.panelPix.add((Component)this.textSacado, c);
        if (limpar) {
            this.textSacado.setText("");
            this.textNumeroCheque.setText("");
            this.textContaCheque.setText("");
            this.textAgencia.setText("");
            this.textBanco.setText("");
            this.textData.setText("");
            this.textPix.setText("");
        }
        this.preencheDadosBanco(limpar);
    }

    private void montaPanelDescontoFolha(boolean limpar) {
        this.panelDescontoFolha.setBorder(BorderFactory.createTitledBorder("Desconto em Folha"));
        this.panelDescontoFolha.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 0, 0, 1);
        this.panelDescontoFolha.add((Component)this.labelNomeFuncionario, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.textNomeFuncionario.setPreferredSize(new Dimension(200, 20));
        this.textNomeFuncionario.setMinimumSize(new Dimension(200, 20));
        this.panelDescontoFolha.add((Component)this.textNomeFuncionario, c);
        c.gridwidth = 1;
        this.panelDescontoFolha.add((Component)new JLabel(""), c);
        if (limpar) {
            this.textNomeFuncionario.setText("");
        }
    }

    private void montaPanelCartao(boolean limpar) {
        this.panelCartao.setBorder(BorderFactory.createTitledBorder("Dados Cart\u00e3o"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 0, 0, 1);
        this.panelCartao.add((Component)this.labelValidadeCartao, c);
        ++c.gridx;
        this.textValidadeCartao.setPreferredSize(new Dimension(110, 20));
        this.textValidadeCartao.setMinimumSize(new Dimension(110, 20));
        this.panelCartao.add((Component)this.textValidadeCartao, c);
        ++c.gridx;
        this.panelCartao.add((Component)new JLabel("  "), c);
        ++c.gridx;
        this.panelCartao.add((Component)this.labelNumeroCartao, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.textNumeroCartao.setPreferredSize(new Dimension(110, 20));
        this.textNumeroCartao.setMinimumSize(new Dimension(110, 20));
        this.panelCartao.add((Component)this.textNumeroCartao, c);
        c.weightx = 0.0;
        c.fill = 17;
        ++c.gridy;
        c.gridx = 0;
        this.panelCartao.add((Component)this.labelCartaoCredito, c);
        ++c.gridx;
        this.cbxCartaoCredito.setPreferredSize(new Dimension(110, 20));
        this.cbxCartaoCredito.setMinimumSize(new Dimension(110, 20));
        this.panelCartao.add((Component)this.cbxCartaoCredito, c);
        if (limpar) {
            this.textNumeroCartao.setText("");
            this.textValidadeCartao.setText("");
        }
    }

    @Override
    public void novo() {
        super.novo();
        if (Acesso.getAcesso(ACESSO_ALTERAR_CENTRO_CUSTO) || Acesso.getAcesso(ACESSO_ALTERAR_PLANO_CONTAS)) {
            this.lancamentoOrigem = new LancamentoBean();
            this.lancamentoOrigem.setTipo("D");
            this.lancamentoDestino = new LancamentoBean();
            this.lancamentoDestino.setTipo("C");
        }
    }

    private void iniciaActionListener() {
        this.comboTipoPagamento.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object o = TransferenciaEntreFiliais.this.comboTipoPagamento.getSelectedItem();
                    if (o == null) {
                        return;
                    }
                    TransferenciaEntreFiliais.this.comboTipoPagamento.hidePopup();
                    if (TransferenciaEntreFiliais.this.montaPainelTipoFormaPagamento(o)) {
                        TransferenciaEntreFiliais.this.exibePanelFormaPagamento();
                    }
                }
            }
        });
        this.buttonFormasPagamento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferenciaEntreFiliais.this.exibePanelFormaPagamento();
            }
        });
    }

    private void exibePanelFormaPagamento() {
        if (this.panelTipoPagamento.getComponentCount() == 0) {
            return;
        }
        JPanel botoes = new JPanel(new FlowLayout(2));
        BotaoNavegavel ok = new BotaoNavegavel("OK", 'O');
        BotaoNavegavel cancel = new BotaoNavegavel("Cancelar", 'C');
        final JDialog dlg = new JDialog(Laboratorio.getInstancia());
        dlg.setTitle("Dados da forma de pagamento");
        dlg.setDefaultCloseOperation(0);
        dlg.setLayout(new BorderLayout());
        dlg.setResizable(false);
        Double width = this.panelTipoPagamento.getPreferredSize().getWidth();
        Double height = this.panelTipoPagamento.getPreferredSize().getHeight();
        this.panelTipoPagamento.getPreferredSize().setSize(new Dimension(Integer.parseInt("" + (width.intValue() + 150)), Integer.parseInt("" + (height.intValue() + 50))));
        this.panelTipoPagamento.revalidate();
        dlg.add((Component)this.panelTipoPagamento, "Center");
        dlg.add((Component)botoes, "South");
        botoes.add(ok);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!TransferenciaEntreFiliais.this.validarCamposInformadosFormaPagamento()) {
                    return;
                }
                TransferenciaEntreFiliais.this.buttonFormasPagamento.setVisible(true);
                dlg.setVisible(false);
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dlg.setVisible(false);
                TransferenciaEntreFiliais.this.buttonFormasPagamento.setVisible(true);
            }
        });
        dlg.pack();
        dlg.setModal(true);
        ScreenUtil.centralizar(dlg);
        dlg.setVisible(true);
    }

    private boolean validarCamposInformadosFormaPagamento() {
        Component[] components = this.panelTipoPagamento.getComponents();
        String tipoPagamento = Tipos.getTipoPagamento(this.comboTipoPagamento.getSelectedItem().toString());
        if (!Funcoes.textoVazio(tipoPagamento) && tipoPagamento.equals("Y")) {
            for (Component component : components) {
                TTextField campo;
                if (!(component instanceof TTextField) || !Funcoes.textoVazio(campo = (TTextField)component) || !Funcoes.textoVazio(this.textPix.getText()) && !Funcoes.textoVazio(this.textData.getText()) && !Funcoes.textoVazio(this.textSacado.getText())) continue;
                ScreenUtil.requisitarFoco(campo);
                return false;
            }
        } else {
            for (Component component : components) {
                TTextField campo;
                if (!(component instanceof TTextField) || !Funcoes.textoVazio(campo = (TTextField)component)) continue;
                ScreenUtil.requisitarFoco(campo);
                return false;
            }
        }
        return true;
    }

    private boolean montaPainelTipoFormaPagamento(Object o) {
        String s = (String)o;
        if (s.equalsIgnoreCase(Tipos.tipoPagamento("H")) || s.equalsIgnoreCase(Tipos.tipoPagamento("T")) || s.equalsIgnoreCase(Tipos.tipoPagamento("P")) || s.equalsIgnoreCase(Tipos.tipoPagamento("A"))) {
            this.panelTipoPagamento.removeAll();
            this.montaPanelCheque(true);
            this.buttonFormasPagamento.setEnabled(true);
            this.panelTipoPagamento = this.panelCheque;
            return true;
        }
        if (s.equalsIgnoreCase(Tipos.tipoPagamento("I")) || s.equalsIgnoreCase(Tipos.tipoPagamento("O"))) {
            this.panelTipoPagamento.removeAll();
            this.montaPanelCartao(true);
            this.panelTipoPagamento = this.panelCartao;
            this.buttonFormasPagamento.setEnabled(true);
            return true;
        }
        if (s.equalsIgnoreCase(Tipos.tipoPagamento("Z"))) {
            this.panelTipoPagamento.removeAll();
            this.montaPanelAutDebito(true);
            this.panelTipoPagamento = this.panelAutDebito;
            this.buttonFormasPagamento.setEnabled(true);
            return true;
        }
        if (s.equalsIgnoreCase(Tipos.tipoPagamento("W"))) {
            this.panelTipoPagamento.removeAll();
            this.montaPanelTransferencia(true);
            this.panelTipoPagamento = this.panelTransferencia;
            this.buttonFormasPagamento.setEnabled(true);
            return true;
        }
        if (s.equalsIgnoreCase(Tipos.tipoPagamento("Y"))) {
            this.panelTipoPagamento.removeAll();
            this.montaPanelPix(true);
            this.panelTipoPagamento = this.panelPix;
            this.buttonFormasPagamento.setEnabled(true);
            return true;
        }
        this.buttonFormasPagamento.setEnabled(false);
        return false;
    }

    private void montaPanelCheque(boolean limpar) {
        this.panelCheque.removeAll();
        this.panelCheque.setBorder(BorderFactory.createTitledBorder("Dados Cheque"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 0, 0, 1);
        this.panelCheque.add((Component)this.labelBanco, c);
        ++c.gridx;
        this.textBanco.setPreferredSize(new Dimension(110, 20));
        this.textBanco.setMinimumSize(new Dimension(110, 20));
        this.panelCheque.add((Component)this.textBanco, c);
        ++c.gridx;
        this.panelCheque.add((Component)new JLabel("  "), c);
        ++c.gridx;
        this.panelCheque.add((Component)this.labelAgencia, c);
        ++c.gridx;
        this.textAgencia.setPreferredSize(new Dimension(110, 20));
        this.textAgencia.setMinimumSize(new Dimension(110, 20));
        this.panelCheque.add((Component)this.textAgencia, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelCheque.add((Component)this.labelContaCheque, c);
        ++c.gridx;
        this.textContaCheque.setPreferredSize(new Dimension(110, 20));
        this.textContaCheque.setMinimumSize(new Dimension(110, 20));
        this.panelCheque.add((Component)this.textContaCheque, c);
        ++c.gridx;
        this.panelCheque.add((Component)new JLabel("  "), c);
        ++c.gridx;
        this.panelCheque.add((Component)this.labelNumeroCheque, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.textNumeroCheque.setPreferredSize(new Dimension(300, 20));
        this.textNumeroCheque.setMinimumSize(new Dimension(300, 20));
        this.panelCheque.add((Component)this.textNumeroCheque, c);
        if (this.comboTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("T")) || this.comboTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("P"))) {
            ++c.gridy;
            c.gridx = 0;
            c.fill = 0;
            c.weightx = 0.0;
            this.panelCheque.add((Component)this.labelSacado, c);
            ++c.gridx;
            c.gridwidth = 11;
            c.weightx = 1.0;
            this.textSacado.setPreferredSize(new Dimension(110, 20));
            this.textSacado.setMinimumSize(new Dimension(110, 20));
            c.fill = 2;
            this.panelCheque.add((Component)this.textSacado, c);
            this.panelCheque.add((Component)new JLabel(), c);
        }
        if (limpar) {
            this.textSacado.setText("");
            this.textNumeroCheque.setText("");
            this.textContaCheque.setText("");
            this.textAgencia.setText("");
            this.textBanco.setText("");
        }
        this.preencheDadosBanco(limpar);
    }

    private void preencheDadosBanco(boolean limpar) {
        if (!Funcoes.textoVazio(this.textCodContaOrigem)) {
            ContaCorrenteBean contaBean = null;
            try {
                contaBean = (ContaCorrenteBean)new ContaCorrenteDao().getBean(Variaveis.filialPadrao, this.textCodContaOrigem.getText());
            }
            catch (ThreadDaoException e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar os detalhes da conta.", 2);
            }
            if (contaBean != null && contaBean.getTipo() != null && contaBean.getTipo().equalsIgnoreCase("C")) {
                if (Funcoes.textoVazio(this.textBanco)) {
                    this.textBanco.setText(String.valueOf(contaBean.getBanco().getCodigo()));
                }
                if (Funcoes.textoVazio(this.textAgencia)) {
                    this.textAgencia.setText(contaBean.getAgencia().getCodigo());
                }
                if (Funcoes.textoVazio(this.textContaCheque)) {
                    this.textContaCheque.setText(contaBean.getConta());
                }
            }
            if (limpar) {
                this.textBanco.setText("");
                this.textAgencia.setText("");
                this.textContaCheque.setText("");
            }
        }
    }

    @Override
    public void salvar() {
        if (this.validaCampos()) {
            try {
                ArrayList<AbstractThreadBean> arrayList;
                Date dataInformada = null;
                if (!Funcoes.textoVazio(this.textData.getText())) {
                    dataInformada = Funcoes.stringToDate("dd/MM/yyyy", this.textData.getText());
                }
                Double valorTransferencia = 0.0;
                if (!Funcoes.textoVazio(this.textValor)) {
                    valorTransferencia = Funcoes.textoVazio(this.textValor.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValor.getText()));
                }
                ContaCorrenteVO contaOrigem = (ContaCorrenteVO)this.contaCorrenteService.getVO(this.getFilialPadrao(), this.textCodContaOrigem.getText());
                ContaCorrenteVO contaDestino = (ContaCorrenteVO)this.contaCorrenteService.getVO(this.textCodFilial.getText(), this.textCodContaDestino.getText());
                HistoricoPadraoVO historicoOrigem = (HistoricoPadraoVO)this.historicoPadraoService.getVO(this.getFilialPadrao(), this.textCodHistoricoOrigem.getText());
                historicoOrigem.setDescricao(this.textDescHistoricoOrigem.getText());
                HistoricoPadraoVO historicoDestino = (HistoricoPadraoVO)this.historicoPadraoService.getVO(this.getFilialPadrao(), this.textCodHistoricoDestino.getText());
                historicoDestino.setDescricao(this.textDescHistoricoDestino.getText());
                FilialVO filialTransferencia = new FilialVO();
                filialTransferencia.setCodigo(Integer.parseInt(this.textCodFilial.getText()));
                FilialVO filial = new FilialVO();
                filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                UsuarioVO usuario = new UsuarioVO();
                usuario.setCodigo(Variaveis.login);
                EstacaoVO estacao = new EstacaoVO();
                estacao.setCodigo(Integer.parseInt(Variaveis.codigoEstacao));
                LancamentoBean lanctoBean = null;
                String tipoPagamento = Tipos.getTipoPagamento(this.comboTipoPagamento.getSelectedItem().toString());
                lanctoBean = new LancamentoBean();
                lanctoBean.setTipoPagamento(tipoPagamento);
                lanctoBean.setFilialTransferencia(filialTransferencia);
                if (tipoPagamento.equalsIgnoreCase("Z")) {
                    lanctoBean.setNumeroDocumento(this.textAutDebito.getText());
                } else if (tipoPagamento.equalsIgnoreCase("I") || tipoPagamento.equalsIgnoreCase("O")) {
                    lanctoBean.setValidadeCartao(Funcoes.textoVazio(this.textValidadeCartao.getText()) ? null : Funcoes.getData("dd/MM/yyyy", this.textValidadeCartao.getText()));
                    lanctoBean.setNumeroCartao(this.textNumeroCartao.getText());
                    lanctoBean.setCartaoCredito(this.cbxCartaoCredito.getSelectedItem().toString());
                } else if (tipoPagamento.equalsIgnoreCase("A") || tipoPagamento.equalsIgnoreCase("H") || tipoPagamento.equalsIgnoreCase("T") || tipoPagamento.equalsIgnoreCase("P")) {
                    lanctoBean.setBanco(Funcoes.textoVazio(this.textBanco.getText()) ? null : Integer.valueOf(Integer.parseInt(this.textBanco.getText())));
                    lanctoBean.setAgencia(Funcoes.textoVazio(this.textAgencia.getText()) ? null : this.textAgencia.getText());
                    lanctoBean.setConta(Funcoes.textoVazio(this.textContaCheque) ? null : this.textContaCheque.getText());
                    lanctoBean.setNumeroCheque(Funcoes.textoVazio(this.textNumeroCheque) ? null : this.textNumeroCheque.getText());
                    lanctoBean.setSacado(this.textSacado.getText());
                } else if (tipoPagamento.equalsIgnoreCase("W")) {
                    lanctoBean.setBanco(Funcoes.textoVazio(this.textBanco.getText()) ? null : Integer.valueOf(Integer.parseInt(this.textBanco.getText())));
                    lanctoBean.setAgencia(Funcoes.textoVazio(this.textAgencia.getText()) ? null : this.textAgencia.getText());
                    lanctoBean.setConta(Funcoes.textoVazio(this.textContaCheque) ? null : this.textContaCheque.getText());
                    lanctoBean.setSacado(this.textSacado.getText());
                    lanctoBean.setTipoTransferencia(this.textTransferencia.getText());
                    lanctoBean.setDataVencimento(Funcoes.textoVazio(this.textData) ? null : Funcoes.getData("dd/MM/yyyy", this.textData.getText()));
                } else if (tipoPagamento.equalsIgnoreCase("Y")) {
                    lanctoBean.setBanco(Funcoes.textoVazio(this.textBanco.getText()) ? null : Integer.valueOf(Integer.parseInt(this.textBanco.getText())));
                    lanctoBean.setAgencia(Funcoes.textoVazio(this.textAgencia.getText()) ? null : this.textAgencia.getText());
                    lanctoBean.setConta(Funcoes.textoVazio(this.textContaCheque) ? null : this.textContaCheque.getText());
                    lanctoBean.setSacado(this.textSacado.getText());
                    lanctoBean.setPix(this.textPix.getText());
                    lanctoBean.setDataVencimento(Funcoes.textoVazio(this.textData) ? null : Funcoes.getData("dd/MM/yyyy", this.textData.getText()));
                }
                lanctoBean.setDescricaoHistorico(this.textDescHistoricoOrigem.getText());
                FilialVO filialVO = new FilialVO();
                filialVO.setCodigo(Integer.parseInt(this.textCodFilial.getText()));
                ArrayList<AbstractThreadBean> listPlanoContasOrigem = this.panelPlanoCustoOrigem.getPlanoContas();
                for (AbstractThreadBean abstractThreadBean : listPlanoContasOrigem) {
                    LancamentoPlanoContaBean lancamentoPlanoContaBean = (LancamentoPlanoContaBean)abstractThreadBean;
                    lancamentoPlanoContaBean.setLancamento(null);
                }
                ArrayList<AbstractThreadBean> listCentroCustoOrigem = this.panelPlanoCustoOrigem.getCentrosCusto();
                for (AbstractThreadBean abstractThreadBean : listCentroCustoOrigem) {
                    LancamentoCentroCustoBean bean = (LancamentoCentroCustoBean)abstractThreadBean;
                    bean.setLancamento(null);
                }
                ArrayList<AbstractThreadBean> arrayList2 = this.panelPlanoCustoDestino.getPlanoContas();
                if (arrayList2 != null) {
                    for (AbstractThreadBean abstractThreadBean : arrayList2) {
                        LancamentoPlanoContaBean bean = (LancamentoPlanoContaBean)abstractThreadBean;
                        bean.setFilial(filialVO);
                        bean.setLancamento(null);
                    }
                }
                if ((arrayList = this.panelPlanoCustoDestino.getCentrosCusto()) != null) {
                    for (AbstractThreadBean abstractThreadBean : arrayList) {
                        LancamentoCentroCustoBean bean = (LancamentoCentroCustoBean)abstractThreadBean;
                        bean.setFilial(filialVO);
                        bean.setLancamento(null);
                    }
                }
                if (Acesso.getAcesso(ACESSO_ALTERAR_CENTRO_CUSTO) || Acesso.getAcesso(ACESSO_ALTERAR_PLANO_CONTAS)) {
                    this.lancamentoService.transferenciaEntreContas(contaOrigem, contaDestino, dataInformada, valorTransferencia, lanctoBean, filial, usuario, estacao, historicoOrigem, historicoDestino, true, this.panelPlanoCustoOrigem.getPlanoContas(), this.panelPlanoCustoOrigem.getCentrosCusto(), this.panelPlanoCustoDestino.getPlanoContas(), this.panelPlanoCustoDestino.getCentrosCusto());
                } else {
                    this.lancamentoService.transferenciaEntreContas(contaOrigem, contaDestino, dataInformada, valorTransferencia, lanctoBean, filial, usuario, estacao, historicoOrigem, historicoDestino, true, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList());
                }
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
                Funcoes.mensagem(this, "Transfer\u00eancia realizada com sucesso.", 2);
            }
            catch (Exception e) {
                e.printStackTrace();
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel efeturar a transfer\u00eancia.", e.getStackTrace());
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e1) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel revertar mudan\u00e7as da transnfer\u00eancia.", e.getStackTrace());
                }
            }
        }
    }

    private void iniciaKeyListener() {
        this.textCodContaDestino.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    TransferenciaEntreFiliais.this.buscarContaDestino(true);
                }
                ScreenUtil.requisitarFoco(TransferenciaEntreFiliais.this.textCodContaDestino);
            }
        });
        this.textCodContaOrigem.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    TransferenciaEntreFiliais.this.buscarContaOrigem(true);
                }
                ScreenUtil.requisitarFoco(TransferenciaEntreFiliais.this.textCodContaOrigem);
            }
        });
        this.textCodFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    TransferenciaEntreFiliais.this.buscarFilial(true);
                }
                ScreenUtil.requisitarFoco(TransferenciaEntreFiliais.this.textCodFilial);
            }
        });
        this.textCodHistoricoDestino.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    TransferenciaEntreFiliais.this.buscarHistoricoDestino(true);
                }
                ScreenUtil.requisitarFoco(TransferenciaEntreFiliais.this.textCodHistoricoDestino);
            }
        });
        this.textCodHistoricoOrigem.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    TransferenciaEntreFiliais.this.buscarHistoricoOrigem(true);
                }
                ScreenUtil.requisitarFoco(TransferenciaEntreFiliais.this.textCodHistoricoOrigem);
            }
        });
        this.textData.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    TransferenciaEntreFiliais.this.mostraData();
                }
            }
        });
    }

    protected void mostraData() {
        Funcoes.mostraData(this.textData, this.buttonData, this.panelValorPagamento, true);
    }

    private void iniciaFocusListener() {
        this.textCodContaDestino.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(TransferenciaEntreFiliais.this.textCodContaDestino)) {
                    TransferenciaEntreFiliais.this.buscarContaDestino(false);
                }
            }
        });
        this.textCodContaOrigem.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(TransferenciaEntreFiliais.this.textCodContaOrigem)) {
                    TransferenciaEntreFiliais.this.buscarContaOrigem(false);
                }
            }
        });
        this.textCodFilial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(TransferenciaEntreFiliais.this.textCodFilial)) {
                    TransferenciaEntreFiliais.this.buscarFilial(false);
                }
            }
        });
        this.textCodHistoricoDestino.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(TransferenciaEntreFiliais.this.textCodHistoricoDestino)) {
                    TransferenciaEntreFiliais.this.buscarHistoricoDestino(false);
                }
            }
        });
        this.textCodHistoricoOrigem.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(TransferenciaEntreFiliais.this.textCodHistoricoOrigem)) {
                    TransferenciaEntreFiliais.this.buscarHistoricoOrigem(false);
                }
            }
        });
    }

    protected void buscarHistoricoOrigem(boolean f2) {
        try {
            HistoricoPadraoVO historico = null;
            if (f2) {
                this.textCodHistoricoOrigem.setText("");
                historico = (HistoricoPadraoVO)this.historicoPadraoService.pesquisaVO(this.getTopLevelAncestor(), new HistoricoPadraoVO(), "Pesquisando hist\u00f3ricos", true);
            } else if (!Funcoes.textoVazio(this.textCodHistoricoOrigem)) {
                historico = (HistoricoPadraoVO)this.historicoPadraoService.getVO(this.getFilialPadrao(), this.textCodHistoricoOrigem.getText());
            }
            if (historico != null) {
                this.textCodHistoricoOrigem.setText(historico.getCodigo().toString());
                this.labelDescVlrHistoricoOrigem.setText(historico.getDescricao());
                this.textDescHistoricoOrigem.setEnabled(this.getPodeDescreverHistoricoPadraoOrigem());
                if (!this.textDescHistoricoOrigem.isEnabled()) {
                    this.textDescHistoricoOrigem.setText("");
                }
            } else {
                this.textCodHistoricoOrigem.setText("");
                this.labelDescVlrHistoricoOrigem.setText("");
                if (!Funcoes.textoVazio(this.textCodHistoricoOrigem)) {
                    this.labelDescVlrHistoricoOrigem.setText("N\u00e3o cadastrado");
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar hist\u00f3rico de origem.", e.getStackTrace());
        }
    }

    private boolean getPodeDescreverHistoricoPadraoOrigem() {
        if (!Funcoes.textoVazio(this.textCodHistoricoOrigem)) {
            HistoricoPadraoVO auxHist;
            try {
                auxHist = (HistoricoPadraoVO)this.historicoPadraoService.getVO(String.valueOf(Variaveis.filialPadrao), this.textCodHistoricoOrigem.getText());
            }
            catch (Exception e) {
                return false;
            }
            if (auxHist != null && auxHist.getPermiteDescrever() != null) {
                return auxHist.getPermiteDescrever();
            }
        }
        return false;
    }

    protected void buscarHistoricoDestino(boolean f2) {
        try {
            if (Funcoes.textoVazio(this.textCodFilial.getText())) {
                Funcoes.mensagem(this, "Informe a filial de destino.", 2);
                ScreenUtil.requisitarFoco(this.textCodFilial);
                return;
            }
            HistoricoPadraoVO historico = null;
            historico = f2 ? (HistoricoPadraoVO)this.historicoPadraoService.pesquisaVO(this.getTopLevelAncestor(), new HistoricoPadraoVO(), "Pesquisando hist\u00f3ricos", false, this.textCodFilial.getText()) : (HistoricoPadraoVO)this.historicoPadraoService.getVO(this.textCodFilial.getText(), this.textCodHistoricoDestino.getText());
            if (historico != null) {
                this.textCodHistoricoDestino.setText(historico.getCodigo().toString());
                this.labelDescVlrHistoricoDestino.setText(historico.getDescricao());
                this.textDescHistoricoDestino.setEnabled(this.getPodeDescreverHistoricoPadraoDestino());
                if (!this.textDescHistoricoDestino.isEnabled()) {
                    this.textDescHistoricoDestino.setText("");
                }
            } else {
                this.textCodHistoricoDestino.setText("");
                this.labelDescVlrHistoricoDestino.setText("");
                if (!Funcoes.textoVazio(this.textCodHistoricoDestino)) {
                    this.labelDescVlrHistoricoDestino.setText("N\u00e3o cadastrado");
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar o hist\u00f3rico de destino.", e.getStackTrace());
        }
    }

    private boolean getPodeDescreverHistoricoPadraoDestino() {
        if (!Funcoes.textoVazio(this.textCodHistoricoDestino) && !Funcoes.textoVazio(this.textCodFilial.getText())) {
            HistoricoPadraoVO auxHist;
            try {
                auxHist = (HistoricoPadraoVO)this.historicoPadraoService.getVO(this.textCodFilial.getText(), this.textCodHistoricoDestino.getText());
            }
            catch (Exception e) {
                return false;
            }
            if (auxHist != null && auxHist.getPermiteDescrever() != null) {
                return auxHist.getPermiteDescrever();
            }
        }
        return false;
    }

    protected void buscarFilial(boolean f2) {
        try {
            FilialVO filialVOLogada = (FilialVO)this.filialService.getVO(this.getFilialPadrao());
            String cnpjFilialLogada = filialVOLogada.getCnpj();
            if (!Funcoes.textoVazio(cnpjFilialLogada)) {
                cnpjFilialLogada = cnpjFilialLogada.indexOf("/") > -1 ? cnpjFilialLogada.substring(0, cnpjFilialLogada.indexOf("/")) : cnpjFilialLogada;
            }
            FilialVO filialVO = null;
            filialVO = f2 ? (FilialVO)this.filialService.pesquisaVOFilialDestino(this.getTopLevelAncestor(), new FilialVO(), "Buscando filial", cnpjFilialLogada, true) : (FilialVO)this.filialService.getVOFilialDestino(cnpjFilialLogada, this.getFilialPadrao(), this.textCodFilial.getText());
            if (filialVO != null) {
                this.textCodFilial.setText(filialVO.getCodigo().toString());
                this.labelDescVlrFilialDestino.setText(filialVO.getDescricao());
                this.panelPlanoCustoDestino.setFilial(filialVO.getCodigo().toString());
                this.panelPlanoCustoDestino.controlaCampos(true);
                this.panelPlanoCustoDestino.carregarCombo(filialVO.getCodigo().toString());
            } else {
                this.textCodFilial.setText("");
                this.labelDescVlrFilialDestino.setText("");
                if (!Funcoes.textoVazio(this.textCodFilial)) {
                    this.labelDescVlrFilialDestino.setText("N\u00e3o cadastrado");
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar filial de destino.", e.getStackTrace());
        }
    }

    protected void buscarContaOrigem(boolean f2) {
        try {
            ContaCorrenteVO conta = null;
            if (f2) {
                conta = (ContaCorrenteVO)this.contaCorrenteService.pesquisaVO(this.getTopLevelAncestor(), new ContaCorrenteVO(), "Pesquisando contas correntes", true);
            } else if (!Funcoes.textoVazio(this.textCodContaOrigem.getText())) {
                conta = (ContaCorrenteVO)this.contaCorrenteService.getVO(this.getFilialPadrao(), this.textCodContaOrigem.getText());
            }
            if (conta != null) {
                this.textCodContaOrigem.setText(conta.getReduzido().toString());
                this.labelDescVlrContaOrigem.setText(conta.getConta());
            } else {
                this.textCodContaOrigem.setText("");
                this.labelDescVlrContaOrigem.setText("");
                if (!Funcoes.textoVazio(this.textCodContaOrigem)) {
                    this.labelDescVlrContaOrigem.setText("N\u00e3o cadastrado");
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar conta de origem.", e.getStackTrace());
        }
    }

    protected void buscarContaDestino(boolean f2) {
        block12: {
            try {
                if (!Funcoes.textoVazio(this.textCodFilial.getText())) {
                    if (!this.filialValida()) {
                        Funcoes.mensagem(this, "A filial de destino deve ser diferente a filial logada.", 2);
                    }
                    ContaCorrenteVO contaDestino = null;
                    if (f2) {
                        contaDestino = (ContaCorrenteVO)this.contaCorrenteService.pesquisaVOTransferencia(this.getTopLevelAncestor(), new ContaCorrenteVO(), "Pesquisando contas correntes", false, this.textCodFilial.getText());
                    } else if (!Funcoes.textoVazio(this.textCodContaDestino)) {
                        contaDestino = (ContaCorrenteVO)this.contaCorrenteService.getVO(this.textCodFilial.getText(), this.textCodContaDestino.getText());
                    }
                    if (contaDestino != null) {
                        this.textCodContaDestino.setText(contaDestino.getReduzido().toString());
                        this.labelDescVlrContaDestino.setText(contaDestino.getConta());
                        try {
                            ContaCorrenteBean contaOrigem = null;
                            if (!Funcoes.textoVazio(this.textCodContaOrigem)) {
                                contaOrigem = (ContaCorrenteBean)this.contaCorrenteService.get(this.getFilialPadrao(), this.textCodContaOrigem.getText());
                            }
                            break block12;
                        }
                        catch (Exception e) {
                            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar contas para valida\u00e7\u00e3o.", e.getStackTrace());
                        }
                        break block12;
                    }
                    this.textCodContaDestino.setText("");
                    this.labelDescVlrContaDestino.setText("");
                    if (!Funcoes.textoVazio(this.textCodContaDestino)) {
                        this.labelDescVlrContaDestino.setText("N\u00e3o cadastrado");
                    }
                    break block12;
                }
                Funcoes.mensagem(this, "Informe a filial de destino.", 2);
                return;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar conta destino.", e.getStackTrace());
            }
        }
    }

    private boolean filialValida() {
        return !this.getFilialPadrao().equalsIgnoreCase(this.textCodFilial.getText());
    }

    @Override
    protected void controlaCampos() {
        this.buttonFormasPagamento.setEnabled(false);
        this.panelPlanoCustoOrigem.controlaCampos(this.getStatus() == 3 || this.getStatus() == 2);
        this.panelPlanoCustoDestino.controlaCampos(false);
        this.textCodContaDestino.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textCodContaOrigem.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textCodFilial.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textCodHistoricoDestino.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textCodHistoricoOrigem.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textData.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textDescHistoricoDestino.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textDescHistoricoOrigem.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textValor.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonContaDestino.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonContaOrigem.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonData.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonFilial.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonHistoricoDestino.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonHistoricoOrigem.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboTipoPagamento.setSelectedIndex(0);
        this.comboTipoPagamento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.panelTipoPagamento.removeAll();
    }

    @Override
    protected void limparCampos() {
        this.buttonFormasPagamento.setEnabled(false);
        this.panelPlanoCustoOrigem.limparCampos();
        this.panelPlanoCustoDestino.limparCampos();
        this.textCodContaDestino.setText("");
        this.textCodContaOrigem.setText("");
        this.textCodFilial.setText("");
        this.textCodHistoricoDestino.setText("");
        this.textCodHistoricoOrigem.setText("");
        this.textData.setText("");
        this.textDescHistoricoDestino.setText("");
        this.textDescHistoricoOrigem.setText("");
        this.textValor.setText("");
        this.textAgencia.setText("");
        this.textAutDebito.setText("");
        this.textNomeFuncionario.setText("");
        this.textBanco.setText("");
        this.textNumeroCartao.setText("");
        this.textNumeroCheque.setText("");
        this.textSacado.setText("");
        this.textValidadeCartao.setText("");
        this.textTransferencia.setText("");
        this.textPix.setText("");
        this.textData.setText("");
        this.labelDescVlrContaDestino.setText("");
        this.labelDescVlrContaOrigem.setText("");
        this.labelDescVlrFilialDestino.setText("");
        this.labelDescVlrHistoricoDestino.setText("");
        this.labelDescVlrHistoricoOrigem.setText("");
        this.comboTipoPagamento.setEnabled(false);
        this.comboTipoPagamento.setSelectedIndex(0);
        this.panelTipoPagamento.removeAll();
        ScreenUtil.requisitarFoco(this.textCodContaOrigem);
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        return null;
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
    }

    @Override
    protected String getCopiaFiliais() {
        return null;
    }

    private String getFilialPadrao() {
        return Variaveis.filialPadrao;
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textCodContaOrigem.getText()) || this.textCodContaOrigem.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Conta origem n\u00e3o preenchida.", 2);
            ScreenUtil.requisitarFoco(this.textCodContaOrigem);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodHistoricoOrigem.getText()) || this.textCodHistoricoOrigem.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Hist\u00f3rico origem n\u00e3o preenchido.", 2);
            ScreenUtil.requisitarFoco(this.textCodHistoricoOrigem);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodFilial.getText()) || this.textCodFilial.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Filial n\u00e3o preenchida.", 2);
            ScreenUtil.requisitarFoco(this.textCodFilial);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodContaDestino.getText()) || this.textCodContaDestino.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Conta destino n\u00e3o preenchida.", 2);
            ScreenUtil.requisitarFoco(this.textCodContaDestino);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodHistoricoDestino.getText()) || this.textCodHistoricoDestino.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Hist\u00f3rico destino n\u00e3o preenchido.", 2);
            ScreenUtil.requisitarFoco(this.textCodHistoricoDestino);
            return false;
        }
        if (Funcoes.textoVazio(this.textData.getText()) && Funcoes.verificaData("dd/MM/yyyy", this.textData.getText())) {
            Funcoes.mensagem(this, "Data n\u00e3o preenchida.", 2);
            ScreenUtil.requisitarFoco(this.textData);
            return false;
        }
        if (this.textCodContaOrigem.getText().equalsIgnoreCase(this.textCodContaDestino.getText()) && this.getFilialPadrao().equalsIgnoreCase(this.textCodFilial.getText())) {
            Funcoes.mensagem(this, "A conta corrente de origem deve ser diferente da conta corrente de destino.", 2);
            ScreenUtil.requisitarFoco(this.textCodContaOrigem);
            return false;
        }
        if (Funcoes.textoVazio(this.textValor.getText())) {
            Funcoes.mensagem(this, "Valor n\u00e3o preenchido.", 2);
            ScreenUtil.requisitarFoco(this.textValor);
            return false;
        }
        String valor = this.textValor.getText();
        valor = valor.replaceAll("\\.", "");
        Double valorTrans = Double.parseDouble(valor = valor.replaceAll(",", ""));
        if (valorTrans <= 0.0) {
            Funcoes.mensagem(this, "Valor incorreto.", 2);
            ScreenUtil.requisitarFoco(this.textValor);
            return false;
        }
        if (ParametrosGerais.getTipoIntegracao().equals("F") || ParametrosGerais.getTipoIntegracao().equals("W")) {
            Funcoes.mensagem(this, "Opera\u00e7\u00e3o n\u00e3o \u00e9 permitida para o tipo de integra\u00e7\u00e3o.", 2);
            return false;
        }
        if (Funcoes.textoVazio(this.textData.getText())) {
            Funcoes.mensagem(this, "Data da concilia\u00e7\u00e3o n\u00e3o informada.", 2);
            ScreenUtil.requisitarFoco(this.textData);
            return false;
        }
        String tipoPagamento = Tipos.getTipoPagamento(this.comboTipoPagamento.getSelectedItem().toString());
        if (!(tipoPagamento.equalsIgnoreCase("D") || tipoPagamento.equalsIgnoreCase("U") || tipoPagamento.equalsIgnoreCase("N") || tipoPagamento.equalsIgnoreCase("B") || tipoPagamento.equalsIgnoreCase("E") || tipoPagamento.equalsIgnoreCase("S"))) {
            while (!this.validarCamposInformadosFormaPagamento()) {
                this.exibePanelFormaPagamento();
            }
        }
        return true;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    public static long getModuloAcesso() {
        return Long.valueOf("0600401300");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.buttonContaDestino)) {
            this.buscarContaDestino(true);
            ScreenUtil.requisitarFoco(this.textCodContaDestino);
        } else if (e.getSource().equals(this.buttonContaOrigem)) {
            this.buscarContaOrigem(true);
            ScreenUtil.requisitarFoco(this.textCodContaOrigem);
        } else if (e.getSource().equals(this.buttonFilial)) {
            this.buscarFilial(true);
            ScreenUtil.requisitarFoco(this.textCodFilial);
        } else if (e.getSource().equals(this.buttonHistoricoDestino)) {
            this.buscarHistoricoDestino(true);
            ScreenUtil.requisitarFoco(this.textCodHistoricoDestino);
        } else if (e.getSource().equals(this.buttonHistoricoOrigem)) {
            this.buscarHistoricoOrigem(true);
            ScreenUtil.requisitarFoco(this.textCodHistoricoOrigem);
        } else if (e.getSource().equals(this.buttonData)) {
            this.mostraData();
        }
    }

    @Override
    public AbstractThreadBean buscaBeanPreenchido(PanelPlanoContaCentroCusto source) {
        return null;
    }

    class BuscaBeanPreenchidoDestino
    implements BuscaBeanPreenchido {
        BuscaBeanPreenchidoDestino() {
        }

        @Override
        public AbstractThreadBean buscaBeanPreenchido(PanelPlanoContaCentroCusto source) {
            return TransferenciaEntreFiliais.this.lancamentoDestino;
        }
    }

    class BuscaBeanPreenchidoOrigem
    implements BuscaBeanPreenchido {
        BuscaBeanPreenchidoOrigem() {
        }

        @Override
        public AbstractThreadBean buscaBeanPreenchido(PanelPlanoContaCentroCusto source) {
            return TransferenciaEntreFiliais.this.lancamentoOrigem;
        }
    }
}

