/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.financeiro.lancamentos.FrmCadPadraoBeanLancamento;
import jalis.laboratorio.financeiro.lancamentos.componente.BuscaBeanPreenchido;
import jalis.laboratorio.financeiro.lancamentos.componente.PanelPlanoContaCentroCusto;
import jalis.laboratorio.util.BandeirasCartoes;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.financeiro.ContaCorrenteBean;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.model.dao.cadastro.financeiro.ContaCorrenteDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.HistoricoPadraoVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.financeiro.ContaCorrenteVO;
import jalis.service.cadastro.auxiliares.HistoricoPadraoService;
import jalis.service.cadastro.financeiro.ContaCorrenteService;
import jalis.service.financeiro.LancamentoService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.ConstrutorException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TransferenciaConta
extends FrmCadPadraoBeanLancamento {
    private static long ACESSO_ALTERAR_PLANO_CONTAS = Long.parseLong("0600400404");
    private static long ACESSO_ALTERAR_CENTRO_CUSTO = Long.parseLong("0600400405");
    private LancamentoBean lancamentoOrigem = null;
    private LancamentoBean lancamentoDestino = null;
    private PanelPlanoContaCentroCusto panelPlanoCustoOrigem = new PanelPlanoContaCentroCusto(new BuscaBeanPreenchidoOrigem(), PanelPlanoContaCentroCusto.TIPO_LANCAMENTO, ACESSO_ALTERAR_PLANO_CONTAS, ACESSO_ALTERAR_CENTRO_CUSTO, Variaveis.filialPadrao);
    private PanelPlanoContaCentroCusto panelPlanoCustoDestino = new PanelPlanoContaCentroCusto(new BuscaBeanPreenchidoDestino(), PanelPlanoContaCentroCusto.TIPO_LANCAMENTO, ACESSO_ALTERAR_PLANO_CONTAS, ACESSO_ALTERAR_CENTRO_CUSTO, Variaveis.filialPadrao);
    private JLabel lblContaCorrenteOrigem = new JLabel("Conta Origem:");
    private TTextField textCodigoContaCorrenteOrigem = new TTextField(5, 1);
    private TTextField textDescricaoContaCorrenteOrigem = new TTextField();
    private JButton buttonBuscaContaCorrenteOrigem = new JButton();
    private JLabel lblHistoricoOrigem = new JLabel("Hist\u00f3rico Origem:");
    private TTextField textCodigoHistoricoOrigem = new TTextField(5, 1);
    private TTextField textDescricaoHistoricoOrigem = new TTextField();
    private JButton buttonBuscaHistoricoOrigem = new JButton();
    private JLabel lblContaCorrenteDestino = new JLabel("Conta Destino:");
    private TTextField textCodigoContaCorrenteDestino = new TTextField(5, 1);
    private TTextField textDescricaoContaCorrenteDestino = new TTextField();
    private JButton buttonBuscaContaCorrenteDestino = new JButton();
    private JLabel lblHistoricoDestino = new JLabel("Hist\u00f3rico Destino:");
    private TTextField textCodigoHistoricoDestino = new TTextField(5, 1);
    private TTextField textDescricaoHistoricoDestino = new TTextField();
    private JButton buttonBuscaHistoricoDestino = new JButton();
    private JLabel lblValor = new JLabel("Valor:");
    private TTextField textValor = new TTextField(10, 2, 2);
    private JLabel lblDataConciliacao = new JLabel("Data:");
    private TTextField textDataConciliacao = new TTextField(10, 4);
    private JButton buttonDataConciliacao = new JButton();
    private JLabel lblDescricaoHistoricoOrigemUsuario = new JLabel("Desc. Hist\u00f3rico:");
    private JLabel lblDescricaoHistoricoDestinoUsuario = new JLabel("Desc. Hist\u00f3rico:");
    private TTextField textDescricaoHistoricoOrigemUsuario = new TTextField(100, 3);
    private TTextField textDescricaoHistoricoDestinoUsuario = new TTextField(100, 3);
    private ContaCorrenteService contaCorrenteService = new ContaCorrenteService();
    private HistoricoPadraoService historicoPadraoService = new HistoricoPadraoService();
    private JLabel labelTipoPagamento = new JLabel("Tipo Pagamento:");
    private JComboBox comboTipoPagamento = new JComboBox<Object>(new Object[]{Tipos.tipoPagamento("D"), Tipos.tipoPagamento("H"), Tipos.tipoPagamento("I"), Tipos.tipoPagamento("O"), Tipos.tipoPagamento("P"), Tipos.tipoPagamento("A"), Tipos.tipoPagamento("T"), Tipos.tipoPagamento("B"), Tipos.tipoPagamento("E"), Tipos.tipoPagamento("Z"), Tipos.tipoPagamento("S"), Tipos.tipoPagamento("U"), Tipos.tipoPagamento("N")});
    private boolean transferenciaEntreContasCorrentes = false;
    private JPanel panelTipoPagamento = new JPanel(new BorderLayout());
    private JPanel panelCheque = new JPanel(new GridBagLayout());
    private JPanel panelCartao = new JPanel(new GridBagLayout());
    private JPanel panelAutDebito = new JPanel(new GridBagLayout());
    private TTextField textBanco = new TTextField(5, 1);
    private TTextField textAgencia = new TTextField(10, 3);
    private TTextField textContaCheque = new TTextField(20, 3);
    private TTextField textNumeroCheque = new TTextField(20, 3);
    private TTextField textSacado = new TTextField(80, 3);
    private TTextField textValidadeCartao = new TTextField(10, 4);
    private TTextField textNumeroCartao = new TTextField(16, 3);
    private JComboBox cbxCartaoCredito = new JComboBox<BandeirasCartoes>(FinanceiroUtil.getCartoesCredito());
    private TTextField textAutDebito = new TTextField(50, 3);
    private JLabel lblBanco = new JLabel("Banco:");
    private JLabel lblAgencia = new JLabel("Ag\u00eancia:");
    private JLabel lblContaCheque = new JLabel("Conta:");
    private JLabel lblNumeroCheque = new JLabel("Cheque:");
    private JLabel labelSacado = new JLabel("Sacado:");
    private JLabel lblValidadeCartao = new JLabel("Validade:");
    private JLabel lblNumeroCartao = new JLabel("N\u00famero:");
    private JLabel lblCartaoCredito = new JLabel("Bandeira:");
    private JLabel labelAutDebito = new JLabel("C\u00f3digo Autoriza\u00e7\u00e3o:");

    public TransferenciaConta() {
        this.setLabelDescricao("Realiza a transfer\u00eancia de valores entre contas");
        this.setLabelFormulario("Transfer\u00eancia entre Contas");
        this.setIcone(ImagemUtils.carregaImagemJalis("financeiro/transf_conta.jpg"));
        Dimension d = null;
        d = new Dimension(65, 20);
        this.textBanco.setPreferredSize(d);
        this.textBanco.setMinimumSize(d);
        d = new Dimension(80, 20);
        this.textAgencia.setPreferredSize(d);
        this.textAgencia.setMinimumSize(d);
        d = new Dimension(80, 20);
        this.textContaCheque.setPreferredSize(d);
        this.textContaCheque.setMinimumSize(d);
        d = new Dimension(80, 20);
        this.textNumeroCheque.setPreferredSize(d);
        this.textNumeroCheque.setMinimumSize(d);
        d = new Dimension(100, 20);
        this.textValidadeCartao.setPreferredSize(d);
        this.textValidadeCartao.setMinimumSize(d);
        d = new Dimension(150, 20);
        this.textNumeroCartao.setPreferredSize(d);
        this.textNumeroCartao.setMinimumSize(d);
        d = new Dimension(110, 20);
        this.cbxCartaoCredito.setPreferredSize(d);
        this.cbxCartaoCredito.setMinimumSize(d);
        d = new Dimension(300, 20);
        this.textAutDebito.setPreferredSize(d);
        d = new Dimension(300, 20);
        this.textAutDebito.setMinimumSize(d);
        d = new Dimension(450, 20);
        this.textSacado.setPreferredSize(d);
        d = new Dimension(450, 20);
        this.textSacado.setMinimumSize(d);
        d = new Dimension(60, 20);
        this.textCodigoContaCorrenteOrigem.setPreferredSize(d);
        this.textCodigoContaCorrenteOrigem.setMinimumSize(d);
        this.textCodigoContaCorrenteOrigem.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TransferenciaConta.this.buscaContaCorrenteOrigem(TransferenciaConta.this.textCodigoContaCorrenteOrigem.getText());
                TransferenciaConta.this.controlaTransferenciaEntreContasCorrentes();
            }
        });
        this.textCodigoContaCorrenteDestino.setPreferredSize(d);
        this.textCodigoContaCorrenteDestino.setMinimumSize(d);
        this.textCodigoContaCorrenteDestino.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TransferenciaConta.this.buscaContaCorrenteDestino(TransferenciaConta.this.textCodigoContaCorrenteDestino.getText());
                TransferenciaConta.this.controlaTransferenciaEntreContasCorrentes();
            }
        });
        this.textCodigoHistoricoOrigem.setPreferredSize(d);
        this.textCodigoHistoricoOrigem.setMinimumSize(d);
        this.textCodigoHistoricoOrigem.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TransferenciaConta.this.buscaHistoricoOrigem(TransferenciaConta.this.textCodigoHistoricoOrigem.getText());
                TransferenciaConta.this.controlaCampos();
                if (e.getOppositeComponent() == TransferenciaConta.this.textCodigoContaCorrenteDestino && TransferenciaConta.this.textDescricaoHistoricoOrigemUsuario.isEnabled()) {
                    TransferenciaConta.this.textDescricaoHistoricoOrigemUsuario.grabFocus();
                }
                if (e.getOppositeComponent() == TransferenciaConta.this.textCodigoContaCorrenteDestino && !TransferenciaConta.this.textDescricaoHistoricoOrigemUsuario.isEnabled()) {
                    TransferenciaConta.this.textCodigoContaCorrenteDestino.grabFocus();
                }
                if (e.getOppositeComponent() == TransferenciaConta.this.textCodigoContaCorrenteOrigem) {
                    TransferenciaConta.this.textCodigoContaCorrenteOrigem.grabFocus();
                }
                if (e.getOppositeComponent() == TransferenciaConta.this.textDescricaoHistoricoOrigemUsuario && !TransferenciaConta.this.textDescricaoHistoricoOrigemUsuario.isEnabled()) {
                    TransferenciaConta.this.textCodigoContaCorrenteDestino.grabFocus();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                TransferenciaConta.this.controlaCampos();
            }
        });
        this.textCodigoHistoricoDestino.setPreferredSize(d);
        this.textCodigoHistoricoDestino.setMinimumSize(d);
        this.textCodigoHistoricoDestino.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TransferenciaConta.this.buscaHistoricoDestino(TransferenciaConta.this.textCodigoHistoricoDestino.getText());
                TransferenciaConta.this.controlaCampos();
                if (e.getOppositeComponent() == TransferenciaConta.this.textValor && TransferenciaConta.this.textDescricaoHistoricoDestinoUsuario.isEnabled()) {
                    TransferenciaConta.this.textDescricaoHistoricoDestinoUsuario.grabFocus();
                }
                if (e.getOppositeComponent() == TransferenciaConta.this.textValor && !TransferenciaConta.this.textDescricaoHistoricoDestinoUsuario.isEnabled()) {
                    TransferenciaConta.this.textValor.grabFocus();
                }
                if (e.getOppositeComponent() == TransferenciaConta.this.textCodigoContaCorrenteDestino) {
                    TransferenciaConta.this.textCodigoContaCorrenteDestino.grabFocus();
                }
                if (e.getOppositeComponent() == TransferenciaConta.this.textDescricaoHistoricoDestinoUsuario && !TransferenciaConta.this.textDescricaoHistoricoDestinoUsuario.isEnabled()) {
                    TransferenciaConta.this.textValor.grabFocus();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                TransferenciaConta.this.controlaCampos();
            }
        });
        this.buttonBuscaContaCorrenteOrigem.setFocusable(false);
        this.buttonBuscaContaCorrenteOrigem.setText("");
        d = new Dimension(20, 20);
        this.buttonBuscaContaCorrenteOrigem.setPreferredSize(d);
        this.buttonBuscaContaCorrenteOrigem.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaContaCorrenteOrigem);
        this.buttonBuscaContaCorrenteOrigem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferenciaConta.this.buscaContaCorrenteOrigem();
            }
        });
        this.buttonBuscaContaCorrenteDestino.setFocusable(false);
        this.buttonBuscaContaCorrenteDestino.setText("");
        this.buttonBuscaContaCorrenteDestino.setPreferredSize(d);
        this.buttonBuscaContaCorrenteDestino.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaContaCorrenteDestino);
        this.buttonBuscaContaCorrenteDestino.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferenciaConta.this.buscaContaCorrenteDestino();
            }
        });
        this.buttonBuscaHistoricoOrigem.setFocusable(false);
        this.buttonBuscaHistoricoOrigem.setText("");
        this.buttonBuscaHistoricoOrigem.setPreferredSize(d);
        this.buttonBuscaHistoricoOrigem.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaHistoricoOrigem);
        this.buttonBuscaHistoricoOrigem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferenciaConta.this.buscaHistoricoOrigem();
            }
        });
        this.buttonBuscaHistoricoDestino.setFocusable(false);
        this.buttonBuscaHistoricoDestino.setText("");
        this.buttonBuscaHistoricoDestino.setPreferredSize(d);
        this.buttonBuscaHistoricoDestino.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaHistoricoDestino);
        this.buttonBuscaHistoricoDestino.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferenciaConta.this.buscaHistoricoDestino();
            }
        });
        this.buttonDataConciliacao.setPreferredSize(d);
        this.buttonDataConciliacao.setMinimumSize(d);
        this.buttonDataConciliacao.setMargin(new Insets(2, 2, 2, 2));
        Funcoes.imagemPesquisa(this.buttonDataConciliacao);
        this.buttonDataConciliacao.setFocusable(false);
        this.buttonDataConciliacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferenciaConta.this.buscaDataConciliacao();
            }
        });
        d = new Dimension(200, 20);
        this.textDescricaoContaCorrenteOrigem.setPreferredSize(d);
        this.textDescricaoContaCorrenteOrigem.setMinimumSize(d);
        this.textDescricaoContaCorrenteOrigem.setEditable(false);
        this.textDescricaoContaCorrenteOrigem.setFocusable(false);
        this.textDescricaoContaCorrenteDestino.setPreferredSize(d);
        this.textDescricaoContaCorrenteDestino.setMinimumSize(d);
        this.textDescricaoContaCorrenteDestino.setEditable(false);
        this.textDescricaoContaCorrenteDestino.setFocusable(false);
        this.textDescricaoHistoricoOrigem.setPreferredSize(d);
        this.textDescricaoHistoricoOrigem.setMinimumSize(d);
        this.textDescricaoHistoricoOrigem.setEditable(false);
        this.textDescricaoHistoricoOrigem.setFocusable(false);
        this.textDescricaoHistoricoDestino.setPreferredSize(d);
        this.textDescricaoHistoricoDestino.setMinimumSize(d);
        this.textDescricaoHistoricoDestino.setEditable(false);
        this.textDescricaoHistoricoDestino.setFocusable(false);
        d = new Dimension(120, 20);
        this.comboTipoPagamento.setPreferredSize(d);
        this.comboTipoPagamento.setMinimumSize(d);
        this.comboTipoPagamento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object o = TransferenciaConta.this.comboTipoPagamento.getSelectedItem();
                if (o == null) {
                    return;
                }
                String s = (String)o;
                TransferenciaConta.this.panelTipoPagamento.removeAll();
                if (s.equalsIgnoreCase(Tipos.tipoPagamento("H")) || s.equalsIgnoreCase(Tipos.tipoPagamento("T")) || s.equalsIgnoreCase(Tipos.tipoPagamento("P")) || s.equalsIgnoreCase(Tipos.tipoPagamento("A"))) {
                    TransferenciaConta.this.montaPanelCheque();
                    TransferenciaConta.this.panelTipoPagamento.add((Component)TransferenciaConta.this.panelCheque, "Center");
                } else if (s.equalsIgnoreCase(Tipos.tipoPagamento("I")) || s.equalsIgnoreCase(Tipos.tipoPagamento("O"))) {
                    TransferenciaConta.this.panelTipoPagamento.add((Component)TransferenciaConta.this.panelCartao, "Center");
                } else if (s.equalsIgnoreCase(Tipos.tipoPagamento("Z"))) {
                    TransferenciaConta.this.panelTipoPagamento.add((Component)TransferenciaConta.this.panelAutDebito, "Center");
                }
                TransferenciaConta.this.painelCentral.revalidate();
                TransferenciaConta.this.painelCentral.repaint();
            }
        });
        this.comboTipoPagamento.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String s;
                if (TransferenciaConta.this.comboTipoPagamento.getSelectedItem() != null && ((s = TransferenciaConta.this.comboTipoPagamento.getSelectedItem().toString()).equalsIgnoreCase(Tipos.tipoPagamento("H")) || s.equalsIgnoreCase(Tipos.tipoPagamento("T")) || s.equalsIgnoreCase(Tipos.tipoPagamento("P")) || s.equalsIgnoreCase(Tipos.tipoPagamento("A")))) {
                    TransferenciaConta.this.montaPanelCheque();
                    TransferenciaConta.this.panelTipoPagamento.add((Component)TransferenciaConta.this.panelCheque, "Center");
                }
            }
        });
        d = new Dimension(100, 20);
        this.textValor.setPreferredSize(d);
        this.textValor.setMinimumSize(d);
        this.textDataConciliacao.setPreferredSize(d);
        this.textDataConciliacao.setMinimumSize(d);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridwidth = 1;
        c.fill = 0;
        this.painelCentral.add((Component)this.lblValor, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.painelCentral.add((Component)this.textValor, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        this.painelCentral.add((Component)this.lblDataConciliacao, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.painelCentral.add((Component)this.textDataConciliacao, c);
        c.gridx += 3;
        this.painelCentral.add((Component)this.buttonDataConciliacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.lblContaCorrenteOrigem, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigoContaCorrenteOrigem, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.buttonBuscaContaCorrenteOrigem, c);
        ++c.gridx;
        c.fill = 2;
        c.gridwidth = 5;
        this.painelCentral.add((Component)this.textDescricaoContaCorrenteOrigem, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        this.painelCentral.add((Component)this.lblHistoricoOrigem, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigoHistoricoOrigem, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.buttonBuscaHistoricoOrigem, c);
        ++c.gridx;
        c.gridwidth = 5;
        c.fill = 2;
        this.painelCentral.add((Component)this.textDescricaoHistoricoOrigem, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        this.painelCentral.add((Component)this.lblDescricaoHistoricoOrigemUsuario, c);
        ++c.gridx;
        c.gridwidth = 7;
        c.fill = 2;
        this.painelCentral.add((Component)this.textDescricaoHistoricoOrigemUsuario, c);
        if (Acesso.getAcesso(ACESSO_ALTERAR_CENTRO_CUSTO) || Acesso.getAcesso(ACESSO_ALTERAR_PLANO_CONTAS)) {
            c.fill = 1;
            c.gridx = 0;
            c.gridwidth = 0;
            c.weighty = 1.0;
            ++c.gridy;
            this.painelCentral.add((Component)this.panelPlanoCustoOrigem, c);
            this.panelPlanoCustoOrigem.setTipoDebitoCredito("D");
            this.panelPlanoCustoOrigem.setTituloPlanoContas("Plano de Contas (Origem)");
            this.panelPlanoCustoOrigem.setTituloCentroCusto("Centros de Custo (Origem)");
            this.panelPlanoCustoOrigem.setBean(new LancamentoBean());
            c.fill = 2;
            c.weighty = 0.0;
        }
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        this.painelCentral.add((Component)this.lblContaCorrenteDestino, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigoContaCorrenteDestino, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.buttonBuscaContaCorrenteDestino, c);
        ++c.gridx;
        c.gridwidth = 5;
        c.fill = 2;
        this.painelCentral.add((Component)this.textDescricaoContaCorrenteDestino, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        this.painelCentral.add((Component)this.lblHistoricoDestino, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigoHistoricoDestino, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.buttonBuscaHistoricoDestino, c);
        ++c.gridx;
        c.gridwidth = 5;
        c.fill = 2;
        this.painelCentral.add((Component)this.textDescricaoHistoricoDestino, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        this.painelCentral.add((Component)this.lblDescricaoHistoricoDestinoUsuario, c);
        ++c.gridx;
        c.gridwidth = 7;
        c.fill = 2;
        this.painelCentral.add((Component)this.textDescricaoHistoricoDestinoUsuario, c);
        if (Acesso.getAcesso(ACESSO_ALTERAR_CENTRO_CUSTO) || Acesso.getAcesso(ACESSO_ALTERAR_PLANO_CONTAS)) {
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 0;
            c.weighty = 1.0;
            c.fill = 1;
            this.painelCentral.add((Component)this.panelPlanoCustoDestino, c);
            this.panelPlanoCustoDestino.setTipoDebitoCredito("C");
            this.panelPlanoCustoDestino.setTituloPlanoContas("Plano de Contas (Destino)");
            this.panelPlanoCustoDestino.setTituloCentroCusto("Centros de Custo (Destino)");
            this.panelPlanoCustoDestino.setBean(new LancamentoBean());
            c.weighty = 0.0;
            c.fill = 2;
        }
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        this.painelCentral.add((Component)this.labelTipoPagamento, c);
        ++c.gridx;
        c.gridwidth = 4;
        this.painelCentral.add((Component)this.comboTipoPagamento, c);
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.fill = 2;
        this.painelCentral.add((Component)this.panelTipoPagamento, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 6;
        c.fill = 1;
        this.painelCentral.add((Component)new JPanel(), c);
        this.montaPanelCheque();
        this.montaPanelCartao();
        this.montaPanelAutDebito();
        this.service = new LancamentoService();
        this.controlaCampos();
    }

    private void montaPanelCheque() {
        this.panelCheque.removeAll();
        this.panelCheque.setBorder(BorderFactory.createTitledBorder("Dados Cheque"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.panelCheque.add((Component)this.lblBanco, c);
        ++c.gridx;
        this.panelCheque.add((Component)this.textBanco, c);
        ++c.gridx;
        this.panelCheque.add((Component)new JLabel("  "), c);
        ++c.gridx;
        this.panelCheque.add((Component)this.lblAgencia, c);
        ++c.gridx;
        this.panelCheque.add((Component)this.textAgencia, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelCheque.add((Component)this.lblContaCheque, c);
        ++c.gridx;
        this.panelCheque.add((Component)this.textContaCheque, c);
        ++c.gridx;
        this.panelCheque.add((Component)new JLabel("  "), c);
        ++c.gridx;
        this.panelCheque.add((Component)this.lblNumeroCheque, c);
        ++c.gridx;
        this.panelCheque.add((Component)this.textNumeroCheque, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.panelCheque.add((Component)new JPanel(), c);
        if (this.comboTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("T")) || this.comboTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("P"))) {
            ++c.gridy;
            c.gridx = 0;
            c.fill = 0;
            c.weightx = 0.0;
            this.panelCheque.add((Component)this.labelSacado, c);
            ++c.gridx;
            c.gridwidth = 11;
            c.weightx = 0.0;
            this.panelCheque.add((Component)this.textSacado, c);
            c.fill = 2;
            this.panelCheque.add((Component)new JLabel(), c);
        }
        this.preencheDadosBanco();
    }

    private void preencheDadosBanco() {
        if (!Funcoes.textoVazio(this.textCodigoContaCorrenteOrigem)) {
            ContaCorrenteBean contaBean = null;
            try {
                contaBean = (ContaCorrenteBean)new ContaCorrenteDao().getBean(Variaveis.filialPadrao, this.textCodigoContaCorrenteOrigem.getText());
            }
            catch (ThreadDaoException e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar os detalhes da conta.", 2);
            }
            if (contaBean != null && contaBean.getTipo() != null && contaBean.getTipo().equalsIgnoreCase("C")) {
                if (Funcoes.textoVazio(this.textBanco)) {
                    this.textBanco.setText(String.valueOf(contaBean.getBanco().getCodigo()));
                }
                if (Funcoes.textoVazio(this.textAgencia)) {
                    this.textAgencia.setText(contaBean.getAgencia().getCodigo());
                }
                if (Funcoes.textoVazio(this.textContaCheque)) {
                    this.textContaCheque.setText(contaBean.getConta());
                }
            }
        }
    }

    private void montaPanelCartao() {
        this.panelCartao.setBorder(BorderFactory.createTitledBorder("Dados Cart\u00e3o"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.panelCartao.add((Component)this.lblValidadeCartao, c);
        ++c.gridx;
        this.panelCartao.add((Component)this.textValidadeCartao, c);
        ++c.gridx;
        this.panelCartao.add((Component)new JLabel("  "), c);
        ++c.gridx;
        this.panelCartao.add((Component)this.lblNumeroCartao, c);
        ++c.gridx;
        this.panelCartao.add((Component)this.textNumeroCartao, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelCartao.add((Component)this.lblCartaoCredito, c);
        ++c.gridx;
        this.panelCartao.add((Component)this.cbxCartaoCredito, c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        this.panelCartao.add((Component)new JPanel(), c);
    }

    private void montaPanelAutDebito() {
        this.panelAutDebito.setBorder(BorderFactory.createTitledBorder("Dados Autoriza\u00e7\u00e3o de D\u00e9bito"));
        this.panelAutDebito.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.panelAutDebito.add((Component)this.labelAutDebito, c);
        ++c.gridx;
        this.panelAutDebito.add((Component)this.textAutDebito, c);
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelAutDebito.add((Component)new JLabel(""), c);
    }

    private void controlaTransferenciaEntreContasCorrentes() {
        this.transferenciaEntreContasCorrentes = false;
        if (!(Funcoes.textoVazio(this.textCodigoContaCorrenteOrigem) || Funcoes.textoVazio(this.textCodigoContaCorrenteDestino) || this.textDescricaoContaCorrenteOrigem.getText().equals("N\u00e3o cadastrado") || this.textDescricaoContaCorrenteDestino.getText().equals("N\u00e3o cadastrado"))) {
            ContaCorrenteBean contaOrigem = null;
            ContaCorrenteBean contaDestino = null;
            try {
                contaOrigem = (ContaCorrenteBean)new ContaCorrenteDao().getBean(Variaveis.filialPadrao, this.textCodigoContaCorrenteOrigem.getText());
            }
            catch (ThreadDaoException e1) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar informa\u00e7\u00f5es da Conta Corrente/Caixa. C\u00f3d. Conta: " + this.textCodigoContaCorrenteOrigem.getText(), 2);
                this.transferenciaEntreContasCorrentes = false;
                this.labelTipoPagamento.setVisible(this.transferenciaEntreContasCorrentes);
                this.comboTipoPagamento.setVisible(this.transferenciaEntreContasCorrentes);
                this.panelTipoPagamento.setVisible(this.transferenciaEntreContasCorrentes);
                return;
            }
            try {
                contaDestino = (ContaCorrenteBean)new ContaCorrenteDao().getBean(Variaveis.filialPadrao, this.textCodigoContaCorrenteDestino.getText());
            }
            catch (ThreadDaoException e1) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar informa\u00e7\u00f5es da Conta Corrente/Caixa. C\u00f3d. Conta: " + this.textCodigoContaCorrenteDestino.getText(), 2);
                this.transferenciaEntreContasCorrentes = false;
                this.labelTipoPagamento.setVisible(this.transferenciaEntreContasCorrentes);
                this.comboTipoPagamento.setVisible(this.transferenciaEntreContasCorrentes);
                this.panelTipoPagamento.setVisible(this.transferenciaEntreContasCorrentes);
                return;
            }
            if (contaOrigem != null && contaDestino != null && contaOrigem.getTipo() != null && contaOrigem.getTipo().equalsIgnoreCase("C") && contaDestino.getTipo() != null && contaDestino.getTipo().equalsIgnoreCase("C")) {
                this.transferenciaEntreContasCorrentes = true;
            }
        }
        this.labelTipoPagamento.setVisible(this.transferenciaEntreContasCorrentes);
        this.comboTipoPagamento.setVisible(this.transferenciaEntreContasCorrentes);
        this.panelTipoPagamento.setVisible(this.transferenciaEntreContasCorrentes);
    }

    @Override
    protected void controlaCampos() {
        this.panelPlanoCustoOrigem.controlaCampos(this.getStatus() == 3 || this.getStatus() == 2);
        this.panelPlanoCustoDestino.controlaCampos(this.getStatus() == 3 || this.getStatus() == 2);
        this.textCodigoContaCorrenteDestino.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textDescricaoContaCorrenteDestino.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonBuscaContaCorrenteDestino.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textCodigoContaCorrenteOrigem.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textDescricaoContaCorrenteOrigem.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonBuscaContaCorrenteOrigem.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textCodigoHistoricoDestino.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textDescricaoHistoricoDestino.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonBuscaHistoricoDestino.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textCodigoHistoricoOrigem.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textDescricaoHistoricoOrigem.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonBuscaHistoricoOrigem.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textValor.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textDataConciliacao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonDataConciliacao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textDescricaoHistoricoOrigemUsuario.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textDescricaoHistoricoOrigemUsuario.setEnabled(this.textDescricaoHistoricoOrigemUsuario.isEnabled() && this.getPodeDescreverHistoricoPadraoOrigem());
        if (!this.textDescricaoHistoricoOrigemUsuario.isEnabled()) {
            this.textDescricaoHistoricoOrigemUsuario.setText("");
        }
        this.textDescricaoHistoricoDestinoUsuario.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textDescricaoHistoricoDestinoUsuario.setEnabled(this.textDescricaoHistoricoDestinoUsuario.isEnabled() && this.getPodeDescreverHistoricoPadraoDestino());
        if (!this.textDescricaoHistoricoDestinoUsuario.isEnabled()) {
            this.textDescricaoHistoricoDestinoUsuario.setText("");
        }
        this.comboTipoPagamento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.controlaTransferenciaEntreContasCorrentes();
    }

    private boolean getPodeDescreverHistoricoPadraoOrigem() {
        if (!Funcoes.textoVazio(this.textCodigoHistoricoOrigem)) {
            HistoricoPadraoVO auxHist;
            try {
                auxHist = (HistoricoPadraoVO)new HistoricoPadraoService().getVO(String.valueOf(Variaveis.filialPadrao), this.textCodigoHistoricoOrigem.getText());
            }
            catch (Exception e) {
                return false;
            }
            if (auxHist != null && auxHist.getPermiteDescrever() != null) {
                return auxHist.getPermiteDescrever();
            }
        }
        return false;
    }

    private boolean getPodeDescreverHistoricoPadraoDestino() {
        if (!Funcoes.textoVazio(this.textCodigoHistoricoDestino)) {
            HistoricoPadraoVO auxHist;
            try {
                auxHist = (HistoricoPadraoVO)new HistoricoPadraoService().getVO(String.valueOf(Variaveis.filialPadrao), this.textCodigoHistoricoDestino.getText());
            }
            catch (Exception e) {
                return false;
            }
            if (auxHist != null && auxHist.getPermiteDescrever() != null) {
                return auxHist.getPermiteDescrever();
            }
        }
        return false;
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        return null;
    }

    @Override
    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    protected void limparCampos() {
        this.panelPlanoCustoDestino.limparCampos();
        this.panelPlanoCustoOrigem.limparCampos();
        this.textCodigoContaCorrenteOrigem.setText("");
        this.textDescricaoContaCorrenteOrigem.setText("");
        this.textCodigoContaCorrenteDestino.setText("");
        this.textDescricaoContaCorrenteDestino.setText("");
        this.textCodigoHistoricoOrigem.setText("");
        this.textDescricaoHistoricoOrigem.setText("");
        this.textCodigoHistoricoDestino.setText("");
        this.textDescricaoHistoricoDestino.setText("");
        this.textValor.setText("");
        this.textDataConciliacao.setText("");
        this.textBanco.setText("");
        this.textAgencia.setText("");
        this.textContaCheque.setText("");
        this.textNumeroCheque.setText("");
        this.textSacado.setText("");
        this.textValidadeCartao.setText("");
        this.textNumeroCartao.setText("");
        this.cbxCartaoCredito.setSelectedIndex(-1);
        this.textAutDebito.setText("");
        this.transferenciaEntreContasCorrentes = false;
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textCodigoContaCorrenteOrigem.getText()) || this.textDescricaoContaCorrenteOrigem.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Conta origem n\u00e3o preenchida.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoContaCorrenteOrigem);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodigoContaCorrenteDestino.getText()) || this.textDescricaoContaCorrenteDestino.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Conta destino n\u00e3o preenchida.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoContaCorrenteDestino);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodigoHistoricoOrigem.getText()) || this.textDescricaoHistoricoOrigem.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Hist\u00f3rico origem n\u00e3o preenchido.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoHistoricoOrigem);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodigoHistoricoDestino.getText()) || this.textDescricaoHistoricoDestino.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Hist\u00f3rico destino n\u00e3o preenchido.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoHistoricoDestino);
            return false;
        }
        if (Funcoes.textoVazio(this.textDataConciliacao.getText()) && Funcoes.verificaData("dd/MM/yyyy", this.textDataConciliacao.getText())) {
            Funcoes.mensagem(this, "Data n\u00e3o preenchida.", 2);
            ScreenUtil.requisitarFoco(this.textDataConciliacao);
            return false;
        }
        if (this.textCodigoContaCorrenteOrigem.getText().equalsIgnoreCase(this.textCodigoContaCorrenteDestino.getText())) {
            Funcoes.mensagem(this, "A conta corrente de origem deve ser diferente da conta corrente de destino.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoContaCorrenteDestino);
            return false;
        }
        if (Funcoes.textoVazio(this.textValor.getText())) {
            Funcoes.mensagem(this, "Valor n\u00e3o preenchido.", 2);
            ScreenUtil.requisitarFoco(this.textValor);
            return false;
        }
        return true;
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(TransferenciaConta.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0600400401"));
        this.setModuloEdita(Long.parseLong("0600400402"));
        this.setModuloApaga(Long.parseLong("0600400403"));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600400400");
    }

    private void buscaContaCorrenteOrigem(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoContaCorrenteOrigem.setText("");
            this.textDescricaoContaCorrenteOrigem.setText("");
            return;
        }
        try {
            ContaCorrenteVO conta = (ContaCorrenteVO)this.contaCorrenteService.getVO(Variaveis.filialPadrao, codigo);
            if (conta != null) {
                this.textCodigoContaCorrenteOrigem.setText(conta.getReduzido().toString());
                this.textDescricaoContaCorrenteOrigem.setText(conta.getConta());
            } else {
                this.textDescricaoContaCorrenteOrigem.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "TransferenciaConta:213");
        }
    }

    private void buscaContaCorrenteOrigem() {
        try {
            this.textCodigoContaCorrenteOrigem.setText("");
            this.textDescricaoContaCorrenteOrigem.setText("");
            ContaCorrenteVO conta = (ContaCorrenteVO)this.contaCorrenteService.pesquisaVO(this.getTopLevelAncestor(), new ContaCorrenteVO(), "Pesquisando contas correntes", true);
            if (conta != null) {
                this.textCodigoContaCorrenteOrigem.setText(conta.getReduzido().toString());
                this.textDescricaoContaCorrenteOrigem.setText(conta.getConta());
            } else {
                this.textDescricaoContaCorrenteOrigem.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "TransferenciaConta:228");
        }
    }

    private void buscaContaCorrenteDestino(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoContaCorrenteDestino.setText("");
            this.textDescricaoContaCorrenteDestino.setText("");
            return;
        }
        try {
            ContaCorrenteVO conta = (ContaCorrenteVO)this.contaCorrenteService.getVO(Variaveis.filialPadrao, codigo);
            if (conta != null) {
                this.textCodigoContaCorrenteDestino.setText(conta.getReduzido().toString());
                this.textDescricaoContaCorrenteDestino.setText(conta.getConta());
            } else {
                this.textDescricaoContaCorrenteDestino.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "TransferenciaConta:246");
        }
    }

    private void buscaContaCorrenteDestino() {
        try {
            this.textCodigoContaCorrenteDestino.setText("");
            this.textDescricaoContaCorrenteDestino.setText("");
            ContaCorrenteVO conta = (ContaCorrenteVO)this.contaCorrenteService.pesquisaVO(this.getTopLevelAncestor(), new ContaCorrenteVO(), "Pesquisando contas correntes", true);
            if (conta != null) {
                this.textCodigoContaCorrenteDestino.setText(conta.getReduzido().toString());
                this.textDescricaoContaCorrenteDestino.setText(conta.getConta());
            } else {
                this.textDescricaoContaCorrenteDestino.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "TransferenciaConta:261");
        }
    }

    private void buscaDataConciliacao() {
        Funcoes.mostraData(this.textDataConciliacao, this.buttonDataConciliacao, this.painelCentral, true);
    }

    @Override
    public void pressioneiF2() {
        if (this.textDataConciliacao.hasFocus()) {
            this.buscaDataConciliacao();
        } else if (this.textCodigoContaCorrenteOrigem.hasFocus()) {
            this.buscaContaCorrenteOrigem();
        } else if (this.textCodigoContaCorrenteDestino.hasFocus()) {
            this.buscaContaCorrenteDestino();
        } else if (this.textCodigoHistoricoOrigem.hasFocus()) {
            this.buscaHistoricoOrigem();
            if (this.textDescricaoHistoricoOrigemUsuario.isEnabled()) {
                this.textDescricaoHistoricoOrigemUsuario.grabFocus();
            }
        } else if (this.textCodigoHistoricoDestino.hasFocus()) {
            this.buscaHistoricoDestino();
            if (this.textDescricaoHistoricoDestinoUsuario.isEnabled()) {
                this.textDescricaoHistoricoDestinoUsuario.grabFocus();
            }
        }
        this.controlaCampos();
    }

    @Override
    public void novo() {
        super.novo();
        if (Acesso.getAcesso(ACESSO_ALTERAR_CENTRO_CUSTO) || Acesso.getAcesso(ACESSO_ALTERAR_PLANO_CONTAS)) {
            this.lancamentoOrigem = new LancamentoBean();
            this.lancamentoOrigem.setTipo("D");
            this.lancamentoDestino = new LancamentoBean();
            this.lancamentoDestino.setTipo("C");
        }
        ScreenUtil.requisitarFoco(this.textValor);
    }

    @Override
    public void salvar() {
        if (this.validaCampos()) {
            try {
                if (Funcoes.textoVazio(this.textDataConciliacao.getText())) {
                    throw new ConstrutorException("Data da transfer\u00eancia n\u00e3o informado.");
                }
                Date data = Funcoes.stringToDate("dd/MM/yyyy", this.textDataConciliacao.getText());
                Double valor = Funcoes.textoVazio(this.textValor.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValor.getText()));
                FilialVO filial = new FilialVO();
                filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                UsuarioVO usuario = new UsuarioVO();
                usuario.setCodigo(Variaveis.login);
                EstacaoVO estacao = new EstacaoVO();
                estacao.setCodigo(Integer.parseInt(Variaveis.codigoEstacao));
                ContaCorrenteVO contaOrigem = new ContaCorrenteVO();
                contaOrigem.setFilial(filial);
                contaOrigem.setReduzido(Integer.parseInt(this.textCodigoContaCorrenteOrigem.getText()));
                ContaCorrenteVO contaDestino = new ContaCorrenteVO();
                contaDestino.setFilial(filial);
                contaDestino.setReduzido(Integer.parseInt(this.textCodigoContaCorrenteDestino.getText()));
                HistoricoPadraoVO historicoOrigem = new HistoricoPadraoVO();
                historicoOrigem.setFilial(filial);
                historicoOrigem.setDescricao(this.textDescricaoHistoricoOrigemUsuario.getText());
                historicoOrigem.setCodigo(Integer.parseInt(this.textCodigoHistoricoOrigem.getText()));
                HistoricoPadraoVO historicoDestino = new HistoricoPadraoVO();
                historicoDestino.setFilial(filial);
                historicoDestino.setDescricao(this.textDescricaoHistoricoDestinoUsuario.getText());
                historicoDestino.setCodigo(Integer.parseInt(this.textCodigoHistoricoDestino.getText()));
                LancamentoBean lanctoBean = new LancamentoBean();
                lanctoBean.setTipoPagamento("D");
                if (this.transferenciaEntreContasCorrentes) {
                    String tipoPagamento = Tipos.getTipoPagamento(this.comboTipoPagamento.getSelectedItem().toString());
                    lanctoBean = new LancamentoBean();
                    lanctoBean.setTipoPagamento(tipoPagamento);
                    if (tipoPagamento.equalsIgnoreCase("Z")) {
                        lanctoBean.setNumeroDocumento(this.textAutDebito.getText());
                    } else if (tipoPagamento.equalsIgnoreCase("I") || tipoPagamento.equalsIgnoreCase("O")) {
                        lanctoBean.setValidadeCartao(Funcoes.textoVazio(this.textValidadeCartao.getText()) ? null : Funcoes.getData("dd/MM/yyyy", this.textValidadeCartao.getText()));
                        lanctoBean.setNumeroCartao(this.textNumeroCartao.getText());
                        lanctoBean.setCartaoCredito(this.cbxCartaoCredito.getSelectedItem().toString());
                    } else if (tipoPagamento.equalsIgnoreCase("A") || tipoPagamento.equalsIgnoreCase("H") || tipoPagamento.equalsIgnoreCase("T") || tipoPagamento.equalsIgnoreCase("P")) {
                        lanctoBean.setBanco(Funcoes.textoVazio(this.textBanco.getText()) ? null : Integer.valueOf(Integer.parseInt(this.textBanco.getText())));
                        lanctoBean.setAgencia(Funcoes.textoVazio(this.textAgencia.getText()) ? null : this.textAgencia.getText());
                        lanctoBean.setConta(Funcoes.textoVazio(this.textContaCheque) ? null : this.textContaCheque.getText());
                        lanctoBean.setNumeroCheque(Funcoes.textoVazio(this.textNumeroCheque) ? null : this.textNumeroCheque.getText());
                        lanctoBean.setSacado(this.textSacado.getText());
                    }
                }
                lanctoBean.setTipoDocumento("C");
                lanctoBean.setObservacao("Lan\u00e7amento gerado por Transfer\u00eancia entre Contas.");
                if (Acesso.getAcesso(ACESSO_ALTERAR_CENTRO_CUSTO) || Acesso.getAcesso(ACESSO_ALTERAR_PLANO_CONTAS)) {
                    if (((LancamentoService)this.service).transferenciaEntreContas(contaOrigem, contaDestino, data, valor, lanctoBean, filial, usuario, estacao, historicoOrigem, historicoDestino, false, this.panelPlanoCustoOrigem.getPlanoContas(), this.panelPlanoCustoOrigem.getCentrosCusto(), this.panelPlanoCustoDestino.getPlanoContas(), this.panelPlanoCustoDestino.getCentrosCusto())) {
                        Conexao.arquivaSQL();
                        this.limparCampos();
                        this.setStatus(1);
                        this.controlaCampos();
                    } else {
                        Conexao.anulaSQL();
                    }
                } else if (((LancamentoService)this.service).transferenciaEntreContas(contaOrigem, contaDestino, data, valor, lanctoBean, filial, usuario, estacao, historicoOrigem, historicoDestino, false, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList())) {
                    Conexao.arquivaSQL();
                    this.limparCampos();
                    this.setStatus(1);
                    this.controlaCampos();
                } else {
                    Conexao.anulaSQL();
                }
                return;
            }
            catch (ConstrutorException e) {
                Funcoes.mensagem(this.getTopLevelAncestor(), e.getMessage(), 1);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "FrmCadPadraoBean:86");
            }
        }
    }

    private void buscaHistoricoOrigem(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoHistoricoOrigem.setText("");
            this.textDescricaoHistoricoOrigem.setText("");
            return;
        }
        try {
            HistoricoPadraoVO historico = (HistoricoPadraoVO)this.historicoPadraoService.getVO(Variaveis.filialPadrao, codigo);
            if (historico != null) {
                this.textCodigoHistoricoOrigem.setText(historico.getCodigo().toString());
                this.textDescricaoHistoricoOrigem.setText(historico.getDescricao());
                this.textDescricaoHistoricoOrigemUsuario.grabFocus();
            } else {
                this.textDescricaoHistoricoOrigem.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "TransferenciaConta:461");
        }
    }

    private void buscaHistoricoOrigem() {
        try {
            this.textCodigoHistoricoOrigem.setText("");
            this.textDescricaoHistoricoOrigem.setText("");
            HistoricoPadraoVO historico = (HistoricoPadraoVO)this.historicoPadraoService.pesquisaVO(this.getTopLevelAncestor(), new HistoricoPadraoVO(), "Pesquisando hist\u00f3ricos", true);
            if (historico != null) {
                this.textCodigoHistoricoOrigem.setText(historico.getCodigo().toString());
                this.textDescricaoHistoricoOrigem.setText(historico.getDescricao());
                this.controlaCampos();
            } else {
                this.textDescricaoHistoricoOrigem.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "TransferenciaConta:476");
        }
    }

    private void buscaHistoricoDestino(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoHistoricoDestino.setText("");
            this.textDescricaoHistoricoDestino.setText("");
            return;
        }
        try {
            HistoricoPadraoVO historico = (HistoricoPadraoVO)this.historicoPadraoService.getVO(Variaveis.filialPadrao, codigo);
            if (historico != null) {
                this.textCodigoHistoricoDestino.setText(historico.getCodigo().toString());
                this.textDescricaoHistoricoDestino.setText(historico.getDescricao());
                this.controlaCampos();
            } else {
                this.textDescricaoHistoricoDestino.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "TransferenciaConta:461");
        }
    }

    private void buscaHistoricoDestino() {
        try {
            this.textCodigoHistoricoDestino.setText("");
            this.textDescricaoHistoricoDestino.setText("");
            HistoricoPadraoVO historico = (HistoricoPadraoVO)this.historicoPadraoService.pesquisaVO(this.getTopLevelAncestor(), new HistoricoPadraoVO(), "Pesquisando hist\u00f3ricos", true);
            if (historico != null) {
                this.textCodigoHistoricoDestino.setText(historico.getCodigo().toString());
                this.textDescricaoHistoricoDestino.setText(historico.getDescricao());
            } else {
                this.textDescricaoHistoricoDestino.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "TransferenciaConta:476");
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    class BuscaBeanPreenchidoDestino
    implements BuscaBeanPreenchido {
        BuscaBeanPreenchidoDestino() {
        }

        @Override
        public AbstractThreadBean buscaBeanPreenchido(PanelPlanoContaCentroCusto source) {
            Double valorTotal = 0.0;
            if (!Funcoes.textoVazio(TransferenciaConta.this.textValor)) {
                valorTotal = Double.parseDouble(Funcoes.limpaDecimal(TransferenciaConta.this.textValor.getText()));
            }
            TransferenciaConta.this.lancamentoDestino.setValor(valorTotal);
            TransferenciaConta.this.lancamentoDestino.setValorTotal(valorTotal);
            return TransferenciaConta.this.lancamentoDestino;
        }
    }

    class BuscaBeanPreenchidoOrigem
    implements BuscaBeanPreenchido {
        BuscaBeanPreenchidoOrigem() {
        }

        @Override
        public AbstractThreadBean buscaBeanPreenchido(PanelPlanoContaCentroCusto source) {
            Double valorTotal = 0.0;
            if (!Funcoes.textoVazio(TransferenciaConta.this.textValor)) {
                valorTotal = Double.parseDouble(Funcoes.limpaDecimal(TransferenciaConta.this.textValor.getText()));
            }
            TransferenciaConta.this.lancamentoOrigem.setValor(valorTotal);
            TransferenciaConta.this.lancamentoOrigem.setValorTotal(valorTotal);
            return TransferenciaConta.this.lancamentoOrigem;
        }
    }
}

