/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.model.bean.financeiro.LancamentoCentroCustoBean;
import jalis.model.bean.financeiro.LancamentoPlanoContaBean;
import jalis.model.bean.recepcao.RequisicaoLanctoCaixaBean;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.HistoricoPadraoVO;
import jalis.model.vo.cadastro.financeiro.ContaCorrenteVO;
import jalis.model.vo.financeiro.LancamentoVO;
import jalis.model.vo.financeiro.TransferenciaCaixaVO;
import jalis.service.cadastro.auxiliares.HistoricoPadraoService;
import jalis.service.cadastro.financeiro.ContaCorrenteService;
import jalis.service.financeiro.LancamentoService;
import jalis.service.financeiro.TransferenciaCaixaService;
import jalis.service.recepcao.RequisicaoLanctoCaixaService;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class TransferenciaCaixa
extends FrmCadPadraoBean
implements ActionListener {
    private final int COLUNA_DATA_HORA = 0;
    private final int COLUNA_LANCAMENTO_TIPO = 1;
    private final int COLUNA_SELECAO = 4;
    private final int COLUNA_LANCAMENTO_CODIGO_LANCAMENTO = 5;
    private final int COLUNA_LANCAMENTO_CODIGO_ESTACAO = 6;
    private final int COLUNA_VALOR = 7;
    private final int COLUNA_TIPO_PAGAMENTO = 8;
    private final int COLUNA_RESUMO_TIPO_PAGAMANTO = 0;
    private final int COLUNA_RESUMO_CONTA_DESTINO_DESCRICAO = 2;
    private final int COLUNA_RESUMO_CONTA_DESTINO_OBJ = 4;
    private final int COLUNA_RESUMO_HISTORICO_PADRAO_OBJ = 5;
    private final int COLUNA_RESUMO_DESCRICAO_HISTORICO_OBJ = 6;
    private JLabel labelConta = new JLabel("Conta de Origem:");
    private JLabel labelDescConta = new JLabel();
    private JLabel labelDataInicial = new JLabel("Data Inicial");
    private JLabel labelDataFinal = new JLabel("Data Final");
    private JLabel labelContaDestino = new JLabel("Conta de Destino:");
    private JLabel labelDescContaDestino = new JLabel();
    private JLabel labelHistoricoDestino = new JLabel("Hist\u00f3rico Padr\u00e3o:");
    private JLabel labelDescHistoricoDestino = new JLabel();
    private JLabel labelDescricaoHistoricoDestino = new JLabel("Descri\u00e7\u00e3o Hist\u00f3rico:");
    private JLabel labelHoraInicial = new JLabel("Hora Inicial");
    private JLabel labelHoraFinal = new JLabel("Hora Final");
    private JLabel labelQtdeSelecionada = new JLabel("Qtde. Selecionada: ");
    private JLabel labelVlrQtdeSelecionada = new JLabel();
    private JLabel labelValorSelecionado = new JLabel("Valor Selecionado: ");
    private JLabel labelVlrValorSelecionado = new JLabel();
    private JButton buttonConta = new JButton();
    private JButton buttonDataInicial = new JButton();
    private JButton buttonDataFinal = new JButton();
    private JButton buttonContaDestino = new JButton();
    private JButton buttonHistoricoDestino = new JButton();
    private JButton buttonBuscar = new JButton("Consultar");
    private JButton buttonOK = new JButton("OK");
    private TTextField textConta = new TTextField(8, 1);
    private TTextField textDataInicial = new TTextField(10, 4);
    private TTextField textDataFinal = new TTextField(10, 4);
    private TTextField textContaDestino = new TTextField(8, 1);
    private TTextField textHistoricoDestino = new TTextField(8, 1);
    private TTextField textDescricaoHistoricoDestino = new TTextField(60, 3);
    private TTextField textHoraInicial = new TTextField(5, 6);
    private TTextField textHoraFinal = new TTextField(5, 6);
    private JPanel panelContaOrigem = new JPanel(new GridBagLayout());
    private JPanel panelFiltros = new JPanel(new GridBagLayout());
    private JPanel panelDetalhesTransferencia = new JPanel(new GridBagLayout());
    private JPanel panelDetalhesDestino = new JPanel(new GridBagLayout());
    private JPanel panelSelecionados = new JPanel(new FlowLayout(2));
    private CheckItemFiltro filtroUsuario = new CheckItemFiltro("Usu\u00e1rio", "Filtrar", "Filtrando usu\u00e1rios", "");
    private JCheckBox checkIntervaloHora = new JCheckBox("Intervalo de Hora");
    private ModeloGridTable modeloLancamentos = new ModeloGridTable(new String[]{"Data/Hora", "Tipo", "Valor Total", "Usu\u00e1rio", ""}){

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 4;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Object[] classes = new Object[]{String.class, String.class, String.class, String.class, Boolean.class};
            return (Class)classes[columnIndex];
        }
    };
    private ModeloGridTable modeloResumoPagamentos = new ModeloGridTable(new String[]{"Tipo de pagamento", "Valor", "Conta destino"});
    private JTable tableLancamentos = new JTable(this.modeloLancamentos);
    private JTable tableResumoPagamentos = new JTable(this.modeloResumoPagamentos);
    private JScrollPane scrollPagamentos = new JScrollPane(this.tableLancamentos);
    private JScrollPane scrollResumoPagamentos = new JScrollPane(this.tableResumoPagamentos);
    private ContaCorrenteVO contaCorrenteVOOrigem = null;
    private ContaCorrenteVO contaCorrenteVODestino = null;
    private HistoricoPadraoVO historicoPadraoVO = null;
    private String descricaoHistorico = null;
    private static int casas = ParametrosGerais.getCasasPrecoExame();
    private static RoundingMode round = ParametrosGerais.getArredondamentoPrecoExame();
    private boolean editarTransferencia = false;
    private String tipoPagamento = null;

    public TransferenciaCaixa() {
        this.montaTela();
        this.controlaCampos();
        this.atualizaTotalizadores();
    }

    private void montaTela() {
        Funcoes.criaBarraDescricao(this, "Transfer\u00eancia de Caixa", "Transfer\u00eancia de pagamentos realizados por caixa", "financeiro/transf_conta.jpg");
        ScreenUtil.setBorda(new Component[]{this.labelDescConta, this.labelDescContaDestino, this.labelDescHistoricoDestino}, new TitledBorder(""));
        this.botaoSalvar.setText("Transferir");
        this.painelBotoes.remove(this.botaoEditar);
        this.painelBotoes.remove(this.botaoExcluir);
        this.painelCentral.setLayout(new GridBagLayout());
        this.filtroUsuario.setDados("usuario", new String[]{"usr_codigo", "usr_nome"}, new String[]{"Usu\u00e1rio", "Nome"}, new int[]{70, 0});
        this.filtroUsuario.setColunaHint(1);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(1, 0, 1, 0);
        this.painelCentral.add((Component)this.panelContaOrigem, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.panelFiltros, c);
        c.fill = 1;
        ++c.gridy;
        c.gridwidth = 1;
        c.gridheight = 3;
        c.weighty = 1.0;
        this.scrollPagamentos.setMinimumSize(new Dimension(350, 1));
        this.painelCentral.add((Component)ComponenteFactory.novoJPanelBorderLayout("Lan\u00e7amento", (Component)this.scrollPagamentos, null, null, null, null), c);
        c.gridx = 1;
        c.gridheight = 1;
        this.painelCentral.add((Component)ComponenteFactory.novoJPanelBorderLayout("Resumo de pagamentos", (Component)this.scrollResumoPagamentos, null, null, null, null), c);
        c.fill = 2;
        ++c.gridy;
        c.weighty = 0.0;
        this.painelCentral.add((Component)this.panelSelecionados, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.panelDetalhesTransferencia, c);
        this.panelSelecionados.setPreferredSize(new Dimension(370, 25));
        this.panelSelecionados.setSize(this.panelSelecionados.getPreferredSize());
        this.panelSelecionados.setMinimumSize(this.panelSelecionados.getPreferredSize());
        this.panelSelecionados.setMaximumSize(this.panelSelecionados.getPreferredSize());
        this.panelSelecionados.add(this.labelQtdeSelecionada);
        this.panelSelecionados.add(this.labelVlrQtdeSelecionada);
        this.panelSelecionados.add(new JLabel("  -  "));
        this.panelSelecionados.add(this.labelValorSelecionado);
        this.panelSelecionados.add(this.labelVlrValorSelecionado);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(1, 0, 1, 0);
        this.labelConta.setDisplayedMnemonic('o');
        this.labelConta.setLabelFor(this.textConta);
        this.panelContaOrigem.add((Component)this.labelConta, c);
        ++c.gridx;
        Dimension d = new Dimension(80, 20);
        this.textConta.setPreferredSize(d);
        this.textConta.setMinimumSize(d);
        this.panelContaOrigem.add((Component)this.textConta, c);
        ++c.gridx;
        d = new Dimension(20, 20);
        this.buttonConta.setPreferredSize(d);
        this.buttonConta.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonConta);
        this.buttonConta.setFocusable(false);
        this.buttonConta.addActionListener(this);
        this.panelContaOrigem.add((Component)this.buttonConta, c);
        ++c.gridx;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.fill = 2;
        d = new Dimension(20, 20);
        this.labelDescConta.setPreferredSize(d);
        this.labelDescConta.setMinimumSize(d);
        this.panelContaOrigem.add((Component)this.labelDescConta, c);
        JPanel panelFiltroData = new JPanel(new GridBagLayout());
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.insets = new Insets(1, 0, 1, 0);
        this.labelDataInicial.setDisplayedMnemonic('D');
        this.labelDataInicial.setLabelFor(this.textDataInicial);
        panelFiltroData.add((Component)this.labelDataInicial, c);
        c.gridx += 2;
        c.insets = new Insets(1, 20, 1, 0);
        this.labelDataFinal.setDisplayedMnemonic('i');
        this.labelDataFinal.setLabelFor(this.textDataFinal);
        panelFiltroData.add((Component)this.labelDataFinal, c);
        c.gridx += 2;
        c.gridwidth = 1;
        this.labelHoraInicial.setDisplayedMnemonic('r');
        this.labelHoraInicial.setLabelFor(this.textHoraInicial);
        panelFiltroData.add((Component)this.labelHoraInicial, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.labelHoraFinal.setDisplayedMnemonic('a');
        this.labelHoraFinal.setLabelFor(this.textHoraFinal);
        panelFiltroData.add((Component)this.labelHoraFinal, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = new Insets(1, 0, 1, 0);
        d = new Dimension(90, 20);
        this.textDataInicial.setPreferredSize(d);
        this.textDataInicial.setMinimumSize(d);
        panelFiltroData.add((Component)this.textDataInicial, c);
        ++c.gridx;
        d = new Dimension(20, 20);
        this.buttonDataInicial.setPreferredSize(d);
        this.buttonDataInicial.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonDataInicial);
        this.buttonDataInicial.setFocusable(false);
        this.buttonDataInicial.addActionListener(this);
        panelFiltroData.add((Component)this.buttonDataInicial, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 1, 0);
        d = new Dimension(90, 20);
        this.textDataFinal.setPreferredSize(d);
        this.textDataFinal.setMinimumSize(d);
        panelFiltroData.add((Component)this.textDataFinal, c);
        ++c.gridx;
        c.insets = new Insets(1, 0, 1, 0);
        d = new Dimension(20, 20);
        this.buttonDataFinal.setPreferredSize(d);
        this.buttonDataFinal.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonDataFinal);
        this.buttonDataFinal.setFocusable(false);
        this.buttonDataFinal.addActionListener(this);
        panelFiltroData.add((Component)this.buttonDataFinal, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 1, 0);
        d = new Dimension(60, 20);
        this.textHoraInicial.setPreferredSize(d);
        this.textHoraInicial.setMinimumSize(d);
        panelFiltroData.add((Component)this.textHoraInicial, c);
        ++c.gridx;
        c.gridwidth = 2;
        d = new Dimension(60, 20);
        this.textHoraFinal.setPreferredSize(d);
        this.textHoraFinal.setMinimumSize(d);
        panelFiltroData.add((Component)this.textHoraFinal, c);
        c.gridx += 2;
        this.checkIntervaloHora.setMnemonic('v');
        panelFiltroData.add((Component)this.checkIntervaloHora, c);
        c.gridx += 2;
        c.gridwidth = 1;
        c.fill = 2;
        c.weightx = 1.0;
        panelFiltroData.add((Component)this.filtroUsuario, c);
        JPanel panelFiltroOutros = new JPanel(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.insets = new Insets(1, 0, 1, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.anchor = 17;
        ++c.gridx;
        c.anchor = 13;
        c.weightx = 1.0;
        this.buttonBuscar.setMnemonic('l');
        this.buttonBuscar.addActionListener(this);
        panelFiltroOutros.add((Component)this.buttonBuscar, c);
        this.panelFiltros.setBorder(new TitledBorder("Filtros"));
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.panelFiltros.add((Component)panelFiltroData, c);
        ++c.gridy;
        this.panelFiltros.add((Component)panelFiltroOutros, c);
        this.panelDetalhesTransferencia.setBorder(new TitledBorder("Detalhes da Transfer\u00eancia"));
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.panelDetalhesTransferencia.add((Component)this.panelDetalhesDestino, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(1, 0, 1, 0);
        this.labelContaDestino.setDisplayedMnemonic('t');
        this.labelContaDestino.setLabelFor(this.textContaDestino);
        this.panelDetalhesDestino.add((Component)this.labelContaDestino, c);
        ++c.gridx;
        d = new Dimension(80, 20);
        this.textContaDestino.setPreferredSize(d);
        this.textContaDestino.setMinimumSize(d);
        this.panelDetalhesDestino.add((Component)this.textContaDestino, c);
        ++c.gridx;
        d = new Dimension(20, 20);
        this.buttonContaDestino.setPreferredSize(d);
        this.buttonContaDestino.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonContaDestino);
        this.buttonContaDestino.setFocusable(false);
        this.buttonContaDestino.addActionListener(this);
        this.panelDetalhesDestino.add((Component)this.buttonContaDestino, c);
        ++c.gridx;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.fill = 2;
        d = new Dimension(20, 20);
        this.labelDescContaDestino.setPreferredSize(d);
        this.labelDescContaDestino.setMinimumSize(d);
        this.panelDetalhesDestino.add((Component)this.labelDescContaDestino, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.labelHistoricoDestino.setDisplayedMnemonic('H');
        this.labelHistoricoDestino.setLabelFor(this.textHistoricoDestino);
        this.panelDetalhesDestino.add((Component)this.labelHistoricoDestino, c);
        ++c.gridx;
        d = new Dimension(80, 20);
        this.textHistoricoDestino.setPreferredSize(d);
        this.textHistoricoDestino.setMinimumSize(d);
        this.panelDetalhesDestino.add((Component)this.textHistoricoDestino, c);
        ++c.gridx;
        d = new Dimension(20, 20);
        this.buttonHistoricoDestino.setPreferredSize(d);
        this.buttonHistoricoDestino.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonHistoricoDestino);
        this.buttonHistoricoDestino.setFocusable(false);
        this.buttonHistoricoDestino.addActionListener(this);
        this.panelDetalhesDestino.add((Component)this.buttonHistoricoDestino, c);
        ++c.gridx;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.fill = 2;
        d = new Dimension(20, 20);
        this.labelDescHistoricoDestino.setPreferredSize(d);
        this.labelDescHistoricoDestino.setMinimumSize(d);
        this.panelDetalhesDestino.add((Component)this.labelDescHistoricoDestino, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.labelDescricaoHistoricoDestino.setDisplayedMnemonic('e');
        this.labelDescricaoHistoricoDestino.setLabelFor(this.textDescricaoHistoricoDestino);
        this.panelDetalhesDestino.add((Component)this.labelDescricaoHistoricoDestino, c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.fill = 2;
        JPanel painelDescricaoDetalhe = new JPanel(new GridBagLayout());
        this.panelDetalhesDestino.add((Component)painelDescricaoDetalhe, c);
        c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(1, 0, 1, 0);
        painelDescricaoDetalhe.add((Component)this.textDescricaoHistoricoDestino, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        painelDescricaoDetalhe.add((Component)this.buttonOK, c);
        d = new Dimension(20, 20);
        this.textDescricaoHistoricoDestino.setPreferredSize(d);
        this.textDescricaoHistoricoDestino.setMinimumSize(d);
        this.buttonOK.setPreferredSize(new Dimension(40, 20));
        this.buttonOK.setSize(this.buttonOK.getPreferredSize());
        this.buttonOK.setMinimumSize(this.buttonOK.getPreferredSize());
        this.buttonOK.setMaximumSize(this.buttonOK.getPreferredSize());
        this.buttonOK.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOK.addActionListener(this);
        TableModelListener tableListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TransferenciaCaixa.this.atualizaTotalizadores();
            }
        };
        this.textHistoricoDestino.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    TransferenciaCaixa.this.buttonHistoricoDestino.doClick();
                }
            }
        });
        this.textHistoricoDestino.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TransferenciaCaixa.this.getHistoricoDestino();
            }
        });
        this.textContaDestino.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    TransferenciaCaixa.this.buttonContaDestino.doClick();
                }
            }
        });
        this.textContaDestino.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TransferenciaCaixa.this.getContaDestino();
            }
        });
        this.textConta.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    TransferenciaCaixa.this.buttonConta.doClick();
                }
            }
        });
        this.textConta.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TransferenciaCaixa.this.getContaOrigem();
            }
        });
        this.textDataInicial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    TransferenciaCaixa.this.buttonDataInicial.doClick();
                }
            }
        });
        this.textDataFinal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    TransferenciaCaixa.this.buttonDataFinal.doClick();
                }
            }
        });
        this.tableLancamentos.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = TransferenciaCaixa.this.tableLancamentos.getSelectedRow();
                if (row >= 0 && e.getKeyCode() == 32 && TransferenciaCaixa.this.tableLancamentos.getModel() == TransferenciaCaixa.this.modeloLancamentos) {
                    if (TransferenciaCaixa.this.tableLancamentos.getSelectedColumn() == 4) {
                        return;
                    }
                    boolean valor = (Boolean)TransferenciaCaixa.this.tableLancamentos.getValueAt(row, 4);
                    TransferenciaCaixa.this.tableLancamentos.setValueAt(!valor, row, 4);
                    TransferenciaCaixa.this.atualizaTotalTipoPagamento(row);
                }
                TransferenciaCaixa.this.atualizaTotalizadores();
            }
        });
        this.tableLancamentos.getDefaultEditor(Boolean.class).addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                TransferenciaCaixa.this.atualizaTotalTipoPagamento(TransferenciaCaixa.this.tableLancamentos.getSelectedRow());
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                TransferenciaCaixa.this.atualizaTotalTipoPagamento(TransferenciaCaixa.this.tableLancamentos.getSelectedRow());
            }
        });
        this.tableResumoPagamentos.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = TransferenciaCaixa.this.tableResumoPagamentos.getSelectedRow();
                if (row >= 0 && e.getKeyCode() == 32) {
                    TransferenciaCaixa.this.atualizarDetalhes();
                }
            }
        });
        this.tableResumoPagamentos.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TransferenciaCaixa.this.atualizarDetalhes();
                    return;
                }
                TransferenciaCaixa.this.limparCamposDetalhes();
                TransferenciaCaixa.this.controlaCampos();
            }
        });
        this.tableLancamentos.setSelectionMode(0);
        this.tableLancamentos.getTableHeader().setReorderingAllowed(false);
        this.tableLancamentos.getTableHeader().addMouseListener(this.modeloLancamentos);
        this.tableResumoPagamentos.setSelectionMode(0);
        this.tableResumoPagamentos.getTableHeader().setReorderingAllowed(false);
        this.modeloLancamentos.setColumnSize(new int[]{120, 100, 80, 0, 20}, this.tableLancamentos);
        this.modeloLancamentos.addTableModelListener(tableListener);
        this.modeloLancamentos.ordenarColunaSemTrocarSentido(0);
        this.modeloResumoPagamentos.setColumnSize(new int[]{130, 80, 0}, this.tableResumoPagamentos);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonConta) {
            this.pesquisaContaOrigem();
        } else if (e.getSource() == this.buttonDataInicial) {
            Funcoes.mostraData(this.textDataInicial, this.buttonDataInicial, this.panelFiltros, true);
        } else if (e.getSource() == this.buttonDataFinal) {
            Funcoes.mostraData(this.textDataFinal, this.buttonDataFinal, this.panelFiltros, true);
        } else if (e.getSource() == this.buttonBuscar) {
            this.pesquisaLancamentos();
        } else if (e.getSource() == this.buttonContaDestino) {
            this.pesquisaContaDestino();
        } else if (e.getSource() == this.buttonHistoricoDestino) {
            this.pesquisaHistoricoDestino();
        } else if (e.getSource() == this.buttonOK) {
            this.adicionaTransferencia();
        }
    }

    @Override
    protected void controlaCampos() {
        boolean enabled;
        boolean bl = enabled = this.getStatus() == 2;
        if (!this.possuiAcessoTransferir()) {
            this.botaoNovo.setEnabled(this.possuiAcessoTransferir());
            this.botaoNovo.setVisible(this.possuiAcessoTransferir());
            this.botaoSalvar.setVisible(this.possuiAcessoTransferir());
            this.botaoCancelar.setVisible(this.possuiAcessoTransferir());
        }
        this.buttonBuscar.setEnabled(enabled);
        this.buttonConta.setEnabled(enabled);
        this.buttonContaDestino.setEnabled(enabled && this.editarTransferencia);
        this.buttonDataInicial.setEnabled(enabled);
        this.buttonDataFinal.setEnabled(enabled);
        this.buttonHistoricoDestino.setEnabled(enabled && this.editarTransferencia);
        this.buttonOK.setEnabled(enabled && this.editarTransferencia);
        this.checkIntervaloHora.setEnabled(enabled);
        this.filtroUsuario.setEnabled(enabled);
        this.textConta.setEnabled(enabled);
        this.textContaDestino.setEnabled(enabled && this.editarTransferencia);
        this.textDataInicial.setEnabled(enabled);
        this.textDataFinal.setEnabled(enabled);
        this.textHistoricoDestino.setEnabled(enabled && this.editarTransferencia);
        this.textHoraInicial.setEnabled(enabled);
        this.textHoraFinal.setEnabled(enabled);
        this.tableLancamentos.setEnabled(enabled);
        this.tableResumoPagamentos.setEnabled(enabled);
        boolean ativaDescricaoHistorico = enabled && this.historicoPadraoVO != null && this.historicoPadraoVO.getPermiteDescrever() != null && this.historicoPadraoVO.getPermiteDescrever() != false && this.editarTransferencia;
        this.textDescricaoHistoricoDestino.setEnabled(ativaDescricaoHistorico);
    }

    @Override
    protected void limparCampos() {
        this.labelDescConta.setText("");
        this.textConta.clear();
        this.textDataInicial.clear();
        this.textDataFinal.clear();
        this.textHoraInicial.clear();
        this.textHoraFinal.clear();
        this.checkIntervaloHora.setSelected(false);
        this.filtroUsuario.setSelected(false);
        this.contaCorrenteVOOrigem = null;
        this.modeloLancamentos.clear();
        this.modeloResumoPagamentos.clear();
        this.limparCamposDetalhes();
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        return null;
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
    }

    @Override
    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    public boolean validaCampos() {
        if (this.contaCorrenteVOOrigem == null) {
            Funcoes.mensagem(this, "A conta de origem deve ser selecionada.", 2);
            ScreenUtil.requisitarFoco(this.textConta);
            return false;
        }
        if (this.tableLancamentos.getModel().getRowCount() == 0) {
            Funcoes.mensagem(this, "Existem tipos de pagamento sem lan\u00e7amento selecionado para transfer\u00eancia.", 2);
            return false;
        }
        boolean algumSelecionado = false;
        ArrayList<String> tipoSelecionado = new ArrayList<String>();
        if (this.tableLancamentos.getModel() == this.modeloLancamentos) {
            for (int i = 0; i < this.modeloLancamentos.getRowCount(); ++i) {
                if (!((Boolean)this.modeloLancamentos.getValueAt(i, 4)).booleanValue()) continue;
                algumSelecionado = true;
                tipoSelecionado.add(this.modeloLancamentos.getValueAt(i, 1).toString());
            }
        }
        if (!algumSelecionado) {
            Funcoes.mensagem(this, "Existem tipos de pagamento sem lan\u00e7amento selecionado para transfer\u00eancia.", 2);
            return false;
        }
        for (String tipo : tipoSelecionado) {
            if (!Funcoes.objectIsNull(this.modeloResumoPagamentos.getValueAt(this.modeloResumoPagamentos.localizar(0, tipo), 4))) continue;
            this.validaCamposDetalhes();
            return false;
        }
        return true;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        if (!this.possuiAcessoAlterarContaOrigem()) {
            this.textConta.setText(ParametrosLocais.getParametro("contaCaixa"));
            this.textConta.setEnabled(false);
            this.buttonConta.setEnabled(false);
            this.getContaOrigem();
        }
        ScreenUtil.requisitarFoco(this.textConta);
    }

    @Override
    public void salvar() {
        if (this.validaCampos()) {
            LancamentoService lanctoService = new LancamentoService();
            RequisicaoLanctoCaixaService reqLanctoService = new RequisicaoLanctoCaixaService();
            ArrayList<LancamentoBean> lancamentos = new ArrayList<LancamentoBean>();
            ArrayList lancamentosCodigos = this.getLancamentosSelecionados();
            if (lancamentosCodigos != null) {
                for (ArrayList codigo : lancamentosCodigos) {
                    try {
                        lancamentos.add((LancamentoBean)lanctoService.get(Variaveis.filialPadrao.toString(), String.valueOf(codigo.get(0)), String.valueOf(codigo.get(1))));
                    }
                    catch (Exception e) {
                        ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar informa\u00e7\u00f5es dos lan\u00e7amentos.\n" + e.getMessage(), e.getStackTrace());
                    }
                }
            }
            try {
                int CONTA_CORRENTE = 2;
                int HISTORICO_PADRAO = 3;
                int DESCRICAO_HISTORICO = 4;
                Date data = new Date();
                for (LancamentoBean aux : lancamentos) {
                    Integer codigoRequisicao = lanctoService.getRequisicaoOrigem(aux);
                    String situacaoAnterior = aux.getSituacao();
                    ContaCorrenteVO contaCorrenteVO = (ContaCorrenteVO)((ArrayList)lancamentosCodigos.get(lancamentos.indexOf(aux))).get(2);
                    HistoricoPadraoVO historicoPadraoVO = (HistoricoPadraoVO)((ArrayList)lancamentosCodigos.get(lancamentos.indexOf(aux))).get(3);
                    lanctoService.estornoCancelamento(aux, "P", false, null);
                    Integer codigoAux = aux.getCodigo();
                    EstacaoVO estacaoAux = aux.getEstacao();
                    aux.setCodigo(null);
                    aux.setComplementarCodigo(codigoAux);
                    aux.setComplementarEstacao(estacaoAux);
                    aux.setDataHora(data);
                    aux.setContaCorrente(contaCorrenteVO);
                    aux.setDescricaoHistorico((String)((ArrayList)lancamentosCodigos.get(lancamentos.indexOf(aux))).get(4));
                    aux.setHistoricoPadrao(historicoPadraoVO);
                    aux.setTipoOrigem("P");
                    aux.setDataCancelado(null);
                    aux.setUsuarioCancelado(null);
                    aux.setSituacao(situacaoAnterior);
                    aux.setDescricaoCancelado(null);
                    Set lanctoPlanos = aux.getPlanosContas();
                    HashSet<Object> novosLanctosPlanos = new HashSet<Object>();
                    for (LancamentoPlanoContaBean lanctoPlano : lanctoPlanos) {
                        LancamentoPlanoContaBean novoLanctoPlano = new LancamentoPlanoContaBean();
                        novoLanctoPlano.setFilial(lanctoPlano.getFilial());
                        novoLanctoPlano.setLancamento(lanctoPlano.getLancamento());
                        novoLanctoPlano.setOrigem(lanctoPlano.getOrigem());
                        novoLanctoPlano.setEstacao(lanctoPlano.getEstacao());
                        novoLanctoPlano.setPlanoConta(lanctoPlano.getPlanoConta());
                        novoLanctoPlano.setValor(lanctoPlano.getValor());
                        novoLanctoPlano.setInserir(true);
                        novosLanctosPlanos.add(novoLanctoPlano);
                    }
                    aux.setPlanosContas(novosLanctosPlanos);
                    Set lanctoCentros = aux.getCentrosCusto();
                    HashSet<LancamentoCentroCustoBean> novosLanctosCentros = new HashSet<LancamentoCentroCustoBean>();
                    for (LancamentoCentroCustoBean lanctoCentro : lanctoCentros) {
                        LancamentoCentroCustoBean novoLanctoCentro = new LancamentoCentroCustoBean();
                        novoLanctoCentro.setFilial(lanctoCentro.getFilial());
                        novoLanctoCentro.setLancamento(lanctoCentro.getLancamento());
                        novoLanctoCentro.setOrigem(lanctoCentro.getOrigem());
                        novoLanctoCentro.setEstacao(lanctoCentro.getEstacao());
                        novoLanctoCentro.setPlanoConta(lanctoCentro.getPlanoConta());
                        novoLanctoCentro.setValor(lanctoCentro.getValor());
                        novoLanctoCentro.setCentroCusto(lanctoCentro.getCentroCusto());
                        novoLanctoCentro.setInserir(true);
                        novosLanctosCentros.add(novoLanctoCentro);
                    }
                    aux.setCentrosCusto(novosLanctosCentros);
                    lanctoService.gravaAutoCopiaSemCommit(aux, 0, Variaveis.filialPadrao, null);
                    if (codigoRequisicao == null) continue;
                    RequisicaoLanctoCaixaBean reqLancto = new RequisicaoLanctoCaixaBean();
                    reqLancto.setFilial(aux.getFilial());
                    reqLancto.setLancamento((LancamentoVO)aux.toVO());
                    reqLancto.setEstacao(aux.getEstacao());
                    reqLancto.setRequisicao(codigoRequisicao);
                    reqLanctoService.insert(reqLancto, null, Variaveis.filialPadrao, null);
                }
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel transferir pagamentos.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    @Override
    public void cancelar() {
        this.limparCampos();
        this.setStatus(1);
        this.controlaCampos();
    }

    private void adicionaTransferencia() {
        this.descricaoHistorico = null;
        String descricaoContaDestino = "";
        if (!Funcoes.textoVazio(this.textDescricaoHistoricoDestino)) {
            this.descricaoHistorico = this.textDescricaoHistoricoDestino.getText().trim();
        }
        if (!(Funcoes.objectIsNull(this.contaCorrenteVODestino) && Funcoes.objectIsNull(this.historicoPadraoVO) && Funcoes.objectIsNull(this.descricaoHistorico))) {
            if (!this.validaCamposDetalhes()) {
                return;
            }
            descricaoContaDestino = this.contaCorrenteVODestino.getConta();
        }
        int linha = this.modeloResumoPagamentos.localizarContendo(0, this.tipoPagamento);
        this.modeloResumoPagamentos.setValueAt(descricaoContaDestino, linha, 2);
        this.modeloResumoPagamentos.setValueAt(this.contaCorrenteVODestino, linha, 4);
        this.modeloResumoPagamentos.setValueAt(this.historicoPadraoVO, linha, 5);
        this.modeloResumoPagamentos.setValueAt(this.descricaoHistorico, linha, 6);
        this.limparCamposDetalhes();
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.tableResumoPagamentos);
    }

    private void preencherDados() {
        this.modeloLancamentos.clear();
        this.modeloResumoPagamentos.clear();
        String dataInicial = this.textDataInicial.getText();
        String dataFinal = this.textDataFinal.getText();
        String horaInicial = this.textHoraInicial.getText();
        String horaFinal = this.textHoraFinal.getText();
        TransferenciaCaixaService transferenciaCaixaService = new TransferenciaCaixaService();
        ArrayList listaDados = new ArrayList();
        HashMap<String, BigDecimal> valoresAcumulados = new HashMap<String, BigDecimal>();
        try {
            listaDados = transferenciaCaixaService.pesquisaLancamento(Variaveis.filialPadrao, "C", this.contaCorrenteVOOrigem.getReduzido().toString(), this.checkIntervaloHora.isSelected(), dataInicial, dataFinal, horaInicial, horaFinal, this.filtroUsuario.getSelecionados());
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os pagamentos.\n" + e.getMessage(), e.getStackTrace());
        }
        for (TransferenciaCaixaVO transferenciaCaixaVO : listaDados) {
            String sTipoPagamento = transferenciaCaixaVO.getTipoPagamento();
            if (Funcoes.objectIsNull(sTipoPagamento)) {
                sTipoPagamento = "";
            }
            this.modeloLancamentos.addLine(new Object[]{Funcoes.formataData("dd/MM/yyyy HH:mm", transferenciaCaixaVO.getDataHora()), Tipos.tipoPagamento(transferenciaCaixaVO.getTipoPagamento()), Funcoes.formataDecimal(transferenciaCaixaVO.getValorTotal()), transferenciaCaixaVO.getUsuario(), true, transferenciaCaixaVO.getCodigoLancamento(), transferenciaCaixaVO.getCodigoEstacao(), new BigDecimal(transferenciaCaixaVO.getValorTotal()), sTipoPagamento});
            BigDecimal soma = new BigDecimal(transferenciaCaixaVO.getValorTotal()).setScale(casas, round);
            if (valoresAcumulados.containsKey(transferenciaCaixaVO.getTipoPagamento())) {
                soma = ((BigDecimal)valoresAcumulados.get(transferenciaCaixaVO.getTipoPagamento())).add(new BigDecimal(transferenciaCaixaVO.getValorTotal())).setScale(casas, round);
            }
            valoresAcumulados.put(transferenciaCaixaVO.getTipoPagamento(), soma);
        }
        for (String key : valoresAcumulados.keySet()) {
            String chaveAcesso = key;
            if (Funcoes.objectIsNull(chaveAcesso)) {
                chaveAcesso = "";
            }
            this.modeloResumoPagamentos.addLine(new Object[]{Tipos.tipoPagamento(key), Funcoes.formataDecimal(((BigDecimal)valoresAcumulados.get(key)).doubleValue()), "", chaveAcesso, null, null, null});
        }
        this.modeloLancamentos.ordenarColunaSemTrocarSentido(this.modeloLancamentos.getColunaOrdenacao());
    }

    private void atualizarDetalhes() {
        int linha = this.tableResumoPagamentos.getSelectedRow();
        if (!Funcoes.objectIsNull(this.modeloResumoPagamentos.getValueAt(linha, 4))) {
            this.contaCorrenteVODestino = (ContaCorrenteVO)this.modeloResumoPagamentos.getValueAt(linha, 4);
            this.textContaDestino.setText(this.contaCorrenteVODestino.getReduzido().toString());
            this.labelDescContaDestino.setText(this.contaCorrenteVODestino.getConta());
        }
        if (!Funcoes.objectIsNull(this.modeloResumoPagamentos.getValueAt(linha, 5))) {
            this.historicoPadraoVO = (HistoricoPadraoVO)this.modeloResumoPagamentos.getValueAt(linha, 5);
            this.textHistoricoDestino.setText(this.historicoPadraoVO.getCodigo().toString());
            this.labelDescHistoricoDestino.setText(this.historicoPadraoVO.getDescricao());
        }
        if (!Funcoes.objectIsNull(this.modeloResumoPagamentos.getValueAt(linha, 6))) {
            this.descricaoHistorico = this.modeloResumoPagamentos.getValueAt(linha, 6).toString();
            this.textDescricaoHistoricoDestino.setText(this.descricaoHistorico);
        }
        this.editarTransferencia = true;
        this.tipoPagamento = this.modeloResumoPagamentos.getValueAt(linha, 0).toString();
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.textContaDestino);
    }

    private void pesquisaLancamentos() {
        if (this.contaCorrenteVOOrigem == null) {
            Funcoes.mensagem(this, "\u00c9 necess\u00e1rio selecionar a conta de origem.", 2);
            ScreenUtil.requisitarFoco(this.textConta);
            return;
        }
        if (Funcoes.textoVazio(this.textDataInicial)) {
            Funcoes.mensagem(this, "\u00c9 necess\u00e1rio informar a data inicial.", 2);
            ScreenUtil.requisitarFoco(this.textDataInicial);
            return;
        }
        if (!Funcoes.textoVazio(this.textDataFinal) && Funcoes.getData("dd/MM/yyyy", this.textDataFinal.getText()).compareTo(Funcoes.getData("dd/MM/yyyy", this.textDataInicial.getText())) < 0) {
            Funcoes.mensagem(this, "A data final n\u00e3o pode ser anterior \u00e0 data inicial.", 2);
            ScreenUtil.requisitarFoco(this.textDataFinal);
            return;
        }
        this.limparCamposDetalhes();
        this.controlaCampos();
        this.preencherDados();
    }

    private void pesquisaContaOrigem() {
        try {
            ContaCorrenteVO conta = (ContaCorrenteVO)new ContaCorrenteService().pesquisaVO(Laboratorio.getInstancia(), new ContaCorrenteVO(), "Pesquisando Conta Corrente", true);
            if (conta != null) {
                this.textConta.setText(conta.getReduzido().toString());
                this.getContaOrigem();
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel pesquisar conta de origem.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void pesquisaContaDestino() {
        try {
            ContaCorrenteVO conta = (ContaCorrenteVO)new ContaCorrenteService().pesquisaVO(Laboratorio.getInstancia(), new ContaCorrenteVO(), "Pesquisando Conta Corrente", true);
            if (conta != null) {
                if (this.contaCorrenteVOOrigem != null && this.contaCorrenteVOOrigem.getReduzido().intValue() == conta.getReduzido().intValue()) {
                    Funcoes.mensagem(this, "A conta de destino dos pagamentos deve ser diferente da conta de origem.", 2);
                    return;
                }
                this.contaCorrenteVODestino = conta;
                this.textContaDestino.setText(conta.getReduzido().toString());
                this.labelDescContaDestino.setText(conta.getConta());
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel pesquisar conta de destino.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void pesquisaHistoricoDestino() {
        try {
            HistoricoPadraoVO historico = (HistoricoPadraoVO)new HistoricoPadraoService().pesquisaVO(this.getTopLevelAncestor(), new HistoricoPadraoVO(), "Pesquisando hist\u00f3ricos", true);
            if (historico != null) {
                this.textHistoricoDestino.setText(historico.getCodigo().toString());
                this.labelDescHistoricoDestino.setText(historico.getDescricao());
                this.historicoPadraoVO = historico;
                ScreenUtil.requisitarFoco(this.textDescricaoHistoricoDestino);
            }
            this.controlaCampos();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel pesquisar hist\u00f3rico padr\u00e3o.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void getContaOrigem() {
        if (Funcoes.textoVazio(this.textConta)) {
            this.labelDescConta.setText("");
            this.contaCorrenteVOOrigem = null;
        } else {
            try {
                ContaCorrenteVO conta = this.contaCorrenteVOOrigem;
                this.contaCorrenteVOOrigem = (ContaCorrenteVO)new ContaCorrenteService().getVO(Variaveis.filialPadrao.toString(), this.textConta.getText());
                if (conta != this.contaCorrenteVOOrigem) {
                    this.modeloLancamentos.clear();
                    this.modeloResumoPagamentos.clear();
                    this.limparCamposDetalhes();
                }
                if (this.contaCorrenteVOOrigem == null) {
                    this.labelDescConta.setText("N\u00e3o cadastrado");
                } else {
                    this.textConta.setText(this.contaCorrenteVOOrigem.getReduzido().toString());
                    this.labelDescConta.setText(this.contaCorrenteVOOrigem.getConta());
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar conta de origem.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    private void getContaDestino() {
        if (Funcoes.textoVazio(this.textContaDestino)) {
            this.labelDescContaDestino.setText("");
            this.contaCorrenteVODestino = null;
        } else {
            try {
                this.contaCorrenteVODestino = (ContaCorrenteVO)new ContaCorrenteService().getVO(Variaveis.filialPadrao.toString(), this.textContaDestino.getText());
                if (this.contaCorrenteVODestino == null) {
                    this.labelDescContaDestino.setText("N\u00e3o cadastrado");
                } else {
                    if (this.contaCorrenteVOOrigem != null && this.contaCorrenteVOOrigem.getReduzido().intValue() == this.contaCorrenteVODestino.getReduzido().intValue()) {
                        Funcoes.mensagem(this, "A conta de destino dos pagamentos deve ser diferente da conta de origem.", 2);
                        this.textContaDestino.clear();
                        this.labelDescContaDestino.setText("");
                        this.contaCorrenteVODestino = null;
                        ScreenUtil.requisitarFoco(this.textContaDestino);
                        return;
                    }
                    this.textContaDestino.setText(this.contaCorrenteVODestino.getReduzido().toString());
                    this.labelDescContaDestino.setText(this.contaCorrenteVODestino.getConta());
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar conta de destino.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    private void getHistoricoDestino() {
        if (Funcoes.textoVazio(this.textHistoricoDestino)) {
            this.labelDescHistoricoDestino.setText("");
            this.historicoPadraoVO = null;
        } else {
            try {
                this.historicoPadraoVO = (HistoricoPadraoVO)new HistoricoPadraoService().getVO(Variaveis.filialPadrao.toString(), this.textHistoricoDestino.getText());
                if (this.historicoPadraoVO == null) {
                    this.labelDescHistoricoDestino.setText("N\u00e3o cadastrado");
                    this.textDescricaoHistoricoDestino.setText("");
                } else {
                    this.labelDescHistoricoDestino.setText(this.historicoPadraoVO.getDescricao());
                    ScreenUtil.requisitarFoco(this.textDescricaoHistoricoDestino);
                }
                this.controlaCampos();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar hist\u00f3rico de destino.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    private ArrayList getLancamentosSelecionados() {
        ArrayList lancamentos = new ArrayList();
        if (this.tableLancamentos.getModel() == this.modeloLancamentos) {
            for (int i = 0; i < this.modeloLancamentos.getRowCount(); ++i) {
                if (!((Boolean)this.modeloLancamentos.getValueAt(i, 4)).booleanValue()) continue;
                int linha = this.modeloResumoPagamentos.localizar(0, this.modeloLancamentos.getValueAt(i, 1).toString());
                ArrayList<Object> elementos = new ArrayList<Object>();
                elementos.add(this.modeloLancamentos.getValueAt(i, 5));
                elementos.add(this.modeloLancamentos.getValueAt(i, 6));
                elementos.add(this.modeloResumoPagamentos.getValueAt(linha, 4));
                elementos.add(this.modeloResumoPagamentos.getValueAt(linha, 5));
                elementos.add(this.modeloResumoPagamentos.getValueAt(linha, 6));
                lancamentos.add(elementos);
            }
        }
        return lancamentos;
    }

    private void atualizaTotalTipoPagamento(int linha) {
        if (linha > -1) {
            String tipoPagamento = this.modeloLancamentos.getValueAt(linha, 8).toString();
            BigDecimal valor = ((BigDecimal)this.modeloLancamentos.getValueAt(linha, 7)).setScale(casas, round);
            Boolean selecionado = (Boolean)this.modeloLancamentos.getValueAt(linha, 4);
            int linhaTipoPagamento = this.modeloResumoPagamentos.localizar(3, tipoPagamento);
            if (linhaTipoPagamento > -1) {
                BigDecimal valorAtual = new BigDecimal(Funcoes.limpaDecimal(this.modeloResumoPagamentos.getValueAt(linhaTipoPagamento, 1).toString()));
                valorAtual = selecionado != false ? valorAtual.add(valor).setScale(casas, round) : valorAtual.subtract(valor).setScale(casas, round);
                this.modeloResumoPagamentos.setValueAt(Funcoes.formataDecimal(valorAtual.doubleValue()), linhaTipoPagamento, 1);
            }
        }
    }

    private void atualizaTotalizadores() {
        ModeloGridTable modelo = (ModeloGridTable)this.tableLancamentos.getModel();
        if (modelo != null && modelo.getColumnCount() > 0) {
            BigDecimal valor = BigDecimal.ZERO;
            int qtde = 0;
            if (this.tableLancamentos.getModel() == this.modeloLancamentos) {
                for (int i = 0; i < this.modeloLancamentos.getRowCount(); ++i) {
                    if (!((Boolean)this.modeloLancamentos.getValueAt(i, 4)).booleanValue()) continue;
                    ++qtde;
                    valor = valor.add(((BigDecimal)this.modeloLancamentos.getValueAt(i, 7)).setScale(casas, round));
                }
            }
            this.labelVlrQtdeSelecionada.setText("" + qtde);
            this.labelVlrValorSelecionado.setText(Funcoes.formataDecimal(valor.doubleValue()));
        } else {
            this.labelVlrQtdeSelecionada.setText("0");
            this.labelVlrValorSelecionado.setText(Funcoes.formataDecimal(0));
        }
    }

    private void limparCamposDetalhes() {
        this.editarTransferencia = false;
        this.contaCorrenteVODestino = null;
        this.historicoPadraoVO = null;
        this.descricaoHistorico = null;
        this.tipoPagamento = null;
        this.labelDescContaDestino.setText("");
        this.labelDescHistoricoDestino.setText("");
        this.textContaDestino.clear();
        this.textDescricaoHistoricoDestino.clear();
        this.textHistoricoDestino.clear();
    }

    private boolean validaCamposDetalhes() {
        if (this.contaCorrenteVODestino == null) {
            Funcoes.mensagem(this, "Existem tipos de pagamento sem conta destino selecionada.", 2);
            ScreenUtil.requisitarFoco(this.textContaDestino);
            return false;
        }
        if (this.historicoPadraoVO == null) {
            Funcoes.mensagem(this, "O hist\u00f3rico padr\u00e3o deve ser selecionado.", 2);
            ScreenUtil.requisitarFoco(this.textHistoricoDestino);
            return false;
        }
        return true;
    }

    private boolean possuiAcessoTransferir() {
        return Acesso.getAcesso(TransferenciaCaixa.getModuloTransferir());
    }

    private boolean possuiAcessoAlterarContaOrigem() {
        return Acesso.getAcesso(TransferenciaCaixa.getModuloAlterarContaOrigem());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600401400");
    }

    public static long getModuloAlterarContaOrigem() {
        return Long.parseLong("0600401401");
    }

    public static long getModuloTransferir() {
        return Long.parseLong("0600401402");
    }
}

