/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos;

import jalis.laboratorio.financeiro.lancamentos.ProtestoTitulos;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

class TituloRenderer
extends DefaultTableCellRenderer {
    @Override
    public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
        Component c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
        ModeloGridTable modelo = (ModeloGridTable)table.getModel();
        this.setValue(value);
        if (selected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        if (modelo.getValueAt(row, modelo.getColumnCount() - 1) != null) {
            ReceberPagarBean b = (ReceberPagarBean)modelo.getValueAt(row, modelo.findColumn("Objeto"));
            if (b.getSituacao().equalsIgnoreCase("T")) {
                c.setBackground(ProtestoTitulos.COR_CARTORIO);
            } else if (b.getSituacao().equalsIgnoreCase("S")) {
                c.setBackground(ProtestoTitulos.COR_PROTESTO);
            } else if (b.getSituacao().equalsIgnoreCase("V")) {
                c.setBackground(ProtestoTitulos.COR_AVISO_COBRANCA);
            }
            if (selected && c.getBackground() != table.getSelectionBackground()) {
                c.setBackground(ScreenUtil.escurecerCor(c.getBackground(), 30));
            }
        }
        if (focused) {
            Border border = selected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.focusCellHighlightBorder");
            ((JComponent)c).setBorder(border);
            if (!selected && table.isCellEditable(row, column)) {
                Color col = UIManager.getColor("Table.focusCellForeground");
                if (col != null) {
                    c.setForeground(col);
                }
                if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                    c.setBackground(col);
                }
            }
        } else {
            ((JComponent)c).setBorder(noFocusBorder);
        }
        return c;
    }
}

