/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class SolicitarDataConciliacao
extends AbstractDialogoOKCancelar {
    private boolean ok = false;
    private JLabel labelData = new JLabel("Data:");
    private TTextField textData = new TTextField(10, 4);
    private JButton buttonBuscaData = new JButton();

    public SolicitarDataConciliacao(Frame owner) {
        super(owner, "Data de concilia\u00e7\u00e3o");
        this.construirTela(owner);
    }

    private void construirTela(Component owner) {
        this.setSize(new Dimension(194, 100));
        this.setLocationRelativeTo(owner);
        this.setResizable(false);
        this.labelData.setDisplayedMnemonic('D');
        this.labelData.setLabelFor(this.textData);
        this.getPanelCentral().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.getPanelCentral().add((Component)this.labelData, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets.right = 0;
        this.textData.setPreferredSize(new Dimension(100, 20));
        this.textData.setMinimumSize(new Dimension(100, 20));
        this.getPanelCentral().add((Component)this.textData, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets.right = 1;
        c.insets.left = 0;
        this.getPanelCentral().add((Component)this.buttonBuscaData, c);
        this.labelData.setDisplayedMnemonic('D');
        this.labelData.setLabelFor(this.textData);
        this.buttonBuscaData.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonBuscaData);
        Funcoes.montaEnter((JComponent)this.getPanelCentral());
        ScreenUtil.requisitarFoco(this.textData);
        this.buttonBuscaData.addActionListener(e -> Funcoes.mostraData(this.textData, this.buttonBuscaData, this.getPanelCentral(), true));
        this.textData.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(SolicitarDataConciliacao.this.textData, SolicitarDataConciliacao.this.buttonBuscaData, SolicitarDataConciliacao.this.getPanelCentral(), true);
                }
            }
        });
    }

    public void setData(Date data) {
        if (data == null) {
            this.textData.setText(Funcoes.formataData(new Date()));
        } else {
            this.textData.setText(Funcoes.formataData(data));
        }
    }

    public Date getData() {
        return Funcoes.verificaData(this.textData.getText()) ? Funcoes.stringToDate(this.textData.getText()) : null;
    }

    @Override
    protected boolean acaoOk() {
        boolean dataMaiorQueHoje;
        this.ok = Funcoes.verificaData(this.textData.getText());
        boolean bl = dataMaiorQueHoje = this.ok && Funcoes.comparaData(new Date(), Funcoes.stringToDate(this.textData.getText())) < 0;
        if (!this.ok || dataMaiorQueHoje) {
            Funcoes.mensagem(this, dataMaiorQueHoje ? "A data de concilica\u00e7\u00e3o n\u00e3o pode ser superior a data atual" : "Data incorreta", 2);
            this.textData.grabFocus();
            return false;
        }
        return true;
    }
}

