/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos;

import jalis.comum.Tipos;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.vo.financeiro.LancamentoVO;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class SelecionarLancamentoLocalizado
extends AbstractDialogoOKCancelar {
    private final int COLUNA_VO = 6;
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Conta", "Tipo", "Vencimento", "Documento", "Pagamento", "Valor"});
    private JTable tabela = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.tabela);
    private LancamentoVO lancamentoSelecionado = null;

    public SelecionarLancamentoLocalizado(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela(pai);
    }

    public SelecionarLancamentoLocalizado(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela(pai);
    }

    public static SelecionarLancamentoLocalizado novaInstancia(Object owner) {
        if (owner instanceof Frame) {
            return new SelecionarLancamentoLocalizado((Frame)owner, "Selecionar lan\u00e7amento");
        }
        if (owner instanceof Dialog) {
            return new SelecionarLancamentoLocalizado((Dialog)owner, "Selecionar lan\u00e7amento");
        }
        return null;
    }

    private void montaTela(Component owner) {
        this.setSize(new Dimension(550, 250));
        this.setLocationRelativeTo(owner);
        this.setModal(true);
        this.modelo.setColumnSize(new int[]{100, 70, 80, 0, 70, 70}, this.tabela);
        JPanel panelCentro = this.getPanelCentral();
        panelCentro.setLayout(new BorderLayout());
        panelCentro.add((Component)this.scroll, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (SelecionarLancamentoLocalizado.this.tabela.getRowCount() > 0) {
                    ScreenUtil.requisitarFoco(SelecionarLancamentoLocalizado.this.tabela);
                }
            }
        });
    }

    @Override
    public boolean acaoOk() {
        this.lancamentoSelecionado = this.tabela.getSelectedRow() > -1 && this.modelo.getValueAt(this.tabela.getSelectedRow(), 6) != null && this.modelo.getValueAt(this.tabela.getSelectedRow(), 6) instanceof LancamentoVO ? (LancamentoVO)this.modelo.getValueAt(this.tabela.getSelectedRow(), 6) : null;
        return super.acaoOk();
    }

    public LancamentoVO getLancamentoSelecionado() {
        return this.lancamentoSelecionado;
    }

    public void adicionarLancamentoVO(LancamentoVO lancamento) {
        if (lancamento != null) {
            this.modelo.addLine(new Object[]{lancamento.getContaCorrente().getConta(), Tipos.tipoLancamentoCaixa(lancamento.getTipo()), Funcoes.formataData("dd/MM/yyyy", lancamento.getDataVencimento()), lancamento.getDocumento(), Tipos.tipoPagamento(lancamento.getTipoPagamento()), Funcoes.formataDecimal(lancamento.getValor()), lancamento});
        }
    }
}

