/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.lancamentos.FrmCadPadraoBeanLancamento;
import jalis.laboratorio.financeiro.lancamentos.componente.BuscaBeanPreenchido;
import jalis.laboratorio.financeiro.lancamentos.componente.PanelPlanoContaCentroCusto;
import jalis.laboratorio.financeiro.util.TiposApropriacao;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.financeiro.BaixaBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.dao.cadastro.auxiliares.FilialDao;
import jalis.model.dao.financeiro.ReceberPagarDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.financeiro.SeriesVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.EntidadeService;
import jalis.service.cadastro.PacienteService;
import jalis.service.cadastro.financeiro.CentroCustoService;
import jalis.service.cadastro.financeiro.PlanoContaService;
import jalis.service.cadastro.financeiro.SeriesService;
import jalis.service.financeiro.BaixaService;
import jalis.service.financeiro.ReceberPagarService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TAvisoLabel;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class ReceberPagar
extends FrmCadPadraoBeanLancamento
implements BuscaBeanPreenchido {
    private long ACESSO_VISUALIZAR_PLANOCONTA_CENTROCUSTO = Long.parseLong("0600400504");
    private long ACESSO_ALTERAR_PLANOCONTAS = Long.parseLong("0600400505");
    private long ACESSO_ALTERAR_CENTROSCUSTO = Long.parseLong("0600400506");
    private long ACESSO_PROIBIR_SEM_PLANO_CONTA = Long.parseLong("0600400507");
    private long ACESSO_PROIBIR_SEM_CENTRO_CUSTO = Long.parseLong("0600400508");
    private JTabbedPane tabValoresTitulo = new JTabbedPane();
    private JPanel panelValores = new JPanel();
    private JPanel panelImpostos = new JPanel();
    private JLabel lblValorTotal = new JLabel("Valor Total:");
    private JLabel lblIrrf = new JLabel("IRRF:");
    private JLabel lblIss = new JLabel("ISSQN:");
    private JLabel lblPis = new JLabel("PIS:");
    private JLabel lblCsll = new JLabel("CSLL:");
    private JLabel lblIpi = new JLabel("IPI:");
    private JLabel lblIcms = new JLabel("ICMS:");
    private JLabel lblCofins = new JLabel("COFINS:");
    private JLabel lblInss = new JLabel("INSS:");
    private JLabel lblIssRetido = new JLabel("ISS Ret.:");
    private JLabel lblIrrfPerc = new JLabel("%");
    private JLabel lblIssPerc = new JLabel("%");
    private JLabel lblPisPerc = new JLabel("%");
    private JLabel lblCsllPerc = new JLabel("%");
    private JLabel lblIpiPerc = new JLabel("%");
    private JLabel lblIcmsPerc = new JLabel("%");
    private JLabel lblCofinsPerc = new JLabel("%");
    private JLabel lblInssPerc = new JLabel("%");
    private JLabel lblIssRetidoPerc = new JLabel("%");
    private JLabel lblCodigo = new JLabel("C\u00f3digo:");
    private JLabel lblDataVencimento = new JLabel("Vencimento:");
    private JLabel lblDataCompetencia = new JLabel("Compet\u00eancia:");
    private JLabel lblValor = new JLabel("Valor T\u00edtulo:");
    private JLabel lblMulta = new JLabel("% Multa:");
    private JLabel lblJuro = new JLabel("% Juro:");
    private JLabel lblTipoJuro = new JLabel("Tipo Juro:");
    private JLabel lblDesconto = new JLabel("% Desconto:");
    private JLabel lblTipo = new JLabel("Tipo:");
    private JLabel lblTipoDocumento = new JLabel("Tipo Doc.:");
    private JLabel lblNumeroDocumento = new JLabel("Documento:");
    private JLabel lblTaxa = new JLabel("Valor Taxa:");
    private JLabel lblAcrescimo = new JLabel("% Acr\u00e9scimo:");
    private JLabel lblParcela = new JLabel("Parcela:");
    private JLabel lblCodigoDocumento = new JLabel("C\u00f3d. Doc.:");
    private JLabel lblDataDocumento = new JLabel("Data Doc.:");
    private JLabel lblDataProcessamento = new JLabel("Data Proces.:");
    private JLabel lblObservacao = new JLabel("Observa\u00e7\u00e3o:");
    private JLabel lblSerie = new JLabel("S\u00e9rie:");
    private JLabel lblTipoCadastro = new JLabel("Tipo Cadastro:");
    private JLabel lblCadastro = new JLabel("Cadastro:");
    private JLabel lblVlrValorTotal = new JLabel("");
    private JLabel lblSituacao = new JLabel("Situa\u00e7\u00e3o:");
    private TAvisoLabel lblVlrSituacao = new TAvisoLabel();
    private JLabel lblFrete = new JLabel("Valor Frete:");
    private TTextField textIrrf = new TTextField(10, 2, 2);
    private TTextField textIss = new TTextField(10, 2, 2);
    private TTextField textPis = new TTextField(10, 2, 2);
    private TTextField textCsll = new TTextField(10, 2, 2);
    private TTextField textCofins = new TTextField(10, 2, 2);
    private TTextField textInss = new TTextField(10, 2, 2);
    private TTextField textIpi = new TTextField(10, 2, 4);
    private TTextField textIcms = new TTextField(10, 2, 4);
    private TTextField textCodigo = new TTextField(10, 1);
    private TTextField textPercIrrf = new TTextField(8, 2, 4);
    private TTextField textPercIss = new TTextField(8, 2, 4);
    private TTextField textPercCsll = new TTextField(8, 2, 4);
    private TTextField textPercCofins = new TTextField(8, 2, 4);
    private TTextField textPercInss = new TTextField(8, 2, 4);
    private TTextField textPercIpi = new TTextField(8, 2, 4);
    private TTextField textPercIcms = new TTextField(8, 2, 4);
    private TTextField textPercPis = new TTextField(8, 2, 4);
    private TTextField textPercIssRetido = new TTextField(8, 2, 4);
    private TTextField textFrete = new TTextField(10, 2, 2);
    private TTextField textIssRetido = new TTextField(10, 2, 2);
    private JLabel lblVlrDataHora = new JLabel();
    private TTextField textDataVencimento = new TTextField(10, 4);
    private JButton buttonDataVencimento = new JButton();
    private JButton buttonRateioParcelas = new JButton();
    private TTextField textDataCompetencia = new TTextField(10, 4);
    private JButton buttonDataCompetencia = new JButton();
    private TTextField textValor = new TTextField(10, 2, 2);
    private TTextField textMulta = new TTextField(10, 2, 2);
    private TTextField textJuro = new TTextField(10, 2, 2);
    private JComboBox cbxTipoJuro = new JComboBox<String>(new String[]{Tipos.tipoJuros("D"), Tipos.tipoJuros("M"), Tipos.tipoJuros("A")});
    private TTextField textDesconto = new TTextField(10, 2, 2);
    private JComboBox cbxTipoDocumento = new JComboBox<String>(new String[]{Tipos.tipoDocumento("B"), Tipos.tipoDocumento("D"), Tipos.tipoDocumento("C"), Tipos.tipoDocumento("A")});
    private JComboBox cbxTipo = new JComboBox<String>(new String[]{Tipos.tipoReceberPagar("P"), Tipos.tipoReceberPagar("R")});
    private TTextField textNumeroDocumento = new TTextField(40, 3);
    private TTextField textTaxa = new TTextField(10, 2, 2);
    private TTextField textAcrescimo = new TTextField(10, 2, 2);
    private TTextField textParcela = new TTextField(3, 1);
    private TTextField textCodigoDocumento = new TTextField(40, 3);
    private TTextField textDataDocumento = new TTextField(10, 4);
    private JButton buttonDataDocumento = new JButton();
    private TTextField textDataProcessamento = new TTextField(10, 4);
    private JButton buttonDataProcessamento = new JButton();
    private JTextArea textObservacao = new JTextArea();
    private JScrollPane scrObservacao = new JScrollPane(this.textObservacao);
    private TTextField textCodigoSerie = new TTextField(5, 3);
    private TTextField textDescricaoSerie = new TTextField();
    private JButton buttonBuscaSerie = new JButton();
    private JComboBox cbxTipoCadastro = new JComboBox<String>(new String[]{Tipos.tipoCadastro("U"), Tipos.tipoCadastro("F"), Tipos.tipoCadastro("C"), Tipos.tipoCadastro("R"), Tipos.tipoCadastro("P"), Tipos.tipoCadastro("O")});
    private TTextField textCodigoCadastro = new TTextField(12, 1);
    private TTextField textDescricaoCadastro = new TTextField();
    private JButton buttonBuscaCadastro = new JButton();
    private JButton buttonGeraApropriacoes = new JButton("Gerar Apropria\u00e7\u00f5es");
    private JLabel lblCancelamento = new JLabel("");
    private JPanel panelCancelado = new JPanel(new BorderLayout());
    private JPanel panelDadosCancelado = new JPanel(new BorderLayout());
    private SeriesService seriesService = new SeriesService();
    private ConvenioService convenioService = new ConvenioService();
    private PacienteService pacienteService = new PacienteService();
    private EntidadeService entidadeService = new EntidadeService();
    private String tipoDebitoCredito = null;
    private PanelPlanoContaCentroCusto panelPlanoContaCentroCusto = new PanelPlanoContaCentroCusto(this, PanelPlanoContaCentroCusto.TIPO_RECEBER_PAGAR, this.ACESSO_ALTERAR_PLANOCONTAS, this.ACESSO_ALTERAR_CENTROSCUSTO, Variaveis.filialPadrao);
    private ReceberPagarBean beanDelete = null;
    private ReceberPagarBean beanAux = null;
    public static final int TIPO_RENEGOCIACAO_AGRUPADOR = 1;
    public static final int TIPO_RENEGOCIACAO_PARCELA = 2;
    public static final int TIPO_RENEGOCIACAO_OUTRO = 3;
    public static final int TIPO_NOVO_BAIXA = 4;
    private boolean isAgrupador = false;
    private boolean isParcela = false;
    public static final int MODAL_RESULT_CANCEL = -1;
    public static final int MODAL_RESULT_OK = 1;
    private static int resultadoModal = -1;
    private String situacao;
    private ArrayList<DadosParcelas> arrayDadosParcelas = null;
    private String origem = null;
    private NotaFiscalVO notaFiscal = null;
    private boolean haPlanos = false;
    private boolean haCentros = false;
    private String retornoParaPesquisa = "";
    private static String mascaraDecimalExibindoQuatroDigitos = "###,##0.0000";

    public ReceberPagar() {
        this.setLabelDescricao("Manuten\u00e7\u00e3o dos T\u00edtulos de Receber e Pagar");
        this.setLabelFormulario("Receber/Pagar");
        this.setIcone(ImagemUtils.carregaImagemJalis("financeiro/rec_pag.jpg"));
        Laboratorio.getInstancia().setComponenteMensagemVisivel(true);
        ScreenUtil.setBorda(new Component[]{this.lblVlrDataHora, this.lblVlrValorTotal, this.lblVlrSituacao}, new TitledBorder(""));
        Dimension d = new Dimension(80, 20);
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setMinimumSize(d);
        this.lblVlrSituacao.setPreferredSize(d);
        this.lblVlrSituacao.setMinimumSize(d);
        this.textDataCompetencia.setPreferredSize(d);
        this.textDataCompetencia.setMinimumSize(d);
        this.textDataCompetencia.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ReceberPagar.this.textDataCompetencia.selectAll();
            }
        });
        d = new Dimension(200, 20);
        this.lblVlrDataHora.setSize(d);
        this.lblVlrDataHora.setPreferredSize(d);
        this.lblVlrDataHora.setMinimumSize(d);
        this.lblVlrDataHora.setMaximumSize(d);
        d = new Dimension(20, 20);
        this.buttonDataVencimento.setPreferredSize(d);
        this.buttonDataVencimento.setMinimumSize(d);
        this.buttonDataVencimento.setMargin(new Insets(2, 2, 2, 2));
        Funcoes.imagemPesquisa(this.buttonDataVencimento);
        this.buttonDataVencimento.setFocusable(false);
        this.buttonDataVencimento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceberPagar.this.buscaDataVencimento();
            }
        });
        d = new Dimension(20, 20);
        this.buttonRateioParcelas.setPreferredSize(d);
        this.buttonRateioParcelas.setMinimumSize(d);
        this.buttonRateioParcelas.setText("...");
        this.buttonRateioParcelas.setFocusable(false);
        this.buttonRateioParcelas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ReceberPagar.this.textParcela.getText().equals("") || ReceberPagar.this.textDataVencimento.getText().equals("") || ReceberPagar.this.textValor.getText().equals("")) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Por favor, preencha os campos 'Parcela', 'Vencimento' e 'Valor'.", 2);
                    return;
                }
                DialogVencimentos diag = new DialogVencimentos(Laboratorio.getInstancia(), "Parcelas", Integer.parseInt(ReceberPagar.this.textParcela.getText()), ReceberPagar.this.textDataVencimento.getText(), ReceberPagar.this.textDataCompetencia.getText(), Float.valueOf(Float.parseFloat(ReceberPagar.this.textValor.getText())), (ArrayList<DadosParcelas>)ReceberPagar.this.arrayDadosParcelas);
                if (diag.getOK()) {
                    ReceberPagar.this.arrayDadosParcelas = diag.getArrayDadosParcelas();
                }
            }
        });
        d = new Dimension(20, 20);
        this.buttonDataCompetencia.setSize(d);
        this.buttonDataCompetencia.setPreferredSize(d);
        this.buttonDataCompetencia.setMinimumSize(d);
        this.buttonDataCompetencia.setMaximumSize(d);
        this.buttonDataCompetencia.setMargin(new Insets(2, 2, 2, 2));
        Funcoes.imagemPesquisa(this.buttonDataCompetencia);
        this.buttonDataCompetencia.setFocusable(false);
        this.buttonDataCompetencia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceberPagar.this.buscaDataCompetencia();
            }
        });
        FocusAdapter listenerSelecao = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getSource() instanceof TTextField) {
                    ((TTextField)e.getSource()).selectAll();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getSource() == ReceberPagar.this.textDesconto) {
                    BigDecimal auxDesconto = new BigDecimal(Funcoes.textoVazio(ReceberPagar.this.textDesconto) ? "0" : ReceberPagar.this.textDesconto.getText());
                    if (auxDesconto.compareTo(new BigDecimal("100")) > 0) {
                        Funcoes.mensagem(ReceberPagar.this, "O desconto ultrapassa 100%.", 2);
                        ReceberPagar.this.textDesconto.setText(Funcoes.formataDecimal(ReceberPagar.this.textDesconto.getMaskDecimal(), 0.0));
                        ScreenUtil.requisitarFoco(ReceberPagar.this.textDesconto);
                    }
                    return;
                }
                ReceberPagarBean bean = ReceberPagar.this.getBeanPreenchidoValores(null);
                bean = (ReceberPagarBean)FinanceiroUtil.calculaDesconto((AbstractThreadBean)bean);
                bean = (ReceberPagarBean)FinanceiroUtil.calculaAcrescimo((AbstractThreadBean)bean, null);
                bean = (ReceberPagarBean)FinanceiroUtil.calculaMulta((AbstractThreadBean)bean, null);
                bean = (ReceberPagarBean)FinanceiroUtil.calculaJuros((AbstractThreadBean)bean, bean.getDataVencimento());
                bean = (ReceberPagarBean)FinanceiroUtil.atualizaTotal((AbstractThreadBean)bean);
                ReceberPagar.this.lblVlrValorTotal.setText(bean.getValorTotal() == null ? "0.00" : Funcoes.formataDecimal(bean.getValorTotal()));
            }
        };
        FocusAdapter listenerPercImpostos = new FocusAdapter(){
            double auxIcms;
            double auxIpi;

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getSource() == ReceberPagar.this.textPercIrrf || e.getSource() == ReceberPagar.this.textPercIss || e.getSource() == ReceberPagar.this.textPercPis || e.getSource() == ReceberPagar.this.textPercCofins || e.getSource() == ReceberPagar.this.textPercCsll || e.getSource() == ReceberPagar.this.textPercInss || e.getSource() == ReceberPagar.this.textPercIpi || e.getSource() == ReceberPagar.this.textPercIcms || e.getSource() == ReceberPagar.this.textValor || e.getSource() == ReceberPagar.this.textPercIssRetido) {
                    if (Funcoes.textoVazio(ReceberPagar.this.textPercIcms)) {
                        ReceberPagar.this.textPercIcms.setText(Funcoes.formataDecimal(mascaraDecimalExibindoQuatroDigitos, 0));
                    }
                    if (Funcoes.textoVazio(ReceberPagar.this.textPercIpi)) {
                        ReceberPagar.this.textPercIpi.setText(Funcoes.formataDecimal(mascaraDecimalExibindoQuatroDigitos, 0));
                    }
                    ReceberPagarBean bean = ReceberPagar.this.getBeanPreenchidoValores(null);
                    bean = FinanceiroUtil.calculaValorImposto(bean);
                    bean = (ReceberPagarBean)FinanceiroUtil.calculaDesconto((AbstractThreadBean)bean);
                    bean = (ReceberPagarBean)FinanceiroUtil.calculaAcrescimo((AbstractThreadBean)bean, null);
                    bean = (ReceberPagarBean)FinanceiroUtil.calculaMulta((AbstractThreadBean)bean, null);
                    bean = (ReceberPagarBean)FinanceiroUtil.calculaJuros((AbstractThreadBean)bean, null);
                    bean = (ReceberPagarBean)FinanceiroUtil.atualizaTotal((AbstractThreadBean)bean);
                    ReceberPagar.this.textIrrf.setText(bean.getIrrfValor() == null ? ReceberPagar.this.textIrrf.getMaskDecimal() : Funcoes.formataDecimal(ReceberPagar.this.textIrrf.getMaskDecimal(), bean.getIrrfValor()));
                    ReceberPagar.this.textIss.setText(bean.getIssValor() == null ? ReceberPagar.this.textIss.getMaskDecimal() : Funcoes.formataDecimal(ReceberPagar.this.textIss.getMaskDecimal(), bean.getIssValor()));
                    ReceberPagar.this.textPis.setText(bean.getPisValor() == null ? ReceberPagar.this.textPis.getMaskDecimal() : Funcoes.formataDecimal(ReceberPagar.this.textPis.getMaskDecimal(), bean.getPisValor()));
                    ReceberPagar.this.textCofins.setText(bean.getCofinsValor() == null ? ReceberPagar.this.textCofins.getMaskDecimal() : Funcoes.formataDecimal(ReceberPagar.this.textCofins.getMaskDecimal(), bean.getCofinsValor()));
                    ReceberPagar.this.textCsll.setText(bean.getCsllValor() == null ? ReceberPagar.this.textCsll.getMaskDecimal() : Funcoes.formataDecimal(ReceberPagar.this.textCsll.getMaskDecimal(), bean.getCsllValor()));
                    ReceberPagar.this.textInss.setText(bean.getInssValor() == null ? ReceberPagar.this.textInss.getMaskDecimal() : Funcoes.formataDecimal(ReceberPagar.this.textInss.getMaskDecimal(), bean.getInssValor()));
                    ReceberPagar.this.textIpi.setText(bean.getValorIpi() == null ? ReceberPagar.this.textIpi.getMaskDecimal() : Funcoes.formataDecimal(ReceberPagar.this.textIpi.getMaskDecimal(), bean.getValorIpi()));
                    ReceberPagar.this.textIcms.setText(bean.getValorIcms() == null ? ReceberPagar.this.textIcms.getMaskDecimal() : Funcoes.formataDecimal(ReceberPagar.this.textIcms.getMaskDecimal(), bean.getValorIcms()));
                    ReceberPagar.this.textIssRetido.setText(bean.getIssRetidoValor() == null ? ReceberPagar.this.textIssRetido.getMaskDecimal() : Funcoes.formataDecimal(ReceberPagar.this.textIssRetido.getMaskDecimal(), bean.getIssRetidoValor()));
                    ReceberPagar.this.lblVlrValorTotal.setText(bean.getValorTotal() == null ? "0.00" : Funcoes.formataDecimal(bean.getValorTotal()));
                    ReceberPagar.this.controlaBotaoGerarApropriacoes();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getSource() instanceof TTextField) {
                    ((TTextField)e.getSource()).selectAll();
                    this.auxIcms = Double.parseDouble(Funcoes.textoVazio(ReceberPagar.this.textPercIcms.getText()) ? "0.00" : Funcoes.limpaDecimal(ReceberPagar.this.textPercIcms.getText()));
                    this.auxIpi = Double.parseDouble(Funcoes.textoVazio(ReceberPagar.this.textPercIpi.getText()) ? "0.00" : Funcoes.limpaDecimal(ReceberPagar.this.textPercIpi.getText()));
                }
            }
        };
        FocusAdapter listenerFoco = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(ReceberPagar.this.textIcms)) {
                    ReceberPagar.this.textIcms.setText(Funcoes.formataDecimal(mascaraDecimalExibindoQuatroDigitos, 0));
                }
                if (Funcoes.textoVazio(ReceberPagar.this.textIpi)) {
                    ReceberPagar.this.textIpi.setText(Funcoes.formataDecimal(mascaraDecimalExibindoQuatroDigitos, 0));
                }
                ReceberPagarBean bean = ReceberPagar.this.getBeanPreenchidoValores(null);
                bean = FinanceiroUtil.calculaPercentualImposto(bean);
                bean = (ReceberPagarBean)FinanceiroUtil.calculaDesconto((AbstractThreadBean)bean);
                bean = (ReceberPagarBean)FinanceiroUtil.calculaAcrescimo((AbstractThreadBean)bean, null);
                bean = (ReceberPagarBean)FinanceiroUtil.calculaMulta((AbstractThreadBean)bean, null);
                bean = (ReceberPagarBean)FinanceiroUtil.calculaJuros((AbstractThreadBean)bean, null);
                bean = (ReceberPagarBean)FinanceiroUtil.atualizaTotal((AbstractThreadBean)bean);
                ReceberPagar.this.textPercIrrf.setText(bean.getIrrfPercentual() == null ? "0.00" : Funcoes.formataDecimal("###,##0.00##", bean.getIrrfPercentual()));
                ReceberPagar.this.textPercIss.setText(bean.getIssPercentual() == null ? "0.00" : Funcoes.formataDecimal("###,##0.00##", bean.getIssPercentual()));
                ReceberPagar.this.textPercPis.setText(bean.getPisPercentual() == null ? "0.00" : Funcoes.formataDecimal("###,##0.00##", bean.getPisPercentual()));
                ReceberPagar.this.textPercCofins.setText(bean.getCofinsPercentual() == null ? "0.00" : Funcoes.formataDecimal("###,##0.00##", bean.getCofinsPercentual()));
                ReceberPagar.this.textPercCsll.setText(bean.getCsllPercentual() == null ? "0.00" : Funcoes.formataDecimal("###,##0.00##", bean.getCsllPercentual()));
                ReceberPagar.this.textPercInss.setText(bean.getInssPercentual() == null ? "0.00" : Funcoes.formataDecimal("###,##0.00##", bean.getInssPercentual()));
                if (e.getSource() == ReceberPagar.this.textIcms) {
                    ReceberPagar.this.textPercIcms.setText(bean.getPercentualIcms() == null ? "0.00" : Funcoes.formataDecimal(mascaraDecimalExibindoQuatroDigitos, bean.getPercentualIcms()));
                }
                if (e.getSource() == ReceberPagar.this.textIpi) {
                    ReceberPagar.this.textPercIpi.setText(bean.getPercentualIpi() == null ? "0.00" : Funcoes.formataDecimal(mascaraDecimalExibindoQuatroDigitos, bean.getPercentualIpi()));
                }
                ReceberPagar.this.textPercIssRetido.setText(bean.getIssRetidoPercentual() == null ? "0.00" : Funcoes.formataDecimal("###,##0.00##", bean.getIssRetidoPercentual()));
                ReceberPagar.this.lblVlrValorTotal.setText(bean.getValorTotal() == null ? "0.00" : Funcoes.formataDecimal(bean.getValorTotal()));
                ReceberPagar.this.controlaBotaoGerarApropriacoes();
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getSource() instanceof TTextField) {
                    ((TTextField)e.getSource()).selectAll();
                }
            }
        };
        d = new Dimension(100, 20);
        this.textValor.setPreferredSize(d);
        this.textValor.setMinimumSize(d);
        this.textValor.addFocusListener(listenerPercImpostos);
        d = new Dimension(70, 20);
        this.textMulta.setPreferredSize(d);
        this.textMulta.setMinimumSize(d);
        this.textMulta.addFocusListener(listenerSelecao);
        d = new Dimension(70, 20);
        this.textJuro.setPreferredSize(d);
        this.textJuro.setMinimumSize(d);
        this.textJuro.addFocusListener(listenerSelecao);
        d = new Dimension(80, 20);
        this.cbxTipoJuro.setPreferredSize(d);
        this.cbxTipoJuro.setMinimumSize(d);
        d = new Dimension(70, 20);
        this.textDesconto.setPreferredSize(d);
        this.textDesconto.setMinimumSize(d);
        this.textDesconto.addFocusListener(listenerSelecao);
        d = new Dimension(100, 20);
        this.cbxTipoDocumento.setPreferredSize(d);
        this.cbxTipoDocumento.setMinimumSize(d);
        d = new Dimension(100, 20);
        this.cbxTipo.setPreferredSize(d);
        this.cbxTipo.setMinimumSize(d);
        this.cbxTipo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (ReceberPagar.this.panelPlanoContaCentroCusto != null && ReceberPagar.this.tipoDebitoCredito != null && !ReceberPagar.this.tipoDebitoCredito.equals(ReceberPagar.this.cbxTipo.getSelectedItem())) {
                    String aux = ReceberPagar.this.cbxTipo.getSelectedItem().equals(Tipos.tipoReceberPagar("R")) ? "C" : "D";
                    ReceberPagar.this.panelPlanoContaCentroCusto.setTipoDebitoCredito(aux);
                    if (ReceberPagar.this.tipoDebitoCredito != null && !ReceberPagar.this.tipoDebitoCredito.equalsIgnoreCase(aux)) {
                        ReceberPagar.this.panelPlanoContaCentroCusto.removerTodosPlanosContas();
                        ReceberPagar.this.panelPlanoContaCentroCusto.removerTodosCentrosCusto();
                        ReceberPagarBean bean = ReceberPagar.this.getBeanPreenchidoValores(null);
                        bean = FinanceiroUtil.calculaPercentualImposto(bean);
                        bean = FinanceiroUtil.atualizaTotalSemRecalculo(bean);
                        ReceberPagar.this.textPercIrrf.setText(bean.getIrrfPercentual() == null ? "0.00" : Funcoes.formataDecimal("###,##0.00##", bean.getIrrfPercentual()));
                        ReceberPagar.this.textPercIss.setText(bean.getIssPercentual() == null ? "0.00" : Funcoes.formataDecimal("###,##0.00##", bean.getIssPercentual()));
                        ReceberPagar.this.textPercPis.setText(bean.getPisPercentual() == null ? "0.00" : Funcoes.formataDecimal("###,##0.00##", bean.getPisPercentual()));
                        ReceberPagar.this.textPercCofins.setText(bean.getCofinsPercentual() == null ? "0.00" : Funcoes.formataDecimal("###,##0.00##", bean.getCofinsPercentual()));
                        ReceberPagar.this.textPercCsll.setText(bean.getCsllPercentual() == null ? "0.00" : Funcoes.formataDecimal("###,##0.00##", bean.getCsllPercentual()));
                        ReceberPagar.this.textPercInss.setText(bean.getInssPercentual() == null ? "0.00" : Funcoes.formataDecimal("###,##0.00##", bean.getInssPercentual()));
                        ReceberPagar.this.textPercIcms.setText(bean.getPercentualIcms() == null ? "0.00" : Funcoes.formataDecimal(mascaraDecimalExibindoQuatroDigitos, bean.getPercentualIcms()));
                        ReceberPagar.this.textPercIpi.setText(bean.getPercentualIpi() == null ? "0.00" : Funcoes.formataDecimal(mascaraDecimalExibindoQuatroDigitos, bean.getPercentualIpi()));
                        ReceberPagar.this.lblVlrValorTotal.setText(bean.getValorTotal() == null ? "0.00" : Funcoes.formataDecimal(bean.getValorTotal()));
                    }
                    ReceberPagar.this.tipoDebitoCredito = aux;
                }
                ReceberPagar.this.controlaCampos();
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (ReceberPagar.this.cbxTipo.getSelectedItem().equals(Tipos.tipoReceberPagar("R"))) {
                    ReceberPagar.this.tipoDebitoCredito = "C";
                } else {
                    ReceberPagar.this.tipoDebitoCredito = "D";
                }
            }
        });
        d = new Dimension(100, 20);
        this.textNumeroDocumento.setPreferredSize(d);
        this.textNumeroDocumento.setMinimumSize(d);
        d = new Dimension(80, 20);
        this.textDataVencimento.setPreferredSize(d);
        this.textDataVencimento.setMinimumSize(d);
        this.textDataVencimento.addFocusListener(listenerFoco);
        d = new Dimension(70, 20);
        this.textFrete.setPreferredSize(d);
        this.textFrete.setMinimumSize(d);
        this.textFrete.addFocusListener(listenerFoco);
        d = new Dimension(70, 20);
        this.textTaxa.setPreferredSize(d);
        this.textTaxa.setMinimumSize(d);
        this.textTaxa.addFocusListener(listenerFoco);
        d = new Dimension(70, 20);
        this.textAcrescimo.setPreferredSize(d);
        this.textAcrescimo.setMinimumSize(d);
        this.textAcrescimo.addFocusListener(listenerSelecao);
        d = new Dimension(80, 20);
        this.textParcela.setPreferredSize(d);
        this.textParcela.setMinimumSize(d);
        this.textParcela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ReceberPagar.this.buttonRateioParcelas.doClick();
                }
            }
        });
        d = new Dimension(300, 20);
        this.textCodigoDocumento.setPreferredSize(d);
        this.textCodigoDocumento.setMinimumSize(d);
        d = new Dimension(80, 20);
        this.textDataDocumento.setPreferredSize(d);
        this.textDataDocumento.setMinimumSize(d);
        this.textDataDocumento.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(ReceberPagar.this.textDataDocumento.getText()) && Funcoes.textoVazio(ReceberPagar.this.textDataCompetencia.getText()) && Funcoes.verificaData(ReceberPagar.this.textDataDocumento.getText())) {
                    ReceberPagar.this.textDataCompetencia.setText(ReceberPagar.this.textDataDocumento.getText());
                }
            }
        });
        d = new Dimension(20, 20);
        this.buttonDataDocumento.setPreferredSize(d);
        this.buttonDataDocumento.setMinimumSize(d);
        this.buttonDataDocumento.setMargin(new Insets(2, 2, 2, 2));
        Funcoes.imagemPesquisa(this.buttonDataDocumento);
        this.buttonDataDocumento.setFocusable(false);
        this.buttonDataDocumento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceberPagar.this.buscaDataDocumento();
            }
        });
        d = new Dimension(80, 20);
        this.textDataProcessamento.setPreferredSize(d);
        this.textDataProcessamento.setMinimumSize(d);
        this.textDataProcessamento.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ReceberPagar.this.textDataProcessamento.selectAll();
            }
        });
        d = new Dimension(20, 20);
        this.buttonDataProcessamento.setPreferredSize(d);
        this.buttonDataProcessamento.setMinimumSize(d);
        this.buttonDataProcessamento.setMargin(new Insets(2, 2, 2, 2));
        Funcoes.imagemPesquisa(this.buttonDataProcessamento);
        this.buttonDataProcessamento.setFocusable(false);
        this.buttonDataProcessamento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceberPagar.this.buscaDataProcessamento();
            }
        });
        d = new Dimension(100, 35);
        this.scrObservacao.setPreferredSize(d);
        this.scrObservacao.setMinimumSize(d);
        ScreenUtil.montaSaidaTextArea(this.textObservacao);
        d = new Dimension(80, 20);
        this.textCodigoSerie.setPreferredSize(d);
        this.textCodigoSerie.setMinimumSize(d);
        this.textCodigoSerie.setUpperCase(true);
        this.textCodigoSerie.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ReceberPagar.this.buscaSerie(ReceberPagar.this.textCodigoSerie.getText());
            }
        });
        this.buttonBuscaSerie.setFocusable(false);
        this.buttonBuscaSerie.setText("");
        d = new Dimension(20, 20);
        this.buttonBuscaSerie.setPreferredSize(d);
        this.buttonBuscaSerie.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaSerie);
        this.buttonBuscaSerie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceberPagar.this.buscaSerie();
            }
        });
        d = new Dimension(200, 20);
        this.textDescricaoSerie.setPreferredSize(d);
        this.textDescricaoSerie.setMinimumSize(d);
        this.textDescricaoSerie.setEditable(false);
        this.textDescricaoSerie.setFocusable(false);
        d = new Dimension(100, 20);
        this.cbxTipoCadastro.setPreferredSize(d);
        this.cbxTipoCadastro.setMinimumSize(d);
        this.cbxTipoCadastro.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ReceberPagar.this.textCodigoCadastro.setText("");
                ReceberPagar.this.textDescricaoCadastro.setText("");
                ScreenUtil.requisitarFoco(ReceberPagar.this.textCodigoCadastro);
            }
        });
        d = new Dimension(80, 20);
        this.textCodigoCadastro.setPreferredSize(d);
        this.textCodigoCadastro.setMinimumSize(d);
        this.textCodigoCadastro.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ReceberPagar.this.buscaCadastro(ReceberPagar.this.textCodigoCadastro.getText());
            }
        });
        this.buttonBuscaCadastro.setFocusable(false);
        this.buttonBuscaCadastro.setText("");
        d = new Dimension(20, 20);
        this.buttonBuscaCadastro.setPreferredSize(d);
        this.buttonBuscaCadastro.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaCadastro);
        this.buttonBuscaCadastro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceberPagar.this.buscaCadastro();
            }
        });
        d = new Dimension(200, 20);
        this.textDescricaoCadastro.setPreferredSize(d);
        this.textDescricaoCadastro.setMinimumSize(d);
        this.textDescricaoCadastro.setEditable(false);
        this.textDescricaoCadastro.setFocusable(false);
        d = new Dimension(70, 20);
        this.textIrrf.setPreferredSize(d);
        this.textIrrf.setMinimumSize(d);
        this.textIrrf.addFocusListener(listenerFoco);
        this.textIss.setPreferredSize(d);
        this.textIss.setMinimumSize(d);
        this.textIss.addFocusListener(listenerFoco);
        this.textIssRetido.setPreferredSize(d);
        this.textIssRetido.setMinimumSize(d);
        this.textIssRetido.addFocusListener(listenerFoco);
        this.textPis.setPreferredSize(d);
        this.textPis.setMinimumSize(d);
        this.textPis.addFocusListener(listenerFoco);
        this.textCsll.setPreferredSize(d);
        this.textCsll.setMinimumSize(d);
        this.textCsll.addFocusListener(listenerFoco);
        this.textCofins.setPreferredSize(d);
        this.textCofins.setMinimumSize(d);
        this.textCofins.addFocusListener(listenerFoco);
        this.textInss.setPreferredSize(d);
        this.textInss.setMinimumSize(d);
        this.textInss.addFocusListener(listenerFoco);
        this.textIpi.setPreferredSize(d);
        this.textIpi.setMinimumSize(d);
        this.textIpi.addFocusListener(listenerFoco);
        this.textIcms.setPreferredSize(d);
        this.textIcms.setMinimumSize(d);
        this.textIcms.addFocusListener(listenerFoco);
        d = new Dimension(60, 20);
        this.textPercCofins.setPreferredSize(d);
        this.textPercCofins.setMinimumSize(d);
        this.textPercCofins.addFocusListener(listenerPercImpostos);
        this.textPercCsll.setPreferredSize(d);
        this.textPercCsll.setMinimumSize(d);
        this.textPercCsll.addFocusListener(listenerPercImpostos);
        this.textPercIpi.setPreferredSize(d);
        this.textPercIpi.setMinimumSize(d);
        this.textPercIpi.addFocusListener(listenerPercImpostos);
        this.textPercIcms.setPreferredSize(d);
        this.textPercIcms.setMinimumSize(d);
        this.textPercIcms.addFocusListener(listenerPercImpostos);
        this.textPercInss.setPreferredSize(d);
        this.textPercInss.setMinimumSize(d);
        this.textPercInss.addFocusListener(listenerPercImpostos);
        this.textPercIrrf.setPreferredSize(d);
        this.textPercIrrf.setMinimumSize(d);
        this.textPercIrrf.addFocusListener(listenerPercImpostos);
        this.textPercIss.setPreferredSize(d);
        this.textPercIss.setMinimumSize(d);
        this.textPercIss.addFocusListener(listenerPercImpostos);
        this.textPercPis.setPreferredSize(d);
        this.textPercPis.setMinimumSize(d);
        this.textPercPis.addFocusListener(listenerPercImpostos);
        this.textPercIssRetido.setPreferredSize(d);
        this.textPercIssRetido.setMinimumSize(d);
        this.textPercIssRetido.addFocusListener(listenerPercImpostos);
        d = new Dimension(100, 20);
        this.lblVlrValorTotal.setPreferredSize(d);
        d = new Dimension(100, 20);
        this.lblVlrValorTotal.setMinimumSize(d);
        this.lblVlrValorTotal.setHorizontalAlignment(4);
        d = new Dimension(140, 20);
        this.buttonGeraApropriacoes.setPreferredSize(d);
        this.buttonGeraApropriacoes.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGeraApropriacoes.setMinimumSize(d);
        this.buttonGeraApropriacoes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceberPagarBean bean = (ReceberPagarBean)ReceberPagar.this.getBeanPreenchido();
                bean = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes((AbstractThreadBean)bean, ReceberPagar.this.panelPlanoContaCentroCusto, 0, null);
            }
        });
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.panelValores.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.panelValores.add((Component)this.lblTipoJuro, c);
        ++c.gridx;
        this.panelValores.add((Component)this.cbxTipoJuro, c);
        ++c.gridx;
        JLabel lblAux3 = new JLabel();
        d = new Dimension(20, 20);
        lblAux3.setPreferredSize(d);
        lblAux3.setMinimumSize(d);
        this.panelValores.add((Component)lblAux3, c);
        ++c.gridx;
        this.panelValores.add((Component)this.lblJuro, c);
        ++c.gridx;
        this.panelValores.add((Component)this.textJuro, c);
        ++c.gridx;
        JLabel lblAux4 = new JLabel();
        d = new Dimension(20, 20);
        lblAux4.setPreferredSize(d);
        lblAux4.setMinimumSize(d);
        this.panelValores.add((Component)lblAux4, c);
        ++c.gridx;
        this.panelValores.add((Component)this.lblDesconto, c);
        ++c.gridx;
        this.panelValores.add((Component)this.textDesconto, c);
        ++c.gridx;
        JLabel lblAux10 = new JLabel();
        d = new Dimension(20, 20);
        lblAux10.setPreferredSize(d);
        lblAux10.setMinimumSize(d);
        this.panelValores.add((Component)lblAux10, c);
        ++c.gridx;
        this.panelValores.add((Component)this.lblAcrescimo, c);
        ++c.gridx;
        this.panelValores.add((Component)this.textAcrescimo, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelValores.add((Component)new JLabel(), c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        this.panelValores.add((Component)this.lblMulta, c);
        ++c.gridx;
        this.panelValores.add((Component)this.textMulta, c);
        c.gridx += 2;
        this.panelValores.add((Component)this.lblTaxa, c);
        ++c.gridx;
        this.panelValores.add((Component)this.textTaxa, c);
        c.gridx += 2;
        this.panelValores.add((Component)this.lblFrete, c);
        ++c.gridx;
        this.panelValores.add((Component)this.textFrete, c);
        this.panelImpostos.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 0, 1, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.panelImpostos.add((Component)this.lblIrrf, c);
        ++c.gridx;
        this.panelImpostos.add((Component)this.textIrrf, c);
        ++c.gridx;
        this.panelImpostos.add((Component)this.textPercIrrf, c);
        ++c.gridx;
        this.panelImpostos.add((Component)this.lblIrrfPerc, c);
        ++c.gridx;
        c.insets = new Insets(1, 10, 1, 0);
        this.panelImpostos.add((Component)this.lblIss, c);
        c.insets = new Insets(1, 0, 1, 0);
        ++c.gridx;
        this.panelImpostos.add((Component)this.textIss, c);
        ++c.gridx;
        this.panelImpostos.add((Component)this.textPercIss, c);
        ++c.gridx;
        this.panelImpostos.add((Component)this.lblIssPerc, c);
        ++c.gridx;
        c.insets = new Insets(1, 10, 1, 0);
        this.panelImpostos.add((Component)this.lblPis, c);
        c.insets = new Insets(1, 0, 1, 0);
        ++c.gridx;
        this.panelImpostos.add((Component)this.textPis, c);
        ++c.gridx;
        this.panelImpostos.add((Component)this.textPercPis, c);
        ++c.gridx;
        this.panelImpostos.add((Component)this.lblPisPerc, c);
        ++c.gridx;
        c.insets = new Insets(1, 10, 1, 0);
        this.panelImpostos.add((Component)this.lblIssRetido, c);
        c.insets = new Insets(1, 0, 1, 0);
        ++c.gridx;
        this.panelImpostos.add((Component)this.textIssRetido, c);
        ++c.gridx;
        this.panelImpostos.add((Component)this.textPercIssRetido, c);
        ++c.gridx;
        this.panelImpostos.add((Component)this.lblIssRetidoPerc, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        this.panelImpostos.add((Component)this.lblCsll, c);
        ++c.gridx;
        this.panelImpostos.add((Component)this.textCsll, c);
        ++c.gridx;
        this.panelImpostos.add((Component)this.textPercCsll, c);
        ++c.gridx;
        this.panelImpostos.add((Component)this.lblCsllPerc, c);
        ++c.gridx;
        c.insets = new Insets(1, 10, 1, 0);
        this.panelImpostos.add((Component)this.lblCofins, c);
        c.insets = new Insets(1, 0, 1, 0);
        ++c.gridx;
        this.panelImpostos.add((Component)this.textCofins, c);
        ++c.gridx;
        this.panelImpostos.add((Component)this.textPercCofins, c);
        ++c.gridx;
        this.panelImpostos.add((Component)this.lblCofinsPerc, c);
        ++c.gridx;
        c.insets = new Insets(1, 10, 1, 0);
        this.panelImpostos.add((Component)this.lblInss, c);
        c.insets = new Insets(1, 0, 1, 0);
        ++c.gridx;
        this.panelImpostos.add((Component)this.textInss, c);
        ++c.gridx;
        this.panelImpostos.add((Component)this.textPercInss, c);
        ++c.gridx;
        this.panelImpostos.add((Component)this.lblInssPerc, c);
        ++c.gridx;
        c.insets = new Insets(1, 10, 1, 0);
        c.gridwidth = 4;
        c.gridx += 3;
        c.fill = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelImpostos.add((Component)new JLabel(), c);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.panelImpostos.add((Component)this.lblIcms, c);
        ++c.gridx;
        this.panelImpostos.add((Component)this.textIcms, c);
        ++c.gridx;
        this.panelImpostos.add((Component)this.textPercIcms, c);
        ++c.gridx;
        this.panelImpostos.add((Component)this.lblIcmsPerc, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 1, 0);
        this.panelImpostos.add((Component)this.lblIpi, c);
        c.insets = new Insets(1, 0, 1, 0);
        ++c.gridx;
        this.panelImpostos.add((Component)this.textIpi, c);
        ++c.gridx;
        this.panelImpostos.add((Component)this.textPercIpi, c);
        ++c.gridx;
        this.panelImpostos.add((Component)this.lblIpiPerc, c);
        this.tabValoresTitulo.addTab("Valores (F5)", this.panelValores);
        this.tabValoresTitulo.addTab("Impostos (F6)", this.panelImpostos);
        this.inserirAcaoDeTecla("F5", "atalhoF5", new AbstractAction("atalhoF5"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ReceberPagar.this.getStatus() == 3 || ReceberPagar.this.getStatus() == 2) {
                    ReceberPagar.this.tabValoresTitulo.setSelectedComponent(ReceberPagar.this.panelValores);
                    if (ReceberPagar.this.cbxTipoJuro.isFocusable()) {
                        ReceberPagar.this.cbxTipoJuro.grabFocus();
                    }
                }
            }
        });
        this.inserirAcaoDeTecla("F6", "atalhoF6", new AbstractAction("atalhoF6"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ReceberPagar.this.getStatus() == 3 || ReceberPagar.this.getStatus() == 2) {
                    ReceberPagar.this.tabValoresTitulo.setSelectedComponent(ReceberPagar.this.panelImpostos);
                    if (ReceberPagar.this.textIrrf.isFocusable()) {
                        ReceberPagar.this.textIrrf.grabFocus();
                    }
                }
            }
        });
        this.inserirAcaoDeTecla("F7", "atalhoF7", new AbstractAction("atalhoF7"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ((ReceberPagar.this.getStatus() == 3 || ReceberPagar.this.getStatus() == 2) && ReceberPagar.this.panelPlanoContaCentroCusto.isVisible()) {
                    ReceberPagar.this.panelPlanoContaCentroCusto.focalizarPlanoContas();
                }
            }
        });
        this.inserirAcaoDeTecla("F8", "atalhoF8", new AbstractAction("atalhoF8"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ((ReceberPagar.this.getStatus() == 3 || ReceberPagar.this.getStatus() == 2) && ReceberPagar.this.panelPlanoContaCentroCusto.isVisible()) {
                    ReceberPagar.this.panelPlanoContaCentroCusto.focalizarCentroCusto();
                }
            }
        });
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.painelCentral.add((Component)this.lblCodigo, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.textCodigo, c);
        c.gridx += 3;
        this.painelCentral.add((Component)this.lblSituacao, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.lblVlrSituacao, c);
        c.gridx += 3;
        c.gridwidth = 4;
        c.anchor = 13;
        c.weightx = 1.0;
        this.painelCentral.add((Component)this.lblVlrDataHora, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.anchor = 17;
        c.gridx = 0;
        c.gridwidth = 1;
        this.lblTipo.setLabelFor(this.cbxTipo);
        this.lblTipo.setDisplayedMnemonic('T');
        this.painelCentral.add((Component)this.lblTipo, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.cbxTipo, c);
        c.gridx += 2;
        c.gridwidth = 1;
        JLabel lblAux = new JLabel();
        d = new Dimension(20, 20);
        lblAux.setPreferredSize(d);
        d = new Dimension(20, 20);
        lblAux.setMinimumSize(d);
        this.painelCentral.add((Component)lblAux, c);
        ++c.gridx;
        this.lblSerie.setLabelFor(this.textCodigoSerie);
        this.lblSerie.setDisplayedMnemonic('r');
        this.painelCentral.add((Component)this.lblSerie, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 0);
        this.painelCentral.add((Component)this.textCodigoSerie, c);
        ++c.gridx;
        c.insets = new Insets(1, 0, 1, 1);
        this.painelCentral.add((Component)this.buttonBuscaSerie, c);
        ++c.gridx;
        c.gridwidth = 5;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(1, 1, 1, 1);
        this.painelCentral.add((Component)this.textDescricaoSerie, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        this.lblTipoCadastro.setLabelFor(this.cbxTipoCadastro);
        this.lblTipoCadastro.setDisplayedMnemonic('i');
        this.painelCentral.add((Component)this.lblTipoCadastro, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.cbxTipoCadastro, c);
        c.gridx += 3;
        c.gridwidth = 1;
        this.lblCadastro.setLabelFor(this.textCodigoCadastro);
        this.lblCadastro.setDisplayedMnemonic('a');
        this.painelCentral.add((Component)this.lblCadastro, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 0);
        this.painelCentral.add((Component)this.textCodigoCadastro, c);
        ++c.gridx;
        c.insets = new Insets(1, 0, 1, 1);
        this.painelCentral.add((Component)this.buttonBuscaCadastro, c);
        ++c.gridx;
        c.gridwidth = 5;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(1, 1, 1, 1);
        this.painelCentral.add((Component)this.textDescricaoCadastro, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        this.lblTipoDocumento.setLabelFor(this.cbxTipoDocumento);
        this.lblTipoDocumento.setDisplayedMnemonic('p');
        this.painelCentral.add((Component)this.lblTipoDocumento, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.cbxTipoDocumento, c);
        c.gridx += 3;
        c.gridwidth = 1;
        this.lblCodigoDocumento.setLabelFor(this.textCodigoDocumento);
        this.lblCodigoDocumento.setDisplayedMnemonic('o');
        this.painelCentral.add((Component)this.lblCodigoDocumento, c);
        ++c.gridx;
        c.gridwidth = 6;
        this.painelCentral.add((Component)this.textCodigoDocumento, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.lblNumeroDocumento.setLabelFor(this.textNumeroDocumento);
        this.lblNumeroDocumento.setDisplayedMnemonic('u');
        this.painelCentral.add((Component)this.lblNumeroDocumento, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.textNumeroDocumento, c);
        c.gridx += 3;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.lblDataDocumento, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.insets = new Insets(1, 1, 1, 0);
        this.painelCentral.add((Component)this.textDataDocumento, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.insets = new Insets(1, 0, 1, 1);
        this.painelCentral.add((Component)this.buttonDataDocumento, c);
        ++c.gridx;
        JLabel lblAux2 = new JLabel();
        d = new Dimension(20, 20);
        lblAux2.setPreferredSize(d);
        lblAux2.setMinimumSize(d);
        this.painelCentral.add((Component)lblAux2, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 1);
        this.painelCentral.add((Component)this.lblDataProcessamento, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 0);
        this.painelCentral.add((Component)this.textDataProcessamento, c);
        ++c.gridx;
        c.insets = new Insets(1, 0, 1, 1);
        this.painelCentral.add((Component)this.buttonDataProcessamento, c);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(1, 1, 1, 1);
        this.lblDataCompetencia.setLabelFor(this.textDataCompetencia);
        this.lblDataCompetencia.setDisplayedMnemonic('m');
        this.painelCentral.add((Component)this.lblDataCompetencia, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 0);
        this.painelCentral.add((Component)this.textDataCompetencia, c);
        ++c.gridx;
        c.insets = new Insets(1, 0, 1, 1);
        this.painelCentral.add((Component)this.buttonDataCompetencia, c);
        c.gridx += 2;
        c.insets = new Insets(1, 1, 1, 1);
        this.lblDataVencimento.setLabelFor(this.textDataVencimento);
        this.lblDataVencimento.setDisplayedMnemonic('n');
        this.painelCentral.add((Component)this.lblDataVencimento, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 0);
        this.painelCentral.add((Component)this.textDataVencimento, c);
        ++c.gridx;
        c.insets = new Insets(1, 0, 1, 1);
        this.painelCentral.add((Component)this.buttonDataVencimento, c);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(1, 1, 1, 1);
        this.lblValor.setLabelFor(this.textValor);
        this.lblValor.setDisplayedMnemonic('V');
        this.painelCentral.add((Component)this.lblValor, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.insets = new Insets(2, 1, 1, 1);
        this.painelCentral.add((Component)this.textValor, c);
        ++c.gridx;
        JLabel lblAux9 = new JLabel();
        d = new Dimension(20, 20);
        lblAux9.setPreferredSize(d);
        lblAux9.setMinimumSize(d);
        this.painelCentral.add((Component)lblAux9, c);
        c.gridx += 2;
        c.insets = new Insets(1, 1, 1, 1);
        this.lblParcela.setLabelFor(this.textParcela);
        this.lblParcela.setDisplayedMnemonic('l');
        this.painelCentral.add((Component)this.lblParcela, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 0);
        this.painelCentral.add((Component)this.textParcela, c);
        ++c.gridx;
        c.insets = new Insets(1, 0, 1, 1);
        this.painelCentral.add((Component)this.buttonRateioParcelas, c);
        ++c.gridy;
        c.gridx = 0;
        JLabel lblAux7 = new JLabel();
        d = new Dimension(20, 5);
        lblAux7.setPreferredSize(d);
        d = new Dimension(20, 5);
        lblAux7.setMinimumSize(d);
        this.painelCentral.add((Component)lblAux7, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 12;
        this.painelCentral.add((Component)this.tabValoresTitulo, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(1, 1, 1, 1);
        this.painelCentral.add((Component)this.lblValorTotal, c);
        ++c.gridx;
        c.insets = new Insets(2, 1, 1, 1);
        this.painelCentral.add((Component)this.lblVlrValorTotal, c);
        c.gridx += 3;
        c.insets = new Insets(1, 1, 1, 1);
        this.painelCentral.add((Component)this.buttonGeraApropriacoes, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        JLabel lblAux8 = new JLabel();
        d = new Dimension(20, 5);
        lblAux8.setPreferredSize(d);
        d = new Dimension(20, 5);
        lblAux8.setMinimumSize(d);
        c.insets = new Insets(1, 1, 1, 1);
        this.painelCentral.add((Component)lblAux8, c);
        ++c.gridy;
        c.gridx = 0;
        this.lblObservacao.setLabelFor(this.scrObservacao);
        this.lblObservacao.setDisplayedMnemonic('b');
        this.painelCentral.add((Component)this.lblObservacao, c);
        ++c.gridx;
        c.gridwidth = 11;
        c.fill = 2;
        c.gridheight = 2;
        this.painelCentral.add((Component)this.scrObservacao, c);
        c.gridy += 2;
        c.gridx = 1;
        c.gridheight = 1;
        c.gridwidth = 12;
        this.painelCentral.add((Component)this.panelCancelado, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add((Component)new JLabel(""), c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 12;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panelPlanoContaCentroCusto.setTituloPlanoContas("Plano de Contas (F7)");
        this.panelPlanoContaCentroCusto.setTituloCentroCusto("Centros de Custo (F8)");
        try {
            this.haPlanos = new PlanoContaService().haPlanosContas(Variaveis.filialPadrao);
            this.haCentros = new CentroCustoService().haCentrosCusto(Variaveis.filialPadrao);
            if (Acesso.getAcesso(this.ACESSO_VISUALIZAR_PLANOCONTA_CENTROCUSTO) && (this.haPlanos || this.haCentros)) {
                this.painelCentral.add((Component)this.panelPlanoContaCentroCusto, c);
                this.panelPlanoContaCentroCusto.setPainelPlanoContaVisivel(this.haPlanos);
                this.panelPlanoContaCentroCusto.setPainelCentroCustoVisivel(this.haCentros);
            } else {
                this.painelCentral.add((Component)new JPanel(), c);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel verificar dados de planos de contas e centros e custo.\n" + e.getMessage(), e.getStackTrace());
        }
        this.montaPanelCancelado();
        this.service = new ReceberPagarService();
        this.panelPlanoContaCentroCusto.setService((ReceberPagarService)this.service);
        if (this.cbxTipo.getSelectedItem().equals(Tipos.tipoReceberPagar("R"))) {
            this.panelPlanoContaCentroCusto.setTipoDebitoCredito("C");
        } else {
            this.panelPlanoContaCentroCusto.setTipoDebitoCredito("D");
        }
        this.controlaCampos();
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public static ReceberPagarBean novaInstanciaDialog(Frame owner, ReceberPagarBean beanPreenchido, String tituloDialog, boolean podeAlterar, int tipo) {
        final JDialog aux = new JDialog(owner, tituloDialog, true);
        aux.setSize(700, 600);
        final ReceberPagar recPag = new ReceberPagar();
        if (tipo == 1) {
            recPag.setAgrupador(true);
        } else if (tipo == 2) {
            recPag.setParcela(true);
        }
        recPag.painelBotoes.setVisible(false);
        if (beanPreenchido != null) {
            recPag.editar(beanPreenchido);
            if ((beanPreenchido.getSituacao().equalsIgnoreCase("G") || beanPreenchido.getSituacao().equalsIgnoreCase("L")) && podeAlterar) {
                recPag.setStatus(3);
                recPag.controlaCampos();
                recPag.cbxTipo.setEnabled(false);
                recPag.cbxTipoCadastro.setEnabled(false);
                recPag.textCodigoCadastro.setEnabled(false);
            }
        } else {
            beanPreenchido = new ReceberPagarBean();
            recPag.novo();
        }
        Container painelConteudo = aux.getContentPane();
        painelConteudo.setLayout(new BorderLayout());
        painelConteudo.add((Component)recPag, "Center");
        ((JPanel)painelConteudo).setBorder(ScreenUtil.criarBordaVazia());
        JButton buttonOK = null;
        if (beanPreenchido.getCodigo() != null || tipo == 4) {
            buttonOK = new JButton("Salvar");
            buttonOK.setMnemonic('S');
        } else {
            buttonOK = new JButton("OK");
            buttonOK.setMnemonic('O');
        }
        if (recPag.getStatus() == 2 || recPag.getStatus() == 3) {
            buttonOK.setVisible(true);
        } else {
            buttonOK.setVisible(false);
        }
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceberPagar.setResultadoModal(1);
                if (((ReceberPagarBean)recPag.getBeanPreenchido()).getCodigo() != null) {
                    if (recPag.validaCampos()) {
                        aux.setVisible(false);
                    }
                } else {
                    aux.setVisible(false);
                }
            }
        });
        JButton buttonCancelar = new JButton("Cancelar");
        buttonCancelar.setMnemonic('C');
        buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceberPagar.setResultadoModal(-1);
                aux.setVisible(false);
            }
        });
        JPanel panelBotoes = new JPanel();
        panelBotoes.setLayout(new FlowLayout(2));
        panelBotoes.add(buttonOK);
        panelBotoes.add(buttonCancelar);
        painelConteudo.add((Component)panelBotoes, "South");
        aux.setLocationRelativeTo(Laboratorio.getInstancia());
        aux.setVisible(true);
        ReceberPagarBean auxRetorno = (ReceberPagarBean)recPag.getBeanPreenchido();
        if (beanPreenchido.isInserir()) {
            auxRetorno.setInserir(true);
        }
        if (recPag.getResultadoModal() == 1) {
            return auxRetorno;
        }
        return null;
    }

    public void setAgrupador(boolean isAgrupador) {
        this.isAgrupador = isAgrupador;
    }

    public boolean isAgrupador() {
        return this.isAgrupador;
    }

    public void setParcela(boolean isParcela) {
        this.isParcela = isParcela;
    }

    public boolean isParcela() {
        return this.isParcela;
    }

    public static void setResultadoModal(int resultado) {
        resultadoModal = resultado;
    }

    public int getResultadoModal() {
        return resultadoModal;
    }

    @Override
    protected void controlaCampos() {
        this.textCodigo.setEnabled(false);
        this.cbxTipo.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador && !this.isParcela);
        this.textValor.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textObservacao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.cbxTipoDocumento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textDataVencimento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textDataCompetencia.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonDataVencimento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonDataCompetencia.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textMulta.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textJuro.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textDesconto.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textCodigoSerie.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonBuscaSerie.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textDescricaoSerie.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.cbxTipoCadastro.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador && !this.isParcela);
        this.textCodigoCadastro.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador && !this.isParcela);
        this.buttonBuscaCadastro.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador && !this.isParcela);
        this.textDescricaoCadastro.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textDataDocumento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonDataDocumento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textDataProcessamento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonDataProcessamento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textNumeroDocumento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textCodigoDocumento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textParcela.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textTaxa.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textAcrescimo.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textObservacao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.cbxTipoJuro.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.panelPlanoContaCentroCusto.controlaCampos(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonRateioParcelas.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador && !this.isParcela);
        this.textFrete.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        boolean isContaReceber = this.cbxTipo.getSelectedItem().equals("Receber");
        boolean auxAtivaCamposReceber = !this.isAgrupador && isContaReceber;
        boolean auxAtivaCamposPagar = (this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador && !isContaReceber;
        this.textIrrf.setVisible(auxAtivaCamposReceber);
        this.textIss.setVisible(auxAtivaCamposReceber);
        this.textPis.setVisible(auxAtivaCamposReceber);
        this.textCsll.setVisible(auxAtivaCamposReceber);
        this.textCofins.setVisible(auxAtivaCamposReceber);
        this.textInss.setVisible(auxAtivaCamposReceber);
        this.textIssRetido.setVisible(auxAtivaCamposReceber);
        this.textIpi.setVisible(auxAtivaCamposPagar);
        this.textIcms.setVisible(auxAtivaCamposPagar);
        this.textPercIrrf.setVisible(auxAtivaCamposReceber);
        this.textPercIss.setVisible(auxAtivaCamposReceber);
        this.textPercPis.setVisible(auxAtivaCamposReceber);
        this.textPercCsll.setVisible(auxAtivaCamposReceber);
        this.textPercCofins.setVisible(auxAtivaCamposReceber);
        this.textPercInss.setVisible(auxAtivaCamposReceber);
        this.textPercIssRetido.setVisible(auxAtivaCamposReceber);
        this.textPercIpi.setVisible(auxAtivaCamposPagar);
        this.textPercIcms.setVisible(auxAtivaCamposPagar);
        this.textIrrf.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textIss.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textPis.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textCsll.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textCofins.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textInss.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textIpi.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textIcms.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textIssRetido.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textPercIrrf.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textPercIss.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textPercPis.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textPercCsll.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textPercCofins.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textPercInss.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textPercIpi.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textPercIcms.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.textPercIssRetido.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && !this.isAgrupador);
        this.lblIrrf.setVisible(auxAtivaCamposReceber);
        this.lblIss.setVisible(auxAtivaCamposReceber);
        this.lblPis.setVisible(auxAtivaCamposReceber);
        this.lblCsll.setVisible(auxAtivaCamposReceber);
        this.lblCofins.setVisible(auxAtivaCamposReceber);
        this.lblInss.setVisible(auxAtivaCamposReceber);
        this.lblIssRetido.setVisible(auxAtivaCamposReceber);
        this.lblIpi.setVisible(auxAtivaCamposPagar);
        this.lblIcms.setVisible(auxAtivaCamposPagar);
        this.lblIrrfPerc.setVisible(auxAtivaCamposReceber);
        this.lblIssPerc.setVisible(auxAtivaCamposReceber);
        this.lblPisPerc.setVisible(auxAtivaCamposReceber);
        this.lblCsllPerc.setVisible(auxAtivaCamposReceber);
        this.lblCofinsPerc.setVisible(auxAtivaCamposReceber);
        this.lblInssPerc.setVisible(auxAtivaCamposReceber);
        this.lblIssRetidoPerc.setVisible(auxAtivaCamposReceber);
        this.lblIpiPerc.setVisible(auxAtivaCamposPagar);
        this.lblIcmsPerc.setVisible(auxAtivaCamposPagar);
        this.buttonGeraApropriacoes.setEnabled(!(this.getStatus() != 3 && this.getStatus() != 2 || this.isAgrupador || !this.haPlanos && !this.haCentros));
    }

    private ReceberPagarBean getBeanPreenchidoValores(ReceberPagarBean bean) {
        if (bean == null) {
            bean = new ReceberPagarBean();
        }
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        bean.setFilial(filial);
        if (!Funcoes.textoVazio(this.textDataVencimento) && this.textDataVencimento.isConteudoValido()) {
            bean.setDataVencimento(Funcoes.getData("dd/MM/yyyy", this.textDataVencimento.getText()));
        }
        bean.setValor(Funcoes.textoVazio(this.textValor.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValor.getText())));
        bean.setPercentualMulta(Double.valueOf(Funcoes.textoVazio(this.textMulta.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textMulta.getText())));
        bean.setPercentualDesconto(Double.valueOf(Funcoes.textoVazio(this.textDesconto.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textDesconto.getText())));
        bean.setPercentualAcrescimo(Double.valueOf(Funcoes.textoVazio(this.textAcrescimo.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textAcrescimo.getText())));
        bean.setIrrfPercentual(Double.valueOf(Funcoes.textoVazio(this.textPercIrrf.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textPercIrrf.getText())));
        bean.setIssPercentual(Double.valueOf(Funcoes.textoVazio(this.textPercIss.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textPercIss.getText())));
        bean.setPisPercentual(Double.valueOf(Funcoes.textoVazio(this.textPercPis.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textPercPis.getText())));
        bean.setCsllPercentual(Double.valueOf(Funcoes.textoVazio(this.textPercCsll.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textPercCsll.getText())));
        bean.setCofinsPercentual(Double.valueOf(Funcoes.textoVazio(this.textPercCofins.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textPercCofins.getText())));
        bean.setInssPercentual(Double.valueOf(Funcoes.textoVazio(this.textPercInss.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textPercInss.getText())));
        bean.setPercentualIpi(Double.valueOf(Funcoes.textoVazio(this.textPercIpi.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textPercIpi.getText())));
        bean.setPercentualIcms(Double.valueOf(Funcoes.textoVazio(this.textPercIcms.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textPercIcms.getText())));
        bean.setIssRetidoPercentual(Double.valueOf(Funcoes.textoVazio(this.textPercIssRetido.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textPercIssRetido.getText())));
        if (this.cbxTipoJuro.getSelectedIndex() >= 0) {
            String tipo = (String)this.cbxTipoJuro.getSelectedItem();
            if (tipo.equalsIgnoreCase(Tipos.tipoJuros("A"))) {
                bean.setTipoJuro("A");
            } else if (tipo.equalsIgnoreCase(Tipos.tipoJuros("M"))) {
                bean.setTipoJuro("M");
            } else if (tipo.equalsIgnoreCase(Tipos.tipoJuros("D"))) {
                bean.setTipoJuro("D");
            }
        }
        bean.setValorMulta(new Double(0.0));
        bean.setValorDesconto(new Double(0.0));
        bean.setValorAcrescimo(new Double(0.0));
        bean.setTaxa(Funcoes.textoVazio(this.textTaxa.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textTaxa.getText())));
        bean.setValorFrete(Funcoes.textoVazio(this.textFrete.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textFrete.getText())));
        bean.setIrrfValor(Double.valueOf(Funcoes.textoVazio(this.textIrrf.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textIrrf.getText())));
        bean.setIssValor(Double.valueOf(Funcoes.textoVazio(this.textIss.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textIss.getText())));
        bean.setPisValor(Double.valueOf(Funcoes.textoVazio(this.textPis.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textPis.getText())));
        bean.setCsllValor(Double.valueOf(Funcoes.textoVazio(this.textCsll.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textCsll.getText())));
        bean.setCofinsValor(Double.valueOf(Funcoes.textoVazio(this.textCofins.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textCofins.getText())));
        bean.setInssValor(Double.valueOf(Funcoes.textoVazio(this.textInss.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textInss.getText())));
        bean.setValorIpi(Double.valueOf(Funcoes.textoVazio(this.textIpi.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textIpi.getText())));
        bean.setValorIcms(Double.valueOf(Funcoes.textoVazio(this.textIcms.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textIcms.getText())));
        bean.setIssRetidoValor(Double.valueOf(Funcoes.textoVazio(this.textIssRetido.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textIssRetido.getText())));
        bean.setPercentualJuro(Double.valueOf(Funcoes.textoVazio(this.textJuro.getText()) ? "0.00" : Funcoes.limpaDecimal(this.textJuro.getText())));
        bean.setValorJuro(new Double(0.0));
        if (this.cbxTipo.getSelectedItem().equals(Tipos.tipoReceberPagar("R"))) {
            bean.setTipo("R");
        } else {
            bean.setTipo("P");
        }
        return bean;
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        FilialVO filial = new FilialVO();
        try {
            filial = (FilialVO)new FilialDao().getVO(Variaveis.filialPadrao);
        }
        catch (ThreadDaoException e1) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar dados da filial.", 2);
        }
        ReceberPagarBean recpag = new ReceberPagarBean();
        recpag.setFilial(filial);
        if (this.getStatus() == 3) {
            if (!Funcoes.textoVazio(this.textCodigo)) {
                recpag.setCodigo(Integer.parseInt(this.textCodigo.getText()));
            } else {
                recpag.setCodigo(null);
            }
            recpag.setSituacao(this.situacao);
            recpag.setDataHora(this.beanAux.getDataHora());
            recpag.setUsuario(this.beanAux.getUsuario());
        } else if (this.getStatus() == 2) {
            recpag.setSituacao("A");
            recpag.setDataHora(new Date());
            UsuarioVO usuario = new UsuarioVO();
            usuario.setCodigo(Variaveis.login);
            recpag.setUsuario(usuario);
        }
        String tipo = (String)this.cbxTipo.getSelectedItem();
        if (tipo.equalsIgnoreCase(Tipos.tipoReceberPagar("P"))) {
            recpag.setTipo("P");
        } else {
            recpag.setTipo("R");
        }
        tipo = (String)this.cbxTipoDocumento.getSelectedItem();
        if (tipo.equalsIgnoreCase(Tipos.tipoDocumento("B"))) {
            recpag.setTipoDocumento("B");
        } else if (tipo.equalsIgnoreCase(Tipos.tipoDocumento("D"))) {
            recpag.setTipoDocumento("D");
        } else if (tipo.equalsIgnoreCase(Tipos.tipoDocumento("C"))) {
            recpag.setTipoDocumento("C");
        } else if (tipo.equalsIgnoreCase(Tipos.tipoDocumento("A"))) {
            recpag.setTipoDocumento("A");
        }
        recpag.setDataVencimento(!Funcoes.textoVazio(this.textDataVencimento.getText()) && Funcoes.verificaData(this.textDataVencimento.getText()) ? Funcoes.stringToDate(this.textDataVencimento.getText()) : null);
        recpag.setDataCompetencia(!Funcoes.textoVazio(this.textDataCompetencia.getText()) && Funcoes.verificaData(this.textDataCompetencia.getText()) ? Funcoes.stringToDate(this.textDataCompetencia.getText()) : null);
        recpag = this.getBeanPreenchidoValores(recpag);
        recpag = (ReceberPagarBean)FinanceiroUtil.calculaDesconto((AbstractThreadBean)recpag);
        recpag = (ReceberPagarBean)FinanceiroUtil.calculaAcrescimo((AbstractThreadBean)recpag, null);
        recpag = (ReceberPagarBean)FinanceiroUtil.calculaMulta((AbstractThreadBean)recpag, null);
        recpag = (ReceberPagarBean)FinanceiroUtil.calculaJuros((AbstractThreadBean)recpag, recpag.getDataVencimento());
        recpag = (ReceberPagarBean)FinanceiroUtil.atualizaTotal((AbstractThreadBean)recpag);
        if (this.cbxTipoJuro.getSelectedIndex() >= 0) {
            tipo = (String)this.cbxTipoJuro.getSelectedItem();
            if (tipo.equalsIgnoreCase(Tipos.tipoJuros("A"))) {
                recpag.setTipoJuro("A");
            } else if (tipo.equalsIgnoreCase(Tipos.tipoJuros("M"))) {
                recpag.setTipoJuro("M");
            } else if (tipo.equalsIgnoreCase(Tipos.tipoJuros("D"))) {
                recpag.setTipoJuro("D");
            }
        }
        recpag.setNumeroDocumento(Funcoes.textoVazio(this.textNumeroDocumento.getText()) ? null : this.textNumeroDocumento.getText());
        recpag.setParcela(Funcoes.textoVazio(this.textParcela.getText()) ? 1 : Integer.parseInt(this.textParcela.getText()));
        recpag.setCodigoDocumento(Funcoes.textoVazio(this.textCodigoDocumento.getText()) ? null : this.textCodigoDocumento.getText());
        recpag.setDataDocumento(Funcoes.textoVazio(this.textDataDocumento.getText()) ? null : Funcoes.stringToDate(this.textDataDocumento.getText()));
        recpag.setDataProcessamento(Funcoes.textoVazio(this.textDataProcessamento.getText()) ? null : Funcoes.stringToDate(this.textDataProcessamento.getText()));
        recpag.setObservacao(Funcoes.textoVazio(this.textObservacao.getText()) ? null : this.textObservacao.getText());
        tipo = this.getTipoCadastroSelecionado();
        recpag.setTipoCadastro(tipo);
        try {
            if (!Funcoes.textoVazio(this.textCodigoSerie.getText()) && !this.textDescricaoSerie.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
                SeriesVO serie = (SeriesVO)this.seriesService.getVO(String.valueOf(filial.getCodigo()), this.textCodigoSerie.getText());
                recpag.setSerie(serie);
            }
            if (!Funcoes.textoVazio(this.textCodigoCadastro.getText()) && !this.textDescricaoCadastro.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
                if (tipo.equalsIgnoreCase("P")) {
                    PacienteVO paciente = (PacienteVO)new PacienteService().getVO(String.valueOf(filial.getCodigo()), this.textCodigoCadastro.getText());
                    recpag.setPaciente(paciente);
                } else if (tipo.equalsIgnoreCase("O")) {
                    ConvenioVO convenio = (ConvenioVO)new ConvenioService().getVO(String.valueOf(filial.getCodigo()), this.textCodigoCadastro.getText());
                    recpag.setConvenio(convenio);
                } else {
                    EntidadeVO entidade = (EntidadeVO)new EntidadeService().getVO(String.valueOf(filial.getCodigo()), this.textCodigoCadastro.getText());
                    recpag.setEntidade(entidade);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Erro preencher o receber/pagar.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
        if (this.panelPlanoContaCentroCusto.getPlanoContas() != null) {
            recpag.setPlanosContas(new HashSet<AbstractThreadBean>(this.panelPlanoContaCentroCusto.getPlanoContas()));
        }
        if (this.panelPlanoContaCentroCusto.getCentrosCusto() != null) {
            recpag.setCentrosCusto(new HashSet<AbstractThreadBean>(this.panelPlanoContaCentroCusto.getCentrosCusto()));
        }
        recpag.setOrigem(this.origem == null ? "M" : this.origem);
        recpag.setNotaFiscal(this.notaFiscal);
        return recpag;
    }

    @Override
    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    protected void limparCampos() {
        this.textCodigo.setText("");
        this.cbxTipo.setSelectedIndex(0);
        this.lblVlrDataHora.setText("");
        this.textValor.setText("");
        this.textObservacao.setText("");
        this.cbxTipoDocumento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textDataVencimento.setText("");
        this.textDataCompetencia.setText("");
        this.textMulta.setText("");
        this.textJuro.setText("");
        this.textDesconto.setText("");
        this.textCodigoSerie.setText("");
        this.textDescricaoSerie.setText("");
        this.textCodigoCadastro.setText("");
        this.textDescricaoCadastro.setText("");
        this.textDataDocumento.setText("");
        this.textDataProcessamento.setText("");
        this.textNumeroDocumento.setText("");
        this.textCodigoDocumento.setText("");
        this.textParcela.setText("");
        this.textTaxa.setText("1");
        this.textAcrescimo.setText("");
        this.textFrete.setText("");
        this.textObservacao.setText("");
        this.cbxTipoJuro.setSelectedIndex(0);
        this.panelPlanoContaCentroCusto.limparCampos();
        this.panelCancelado.removeAll();
        this.painelCentral.revalidate();
        this.painelCentral.repaint();
        if (this.arrayDadosParcelas != null) {
            this.arrayDadosParcelas.clear();
        }
        this.textJuro.setText(Funcoes.formataDecimal(0));
        this.textDesconto.setText(Funcoes.formataDecimal(0));
        this.textAcrescimo.setText(Funcoes.formataDecimal(0));
        this.textMulta.setText(Funcoes.formataDecimal(0));
        this.textTaxa.setText(Funcoes.formataDecimal(0));
        this.textFrete.setText(Funcoes.formataDecimal(0));
        this.textIrrf.setText(Funcoes.formataDecimal(0));
        this.textIss.setText(Funcoes.formataDecimal(0));
        this.textPis.setText(Funcoes.formataDecimal(0));
        this.textCsll.setText(Funcoes.formataDecimal(0));
        this.textCofins.setText(Funcoes.formataDecimal(0));
        this.textInss.setText(Funcoes.formataDecimal(0));
        this.textIcms.setText(Funcoes.formataDecimal(mascaraDecimalExibindoQuatroDigitos, 0));
        this.textIpi.setText(Funcoes.formataDecimal(mascaraDecimalExibindoQuatroDigitos, 0));
        this.textIssRetido.setText(Funcoes.formataDecimal(0));
        this.textPercIrrf.setText(Funcoes.formataDecimal("0.00##", 0));
        this.textPercIss.setText(Funcoes.formataDecimal("0.00##", 0));
        this.textPercPis.setText(Funcoes.formataDecimal("0.00##", 0));
        this.textPercCsll.setText(Funcoes.formataDecimal("0.00##", 0));
        this.textPercCofins.setText(Funcoes.formataDecimal("0.00##", 0));
        this.textPercInss.setText(Funcoes.formataDecimal("0.00##", 0));
        this.textPercIpi.setText(Funcoes.formataDecimal(mascaraDecimalExibindoQuatroDigitos, 0));
        this.textPercIcms.setText(Funcoes.formataDecimal(mascaraDecimalExibindoQuatroDigitos, 0));
        this.textPercIssRetido.setText(Funcoes.formataDecimal("0.00##", 0));
        this.textValor.setText(Funcoes.formataDecimal(0));
        this.lblVlrValorTotal.setText(Funcoes.formataDecimal(0));
        this.lblVlrSituacao.setText("");
        this.origem = null;
        this.notaFiscal = null;
        this.beanAux = null;
        this.lblVlrSituacao.setAviso(null);
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            ReceberPagarBean titulo;
            Hashtable hash = Pesquisas.titulo(Laboratorio.getInstancia(), false);
            if (hash != null && (titulo = (ReceberPagarBean)new ReceberPagarDao().getBean(Variaveis.filialPadrao, hash.get("rpg_codigo").toString())) != null) {
                return titulo;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ReceberPagar: 834");
        }
        return null;
    }

    protected AbstractThreadBean pesquisarTitulosAbertos() {
        try {
            ReceberPagarBean titulo;
            Hashtable hash = Pesquisas.titulosAbertos(Laboratorio.getInstancia(), false);
            if (hash != null && (titulo = (ReceberPagarBean)new ReceberPagarDao().getBean(Variaveis.filialPadrao, hash.get("rpg_codigo").toString())) != null) {
                return titulo;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ReceberPagar: 834");
        }
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        this.beanAux = (ReceberPagarBean)bean;
        this.situacao = this.beanAux.getSituacao();
        if (this.situacao != null) {
            this.lblVlrSituacao.setText(Tipos.tipoSituacaoReceberPagar(this.situacao));
        }
        if (this.beanAux.getCodigo() != null) {
            this.textCodigo.setText(Integer.toString(this.beanAux.getCodigo()));
        }
        StringBuilder txt = new StringBuilder();
        txt.append(this.beanAux.getUsuario().getCodigo());
        txt.append(" em ");
        txt.append(Funcoes.formataData("dd/MM/yyyy HH:mm", this.beanAux.getDataHora()));
        this.lblVlrDataHora.setText(txt.toString());
        if (this.beanAux.getTipo().equalsIgnoreCase("P")) {
            this.cbxTipo.setSelectedItem(Tipos.tipoReceberPagar("P"));
        } else {
            this.cbxTipo.setSelectedItem(Tipos.tipoReceberPagar("R"));
        }
        if (this.beanAux.getTipoDocumento().equalsIgnoreCase("B")) {
            this.cbxTipoDocumento.setSelectedItem(Tipos.tipoDocumento("B"));
        } else if (this.beanAux.getTipoDocumento().equalsIgnoreCase("D")) {
            this.cbxTipoDocumento.setSelectedItem(Tipos.tipoDocumento("D"));
        } else if (this.beanAux.getTipoDocumento().equalsIgnoreCase("C")) {
            this.cbxTipoDocumento.setSelectedItem(Tipos.tipoDocumento("C"));
        } else if (this.beanAux.getTipoDocumento().equalsIgnoreCase("A")) {
            this.cbxTipoDocumento.setSelectedItem(Tipos.tipoDocumento("A"));
        }
        this.textDataVencimento.setText(Funcoes.formataData("dd/MM/yyyy", this.beanAux.getDataVencimento()));
        this.textDataCompetencia.setText(Funcoes.formataData("dd/MM/yyyy", this.beanAux.getDataCompetencia()));
        this.textValor.setText(this.beanAux.getValor() == null ? "0.00" : Funcoes.formataDecimal("0.00", this.beanAux.getValor()));
        this.textMulta.setText(this.beanAux.getPercentualMulta() == null ? "0.00" : Funcoes.formataDecimal("0.00", this.beanAux.getPercentualMulta()));
        this.textJuro.setText(this.beanAux.getPercentualJuro() == null ? "0.00" : Funcoes.formataDecimal("0.00", this.beanAux.getPercentualJuro()));
        this.textDesconto.setText(this.beanAux.getPercentualDesconto() == null ? "0.00" : Funcoes.formataDecimal("0.00", this.beanAux.getPercentualDesconto()));
        this.textFrete.setText(this.beanAux.getValorFrete() == null ? "0.00" : Funcoes.formataDecimal("0.00", this.beanAux.getValorFrete()));
        this.textNumeroDocumento.setText(this.beanAux.getNumeroDocumento());
        this.textTaxa.setText(this.beanAux.getTaxa() == null ? "" : Funcoes.formataDecimal("0.00", this.beanAux.getTaxa()));
        this.textAcrescimo.setText(this.beanAux.getPercentualAcrescimo() == null ? "" : Funcoes.formataDecimal("0.00", this.beanAux.getPercentualAcrescimo()));
        this.textParcela.setText(this.beanAux.getParcela() != null ? Integer.toString(this.beanAux.getParcela()) : "1");
        this.textCodigoDocumento.setText(this.beanAux.getCodigoDocumento());
        this.textDataDocumento.setText(Funcoes.formataData("dd/MM/yyyy", this.beanAux.getDataDocumento()));
        this.textDataProcessamento.setText(Funcoes.formataData("dd/MM/yyyy", this.beanAux.getDataProcessamento()));
        this.textObservacao.setText(this.beanAux.getObservacao());
        this.lblVlrValorTotal.setText(this.beanAux.getValorTotal() == null ? "" : Funcoes.formataDecimal("0.00", this.beanAux.getValorTotal()));
        this.textIrrf.setText(this.beanAux.getIrrfValor() == null ? "" : Funcoes.formataDecimal(this.textIrrf.getMaskDecimal(), this.beanAux.getIrrfValor()));
        this.textIss.setText(this.beanAux.getIssValor() == null ? "" : Funcoes.formataDecimal(this.textIss.getMaskDecimal(), this.beanAux.getIssValor()));
        this.textPis.setText(this.beanAux.getPisValor() == null ? "" : Funcoes.formataDecimal(this.textPis.getMaskDecimal(), this.beanAux.getPisValor()));
        this.textCsll.setText(this.beanAux.getCsllValor() == null ? "" : Funcoes.formataDecimal(this.textCsll.getMaskDecimal(), this.beanAux.getCsllValor()));
        this.textCofins.setText(this.beanAux.getCofinsValor() == null ? "" : Funcoes.formataDecimal(this.textCofins.getMaskDecimal(), this.beanAux.getCofinsValor()));
        this.textInss.setText(this.beanAux.getInssValor() == null ? "" : Funcoes.formataDecimal(this.textInss.getMaskDecimal(), this.beanAux.getInssValor()));
        this.textIcms.setText(this.beanAux.getValorIcms() == null ? "" : Funcoes.formataDecimal(this.textIcms.getMaskDecimal(), this.beanAux.getValorIcms()));
        this.textIpi.setText(this.beanAux.getValorIpi() == null ? "" : Funcoes.formataDecimal(this.textIpi.getMaskDecimal(), this.beanAux.getValorIpi()));
        this.textIssRetido.setText(this.beanAux.getIssRetidoValor() == null ? "" : Funcoes.formataDecimal(this.textIssRetido.getMaskDecimal(), this.beanAux.getIssRetidoValor()));
        this.textPercIrrf.setText(this.beanAux.getIrrfPercentual() == null ? "" : Funcoes.formataDecimal("0.00##", this.beanAux.getIrrfPercentual()));
        this.textPercIss.setText(this.beanAux.getIssPercentual() == null ? "" : Funcoes.formataDecimal("0.00##", this.beanAux.getIssPercentual()));
        this.textPercPis.setText(this.beanAux.getPisPercentual() == null ? "" : Funcoes.formataDecimal("0.00##", this.beanAux.getPisPercentual()));
        this.textPercCsll.setText(this.beanAux.getCsllPercentual() == null ? "" : Funcoes.formataDecimal("0.00##", this.beanAux.getCsllPercentual()));
        this.textPercCofins.setText(this.beanAux.getCofinsPercentual() == null ? "" : Funcoes.formataDecimal("0.00##", this.beanAux.getCofinsPercentual()));
        this.textPercInss.setText(this.beanAux.getInssPercentual() == null ? "" : Funcoes.formataDecimal("0.00##", this.beanAux.getInssPercentual()));
        this.textPercIcms.setText(this.beanAux.getPercentualIcms() == null ? "" : Funcoes.formataDecimal(mascaraDecimalExibindoQuatroDigitos, this.beanAux.getPercentualIcms()));
        this.textPercIpi.setText(this.beanAux.getPercentualIpi() == null ? "" : Funcoes.formataDecimal(mascaraDecimalExibindoQuatroDigitos, this.beanAux.getPercentualIpi()));
        this.textPercIssRetido.setText(this.beanAux.getIssRetidoPercentual() == null ? "" : Funcoes.formataDecimal("0.00##", this.beanAux.getIssRetidoPercentual()));
        if (this.beanAux.getSerie() != null) {
            this.textCodigoSerie.setText(this.beanAux.getSerie().getCodigo());
            this.textDescricaoSerie.setText(this.beanAux.getSerie().getDescricao());
        }
        String tipo = this.beanAux.getTipoCadastro();
        this.cbxTipoCadastro.setSelectedItem(Tipos.tipoCadastro(tipo));
        if (tipo.equalsIgnoreCase("P")) {
            PacienteVO paciente = this.beanAux.getPaciente();
            if (paciente != null) {
                this.textCodigoCadastro.setText(Integer.toString(paciente.getCodigo()));
                this.textDescricaoCadastro.setText(paciente.getNome());
            }
        } else if (tipo.equalsIgnoreCase("O")) {
            ConvenioVO convenio = this.beanAux.getConvenio();
            if (convenio != null) {
                this.textCodigoCadastro.setText(Integer.toString(convenio.getCodigo()));
                this.textDescricaoCadastro.setText(convenio.getFantasia());
            }
        } else {
            EntidadeVO entidade = this.beanAux.getEntidade();
            if (entidade != null) {
                this.textCodigoCadastro.setText(Integer.toString(entidade.getCodigo()));
                this.textDescricaoCadastro.setText(entidade.getFantasia());
            }
        }
        this.panelCancelado.removeAll();
        if (this.beanAux.getSituacao() != null && this.beanAux.getSituacao().equalsIgnoreCase("C")) {
            StringBuilder html = new StringBuilder();
            html.append("<html>");
            html.append("Usu\u00e1rio:").append(this.beanAux.getUsuarioCancelado() == null ? "" : this.beanAux.getUsuarioCancelado().getCodigo()).append("<br>");
            html.append("Data:").append(this.beanAux.getDataCancelado() == null ? "" : Funcoes.formataData("dd/MM/yyyy", this.beanAux.getDataCancelado())).append("<br>");
            html.append("<html/>");
            this.lblCancelamento.setText(html.toString());
            this.panelCancelado.add((Component)this.panelDadosCancelado, "Center");
        }
        if (this.beanAux.getTipo().equals("R")) {
            this.panelPlanoContaCentroCusto.setTipoDebitoCredito("C");
        } else {
            this.panelPlanoContaCentroCusto.setTipoDebitoCredito("D");
        }
        this.panelPlanoContaCentroCusto.setBean(this.beanAux);
        this.panelPlanoContaCentroCusto.setPlanoContas(this.beanAux.getPlanosContas());
        this.panelPlanoContaCentroCusto.atualizar(this.beanAux);
        this.origem = this.beanAux.getOrigem();
        this.notaFiscal = this.beanAux.getNotaFiscal();
        this.painelCentral.revalidate();
        this.painelCentral.repaint();
    }

    @Override
    public boolean validaCampos() {
        if (this.cbxTipo.getSelectedItem() == null || this.cbxTipo.getSelectedIndex() < 0) {
            Funcoes.mensagem(this, "Tipo do receber/pagar n\u00e3o selecionado!", 2);
            ScreenUtil.requisitarFoco(this.cbxTipo);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodigoSerie.getText()) || this.textDescricaoSerie.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "S\u00e9rie n\u00e3o selecionada para o receber/pagar", 2);
            ScreenUtil.requisitarFoco(this.textCodigoSerie);
            return false;
        }
        if (this.cbxTipoCadastro.getSelectedItem() == null || this.cbxTipoCadastro.getSelectedIndex() < 0) {
            Funcoes.mensagem(this, "Tipo do cadastro n\u00e3o selecionado!", 2);
            ScreenUtil.requisitarFoco(this.cbxTipoCadastro);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodigoCadastro.getText()) || this.textDescricaoCadastro.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Cadastro n\u00e3o selecionado para o lan\u00e7amento", 2);
            ScreenUtil.requisitarFoco(this.textCodigoCadastro);
            return false;
        }
        if (this.cbxTipoDocumento.getSelectedItem() == null || this.cbxTipoDocumento.getSelectedIndex() < 0) {
            Funcoes.mensagem(this, "Tipo do documento n\u00e3o selecionado!", 2);
            ScreenUtil.requisitarFoco(this.cbxTipoDocumento);
            return false;
        }
        if (Funcoes.textoVazio(this.textDataDocumento.getText()) || !Funcoes.verificaData(this.textDataDocumento.getText())) {
            Funcoes.mensagem(this, "Data do documento n\u00e3o \u00e9 valida", 2);
            ScreenUtil.requisitarFoco(this.textDataDocumento);
            return false;
        }
        if (Funcoes.textoVazio(this.textDataVencimento.getText()) || !Funcoes.verificaData(this.textDataVencimento.getText())) {
            Funcoes.mensagem(this, "Data de vencimento n\u00e3o \u00e9 valida", 2);
            ScreenUtil.requisitarFoco(this.textDataVencimento);
            return false;
        }
        if (Funcoes.textoVazio(this.textDataCompetencia.getText()) || !Funcoes.verificaData(this.textDataCompetencia.getText())) {
            Funcoes.mensagem(this, "Data de competencia n\u00e3o \u00e9 valida", 2);
            ScreenUtil.requisitarFoco(this.textDataCompetencia);
            return false;
        }
        if (Funcoes.textoVazio(this.textValor.getText())) {
            Funcoes.mensagem(this, "Valor n\u00e3o preenchido", 2);
            ScreenUtil.requisitarFoco(this.textValor);
            return false;
        }
        if (!Funcoes.textoVazio(this.textIss) && !Funcoes.textoVazio(this.textIssRetido)) {
            double valorIss = Double.parseDouble(Funcoes.limpaDecimal(this.textIss.getText()));
            double valorIssRetido = Double.parseDouble(Funcoes.limpaDecimal(this.textIssRetido.getText()));
            if (valorIss > 0.0 && valorIssRetido > 0.0) {
                Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel informar valor de ISS devido e retido no mesmo t\u00edtulo.", 2);
                ScreenUtil.requisitarFoco(this.textIss);
                return false;
            }
        }
        if (!this.panelPlanoContaCentroCusto.validarOrigem()) {
            Funcoes.mensagem(this, "H\u00e1 planos de conta/centros de custo SEM origem informada.", 2);
            return false;
        }
        if (Acesso.getAcesso(this.ACESSO_PROIBIR_SEM_PLANO_CONTA) && this.panelPlanoContaCentroCusto.verificaPlanoContaSemApropriacao()) {
            Funcoes.mensagem(this, "O valor do t\u00edtulo deve ser apropriado nos planos de conta.", 2);
            this.panelPlanoContaCentroCusto.focalizarPlanoContas();
            return false;
        }
        if (Acesso.getAcesso(this.ACESSO_PROIBIR_SEM_CENTRO_CUSTO) && this.panelPlanoContaCentroCusto.verificaCentroCustoSemApropriacao()) {
            Funcoes.mensagem(this, "O valor do t\u00edtulo deve ser apropriado nos centros de custo.", 2);
            this.panelPlanoContaCentroCusto.focalizarCentroCusto();
            return false;
        }
        if (!this.panelPlanoContaCentroCusto.validar()) {
            Funcoes.mensagem(this, "O total apropriado nos planos de contas \u00e9 diferente do valor total do receber/pagar.", 2);
            return false;
        }
        return true;
    }

    private boolean validaApropriacoes() {
        ReceberPagarBean bean = (ReceberPagarBean)this.getBeanPreenchido();
        boolean haApropriacoes = true;
        if (this.buttonGeraApropriacoes.isVisible()) {
            return true;
        }
        haApropriacoes = bean.getTaxa() > 0.0;
        boolean bl = haApropriacoes = !FinanceiroUtil.haApropriacoes(bean, TiposApropriacao.Taxa, this.panelPlanoContaCentroCusto) && haApropriacoes;
        if (haApropriacoes) {
            return haApropriacoes;
        }
        haApropriacoes = bean.getIrrfValor() > 0.0;
        boolean bl2 = haApropriacoes = !FinanceiroUtil.haApropriacoes(bean, TiposApropriacao.ImpostosIRRF, this.panelPlanoContaCentroCusto) && haApropriacoes;
        if (haApropriacoes) {
            return haApropriacoes;
        }
        haApropriacoes = bean.getIssValor() > 0.0;
        boolean bl3 = haApropriacoes = !FinanceiroUtil.haApropriacoes(bean, TiposApropriacao.ImpostosISS, this.panelPlanoContaCentroCusto) && haApropriacoes;
        if (haApropriacoes) {
            return haApropriacoes;
        }
        haApropriacoes = bean.getPisValor() > 0.0;
        boolean bl4 = haApropriacoes = !FinanceiroUtil.haApropriacoes(bean, TiposApropriacao.ImpostosPIS, this.panelPlanoContaCentroCusto) && haApropriacoes;
        if (haApropriacoes) {
            return haApropriacoes;
        }
        haApropriacoes = bean.getCsllValor() > 0.0;
        boolean bl5 = haApropriacoes = !FinanceiroUtil.haApropriacoes(bean, TiposApropriacao.ImpostosCSLL, this.panelPlanoContaCentroCusto) && haApropriacoes;
        if (haApropriacoes) {
            return haApropriacoes;
        }
        haApropriacoes = bean.getCofinsValor() > 0.0;
        boolean bl6 = haApropriacoes = !FinanceiroUtil.haApropriacoes(bean, TiposApropriacao.ImpostosCOFINS, this.panelPlanoContaCentroCusto) && haApropriacoes;
        if (haApropriacoes) {
            return haApropriacoes;
        }
        haApropriacoes = bean.getValorIpi() > 0.0;
        boolean bl7 = haApropriacoes = !FinanceiroUtil.haApropriacoes(bean, TiposApropriacao.ImpostosIPI, this.panelPlanoContaCentroCusto) && haApropriacoes;
        if (haApropriacoes) {
            return haApropriacoes;
        }
        haApropriacoes = bean.getValorIcms() > 0.0;
        boolean bl8 = haApropriacoes = !FinanceiroUtil.haApropriacoes(bean, TiposApropriacao.ImpostosICMS, this.panelPlanoContaCentroCusto) && haApropriacoes;
        if (haApropriacoes) {
            return haApropriacoes;
        }
        haApropriacoes = bean.getInssValor() > 0.0;
        boolean bl9 = haApropriacoes = !FinanceiroUtil.haApropriacoes(bean, TiposApropriacao.ImpostosINSS, this.panelPlanoContaCentroCusto) && haApropriacoes;
        if (haApropriacoes) {
            return haApropriacoes;
        }
        haApropriacoes = bean.getIssRetidoValor() > 0.0;
        boolean bl10 = haApropriacoes = !FinanceiroUtil.haApropriacoes(bean, TiposApropriacao.ImpostosISSRetido, this.panelPlanoContaCentroCusto) && haApropriacoes;
        if (haApropriacoes) {
            return haApropriacoes;
        }
        return false;
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(ReceberPagar.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0600400501"));
        this.setModuloEdita(Long.parseLong("0600400502"));
        this.setModuloApaga(Long.parseLong("0600400503"));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600400500");
    }

    private void buscaSerie(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoSerie.setText("");
            this.textDescricaoSerie.setText("");
            return;
        }
        try {
            SeriesVO serie = (SeriesVO)this.seriesService.getVO(Variaveis.filialPadrao, codigo);
            if (serie != null) {
                this.textCodigoSerie.setText(serie.getCodigo());
                this.textDescricaoSerie.setText(serie.getDescricao());
            } else {
                this.textDescricaoSerie.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ReceberPagar:1046");
        }
    }

    private void buscaSerie() {
        try {
            this.textCodigoSerie.setText("");
            this.textDescricaoSerie.setText("");
            SeriesVO serie = (SeriesVO)this.seriesService.pesquisaVO(this.getTopLevelAncestor(), new SeriesVO(), "Pesquisando s\u00e9ries", true);
            if (serie != null) {
                this.textCodigoSerie.setText(serie.getCodigo());
                this.textDescricaoSerie.setText(serie.getDescricao());
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ReceberPagar:1061");
        }
    }

    public void salvarAlteracoes() {
        ReceberPagarBean bean;
        if (this.validaCampos() && (bean = (ReceberPagarBean)this.getBeanPreenchido()) != null) {
            try {
                this.service.gravaAutoCopiaSemCommit(bean, 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "ReceberPagar:salvarAlteracoes");
            }
        }
    }

    @Override
    public void salvar() {
        ReceberPagarBean bean;
        if (this.validaCampos() && (bean = (ReceberPagarBean)this.getBeanPreenchido()) != null) {
            try {
                this.service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                if (this.arrayDadosParcelas != null) {
                    for (DadosParcelas aux : this.arrayDadosParcelas) {
                        bean.setCodigo(null);
                        bean.setParcela(aux.numeroParcela);
                        bean.setDataVencimento(Funcoes.getData("dd/MM/yyyy", aux.stringDataVcto));
                        bean.setDataCompetencia(Funcoes.getData("dd/MM/yyyy", aux.stringDataComp));
                        bean.setValor(Double.parseDouble(Funcoes.limpaDecimal(aux.valorTitulo)));
                        this.service.gravaAutoCopiaSemCommit(bean, 0, Variaveis.filialPadrao, this.getCopiaFiliais());
                    }
                }
                this.retornoParaPesquisa = bean.getCodigo().toString();
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace());
            }
        }
    }

    private void controlaBotaoGerarApropriacoes() {
        ReceberPagarBean bean = (ReceberPagarBean)this.getBeanPreenchido();
        TiposApropriacao aux = null;
        TTextField[] campos = new TTextField[]{this.textTaxa, this.textIrrf, this.textIss, this.textPis, this.textCsll, this.textCofins, this.textInss, this.textIssRetido};
        boolean mostrar = false;
        for (int i = 0; i < campos.length; ++i) {
            TTextField campoOrigem = campos[i];
            if (campoOrigem == this.textTaxa) {
                aux = TiposApropriacao.Taxa;
            } else if (campoOrigem == this.textIrrf) {
                aux = TiposApropriacao.ImpostosIRRF;
            } else if (campoOrigem == this.textIss) {
                aux = TiposApropriacao.ImpostosISS;
            } else if (campoOrigem == this.textPis) {
                aux = TiposApropriacao.ImpostosPIS;
            } else if (campoOrigem == this.textCsll) {
                aux = TiposApropriacao.ImpostosCSLL;
            } else if (campoOrigem == this.textCofins) {
                aux = TiposApropriacao.ImpostosCOFINS;
            } else if (campoOrigem == this.textInss) {
                aux = TiposApropriacao.ImpostosINSS;
            } else if (campoOrigem == this.textIpi) {
                aux = TiposApropriacao.ImpostosIPI;
            } else if (campoOrigem == this.textIcms) {
                aux = TiposApropriacao.ImpostosICMS;
            } else if (campoOrigem == this.textIssRetido) {
                aux = TiposApropriacao.ImpostosISSRetido;
            }
            if (Funcoes.textoVazio(campoOrigem.getText()) || aux == null || !(Double.parseDouble(campoOrigem.getText()) > 0.0)) continue;
            mostrar = FinanceiroUtil.isApropriacaoPlanoContasConfigurada(bean, aux) || mostrar;
            boolean bl = mostrar = FinanceiroUtil.isApropriacaoCentroCustoConfigurada(bean, aux) || mostrar;
            if (!mostrar) continue;
            this.buttonGeraApropriacoes.setVisible(mostrar);
            return;
        }
        this.buttonGeraApropriacoes.setVisible(mostrar);
    }

    @Override
    public void pressioneiF2() {
        if (this.textDataDocumento.hasFocus()) {
            this.buscaDataDocumento();
        } else if (this.textDataVencimento.hasFocus()) {
            this.buscaDataVencimento();
        } else if (this.textDataCompetencia.hasFocus()) {
            this.buscaDataCompetencia();
        } else if (this.textDataProcessamento.hasFocus()) {
            this.buscaDataProcessamento();
        } else if (this.textCodigoSerie.hasFocus()) {
            this.buscaSerie();
        } else if (this.textCodigoCadastro.hasFocus()) {
            this.buscaCadastro();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        boolean podeAlterar = false;
        ReceberPagarBean bean = (ReceberPagarBean)this.pesquisar();
        if (bean != null) {
            podeAlterar = bean.getNotaFiscal() == null || bean.getOrigem() == null || !bean.getOrigem().equalsIgnoreCase("N") || bean.getNotaFiscal().getTipo() == null || bean.getNotaFiscal().getTipo().equalsIgnoreCase("E");
            if (bean.getSituacao() != null && !bean.getSituacao().equalsIgnoreCase("A")) {
                podeAlterar = false;
            }
            if (podeAlterar) {
                this.setStatus(3);
            } else {
                this.setStatus(5);
            }
            this.preencherCampos(bean);
            this.controlaCampos();
            this.painelCentral.grabFocus();
            this.tipoDebitoCredito = bean.getTipo().equalsIgnoreCase("R") ? "C" : "D";
            this.controlaBotaoGerarApropriacoes();
            if (bean.getSituacao() != null && bean.getSituacao().equalsIgnoreCase("Q")) {
                Integer codigoBaixa = null;
                try {
                    codigoBaixa = new BaixaService().getCodigoBaixa(bean.getFilial().getCodigo().toString(), bean.getCodigo().toString());
                    if (codigoBaixa != null) {
                        BaixaBean baixa = (BaixaBean)new BaixaService().get(bean.getFilial().getCodigo().toString(), codigoBaixa.toString());
                        StringBuilder buf = new StringBuilder();
                        buf.append("Baixa: ").append(codigoBaixa);
                        buf.append(" em ").append(Funcoes.formataData("dd/MM/yyyy HH:mm", baixa.getDataHora()));
                        buf.append(" por ").append(baixa.getUsuario());
                        this.lblVlrSituacao.setAviso(buf.toString(), 1);
                    }
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar dados da baixa do receber/pagar.\n" + e.getMessage(), e.getStackTrace());
                }
            }
        }
        ScreenUtil.requisitarFoco(this.cbxTipo);
    }

    public void editar(ReceberPagarBean bean) {
        this.limparCampos();
        boolean podeAlterar = false;
        if (bean != null) {
            podeAlterar = bean.getNotaFiscal() == null || bean.getNotaFiscal().getTipo() != null && bean.getNotaFiscal().getTipo().equalsIgnoreCase("E") ? true : bean.getOrigem().equalsIgnoreCase("C") || bean.getOrigem().equalsIgnoreCase("R");
            if (bean.getSituacao() != null && !bean.getSituacao().equalsIgnoreCase("A")) {
                podeAlterar = false;
            }
            if (podeAlterar) {
                this.setStatus(3);
            } else {
                this.setStatus(5);
            }
            this.preencherCampos(bean);
            this.controlaCampos();
            this.painelCentral.grabFocus();
            this.tipoDebitoCredito = bean.getTipo().equalsIgnoreCase("R") ? "C" : "D";
            this.controlaBotaoGerarApropriacoes();
        }
        ScreenUtil.requisitarFoco(this.textCodigoSerie);
    }

    @Override
    public void novo() {
        SeriesVO serie = null;
        try {
            serie = (SeriesVO)new SeriesService().getVO(Variaveis.filialPadrao, ParametrosLocais.getParametro("serie"));
            if (serie == null) {
                throw new Exception("A s\u00e9rie padr\u00e3o n\u00e3o est\u00e1 configurada para a esta\u00e7\u00e3o.");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            return;
        }
        super.novo();
        this.textDataProcessamento.setText(Funcoes.formataData("dd/MM/yyyy", new Date()));
        this.textDataDocumento.setText(Funcoes.formataData("dd/MM/yyyy", new Date()));
        this.textCodigoSerie.setText(serie.getCodigo());
        this.textDescricaoSerie.setText(serie.getDescricao());
        this.controlaBotaoGerarApropriacoes();
        ScreenUtil.requisitarFoco(this.cbxTipo);
    }

    private void buscaDataDocumento() {
        Funcoes.mostraData(this.textDataDocumento, this.buttonDataDocumento, this.painelCentral, true);
    }

    private void buscaDataProcessamento() {
        Funcoes.mostraData(this.textDataProcessamento, this.buttonDataProcessamento, this.painelCentral, true);
    }

    private void buscaDataVencimento() {
        Funcoes.mostraData(this.textDataVencimento, this.buttonDataVencimento, this.painelCentral, true);
    }

    private void buscaDataCompetencia() {
        Funcoes.mostraData(this.textDataCompetencia, this.buttonDataCompetencia, this.painelCentral, true);
    }

    private void montaPanelCancelado() {
        Font f = this.lblCancelamento.getFont();
        f = new Font(f.getName(), f.getStyle(), 10);
        this.lblCancelamento.setHorizontalAlignment(2);
        this.lblCancelamento.setFont(f);
        this.panelDadosCancelado.setBorder(BorderFactory.createTitledBorder("Dados Cancelamento"));
        this.panelDadosCancelado.add((Component)this.lblCancelamento, "Center");
    }

    private void buscaCadastro(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoCadastro.setText("");
            this.textDescricaoCadastro.setText("");
            return;
        }
        if (this.cbxTipoCadastro.getSelectedIndex() < 0) {
            return;
        }
        try {
            String tipo = this.getTipoCadastroSelecionado();
            if (tipo.equalsIgnoreCase("O")) {
                ConvenioVO convenio = (ConvenioVO)this.convenioService.getVO(Variaveis.filialPadrao, codigo);
                if (convenio != null) {
                    this.textCodigoCadastro.setText(Integer.toString(convenio.getCodigo()));
                    this.textDescricaoCadastro.setText(convenio.getFantasia());
                }
            } else if (tipo.equalsIgnoreCase("P")) {
                PacienteVO paciente = (PacienteVO)this.pacienteService.getVO(Variaveis.filialPadrao, codigo);
                if (paciente != null) {
                    this.textCodigoCadastro.setText(Integer.toString(paciente.getCodigo()));
                    this.textDescricaoCadastro.setText(paciente.getNome());
                }
            } else {
                EntidadeVO entidade = (EntidadeVO)this.entidadeService.getVO(Variaveis.filialPadrao, codigo);
                if (entidade != null) {
                    if (!entidade.getTipo().equalsIgnoreCase(tipo)) {
                        this.textDescricaoCadastro.setText("N\u00e3o cadastrado");
                    } else {
                        this.textCodigoCadastro.setText(Integer.toString(entidade.getCodigo()));
                        this.textDescricaoCadastro.setText(entidade.getFantasia());
                    }
                }
            }
            if (Funcoes.textoVazio(this.textDescricaoCadastro.getText())) {
                this.textDescricaoCadastro.setText("N\u00e3o cadastrado");
                ScreenUtil.requisitarFoco(this.textCodigoCadastro);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ReceberPagar:1046");
        }
    }

    private void buscaCadastro() {
        try {
            this.textCodigoCadastro.setText("");
            this.textDescricaoCadastro.setText("");
            if (this.cbxTipoCadastro.getSelectedIndex() < 0) {
                return;
            }
            String tipo = this.getTipoCadastroSelecionado();
            if (tipo.equalsIgnoreCase("O")) {
                ConvenioVO convenio = (ConvenioVO)this.convenioService.pesquisaVO(this.getTopLevelAncestor(), new ConvenioVO(), "Pesquisando Conv\u00eanios", true);
                if (convenio != null) {
                    this.textCodigoCadastro.setText(Integer.toString(convenio.getCodigo()));
                    this.textDescricaoCadastro.setText(convenio.getFantasia());
                }
            } else if (tipo.equalsIgnoreCase("P")) {
                PacienteVO paciente = (PacienteVO)this.pacienteService.pesquisaVO(this.getTopLevelAncestor(), new PacienteVO(), "Pesquisando Pacientes", true);
                if (paciente != null) {
                    this.textCodigoCadastro.setText(Integer.toString(paciente.getCodigo()));
                    this.textDescricaoCadastro.setText(paciente.getNome());
                }
            } else {
                String titulo = "";
                int tipoTelaModulo = 4;
                if (tipo.equalsIgnoreCase("C")) {
                    titulo = "Pesquisando Coletadores";
                    tipoTelaModulo = 3;
                } else if (tipo.equalsIgnoreCase("F")) {
                    titulo = "Pesquisando Fornecedores";
                    tipoTelaModulo = 1;
                } else if (tipo.equalsIgnoreCase("U")) {
                    titulo = "Pesquisando Funcion\u00e1rios";
                    tipoTelaModulo = 2;
                } else {
                    titulo = "Pesquisando Representantes";
                }
                EntidadeVO entidade = (EntidadeVO)this.entidadeService.pesquisaVO((Object)this.getTopLevelAncestor(), (AbstractThreadVO)new EntidadeVO(), titulo, tipoTelaModulo, tipo, true);
                if (entidade != null) {
                    if (!entidade.getTipo().equalsIgnoreCase(tipo)) {
                        this.textDescricaoCadastro.setText("N\u00e3o cadastrado");
                    } else {
                        this.textCodigoCadastro.setText(Integer.toString(entidade.getCodigo()));
                        this.textDescricaoCadastro.setText(entidade.getFantasia());
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ReceberPagar:1061");
        }
    }

    private String getTipoCadastroSelecionado() {
        String tipo = (String)this.cbxTipoCadastro.getSelectedItem();
        if (tipo.equalsIgnoreCase(Tipos.tipoCadastro("U"))) {
            return "U";
        }
        if (tipo.equalsIgnoreCase(Tipos.tipoCadastro("F"))) {
            return "F";
        }
        if (tipo.equalsIgnoreCase(Tipos.tipoCadastro("C"))) {
            return "C";
        }
        if (tipo.equalsIgnoreCase(Tipos.tipoCadastro("R"))) {
            return "R";
        }
        if (tipo.equalsIgnoreCase(Tipos.tipoCadastro("P"))) {
            return "P";
        }
        return "O";
    }

    protected void inserirAcaoDeTecla(String key_stroke, String action_name, AbstractAction action) {
        this.getInputMap(0).put(KeyStroke.getKeyStroke(key_stroke), action_name);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(key_stroke), action_name);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(key_stroke), action_name);
        this.getActionMap().put(action_name, action);
    }

    @Override
    public AbstractThreadBean buscaBeanPreenchido(PanelPlanoContaCentroCusto source) {
        return this.getBeanPreenchido();
    }

    @Override
    public void excluir() {
        this.beanDelete = (ReceberPagarBean)this.pesquisarTitulosAbertos();
        if (this.beanDelete != null) {
            if (!this.beanDelete.getSituacao().equalsIgnoreCase("A") && !this.beanDelete.getSituacao().equalsIgnoreCase("P") && this.beanDelete.getNotaFiscal() == null) {
                Funcoes.mensagem(this, "O t\u00edtulo n\u00e3o pode ser exclu\u00eddo, pois sua situa\u00e7\u00e3o \u00e9: " + Tipos.tipoSituacaoReceberPagar(this.beanDelete.getSituacao() + "."), 2);
                return;
            }
            if (this.beanDelete.getSituacao().equalsIgnoreCase("P") && this.beanDelete.getOrigem() != null && this.beanDelete.getOrigem().equalsIgnoreCase("N")) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "O Receber/Pagar n\u00e3o pode ser exclu\u00eddo, pois \u00e9 a pr\u00e9via da Nota Fiscal: " + this.beanDelete.getNotaFiscal().getNumero() + ", s\u00e9rie: " + this.beanDelete.getSerie().getCodigo() + ".", 2);
                return;
            }
            if (this.beanDelete.getNotaFiscal() != null || this.beanDelete.getOrigem() != null && this.beanDelete.getOrigem().equalsIgnoreCase("N")) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "O Receber/Pagar n\u00e3o pode ser exclu\u00eddo, pois sua origem \u00e9 a Nota Fiscal: " + this.beanDelete.getNotaFiscal().getNumero() + ", s\u00e9rie: " + this.beanDelete.getSerie().getCodigo() + ".", 2);
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReceberPagar.this.preencherCampos(ReceberPagar.this.beanDelete);
                    if (Funcoes.mensagem(Laboratorio.getInstancia(), "Deseja excluir o registro selecionado?", 4) == 0) {
                        try {
                            ReceberPagar.this.beanDelete.setSituacao("X");
                            ReceberPagar.this.service.gravaAutoCopiaSemCommit(ReceberPagar.this.beanDelete, 1, Variaveis.filialPadrao, ReceberPagar.this.getCopiaFiliais());
                            Conexao.arquivaSQL();
                        }
                        catch (Exception e) {
                            try {
                                Conexao.anulaSQL();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ReceberPagarBean:2329");
                        }
                    }
                    ReceberPagar.this.limparCampos();
                    ReceberPagar.this.beanDelete = null;
                }
            });
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "rpg_codigo";
    }

    @Override
    public void fechar() {
        Laboratorio.getInstancia().setComponenteMensagemVisivel(false);
        super.fechar();
    }

    class DialogVencimentos
    extends AbstractDialogoOKCancelar {
        private JLabel labelQtdeParcelas;
        private TTextField textQtdeParcelas;
        private JButton buttonGerarParcelas;
        private JButton buttonLimpar;
        private JPanel panelParcelas;
        private JLabel labelNumParcela;
        private JLabel labelVctoParcela;
        private JLabel labelCompParcela;
        private JLabel labelValorParcela;
        private JButton buttonVcto;
        private JButton buttonComp;
        private JButton buttonOK;
        private ModeloGridTable modelo;
        private JTable grid;
        private TTextField textNumParcela;
        private TTextField textVctoParcela;
        private TTextField textCompParcela;
        private TTextField textValorParcela;
        private JPanel panelPrincipal;
        private JScrollPane scrollGrid;
        private JLabel labelIntervaloParcelas;
        private TTextField textIntervaloParcelas;
        private int numeroInicial;
        private String stringDataVcto;
        private String stringDataComp;
        private Float valorTitulo;
        private JCheckBox checkDiasFixos;
        private JPanel panelDiasFixos;
        private JPanel panelDiasVariaveis;
        private JPanel panelDatas;
        private HashMap<String, Object> linhaSelecionada;

        public DialogVencimentos(Frame framePai, String stringTitulo, int numeroInicial, String stringDataVcto, String stringDataComp, Float valorTitulo, ArrayList<DadosParcelas> arrayDadosIniciais) {
            super(framePai, stringTitulo);
            this.labelQtdeParcelas = new JLabel("Qtde. Parc.:");
            this.textQtdeParcelas = new TTextField(3, 1);
            this.buttonGerarParcelas = new JButton("Gerar");
            this.buttonLimpar = new JButton("Limpar");
            this.panelParcelas = new JPanel(new GridBagLayout());
            this.labelNumParcela = new JLabel("N\u00famero");
            this.labelVctoParcela = new JLabel("Vencimento");
            this.labelCompParcela = new JLabel("Compet\u00eancia");
            this.labelValorParcela = new JLabel("Valor");
            this.buttonVcto = new JButton();
            this.buttonComp = new JButton();
            this.buttonOK = new JButton("OK");
            this.modelo = new ModeloGridTable(new String[]{"N\u00famero", "Vencimento", "Compet\u00eancia", "Valor"});
            this.grid = new JTable(this.modelo);
            this.textNumParcela = new TTextField(3, 1);
            this.textVctoParcela = new TTextField(10, 4);
            this.textCompParcela = new TTextField(10, 4);
            this.textValorParcela = new TTextField(10, 2);
            this.panelPrincipal = this.getPanelCentral();
            this.labelIntervaloParcelas = new JLabel("Interv. dias:");
            this.textIntervaloParcelas = new TTextField(4, 1);
            this.checkDiasFixos = new JCheckBox("Usar dias fixos", true);
            this.panelDiasFixos = new JPanel(new GridBagLayout());
            this.panelDiasVariaveis = new JPanel(new GridBagLayout());
            this.panelDatas = new JPanel(new BorderLayout());
            this.linhaSelecionada = null;
            this.constroiObjeto(numeroInicial, stringDataVcto, stringDataComp, valorTitulo, arrayDadosIniciais);
        }

        public DialogVencimentos(Dialog dialogPai, String stringTitulo, int numeroInicial, String stringDataVcto, String stringDataComp, Float valorTitulo, ArrayList<DadosParcelas> arrayDadosIniciais) {
            super(dialogPai, stringTitulo);
            this.labelQtdeParcelas = new JLabel("Qtde. Parc.:");
            this.textQtdeParcelas = new TTextField(3, 1);
            this.buttonGerarParcelas = new JButton("Gerar");
            this.buttonLimpar = new JButton("Limpar");
            this.panelParcelas = new JPanel(new GridBagLayout());
            this.labelNumParcela = new JLabel("N\u00famero");
            this.labelVctoParcela = new JLabel("Vencimento");
            this.labelCompParcela = new JLabel("Compet\u00eancia");
            this.labelValorParcela = new JLabel("Valor");
            this.buttonVcto = new JButton();
            this.buttonComp = new JButton();
            this.buttonOK = new JButton("OK");
            this.modelo = new ModeloGridTable(new String[]{"N\u00famero", "Vencimento", "Compet\u00eancia", "Valor"});
            this.grid = new JTable(this.modelo);
            this.textNumParcela = new TTextField(3, 1);
            this.textVctoParcela = new TTextField(10, 4);
            this.textCompParcela = new TTextField(10, 4);
            this.textValorParcela = new TTextField(10, 2);
            this.panelPrincipal = this.getPanelCentral();
            this.labelIntervaloParcelas = new JLabel("Interv. dias:");
            this.textIntervaloParcelas = new TTextField(4, 1);
            this.checkDiasFixos = new JCheckBox("Usar dias fixos", true);
            this.panelDiasFixos = new JPanel(new GridBagLayout());
            this.panelDiasVariaveis = new JPanel(new GridBagLayout());
            this.panelDatas = new JPanel(new BorderLayout());
            this.linhaSelecionada = null;
            this.constroiObjeto(numeroInicial, stringDataVcto, stringDataComp, valorTitulo, arrayDadosIniciais);
        }

        public void constroiObjeto(int numeroInicial, String stringDataVcto, String stringDataComp, Float valorTitulo, ArrayList<DadosParcelas> arrayDadosIniciais) {
            this.numeroInicial = numeroInicial;
            this.stringDataVcto = stringDataVcto;
            this.stringDataComp = stringDataComp;
            this.valorTitulo = valorTitulo;
            if (arrayDadosIniciais != null) {
                this.carregaDadosArray(arrayDadosIniciais);
            }
            this.montaTela();
        }

        private void carregaDadosArray(ArrayList<DadosParcelas> arrayDadosIniciais) {
            for (int i = 0; i < arrayDadosIniciais.size(); ++i) {
                Object[] linha = new Object[]{arrayDadosIniciais.get((int)i).numeroParcela, arrayDadosIniciais.get((int)i).stringDataComp, arrayDadosIniciais.get((int)i).stringDataVcto, arrayDadosIniciais.get((int)i).valorTitulo};
                this.modelo.addLine(linha);
            }
        }

        protected ArrayList<DadosParcelas> getArrayDadosParcelas() {
            ArrayList<DadosParcelas> arrayDados = null;
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                if (arrayDados == null) {
                    arrayDados = new ArrayList<DadosParcelas>();
                }
                String valorTitulo = (String)this.modelo.getValueAt(i, this.modelo.findColumn("Valor"));
                String stringDataVcto = (String)this.modelo.getValueAt(i, this.modelo.findColumn("Vencimento"));
                String stringDataComp = (String)this.modelo.getValueAt(i, this.modelo.findColumn("Compet\u00eancia"));
                int numeroParcela = (Integer)this.modelo.getValueAt(i, this.modelo.findColumn("N\u00famero"));
                DadosParcelas aux = new DadosParcelas(numeroParcela, stringDataVcto, stringDataComp, valorTitulo);
                arrayDados.add(aux);
            }
            return arrayDados;
        }

        private void montaTela() {
            this.setResizable(false);
            this.modelo.setColumnSize(new int[]{60, 0, 0, 90}, this.grid);
            this.checkDiasFixos.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JCheckBox aux = (JCheckBox)e.getSource();
                    DialogVencimentos.this.panelDatas.removeAll();
                    if (aux.isSelected()) {
                        DialogVencimentos.this.montaPanelDiasFixos();
                        DialogVencimentos.this.panelDatas.add((Component)DialogVencimentos.this.panelDiasFixos, "Center");
                    } else {
                        DialogVencimentos.this.montaPanelDiasVariaveis();
                        DialogVencimentos.this.panelDatas.add((Component)DialogVencimentos.this.panelDiasVariaveis, "Center");
                    }
                    DialogVencimentos.this.panelDatas.revalidate();
                }
            });
            this.buttonLimpar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogVencimentos.this.removerTodasParcelas();
                }
            });
            this.buttonGerarParcelas.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogVencimentos.this.textQtdeParcelas.getText().equals("")) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "Por favor, defina a quantidade de parcelas.", 2);
                        DialogVencimentos.this.textQtdeParcelas.selectAll();
                        if (DialogVencimentos.this.textQtdeParcelas.isFocusable()) {
                            DialogVencimentos.this.textQtdeParcelas.grabFocus();
                        }
                        return;
                    }
                    if (!DialogVencimentos.this.checkDiasFixos.isSelected() && DialogVencimentos.this.textIntervaloParcelas.getText().equals("")) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "Por favor, defina o intervalo entre parcelas.", 2);
                        DialogVencimentos.this.textIntervaloParcelas.selectAll();
                        if (DialogVencimentos.this.textIntervaloParcelas.isFocusable()) {
                            DialogVencimentos.this.textIntervaloParcelas.grabFocus();
                        }
                        return;
                    }
                    if (DialogVencimentos.this.checkDiasFixos.isSelected()) {
                        DialogVencimentos.this.addParcelasAutomaticasDiasFixos(Integer.parseInt(DialogVencimentos.this.textQtdeParcelas.getText()), DialogVencimentos.this.numeroInicial, DialogVencimentos.this.stringDataVcto, DialogVencimentos.this.stringDataComp, DialogVencimentos.this.valorTitulo);
                    } else {
                        DialogVencimentos.this.addParcelasAutomaticas(Integer.parseInt(DialogVencimentos.this.textQtdeParcelas.getText()), Integer.parseInt(DialogVencimentos.this.textIntervaloParcelas.getText()), DialogVencimentos.this.numeroInicial, DialogVencimentos.this.stringDataVcto, DialogVencimentos.this.stringDataComp, DialogVencimentos.this.valorTitulo);
                    }
                    DialogVencimentos.this.textQtdeParcelas.setText("");
                    DialogVencimentos.this.textIntervaloParcelas.setText("");
                    if (DialogVencimentos.this.grid.isFocusable()) {
                        DialogVencimentos.this.grid.grabFocus();
                    }
                }
            });
            this.buttonVcto.setPreferredSize(new Dimension(20, 20));
            this.buttonVcto.setMinimumSize(new Dimension(20, 20));
            this.buttonVcto.setFocusable(false);
            this.buttonVcto.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Funcoes.mostraData(DialogVencimentos.this.textVctoParcela, DialogVencimentos.this.buttonVcto, DialogVencimentos.this.panelPrincipal, true);
                }
            });
            Funcoes.imagemPesquisa(this.buttonVcto);
            this.buttonComp.setPreferredSize(new Dimension(20, 20));
            this.buttonComp.setMinimumSize(new Dimension(20, 20));
            this.buttonComp.setFocusable(false);
            this.buttonComp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Funcoes.mostraData(DialogVencimentos.this.textCompParcela, DialogVencimentos.this.buttonComp, DialogVencimentos.this.panelPrincipal, true);
                }
            });
            Funcoes.imagemPesquisa(this.buttonComp);
            this.buttonOK.setPreferredSize(new Dimension(40, 20));
            this.buttonOK.setMinimumSize(new Dimension(40, 20));
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogVencimentos.this.linhaSelecionada == null) {
                        if (DialogVencimentos.this.textNumParcela.getText().equals("") || DialogVencimentos.this.textVctoParcela.getText().equals("") || DialogVencimentos.this.textCompParcela.getText().equals("") || DialogVencimentos.this.textValorParcela.getText().equals("")) {
                            Funcoes.mensagem(ReceberPagar.this, "Por favor, preencha todos os campos.", 2);
                            return;
                        }
                        DialogVencimentos.this.addParcela(Integer.parseInt(DialogVencimentos.this.textNumParcela.getText()), DialogVencimentos.this.textVctoParcela.getText(), DialogVencimentos.this.textCompParcela.getText(), Float.valueOf(Float.parseFloat(DialogVencimentos.this.textValorParcela.getText())));
                    } else {
                        DialogVencimentos.this.alterarParcela(Integer.parseInt(DialogVencimentos.this.textNumParcela.getText()), DialogVencimentos.this.textVctoParcela.getText(), DialogVencimentos.this.textCompParcela.getText(), Float.valueOf(Float.parseFloat(DialogVencimentos.this.textValorParcela.getText())));
                    }
                    DialogVencimentos.this.textNumParcela.setText("");
                    DialogVencimentos.this.textVctoParcela.setText("");
                    DialogVencimentos.this.textCompParcela.setText("");
                    DialogVencimentos.this.textValorParcela.setText("");
                }
            });
            this.buttonOK.setText("OK");
            this.buttonOK.setMargin(new Insets(0, 0, 0, 0));
            this.textNumParcela.setPreferredSize(new Dimension(60, 20));
            this.textNumParcela.setMinimumSize(new Dimension(60, 20));
            this.textVctoParcela.setPreferredSize(new Dimension(80, 20));
            this.textVctoParcela.setMinimumSize(new Dimension(80, 20));
            this.textVctoParcela.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    DialogVencimentos.this.textVctoParcela.selectAll();
                }
            });
            this.textVctoParcela.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 113) {
                        Funcoes.mostraData(DialogVencimentos.this.textVctoParcela, DialogVencimentos.this.buttonVcto, DialogVencimentos.this.panelPrincipal, true);
                    }
                }
            });
            this.textCompParcela.setPreferredSize(new Dimension(80, 20));
            this.textCompParcela.setMinimumSize(new Dimension(80, 20));
            this.textCompParcela.setMaximumSize(new Dimension(80, 20));
            this.textCompParcela.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    DialogVencimentos.this.textCompParcela.selectAll();
                }
            });
            this.textCompParcela.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 113) {
                        Funcoes.mostraData(DialogVencimentos.this.textCompParcela, DialogVencimentos.this.buttonComp, DialogVencimentos.this.panelPrincipal, true);
                    }
                }
            });
            this.textValorParcela.setPreferredSize(new Dimension(80, 20));
            this.textValorParcela.setMinimumSize(new Dimension(80, 20));
            TableRowSorter<TableModel> sorterParcelas = new TableRowSorter<TableModel>(this.grid.getModel());
            this.grid.setRowSorter(sorterParcelas);
            this.grid.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 127) {
                        DialogVencimentos.this.removeParcela();
                    }
                }
            });
            this.grid.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int linha = -1;
                    if (DialogVencimentos.this.grid.getSelectedRow() >= 0) {
                        linha = DialogVencimentos.this.grid.getRowSorter().convertRowIndexToModel(DialogVencimentos.this.grid.getSelectedRow());
                    }
                    if (e.getClickCount() == 2) {
                        if (linha == -1) {
                            DialogVencimentos.this.linhaSelecionada = null;
                        } else {
                            DialogVencimentos.this.linhaSelecionada = DialogVencimentos.this.modelo.getLine(linha);
                            DialogVencimentos.this.carregaDadosLinha(DialogVencimentos.this.linhaSelecionada);
                        }
                    } else if (e.getClickCount() == 1) {
                        DialogVencimentos.this.linhaSelecionada = null;
                    }
                }
            });
            this.scrollGrid = new JScrollPane(this.grid);
            this.scrollGrid.setPreferredSize(new Dimension(400, 170));
            this.scrollGrid.setMinimumSize(new Dimension(400, 170));
            this.scrollGrid.setVerticalScrollBarPolicy(22);
            this.montaPanelDiasFixos();
            this.panelDatas.add((Component)this.panelDiasFixos, "Center");
            this.panelPrincipal.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            this.setSize(new Dimension(415, 350));
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 17;
            c.insets = new Insets(2, 1, 1, 1);
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridheight = 1;
            c.gridwidth = 1;
            this.panelPrincipal.add((Component)this.checkDiasFixos, c);
            ++c.gridx;
            c.weightx = 1.0;
            c.fill = 2;
            this.panelPrincipal.add((Component)new JLabel(""), c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 2;
            this.panelPrincipal.add((Component)this.panelDatas, c);
            c.gridx = 0;
            ++c.gridy;
            c.anchor = 17;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 5;
            c.fill = 1;
            c.insets = new Insets(1, 1, 1, 1);
            this.panelPrincipal.add((Component)this.panelParcelas, c);
            this.panelParcelas.setLayout(new GridBagLayout());
            this.panelParcelas.setBorder(new TitledBorder("Parcelas"));
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 17;
            c.fill = 0;
            c.weighty = 1.0;
            this.panelParcelas.add((Component)this.labelNumParcela, c);
            c.gridx += 2;
            c.fill = 2;
            this.panelParcelas.add((Component)this.labelVctoParcela, c);
            c.fill = 0;
            c.gridx += 3;
            this.panelParcelas.add((Component)this.labelCompParcela, c);
            c.gridx += 3;
            this.panelParcelas.add((Component)this.labelValorParcela, c);
            c.gridx = 0;
            ++c.gridy;
            this.panelParcelas.add((Component)this.textNumParcela, c);
            c.gridx += 2;
            c.fill = 2;
            this.panelParcelas.add((Component)this.textVctoParcela, c);
            c.fill = 0;
            ++c.gridx;
            this.panelParcelas.add((Component)this.buttonVcto, c);
            c.gridx += 2;
            this.panelParcelas.add((Component)this.textCompParcela, c);
            ++c.gridx;
            this.panelParcelas.add((Component)this.buttonComp, c);
            c.gridx += 2;
            this.panelParcelas.add((Component)this.textValorParcela, c);
            ++c.gridx;
            this.panelParcelas.add((Component)this.buttonOK, c);
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 0;
            c.fill = 1;
            this.panelParcelas.add((Component)this.scrollGrid, c);
            this.setLocationRelativeTo(Laboratorio.getInstancia());
            Funcoes.montaEnter((JComponent)this.panelPrincipal);
            this.setVisible(true);
        }

        private void alterarParcela(int numeroParcela, String stringDataVcto, String stringDataComp, Float valorTitulo) {
            if (this.linhaSelecionada != null) {
                int linha = -1;
                if (this.grid.getSelectedRow() >= 0) {
                    linha = this.grid.getRowSorter().convertRowIndexToModel(this.grid.getSelectedRow());
                }
                if (linha > -1) {
                    this.modelo.setValueAt(numeroParcela, linha, this.modelo.findColumn("N\u00famero"));
                    this.modelo.setValueAt(Funcoes.formataData("dd/MM/yyyy", stringDataVcto), linha, this.modelo.findColumn("Vencimento"));
                    this.modelo.setValueAt(Funcoes.formataData("dd/MM/yyyy", stringDataComp), linha, this.modelo.findColumn("Compet\u00eancia"));
                    this.modelo.setValueAt(Funcoes.formataDecimal(valorTitulo.floatValue()), linha, this.modelo.findColumn("Valor"));
                    this.linhaSelecionada = null;
                }
            }
        }

        private void carregaDadosLinha(HashMap<String, Object> linha) {
            if (linha != null) {
                this.textCompParcela.setText(linha.get("Compet\u00eancia").toString());
                this.textNumParcela.setText(linha.get("N\u00famero").toString());
                this.textVctoParcela.setText(linha.get("Vencimento").toString());
                this.textValorParcela.setText(linha.get("Valor").toString());
                if (this.textNumParcela.isFocusable()) {
                    this.textNumParcela.grabFocus();
                }
            }
        }

        private void montaPanelDiasFixos() {
            this.textQtdeParcelas.setPreferredSize(new Dimension(50, 20));
            this.textQtdeParcelas.setMinimumSize(new Dimension(50, 20));
            this.buttonGerarParcelas.setPreferredSize(new Dimension(70, 20));
            this.buttonGerarParcelas.setMinimumSize(new Dimension(70, 20));
            this.buttonLimpar.setPreferredSize(new Dimension(80, 20));
            this.buttonLimpar.setMinimumSize(new Dimension(80, 20));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 17;
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridheight = 1;
            c.gridwidth = 1;
            this.panelDiasFixos.add((Component)this.labelQtdeParcelas, c);
            ++c.gridx;
            this.panelDiasFixos.add((Component)this.textQtdeParcelas, c);
            ++c.gridx;
            this.panelDiasFixos.add((Component)this.buttonGerarParcelas, c);
            ++c.gridx;
            this.panelDiasFixos.add((Component)this.buttonLimpar, c);
            ++c.gridx;
            c.fill = 2;
            c.weightx = 1.0;
            this.panelDiasFixos.add((Component)new JLabel(""), c);
        }

        private void montaPanelDiasVariaveis() {
            this.textQtdeParcelas.setPreferredSize(new Dimension(50, 20));
            this.textQtdeParcelas.setMinimumSize(new Dimension(50, 20));
            this.textIntervaloParcelas.setPreferredSize(new Dimension(50, 20));
            this.textIntervaloParcelas.setMinimumSize(new Dimension(50, 20));
            this.buttonGerarParcelas.setPreferredSize(new Dimension(70, 20));
            this.buttonGerarParcelas.setMinimumSize(new Dimension(70, 20));
            this.buttonLimpar.setPreferredSize(new Dimension(80, 20));
            this.buttonLimpar.setMinimumSize(new Dimension(80, 20));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 17;
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridheight = 1;
            c.gridwidth = 1;
            this.panelDiasVariaveis.add((Component)this.labelQtdeParcelas, c);
            ++c.gridx;
            this.panelDiasVariaveis.add((Component)this.textQtdeParcelas, c);
            ++c.gridx;
            this.panelDiasVariaveis.add((Component)new JLabel(" "), c);
            ++c.gridx;
            this.panelDiasVariaveis.add((Component)this.labelIntervaloParcelas, c);
            ++c.gridx;
            this.panelDiasVariaveis.add((Component)this.textIntervaloParcelas, c);
            ++c.gridx;
            this.panelDiasVariaveis.add((Component)this.buttonGerarParcelas, c);
            ++c.gridx;
            this.panelDiasVariaveis.add((Component)this.buttonLimpar, c);
            ++c.gridx;
            c.fill = 2;
            c.weightx = 1.0;
            this.panelDiasVariaveis.add((Component)new JLabel(""), c);
        }

        private void removerTodasParcelas() {
            this.modelo.clear();
        }

        private void removeParcela() {
            if (this.grid.getSelectedRow() >= 0) {
                int linha = this.grid.getRowSorter().convertRowIndexToModel(this.grid.getSelectedRow());
                this.modelo.removeLine(linha);
            }
        }

        private boolean existsParcela(int numeroParcela) {
            if (numeroParcela == this.numeroInicial) {
                return true;
            }
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                if (!this.modelo.getValueAt(i, this.modelo.findColumn("N\u00famero")).toString().equals(String.valueOf(numeroParcela))) continue;
                return true;
            }
            return false;
        }

        private void addParcela(int numeroParcela, String stringDataVcto, String stringDataComp, Float valorTitulo) {
            Object[] linha = new Object[4];
            if (this.existsParcela(numeroParcela)) {
                this.textNumParcela.setText("");
                this.textCompParcela.setText("");
                this.textVctoParcela.setText("");
                this.textValorParcela.setText("");
                return;
            }
            linha[0] = numeroParcela;
            linha[1] = Funcoes.formataData(Funcoes.somaDias(Funcoes.getData("dd/MM/yyyy", stringDataVcto), 0));
            linha[2] = Funcoes.formataData(Funcoes.somaDias(Funcoes.getData("dd/MM/yyyy", stringDataComp), 0));
            linha[3] = Funcoes.formataDecimal(valorTitulo.floatValue());
            this.modelo.addLine(linha);
        }

        private void addParcelasAutomaticasDiasFixos(int qtdeParcelas, int numeroInicial, String stringDataVcto, String stringDataComp, Float valorTitulo) {
            if (qtdeParcelas <= 0 || stringDataVcto.equals("")) {
                return;
            }
            if (stringDataComp.equals("")) {
                stringDataComp = stringDataVcto.toString();
            }
            Float auxValor = Float.valueOf(0.0f);
            auxValor = valorTitulo;
            this.modelo.clear();
            for (int i = 0; i < qtdeParcelas; ++i) {
                if (this.existsParcela(numeroInicial + i + 1)) {
                    return;
                }
                Object[] linha = new Object[this.modelo.getColumnCount()];
                linha[0] = numeroInicial + i + 1;
                linha[1] = Funcoes.formataData(Funcoes.somaMeses(Funcoes.getData("dd/MM/yyyy", stringDataVcto), i + 1));
                linha[2] = Funcoes.formataData(Funcoes.somaMeses(Funcoes.getData("dd/MM/yyyy", stringDataComp), i + 1));
                linha[3] = Funcoes.formataDecimal(auxValor.floatValue());
                this.modelo.addLine(linha);
            }
        }

        private void addParcelasAutomaticas(int qtdeParcelas, int intervaloDias, int numeroInicial, String stringDataVcto, String stringDataComp, Float valorTitulo) {
            if (qtdeParcelas <= 0 || stringDataVcto.equals("")) {
                return;
            }
            if (stringDataComp.equals("")) {
                stringDataComp = stringDataVcto.toString();
            }
            Float auxValor = Float.valueOf(0.0f);
            auxValor = valorTitulo;
            this.modelo.clear();
            for (int i = 0; i < qtdeParcelas; ++i) {
                if (this.existsParcela(numeroInicial + i + 1)) {
                    return;
                }
                Object[] linha = new Object[this.modelo.getColumnCount()];
                linha[0] = numeroInicial + i + 1;
                linha[1] = Funcoes.formataData(Funcoes.somaDias(Funcoes.getData("dd/MM/yyyy", stringDataVcto), intervaloDias * (i + 1)));
                linha[2] = Funcoes.formataData(Funcoes.somaDias(Funcoes.getData("dd/MM/yyyy", stringDataComp), intervaloDias * (i + 1)));
                linha[3] = Funcoes.formataDecimal(auxValor.floatValue());
                this.modelo.addLine(linha);
            }
        }
    }

    class DadosParcelas {
        protected String stringTitulo;
        protected String stringDataVcto;
        protected String stringDataComp;
        protected String valorTitulo;
        protected int numeroParcela;

        public DadosParcelas(int numeroParcela, String stringDataVcto, String stringDataComp, String valorTitulo) {
            this.numeroParcela = numeroParcela;
            this.stringDataComp = stringDataComp;
            this.stringDataVcto = stringDataVcto;
            this.valorTitulo = valorTitulo;
        }
    }
}

