/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.lancamentos.DialogBuscaTitulos;
import jalis.laboratorio.financeiro.lancamentos.TituloRenderer;
import jalis.laboratorio.relatorios.financeiro.movimento.RelatorioAvisoCobranca;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.dao.financeiro.ReceberPagarDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.service.financeiro.ReceberPagarService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ProtestoTitulos
extends FrmCadPadrao {
    private JTable tableSelecionados;
    private JTable tableAlterados;
    private ModeloGridTable modelSelecionados;
    private ModeloGridTable modelAlterados;
    private JScrollPane scrollSelecionados;
    private JScrollPane scrollAlterados;
    private TTextField textCodigo = new TTextField(8, 3);
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JCheckBox checkEmitirAviso = new JCheckBox("Emitir Aviso de Cobran\u00e7a ao salvar");
    private ReceberPagarService service = new ReceberPagarService();
    private JPanel panelBusca = new JPanel(new GridBagLayout());
    private JPanel panelLegendas = new JPanel(new GridBagLayout());
    private JPanel panelSelecionados = new JPanel(new GridBagLayout());
    private JPanel panelAlterados = new JPanel(new GridBagLayout());
    private JButton buttonBusca = new JButton();
    private JButton buttonCartorio = new JButton("Cart\u00f3rio");
    private JButton buttonProtesto = new JButton("Protesto");
    private JButton buttonAviso = new JButton("Aviso de Cobran\u00e7a");
    private JButton buttonAberto = new JButton("Aberto");
    private JButton buttonSelecionarTodos = new JButton("Selecionar Todos");
    private JButton buttonLimparSelecao = new JButton("Limpar Sele\u00e7\u00e3o");
    private JButton buttonRemover = new JButton("Remover Altera\u00e7\u00e3o");
    private JButton buttonSelecionarTodosAlterados = new JButton("Selecionar Todos");
    private JButton buttonLimparSelecaoAlterados = new JButton("Limpar Sele\u00e7\u00e3o");
    public static final Color COR_PROTESTO = ScreenUtil.clarearCor(Color.YELLOW, 125);
    public static final Color COR_CARTORIO = ScreenUtil.clarearCor(Color.GREEN, 125);
    public static final Color COR_AVISO_COBRANCA = ScreenUtil.clarearCor(Color.BLUE, 125);

    public ProtestoTitulos() {
        this.painelCentral.setLayout(new GridBagLayout());
        Funcoes.criaBarraDescricao(this, "Protesto de T\u00edtulos", "Protesto de t\u00edtulos a receber", "financeiro/protesto_titulos.jpg");
        this.painelBotoes.removeAll();
        this.painelBotoes.setLayout(new GridBagLayout());
        this.modelSelecionados = new ModeloGridTable(new String[]{"Cadastro", "Documento", "Vencimento", "Valor", "Total", "Dias Atraso", "Sel", "Objeto"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.getColumnNameSemCaracterEspecial(columnIndex).equalsIgnoreCase("Sel");
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    ProtestoTitulos.this.tableSelecionados.removeColumn(ProtestoTitulos.this.tableSelecionados.getColumn("Objeto"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            public Class getColumnClass(int c) {
                if (this.getColumnNameSemCaracterEspecial(c).equalsIgnoreCase("Sel")) {
                    return Boolean.class;
                }
                return super.getColumnClass(c);
            }
        };
        this.tableSelecionados = new JTable(this.modelSelecionados);
        this.tableSelecionados.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    int row;
                    int[] colunas = ((JTable)e.getSource()).getSelectedColumns();
                    boolean colunaSelecionada = false;
                    for (int i = 0; i < colunas.length; ++i) {
                        if (!ProtestoTitulos.this.modelSelecionados.getColumnNameSemCaracterEspecial(colunas[i]).equalsIgnoreCase("Sel")) continue;
                        colunaSelecionada = true;
                        break;
                    }
                    if ((row = ((JTable)e.getSource()).getSelectedRow()) >= 0 && !colunaSelecionada) {
                        Boolean valor = (Boolean)ProtestoTitulos.this.modelSelecionados.getValueAt(row, ProtestoTitulos.this.modelSelecionados.findColumn("Sel"));
                        ProtestoTitulos.this.modelSelecionados.setValueAt(valor == false, row, ProtestoTitulos.this.modelSelecionados.findColumn("Sel"));
                    }
                }
            }
        });
        this.modelSelecionados.setColumnSize(new int[]{0, 90, 90, 90, 90, 90, 20, 0}, this.tableSelecionados);
        this.tableSelecionados.removeColumn(this.tableSelecionados.getColumn("Objeto"));
        this.tableSelecionados.getTableHeader().addMouseListener(this.modelSelecionados);
        TituloRenderer rendererTitulo = new TituloRenderer();
        this.tableSelecionados.setDefaultRenderer(Object.class, rendererTitulo);
        this.scrollSelecionados = new JScrollPane(this.tableSelecionados);
        this.modelAlterados = new ModeloGridTable(new String[]{"Cadastro", "Documento", "Vencimento", "Valor", "Total", "Dias Atraso", "Sel", "Objeto", "Sit Ant"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.getColumnNameSemCaracterEspecial(columnIndex).equalsIgnoreCase("Sel");
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    ProtestoTitulos.this.tableAlterados.removeColumn(ProtestoTitulos.this.tableAlterados.getColumn("Objeto"));
                    ProtestoTitulos.this.tableAlterados.removeColumn(ProtestoTitulos.this.tableAlterados.getColumn("Sit Ant"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            public Class getColumnClass(int c) {
                if (this.getColumnNameSemCaracterEspecial(c).equalsIgnoreCase("Sel")) {
                    return Boolean.class;
                }
                return super.getColumnClass(c);
            }
        };
        this.tableAlterados = new JTable(this.modelAlterados);
        this.tableAlterados.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    int row;
                    int[] colunas = ((JTable)e.getSource()).getSelectedColumns();
                    boolean colunaSelecionada = false;
                    for (int i = 0; i < colunas.length; ++i) {
                        if (!ProtestoTitulos.this.modelAlterados.getColumnNameSemCaracterEspecial(colunas[i]).equalsIgnoreCase("Sel")) continue;
                        colunaSelecionada = true;
                        break;
                    }
                    if ((row = ((JTable)e.getSource()).getSelectedRow()) >= 0 && !colunaSelecionada) {
                        Boolean valor = (Boolean)ProtestoTitulos.this.modelAlterados.getValueAt(row, ProtestoTitulos.this.modelAlterados.findColumn("Sel"));
                        ProtestoTitulos.this.modelAlterados.setValueAt(valor == false, row, ProtestoTitulos.this.modelAlterados.findColumn("Sel"));
                    }
                }
            }
        });
        this.modelAlterados.setColumnSize(new int[]{0, 90, 90, 90, 90, 90, 20, 0, 0}, this.tableAlterados);
        this.tableAlterados.removeColumn(this.tableAlterados.getColumn("Objeto"));
        this.tableAlterados.removeColumn(this.tableAlterados.getColumn("Sit Ant"));
        this.tableAlterados.getTableHeader().addMouseListener(this.modelAlterados);
        this.tableAlterados.setDefaultRenderer(Object.class, rendererTitulo);
        this.scrollAlterados = new JScrollPane(this.tableAlterados);
        Dimension d = new Dimension(80, 20);
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setMinimumSize(d);
        this.textCodigo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ProtestoTitulos.this.buscaTitulos();
                }
            }
        });
        d = new Dimension(20, 20);
        this.buttonBusca.setPreferredSize(d);
        this.buttonBusca.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonBusca);
        this.buttonBusca.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProtestoTitulos.this.buscaTitulos();
            }
        });
        this.buttonCartorio.setMargin(new Insets(1, 1, 1, 1));
        this.buttonCartorio.setMnemonic('t');
        this.buttonCartorio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProtestoTitulos.this.enviarCartorio();
            }
        });
        this.buttonProtesto.setMargin(new Insets(1, 1, 1, 1));
        this.buttonProtesto.setMnemonic('P');
        this.buttonProtesto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProtestoTitulos.this.enviarProtesto();
            }
        });
        this.buttonAberto.setMargin(new Insets(1, 1, 1, 1));
        this.buttonAberto.setMnemonic('A');
        this.buttonAberto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProtestoTitulos.this.enviarAberto();
            }
        });
        this.buttonAviso.setMargin(new Insets(1, 1, 1, 1));
        this.buttonAviso.setMnemonic('v');
        this.buttonAviso.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProtestoTitulos.this.enviarAviso();
            }
        });
        this.buttonRemover.setMargin(new Insets(1, 1, 1, 1));
        this.buttonRemover.setMnemonic('R');
        this.buttonRemover.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProtestoTitulos.this.removerAlteracao();
            }
        });
        this.buttonSelecionarTodos.setMargin(new Insets(1, 1, 1, 1));
        this.buttonSelecionarTodos.setMnemonic('e');
        this.buttonSelecionarTodos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProtestoTitulos.this.selecionarTodos();
            }
        });
        this.buttonSelecionarTodosAlterados.setMargin(new Insets(1, 1, 1, 1));
        this.buttonSelecionarTodosAlterados.setMnemonic('o');
        this.buttonSelecionarTodosAlterados.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProtestoTitulos.this.selecionarTodosAlterados();
            }
        });
        this.buttonLimparSelecao.setMargin(new Insets(1, 1, 1, 1));
        this.buttonLimparSelecao.setMnemonic('L');
        this.buttonLimparSelecao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProtestoTitulos.this.limparSelecao();
            }
        });
        this.buttonLimparSelecaoAlterados.setMargin(new Insets(1, 1, 1, 1));
        this.buttonLimparSelecaoAlterados.setMnemonic('i');
        this.buttonLimparSelecaoAlterados.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProtestoTitulos.this.limparSelecaoAlterados();
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.montaPainelBusca();
        this.painelCentral.add((Component)this.panelBusca, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.montaPainelSelecionados();
        this.painelCentral.add((Component)this.panelSelecionados, c);
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        this.montaPainelAlterados();
        this.painelCentral.add((Component)this.panelAlterados, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 2;
        this.montaPainelLegendas();
        this.painelCentral.add((Component)this.panelLegendas, c);
        this.montaPainelBotoes();
        this.controlaCampos();
    }

    private void montaPainelBotoes() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.painelBotoes.add((Component)this.checkEmitirAviso, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.painelBotoes.add((Component)new JLabel(), c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        this.painelBotoes.add((Component)this.botaoNovo, c);
        ++c.gridx;
        this.painelBotoes.add((Component)this.botaoSalvar, c);
        ++c.gridx;
        this.painelBotoes.add((Component)this.botaoCancelar, c);
        ++c.gridx;
        this.painelBotoes.add((Component)this.botaoFechar, c);
    }

    private void selecionarTodos() {
        for (int i = 0; i < this.modelSelecionados.getRowCount(); ++i) {
            this.modelSelecionados.setValueAt(true, i, this.modelSelecionados.findColumn("Sel"));
        }
        this.modelSelecionados.fireTableDataChanged();
    }

    private void limparSelecao() {
        for (int i = 0; i < this.modelSelecionados.getRowCount(); ++i) {
            this.modelSelecionados.setValueAt(false, i, this.modelSelecionados.findColumn("Sel"));
        }
        this.modelSelecionados.fireTableDataChanged();
    }

    private void selecionarTodosAlterados() {
        for (int i = 0; i < this.modelAlterados.getRowCount(); ++i) {
            this.modelAlterados.setValueAt(true, i, this.modelAlterados.findColumn("Sel"));
        }
        this.modelAlterados.fireTableDataChanged();
    }

    private void limparSelecaoAlterados() {
        for (int i = 0; i < this.modelAlterados.getRowCount(); ++i) {
            this.modelAlterados.setValueAt(false, i, this.modelAlterados.findColumn("Sel"));
        }
        this.modelAlterados.fireTableDataChanged();
    }

    private void enviarAviso() {
        for (int i = 0; i < this.modelSelecionados.getRowCount(); ++i) {
            ReceberPagarBean titulo;
            String situacao;
            Boolean bool = (Boolean)this.modelSelecionados.getValueAt(i, this.modelSelecionados.findColumn("Sel"));
            if (bool == null || !bool.booleanValue() || (situacao = (titulo = (ReceberPagarBean)this.modelSelecionados.getValueAt(i, this.modelSelecionados.findColumn("Objeto"))).getSituacao()).equalsIgnoreCase("V")) continue;
            titulo.setSituacao("V");
            this.adicionaTituloAlterado(titulo, situacao);
            this.modelSelecionados.removeLine(i);
            --i;
        }
    }

    private void enviarCartorio() {
        for (int i = 0; i < this.modelSelecionados.getRowCount(); ++i) {
            ReceberPagarBean titulo;
            String situacao;
            Boolean bool = (Boolean)this.modelSelecionados.getValueAt(i, this.modelSelecionados.findColumn("Sel"));
            if (bool == null || !bool.booleanValue() || (situacao = (titulo = (ReceberPagarBean)this.modelSelecionados.getValueAt(i, this.modelSelecionados.findColumn("Objeto"))).getSituacao()).equalsIgnoreCase("T")) continue;
            titulo.setSituacao("T");
            this.adicionaTituloAlterado(titulo, situacao);
            this.modelSelecionados.removeLine(i);
            --i;
        }
    }

    private void enviarProtesto() {
        for (int i = 0; i < this.modelSelecionados.getRowCount(); ++i) {
            ReceberPagarBean titulo;
            String situacao;
            Boolean bool = (Boolean)this.modelSelecionados.getValueAt(i, this.modelSelecionados.findColumn("Sel"));
            if (bool == null || !bool.booleanValue() || (situacao = (titulo = (ReceberPagarBean)this.modelSelecionados.getValueAt(i, this.modelSelecionados.findColumn("Objeto"))).getSituacao()).equalsIgnoreCase("S")) continue;
            titulo.setSituacao("S");
            this.adicionaTituloAlterado(titulo, situacao);
            this.modelSelecionados.removeLine(i);
            --i;
        }
    }

    private void enviarAberto() {
        for (int i = 0; i < this.modelSelecionados.getRowCount(); ++i) {
            ReceberPagarBean titulo;
            String situacao;
            Boolean bool = (Boolean)this.modelSelecionados.getValueAt(i, this.modelSelecionados.findColumn("Sel"));
            if (bool == null || !bool.booleanValue() || (situacao = (titulo = (ReceberPagarBean)this.modelSelecionados.getValueAt(i, this.modelSelecionados.findColumn("Objeto"))).getSituacao()).equalsIgnoreCase("A")) continue;
            titulo.setSituacao("A");
            this.adicionaTituloAlterado(titulo, situacao);
            this.modelSelecionados.removeLine(i);
            --i;
        }
    }

    private void removerAlteracao() {
        for (int i = 0; i < this.modelAlterados.getRowCount(); ++i) {
            Boolean bool = (Boolean)this.modelAlterados.getValueAt(i, this.modelAlterados.findColumn("Sel"));
            if (bool == null || !bool.booleanValue()) continue;
            ReceberPagarBean titulo = (ReceberPagarBean)this.modelAlterados.getValueAt(i, this.modelAlterados.findColumn("Objeto"));
            titulo.setSituacao((String)this.modelAlterados.getValueAt(i, this.modelAlterados.findColumn("Sit Ant")));
            this.adicionaTitulo(titulo);
            this.modelAlterados.removeLine(i);
            --i;
        }
    }

    private void adicionaTituloAlterado(ReceberPagarBean titulo, String situacaoAnterior) {
        if (titulo == null || this.tituloAlteradoAdicionado(titulo)) {
            return;
        }
        String cadastro = "";
        cadastro = titulo.getTipoCadastro().equalsIgnoreCase("P") ? titulo.getPaciente().getNome() : (titulo.getTipoCadastro().equalsIgnoreCase("O") ? titulo.getConvenio().getFantasia() : titulo.getEntidade().getFantasia());
        this.modelAlterados.addLine(new Object[]{cadastro, titulo.getNumeroDocumento(), Funcoes.formataData("dd/MM/yyyy", titulo.getDataVencimento()), Funcoes.formataDecimal(titulo.getValor()), Funcoes.formataDecimal(titulo.getValorTotal()), Funcoes.daysBetween(new Date(), titulo.getDataVencimento()), new Boolean(false), titulo, situacaoAnterior});
        this.textCodigo.setText("");
        if (this.textCodigo.isFocusable()) {
            this.textCodigo.grabFocus();
        }
    }

    private boolean tituloSelecionadoAdicionado(ReceberPagarBean bean) {
        for (int i = 0; i < this.modelSelecionados.getRowCount(); ++i) {
            ReceberPagarBean beanModel;
            if (this.modelSelecionados.getValueAt(i, this.modelSelecionados.findColumn("Objeto")) == null || !(beanModel = (ReceberPagarBean)this.modelSelecionados.getValueAt(i, this.modelSelecionados.findColumn("Objeto"))).equals(bean)) continue;
            return true;
        }
        return false;
    }

    private boolean tituloAlteradoAdicionado(ReceberPagarBean bean) {
        for (int i = 0; i < this.modelAlterados.getRowCount(); ++i) {
            ReceberPagarBean beanModel;
            if (this.modelAlterados.getValueAt(i, this.modelAlterados.findColumn("Objeto")) == null || !(beanModel = (ReceberPagarBean)this.modelAlterados.getValueAt(i, this.modelAlterados.findColumn("Objeto"))).equals(bean)) continue;
            return true;
        }
        return false;
    }

    private void buscaTitulos() {
        List<HashMap<String, Object>> titulos = null;
        DialogBuscaTitulos diag = new DialogBuscaTitulos(Laboratorio.getInstancia());
        titulos = diag.getTitulosSelecionados();
        diag.setVisible(false);
        diag = null;
        if (titulos != null && titulos.size() > 0) {
            Iterator<HashMap<String, Object>> it = titulos.iterator();
            int i = 0;
            int qtde = titulos.size();
            SplashMensagem janelaEspera = SplashMensagem.getInstancia(this);
            janelaEspera.mostrar("Adicionando t\u00edtulos");
            while (it.hasNext()) {
                HashMap<String, Object> reg = it.next();
                janelaEspera.setText("Adicionando t\u00edtulos - " + (int)Funcoes.arredondar(++i * 100 / qtde, 2) + "%");
                ReceberPagarBean titulo = null;
                try {
                    titulo = (ReceberPagarBean)new ReceberPagarDao().getBean(Variaveis.filialPadrao, String.valueOf(reg.get("C\u00f3digo")));
                }
                catch (ThreadDaoException e) {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados do t\u00edtulo.", 2);
                }
                if (titulo == null || !this.validaTitulo(titulo)) continue;
                this.adicionaTitulo(titulo);
            }
            janelaEspera.apagar();
        }
    }

    private void adicionaTitulo(ReceberPagarBean titulo) {
        if (titulo == null || this.tituloSelecionadoAdicionado(titulo)) {
            return;
        }
        String cadastro = "";
        cadastro = titulo.getTipoCadastro().equalsIgnoreCase("P") ? titulo.getPaciente().getNome() : (titulo.getTipoCadastro().equalsIgnoreCase("O") ? titulo.getConvenio().getFantasia() : titulo.getEntidade().getFantasia());
        this.modelSelecionados.addLine(new Object[]{cadastro, titulo.getNumeroDocumento(), Funcoes.formataData("dd/MM/yyyy", titulo.getDataVencimento()), Funcoes.formataDecimal(titulo.getValor()), Funcoes.formataDecimal(titulo.getValorTotal()), Funcoes.daysBetween(new Date(), titulo.getDataVencimento()), new Boolean(false), titulo});
        this.textCodigo.setText("");
        if (this.textCodigo.isFocusable()) {
            this.textCodigo.grabFocus();
        }
    }

    private boolean validaTitulo(ReceberPagarBean titulo) {
        boolean erro = false;
        if (titulo.getSituacao() == null || !titulo.getSituacao().equalsIgnoreCase("A") && !titulo.getSituacao().equalsIgnoreCase("S") && !titulo.getSituacao().equalsIgnoreCase("V") && !titulo.getSituacao().equalsIgnoreCase("T")) {
            Funcoes.mensagem(this, "Somente t\u00edtulos com situa\u00e7\u00e3o 'Aberto' podem ser protestados.\nA situa\u00e7\u00e3o do t\u00edtulo \u00e9: '" + Tipos.tipoSituacaoReceberPagar(titulo.getSituacao()) + "'.", 2);
            erro = true;
        }
        if (!(erro || titulo.getTipo() != null && titulo.getTipo().equalsIgnoreCase("R"))) {
            Funcoes.mensagem(this, "Somente t\u00edtulos a receber podem ser protestados.", 2);
            erro = true;
        }
        if (erro) {
            this.textCodigo.selectAll();
            if (this.textCodigo.isFocusable()) {
                this.textCodigo.grabFocus();
            }
            return false;
        }
        return true;
    }

    private void montaPainelBusca() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelBusca.add((Component)this.labelCodigo, c);
        ++c.gridx;
        this.panelBusca.add((Component)this.textCodigo, c);
        ++c.gridx;
        this.panelBusca.add((Component)this.buttonBusca, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelBusca.add((Component)new JLabel(), c);
    }

    private void montaPainelLegendas() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_AVISO_COBRANCA);
        this.panelLegendas.add((Component)pnlCorLegenda, c);
        JLabel lblLegenda = new JLabel("Aviso de Cobran\u00e7a");
        Font font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        this.panelLegendas.add((Component)lblLegenda, c);
        ++c.gridx;
        this.panelLegendas.add((Component)new JLabel("  "), c);
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_CARTORIO);
        ++c.gridx;
        this.panelLegendas.add((Component)pnlCorLegenda, c);
        lblLegenda = new JLabel("Cart\u00f3rio");
        font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        this.panelLegendas.add((Component)lblLegenda, c);
        ++c.gridx;
        this.panelLegendas.add((Component)new JLabel("  "), c);
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_PROTESTO);
        ++c.gridx;
        this.panelLegendas.add((Component)pnlCorLegenda, c);
        lblLegenda = new JLabel("Protesto");
        font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        this.panelLegendas.add((Component)lblLegenda, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelLegendas.add((Component)new JLabel(), c);
    }

    private void montaPainelSelecionados() {
        this.panelSelecionados.setBorder(BorderFactory.createTitledBorder("T\u00edtulos Selecionados"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 7;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelSelecionados.add((Component)this.scrollSelecionados, c);
        ++c.gridy;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        this.panelSelecionados.add((Component)this.buttonSelecionarTodos, c);
        ++c.gridx;
        this.panelSelecionados.add((Component)this.buttonLimparSelecao, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelSelecionados.add((Component)new JLabel(), c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.panelSelecionados.add((Component)this.buttonAviso, c);
        ++c.gridx;
        this.panelSelecionados.add((Component)this.buttonCartorio, c);
        ++c.gridx;
        this.panelSelecionados.add((Component)this.buttonProtesto, c);
        ++c.gridx;
        this.panelSelecionados.add((Component)this.buttonAberto, c);
    }

    private void montaPainelAlterados() {
        this.panelAlterados.setBorder(BorderFactory.createTitledBorder("T\u00edtulos Alterados"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 4;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelAlterados.add((Component)this.scrollAlterados, c);
        ++c.gridy;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        this.panelAlterados.add((Component)this.buttonSelecionarTodosAlterados, c);
        ++c.gridx;
        this.panelAlterados.add((Component)this.buttonLimparSelecaoAlterados, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelAlterados.add((Component)new JLabel(), c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.panelAlterados.add((Component)this.buttonRemover, c);
    }

    private void limparCampos() {
        this.textCodigo.setText("");
        this.modelSelecionados.clear();
        this.modelAlterados.clear();
        this.checkEmitirAviso.setSelected(false);
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        if (this.textCodigo.isEnabled() && this.textCodigo.isFocusable()) {
            this.textCodigo.grabFocus();
        }
    }

    @Override
    public void salvar() {
        if (this.validaCampos()) {
            RelatorioAvisoCobranca relatorioAviso = null;
            if (this.checkEmitirAviso.isSelected()) {
                relatorioAviso = new RelatorioAvisoCobranca(false);
            }
            for (int i = 0; i < this.modelAlterados.getRowCount(); ++i) {
                ReceberPagarBean bean = (ReceberPagarBean)this.modelAlterados.getValueAt(i, this.modelAlterados.findColumn("Objeto"));
                bean = this.configuraDataAlteracaoTitulo(bean);
                try {
                    this.service.gravaAutoCopiaSemCommit(bean, 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                    Conexao.arquivaSQL();
                    if (!this.checkEmitirAviso.isSelected() || !bean.getSituacao().equalsIgnoreCase("V") || relatorioAviso == null) continue;
                    relatorioAviso.imprimirPressionado(String.valueOf(bean.getCodigo()));
                    continue;
                }
                catch (Exception e) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel salvar as altera\u00e7\u00f5es nos t\u00edtulos. - " + e.getMessage(), 2);
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    protected String getCopiaFiliais() {
        return null;
    }

    private void controlaCampos() {
        boolean habilitar = this.getStatus() == 2;
        this.textCodigo.setEnabled(habilitar);
        this.buttonBusca.setEnabled(habilitar);
        this.buttonSelecionarTodos.setEnabled(habilitar);
        this.buttonLimparSelecao.setEnabled(habilitar);
        this.buttonCartorio.setEnabled(habilitar && Acesso.getAcesso(ProtestoTitulos.getModuloCartorio()));
        this.buttonProtesto.setEnabled(habilitar && Acesso.getAcesso(ProtestoTitulos.getModuloProtesto()));
        this.buttonAberto.setEnabled(habilitar && Acesso.getAcesso(ProtestoTitulos.getModuloReabrir()));
        this.buttonAviso.setEnabled(habilitar && Acesso.getAcesso(ProtestoTitulos.getModuloAviso()));
        this.checkEmitirAviso.setEnabled(habilitar && Acesso.getAcesso(ProtestoTitulos.getModuloEmitirAviso()));
        this.buttonSelecionarTodosAlterados.setEnabled(habilitar);
        this.buttonLimparSelecaoAlterados.setEnabled(habilitar);
        this.buttonRemover.setEnabled(habilitar);
        this.tableSelecionados.setEnabled(habilitar);
        this.tableAlterados.setEnabled(habilitar);
    }

    private ReceberPagarBean configuraDataAlteracaoTitulo(ReceberPagarBean bean) {
        if (bean != null && bean.getSituacao() != null) {
            UsuarioVO usuario = new UsuarioVO();
            usuario.setCodigo(Variaveis.login);
            if (bean.getSituacao().equalsIgnoreCase("T")) {
                bean.setUsuarioCartorioCobranca(usuario);
                bean.setDataCartorioCobranca(new Date());
            } else if (bean.getSituacao().equalsIgnoreCase("S")) {
                bean.setUsuarioProtestoCobranca(usuario);
                bean.setDataProtestoCobranca(new Date());
            } else if (bean.getSituacao().equalsIgnoreCase("V")) {
                bean.setUsuarioAvisoCobranca(usuario);
                bean.setDataAvisoCobranca(new Date());
            }
        }
        return bean;
    }

    @Override
    public boolean validaCampos() {
        if (this.modelAlterados.getRowCount() <= 0) {
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 t\u00edtulos alterados.", 2);
            return false;
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600400900");
    }

    public static long getModuloCartorio() {
        return Long.parseLong("0600400901");
    }

    public static long getModuloProtesto() {
        return Long.parseLong("0600400902");
    }

    public static long getModuloReabrir() {
        return Long.parseLong("0600400903");
    }

    public static long getModuloAviso() {
        return Long.parseLong("0600400904");
    }

    public static long getModuloEmitirAviso() {
        return Long.parseLong("0600400905");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }
}

