/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos;

import jalis.comum.Acesso;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.detalhes.Detalhes;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.lancamentos.FrmCadPadraoBeanLancamento;
import jalis.laboratorio.financeiro.lancamentos.ReceberPagar;
import jalis.laboratorio.financeiro.lancamentos.componente.BuscaBeanPreenchido;
import jalis.laboratorio.financeiro.lancamentos.componente.PanelPlanoContaCentroCusto;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.financeiro.ParcelamentoBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.dao.financeiro.ReceberPagarDao;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.financeiro.ReceberPagarVO;
import jalis.service.financeiro.ParcelamentoService;
import jalis.service.financeiro.ReceberPagarService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;

public class ParcelamentoReceberPagar
extends FrmCadPadraoBeanLancamento
implements BuscaBeanPreenchido {
    private static final long ACESSO_ACESSAR_RECEBERPAGAR = Long.parseLong("0600410204");
    private static final long ACESSO_ALTERAR_RECEBERPAGAR = Long.parseLong("0600410205");
    private JPanel panelBusca = null;
    private JPanel panelResumo = null;
    private JPanel panelInfo = null;
    private JPanel panelParcelas = null;
    private JPanel panelLegenda = null;
    private JPanel panelParcelasManuais = null;
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private TTextField textCodigo = new TTextField(8, 1);
    private JButton buttonCodigo = new JButton();
    private JLabel labelData = new JLabel("Data Inicial:");
    private JLabel labelQtdeParc = new JLabel("Qtde. Parcelas:");
    private JLabel labelIntervaloDias = new JLabel("Intervalo (dias):");
    private TTextField textData = new TTextField(10, 4);
    private TTextField textQtdeParc = new TTextField(2, 1);
    private TTextField textIntervaloDias = new TTextField(3, 1);
    private JButton buttonData = new JButton();
    private JCheckBox checkUsarFixa = new JCheckBox("Usar Data Fixa", true);
    private JButton buttonEditarOriginal = new JButton("Editar T\u00edtulo");
    private JButton buttonGerar = new JButton("Gerar Parcelas");
    private JButton buttonRemoverTodasParcelas = new JButton("Remover Todas as Parcelas");
    private JButton buttonAdicionarParcela = new JButton("Adicionar Parcela");
    private JButton buttonRemoverParcela = new JButton("Remover Parcela");
    private JComboBox comboTipoDocumento = new JComboBox<String>(new String[]{Tipos.tipoDocumento("B"), Tipos.tipoDocumento("C"), Tipos.tipoDocumento("A"), Tipos.tipoDocumento("D")});
    private JLabel labelTipoDocumento = new JLabel("Tipo Documento:");
    private JTable tableParcelas = null;
    private JScrollPane scrollParcelas = null;
    private ModeloGridTable modelParcelas = null;
    private JPanel pnlLegenda = new JPanel(new GridBagLayout());
    private DetalhesTituloOriginal detalhesTituloOriginal = new DetalhesTituloOriginal(1);
    private DetalhesParcelas detalhesParcelas = new DetalhesParcelas(1);
    private ReceberPagarBean tituloOriginal = null;
    private ArrayList<ReceberPagarBean> parcelas = new ArrayList();
    private boolean isJanela = false;
    private boolean isParcelamentoOk = false;
    private Window owner = null;

    public ParcelamentoReceberPagar() {
        this.montaTela(false);
        this.isJanela = false;
    }

    public ParcelamentoReceberPagar(ReceberPagarBean original, Window owner) {
        this.isJanela = true;
        this.owner = owner;
        this.montaTela(this.isJanela);
        if (original != null) {
            this.novo();
            this.tituloOriginal = original;
            FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)this.tituloOriginal);
            this.popularTituloOriginal();
            this.controlaCampos();
            this.detalhesTituloOriginal.setSituacao(2);
            this.detalhesTituloOriginal.montaReduzido();
        }
    }

    public void focalizarData() {
        ScreenUtil.requisitarFoco(this.textData);
    }

    public void montaTela(boolean isJanela) {
        this.service = new ParcelamentoService();
        this.setLabelDescricao("Parcelamento de t\u00edtulos a Receber e Pagar");
        this.setLabelFormulario("Parcelamento de receber/pagar");
        this.setIcone(ImagemUtils.carregaImagemJalis("financeiro/parcelamento_receber_pagar.jpg"));
        this.botaoExcluir.setText("Desfazer Parcelamento");
        if (isJanela) {
            this.botaoNovo.setVisible(false);
            this.botaoEditar.setVisible(false);
            this.botaoExcluir.setVisible(false);
            this.botaoFechar.setVisible(false);
        }
        this.painelCentral.setLayout(new GridBagLayout());
        this.panelResumo = new JPanel(new GridBagLayout());
        this.panelResumo.setBorder(BorderFactory.createTitledBorder("T\u00edtulo Original (Resumo)"));
        this.panelResumo.setFocusCycleRoot(false);
        this.panelParcelas = new JPanel(new GridBagLayout());
        this.panelParcelas.setBorder(BorderFactory.createTitledBorder("Parcelas"));
        this.panelParcelas.setFocusCycleRoot(false);
        this.panelBusca = new JPanel(new GridBagLayout());
        this.panelBusca.setFocusCycleRoot(false);
        this.panelInfo = new JPanel(new GridBagLayout());
        this.panelInfo.setBorder(BorderFactory.createTitledBorder(""));
        this.panelInfo.setFocusCycleRoot(false);
        this.panelLegenda = FinanceiroUtil.montaPanelLegenda(this.pnlLegenda);
        this.panelParcelasManuais = new JPanel(new GridBagLayout());
        this.panelParcelasManuais.setBorder(BorderFactory.createTitledBorder(""));
        this.panelParcelasManuais.setFocusCycleRoot(false);
        Dimension d = new Dimension(80, 20);
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setMinimumSize(d);
        d = new Dimension(85, 20);
        this.textData.setPreferredSize(d);
        this.textData.setMinimumSize(d);
        this.comboTipoDocumento.setPreferredSize(d);
        this.comboTipoDocumento.setMinimumSize(d);
        d = new Dimension(40, 20);
        this.textQtdeParc.setPreferredSize(d);
        this.textQtdeParc.setMinimumSize(d);
        this.textIntervaloDias.setPreferredSize(d);
        this.textIntervaloDias.setMinimumSize(d);
        d = new Dimension(20, 20);
        this.buttonCodigo.setPreferredSize(d);
        this.buttonCodigo.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonCodigo);
        this.buttonCodigo.setFocusable(false);
        this.buttonData.setPreferredSize(d);
        this.buttonData.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonData);
        this.buttonData.setFocusable(false);
        this.buttonEditarOriginal.setMargin(new Insets(1, 1, 1, 1));
        this.buttonGerar.setMargin(new Insets(1, 1, 1, 1));
        this.buttonGerar.setFocusable(false);
        this.buttonGerar.setMnemonic('G');
        this.buttonAdicionarParcela.setMargin(new Insets(1, 1, 1, 1));
        this.buttonAdicionarParcela.setFocusable(false);
        this.buttonAdicionarParcela.setMnemonic('A');
        this.buttonAdicionarParcela.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ParcelamentoReceberPagar.this.tituloOriginal != null) {
                    ReceberPagarBean parcela = new ReceberPagarBean();
                    FilialVO filial = new FilialVO();
                    filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                    UsuarioVO usuario = new UsuarioVO();
                    usuario.setCodigo(Variaveis.login);
                    parcela.setFilial(filial);
                    parcela.setDataHora(new Date());
                    parcela.setUsuario(usuario);
                    parcela.setTipo(ParcelamentoReceberPagar.this.tituloOriginal.getTipo());
                    parcela.setTipoCadastro(ParcelamentoReceberPagar.this.tituloOriginal.getTipoCadastro());
                    parcela.setConvenio(ParcelamentoReceberPagar.this.tituloOriginal.getConvenio());
                    parcela.setEntidade(ParcelamentoReceberPagar.this.tituloOriginal.getEntidade());
                    parcela.setPaciente(ParcelamentoReceberPagar.this.tituloOriginal.getPaciente());
                    parcela.setTipoDocumento(ParcelamentoReceberPagar.this.tituloOriginal.getTipoDocumento());
                    parcela.setParcela(ParcelamentoReceberPagar.this.getProximaParcela());
                    parcela.setObservacao("T\u00edtulo gerado por parcelamento - Parcela: " + parcela.getParcela() + ". C\u00f3d. T\u00edt. Original: " + ParcelamentoReceberPagar.this.tituloOriginal.getCodigo() + ", Filial: " + ParcelamentoReceberPagar.this.tituloOriginal.getFilial().getCodigo() + ".");
                    parcela.setNumeroDocumento(ParcelamentoReceberPagar.this.tituloOriginal.getNumeroDocumento());
                    parcela.setValor(0.0);
                    parcela.setValorTotal(0.0);
                    parcela.setSituacao("A");
                    parcela.setInserir(true);
                    if (ParcelamentoReceberPagar.this.parcelas != null) {
                        FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)parcela);
                        ParcelamentoReceberPagar.this.parcelas.add(parcela);
                        ParcelamentoReceberPagar.this.popularParcelas();
                    }
                }
            }
        });
        this.buttonRemoverParcela.setMargin(new Insets(1, 1, 1, 1));
        this.buttonRemoverParcela.setFocusable(false);
        this.buttonRemoverParcela.setMnemonic('R');
        this.buttonRemoverParcela.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ParcelamentoReceberPagar.this.tableParcelas.getSelectedRow();
                if (row >= 0) {
                    ReceberPagarBean auxBean = (ReceberPagarBean)ParcelamentoReceberPagar.this.modelParcelas.getValueAt(row, ParcelamentoReceberPagar.this.modelParcelas.findColumn("Objeto"));
                    auxBean.setRemover(true);
                    ParcelamentoReceberPagar.this.popularParcelas();
                }
            }
        });
        this.buttonRemoverTodasParcelas.setMargin(new Insets(1, 1, 1, 1));
        this.buttonRemoverTodasParcelas.setFocusable(false);
        this.buttonRemoverTodasParcelas.setMnemonic('P');
        this.detalhesTituloOriginal.setFocusable(false);
        this.detalhesParcelas.setFocusable(false);
        this.modelParcelas = new ModeloGridTable(new String[]{"Tipo Doc.", "N\u00fam. Doc.", "Parc.", "Observa\u00e7\u00e3o", "Vencimento", "Vl. Bruto", "Vl. L\u00edquido", "Objeto"}){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                ParcelamentoReceberPagar.this.tableParcelas.removeColumn(ParcelamentoReceberPagar.this.tableParcelas.getColumnModel().getColumn(ParcelamentoReceberPagar.this.tableParcelas.getColumnCount() - 1));
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            public Class getColumnClass(int column) {
                Class returnValue = Object.class;
                if (this.getRowCount() > 0 && column >= 0 && column < this.getColumnCount() && this.getValueAt(0, column) != null) {
                    returnValue = this.getValueAt(0, column).getClass();
                }
                return returnValue;
            }
        };
        this.tableParcelas = new JTable(this.modelParcelas);
        this.modelParcelas.setColumnSize(new int[]{100, 90, 50, 0, 90, 85, 85, 0}, this.tableParcelas);
        this.tableParcelas.getTableHeader().addMouseListener(this.modelParcelas);
        this.tableParcelas.removeColumn(this.tableParcelas.getColumnModel().getColumn(this.tableParcelas.getColumnCount() - 1));
        TituloRenderer rendererTitulo = new TituloRenderer();
        this.tableParcelas.setDefaultRenderer(Object.class, rendererTitulo);
        this.tableParcelas.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 && Acesso.getAcesso(ACESSO_ACESSAR_RECEBERPAGAR)) {
                    ParcelamentoReceberPagar.this.alteraParcelaSelecionada();
                }
            }
        });
        this.tableParcelas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && Acesso.getAcesso(ACESSO_ACESSAR_RECEBERPAGAR)) {
                    ParcelamentoReceberPagar.this.alteraParcelaSelecionada();
                }
            }
        });
        this.scrollParcelas = new JScrollPane(this.tableParcelas);
        this.buttonCodigo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Hashtable hash = Pesquisas.titulosAbertos(Laboratorio.getInstancia(), false);
                    if (hash != null) {
                        ReceberPagarBean titulo = (ReceberPagarBean)new ReceberPagarDao().getBean(Variaveis.filialPadrao, hash.get("rpg_codigo").toString());
                        if (titulo != null) {
                            ParcelamentoReceberPagar.this.tituloOriginal = titulo;
                            FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)ParcelamentoReceberPagar.this.tituloOriginal);
                            ParcelamentoReceberPagar.this.textCodigo.setText(String.valueOf(ParcelamentoReceberPagar.this.tituloOriginal.getCodigo()));
                            ParcelamentoReceberPagar.this.popularTituloOriginal();
                        }
                        ParcelamentoReceberPagar.this.controlaCampos();
                        if (ParcelamentoReceberPagar.this.textData.isEnabled() && ParcelamentoReceberPagar.this.textData.isFocusable()) {
                            ParcelamentoReceberPagar.this.textData.grabFocus();
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(ParcelamentoReceberPagar.this, ex.getMessage(), ex.getStackTrace(), "ParcelamentoReceberPagar: 205");
                }
            }
        });
        this.textCodigo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ParcelamentoReceberPagar.this.buttonCodigo.doClick();
                }
            }
        });
        this.textCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ReceberPagarBean bean;
                if (!Funcoes.textoVazio(ParcelamentoReceberPagar.this.textCodigo) && (bean = ParcelamentoReceberPagar.this.buscaTitulo(ParcelamentoReceberPagar.this.textCodigo.getText())) != null) {
                    ParcelamentoReceberPagar.this.tituloOriginal = bean;
                    FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)ParcelamentoReceberPagar.this.tituloOriginal);
                    ParcelamentoReceberPagar.this.popularTituloOriginal();
                    ParcelamentoReceberPagar.this.controlaCampos();
                    if (ParcelamentoReceberPagar.this.textData.isEnabled() && ParcelamentoReceberPagar.this.textData.isFocusable()) {
                        ParcelamentoReceberPagar.this.textData.grabFocus();
                    }
                }
            }
        });
        this.checkUsarFixa.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ParcelamentoReceberPagar.this.controlaCampos();
            }
        });
        this.textData.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ParcelamentoReceberPagar.this.buttonData.doClick();
                }
            }
        });
        this.buttonData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(ParcelamentoReceberPagar.this.textData, ParcelamentoReceberPagar.this.buttonData, ParcelamentoReceberPagar.this.panelInfo, true);
            }
        });
        this.buttonGerar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParcelamentoReceberPagar.this.gerarParcelas();
            }
        });
        this.buttonRemoverTodasParcelas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < ParcelamentoReceberPagar.this.parcelas.size(); ++i) {
                    ReceberPagarBean auxBean = (ReceberPagarBean)ParcelamentoReceberPagar.this.parcelas.get(i);
                    auxBean.setRemover(true);
                }
                ParcelamentoReceberPagar.this.popularParcelas();
            }
        });
        this.buttonEditarOriginal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Acesso.getAcesso(ACESSO_ACESSAR_RECEBERPAGAR)) {
                    ParcelamentoReceberPagar.this.alteraTituloOriginal();
                }
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        if (!isJanela) {
            this.painelCentral.add((Component)this.panelBusca, c);
        }
        ++c.gridy;
        this.painelCentral.add((Component)this.panelResumo, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        this.painelCentral.add((Component)this.panelParcelas, c);
        ++c.gridy;
        c.fill = 2;
        c.weighty = 0.0;
        this.painelCentral.add((Component)this.detalhesParcelas, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 2;
        c.weighty = 0.0;
        if (!isJanela) {
            this.painelCentral.add((Component)this.panelLegenda, c);
        }
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelCodigo.setLabelFor(this.textCodigo);
        this.labelCodigo.setDisplayedMnemonic('o');
        this.panelBusca.add((Component)this.labelCodigo, c);
        ++c.gridx;
        this.panelBusca.add((Component)this.textCodigo, c);
        ++c.gridx;
        this.panelBusca.add((Component)this.buttonCodigo, c);
        c.weightx = 1.0;
        c.fill = 2;
        this.panelBusca.add((Component)new JPanel(), c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.panelResumo.add((Component)this.detalhesTituloOriginal, c);
        ++c.gridy;
        c.fill = 0;
        c.weightx = 0.0;
        this.buttonEditarOriginal.setMnemonic('T');
        this.panelResumo.add((Component)this.buttonEditarOriginal, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelData.setLabelFor(this.textData);
        this.labelData.setDisplayedMnemonic('I');
        this.panelInfo.add((Component)this.labelData, c);
        ++c.gridx;
        this.panelInfo.add((Component)this.textData, c);
        ++c.gridx;
        this.panelInfo.add((Component)this.buttonData, c);
        ++c.gridx;
        this.panelInfo.add((Component)this.getPanelVazio(20, 20), c);
        ++c.gridx;
        this.labelTipoDocumento.setLabelFor(this.comboTipoDocumento);
        this.labelTipoDocumento.setDisplayedMnemonic('u');
        this.panelInfo.add((Component)this.labelTipoDocumento, c);
        ++c.gridx;
        this.panelInfo.add((Component)this.comboTipoDocumento, c);
        ++c.gridx;
        this.panelInfo.add((Component)this.getPanelVazio(20, 20), c);
        ++c.gridx;
        c.gridwidth = 3;
        this.checkUsarFixa.setMnemonic('x');
        this.panelInfo.add((Component)this.checkUsarFixa, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.labelQtdeParc.setLabelFor(this.textQtdeParc);
        this.labelQtdeParc.setDisplayedMnemonic('Q');
        this.panelInfo.add((Component)this.labelQtdeParc, c);
        ++c.gridx;
        this.panelInfo.add((Component)this.textQtdeParc, c);
        ++c.gridx;
        this.panelInfo.add((Component)this.getPanelVazio(20, 20), c);
        c.gridx += 2;
        this.labelIntervaloDias.setLabelFor(this.textIntervaloDias);
        this.labelIntervaloDias.setDisplayedMnemonic('v');
        this.panelInfo.add((Component)this.labelIntervaloDias, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.panelInfo.add((Component)this.textIntervaloDias, c);
        c.gridx += 2;
        c.gridwidth = 1;
        this.panelInfo.add((Component)this.buttonGerar, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelInfo.add((Component)new JPanel(), c);
        c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelParcelasManuais.add((Component)this.buttonAdicionarParcela, c);
        ++c.gridx;
        this.panelParcelasManuais.add((Component)this.buttonRemoverParcela, c);
        ++c.gridx;
        this.panelParcelasManuais.add((Component)new JLabel("   "), c);
        ++c.gridx;
        this.panelParcelasManuais.add((Component)this.buttonRemoverTodasParcelas, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelParcelasManuais.add((Component)new JLabel(), c);
        c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        ++c.gridy;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(1, 1, 1, 0);
        this.panelParcelas.add((Component)this.panelInfo, c);
        ++c.gridy;
        c.fill = 2;
        c.insets = new Insets(1, 1, 1, 0);
        this.panelParcelas.add((Component)this.panelParcelasManuais, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        this.panelParcelas.add((Component)this.scrollParcelas, c);
        this.panelLegenda = FinanceiroUtil.montaPanelLegenda(this.panelLegenda);
        this.controlaCampos();
    }

    private int getProximaParcela() {
        int maior = -1;
        if (this.parcelas != null) {
            for (int i = 0; i < this.parcelas.size(); ++i) {
                ReceberPagarBean bean = this.parcelas.get(i);
                if (bean != null && bean.isRemover() || bean == null || bean.getParcela() == null || bean.getParcela() <= maior) continue;
                maior = bean.getParcela();
            }
            return maior == -1 ? 1 : maior + 1;
        }
        return 1;
    }

    private void alteraParcelaSelecionada() {
        int row = this.tableParcelas.getSelectedRow();
        if (row >= 0) {
            ReceberPagarBean auxBean = (ReceberPagarBean)this.modelParcelas.getValueAt(row, this.modelParcelas.findColumn("Objeto"));
            int indiceArray = this.parcelas.indexOf(auxBean);
            boolean podeAlterar = true;
            for (int i = 0; i < this.parcelas.size(); ++i) {
                ReceberPagarBean aux = this.parcelas.get(i);
                if (aux.getSituacao().equalsIgnoreCase("A")) continue;
                podeAlterar = false;
                break;
            }
            if ((auxBean = ReceberPagar.novaInstanciaDialog(Laboratorio.getInstancia(), auxBean, "Parcela " + auxBean.getParcela(), podeAlterar && Acesso.getAcesso(ACESSO_ALTERAR_RECEBERPAGAR), 2)) != null) {
                FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)auxBean);
                this.parcelas.set(indiceArray, auxBean);
                auxBean.setAlterar(true);
                if (auxBean.getParcela() == null) {
                    return;
                }
                BigDecimal soma = BigDecimal.ZERO;
                int qtdeParcelasRestantes = 0;
                for (int i = 0; i < this.parcelas.size(); ++i) {
                    ReceberPagarBean parc = this.parcelas.get(i);
                    if (parc.isRemover()) continue;
                    if (parc.getParcela() != null && parc.getParcela() <= auxBean.getParcela()) {
                        soma = soma.add(new BigDecimal(parc.getValor().toString()).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()));
                        continue;
                    }
                    ++qtdeParcelasRestantes;
                }
                BigDecimal restante = new BigDecimal(this.tituloOriginal.getValor().toString()).subtract(soma);
                if (restante.doubleValue() > 0.0 && qtdeParcelasRestantes > 0) {
                    restante = restante.divide(new BigDecimal(String.valueOf(qtdeParcelasRestantes)), ParametrosGerais.getArredondamentoPrecoExame());
                    int resp = Funcoes.mensagem(this, "Deseja atualizar as parcelas seguintes com o valor restante?", 4);
                    if (resp == 0) {
                        for (int i = 0; i < this.parcelas.size(); ++i) {
                            ReceberPagarBean parc = this.parcelas.get(i);
                            if (parc.isRemover() || parc.getParcela() != null && parc.getParcela() <= auxBean.getParcela()) continue;
                            parc.setValor(restante.doubleValue());
                            parc = FinanceiroUtil.calculaValorImpostoSemNota(parc);
                            parc = (ReceberPagarBean)FinanceiroUtil.atualizaTotal((AbstractThreadBean)parc);
                            parc.setAlterar(true);
                        }
                    }
                }
            }
            this.popularParcelas();
        }
    }

    private void gerarParcelas() {
        if (this.tituloOriginal != null) {
            ReceberPagarBean aux;
            if (Funcoes.textoVazio(this.textData)) {
                Funcoes.mensagem(this, "A data inicial deve ser inserida.", 2);
                return;
            }
            if (Funcoes.textoVazio(this.textQtdeParc)) {
                Funcoes.mensagem(this, "A quantidade de parcelas deve ser configurada.", 2);
                return;
            }
            if (Integer.parseInt(this.textQtdeParc.getText()) <= 1) {
                Funcoes.mensagem(this, "A quantidade de parcelas deve ser maior que 1.", 2);
                return;
            }
            if (!this.checkUsarFixa.isSelected()) {
                if (Funcoes.textoVazio(this.textIntervaloDias)) {
                    Funcoes.mensagem(this, "O intervalo de dias deve ser inserido.", 2);
                    return;
                }
            } else {
                this.textIntervaloDias.setText("");
            }
            if (this.modelParcelas != null && this.modelParcelas.getRowCount() > 0 && Funcoes.mensagem(this, "As parcelas geradas anteriormente ser\u00e3o perdidas.\nDeseja gerar novas parcelas?", 4) == 1) {
                return;
            }
            this.limparParcelas();
            for (int i = 0; i < this.parcelas.size(); ++i) {
                ReceberPagarBean aux2 = this.parcelas.get(i);
                aux2.setRemover(true);
            }
            ArrayList<ReceberPagarBean> parcelasAux = null;
            parcelasAux = FinanceiroUtil.gerarParcelas(this.tituloOriginal.getValor(), this.tituloOriginal.getValorTotal(), this.tituloOriginal.getIrrfPercentual(), this.tituloOriginal.getIssPercentual(), this.tituloOriginal.getPisPercentual(), this.tituloOriginal.getCsllPercentual(), this.tituloOriginal.getCofinsPercentual(), this.tituloOriginal.getInssPercentual(), this.tituloOriginal.getIrrfValor(), this.tituloOriginal.getIssValor(), this.tituloOriginal.getPisValor(), this.tituloOriginal.getCsllValor(), this.tituloOriginal.getCofinsValor(), this.tituloOriginal.getInssValor(), this.tituloOriginal.getValorJuro(), this.tituloOriginal.getValorDesconto(), this.tituloOriginal.getValorAcrescimo(), this.tituloOriginal.getValorMulta(), this.tituloOriginal.getTaxa(), this.tituloOriginal.getTipo(), Funcoes.getData("dd/MM/yyyy", this.textData.getText()), Integer.parseInt(this.textQtdeParc.getText()), Funcoes.textoVazio(this.textIntervaloDias.getText()) ? null : Integer.valueOf(Integer.parseInt(this.textIntervaloDias.getText())));
            if (parcelasAux != null) {
                for (int i = 0; i < parcelasAux.size(); ++i) {
                    aux = parcelasAux.get(i);
                    this.parcelas.add(aux);
                }
            }
            for (int i = 0; i < this.parcelas.size(); ++i) {
                aux = this.parcelas.get(i);
                if (aux.isRemover()) continue;
                aux.setDataHora(new Date());
                aux.setCodigoDocumento(this.tituloOriginal.getCodigoDocumento());
                aux.setConvenio(this.tituloOriginal.getConvenio());
                aux.setDataCompetencia(this.tituloOriginal.getDataCompetencia());
                aux.setDataDocumento(this.tituloOriginal.getDataDocumento());
                aux.setDataProcessamento(this.tituloOriginal.getDataProcessamento());
                aux.setEntidade(this.tituloOriginal.getEntidade());
                aux.setFilial(this.tituloOriginal.getFilial());
                aux.setNumeroDocumento(this.tituloOriginal.getNumeroDocumento());
                aux.setObservacao("T\u00edtulo gerado por parcelamento - Parcela: " + aux.getParcela() + ". C\u00f3d. T\u00edt. Original: " + this.tituloOriginal.getCodigo() + ", Filial: " + this.tituloOriginal.getFilial().getCodigo() + ".");
                aux.setPaciente(this.tituloOriginal.getPaciente());
                aux.setSerie(this.tituloOriginal.getSerie());
                aux.setSituacao("A");
                aux.setTipoCadastro(this.tituloOriginal.getTipoCadastro());
                aux.setTipoDocumento(Tipos.getTipoDocumento(this.comboTipoDocumento.getSelectedItem().toString()));
                aux.setTipoJuro(this.tituloOriginal.getTipoJuro());
                aux.setUsuario(this.tituloOriginal.getUsuario());
                aux.setOrigem("R");
                aux.setNotaFiscal(this.tituloOriginal.getNotaFiscal());
                aux.setInserir(true);
                FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)aux);
            }
        } else {
            Funcoes.mensagem(this, "A quantidade de parcelas deve ser configurada.", 2);
            return;
        }
        this.popularParcelas();
    }

    private void limparParcelas() {
        this.popularParcelas();
    }

    private void alteraTituloOriginal() {
        if (this.tituloOriginal != null) {
            ReceberPagarBean aux;
            boolean podeAlterar = true;
            if (this.parcelas != null) {
                for (int i = 0; i < this.parcelas.size(); ++i) {
                    ReceberPagarBean aux2 = this.parcelas.get(i);
                    if (aux2.getSituacao().equalsIgnoreCase("A")) continue;
                    podeAlterar = false;
                    break;
                }
            }
            if ((aux = ReceberPagar.novaInstanciaDialog(Laboratorio.getInstancia(), this.tituloOriginal, "T\u00edtulo Original", podeAlterar && Acesso.getAcesso(ACESSO_ALTERAR_RECEBERPAGAR), 3)) != null) {
                int resposta;
                this.tituloOriginal = aux;
                if (aux.getCamposAlterados().size() > 0) {
                    aux.setAlterar(true);
                }
                FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)this.tituloOriginal);
                if (this.parcelas != null && this.parcelas.size() > 0 && (resposta = Funcoes.mensagem(this, "Deseja atualizar as parcelas?", 4)) == 0) {
                    this.gerarParcelas();
                }
            }
            this.popularTituloOriginal();
        }
    }

    private void popularParcelas() {
        BigDecimal valorBruto = new BigDecimal(0).setScale(2, RoundingMode.HALF_UP);
        BigDecimal valorLiquido = new BigDecimal(0).setScale(2, RoundingMode.HALF_UP);
        int qtdeParcelas = 0;
        if (this.parcelas != null) {
            this.modelParcelas.clear();
            for (int i = 0; i < this.parcelas.size(); ++i) {
                ReceberPagarBean titulo = this.parcelas.get(i);
                if (titulo != null && titulo.isRemover() || titulo == null) continue;
                this.modelParcelas.addLine(new Object[]{titulo.getTipoDocumento() == "" ? "" : Tipos.tipoDocumento(titulo.getTipoDocumento()), titulo.getNumeroDocumento(), titulo.getParcela() + " ", titulo.getObservacao(), Funcoes.formataData("dd/MM/yyyy", titulo.getDataVencimento()), titulo.getValor() == null ? "" : Funcoes.formataDecimal(titulo.getValor()), titulo.getValorTotal() == null ? "" : Funcoes.formataDecimal(titulo.getValorTotal()), titulo});
                valorBruto = valorBruto.add(new BigDecimal(titulo.getValor()).setScale(2, RoundingMode.HALF_UP));
                valorLiquido = valorLiquido.add(new BigDecimal(titulo.getValorTotal()).setScale(2, RoundingMode.HALF_UP));
                ++qtdeParcelas;
            }
            this.detalhesParcelas.setValores(valorBruto.doubleValue(), valorLiquido.doubleValue(), qtdeParcelas, this.tituloOriginal == null ? 0.0 : this.tituloOriginal.getValor(), this.tituloOriginal == null ? 0.0 : this.tituloOriginal.getValorTotal());
        }
    }

    private ReceberPagarBean buscaTitulo(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            return null;
        }
        try {
            ReceberPagarVO recpag = (ReceberPagarVO)new ReceberPagarService().getVO(Variaveis.filialPadrao, codigo);
            if (recpag != null) {
                ReceberPagarBean titulo = (ReceberPagarBean)new ReceberPagarService().voToBean(recpag, ReceberPagarBean.class);
                if (this.getStatus() == 2 && !this.validaTitulo(titulo)) {
                    if (this.textCodigo.isFocusable() && this.textCodigo.isEnabled()) {
                        this.textCodigo.selectAll();
                        this.textCodigo.grabFocus();
                    }
                    return null;
                }
                return titulo;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ParcelamentoReceberPagar:buscaTitulo:370");
        }
        return null;
    }

    private boolean validaTitulo(ReceberPagarBean bean) {
        if (bean == null) {
            return false;
        }
        if (!bean.getSituacao().equalsIgnoreCase("A")) {
            Funcoes.mensagem(this, "A situa\u00e7\u00e3o do t\u00edtulo \u00e9: \"" + Tipos.tipoSituacaoReceberPagar(bean.getSituacao()) + "\".\nSomente t\u00edtulos com situa\u00e7\u00e3o ABERTO podem ser parcelados.", 2);
            return false;
        }
        return true;
    }

    private void popularTituloOriginal() {
        if (this.tituloOriginal != null) {
            String cadastro = "";
            if (!Funcoes.textoVazio(this.tituloOriginal.getTipoCadastro())) {
                if (this.tituloOriginal.getTipoCadastro().equalsIgnoreCase("P")) {
                    if (this.tituloOriginal.getPaciente() != null) {
                        cadastro = this.tituloOriginal.getPaciente().getNome();
                    }
                } else if (this.tituloOriginal.getTipoCadastro().equalsIgnoreCase("O")) {
                    if (this.tituloOriginal.getConvenio() != null) {
                        cadastro = this.tituloOriginal.getConvenio().getFantasia();
                    }
                } else if (this.tituloOriginal.getEntidade() != null) {
                    cadastro = this.tituloOriginal.getEntidade().getRazaoSocial();
                }
            }
            this.detalhesTituloOriginal.setValores(this.tituloOriginal.getCodigo(), Tipos.tipoDocumento(this.tituloOriginal.getTipoDocumento()), this.tituloOriginal.getNumeroDocumento(), this.tituloOriginal.getDataVencimento(), this.tituloOriginal.getValor(), this.tituloOriginal.getValorTotal(), Tipos.tipoCadastro(this.tituloOriginal.getTipoCadastro()), cadastro, Tipos.tipoReceberPagar(this.tituloOriginal.getTipo()));
        } else {
            this.detalhesTituloOriginal.limparDetalhes();
        }
        this.popularParcelas();
    }

    private JPanel getPanelVazio(int width, int height) {
        JPanel aux = new JPanel();
        Dimension d = new Dimension(width, height);
        aux.setPreferredSize(d);
        aux.setMaximumSize(d);
        return aux;
    }

    @Override
    protected void controlaCampos() {
        boolean haParcelas = false;
        for (ReceberPagarBean aux : this.parcelas) {
            if (aux.isRemover()) continue;
            haParcelas = true;
            break;
        }
        this.textCodigo.setEnabled(this.getStatus() == 2 && !haParcelas && this.tituloOriginal == null);
        this.buttonCodigo.setEnabled(this.getStatus() == 2 && !haParcelas && this.tituloOriginal == null);
        this.checkUsarFixa.setEnabled((this.getStatus() == 2 || this.getStatus() == 3) && this.tituloOriginal != null);
        this.textData.setEnabled((this.getStatus() == 2 || this.getStatus() == 3) && this.tituloOriginal != null);
        this.textQtdeParc.setEnabled((this.getStatus() == 2 || this.getStatus() == 3) && this.tituloOriginal != null);
        this.textIntervaloDias.setEnabled((this.getStatus() == 2 || this.getStatus() == 3) && this.tituloOriginal != null && !this.checkUsarFixa.isSelected());
        this.buttonData.setEnabled((this.getStatus() == 2 || this.getStatus() == 3) && this.tituloOriginal != null);
        this.buttonGerar.setEnabled((this.getStatus() == 2 || this.getStatus() == 3) && this.tituloOriginal != null);
        this.buttonRemoverTodasParcelas.setEnabled((this.getStatus() == 2 || this.getStatus() == 3) && this.tituloOriginal != null);
        this.comboTipoDocumento.setEnabled((this.getStatus() == 2 || this.getStatus() == 3) && this.tituloOriginal != null);
        this.buttonAdicionarParcela.setEnabled((this.getStatus() == 2 || this.getStatus() == 3) && this.tituloOriginal != null);
        this.buttonRemoverParcela.setEnabled((this.getStatus() == 2 || this.getStatus() == 3) && this.tituloOriginal != null);
        this.buttonEditarOriginal.setEnabled((this.getStatus() == 2 || this.getStatus() == 3) && this.tituloOriginal != null && Acesso.getAcesso(ACESSO_ACESSAR_RECEBERPAGAR));
        this.labelIntervaloDias.setVisible(!this.checkUsarFixa.isSelected());
        this.textIntervaloDias.setVisible(!this.checkUsarFixa.isSelected());
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        ParcelamentoBean bean = new ParcelamentoBean();
        bean.setTituloOriginal(this.tituloOriginal);
        if (this.parcelas != null) {
            HashSet<ReceberPagarBean> hash = new HashSet<ReceberPagarBean>();
            for (int i = 0; i < this.parcelas.size(); ++i) {
                hash.add(this.parcelas.get(i));
            }
            bean.setParcelas(hash);
        }
        return bean;
    }

    @Override
    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    protected void limparCampos() {
        this.textCodigo.setText("");
        this.checkUsarFixa.setSelected(true);
        this.textData.setText("");
        this.textQtdeParc.setText("");
        this.textIntervaloDias.setText("");
        this.comboTipoDocumento.setSelectedIndex(0);
        this.textData.setText("");
        this.comboTipoDocumento.setSelectedIndex(0);
        this.checkUsarFixa.setSelected(true);
        this.textQtdeParc.setText("");
        this.textIntervaloDias.setText("");
        this.tituloOriginal = null;
        this.popularTituloOriginal();
        this.parcelas.clear();
        this.limparParcelas();
        this.controlaCampos();
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        Hashtable titulos = Pesquisas.tituloParcelado(Laboratorio.getInstancia());
        ParcelamentoBean bean = null;
        if (titulos != null) {
            try {
                bean = (ParcelamentoBean)new ParcelamentoService().get(Variaveis.filialPadrao, String.valueOf(titulos.get("rpg_codigo")));
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar o parcelamento.", e.getStackTrace());
            }
        }
        return bean;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        if (bean == null) {
            return;
        }
        ParcelamentoBean parcBean = (ParcelamentoBean)bean;
        if (parcBean.getTituloOriginal() == null) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "O Parcelamento n\u00e3o pode ser carregado, pois, n\u00e3o possui t\u00edtulo original.", null);
            return;
        }
        if (parcBean.getParcelas() == null || parcBean.getParcelas().size() <= 0) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "O Parcelamento n\u00e3o pode ser carregado, pois, n\u00e3o possui parcelas.", null);
            return;
        }
        this.tituloOriginal = parcBean.getTituloOriginal();
        FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)this.tituloOriginal);
        for (ReceberPagarBean titulo : parcBean.getParcelas()) {
            if (titulo.getParcela() != null && titulo.getParcela() == 1) {
                this.textData.setText(Funcoes.formataData(titulo.getDataVencimento()));
            }
            FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)titulo);
            this.parcelas.add(titulo);
        }
        this.textCodigo.setText(parcBean.getTituloOriginal().getCodigo() == null ? "" : String.valueOf(parcBean.getTituloOriginal().getCodigo()));
        this.textQtdeParc.setText(String.valueOf(this.parcelas.size()));
        this.popularTituloOriginal();
        this.popularParcelas();
    }

    @Override
    public boolean validaCampos() {
        int i;
        int resp;
        int i2;
        int resp2;
        if (this.tituloOriginal == null) {
            Funcoes.mensagem(this, "O Parcelamento n\u00e3o possui t\u00edtulo original.", 2);
            return false;
        }
        if (this.parcelas == null || this.parcelas.size() <= 0) {
            Funcoes.mensagem(this, "O Parcelamento n\u00e3o possui parcelas", 2);
            return false;
        }
        if ((this.tituloOriginal.isPlanoContaErrado() || this.tituloOriginal.isPlanoContaNaoConfigurado()) && (resp2 = Funcoes.mensagem(this, "O Plano de Contas do t\u00edtulo Original est\u00e1 errado ou n\u00e3o configurado.\nDeseja continuar?", 4)) == 1) {
            return false;
        }
        if ((this.tituloOriginal.isCentroCustoErrado() || this.tituloOriginal.isCentroCustoNaoConfigurado()) && (resp2 = Funcoes.mensagem(this, "O Centro de Custo do t\u00edtulo Original est\u00e1 errado ou n\u00e3o configurado.\nDeseja continuar?", 4)) == 1) {
            return false;
        }
        for (i2 = 0; i2 < this.parcelas.size(); ++i2) {
            if (this.parcelas.get(i2).isRemover() || !this.parcelas.get(i2).isPlanoContaErrado() && !this.parcelas.get(i2).isPlanoContaNaoConfigurado()) continue;
            resp = Funcoes.mensagem(this, "H\u00e1 alguma parcela com Plano de Contas errado ou n\u00e3o configurado.\nDeseja continuar?", 4);
            if (resp != 1) break;
            return false;
        }
        for (i2 = 0; i2 < this.parcelas.size(); ++i2) {
            if (this.parcelas.get(i2).isRemover() || !this.parcelas.get(i2).isCentroCustoErrado() && !this.parcelas.get(i2).isCentroCustoNaoConfigurado()) continue;
            resp = Funcoes.mensagem(this, "H\u00e1 alguma parcela com Centro de Custo errado ou n\u00e3o configurado.\nDeseja continuar?", 4);
            if (resp != 1) break;
            return false;
        }
        int maiorParcela = this.getProximaParcela() - 1;
        int qtdeParcelas = 0;
        if (maiorParcela > 0) {
            for (i = 1; i < maiorParcela; ++i) {
                boolean encontrado = false;
                for (int j = 0; j < this.parcelas.size(); ++j) {
                    ReceberPagarBean bean = this.parcelas.get(j);
                    if (j == 0) {
                        ++qtdeParcelas;
                    }
                    if (bean == null || bean.isRemover()) continue;
                    if (bean.getParcela() <= 0) {
                        Funcoes.mensagem(this, "H\u00e1 uma parcela com o n\u00famero: " + bean.getParcela() + ".\nO n\u00famero das parcelas deve ser maior que zero.", 2);
                        return false;
                    }
                    if (bean.getParcela() != i) continue;
                    encontrado = true;
                    break;
                }
                if (encontrado) continue;
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 parcela com o n\u00famero: " + i + ".", 2);
                return false;
            }
        }
        if (maiorParcela <= qtdeParcelas) {
            Funcoes.mensagem(this, "H\u00e1 parcelas com numera\u00e7\u00e3o repetida.", 2);
            return false;
        }
        for (i = 0; i < this.parcelas.size(); ++i) {
            String campo = null;
            ReceberPagarBean bean = this.parcelas.get(i);
            if (bean.isRemover() || (campo = new ReceberPagarService().validaCamposPreenchidos(bean)) == null) continue;
            Funcoes.mensagem(this, "O campo '" + campo + "' n\u00e3o foi preenchido.\nParcela: " + bean.getParcela() + ".", 2);
            return false;
        }
        BigDecimal valorTotal = new BigDecimal(0).setScale(2, RoundingMode.HALF_UP);
        for (int i3 = 0; i3 < this.parcelas.size(); ++i3) {
            ReceberPagarBean bean = this.parcelas.get(i3);
            if (bean.isRemover()) continue;
            valorTotal = valorTotal.add(new BigDecimal(bean.getValorTotal()).setScale(2, RoundingMode.HALF_UP));
        }
        return this.tituloOriginal.getValorTotal().doubleValue() == valorTotal.doubleValue() || Funcoes.mensagem(this, "O somat\u00f3rio dos valores l\u00edquidos das parcelas \u00e9 diferente do valor l\u00edquido do t\u00edtulo original.\nConfirma a cria\u00e7\u00e3o das novas parcelas com os valores diferentes?", 4) != 1;
    }

    @Override
    public void salvar(boolean limparCampos) {
        AbstractThreadBean bean;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                if (this.getStatus() == 2) {
                    new ParcelamentoService().insert(bean, Variaveis.filialPadrao, this.getCopiaFiliais());
                } else if (this.getStatus() == 3) {
                    new ParcelamentoService().update(bean, Variaveis.filialPadrao, this.getCopiaFiliais());
                }
                if (!this.isJanela) {
                    if (limparCampos) {
                        this.limparCampos();
                        this.setStatus(1);
                        this.controlaCampos();
                    }
                } else {
                    this.isParcelamentoOk = true;
                    this.owner.setVisible(false);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "ParcelamentoReceberPagar:salvar:894");
            }
        }
    }

    @Override
    @Deprecated
    public AbstractThreadBean buscaBeanPreenchido(PanelPlanoContaCentroCusto source) {
        return null;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600410200");
    }

    @Override
    public void novo() {
        super.novo();
        if (this.textCodigo.isFocusable()) {
            this.textCodigo.grabFocus();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        AbstractThreadBean bean = this.pesquisar();
        if (bean != null) {
            ReceberPagarBean beanAux2 = null;
            if (((ParcelamentoBean)bean).getParcelas() != null) {
                for (ReceberPagarBean beanAux2 : ((ParcelamentoBean)bean).getParcelas()) {
                    if (beanAux2 == null || beanAux2.getSituacao() == null || beanAux2.getSituacao().equalsIgnoreCase("A")) continue;
                    Funcoes.mensagem(this, "A situa\u00e7\u00e3o da Parcela " + beanAux2.getParcela() + " \u00e9: \"" + Tipos.tipoSituacaoReceberPagar(beanAux2.getSituacao()) + "\".\nO Parcelamento n\u00e3o pode ser alterado.", 5);
                    this.setStatus(5);
                }
                this.setStatus(3);
            }
            this.preencherCampos(bean);
            this.controlaCampos();
        }
    }

    @Override
    public void excluir() {
        final ParcelamentoBean bean = (ParcelamentoBean)this.pesquisar();
        if (bean != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ParcelamentoReceberPagar.this.preencherCampos(bean);
                    if (Funcoes.mensagem(ParcelamentoReceberPagar.this, "Deseja desfazer o parcelamento?", 4) == 0) {
                        try {
                            new ParcelamentoService().delete(bean, Variaveis.filialPadrao, ParcelamentoReceberPagar.this.getCopiaFiliais());
                        }
                        catch (Exception e) {
                            ErrorLogger.mostraMensagem(ParcelamentoReceberPagar.this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "ParcelamentoReceberPagar:excluir:1149");
                        }
                    }
                    ParcelamentoReceberPagar.this.limparCampos();
                }
            });
        }
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(ParcelamentoReceberPagar.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0600410201"));
        this.setModuloEdita(Long.parseLong("0600410202"));
        this.setModuloApaga(Long.parseLong("0600410203"));
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    @Override
    public void cancelar() {
        super.cancelar();
        this.isParcelamentoOk = false;
        if (this.isJanela) {
            this.owner.setVisible(false);
        }
    }

    public boolean isOk() {
        return this.isParcelamentoOk;
    }

    public ArrayList<ReceberPagarBean> getParcelas() {
        return this.parcelas;
    }

    public ReceberPagarBean getTituloOriginal() {
        return this.tituloOriginal;
    }

    class TituloRenderer
    extends DefaultTableCellRenderer {
        @Override
        public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            ReceberPagarBean b;
            Component c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            this.setValue(value);
            if (selected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (row < ParcelamentoReceberPagar.this.parcelas.size() && ParcelamentoReceberPagar.this.parcelas.get(row) != null && !(b = (ReceberPagarBean)ParcelamentoReceberPagar.this.modelParcelas.getValueAt(row, ParcelamentoReceberPagar.this.modelParcelas.getColumnCount() - 1)).isRemover()) {
                if (b.isPlanoContaErrado() && b.isCentroCustoErrado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_CENTROCUSTO_ERRADO);
                } else if (b.isPlanoContaErrado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_ERRADO);
                } else if (b.isCentroCustoErrado()) {
                    c.setBackground(FinanceiroUtil.COR_CENTROCUSTO_ERRADO);
                } else if (b.isPlanoContaNaoConfigurado() && b.isCentroCustoNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_CENTROCUSTO_NAO_CONFIGURADO);
                } else if (b.isPlanoContaNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_NAO_CONFIGURADO);
                } else if (b.isCentroCustoNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_CENTROCUSTO_NAO_CONFIGURADO);
                }
                if (selected && c.getBackground() != table.getSelectionBackground()) {
                    c.setBackground(ScreenUtil.escurecerCor(c.getBackground(), 30));
                }
            }
            if (focused) {
                Border border = selected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.focusCellHighlightBorder");
                ((JComponent)c).setBorder(border);
                if (!selected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        c.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        c.setBackground(col);
                    }
                }
            } else {
                ((JComponent)c).setBorder(noFocusBorder);
            }
            return c;
        }
    }

    private class DetalhesParcelas
    extends Detalhes {
        private Double valorBruto;
        private Double valorLiquido;
        private int qtdeParcelas;
        private Double valorBrutoOriginal;
        private Double valorLiquidoOriginal;

        public DetalhesParcelas(int situacao) {
            super(situacao);
            this.valorBruto = new Double(0.0);
            this.valorLiquido = new Double(0.0);
            this.qtdeParcelas = 0;
            this.valorBrutoOriginal = new Double(0.0);
            this.valorLiquidoOriginal = new Double(0.0);
            this.valorBruto = new Double(0.0);
            this.valorLiquido = new Double(0.0);
            this.qtdeParcelas = 0;
            this.valorBrutoOriginal = new Double(0.0);
            this.valorLiquidoOriginal = new Double(0.0);
            this.setFont(this.getFont().deriveFont(11.0f));
            this.setBotaoExpandirVisible(false);
        }

        public void setValores(Double valorBruto, Double valorLiquido, int qtdeParcelas, Double valorBrutoOriginal, Double valorLiquidoOriginal) {
            this.valorBruto = valorBruto;
            this.valorLiquido = valorLiquido;
            this.qtdeParcelas = qtdeParcelas;
            this.valorBrutoOriginal = valorBrutoOriginal;
            this.valorLiquidoOriginal = valorLiquidoOriginal;
            this.atualizarDados();
        }

        @Override
        protected void atualizarDados() {
            StringBuilder html = new StringBuilder();
            Double valorBrutoRestante = (this.valorBrutoOriginal == null ? 0.0 : this.valorBrutoOriginal) - (this.valorBruto == null ? 0.0 : this.valorBruto);
            Double valorLiquidoRestante = (this.valorLiquidoOriginal == null ? 0.0 : this.valorLiquidoOriginal) - (this.valorLiquido == null ? 0.0 : this.valorLiquido);
            html.append("<html>");
            html.append("<table>");
            html.append("<font size=20>");
            html.append("<tr>");
            html.append("<td><b>Qtde. Parc.:").append("</b></td>");
            html.append("<td align=\"right\" width=20>").append(this.qtdeParcelas).append("</td>");
            html.append("<td width=15>-</td>");
            html.append("<td><b>Valor Bruto Parc.:").append("</b></td>");
            html.append("<td align=\"right\" width=80>").append(this.valorBruto == null ? "" : Funcoes.formataDecimal("0.00", this.valorBruto)).append("</td>");
            if (valorBrutoRestante > 0.0) {
                html.append("<td align=\"center\" width=80>").append("(").append(valorBrutoRestante == null ? "" : Funcoes.formataDecimal("0.00", valorBrutoRestante)).append(") restando").append("</td>");
            } else if (valorBrutoRestante < 0.0) {
                html.append("<td align=\"center\" width=80>").append("(").append(valorBrutoRestante == null ? "" : Funcoes.formataDecimal("0.00", valorBrutoRestante * -1.0)).append(") sobrando").append("</td>");
            }
            html.append("<td width=15>-</td>");
            html.append("<td><b>Valor L\u00edquido Parc.:").append("</b></td>");
            html.append("<td align=\"right\" width=80>").append(this.valorLiquido == null ? "" : Funcoes.formataDecimal("0.00", this.valorLiquido)).append("</td>");
            if (valorLiquidoRestante > 0.0) {
                html.append("<td align=\"center\" width=80>").append("(").append(valorLiquidoRestante == null ? "" : Funcoes.formataDecimal("0.00", valorLiquidoRestante)).append(") restando").append("</td>");
            } else if (valorLiquidoRestante < 0.0) {
                html.append("<td align=\"center\" width=80>").append("(").append(valorLiquidoRestante == null ? "" : Funcoes.formataDecimal("0.00", valorLiquidoRestante * -1.0)).append(") sobrando").append("</td>");
            }
            html.append("</tr>");
            html.append("</font>");
            html.append("</table>");
            html.append("</html>");
            this.setDetalhes(html.toString());
            this.repaint();
        }
    }

    private class DetalhesTituloOriginal
    extends Detalhes {
        private Integer codigo;
        private String tipoDocumento;
        private String numeroDocumento;
        private Date dataVencimento;
        private Double valorBruto;
        private Double valorLiquido;
        private String tipoCadastro;
        private String cadastro;
        private String tipo;

        public DetalhesTituloOriginal(int situacao) {
            super(situacao, 11);
            this.codigo = 0;
            this.tipoDocumento = "";
            this.numeroDocumento = "";
            this.dataVencimento = new Date();
            this.valorBruto = new Double(0.0);
            this.valorLiquido = new Double(0.0);
            this.tipoCadastro = "";
            this.cadastro = "";
            this.tipo = "";
            this.codigo = 0;
            this.tipoDocumento = "";
            this.numeroDocumento = "";
            this.dataVencimento = new Date();
            this.valorBruto = new Double(0.0);
            this.valorLiquido = new Double(0.0);
            this.tipoCadastro = "";
            this.cadastro = "";
            this.tipo = "";
            this.setFont(this.getFont().deriveFont(11.0f));
        }

        public void setValores(Integer codigo, String tipoDocumento, String numeroDocumento, Date dataVencimento, Double valorBruto, Double valorLiquido, String tipoCadastro, String cadastro, String tipo) {
            this.codigo = codigo;
            this.tipoDocumento = tipoDocumento;
            this.numeroDocumento = numeroDocumento;
            this.dataVencimento = dataVencimento;
            this.valorBruto = valorBruto;
            this.valorLiquido = valorLiquido;
            this.tipoCadastro = tipoCadastro;
            this.cadastro = cadastro;
            this.tipo = tipo;
            this.atualizarDados();
        }

        @Override
        protected void atualizarDados() {
            StringBuilder html = new StringBuilder();
            html.append("<html>");
            html.append("<table>");
            html.append("<font size=20>");
            if (this.getSituacao() == 1) {
                html.append("<tr>");
                html.append("<td><b>C\u00f3digo: ").append("</b></td>");
                html.append("<td align=\"right\" width=85>").append(this.codigo == null ? "---" : this.codigo).append("</td>");
                html.append("<td width=30>-</td>");
                html.append("<td><b>Tipo: ").append("</b></td>");
                html.append("<td width=85>").append(this.tipo == null ? "" : this.tipo).append("</td>");
                html.append("<td width=30>-</td>");
                html.append("<td><b>Vl. Bruto: ").append("</b></td>");
                html.append("<td align=\"right\" width=70>").append(this.valorBruto == null ? "" : Funcoes.formataDecimal("0.00", this.valorBruto)).append("</td>");
                html.append("</tr>");
                html.append("<tr>");
                html.append("<td><b>Dt. Vencto.: ").append("</b></td>");
                html.append("<td width=85>").append(this.dataVencimento == null ? "" : Funcoes.formataData("dd/MM/yyyy", this.dataVencimento)).append("</td>");
                html.append("<td width=30>-</td>");
                html.append("<td><b>N\u00fam. Doc.: ").append("</b></td>");
                html.append("<td width=85>").append(this.numeroDocumento == null ? "" : this.numeroDocumento).append("</td>");
                html.append("<td width=30>-</td>");
                html.append("<td><b>Vl. L\u00edquido: ").append("</b></td>");
                html.append("<td align=\"right\" width=70>").append(this.valorLiquido == null ? "" : Funcoes.formataDecimal("0.00", this.valorLiquido)).append("</td>");
                html.append("</tr>");
                html.append("<tr>");
                html.append("<td><b>Tipo Cadastro: ").append("</b></td>");
                html.append("<td width=85>").append(this.tipoCadastro == null ? "" : this.tipoCadastro).append("</td>");
                html.append("<td width=30>-</td>");
                html.append("<td><b>Cadastro: ").append("</b></td>");
                html.append("<td width=155>").append(this.cadastro == null ? "" : this.cadastro).append("</td>");
                html.append("<td width=30>-</td>");
                html.append("<td><b>Tipo Doc.: ").append("</b></td>");
                html.append("<td width=85>").append(this.tipoDocumento == null ? "" : this.tipoDocumento).append("</td>");
                html.append("</tr>");
            } else {
                html.append("<tr>");
                html.append("<td><b>C\u00f3digo: ").append("</b></td>");
                html.append("<td align=\"right\" width=45>").append(this.codigo == null ? "---" : this.codigo).append("</td>");
                html.append("<td width=20>-</td>");
                html.append("<td><b>Cadastro: ").append("</b></td>");
                html.append("<td width=130>").append(this.cadastro == null ? "" : this.cadastro).append("</td>");
                html.append("<td width=20>-</td>");
                html.append("<td><b>Vl. Bruto: ").append("</b></td>");
                html.append("<td align=\"right\" width=70>").append(this.valorBruto == null ? "" : Funcoes.formataDecimal("0.00", this.valorBruto)).append("</td>");
                html.append("<td width=20>-</td>");
                html.append("<td><b>Vl. L\u00edquido: ").append("</b></td>");
                html.append("<td align=\"right\" width=70>").append(this.valorLiquido == null ? "" : Funcoes.formataDecimal("0.00", this.valorLiquido)).append("</td>");
                html.append("</tr>");
            }
            html.append("</font>");
            html.append("</table>");
            html.append("</html>");
            this.setDetalhes(html.toString());
            this.repaint();
        }

        public void limparDetalhes() {
            this.setValores(null, null, null, null, null, null, null, null, null);
        }
    }
}

