/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.lancamentos.SolicitarDataConciliacao;
import jalis.laboratorio.financeiro.lancamentos.componente.BuscaBeanPreenchido;
import jalis.laboratorio.financeiro.lancamentos.componente.PanelPlanoContaCentroCusto;
import jalis.laboratorio.financeiro.util.TiposApropriacao;
import jalis.laboratorio.util.BandeirasCartoes;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.financeiro.ContaCorrenteBean;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.model.dao.cadastro.financeiro.ContaCorrenteDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.HistoricoPadraoVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.financeiro.ContaCorrenteVO;
import jalis.model.vo.financeiro.LancamentoVO;
import jalis.service.cadastro.auxiliares.HistoricoPadraoService;
import jalis.service.cadastro.financeiro.CentroCustoService;
import jalis.service.cadastro.financeiro.ContaCorrenteService;
import jalis.service.cadastro.financeiro.PlanoContaService;
import jalis.service.financeiro.LancamentoService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class Lancamento
extends FrmCadPadraoBean
implements BuscaBeanPreenchido {
    private static final long ALTERAR_DATA_CONCILIACAO = Long.parseLong("0600400104");
    private static final long ACESSO_VISUALIZAR_PLANOCONTA_CENTROCUSTO = Long.parseLong("0600400105");
    private static final long ACESSO_ALTERAR_PLANOCONTAS = Long.parseLong("0600400106");
    private static final long ACESSO_ALTERAR_CENTROSCUSTO = Long.parseLong("0600400107");
    private static final long ACESSO_PROIBIR_SALVAR_SEM_PLANO_CONTAS = Long.parseLong("0600400108");
    private static final long ACESSO_PROIBIR_SALVAR_SEM_CENTRO_CUSTO = Long.parseLong("0600400109");
    private static final long ACESSO_NAO_ALTERAR_CONTA_CORRENTE = Long.parseLong("0600400110");
    private static final long ACESSO_SALVAR_CONCILIADO = Long.parseLong("0600400111");
    private JButton buttonSalvarConciliar = ComponenteFactory.novoJButton("Salvar e conciliar \u25bc", 'v', e -> this.abrirSalvarConciliar());
    private JPopupMenu menuConciliar = new JPopupMenu();
    private JMenuItem itemConciliarContaAtual = ComponenteFactory.novoJMenuItem(this.menuConciliar, this.getDescricaoConciliarAtual(), e -> this.conciliarAtual());
    private JMenuItem itemConciliarContaDiferente = ComponenteFactory.novoJMenuItem(this.menuConciliar, "Conciliar em conta diferente", e -> this.conciliarDiferente());
    private JLabel lblValorTotal = new JLabel("Valor Total:");
    private JLabel lblCodigo = new JLabel("C\u00f3digo:");
    private JLabel lblTipo = new JLabel("Tipo:");
    private JLabel lblValor = new JLabel("Valor:");
    private JLabel lblBanco = new JLabel("Banco:");
    private JLabel lblAgencia = new JLabel("Ag\u00eancia:");
    private JLabel lblDocumento = new JLabel("Documento:");
    private JLabel lblObservacao = new JLabel("Observa\u00e7\u00e3o:");
    private JLabel lblTipoDocumento = new JLabel("Tipo Documento:");
    private JLabel lblTipoPagamento = new JLabel("Tipo Pagamento:");
    private JLabel lblContaCorrente = new JLabel("Conta Corrente:");
    private JLabel lblNumeroCheque = new JLabel("Cheque:");
    private JLabel lblValidadeCartao = new JLabel("Validade:");
    private JLabel lblNumeroCartao = new JLabel("N\u00famero:");
    private JLabel lblCartaoCredito = new JLabel("Bandeira:");
    private JLabel lblContaCheque = new JLabel("Conta:");
    private JLabel labelAutDebito = new JLabel("C\u00f3digo Autoriza\u00e7\u00e3o:");
    private JLabel labelPromissoria = new JLabel("C\u00f3digo Promiss\u00f3ria:");
    private JLabel labelNomeDescFolha = new JLabel("Nome:");
    private JLabel labelSetorDescFolha = new JLabel("Setor:");
    private JLabel labelAutorizadoDescFolha = new JLabel("Autorizado por:");
    private JLabel lblDataVencimento = new JLabel("Vencimento:");
    private JLabel lblDataCompetencia = new JLabel("Compet\u00eancia:");
    private JLabel lblMulta = new JLabel("Multa:");
    private JLabel lblJuro = new JLabel("Juro:");
    private JLabel lblTipoJuro = new JLabel("Tipo Juro:");
    private JLabel lblAcrescimo = new JLabel("Acr\u00e9scimo:");
    private JLabel lblDesconto = new JLabel("Desconto:");
    private JLabel lblCancelamento = new JLabel("");
    private JLabel lblHistorico = new JLabel("Hist\u00f3rico:");
    private TTextField textCodigo = new TTextField(10, 1);
    private JComboBox<String> cbxTipo = new JComboBox<String>(new String[]{Tipos.tipoLancamentoCaixa("C"), Tipos.tipoLancamentoCaixa("D")});
    private JLabel lblVlrDataHora = new JLabel();
    private JLabel labelValorTotal = new JLabel("", 4);
    private TTextField textValor = new TTextField(10, 2, 2);
    private TTextField textBanco = new TTextField(3, 1);
    private TTextField textAgencia = new TTextField(10, 3);
    private TTextField textDocumento = new TTextField(50, 3);
    private TTextField textAutDebito = new TTextField(50, 3);
    private TTextField textPromissoria = new TTextField(50, 3);
    private TTextField textNomeDescFolha = new TTextField(80, 3);
    private TTextField textSetorDescFolha = new TTextField(80, 3);
    private TTextField textAutorizadoDescFolha = new TTextField(80, 3);
    private JTextArea textObservacao = new JTextArea(new TTextAreaDocument(500));
    private JScrollPane scrObservacao = new JScrollPane(this.textObservacao);
    private JComboBox<String> cbxTipoDocumento = new JComboBox<String>(new String[]{Tipos.tipoDocumento("B"), Tipos.tipoDocumento("D"), Tipos.tipoDocumento("C"), Tipos.tipoDocumento("A")});
    private JComboBox<String> cbxTipoPagamento = new JComboBox<String>(new String[]{Tipos.tipoPagamento("D"), Tipos.tipoPagamento("H"), Tipos.tipoPagamento("I"), Tipos.tipoPagamento("O"), Tipos.tipoPagamento("P"), Tipos.tipoPagamento("A"), Tipos.tipoPagamento("T"), Tipos.tipoPagamento("B"), Tipos.tipoPagamento("E"), Tipos.tipoPagamento("Z"), Tipos.tipoPagamento("U"), Tipos.tipoPagamento("N"), Tipos.tipoPagamento("F"), Tipos.tipoPagamento("S"), Tipos.tipoPagamento("W"), Tipos.tipoPagamento("Y")});
    private TTextField textCodigoContaCorrente = new TTextField(5, 1);
    private TTextField textDescricaoContaCorrente = new TTextField();
    private JButton buttonBuscaContaCorrente = new JButton();
    private TTextField textNumeroCheque = new TTextField(20, 3);
    private TTextField textValidadeCartao = new TTextField(10, 4);
    private JButton buttonDataValidadeCartao = new JButton();
    private TTextField textNumeroCartao = new TTextField(16, 3);
    private JComboBox<BandeirasCartoes> cbxCartaoCredito = new JComboBox();
    private TTextField textContaCheque = new TTextField(20, 3);
    private TTextField textDataVencimento = new TTextField(10, 4);
    private JButton buttonDataVencimento = new JButton();
    private TTextField textDataCompetencia = new TTextField(10, 4);
    private JButton buttonDataCompetencia = new JButton();
    private TTextField textMulta = new TTextField(10, 2, 2);
    private TTextField textJuro = new TTextField(10, 2, 2);
    private TTextField textDesconto = new TTextField(10, 2, 2);
    private TTextField textAcrescimo = new TTextField(10, 2, 2);
    private TTextField textCodigoHistorico = new TTextField(5, 1);
    private JComboBox<String> cbxTipoJuro = new JComboBox<String>(new String[]{Tipos.tipoJuros("V"), Tipos.tipoJuros("D"), Tipos.tipoJuros("M"), Tipos.tipoJuros("A")});
    private TTextField textDescricaoHistorico = new TTextField(60, 3);
    private JButton buttonBuscaHistorico = new JButton();
    private JPanel panelTipoPagamento = new JPanel(new BorderLayout());
    private JPanel panelCheque = new JPanel(new GridBagLayout());
    private JPanel panelTransferenciaBancaria = new JPanel(new GridBagLayout());
    private JPanel panelPix = new JPanel(new GridBagLayout());
    private JPanel panelCartao = new JPanel(new GridBagLayout());
    private JPanel panelAutDebito = new JPanel(new GridBagLayout());
    private JPanel panelPromissoria = new JPanel(new GridBagLayout());
    private JPanel panelDescontoFolha = new JPanel(new GridBagLayout());
    private JPanel panelCancelado = new JPanel(new BorderLayout());
    private JPanel panelDadosCancelado = new JPanel(new BorderLayout());
    private ContaCorrenteService contaCorrenteService = new ContaCorrenteService();
    private HistoricoPadraoService historicoPadraoService = new HistoricoPadraoService();
    private String tipoOrigem = "U";
    private JButton buttonGeraApropriacoes = new JButton("Gerar Apropria\u00e7\u00f5es");
    private JLabel lblSituacao = new JLabel("Situa\u00e7\u00e3o:");
    private JLabel lblVlrSituacao = new JLabel();
    private JLabel lblDescricaoHistorico = new JLabel("Desc. Hist\u00f3rico:");
    private JLabel lblTransferenciaBancaria = new JLabel("Transfer\u00eancia: ");
    private JLabel lblPix = new JLabel("Pix: ");
    private TTextField textDescricaoHistoricoUsuario = new TTextField(60, 3);
    private TTextField textSacado = new TTextField(80, 3);
    private TTextField textBancoTransferencia = new TTextField(3, 1);
    private TTextField textAgenciaTransferencia = new TTextField(5, 1);
    private TTextField textContaTransferencia = new TTextField(15, 1);
    private TTextField textTransferenciaBancaria = new TTextField(5, 3);
    private TTextField textPix = new TTextField(50, 3);
    private TTextField textVencimentoChq = new TTextField(10, 4);
    private TTextField textDataTransferenciaBancaria = new TTextField(12, 4);
    private JButton buttonVencimentoChq = new JButton();
    private JButton buttonDataTransferenciaBancaria = new JButton();
    private JButton buttonDataPix = new JButton();
    private JLabel labelSacado = new JLabel("Sacado:");
    private JLabel labelVencimentoChqPre = new JLabel("Vencimento:");
    private JLabel labelDataTransferenciaBancaria = new JLabel("Data: ");
    private String tipoDebitoCredito = null;
    private PanelPlanoContaCentroCusto panelPlanoContaCentroCusto = new PanelPlanoContaCentroCusto(this, PanelPlanoContaCentroCusto.TIPO_LANCAMENTO, ACESSO_ALTERAR_PLANOCONTAS, ACESSO_ALTERAR_CENTROSCUSTO, Variaveis.filialPadrao);
    public static final int MODAL_RESULT_CANCEL = -1;
    public static final int MODAL_RESULT_OK = 1;
    private static int resultadoModal = -1;
    private boolean ocultarCampos = false;
    transient BandeirasCartoes[] cartoes = FinanceiroUtil.getCartoesCredito();
    private String situacao;
    private FilialVO filial;
    private EstacaoVO estacao;
    private UsuarioVO usuario;
    private String retornoParaPesquisa = "";

    public Lancamento(boolean ocultarCampos) {
        this.ocultarCampos = ocultarCampos;
        this.setLabelDescricao("Manuten\u00e7\u00e3o dos Lan\u00e7amentos Financeiros");
        this.setLabelFormulario("Lan\u00e7amentos Financeiros");
        this.setIcone(ImagemUtils.carregaImagemJalis("financeiro/lanc_financeiro.jpg"));
        if (this.cartoes == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Nenhuma bandeira de cart\u00e3o configurada.", 2);
            this.botaoFechar.doClick();
        } else {
            for (BandeirasCartoes cartao : this.cartoes) {
                this.cbxCartaoCredito.addItem(cartao);
            }
        }
        ScreenUtil.setBorda(new Component[]{this.lblVlrDataHora, this.labelValorTotal, this.lblVlrSituacao}, new TitledBorder(""));
        Dimension d = new Dimension(80, 20);
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setMinimumSize(d);
        d = new Dimension(325, 20);
        this.lblVlrDataHora.setPreferredSize(d);
        this.lblVlrDataHora.setHorizontalAlignment(4);
        this.lblVlrDataHora.setMinimumSize(d);
        d = new Dimension(80, 20);
        this.cbxTipo.setPreferredSize(d);
        this.cbxTipo.setMinimumSize(d);
        this.cbxTipo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Lancamento.this.panelPlanoContaCentroCusto != null && Lancamento.this.tipoDebitoCredito != null && !Lancamento.this.tipoDebitoCredito.equals(Lancamento.this.cbxTipo.getSelectedItem())) {
                    String aux = Lancamento.this.cbxTipo.getSelectedItem().equals(Tipos.tipoLancamentoCaixa("C")) ? "C" : "D";
                    Lancamento.this.panelPlanoContaCentroCusto.setTipoDebitoCredito(aux);
                    if (!Lancamento.this.tipoDebitoCredito.equalsIgnoreCase(aux)) {
                        Lancamento.this.panelPlanoContaCentroCusto.removerTodosPlanosContas();
                        Lancamento.this.panelPlanoContaCentroCusto.removerTodosCentrosCusto();
                        LancamentoBean bean = Lancamento.this.getBeanPreenchidoValores(null);
                        bean = (LancamentoBean)FinanceiroUtil.atualizaTotal((AbstractThreadBean)bean);
                        Lancamento.this.labelValorTotal.setText(Funcoes.formataDecimal(bean.getValorTotal()));
                    }
                    Lancamento.this.tipoDebitoCredito = aux;
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (Lancamento.this.cbxTipo.getSelectedItem().equals(Tipos.tipoLancamentoCaixa("C"))) {
                    Lancamento.this.tipoDebitoCredito = "C";
                } else {
                    Lancamento.this.tipoDebitoCredito = "D";
                }
            }
        });
        d = new Dimension(60, 20);
        this.textCodigoContaCorrente.setPreferredSize(d);
        this.textCodigoContaCorrente.setMinimumSize(d);
        this.textCodigoContaCorrente.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Lancamento.this.buscaContaCorrente(Lancamento.this.textCodigoContaCorrente.getText());
            }
        });
        d = new Dimension(60, 20);
        this.textContaTransferencia.setPreferredSize(d);
        this.textContaTransferencia.setMinimumSize(d);
        d = new Dimension(35, 20);
        this.textBancoTransferencia.setPreferredSize(d);
        this.textBancoTransferencia.setMinimumSize(d);
        d = new Dimension(80, 20);
        this.textAgenciaTransferencia.setPreferredSize(d);
        this.textAgenciaTransferencia.setMinimumSize(d);
        d = new Dimension(82, 20);
        this.textTransferenciaBancaria.setPreferredSize(d);
        this.textTransferenciaBancaria.setMinimumSize(d);
        d = new Dimension(82, 20);
        this.textPix.setPreferredSize(d);
        this.textPix.setMinimumSize(d);
        this.buttonBuscaContaCorrente.setFocusable(false);
        this.buttonBuscaContaCorrente.setText("");
        d = new Dimension(20, 20);
        this.buttonBuscaContaCorrente.setPreferredSize(d);
        this.buttonBuscaContaCorrente.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaContaCorrente);
        this.buttonBuscaContaCorrente.addActionListener(e -> this.buscaContaCorrente());
        d = new Dimension(200, 20);
        this.textDescricaoContaCorrente.setPreferredSize(d);
        this.textDescricaoContaCorrente.setMinimumSize(d);
        this.textDescricaoContaCorrente.setEditable(false);
        this.textDescricaoContaCorrente.setFocusable(false);
        d = new Dimension(60, 20);
        this.textCodigoHistorico.setPreferredSize(d);
        this.textCodigoHistorico.setMinimumSize(d);
        this.textCodigoHistorico.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Lancamento.this.buscaHistorico(Lancamento.this.textCodigoHistorico.getText());
                Lancamento.this.controlaCampos();
                if (e.getOppositeComponent() == Lancamento.this.cbxTipoDocumento && Lancamento.this.textDescricaoHistoricoUsuario.isEnabled()) {
                    Lancamento.this.textDescricaoHistoricoUsuario.grabFocus();
                }
                if (e.getOppositeComponent() == Lancamento.this.cbxTipoDocumento && !Lancamento.this.textDescricaoHistoricoUsuario.isEnabled()) {
                    Lancamento.this.cbxTipoDocumento.grabFocus();
                }
                if (e.getOppositeComponent() == Lancamento.this.textCodigoContaCorrente) {
                    Lancamento.this.textCodigoContaCorrente.grabFocus();
                }
                if (e.getOppositeComponent() == Lancamento.this.textDescricaoHistoricoUsuario && !Lancamento.this.textDescricaoHistoricoUsuario.isEnabled()) {
                    Lancamento.this.cbxTipoDocumento.grabFocus();
                }
                Lancamento.this.visualizarCampos(Lancamento.this.mostrarTela());
            }

            @Override
            public void focusGained(FocusEvent e) {
                Lancamento.this.controlaCampos();
                Lancamento.this.visualizarCampos(Lancamento.this.mostrarTela());
            }
        });
        this.buttonBuscaHistorico.setFocusable(false);
        this.buttonBuscaHistorico.setText("");
        d = new Dimension(20, 20);
        this.buttonBuscaHistorico.setPreferredSize(d);
        this.buttonBuscaHistorico.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaHistorico);
        this.buttonBuscaHistorico.addActionListener(e -> this.buscaHistorico());
        d = new Dimension(200, 20);
        this.textDescricaoHistorico.setPreferredSize(d);
        this.textDescricaoHistorico.setMinimumSize(d);
        this.textDescricaoHistorico.setEditable(false);
        this.textDescricaoHistorico.setFocusable(false);
        d = new Dimension(100, 20);
        this.cbxTipoDocumento.setPreferredSize(d);
        this.cbxTipoDocumento.setMinimumSize(d);
        d = new Dimension(200, 20);
        this.textDocumento.setPreferredSize(d);
        this.textDocumento.setMinimumSize(d);
        d = new Dimension(200, 20);
        this.textPromissoria.setPreferredSize(d);
        this.textPromissoria.setMinimumSize(d);
        FocusAdapter listenerFoco = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                LancamentoBean bean = Lancamento.this.getBeanPreenchidoValores(null);
                bean = (LancamentoBean)FinanceiroUtil.atualizaTotal((AbstractThreadBean)bean);
                Lancamento.this.labelValorTotal.setText(Funcoes.formataDecimal(bean.getValorTotal()));
                Lancamento.this.controlaBotaoGerarApropriacoes();
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getSource() instanceof TTextField) {
                    ((TTextField)e.getSource()).selectAll();
                }
            }
        };
        d = new Dimension(100, 20);
        this.textValor.setPreferredSize(d);
        this.textValor.setMinimumSize(d);
        this.textValor.addFocusListener(listenerFoco);
        d = new Dimension(100, 20);
        this.textMulta.setPreferredSize(d);
        this.textMulta.setMinimumSize(d);
        this.textMulta.addFocusListener(listenerFoco);
        d = new Dimension(100, 20);
        this.textJuro.setPreferredSize(d);
        this.textJuro.setMinimumSize(d);
        this.textJuro.addFocusListener(listenerFoco);
        d = new Dimension(100, 20);
        this.textDesconto.setPreferredSize(d);
        this.textDesconto.setMinimumSize(d);
        this.textDesconto.addFocusListener(listenerFoco);
        d = new Dimension(100, 20);
        this.labelValorTotal.setPreferredSize(d);
        this.labelValorTotal.setMinimumSize(d);
        d = new Dimension(100, 20);
        this.textAcrescimo.setPreferredSize(d);
        this.textAcrescimo.setMinimumSize(d);
        this.textAcrescimo.addFocusListener(listenerFoco);
        d = new Dimension(100, 20);
        this.textDataVencimento.setPreferredSize(d);
        this.textDataVencimento.setMinimumSize(d);
        this.textDataVencimento.addFocusListener(listenerFoco);
        d = new Dimension(160, 20);
        this.cbxTipoPagamento.setPreferredSize(d);
        this.cbxTipoPagamento.setMinimumSize(d);
        this.cbxTipoPagamento.addActionListener(e -> {
            Object o = this.cbxTipoPagamento.getSelectedItem();
            if (o == null) {
                return;
            }
            String s = (String)o;
            this.panelTipoPagamento.removeAll();
            this.cbxCartaoCredito.removeAllItems();
            if (s.equalsIgnoreCase(Tipos.tipoPagamento("H")) || s.equalsIgnoreCase(Tipos.tipoPagamento("T")) || s.equalsIgnoreCase(Tipos.tipoPagamento("P")) || s.equalsIgnoreCase(Tipos.tipoPagamento("A"))) {
                this.montaPanelCheque();
                this.panelTipoPagamento.add((Component)this.panelCheque, "Center");
                this.textDataVencimento.setEnabled(!s.equalsIgnoreCase(Tipos.tipoPagamento("T")) && !s.equalsIgnoreCase(Tipos.tipoPagamento("P")));
                this.textVencimentoChq.setEnabled(s.equalsIgnoreCase(Tipos.tipoPagamento("T")) || s.equalsIgnoreCase(Tipos.tipoPagamento("P")));
                this.buttonDataVencimento.setEnabled(!s.equalsIgnoreCase(Tipos.tipoPagamento("T")) && !s.equalsIgnoreCase(Tipos.tipoPagamento("P")));
            } else if (s.equalsIgnoreCase(Tipos.tipoPagamento("I")) || s.equalsIgnoreCase(Tipos.tipoPagamento("O"))) {
                if (s.equalsIgnoreCase(Tipos.tipoPagamento("I"))) {
                    for (int i = 0; i < this.cartoes.length; ++i) {
                        BandeirasCartoes aux = this.cartoes[i];
                        if (aux.getOperacao() != null && !aux.getOperacao().equalsIgnoreCase("D")) continue;
                        this.cbxCartaoCredito.addItem(aux);
                    }
                } else {
                    for (int i = 0; i < this.cartoes.length; ++i) {
                        BandeirasCartoes aux = this.cartoes[i];
                        if (aux.getOperacao() != null && !aux.getOperacao().equalsIgnoreCase("C")) continue;
                        this.cbxCartaoCredito.addItem(aux);
                    }
                }
                this.panelTipoPagamento.add((Component)this.panelCartao, "Center");
            } else if (s.equalsIgnoreCase(Tipos.tipoPagamento("Z"))) {
                this.panelTipoPagamento.add((Component)this.panelAutDebito, "Center");
            } else if (s.equalsIgnoreCase(Tipos.tipoPagamento("S"))) {
                this.panelTipoPagamento.add((Component)this.panelPromissoria, "Center");
            } else if (s.equalsIgnoreCase(Tipos.tipoPagamento("F"))) {
                this.panelTipoPagamento.add((Component)this.panelDescontoFolha, "Center");
            } else if (s.equalsIgnoreCase(Tipos.tipoPagamento("W"))) {
                this.montaPanelTransferenciaBancaria();
                this.panelTipoPagamento.add((Component)this.panelTransferenciaBancaria, "Center");
            } else if (s.equalsIgnoreCase(Tipos.tipoPagamento("Y"))) {
                this.montaPanelPix();
                this.panelTipoPagamento.add((Component)this.panelPix, "Center");
            }
            this.painelCentral.revalidate();
            this.painelCentral.repaint();
        });
        this.cbxTipoPagamento.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Lancamento.this.cbxTipoPagamento.getSelectedItem() != null) {
                    String s = Lancamento.this.cbxTipoPagamento.getSelectedItem().toString();
                    if (s.equalsIgnoreCase(Tipos.tipoPagamento("H")) || s.equalsIgnoreCase(Tipos.tipoPagamento("T")) || s.equalsIgnoreCase(Tipos.tipoPagamento("P")) || s.equalsIgnoreCase(Tipos.tipoPagamento("A"))) {
                        Lancamento.this.montaPanelCheque();
                        Lancamento.this.panelTipoPagamento.add((Component)Lancamento.this.panelCheque, "Center");
                    }
                    Lancamento.this.textDataVencimento.setEnabled(!s.equalsIgnoreCase(Tipos.tipoPagamento("T")) && !s.equalsIgnoreCase(Tipos.tipoPagamento("P")));
                    Lancamento.this.textVencimentoChq.setEnabled(s.equalsIgnoreCase(Tipos.tipoPagamento("T")) || s.equalsIgnoreCase(Tipos.tipoPagamento("P")));
                    Lancamento.this.buttonDataVencimento.setEnabled(!s.equalsIgnoreCase(Tipos.tipoPagamento("T")) && !s.equalsIgnoreCase(Tipos.tipoPagamento("P")));
                }
            }
        });
        d = new Dimension(100, 20);
        this.textDataCompetencia.setPreferredSize(d);
        this.textDataCompetencia.setMinimumSize(d);
        d = new Dimension(35, 20);
        this.textBanco.setPreferredSize(d);
        this.textBanco.setMinimumSize(d);
        d = new Dimension(80, 20);
        this.textAgencia.setPreferredSize(d);
        this.textAgencia.setMinimumSize(d);
        d = new Dimension(85, 20);
        this.textContaCheque.setPreferredSize(d);
        this.textContaCheque.setMinimumSize(d);
        d = new Dimension(82, 20);
        this.textNumeroCheque.setPreferredSize(d);
        this.textNumeroCheque.setMinimumSize(d);
        d = new Dimension(300, 20);
        this.textSacado.setPreferredSize(d);
        this.textSacado.setMinimumSize(d);
        d = new Dimension(82, 20);
        this.textVencimentoChq.setPreferredSize(d);
        this.textVencimentoChq.setMinimumSize(d);
        d = new Dimension(82, 20);
        this.textDataTransferenciaBancaria.setPreferredSize(d);
        this.textDataTransferenciaBancaria.setMinimumSize(d);
        d = new Dimension(90, 20);
        this.textValidadeCartao.setPreferredSize(d);
        this.textValidadeCartao.setMinimumSize(d);
        this.listener();
        d = new Dimension(135, 20);
        this.textNumeroCartao.setPreferredSize(d);
        this.textNumeroCartao.setMinimumSize(d);
        d = new Dimension(115, 20);
        this.cbxCartaoCredito.setPreferredSize(d);
        this.cbxCartaoCredito.setMinimumSize(d);
        d = new Dimension(300, 20);
        this.textAutDebito.setPreferredSize(d);
        d = new Dimension(300, 20);
        this.textAutDebito.setMinimumSize(d);
        d = new Dimension(300, 20);
        this.textPromissoria.setPreferredSize(d);
        d = new Dimension(300, 20);
        this.textPromissoria.setMinimumSize(d);
        d = new Dimension(300, 20);
        this.textNomeDescFolha.setPreferredSize(d);
        d = new Dimension(300, 20);
        this.textNomeDescFolha.setMinimumSize(d);
        d = new Dimension(300, 20);
        this.textSetorDescFolha.setPreferredSize(d);
        d = new Dimension(300, 20);
        this.textSetorDescFolha.setMinimumSize(d);
        d = new Dimension(300, 20);
        this.textAutorizadoDescFolha.setPreferredSize(d);
        d = new Dimension(300, 20);
        this.textAutorizadoDescFolha.setMinimumSize(d);
        d = new Dimension(100, 35);
        this.scrObservacao.setPreferredSize(d);
        this.scrObservacao.setMinimumSize(d);
        ScreenUtil.montaSaidaTextArea(this.textObservacao);
        d = new Dimension(20, 20);
        this.buttonDataValidadeCartao.setPreferredSize(d);
        this.buttonDataValidadeCartao.setMinimumSize(d);
        this.buttonDataValidadeCartao.setMargin(new Insets(2, 2, 2, 2));
        Funcoes.imagemPesquisa(this.buttonDataValidadeCartao);
        this.buttonDataValidadeCartao.setFocusable(false);
        this.buttonDataValidadeCartao.addActionListener(e -> this.buscaDataValidadeCartao());
        d = new Dimension(20, 20);
        this.buttonDataVencimento.setPreferredSize(d);
        this.buttonDataVencimento.setMinimumSize(d);
        this.buttonDataVencimento.setMargin(new Insets(2, 2, 2, 2));
        Funcoes.imagemPesquisa(this.buttonDataVencimento);
        this.buttonDataVencimento.setFocusable(false);
        this.buttonDataVencimento.addActionListener(e -> this.buscaDataVencimento());
        d = new Dimension(20, 20);
        this.buttonDataCompetencia.setPreferredSize(d);
        this.buttonDataCompetencia.setMinimumSize(d);
        this.buttonDataCompetencia.setMargin(new Insets(2, 2, 2, 2));
        Funcoes.imagemPesquisa(this.buttonDataCompetencia);
        this.buttonDataCompetencia.setFocusable(false);
        this.buttonDataCompetencia.addActionListener(e -> this.buscaDataCompetencia());
        d = new Dimension(20, 20);
        this.buttonVencimentoChq.setPreferredSize(d);
        this.buttonVencimentoChq.setMinimumSize(d);
        this.buttonVencimentoChq.setMargin(new Insets(2, 2, 2, 2));
        Funcoes.imagemPesquisa(this.buttonVencimentoChq);
        this.buttonVencimentoChq.setFocusable(false);
        this.buttonVencimentoChq.addActionListener(e -> this.buscaVencimentoChq());
        d = new Dimension(20, 20);
        this.buttonDataPix.setPreferredSize(d);
        this.buttonDataPix.setMinimumSize(d);
        this.buttonDataPix.setMargin(new Insets(2, 2, 2, 2));
        Funcoes.imagemPesquisa(this.buttonDataPix);
        this.buttonDataPix.setFocusable(false);
        this.buttonDataPix.addActionListener(e -> this.buscaDataPix());
        d = new Dimension(20, 20);
        this.buttonDataTransferenciaBancaria.setPreferredSize(d);
        this.buttonDataTransferenciaBancaria.setMinimumSize(d);
        this.buttonDataTransferenciaBancaria.setMargin(new Insets(2, 2, 2, 2));
        Funcoes.imagemPesquisa(this.buttonDataTransferenciaBancaria);
        this.buttonDataTransferenciaBancaria.setFocusable(false);
        this.buttonDataTransferenciaBancaria.addActionListener(e -> this.buscaDataTransferencia());
        d = new Dimension(100, 20);
        this.cbxTipoJuro.setPreferredSize(d);
        this.cbxTipoJuro.setMinimumSize(d);
        d = new Dimension(100, 20);
        this.lblVlrSituacao.setPreferredSize(d);
        this.lblVlrSituacao.setMinimumSize(d);
        d = new Dimension(140, 20);
        this.buttonGeraApropriacoes.setPreferredSize(d);
        this.buttonGeraApropriacoes.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGeraApropriacoes.setMinimumSize(d);
        this.buttonGeraApropriacoes.addActionListener(e -> {
            LancamentoBean bean = this.getBeanPreenchido();
            bean = (LancamentoBean)FinanceiroUtil.gerarApropriacoes(bean, this.panelPlanoContaCentroCusto, 1, null);
        });
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.painelCentral.add((Component)this.lblCodigo, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.textCodigo, c);
        c.gridx += 5;
        c.gridwidth = 8;
        c.anchor = 13;
        c.fill = 2;
        this.painelCentral.add((Component)this.lblVlrDataHora, c);
        c.anchor = 17;
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        c.gridwidth = 1;
        this.lblTipo.setLabelFor(this.cbxTipo);
        this.lblTipo.setDisplayedMnemonic('p');
        this.painelCentral.add((Component)this.lblTipo, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add(this.cbxTipo, c);
        c.gridx += 4;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.lblSituacao, c);
        c.gridx += 3;
        this.painelCentral.add((Component)this.lblVlrSituacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.lblContaCorrente.setLabelFor(this.textCodigoContaCorrente);
        this.lblContaCorrente.setDisplayedMnemonic('o');
        this.painelCentral.add((Component)this.lblContaCorrente, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigoContaCorrente, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.buttonBuscaContaCorrente, c);
        ++c.gridx;
        c.gridwidth = 11;
        c.fill = 2;
        this.painelCentral.add((Component)this.textDescricaoContaCorrente, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        this.lblHistorico.setLabelFor(this.textCodigoHistorico);
        this.lblHistorico.setDisplayedMnemonic('H');
        this.painelCentral.add((Component)this.lblHistorico, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigoHistorico, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.buttonBuscaHistorico, c);
        ++c.gridx;
        c.gridwidth = 11;
        c.fill = 2;
        this.painelCentral.add((Component)this.textDescricaoHistorico, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.painelCentral.add((Component)this.lblDescricaoHistorico, c);
        ++c.gridx;
        c.gridwidth = 13;
        c.weightx = 0.0;
        c.fill = 2;
        this.painelCentral.add((Component)this.textDescricaoHistoricoUsuario, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        this.lblTipoDocumento.setLabelFor(this.cbxTipoDocumento);
        this.lblTipoDocumento.setDisplayedMnemonic('i');
        this.painelCentral.add((Component)this.lblTipoDocumento, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.painelCentral.add(this.cbxTipoDocumento, c);
        c.gridx += 4;
        c.gridwidth = 3;
        this.lblDocumento.setLabelFor(this.textDocumento);
        this.lblDocumento.setDisplayedMnemonic('u');
        this.painelCentral.add((Component)this.lblDocumento, c);
        c.gridx += 3;
        c.fill = 2;
        c.gridwidth = 6;
        this.painelCentral.add((Component)this.textDocumento, c);
        c.fill = 0;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.lblDataVencimento.setLabelFor(this.textDataVencimento);
        this.lblDataVencimento.setDisplayedMnemonic('n');
        this.painelCentral.add((Component)this.lblDataVencimento, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.painelCentral.add((Component)this.textDataVencimento, c);
        c.gridx += 3;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.buttonDataVencimento, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.lblDataCompetencia.setLabelFor(this.textDataCompetencia);
        this.lblDataCompetencia.setDisplayedMnemonic('m');
        this.painelCentral.add((Component)this.lblDataCompetencia, c);
        c.gridx += 3;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.textDataCompetencia, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.buttonDataCompetencia, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.lblValor.setLabelFor(this.textValor);
        this.lblValor.setDisplayedMnemonic('V');
        this.painelCentral.add((Component)this.lblValor, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.painelCentral.add((Component)this.textValor, c);
        if (this.mostrarTela()) {
            c.gridx += 4;
            c.gridwidth = 3;
            this.lblTipoJuro.setLabelFor(this.cbxTipoJuro);
            this.lblTipoJuro.setDisplayedMnemonic('J');
            this.painelCentral.add((Component)this.lblTipoJuro, c);
            c.gridx += 3;
            c.gridwidth = 1;
            this.painelCentral.add(this.cbxTipoJuro, c);
            c.gridx += 2;
            this.lblJuro.setLabelFor(this.textJuro);
            this.lblJuro.setDisplayedMnemonic('r');
            this.painelCentral.add((Component)this.lblJuro, c);
            ++c.gridx;
            this.painelCentral.add((Component)this.textJuro, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 1;
            this.lblDesconto.setLabelFor(this.textDesconto);
            this.lblDesconto.setDisplayedMnemonic('t');
            this.painelCentral.add((Component)this.lblDesconto, c);
            ++c.gridx;
            c.gridwidth = 3;
            this.painelCentral.add((Component)this.textDesconto, c);
            c.gridx += 4;
            c.gridwidth = 3;
            this.lblAcrescimo.setLabelFor(this.textAcrescimo);
            this.lblAcrescimo.setDisplayedMnemonic('A');
            this.painelCentral.add((Component)this.lblAcrescimo, c);
            c.gridx += 3;
            c.gridwidth = 1;
            this.painelCentral.add((Component)this.textAcrescimo, c);
            c.gridx += 2;
            this.lblMulta.setLabelFor(this.textMulta);
            this.lblMulta.setDisplayedMnemonic('l');
            this.painelCentral.add((Component)this.lblMulta, c);
            ++c.gridx;
            this.painelCentral.add((Component)this.textMulta, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 1;
            this.painelCentral.add((Component)this.lblValorTotal, c);
            ++c.gridx;
            c.gridwidth = 3;
            this.painelCentral.add((Component)this.labelValorTotal, c);
            c.gridx += 4;
            c.gridwidth = 1;
            this.lblTipoPagamento.setLabelFor(this.cbxTipoPagamento);
            this.lblTipoPagamento.setDisplayedMnemonic('g');
            this.painelCentral.add((Component)this.lblTipoPagamento, c);
            c.gridx += 2;
            c.gridwidth = 4;
            this.painelCentral.add(this.cbxTipoPagamento, c);
        } else {
            c.fill = 2;
            c.gridx += 4;
            c.gridwidth = 1;
            this.lblTipoPagamento.setLabelFor(this.cbxTipoPagamento);
            this.lblTipoPagamento.setDisplayedMnemonic('g');
            this.painelCentral.add((Component)this.lblTipoPagamento, c);
            c.gridx += 2;
            c.gridwidth = 4;
            this.painelCentral.add(this.cbxTipoPagamento, c);
        }
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 13;
        c.weightx = 1.0;
        c.fill = 2;
        this.painelCentral.add((Component)this.panelTipoPagamento, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.lblObservacao.setLabelFor(this.scrObservacao);
        this.lblObservacao.setDisplayedMnemonic('b');
        this.painelCentral.add((Component)this.lblObservacao, c);
        ++c.gridx;
        c.gridwidth = 13;
        c.weightx = 1.0;
        c.fill = 2;
        this.painelCentral.add((Component)this.scrObservacao, c);
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 13;
        c.weightx = 1.0;
        c.fill = 2;
        this.painelCentral.add((Component)this.panelCancelado, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 15;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panelPlanoContaCentroCusto.setTituloPlanoContas("Plano de Contas (F5)");
        this.panelPlanoContaCentroCusto.setTituloCentroCusto("Centros de Custo (F6)");
        boolean haPlanos = false;
        boolean haCentros = false;
        try {
            haPlanos = new PlanoContaService().haPlanosContas(Variaveis.filialPadrao);
            haCentros = new CentroCustoService().haCentrosCusto(Variaveis.filialPadrao);
            if (this.mostrarTela() && Acesso.getAcesso(ACESSO_VISUALIZAR_PLANOCONTA_CENTROCUSTO) && (haPlanos || haCentros)) {
                this.painelCentral.add((Component)this.panelPlanoContaCentroCusto, c);
                this.panelPlanoContaCentroCusto.setPainelPlanoContaVisivel(haPlanos);
                this.panelPlanoContaCentroCusto.setPainelCentroCustoVisivel(haCentros);
            } else {
                this.painelCentral.add((Component)new JPanel(), c);
            }
        }
        catch (Exception e2) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel verificar dados de planos de contas e centros e custo.\n" + e2.getMessage(), e2.getStackTrace());
        }
        if (this.mostrarTela() && Acesso.getAcesso(ACESSO_VISUALIZAR_PLANOCONTA_CENTROCUSTO) && haCentros) {
            this.painelCentral.add((Component)this.panelPlanoContaCentroCusto, c);
        } else {
            this.painelCentral.add((Component)new JPanel(), c);
        }
        this.montaPanelCheque();
        this.montaPanelCartao();
        this.montaPanelCancelado();
        this.montaPanelAutDebito();
        this.montaDescontoFolha();
        this.montaPanelPromissoria();
        this.montaPanelTransferenciaBancaria();
        this.service = new LancamentoService();
        this.panelPlanoContaCentroCusto.setService(this.service);
        if (this.cbxTipo.getSelectedItem().equals(Tipos.tipoLancamentoCaixa("C"))) {
            this.panelPlanoContaCentroCusto.setTipoDebitoCredito("C");
        } else {
            this.panelPlanoContaCentroCusto.setTipoDebitoCredito("D");
        }
        this.panelPlanoContaCentroCusto.buscaValorTituloPlano();
        this.panelPlanoContaCentroCusto.buscaValorTituloCentro();
        this.inserirAcaoDeTecla("F5", "atalhoF5", new AbstractAction("atalhoF5"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Lancamento.this.getStatus() == 3 || Lancamento.this.getStatus() == 2) {
                    Lancamento.this.panelPlanoContaCentroCusto.focalizarPlanoContas();
                }
            }
        });
        this.inserirAcaoDeTecla("F6", "atalhoF6", new AbstractAction("atalhoF6"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Lancamento.this.getStatus() == 3 || Lancamento.this.getStatus() == 2) {
                    Lancamento.this.panelPlanoContaCentroCusto.focalizarCentroCusto();
                }
            }
        });
        this.visualizarCampos(this.mostrarTela());
        this.controlaCampos();
    }

    private void conciliarDiferente() {
        if (this.validaCampos()) {
            ContaCorrenteVO conta = (ContaCorrenteVO)this.contaCorrenteService.pesquisaVO(this.getTopLevelAncestor(), new ContaCorrenteVO(), "Pesquisando contas correntes", false);
            if (conta != null) {
                Date data = this.solicitarDataConciliacao();
                if (null != data) {
                    this.salvarLancamento(true, true, conta, data);
                }
            } else {
                Funcoes.mensagem(this, "A conta corrente para concilia\u00e7\u00e3o deve ser selecionada", 2);
            }
        }
    }

    private void conciliarAtual() {
        if (this.validaCampos()) {
            FilialVO filialVO = new FilialVO();
            filialVO.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
            ContaCorrenteVO conta = new ContaCorrenteVO();
            conta.setFilial(filialVO);
            conta.setReduzido(Integer.parseInt(this.textCodigoContaCorrente.getText()));
            Date data = this.solicitarDataConciliacao();
            if (null != data) {
                this.salvarLancamento(true, true, conta, data);
            }
        }
    }

    private Date solicitarDataConciliacao() {
        SolicitarDataConciliacao d = new SolicitarDataConciliacao(Laboratorio.getInstancia());
        d.setData(new Date());
        d.setVisible(true);
        if (d.getOK()) {
            return d.getData();
        }
        return null;
    }

    private void abrirSalvarConciliar() {
        this.menuConciliar.show(this.painelBotoes, this.buttonSalvarConciliar.getX(), this.buttonSalvarConciliar.getY() + this.buttonSalvarConciliar.getHeight());
    }

    private String getDescricaoConciliarAtual() {
        return this.textDescricaoContaCorrente == null || Funcoes.textoVazio(this.textDescricaoContaCorrente.getText()) || this.textDescricaoContaCorrente.getText().equals("N\u00e3o cadastrado") ? "Conciliar na conta atual" : "Conciliar na conta " + this.textDescricaoContaCorrente.getText();
    }

    private void listener() {
        this.textValidadeCartao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary() && !Lancamento.this.validarData(Lancamento.this.textValidadeCartao.getText())) {
                    Funcoes.mensagem(Lancamento.this, "A data de Validade do cart\u00e3o \u00e9 inferior a Data Atual. Efetuar a corre\u00e7\u00e3o", 2);
                    ScreenUtil.requisitarFoco(Lancamento.this.textValidadeCartao);
                    return;
                }
            }
        });
    }

    private boolean validarData(String data) {
        if (!Funcoes.textoVazio(data) && Funcoes.verificaData(data)) {
            int mesAtual = Funcoes.retornaMes(new Date());
            int anoAtual = Funcoes.retornaAno(new Date());
            Date mesInformado = Funcoes.getData("dd/MM/yyyy", data);
            int mes = Funcoes.retornaMes(mesInformado);
            int ano = Funcoes.retornaAno(mesInformado);
            if (anoAtual > ano || mesAtual > mes && anoAtual == ano) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            if (this.getTopLevelAncestor() instanceof JDialog) {
                this.getTopLevelAncestor().setVisible(false);
            }
            this.setVisible(false);
        }
    }

    @Override
    public void cancelar() {
        boolean podeCancelar = true;
        if (this.getStatus() == 3 || this.getStatus() == 2) {
            podeCancelar = false;
            if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
                podeCancelar = true;
            }
        }
        if (podeCancelar) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
            this.visualizarCampos(this.mostrarTela());
        }
    }

    @Override
    protected void controlaCampos() {
        boolean validarStatus = this.getStatus() == 3 || this.getStatus() == 2;
        this.textCodigo.setEnabled(false);
        this.cbxTipo.setEnabled(validarStatus);
        this.textValor.setEnabled(validarStatus);
        this.textBanco.setEnabled(validarStatus);
        this.textAgencia.setEnabled(validarStatus);
        this.textDocumento.setEnabled(validarStatus);
        this.textPromissoria.setEnabled(validarStatus);
        this.textObservacao.setEnabled(validarStatus);
        this.cbxTipoDocumento.setEnabled(validarStatus);
        this.cbxTipoPagamento.setEnabled(validarStatus);
        this.textCodigoContaCorrente.setEnabled(validarStatus);
        this.textDescricaoContaCorrente.setEnabled(validarStatus);
        this.buttonBuscaContaCorrente.setEnabled(validarStatus);
        this.textCodigoHistorico.setEnabled(validarStatus);
        this.textDescricaoHistorico.setEnabled(validarStatus);
        this.buttonBuscaHistorico.setEnabled(validarStatus);
        this.textNumeroCheque.setEnabled(validarStatus);
        this.textValidadeCartao.setEnabled(validarStatus);
        this.textNumeroCartao.setEnabled(validarStatus);
        this.cbxCartaoCredito.setEnabled(validarStatus);
        this.textContaCheque.setEnabled(validarStatus);
        this.textDataVencimento.setEnabled(validarStatus);
        this.textDataCompetencia.setEnabled(validarStatus);
        this.textVencimentoChq.setEnabled(validarStatus);
        this.buttonDataCompetencia.setEnabled(validarStatus);
        this.buttonDataValidadeCartao.setEnabled(validarStatus);
        this.buttonDataVencimento.setEnabled(validarStatus);
        this.buttonVencimentoChq.setEnabled(validarStatus);
        this.textMulta.setEnabled(validarStatus);
        this.textJuro.setEnabled(validarStatus);
        this.textAcrescimo.setEnabled(validarStatus);
        this.textDesconto.setEnabled(validarStatus);
        this.cbxTipoJuro.setEnabled(validarStatus);
        this.panelPlanoContaCentroCusto.setEnabled(validarStatus);
        this.buttonGeraApropriacoes.setEnabled(validarStatus);
        this.textSacado.setEnabled(validarStatus);
        this.textNomeDescFolha.setEnabled(validarStatus);
        this.textSetorDescFolha.setEnabled(validarStatus);
        this.textAutorizadoDescFolha.setEnabled(validarStatus);
        this.textContaTransferencia.setEnabled(validarStatus);
        this.textDataTransferenciaBancaria.setEnabled(validarStatus);
        this.textTransferenciaBancaria.setEnabled(validarStatus);
        this.textAgenciaTransferencia.setEnabled(validarStatus);
        this.textBancoTransferencia.setEnabled(validarStatus);
        this.textDescricaoHistoricoUsuario.setEnabled(validarStatus);
        this.textDescricaoHistoricoUsuario.setEnabled(this.textDescricaoHistoricoUsuario.isEnabled() && this.getPodeDescreverHistoricoPadrao());
        if (!this.textDescricaoHistoricoUsuario.isEnabled() && validarStatus) {
            this.textDescricaoHistoricoUsuario.setText("");
        }
    }

    private void visualizarCampos(boolean validarStatus) {
        boolean mostraCampos = this.mostrarTela();
        if (mostraCampos) {
            this.panelPlanoContaCentroCusto.controlaCampos(validarStatus);
        } else {
            this.lblAcrescimo.setVisible(mostraCampos);
            this.textAcrescimo.setVisible(mostraCampos);
            this.textAcrescimo.setText(Funcoes.formataDecimal(0.0));
            this.lblJuro.setVisible(mostraCampos);
            this.textJuro.setText(Funcoes.formataDecimal(0.0));
            this.textJuro.setVisible(mostraCampos);
            this.lblTipoJuro.setVisible(mostraCampos);
            this.cbxTipoJuro.setVisible(mostraCampos);
            this.lblMulta.setVisible(mostraCampos);
            this.textMulta.setText(Funcoes.formataDecimal(0.0));
            this.textMulta.setVisible(mostraCampos);
            this.lblValorTotal.setVisible(mostraCampos);
            this.labelValorTotal.setVisible(mostraCampos);
            this.lblDesconto.setVisible(mostraCampos);
            this.textDesconto.setVisible(mostraCampos);
            this.cbxTipoDocumento.setSelectedItem(Tipos.tipoDocumento("C"));
            this.cbxTipoDocumento.setEnabled(mostraCampos);
            this.textDataVencimento.setText(Funcoes.formataData(Funcoes.getDataHoraAtual()));
            this.textDataCompetencia.setText(Funcoes.formataData(Funcoes.getDataHoraAtual()));
        }
    }

    private boolean validaApropriacoes() {
        LancamentoBean bean = this.getBeanPreenchido();
        boolean haApropriacoes = true;
        if (this.buttonGeraApropriacoes.isVisible()) {
            return true;
        }
        haApropriacoes = bean.getValorJuro() > 0.0;
        boolean bl = haApropriacoes = !FinanceiroUtil.haApropriacoes(bean, TiposApropriacao.Juros, this.panelPlanoContaCentroCusto) && haApropriacoes;
        if (haApropriacoes) {
            return haApropriacoes;
        }
        haApropriacoes = bean.getValorDesconto() > 0.0;
        boolean bl2 = haApropriacoes = !FinanceiroUtil.haApropriacoes(bean, TiposApropriacao.Desconto, this.panelPlanoContaCentroCusto) && haApropriacoes;
        if (haApropriacoes) {
            return haApropriacoes;
        }
        haApropriacoes = bean.getValorAcrescimo() > 0.0;
        boolean bl3 = haApropriacoes = !FinanceiroUtil.haApropriacoes(bean, TiposApropriacao.Acrescimos, this.panelPlanoContaCentroCusto) && haApropriacoes;
        if (haApropriacoes) {
            return haApropriacoes;
        }
        haApropriacoes = bean.getValorMulta() > 0.0;
        boolean bl4 = haApropriacoes = !FinanceiroUtil.haApropriacoes(bean, TiposApropriacao.Multas, this.panelPlanoContaCentroCusto) && haApropriacoes;
        if (haApropriacoes) {
            return haApropriacoes;
        }
        return haApropriacoes;
    }

    private boolean getPodeDescreverHistoricoPadrao() {
        LancamentoBean bean = this.getBeanPreenchido();
        if (bean != null && bean.getHistoricoPadrao() != null && bean.getHistoricoPadrao().getPermiteDescrever() != null) {
            return bean.getHistoricoPadrao().getPermiteDescrever();
        }
        return false;
    }

    private LancamentoBean getBeanPreenchidoValores(LancamentoBean bean) {
        if (bean == null) {
            bean = new LancamentoBean();
        }
        bean.setValor(Funcoes.textoVazio(this.textValor.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValor.getText())));
        bean.setValorMulta(Funcoes.textoVazio(this.textMulta.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textMulta.getText())));
        bean.setValorJuro(Funcoes.textoVazio(this.textJuro.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textJuro.getText())));
        bean.setValorDesconto(Funcoes.textoVazio(this.textDesconto.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textDesconto.getText())));
        bean.setValorAcrescimo(Funcoes.textoVazio(this.textAcrescimo.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textAcrescimo.getText())));
        if (this.cbxTipo.getSelectedItem().equals(Tipos.tipoLancamentoCaixa("C"))) {
            bean.setTipo("C");
        } else {
            bean.setTipo("D");
        }
        return bean;
    }

    @Override
    protected LancamentoBean getBeanPreenchido() {
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        UsuarioVO usuarioVO = new UsuarioVO();
        usuarioVO.setCodigo(Variaveis.login);
        EstacaoVO estacaoVO = new EstacaoVO();
        estacaoVO.setCodigo(Integer.parseInt(Variaveis.codigoEstacao));
        LancamentoBean lancamento = new LancamentoBean();
        lancamento.setFilial(filialVO);
        lancamento.setUsuario(usuarioVO);
        lancamento.setEstacao(estacaoVO);
        if (this.getStatus() == 3) {
            lancamento.setCodigo(Integer.parseInt(this.textCodigo.getText()));
            lancamento.setSituacao(this.situacao);
            lancamento.setFilial(this.filial);
            lancamento.setEstacao(this.estacao);
            lancamento.setUsuario(this.usuario);
        } else if (this.getStatus() == 2) {
            lancamento.setDataHora(new Date());
            lancamento.setSituacao("A");
        }
        lancamento.setTipo(((String)this.cbxTipo.getSelectedItem()).substring(0, 1));
        lancamento.setValor(Funcoes.textoVazio(this.textValor.getText()) ? 0.0 : Double.valueOf(Funcoes.limpaDecimal(this.textValor.getText())));
        lancamento.setValorMulta(Funcoes.textoVazio(this.textMulta.getText()) ? 0.0 : Double.valueOf(Funcoes.limpaDecimal(this.textMulta.getText())));
        lancamento.setValorJuro(Funcoes.textoVazio(this.textJuro.getText()) ? 0.0 : Double.valueOf(Funcoes.limpaDecimal(this.textJuro.getText())));
        lancamento.setValorDesconto(Funcoes.textoVazio(this.textDesconto.getText()) ? 0.0 : Double.valueOf(Funcoes.limpaDecimal(this.textDesconto.getText())));
        lancamento.setValorAcrescimo(Funcoes.textoVazio(this.textAcrescimo.getText()) ? 0.0 : Double.valueOf(Funcoes.limpaDecimal(this.textAcrescimo.getText())));
        lancamento.setValorTotal(Funcoes.textoVazio(this.labelValorTotal.getText()) ? 0.0 : Double.valueOf(Funcoes.limpaDecimal(this.labelValorTotal.getText())));
        lancamento = (LancamentoBean)FinanceiroUtil.calculaPercentuais((AbstractThreadBean)lancamento);
        lancamento.setNumeroDocumento(Funcoes.textoVazio(this.textDocumento.getText()) ? null : this.textDocumento.getText());
        lancamento.setObservacao(Funcoes.textoVazio(this.textObservacao.getText()) ? null : this.textObservacao.getText());
        if (this.cbxTipoPagamento.getSelectedItem() != null) {
            lancamento.setTipoPagamento(Tipos.getTipoPagamento(this.cbxTipoPagamento.getSelectedItem().toString()));
            if (this.cbxTipoPagamento.getSelectedItem() != null && (this.cbxTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("A")) || this.cbxTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("H")) || this.cbxTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("T")) || this.cbxTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("P")))) {
                lancamento.setBanco(Funcoes.textoVazio(this.textBanco.getText()) ? null : Integer.valueOf(Integer.parseInt(this.textBanco.getText())));
                lancamento.setAgencia(Funcoes.textoVazio(this.textAgencia.getText()) ? null : this.textAgencia.getText());
                lancamento.setConta(Funcoes.textoVazio(this.textContaCheque.getText()) ? null : this.textContaCheque.getText());
                lancamento.setNumeroCheque(Funcoes.textoVazio(this.textNumeroCheque.getText()) ? null : this.textNumeroCheque.getText());
                lancamento.setSacado(Funcoes.textoVazio(this.textSacado) ? null : this.textSacado.getText());
            } else if (this.cbxTipoPagamento.getSelectedItem() != null && this.cbxTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("I")) || this.cbxTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("O"))) {
                lancamento.setValidadeCartao(Funcoes.textoVazio(this.textValidadeCartao.getText()) ? null : Funcoes.stringToDate(this.textValidadeCartao.getText()));
                lancamento.setNumeroCartao(Funcoes.textoVazio(this.textNumeroCartao.getText()) ? null : this.textNumeroCartao.getText());
                lancamento.setCartaoCredito(this.cbxCartaoCredito.getSelectedIndex() < 0 ? null : this.cbxCartaoCredito.getSelectedItem().toString());
            } else if (this.cbxTipoPagamento.getSelectedItem() != null && this.cbxTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("Z"))) {
                lancamento.setNumeroDocumento(this.textAutDebito.getText());
            } else if (this.cbxTipoPagamento.getSelectedItem() != null && this.cbxTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("S"))) {
                lancamento.setNumeroDocumento(this.textPromissoria.getText());
            } else if (this.cbxTipoPagamento.getSelectedItem() != null && this.cbxTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("F"))) {
                lancamento.setNomeDescFolha(this.textNomeDescFolha.getText());
                lancamento.setSetorDescFolha(this.textSetorDescFolha.getText());
                lancamento.setAutorizadoDescFolha(this.textAutorizadoDescFolha.getText());
            } else if (this.cbxTipoPagamento.getSelectedItem() != null && this.cbxTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("W"))) {
                lancamento.setBanco(Funcoes.textoVazio(this.textBancoTransferencia.getText()) ? null : Integer.valueOf(Integer.parseInt(this.textBancoTransferencia.getText())));
                lancamento.setAgencia(Funcoes.textoVazio(this.textAgenciaTransferencia.getText()) ? null : this.textAgenciaTransferencia.getText());
                lancamento.setConta(Funcoes.textoVazio(this.textContaTransferencia.getText()) ? null : this.textContaTransferencia.getText());
                lancamento.setSacado(Funcoes.textoVazio(this.textSacado) ? null : this.textSacado.getText());
                lancamento.setTipoTransferencia(Funcoes.textoVazio(this.textTransferenciaBancaria) ? null : this.textTransferenciaBancaria.getText());
            } else if (this.cbxTipoPagamento.getSelectedItem() != null && this.cbxTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("Y"))) {
                lancamento.setBanco(Funcoes.textoVazio(this.textBancoTransferencia.getText()) ? null : Integer.valueOf(Integer.parseInt(this.textBancoTransferencia.getText())));
                lancamento.setAgencia(Funcoes.textoVazio(this.textAgenciaTransferencia.getText()) ? null : this.textAgenciaTransferencia.getText());
                lancamento.setConta(Funcoes.textoVazio(this.textContaTransferencia.getText()) ? null : this.textContaTransferencia.getText());
                lancamento.setSacado(Funcoes.textoVazio(this.textSacado) ? null : this.textSacado.getText());
                lancamento.setPix(this.textPix.getText());
            }
        }
        String tipo = "";
        if (this.cbxTipoJuro.getSelectedIndex() >= 0) {
            tipo = (String)this.cbxTipoJuro.getSelectedItem();
            if (tipo.equalsIgnoreCase(Tipos.tipoJuros("A"))) {
                lancamento.setTipoJuro("A");
            } else if (tipo.equalsIgnoreCase(Tipos.tipoJuros("M"))) {
                lancamento.setTipoJuro("M");
            } else if (tipo.equalsIgnoreCase(Tipos.tipoJuros("D"))) {
                lancamento.setTipoJuro("D");
            } else {
                lancamento.setTipoJuro("V");
            }
        }
        if (Funcoes.textoVazio(tipo = (String)this.cbxTipoDocumento.getSelectedItem())) {
            lancamento.setTipoDocumento(null);
        } else if (tipo.equalsIgnoreCase(Tipos.tipoDocumento("B"))) {
            lancamento.setTipoDocumento("B");
        } else if (tipo.equalsIgnoreCase(Tipos.tipoDocumento("D"))) {
            lancamento.setTipoDocumento("D");
        } else if (tipo.equalsIgnoreCase(Tipos.tipoDocumento("C"))) {
            lancamento.setTipoDocumento("C");
        } else if (tipo.equalsIgnoreCase(Tipos.tipoDocumento("A"))) {
            lancamento.setTipoDocumento("A");
        }
        this.validaContaCorrentePadrao();
        if (!Funcoes.textoVazio(this.textCodigoContaCorrente.getText()) && !this.textDescricaoContaCorrente.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            ContaCorrenteVO conta = new ContaCorrenteVO();
            conta.setFilial(filialVO);
            conta.setReduzido(Integer.parseInt(this.textCodigoContaCorrente.getText()));
            conta.setConta(this.textDescricaoContaCorrente.getText());
            lancamento.setContaCorrente(conta);
        } else {
            lancamento.setContaCorrente(null);
        }
        if (!Funcoes.textoVazio(this.textCodigoHistorico.getText()) && !this.textDescricaoHistorico.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            try {
                HistoricoPadraoVO historico = (HistoricoPadraoVO)new HistoricoPadraoService().getVO(String.valueOf(filialVO.getCodigo()), this.textCodigoHistorico.getText());
                lancamento.setHistoricoPadrao(historico);
            }
            catch (Exception e) {
                Funcoes.mensagem(this, "Erro gravar hist\u00f3rico padr\u00e3o.", 2);
            }
        }
        if (!Funcoes.textoVazio(tipo) && (tipo.equalsIgnoreCase(Tipos.tipoPagamento("T")) || tipo.equalsIgnoreCase(Tipos.tipoPagamento("P")))) {
            lancamento.setDataVencimento(Funcoes.textoVazio(this.textVencimentoChq.getText()) ? null : Funcoes.stringToDate(this.textVencimentoChq.getText()));
        } else if (!Funcoes.textoVazio(tipo) && tipo.equalsIgnoreCase(Tipos.tipoPagamento("W"))) {
            lancamento.setDataVencimento(Funcoes.textoVazio(this.textDataTransferenciaBancaria.getText()) ? null : Funcoes.stringToDate(this.textDataTransferenciaBancaria.getText()));
        } else {
            lancamento.setDataVencimento(!Funcoes.textoVazio(this.textDataVencimento.getText()) && Funcoes.verificaData(this.textDataVencimento.getText()) ? Funcoes.stringToDate(this.textDataVencimento.getText()) : null);
        }
        lancamento.setDataCompetencia(!Funcoes.textoVazio(this.textDataCompetencia.getText()) && Funcoes.verificaData(this.textDataCompetencia.getText()) ? Funcoes.stringToDate(this.textDataCompetencia.getText()) : null);
        lancamento.setDescricaoHistorico(this.textDescricaoHistoricoUsuario.getText());
        if (this.panelPlanoContaCentroCusto.getPlanoContas() != null) {
            lancamento.setPlanosContas(new HashSet<AbstractThreadBean>(this.panelPlanoContaCentroCusto.getPlanoContas()));
        }
        if (this.panelPlanoContaCentroCusto.getCentrosCusto() != null) {
            lancamento.setCentrosCusto(new HashSet<AbstractThreadBean>(this.panelPlanoContaCentroCusto.getCentrosCusto()));
        }
        lancamento.setTipoOrigem(this.tipoOrigem);
        return lancamento;
    }

    @Override
    public String getCopiaFiliais() {
        return null;
    }

    @Override
    protected void limparCampos() {
        this.textCodigo.setText("");
        this.cbxTipo.setSelectedItem(Tipos.tipoLancamentoCaixa("C"));
        this.lblVlrDataHora.setText("");
        this.textValor.setText("");
        this.textBanco.setText("");
        this.textAgencia.setText("");
        this.textDocumento.setText("");
        this.textPromissoria.setText("");
        this.textObservacao.setText("");
        this.cbxTipoDocumento.setSelectedIndex(-1);
        this.cbxTipoPagamento.setSelectedIndex(-1);
        this.textCodigoContaCorrente.setText("");
        this.textDescricaoContaCorrente.setText("");
        this.textCodigoHistorico.setText("");
        this.textDescricaoHistorico.setText("");
        this.textNumeroCheque.setText("");
        this.textValidadeCartao.setText("");
        this.textNumeroCartao.setText("");
        this.cbxCartaoCredito.setSelectedIndex(-1);
        this.textContaCheque.setText("");
        this.textDataVencimento.setText(Funcoes.formataData("dd/MM/yyyy", new Date()));
        this.textDataCompetencia.setText("");
        this.textMulta.setText("");
        this.textJuro.setText("");
        this.cbxTipoJuro.setSelectedIndex(-1);
        this.textAcrescimo.setText("");
        this.textDesconto.setText("");
        this.textAutDebito.setText("");
        this.textNomeDescFolha.setText("");
        this.textSetorDescFolha.setText("");
        this.textAutorizadoDescFolha.setText("");
        this.panelPlanoContaCentroCusto.limparCampos();
        this.lblVlrSituacao.setText("");
        this.textSacado.setText("");
        this.textVencimentoChq.setText("");
        this.textDataVencimento.setText("");
        this.labelValorTotal.setText("");
        this.textDescricaoHistoricoUsuario.setText("");
        this.textDataVencimento.setText("");
        this.textBancoTransferencia.setText("");
        this.textAgenciaTransferencia.setText("");
        this.textContaTransferencia.setText("");
        this.textTransferenciaBancaria.setText("");
        this.textDataTransferenciaBancaria.setText("");
        this.textPix.setText("");
        this.panelCancelado.removeAll();
        this.painelCentral.revalidate();
        this.painelCentral.repaint();
        this.panelTipoPagamento.remove(this.panelCartao);
        this.panelTipoPagamento.remove(this.panelAutDebito);
        this.panelTipoPagamento.remove(this.panelCheque);
        this.panelTipoPagamento.remove(this.panelDescontoFolha);
        this.panelTipoPagamento.remove(this.panelTransferenciaBancaria);
        this.panelTipoPagamento.revalidate();
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            AbstractThreadVO vo = ((LancamentoService)this.service).pesquisaVO(this.getTopLevelAncestor(), null, "Pesquisando lan\u00e7amentos", "", true);
            if (vo != null) {
                LancamentoVO v = (LancamentoVO)vo;
                AbstractThreadBean tmp = ((LancamentoService)this.service).get(v.getFilial().getCodigo().toString(), v.getCodigo().toString(), v.getEstacao().getCodigo().toString());
                LancamentoBean lancamentoBean = null;
                if (null != tmp) {
                    lancamentoBean = (LancamentoBean)tmp;
                }
                return lancamentoBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Lancamento:153");
        }
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        LancamentoBean lancamento = (LancamentoBean)bean;
        this.textCodigo.setText(lancamento.getCodigo().toString());
        this.situacao = lancamento.getSituacao();
        this.filial = lancamento.getFilial();
        this.estacao = lancamento.getEstacao();
        this.usuario = lancamento.getUsuario();
        if (lancamento.getTipo().equalsIgnoreCase("C")) {
            this.cbxTipo.setSelectedItem(Tipos.tipoLancamentoCaixa("C"));
        } else {
            this.cbxTipo.setSelectedItem(Tipos.tipoLancamentoCaixa("D"));
        }
        StringBuilder txt = new StringBuilder();
        if (lancamento.getUsuario() != null) {
            txt.append(lancamento.getUsuario().getCodigo()).append(" em ");
        }
        txt.append(Funcoes.formataData("dd/MM/yyyy HH:mm", lancamento.getDataHora()));
        this.lblVlrDataHora.setText(txt.toString());
        this.textValor.setText(Funcoes.formataDecimal(this.textValor.getMaskDecimal(), lancamento.getValor()));
        this.textMulta.setText(Funcoes.formataDecimal(this.textMulta.getMaskDecimal(), lancamento.getValorMulta()));
        this.textJuro.setText(Funcoes.formataDecimal(this.textJuro.getMaskDecimal(), lancamento.getValorJuro()));
        if (lancamento.getTipoPagamento() != null && !Funcoes.textoVazio(lancamento.getTipoPagamento())) {
            this.cbxTipoPagamento.setSelectedItem(Tipos.tipoPagamento(lancamento.getTipoPagamento()));
        }
        if (lancamento.getTipoJuro() == null || lancamento.getTipoJuro().equals("")) {
            this.cbxTipoJuro.setSelectedItem(Tipos.tipoJuros("M"));
        } else {
            this.cbxTipoJuro.setSelectedItem(Tipos.tipoJuros(lancamento.getTipoJuro()));
        }
        this.textAcrescimo.setText(Funcoes.formataDecimal(this.textAcrescimo.getMaskDecimal(), lancamento.getValorAcrescimo()));
        this.textDesconto.setText(Funcoes.formataDecimal(this.textDesconto.getMaskDecimal(), lancamento.getValorDesconto()));
        this.textBanco.setText(lancamento.getBanco() == null ? "" : lancamento.getBanco().toString());
        this.textAgencia.setText(lancamento.getAgencia());
        this.textDocumento.setText(lancamento.getNumeroDocumento());
        this.textPromissoria.setText(lancamento.getNumeroDocumento());
        this.textObservacao.setText(lancamento.getObservacao());
        this.textDataTransferenciaBancaria.setText(Funcoes.formataData("dd/MM/yyyy", lancamento.getDataVencimento()));
        this.textBancoTransferencia.setText(lancamento.getBanco() == null ? "" : lancamento.getBanco().toString());
        this.textAgenciaTransferencia.setText(lancamento.getAgencia());
        this.textContaTransferencia.setText(lancamento.getConta());
        this.textTransferenciaBancaria.setText(lancamento.getTipoTransferencia());
        if (lancamento.getTipoPagamento() != null) {
            if (lancamento.getTipoPagamento().equalsIgnoreCase("D")) {
                this.cbxTipoPagamento.setSelectedItem(Tipos.tipoPagamento("D"));
            } else if (lancamento.getTipoPagamento().equalsIgnoreCase("H")) {
                this.cbxTipoPagamento.setSelectedItem(Tipos.tipoPagamento("H"));
            } else if (lancamento.getTipoPagamento().equalsIgnoreCase("I")) {
                this.cbxTipoPagamento.setSelectedItem(Tipos.tipoPagamento("I"));
            } else if (lancamento.getTipoPagamento().equalsIgnoreCase("O")) {
                this.cbxTipoPagamento.setSelectedItem(Tipos.tipoPagamento("O"));
            } else if (lancamento.getTipoPagamento().equalsIgnoreCase("P")) {
                this.cbxTipoPagamento.setSelectedItem(Tipos.tipoPagamento("P"));
            } else if (lancamento.getTipoPagamento().equalsIgnoreCase("A")) {
                this.cbxTipoPagamento.setSelectedItem(Tipos.tipoPagamento("A"));
            } else if (lancamento.getTipoPagamento().equalsIgnoreCase("T")) {
                this.cbxTipoPagamento.setSelectedItem(Tipos.tipoPagamento("T"));
            } else if (lancamento.getTipoPagamento().equalsIgnoreCase("B")) {
                this.cbxTipoPagamento.setSelectedItem(Tipos.tipoPagamento("B"));
            } else if (lancamento.getTipoPagamento().equalsIgnoreCase("E")) {
                this.cbxTipoPagamento.setSelectedItem(Tipos.tipoPagamento("E"));
            } else if (lancamento.getTipoPagamento().equalsIgnoreCase("Z")) {
                this.cbxTipoPagamento.setSelectedItem(Tipos.tipoPagamento("Z"));
            } else if (lancamento.getTipoPagamento().equalsIgnoreCase("S")) {
                this.cbxTipoPagamento.setSelectedItem(Tipos.tipoPagamento("S"));
            } else if (lancamento.getTipoPagamento().equalsIgnoreCase("U")) {
                this.cbxTipoPagamento.setSelectedItem(Tipos.tipoPagamento("U"));
            } else if (lancamento.getTipoPagamento().equalsIgnoreCase("N")) {
                this.cbxTipoPagamento.setSelectedItem(Tipos.tipoPagamento("N"));
            } else if (lancamento.getTipoPagamento().equalsIgnoreCase("F")) {
                this.cbxTipoPagamento.setSelectedItem(Tipos.tipoPagamento("F"));
            } else if (lancamento.getTipoPagamento().equalsIgnoreCase("W")) {
                this.cbxTipoPagamento.setSelectedItem(Tipos.tipoPagamento("W"));
            } else if (lancamento.getTipoPagamento().equalsIgnoreCase("Y")) {
                this.cbxTipoPagamento.setSelectedItem(Tipos.tipoPagamento("Y"));
            }
        }
        if (lancamento.getTipoPagamento() != null && lancamento.getTipoPagamento().equalsIgnoreCase("Z")) {
            this.textAutDebito.setText(lancamento.getNumeroDocumento());
        }
        if (lancamento.getTipoPagamento() != null && lancamento.getTipoPagamento().equalsIgnoreCase("S")) {
            this.textPromissoria.setText(lancamento.getNumeroDocumento());
        }
        if (lancamento.getContaCorrente() != null) {
            this.textCodigoContaCorrente.setText(lancamento.getContaCorrente().getReduzido().toString());
            this.textDescricaoContaCorrente.setText(lancamento.getContaCorrente().getConta());
            this.itemConciliarContaAtual.setText(this.getDescricaoConciliarAtual());
        }
        if (lancamento.getHistoricoPadrao() != null) {
            this.textCodigoHistorico.setText(Integer.toString(lancamento.getHistoricoPadrao().getCodigo()));
            this.textDescricaoHistorico.setText(lancamento.getHistoricoPadrao().getDescricao());
        }
        if (lancamento.getTipoDocumento() != null) {
            if (lancamento.getTipoDocumento().equalsIgnoreCase("B")) {
                this.cbxTipoDocumento.setSelectedItem(Tipos.tipoDocumento("B"));
            } else if (lancamento.getTipoDocumento().equalsIgnoreCase("D")) {
                this.cbxTipoDocumento.setSelectedItem(Tipos.tipoDocumento("D"));
            } else if (lancamento.getTipoDocumento().equalsIgnoreCase("C")) {
                this.cbxTipoDocumento.setSelectedItem(Tipos.tipoDocumento("C"));
            } else if (lancamento.getTipoDocumento().equalsIgnoreCase("A")) {
                this.cbxTipoDocumento.setSelectedItem(Tipos.tipoDocumento("A"));
            }
        }
        this.textNumeroCheque.setText(lancamento.getNumeroCheque());
        this.textValidadeCartao.setText(Funcoes.formataData("dd/MM/yyyy", lancamento.getValidadeCartao()));
        this.textNumeroCartao.setText(lancamento.getNumeroCartao());
        for (int i = 0; i < this.cbxCartaoCredito.getItemCount(); ++i) {
            BandeirasCartoes bandeira = this.cbxCartaoCredito.getItemAt(i);
            if (!bandeira.toString().equals(lancamento.getCartaoCredito())) continue;
            this.cbxCartaoCredito.setSelectedIndex(i);
            break;
        }
        this.textContaCheque.setText(lancamento.getConta());
        this.textDataVencimento.setText(Funcoes.formataData("dd/MM/yyyy", lancamento.getDataVencimento()));
        this.textDataCompetencia.setText(Funcoes.formataData("dd/MM/yyyy", lancamento.getDataCompetencia()));
        this.textDescricaoHistoricoUsuario.setText(lancamento.getDescricaoHistorico());
        this.textSacado.setText(lancamento.getSacado());
        this.textPix.setText(lancamento.getPix());
        this.textVencimentoChq.setText(Funcoes.formataData("dd/MM/yyyy", lancamento.getDataVencimento()));
        if (!Funcoes.textoVazio(lancamento.getNomeDescFolha())) {
            this.textNomeDescFolha.setText(lancamento.getNomeDescFolha());
        }
        if (!Funcoes.textoVazio(lancamento.getSetorDescFolha())) {
            this.textSetorDescFolha.setText(lancamento.getSetorDescFolha());
        }
        if (!Funcoes.textoVazio(lancamento.getAutorizadoDescFolha())) {
            this.textAutorizadoDescFolha.setText(lancamento.getAutorizadoDescFolha());
        }
        this.labelValorTotal.setText(Funcoes.formataDecimal(lancamento.getValorTotal()));
        this.panelCancelado.removeAll();
        if (lancamento.getSituacao() != null && lancamento.getSituacao().equalsIgnoreCase("C")) {
            StringBuilder html = new StringBuilder();
            html.append("<html>");
            if (lancamento.getUsuarioCancelado() != null) {
                html.append("Usu\u00e1rio: ").append(lancamento.getUsuarioCancelado().getCodigo()).append("<br>");
            }
            html.append("Data: ").append(Funcoes.formataData("dd/MM/yyyy", lancamento.getDataCancelado())).append("<br>");
            if (lancamento.getMotivoCancelado() != null) {
                html.append("Motivo: ").append(lancamento.getMotivoCancelado().getDescricao()).append("<br>");
            }
            html.append("Observa\u00e7\u00e3o: ").append(lancamento.getDescricaoCancelado());
            html.append("<html/>");
            this.lblCancelamento.setText(html.toString());
            this.panelCancelado.add((Component)this.panelDadosCancelado, "Center");
        }
        if (lancamento.getTipo().equals("C")) {
            this.panelPlanoContaCentroCusto.setTipoDebitoCredito("C");
        } else {
            this.panelPlanoContaCentroCusto.setTipoDebitoCredito("D");
        }
        this.panelPlanoContaCentroCusto.setBean(lancamento);
        this.panelPlanoContaCentroCusto.setPlanoContas(lancamento.getPlanosContas());
        this.panelPlanoContaCentroCusto.atualizar(lancamento);
        this.tipoOrigem = lancamento.getTipoOrigem();
        this.lblVlrSituacao.setText(lancamento.getSituacao() != null ? Tipos.tipoSituacaoLancamento(lancamento.getSituacao()) : "");
        this.painelCentral.revalidate();
        this.painelCentral.repaint();
    }

    @Override
    public boolean validaCampos() {
        int resposta;
        if (this.cbxTipo.getSelectedItem() == null || this.cbxTipo.getSelectedIndex() < 0) {
            Funcoes.mensagem(this, "Tipo do lan\u00e7amento n\u00e3o selecionado!", 2);
            ScreenUtil.requisitarFoco(this.cbxTipo);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodigoContaCorrente.getText()) || this.textDescricaoContaCorrente.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Conta corrente n\u00e3o selecionada para o lan\u00e7amento", 2);
            ScreenUtil.requisitarFoco(this.textCodigoContaCorrente);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodigoHistorico.getText()) || this.textDescricaoHistorico.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Hist\u00f3rico n\u00e3o selecionada para o lan\u00e7amento", 2);
            ScreenUtil.requisitarFoco(this.textCodigoHistorico);
            return false;
        }
        if (this.textDataVencimento.isEnabled() && (Funcoes.textoVazio(this.textDataVencimento.getText()) || !Funcoes.verificaData(this.textDataVencimento.getText()))) {
            Funcoes.mensagem(this, "Data de vencimento n\u00e3o \u00e9 valida", 2);
            ScreenUtil.requisitarFoco(this.textDataVencimento);
            return false;
        }
        if (Funcoes.textoVazio(this.textDataCompetencia.getText()) || !Funcoes.verificaData(this.textDataCompetencia.getText())) {
            Funcoes.mensagem(this, "Data de compet\u00eancia n\u00e3o \u00e9 valida", 2);
            ScreenUtil.requisitarFoco(this.textDataCompetencia);
            return false;
        }
        ContaCorrenteBean conta = null;
        try {
            conta = (ContaCorrenteBean)new ContaCorrenteDao().getBean(Variaveis.filialPadrao, this.textCodigoContaCorrente.getText());
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar dados da Conta Corrente/Caixa. " + e.getMessage(), 2);
            return false;
        }
        if (this.cbxTipoPagamento.getSelectedItem() == null || this.cbxTipoPagamento.getSelectedIndex() < 0) {
            Funcoes.mensagem(this, "Tipo do pagamento do lan\u00e7amento n\u00e3o selecionado!", 2);
            ScreenUtil.requisitarFoco(this.cbxTipoPagamento);
            return false;
        }
        if (conta != null && conta.getDataSaldoInicial() != null) {
            if ((this.cbxTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("T")) || this.cbxTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("P"))) && (Funcoes.textoVazio(this.textVencimentoChq.getText()) || Funcoes.stringToDate(this.textVencimentoChq.getText()).compareTo(conta.getDataSaldoInicial()) < 0)) {
                Funcoes.mensagem(this, "A data de Vencimento do cheque deve ser maior ou igual a data de Saldo Inicial da Conta Corrente/Caixa.\nA data de Saldo Inicial da Conta \u00e9: " + Funcoes.formataData(conta.getDataSaldoInicial()) + ".", 2);
                ScreenUtil.requisitarFoco(this.textVencimentoChq);
                return false;
            }
            if (!this.cbxTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("T")) && !this.cbxTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("P")) && Funcoes.stringToDate(this.textDataVencimento.getText()).compareTo(conta.getDataSaldoInicial()) < 0) {
                Funcoes.mensagem(this, "A data de Vencimento deve ser maior ou igual a data de Saldo Inicial da Conta Corrente/Caixa.\nA data de Saldo Inicial da Conta \u00e9: " + Funcoes.formataData(conta.getDataSaldoInicial()) + ".", 2);
                return false;
            }
            if (Funcoes.stringToDate(this.textDataCompetencia.getText()).compareTo(conta.getDataSaldoInicial()) < 0) {
                Funcoes.mensagem(this, "A data de Compet\u00eancia deve ser maior ou igual a data de Saldo Inicial da Conta Corrente/Caixa.A data de Saldo Inicial da Conta \u00e9: " + Funcoes.formataData(conta.getDataSaldoInicial()) + ".", 2);
                return false;
            }
        }
        if (Funcoes.textoVazio(this.textValor.getText())) {
            Funcoes.mensagem(this, "Valor n\u00e3o preenchido", 2);
            ScreenUtil.requisitarFoco(this.textDataVencimento);
            return false;
        }
        if ((this.cbxTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("T")) || this.cbxTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("P"))) && (Funcoes.textoVazio(this.textVencimentoChq.getText()) || !Funcoes.verificaData(this.textVencimentoChq.getText()))) {
            Funcoes.mensagem(this, "Data de vencimento do cheque n\u00e3o \u00e9 valida", 2);
            ScreenUtil.requisitarFoco(this.textVencimentoChq);
            return false;
        }
        if (!this.panelPlanoContaCentroCusto.validarOrigem()) {
            Funcoes.mensagem(this, "H\u00e1 planos de conta/centros de custo SEM origem informada.", 2);
            return false;
        }
        if (Acesso.getAcesso(ACESSO_PROIBIR_SALVAR_SEM_PLANO_CONTAS) && this.panelPlanoContaCentroCusto.verificaPlanoContaSemApropriacao()) {
            Funcoes.mensagem(this, "O valor do lan\u00e7amento deve ser apropriado nos planos de contas.", 2);
            this.panelPlanoContaCentroCusto.focalizarPlanoContas();
            return false;
        }
        if (Acesso.getAcesso(ACESSO_PROIBIR_SALVAR_SEM_CENTRO_CUSTO) && this.panelPlanoContaCentroCusto.verificaCentroCustoSemApropriacao()) {
            Funcoes.mensagem(this, "O valor do lan\u00e7amento deve ser apropriado nos centros de custo.", 2);
            this.panelPlanoContaCentroCusto.focalizarCentroCusto();
            return false;
        }
        if (!this.panelPlanoContaCentroCusto.validar()) {
            Funcoes.mensagem(this, "O total apropriado nos planos de contas \u00e9 diferente do valor total do lan\u00e7amento.", 2);
            return false;
        }
        boolean validaCheque = true;
        LancamentoBean lancto = this.getBeanPreenchido();
        try {
            validaCheque = new LancamentoService().validaCheque(lancto);
        }
        catch (SQLException e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel verificar se o cheque j\u00e1 foi usado em outros pagamentos.", 2);
            return false;
        }
        if (!validaCheque && (resposta = Funcoes.mensagem(this, "O cheque: \"" + lancto.getNumeroCheque() + "\" j\u00e1 foi usado em outro pagamento.\nDeseja usar o mesmo cheque?", 4)) == 1) {
            if (this.textNumeroCheque.isFocusable() && this.textNumeroCheque.isEnabled()) {
                this.textNumeroCheque.grabFocus();
            }
            return false;
        }
        return true;
    }

    private void controlaBotaoGerarApropriacoes() {
        LancamentoBean bean = this.getBeanPreenchido();
        TiposApropriacao aux = null;
        TTextField[] campos = new TTextField[]{this.textJuro, this.textDesconto, this.textAcrescimo, this.textMulta};
        boolean mostrar = false;
        for (int i = 0; i < campos.length; ++i) {
            TTextField campoOrigem = campos[i];
            if (campoOrigem == this.textJuro) {
                aux = TiposApropriacao.Juros;
            } else if (campoOrigem == this.textDesconto) {
                aux = TiposApropriacao.Desconto;
            } else if (campoOrigem == this.textAcrescimo) {
                aux = TiposApropriacao.Acrescimos;
            } else if (campoOrigem == this.textMulta) {
                aux = TiposApropriacao.Multas;
            }
            if (Funcoes.textoVazio(campoOrigem.getText()) || aux == null || !(Double.parseDouble(campoOrigem.getText()) > 0.0)) continue;
            mostrar = FinanceiroUtil.isApropriacaoPlanoContasConfigurada(bean, aux) || mostrar;
            boolean bl = mostrar = FinanceiroUtil.isApropriacaoCentroCustoConfigurada(bean, aux) || mostrar;
            if (!mostrar) continue;
            this.buttonGeraApropriacoes.setVisible(mostrar);
            return;
        }
        this.buttonGeraApropriacoes.setVisible(mostrar);
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Lancamento.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0600400101"));
        this.setModuloEdita(Long.parseLong("0600400102"));
        this.setModuloApaga(Long.parseLong("0600400103"));
        this.botaoNovo.setVisible(Acesso.getAcesso(Long.parseLong("0600400101")));
        this.configurarBotoes();
    }

    private void configurarBotoes() {
        if (Acesso.getAcesso(ACESSO_SALVAR_CONCILIADO)) {
            this.painelBotoes.removeAll();
            SwingUtilities.invokeLater(() -> {
                this.painelBotoes.add(this.botaoNovo);
                this.painelBotoes.add(this.botaoEditar);
                this.painelBotoes.add(this.botaoSalvar);
                this.painelBotoes.add(this.buttonSalvarConciliar);
                this.painelBotoes.add(this.botaoCancelar);
                this.painelBotoes.add(this.botaoExcluir);
                this.painelBotoes.add(this.botaoFechar);
                this.buttonSalvarConciliar.setVisible(this.botaoNovo.isVisible());
                this.habilitaBotoes();
            });
        }
    }

    @Override
    public void habilitaBotoes() {
        super.habilitaBotoes();
        if (null != this.buttonSalvarConciliar) {
            this.buttonSalvarConciliar.setEnabled(this.botaoSalvar.isEnabled());
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600400100");
    }

    private void buscaContaCorrente(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoContaCorrente.setText("");
            this.textDescricaoContaCorrente.setText("");
            this.itemConciliarContaAtual.setText(this.getDescricaoConciliarAtual());
            return;
        }
        try {
            ContaCorrenteVO conta = (ContaCorrenteVO)this.contaCorrenteService.getVO(Variaveis.filialPadrao, codigo);
            if (conta != null) {
                this.textCodigoContaCorrente.setText(conta.getReduzido().toString());
                this.textDescricaoContaCorrente.setText(conta.getConta());
            } else {
                this.textDescricaoContaCorrente.setText("N\u00e3o cadastrado");
            }
            this.itemConciliarContaAtual.setText(this.getDescricaoConciliarAtual());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Lancamento:686");
        }
    }

    private void buscaContaCorrente() {
        try {
            this.textCodigoContaCorrente.setText("");
            this.textDescricaoContaCorrente.setText("");
            ContaCorrenteVO conta = (ContaCorrenteVO)this.contaCorrenteService.pesquisaVO(this.getTopLevelAncestor(), new ContaCorrenteVO(), "Pesquisando contas correntes", true);
            if (conta != null) {
                this.textCodigoContaCorrente.setText(conta.getReduzido().toString());
                this.textDescricaoContaCorrente.setText(conta.getConta());
            } else {
                this.textDescricaoContaCorrente.setText("N\u00e3o cadastrado");
            }
            this.itemConciliarContaAtual.setText(this.getDescricaoConciliarAtual());
            ScreenUtil.requisitarFoco(this.textCodigoContaCorrente);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Lancamento:701");
        }
    }

    private void validaContaCorrentePadrao() {
        try {
            String contaCaixa = ParametrosLocais.getParametro("contaCaixa");
            if (!Funcoes.textoVazio(contaCaixa)) {
                ContaCorrenteVO conta = null;
                ContaCorrenteBean ccBean = FinanceiroUtil.getContaCaixaPadrao(Variaveis.filialPadrao);
                conta = (ContaCorrenteVO)this.contaCorrenteService.getVO(Variaveis.filialPadrao, null != this.textCodigoContaCorrente.getText() && this.textCodigoContaCorrente.getText().length() > 0 ? this.textCodigoContaCorrente.getText() : ccBean.getReduzido().toString());
                if (null != conta) {
                    this.textCodigoContaCorrente.setText(conta.getReduzido().toString());
                    this.textDescricaoContaCorrente.setText(conta.getConta());
                    this.itemConciliarContaAtual.setText(this.getDescricaoConciliarAtual());
                    if (Acesso.getAcesso(ACESSO_NAO_ALTERAR_CONTA_CORRENTE)) {
                        this.textCodigoContaCorrente.setEnabled(false);
                        this.buttonBuscaContaCorrente.setEnabled(false);
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Lancamento:701");
        }
    }

    private void buscaHistorico(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoHistorico.setText("");
            this.textDescricaoHistorico.setText("");
            return;
        }
        try {
            HistoricoPadraoVO historico = (HistoricoPadraoVO)this.historicoPadraoService.getVO(Variaveis.filialPadrao, codigo);
            if (historico != null) {
                this.textCodigoHistorico.setText(historico.getCodigo().toString());
                this.textDescricaoHistorico.setText(historico.getDescricao());
            } else {
                this.textDescricaoHistorico.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Lancamento:686");
        }
    }

    private void buscaHistorico() {
        try {
            this.textCodigoHistorico.setText("");
            this.textDescricaoHistorico.setText("");
            HistoricoPadraoVO historico = (HistoricoPadraoVO)this.historicoPadraoService.pesquisaVO(this.getTopLevelAncestor(), new HistoricoPadraoVO(), "Pesquisando hist\u00f3ricos", true);
            if (historico != null) {
                this.textCodigoHistorico.setText(historico.getCodigo().toString());
                this.textDescricaoHistorico.setText(historico.getDescricao());
            } else {
                this.textDescricaoHistorico.setText("N\u00e3o cadastrado");
            }
            ScreenUtil.requisitarFoco(this.textCodigoHistorico);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Lancamento:1105");
        }
    }

    private void montaPanelCheque() {
        this.panelCheque.removeAll();
        this.panelCheque.setBorder(BorderFactory.createTitledBorder("Dados Cheque"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(1, 1, 1, 1);
        this.panelCheque.add((Component)this.lblBanco, c);
        ++c.gridx;
        this.panelCheque.add((Component)this.textBanco, c);
        ++c.gridx;
        this.panelCheque.add((Component)this.lblAgencia, c);
        ++c.gridx;
        this.panelCheque.add((Component)this.textAgencia, c);
        ++c.gridx;
        this.panelCheque.add((Component)this.lblContaCheque, c);
        ++c.gridx;
        this.panelCheque.add((Component)this.textContaCheque, c);
        ++c.gridx;
        this.panelCheque.add((Component)this.lblNumeroCheque, c);
        ++c.gridx;
        this.panelCheque.add((Component)this.textNumeroCheque, c);
        if (this.cbxTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("T")) || this.cbxTipoPagamento.getSelectedItem().equals(Tipos.tipoPagamento("P"))) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            c.fill = 0;
            this.panelCheque.add((Component)this.labelSacado, c);
            ++c.gridx;
            c.gridwidth = 5;
            c.weightx = 0.0;
            this.panelCheque.add((Component)this.textSacado, c);
            c.gridx += 5;
            c.gridwidth = 1;
            this.panelCheque.add((Component)this.labelVencimentoChqPre, c);
            ++c.gridx;
            this.panelCheque.add((Component)this.textVencimentoChq, c);
            ++c.gridx;
            c.weightx = 1.0;
            c.weighty = 0.0;
            this.panelCheque.add((Component)this.buttonVencimentoChq, c);
        } else {
            ++c.gridx;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 2;
            this.panelCheque.add((Component)new JPanel(), c);
        }
        this.preencheDadosBanco();
    }

    private void montaPanelPix() {
        this.panelPix.removeAll();
        this.panelPix.setBorder(BorderFactory.createTitledBorder("Pix"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(2, 2, 2, 1);
        this.panelPix.add((Component)this.lblBanco, c);
        ++c.gridx;
        this.panelPix.add((Component)this.textBancoTransferencia, c);
        ++c.gridx;
        this.panelPix.add((Component)this.lblAgencia, c);
        ++c.gridx;
        this.panelPix.add((Component)this.textAgenciaTransferencia, c);
        ++c.gridx;
        this.panelPix.add((Component)this.lblContaCheque, c);
        ++c.gridx;
        this.panelPix.add((Component)this.textContaTransferencia, c);
        ++c.gridx;
        this.panelPix.add((Component)this.lblPix, c);
        ++c.gridx;
        this.panelPix.add((Component)this.textPix, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        this.panelPix.add((Component)this.labelSacado, c);
        ++c.gridx;
        c.gridwidth = 5;
        c.weightx = 0.0;
        this.panelPix.add((Component)this.textSacado, c);
        c.gridx += 5;
        c.gridwidth = 1;
        this.panelPix.add((Component)this.labelDataTransferenciaBancaria, c);
        ++c.gridx;
        this.panelPix.add((Component)this.textDataTransferenciaBancaria, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.panelPix.add((Component)this.buttonDataPix, c);
        this.preencheDadosBanco();
    }

    private void montaPanelTransferenciaBancaria() {
        this.panelTransferenciaBancaria.removeAll();
        this.panelTransferenciaBancaria.setBorder(BorderFactory.createTitledBorder("Transfer\u00eancia Banc\u00e1ria"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(2, 2, 2, 1);
        this.panelTransferenciaBancaria.add((Component)this.lblBanco, c);
        ++c.gridx;
        this.panelTransferenciaBancaria.add((Component)this.textBancoTransferencia, c);
        ++c.gridx;
        this.panelTransferenciaBancaria.add((Component)this.lblAgencia, c);
        ++c.gridx;
        this.panelTransferenciaBancaria.add((Component)this.textAgenciaTransferencia, c);
        ++c.gridx;
        this.panelTransferenciaBancaria.add((Component)this.lblContaCheque, c);
        ++c.gridx;
        this.panelTransferenciaBancaria.add((Component)this.textContaTransferencia, c);
        ++c.gridx;
        this.panelTransferenciaBancaria.add((Component)this.lblTransferenciaBancaria, c);
        ++c.gridx;
        this.panelTransferenciaBancaria.add((Component)this.textTransferenciaBancaria, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        this.panelTransferenciaBancaria.add((Component)this.labelSacado, c);
        ++c.gridx;
        c.gridwidth = 5;
        c.weightx = 0.0;
        this.panelTransferenciaBancaria.add((Component)this.textSacado, c);
        c.gridx += 5;
        c.gridwidth = 1;
        this.panelTransferenciaBancaria.add((Component)this.labelDataTransferenciaBancaria, c);
        ++c.gridx;
        this.panelTransferenciaBancaria.add((Component)this.textDataTransferenciaBancaria, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.panelTransferenciaBancaria.add((Component)this.buttonDataTransferenciaBancaria, c);
        this.preencheDadosBanco();
    }

    private void preencheDadosBanco() {
        LancamentoBean pgto = this.getBeanPreenchido();
        if (pgto != null && pgto.getContaCorrente() != null) {
            ContaCorrenteVO conta = pgto.getContaCorrente();
            ContaCorrenteBean contaBean = null;
            try {
                contaBean = (ContaCorrenteBean)new ContaCorrenteDao().getBean(Variaveis.filialPadrao, String.valueOf(conta.getReduzido()));
            }
            catch (ThreadDaoException e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar os detalhes da conta.", 2);
            }
            if (contaBean != null && contaBean.getTipo() != null && contaBean.getTipo().equalsIgnoreCase("C")) {
                if (Funcoes.textoVazio(this.textBanco)) {
                    this.textBanco.setText(String.valueOf(contaBean.getBanco().getCodigo()));
                }
                if (Funcoes.textoVazio(this.textAgencia)) {
                    this.textAgencia.setText(contaBean.getAgencia().getCodigo());
                }
                if (Funcoes.textoVazio(this.textContaCheque)) {
                    this.textContaCheque.setText(contaBean.getConta());
                }
            }
        }
    }

    private void montaPanelCartao() {
        this.panelCartao.setBorder(BorderFactory.createTitledBorder("Dados Cart\u00e3o"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.panelCartao.add((Component)this.lblValidadeCartao, c);
        ++c.gridx;
        this.panelCartao.add((Component)this.textValidadeCartao, c);
        ++c.gridx;
        this.panelCartao.add((Component)new JLabel("  "), c);
        ++c.gridx;
        this.panelCartao.add((Component)this.lblNumeroCartao, c);
        ++c.gridx;
        this.panelCartao.add((Component)this.textNumeroCartao, c);
        ++c.gridx;
        this.panelCartao.add((Component)new JLabel("  "), c);
        ++c.gridx;
        this.panelCartao.add((Component)this.lblCartaoCredito, c);
        ++c.gridx;
        this.panelCartao.add(this.cbxCartaoCredito, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        this.panelCartao.add((Component)new JPanel(), c);
    }

    private void montaPanelAutDebito() {
        this.panelAutDebito.setBorder(BorderFactory.createTitledBorder("Dados Autoriza\u00e7\u00e3o de D\u00e9bito"));
        this.panelAutDebito.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.panelAutDebito.add((Component)this.labelAutDebito, c);
        ++c.gridx;
        this.panelAutDebito.add((Component)this.textAutDebito, c);
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelAutDebito.add((Component)new JLabel(""), c);
    }

    private void montaPanelPromissoria() {
        this.panelPromissoria.setBorder(BorderFactory.createTitledBorder("Dados Promiss\u00f3ria"));
        this.panelPromissoria.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.panelPromissoria.add((Component)this.labelPromissoria, c);
        ++c.gridx;
        this.panelPromissoria.add((Component)this.textPromissoria, c);
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelPromissoria.add((Component)new JLabel(""), c);
    }

    private void montaDescontoFolha() {
        this.panelDescontoFolha.setBorder(BorderFactory.createTitledBorder("Dados do funcion\u00e1rio"));
        this.panelDescontoFolha.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.panelDescontoFolha.add((Component)this.labelNomeDescFolha, c);
        ++c.gridy;
        this.panelDescontoFolha.add((Component)this.labelSetorDescFolha, c);
        ++c.gridy;
        this.panelDescontoFolha.add((Component)this.labelAutorizadoDescFolha, c);
        c.gridx = 1;
        c.gridy = 0;
        this.panelDescontoFolha.add((Component)this.textNomeDescFolha, c);
        ++c.gridy;
        this.panelDescontoFolha.add((Component)this.textSetorDescFolha, c);
        ++c.gridy;
        this.panelDescontoFolha.add((Component)this.textAutorizadoDescFolha, c);
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelDescontoFolha.add((Component)new JLabel(""), c);
    }

    private void montaPanelCancelado() {
        Font f = this.lblCancelamento.getFont();
        f = new Font(f.getName(), f.getStyle(), 10);
        this.lblCancelamento.setHorizontalAlignment(2);
        this.lblCancelamento.setFont(f);
        this.panelDadosCancelado.setBorder(BorderFactory.createTitledBorder("Dados Cancelamento"));
        this.panelDadosCancelado.add((Component)this.lblCancelamento, "Center");
    }

    @Override
    public void pressioneiF2() {
        if (this.textCodigoContaCorrente.hasFocus()) {
            this.buscaContaCorrente();
        } else if (this.textDataVencimento.hasFocus()) {
            this.buscaDataVencimento();
        } else if (this.textDataCompetencia.hasFocus()) {
            this.buscaDataCompetencia();
        } else if (this.textCodigoHistorico.hasFocus()) {
            this.buscaHistorico();
            if (this.textDescricaoHistoricoUsuario.isEnabled()) {
                this.textDescricaoHistoricoUsuario.grabFocus();
            }
        }
        this.controlaCampos();
        this.visualizarCampos(this.mostrarTela());
    }

    @Override
    public void editar() {
        AbstractThreadBean bean = this.pesquisar();
        if (bean != null) {
            this.limparCampos();
            LancamentoBean lancamento = (LancamentoBean)bean;
            boolean podeAlterar = true;
            if (this.service != null) {
                try {
                    if (lancamento.getCodigo() != null && lancamento.getEstacao() != null) {
                        podeAlterar = !((LancamentoService)this.service).isOrigemBaixa(lancamento);
                    }
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel verificar origem do lan\u00e7amento.\n" + e.getMessage(), e.getStackTrace());
                    podeAlterar = false;
                }
                if (!Funcoes.textoVazio(lancamento.getTipoOrigem())) {
                    if (lancamento.getTipoOrigem().equalsIgnoreCase("P")) {
                        LancamentoBean origem = null;
                        try {
                            origem = ((LancamentoService)this.service).getPagamentoOrigem(lancamento);
                        }
                        catch (Exception e) {
                            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar lan\u00e7amento de origem.\n" + e.getMessage(), e.getStackTrace());
                            podeAlterar = false;
                        }
                        podeAlterar = origem != null ? podeAlterar && origem.getTipoOrigem().equalsIgnoreCase("U") : false;
                    } else {
                        boolean bl = podeAlterar = podeAlterar && lancamento.getTipoOrigem().equalsIgnoreCase("U");
                    }
                }
            }
            if (lancamento.getDataConciliacao() != null || lancamento.getSituacao() != null && lancamento.getSituacao().equalsIgnoreCase("C")) {
                podeAlterar = false;
            }
            if (podeAlterar) {
                this.setStatus(3);
            } else {
                this.setStatus(5);
            }
            this.preencherCampos(bean);
            this.controlaCampos();
            this.visualizarCampos(this.mostrarTela());
            this.controlaBotaoGerarApropriacoes();
            this.painelCentral.grabFocus();
            if (podeAlterar) {
                String s = this.cbxTipoPagamento.getSelectedItem().toString();
                this.textDataVencimento.setEnabled(!s.equalsIgnoreCase(Tipos.tipoPagamento("T")) && !s.equalsIgnoreCase(Tipos.tipoPagamento("P")));
                this.textVencimentoChq.setEnabled(s.equalsIgnoreCase(Tipos.tipoPagamento("T")) || s.equalsIgnoreCase(Tipos.tipoPagamento("P")));
                this.buttonDataVencimento.setEnabled(!s.equalsIgnoreCase(Tipos.tipoPagamento("T")) && !s.equalsIgnoreCase(Tipos.tipoPagamento("P")));
            }
        }
        if (this.cbxTipo.isFocusable()) {
            this.cbxTipo.grabFocus();
        }
    }

    public void editar(LancamentoBean lancamento) {
        this.limparCampos();
        if (lancamento != null) {
            boolean podeAlterar = true;
            if (this.service != null) {
                try {
                    if (lancamento.getCodigo() != null && lancamento.getEstacao() != null) {
                        podeAlterar = !((LancamentoService)this.service).isOrigemBaixa(lancamento);
                    }
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel verificar origem do lan\u00e7amento.\n" + e.getMessage(), e.getStackTrace());
                    podeAlterar = false;
                }
                if (!Funcoes.textoVazio(lancamento.getTipoOrigem())) {
                    if (lancamento.getTipoOrigem().equalsIgnoreCase("P")) {
                        LancamentoBean origem = null;
                        try {
                            origem = ((LancamentoService)this.service).getPagamentoOrigem(lancamento);
                        }
                        catch (Exception e) {
                            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar lan\u00e7amento de origem.\n" + e.getMessage(), e.getStackTrace());
                            podeAlterar = false;
                        }
                        podeAlterar = origem != null ? podeAlterar && origem.getTipoOrigem().equalsIgnoreCase("U") : false;
                    } else {
                        boolean bl = podeAlterar = podeAlterar && lancamento.getTipoOrigem().equalsIgnoreCase("U");
                    }
                }
            }
            if (lancamento.getDataConciliacao() != null || lancamento.getSituacao() != null && lancamento.getSituacao().equalsIgnoreCase("C")) {
                podeAlterar = false;
            }
            if (podeAlterar) {
                this.setStatus(3);
            } else {
                this.setStatus(5);
            }
            this.preencherCampos(lancamento);
            if (this.ocultarCampos || Acesso.getAcesso(ACESSO_NAO_ALTERAR_CONTA_CORRENTE)) {
                this.validaContaCorrentePadrao();
            }
            this.controlaCampos();
            this.controlaBotaoGerarApropriacoes();
            this.painelCentral.grabFocus();
        }
        if (this.cbxTipo.isFocusable()) {
            this.cbxTipo.grabFocus();
        }
    }

    public static LancamentoBean novaInstanciaDialog(Frame owner, LancamentoBean beanPreenchido) {
        JDialog aux = new JDialog(owner, "Alterando Lan\u00e7amento", true);
        aux.setSize(700, 600);
        Lancamento lancto = new Lancamento(false);
        lancto.painelBotoes.setVisible(false);
        lancto.painelCentral.setBorder(ScreenUtil.criarBordaVazia());
        if (beanPreenchido != null) {
            lancto.editar(beanPreenchido);
        }
        Container painelConteudo = aux.getContentPane();
        painelConteudo.setLayout(new BorderLayout());
        painelConteudo.add((Component)lancto, "Center");
        JButton buttonOK = new JButton();
        if (beanPreenchido != null && beanPreenchido.getCodigo() != null && lancto.getStatus() == 3) {
            buttonOK.setText("Salvar");
            buttonOK.setMnemonic('S');
        }
        buttonOK.setVisible(lancto.getStatus() == 3);
        buttonOK.addActionListener(e -> {
            Lancamento.setResultadoModal(1);
            if (lancto.getBeanPreenchido().getCodigo() != null) {
                if (lancto.validaCampos()) {
                    aux.setVisible(false);
                }
            } else {
                aux.setVisible(false);
            }
        });
        JButton buttonCancelar = new JButton("Cancelar");
        buttonCancelar.setMnemonic('C');
        buttonCancelar.addActionListener(e -> {
            Lancamento.setResultadoModal(-1);
            aux.setVisible(false);
        });
        JPanel panelBotoes = new JPanel();
        panelBotoes.setLayout(new FlowLayout(2));
        panelBotoes.add(buttonOK);
        panelBotoes.add(buttonCancelar);
        painelConteudo.add((Component)panelBotoes, "South");
        aux.setLocationRelativeTo(Laboratorio.getInstancia());
        aux.setVisible(true);
        LancamentoBean auxRetorno = lancto.getBeanPreenchido();
        if (lancto.getResultadoModal() == 1) {
            return auxRetorno;
        }
        return null;
    }

    public static void setResultadoModal(int resultado) {
        resultadoModal = resultado;
    }

    public int getResultadoModal() {
        return resultadoModal;
    }

    @Override
    public void novo() {
        super.novo();
        this.cbxTipoJuro.setSelectedItem(Tipos.tipoJuros("V"));
        this.textValor.setText(Funcoes.formataDecimal(0.0));
        this.textJuro.setText(Funcoes.formataDecimal(0.0));
        this.textDesconto.setText(Funcoes.formataDecimal(0.0));
        this.textAcrescimo.setText(Funcoes.formataDecimal(0.0));
        this.textMulta.setText(Funcoes.formataDecimal(0.0));
        this.labelValorTotal.setText(Funcoes.formataDecimal(0.0));
        if (this.ocultarCampos) {
            this.cbxTipo.setSelectedItem(Tipos.getTipoCartao("D"));
        }
        this.cbxTipoPagamento.setSelectedIndex(0);
        this.tipoOrigem = "U";
        this.controlaBotaoGerarApropriacoes();
        if (this.cbxTipo.isFocusable()) {
            this.cbxTipo.grabFocus();
        }
        this.visualizarCampos(this.mostrarTela());
        this.validaContaCorrentePadrao();
        if (!Acesso.getAcesso(ACESSO_NAO_ALTERAR_CONTA_CORRENTE)) {
            this.textCodigoContaCorrente.setEnabled(true);
        }
    }

    private void buscaDataValidadeCartao() {
        Funcoes.mostraData(this.textValidadeCartao, this.buttonDataValidadeCartao, this.painelCentral, true);
    }

    private void buscaDataVencimento() {
        Funcoes.mostraData(this.textDataVencimento, this.buttonDataVencimento, this.painelCentral, true);
    }

    private void buscaVencimentoChq() {
        Funcoes.mostraData(this.textVencimentoChq, this.buttonVencimentoChq, this.panelCheque, true);
    }

    private void buscaDataPix() {
        Funcoes.mostraData(this.textDataTransferenciaBancaria, this.buttonDataPix, this.panelPix, true);
    }

    private void buscaDataTransferencia() {
        Funcoes.mostraData(this.textDataTransferenciaBancaria, this.buttonDataTransferenciaBancaria, this.panelTransferenciaBancaria, true);
    }

    private void buscaDataCompetencia() {
        Funcoes.mostraData(this.textDataCompetencia, this.buttonDataCompetencia, this.painelCentral, true);
    }

    @Override
    public AbstractThreadBean buscaBeanPreenchido(PanelPlanoContaCentroCusto source) {
        return this.getBeanPreenchido();
    }

    @Override
    public void excluir() {
        LancamentoBean aux = this.getBeanPreenchido();
        if (!Funcoes.textoVazio(aux.getSituacao())) {
            if (aux.getSituacao().equalsIgnoreCase("O")) {
                Funcoes.mensagem(this, "O Lan\u00e7amento est\u00e1 Conciliado.\nN\u00e3o \u00e9 permitido excluir o lan\u00e7amento.", 2);
                return;
            }
            if (aux.getSituacao().equalsIgnoreCase("C")) {
                Funcoes.mensagem(this, "O Lan\u00e7amento est\u00e1 Cancelado.\nN\u00e3o \u00e9 permitido excluir o lan\u00e7amento.", 2);
                return;
            }
        }
        boolean podeExcluir = false;
        if (!Funcoes.textoVazio(aux.getTipoOrigem())) {
            if (aux.getTipoOrigem().equalsIgnoreCase("P")) {
                LancamentoBean origem = null;
                try {
                    origem = ((LancamentoService)this.service).getPagamentoOrigem(aux);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar lan\u00e7amento de origem.\n" + e.getMessage(), e.getStackTrace());
                    podeExcluir = false;
                }
                if (origem != null) {
                    podeExcluir = podeExcluir && origem.getTipoOrigem().equalsIgnoreCase("U");
                }
            } else {
                boolean bl = podeExcluir = podeExcluir && aux.getTipoOrigem().equalsIgnoreCase("U");
            }
            if (!podeExcluir) {
                Funcoes.mensagem(this, "A origem do Lan\u00e7amento \u00e9 \"" + Tipos.tipoOrigemLancamento(aux.getTipoOrigem()) + "\".\nN\u00e3o \u00e9 permitido excluir o lan\u00e7amento.", 2);
                return;
            }
        }
        super.excluir();
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public void salvar(boolean limparCampos) {
        this.salvarLancamento(limparCampos, false, null, null);
    }

    public void salvarLancamento(boolean limparCampos, boolean conciliar, ContaCorrenteVO contaCorrente, Date dataConciliacao) {
        LancamentoBean bean;
        boolean continuar = true;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                this.service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = bean.getCodigo().toString();
                if (conciliar) {
                    continuar = ((LancamentoService)this.service).conciliarLancamentoConta(bean, contaCorrente, dataConciliacao);
                }
                if (continuar) {
                    StringBuilder mensagem = new StringBuilder("Lan\u00e7amento gravado com o c\u00f3digo ");
                    mensagem.append(this.retornoParaPesquisa);
                    Funcoes.mensagem(this, mensagem.toString(), 5);
                    Conexao.arquivaSQL();
                    if (limparCampos) {
                        this.limparCampos();
                        this.setStatus(1);
                        this.controlaCampos();
                        this.visualizarCampos(this.mostrarTela());
                    }
                } else {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel efetuar a concilia\u00e7\u00e3o do lan\u00e7amento", 2);
                }
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "FrmCadPadraoBean:86");
            }
        }
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "lcx_codigo";
    }

    protected void inserirAcaoDeTecla(String key_stroke, String action_name, AbstractAction action) {
        this.getInputMap(0).put(KeyStroke.getKeyStroke(key_stroke), action_name);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(key_stroke), action_name);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(key_stroke), action_name);
        this.getActionMap().put(action_name, action);
    }

    private boolean mostrarTela() {
        return !this.ocultarCampos;
    }
}

