/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.lancamentos.Baixa;
import jalis.model.bean.financeiro.BaixaBean;
import jalis.model.vo.financeiro.BaixaVO;
import jalis.service.financeiro.BaixaService;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EstornoBaixa
extends FrmPadrao
implements ActionListener {
    private Baixa baixaBean = null;
    private JPanel panelBusca = new JPanel();
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    private JButton buttonEstornar = ComponenteFactory.novoJButton("Estornar", 'E', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JLabel labelBaixa = new JLabel("Baixa:");
    private TTextField textBaixa = new TTextField(8, 1);
    private JButton buttonBuscaBaixa = new JButton();
    private static int STATUS_NONE = 0;
    private static int STATUS_BAIXA_NOT_SEL = 1;
    private static int STATUS_BAIXA_SEL = 2;
    private int status = STATUS_NONE;

    public EstornoBaixa() {
        this.montaTela();
        this.atualizaCamposBotoes();
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600400700");
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Estorno de Baixa", "Estorna uma baixa j\u00e1 realizada", "financeiro/estorno_baixa.jpg");
        this.panelBusca.setLayout(new GridBagLayout());
        this.baixaBean = new Baixa("", "", false, false, false, 1.0f);
        Component[] botoes = new JButton[]{this.buttonNovo, this.buttonEstornar, this.buttonCancelar, this.buttonFechar};
        JPanel panelPrinc = new JPanel();
        this.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, botoes), "South");
        this.add((Component)panelPrinc, "Center");
        this.buttonBuscaBaixa.setFocusable(false);
        this.buttonBuscaBaixa.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaBaixa.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaBaixa.setMaximumSize(new Dimension(20, 20));
        Funcoes.imagemPesquisa(this.buttonBuscaBaixa);
        this.buttonBuscaBaixa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaixaService service = new BaixaService();
                BaixaVO baixaVO = new BaixaVO();
                baixaVO = (BaixaVO)service.pesquisaSomenteQuitadasVO(Laboratorio.getInstancia(), baixaVO, "Busca de Baixas", false);
                if (baixaVO == null) {
                    return;
                }
                try {
                    BaixaBean aux = (BaixaBean)service.getSomenteQuitados(String.valueOf(baixaVO.getFilial().getCodigo()), String.valueOf(baixaVO.getCodigo()));
                    EstornoBaixa.this.baixaBean.setBloqueiaAlteracoes(true);
                    EstornoBaixa.this.baixaBean.preencherCampos(aux);
                    EstornoBaixa.this.textBaixa.setText(String.valueOf(aux.getCodigo()));
                    EstornoBaixa.this.status = STATUS_BAIXA_SEL;
                    EstornoBaixa.this.atualizaCamposBotoes();
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar Baixa. EstornoBaixa:buttonBuscaBaixa:95  " + ex.getMessage(), ex.getStackTrace());
                }
            }
        });
        this.textBaixa.setPreferredSize(new Dimension(100, 20));
        this.textBaixa.setMinimumSize(new Dimension(100, 20));
        this.textBaixa.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    EstornoBaixa.this.buttonBuscaBaixa.doClick();
                } else if (e.getKeyCode() == 10 && !EstornoBaixa.this.textBaixa.getText().isEmpty()) {
                    try {
                        BaixaBean aux = (BaixaBean)new BaixaService().getSomenteQuitados(Variaveis.filialPadrao, EstornoBaixa.this.textBaixa.getText());
                        if (aux == null) {
                            Funcoes.mensagem(Laboratorio.getInstancia(), "Baixa n\u00e3o encontrada.", 2);
                            Conexao.anulaSQL();
                            return;
                        }
                        EstornoBaixa.this.baixaBean.setBloqueiaAlteracoes(true);
                        EstornoBaixa.this.baixaBean.preencherCampos(aux);
                        EstornoBaixa.this.textBaixa.setText(String.valueOf(aux.getCodigo()));
                        EstornoBaixa.this.status = STATUS_BAIXA_SEL;
                        EstornoBaixa.this.atualizaCamposBotoes();
                    }
                    catch (Exception ex) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel abrir baixa.", 2);
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        return;
                    }
                }
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.insets = new Insets(2, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.panelBusca.add((Component)this.labelBaixa, c);
        c.insets = new Insets(1, 1, 1, 1);
        ++c.gridx;
        this.panelBusca.add((Component)this.textBaixa, c);
        ++c.gridx;
        this.panelBusca.add((Component)this.buttonBuscaBaixa, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelBusca.add((Component)new JLabel(""), c);
        panelPrinc.setLayout(new BorderLayout());
        panelPrinc.add((Component)this.panelBusca, "North");
        panelPrinc.add((Component)this.baixaBean, "Center");
        this.atualizaCamposBotoes();
    }

    private boolean estornarBaixa() {
        String result = null;
        try {
            result = new BaixaService().estornarBaixa(this.baixaBean.getBeanEstorno());
            if (!Funcoes.textoVazio(result)) {
                Conexao.anulaSQL();
                Funcoes.mensagem(this, result, 2);
                return false;
            }
            Conexao.arquivaSQL();
            return true;
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel estornar baixa.\n" + e.getMessage(), e.getStackTrace());
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonNovo) {
            this.novo();
        } else if (e.getSource() == this.buttonCancelar) {
            this.cancelar();
        } else if (e.getSource() == this.buttonEstornar) {
            this.estornar();
        }
    }

    private void novo() {
        this.limpaCampos();
        this.status = STATUS_BAIXA_NOT_SEL;
        this.atualizaCamposBotoes();
        if (this.textBaixa.isFocusable()) {
            this.textBaixa.grabFocus();
        }
    }

    private void cancelar() {
        this.limpaCampos();
        this.status = STATUS_NONE;
        this.atualizaCamposBotoes();
    }

    private void estornar() {
        if (this.estornarBaixa()) {
            Funcoes.mensagem(this, "Baixa estornada com sucesso.", 5);
            this.novo();
        } else {
            this.cancelar();
        }
    }

    private void limpaCampos() {
        this.textBaixa.setText("");
        if (this.baixaBean != null) {
            this.baixaBean.limparCampos();
        }
    }

    private void atualizaCamposBotoes() {
        this.buttonFechar.setEnabled(true);
        if (this.status == STATUS_NONE) {
            this.textBaixa.setEnabled(false);
            this.buttonBuscaBaixa.setEnabled(false);
            this.buttonNovo.setEnabled(true);
            this.buttonEstornar.setEnabled(false);
            this.buttonCancelar.setEnabled(false);
        } else if (this.status == STATUS_BAIXA_NOT_SEL) {
            this.textBaixa.setEnabled(true);
            this.buttonBuscaBaixa.setEnabled(true);
            this.buttonNovo.setEnabled(false);
            this.buttonEstornar.setEnabled(false);
            this.buttonCancelar.setEnabled(false);
        } else if (this.status == STATUS_BAIXA_SEL) {
            this.textBaixa.setEnabled(false);
            this.buttonBuscaBaixa.setEnabled(false);
            this.buttonNovo.setEnabled(false);
            this.buttonEstornar.setEnabled(true);
            this.buttonCancelar.setEnabled(true);
        }
    }
}

