/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos;

import jalis.comum.Tipos;
import jalis.laboratorio.Laboratorio;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class EscolhaParcela
extends JDialog {
    private JTable tableParcelas = null;
    private JScrollPane scrollParcelas = null;
    private ModeloGridTable modelParcelas = null;
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JButton buttonOK = new JButton("OK");
    private final int COLUNA_TIPO_DOC = 0;
    private final int COLUNA_NUMERO_DOC = 1;
    private final int COLUNA_PARCELA = 2;
    private final int COLUNA_VENCIMENTO = 3;
    private final int COLUNA_VL_BRUTO = 4;
    private final int COLUNA_VL_LIQUIDO = 5;
    private final int COLUNA_OBJETO = 6;
    private ReceberPagarBean retorno = null;

    public EscolhaParcela(ArrayList<ReceberPagarBean> parcelas) {
        super(Laboratorio.getInstancia(), "Escolha a parcela", true);
        this.montaTela();
        for (int i = 0; i < parcelas.size(); ++i) {
            ReceberPagarBean aux = parcelas.get(i);
            if (aux.isRemover()) continue;
            this.modelParcelas.addLine(new Object[]{Tipos.tipoDocumento(aux.getTipoDocumento()), aux.getNumeroDocumento(), aux.getParcela(), Funcoes.formataData("dd/MM/yyyy", aux.getDataVencimento()), Funcoes.formataDecimal(aux.getValor()), Funcoes.formataDecimal(aux.getValorTotal()), aux});
        }
    }

    private void montaTela() {
        this.setSize(new Dimension(500, 200));
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.modelParcelas = new ModeloGridTable(new String[]{"Tipo Doc.", "N\u00fam. Doc.", "Parc.", "Vencimento", "Vl. Bruto", "Vl. L\u00edquido", "Objeto"}){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                EscolhaParcela.this.tableParcelas.removeColumn(EscolhaParcela.this.tableParcelas.getColumnModel().getColumn(6));
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        this.tableParcelas = new JTable(this.modelParcelas);
        this.modelParcelas.setColumnSize(new int[]{100, 90, 50, 90, 85, 85, 0}, this.tableParcelas);
        this.tableParcelas.getTableHeader().addMouseListener(this.modelParcelas);
        this.tableParcelas.removeColumn(this.tableParcelas.getColumnModel().getColumn(6));
        this.scrollParcelas = new JScrollPane(this.tableParcelas);
        this.add((Component)this.scrollParcelas, "Center");
        this.panelBotoes.add(this.buttonOK);
        this.add((Component)this.panelBotoes, "South");
        this.buttonOK.setMnemonic('O');
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = EscolhaParcela.this.tableParcelas.getSelectedRow();
                if (row < 0) {
                    Funcoes.mensagem(EscolhaParcela.this, "Uma parcela deve ser selecionada.", 2);
                    return;
                }
                EscolhaParcela.this.retorno = (ReceberPagarBean)EscolhaParcela.this.modelParcelas.getValueAt(row, 6);
                EscolhaParcela.this.setVisible(false);
            }
        });
        Funcoes.montaEnter((JComponent)this.getContentPane());
        ScreenUtil.centralizar(this);
    }

    public ReceberPagarBean getParcelaSelecionada() {
        return this.retorno;
    }
}

