/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos;

import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.BandeirasCartoes;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.model.bean.cadastro.financeiro.ContaCorrenteBean;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.model.dao.cadastro.financeiro.ContaCorrenteDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.financeiro.ContaCorrenteVO;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class DialogDetalhesObservacao
extends JDialog
implements ActionListener,
KeyListener {
    private JTextArea txtObs = new JTextArea();
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JComboBox comboCartaoCredito = new JComboBox();
    private JButton buttonSalvar = new JButton("OK");
    private JButton buttonFechar = new JButton("Cancelar");
    private JLabel lblValidadeCartao = new JLabel("Validade:");
    private JLabel lblNumeroCartao = new JLabel("N\u00famero Cart\u00e3o:");
    private JLabel lblCartaoCredito = new JLabel("Bandeira:");
    private JLabel lblBanco = new JLabel("Banco:");
    private JLabel lblAgencia = new JLabel("Ag\u00eancia:");
    private JLabel lblContaCheque = new JLabel("Conta:");
    private JLabel lblNumeroCheque = new JLabel("Cheque:");
    private JLabel lblPix = new JLabel("Pix:");
    private JLabel lblAutorizacao = new JLabel("C\u00f3digo Autoriza\u00e7\u00e3o:");
    private JLabel lblSacado = new JLabel("Sacado:");
    private JLabel lblVctoChequePre = new JLabel("Vencimento:");
    private JLabel lblNomeFuncionario = new JLabel("Nome Funcion\u00e1rio:");
    private JLabel lblTransferencia = new JLabel("Transfer\u00eancia: ");
    private JLabel lblDataTransferencia = new JLabel("Data: ");
    private TTextField textContaTransferencia = new TTextField(15, 1);
    private TTextField textBancoTransferencia = new TTextField(3, 1);
    private TTextField textAgenciaTransferencia = new TTextField(5, 1);
    private TTextField textTransferencia = new TTextField(5, 3);
    private TTextField textDataTransferencia = new TTextField(12, 4);
    private TTextField textPix = new TTextField(50, 3);
    private TTextField textNumeroCheque = new TTextField(20, 3);
    private TTextField textValidadeCartao = new TTextField(10, 4);
    private TTextField textNumeroCartao = new TTextField(16, 3);
    private TTextField textContaCheque = new TTextField(20, 3);
    private TTextField textBanco = new TTextField(5, 1);
    private TTextField textAgencia = new TTextField(10, 3);
    private TTextField textAutorizacao = new TTextField(40, 3);
    private TTextField textSacado = new TTextField(80, 3);
    private TTextField textVctoChequePre = new TTextField(10, 4);
    private TTextField textNomeFuncionario = new TTextField(40, 3);
    private BandeirasCartoes[] cartoes = FinanceiroUtil.getCartoesCredito();
    private LancamentoBean pgto = null;
    private int tipoDialog = 0;

    public DialogDetalhesObservacao(LancamentoBean pgto, int tipoDialog) {
        if (pgto == null) {
            this.setVisible(false);
            return;
        }
        this.pgto = pgto;
        this.tipoDialog = tipoDialog;
        this.setModal(true);
        this.setLayout(new BorderLayout());
        if (this.cartoes == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Nenhuma bandeira de cart\u00e3o configurada.", 2);
        } else {
            for (int i = 0; i < this.cartoes.length; ++i) {
                this.comboCartaoCredito.addItem(this.cartoes[i]);
            }
        }
        JPanel painelPrincipal = new JPanel();
        painelPrincipal.setBorder(ScreenUtil.criarBordaVazia());
        if (tipoDialog == 6) {
            this.montaObservacao(painelPrincipal);
        } else if (tipoDialog == 3) {
            this.montaAutDebito(painelPrincipal);
        } else if (tipoDialog == 7) {
            this.montaCartao(painelPrincipal, 7);
        } else if (tipoDialog == 8) {
            this.montaCartao(painelPrincipal, 8);
        } else if (tipoDialog == 2) {
            this.montaCheque(painelPrincipal, 0);
        } else if (tipoDialog == 4) {
            this.montaCheque(painelPrincipal, 4);
        } else if (tipoDialog == 5) {
            this.montaCheque(painelPrincipal, 5);
        } else if (tipoDialog == 9) {
            this.montaTransferenciaBancaria(painelPrincipal, 9);
        } else if (tipoDialog == 10) {
            this.montaPix(painelPrincipal, 10);
        }
        painelPrincipal.setBorder(BorderFactory.createTitledBorder(""));
        this.add((Component)painelPrincipal, "Center");
        this.add((Component)this.panelBotoes, "South");
        this.buttonSalvar.setMnemonic('O');
        this.buttonFechar.setMnemonic('C');
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonFechar);
        this.buttonSalvar.addActionListener(this);
        this.buttonFechar.addActionListener(this);
        this.setLocationRelativeTo(Laboratorio.getInstancia());
        Funcoes.montaEnter(painelPrincipal, this.panelBotoes);
        this.setVisible(true);
    }

    private void montaObservacao(JPanel painelPrincipal) {
        this.setSize(new Dimension(300, 200));
        this.setTitle("Observa\u00e7\u00e3o");
        BorderLayout layout = new BorderLayout();
        layout.setHgap(2);
        layout.setVgap(2);
        painelPrincipal.setLayout(layout);
        this.txtObs.setWrapStyleWord(true);
        this.txtObs.setLineWrap(true);
        painelPrincipal.add((Component)this.txtObs, "Center");
        this.txtObs.setText(this.pgto.getObservacao());
    }

    private void montaAutDebito(JPanel painelPrincipal) {
        this.setSize(new Dimension(400, 100));
        this.setTitle("Detalhes Aut. D\u00e9bito");
        Dimension d = new Dimension(200, 25);
        this.textAutorizacao.setSize(d);
        this.textAutorizacao.setPreferredSize(d);
        this.textAutorizacao.setMinimumSize(d);
        painelPrincipal.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 0);
        painelPrincipal.add((Component)this.lblAutorizacao, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 1;
        painelPrincipal.add((Component)this.textAutorizacao, c);
        this.textAutorizacao.setText(this.pgto.getNumeroDocumento());
    }

    private void montaDescontoFolha(JPanel painelPrincipal) {
        this.setSize(new Dimension(400, 90));
        this.setTitle("Desconto em Folha");
        Dimension d = new Dimension(200, 20);
        this.textNomeFuncionario.setSize(d);
        this.textNomeFuncionario.setPreferredSize(d);
        this.textNomeFuncionario.setMinimumSize(d);
        painelPrincipal.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 0);
        painelPrincipal.add((Component)this.lblNomeFuncionario, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 1;
        painelPrincipal.add((Component)this.textNomeFuncionario, c);
        if (Funcoes.textoVazio(this.textNomeFuncionario)) {
            this.textNomeFuncionario.setText(this.pgto.getNomePagador());
        }
    }

    private void montaTransferenciaBancaria(JPanel painelPrincipal, int tipoCheque) {
        this.setTitle("Transfer\u00eancia Banc\u00e1ria");
        this.setSize(new Dimension(350, 170));
        Dimension d = new Dimension(65, 20);
        this.textBancoTransferencia.setPreferredSize(d);
        this.textBancoTransferencia.setMinimumSize(d);
        d = new Dimension(90, 20);
        this.textAgenciaTransferencia.setPreferredSize(d);
        this.textAgenciaTransferencia.setMinimumSize(d);
        this.textContaTransferencia.setPreferredSize(d);
        this.textContaTransferencia.setMinimumSize(d);
        this.textTransferencia.setPreferredSize(d);
        this.textTransferencia.setMinimumSize(d);
        this.textDataTransferencia.setPreferredSize(d);
        this.textDataTransferencia.setMinimumSize(d);
        d = new Dimension(270, 20);
        this.textSacado.setPreferredSize(d);
        this.textSacado.setMinimumSize(d);
        painelPrincipal.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 0);
        painelPrincipal.add((Component)this.lblBanco, c);
        ++c.gridx;
        painelPrincipal.add((Component)this.textBancoTransferencia, c);
        ++c.gridx;
        c.insets = new Insets(1, 5, 1, 0);
        painelPrincipal.add((Component)this.lblAgencia, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 0);
        painelPrincipal.add((Component)this.textAgenciaTransferencia, c);
        ++c.gridy;
        c.gridx = 0;
        painelPrincipal.add((Component)this.lblContaCheque, c);
        ++c.gridx;
        painelPrincipal.add((Component)this.textContaTransferencia, c);
        ++c.gridx;
        c.insets = new Insets(1, 5, 1, 0);
        painelPrincipal.add((Component)this.lblTransferencia, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 0);
        painelPrincipal.add((Component)this.textTransferencia, c);
        ++c.gridy;
        c.gridx = 0;
        painelPrincipal.add((Component)this.lblDataTransferencia, c);
        ++c.gridx;
        painelPrincipal.add((Component)this.textDataTransferencia, c);
        ++c.gridy;
        c.gridx = 0;
        painelPrincipal.add((Component)this.lblSacado, c);
        ++c.gridx;
        c.gridwidth = 4;
        c.fill = 2;
        painelPrincipal.add((Component)this.textSacado, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 6;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        painelPrincipal.add((Component)new JPanel(), c);
        this.textBancoTransferencia.setText(String.valueOf(this.pgto.getBanco()));
        this.textAgenciaTransferencia.setText(this.pgto.getAgencia());
        this.textContaTransferencia.setText(this.pgto.getConta());
        this.textSacado.setText(this.pgto.getSacado());
        this.textTransferencia.setText(this.pgto.getTipoTransferencia());
        this.textDataTransferencia.setText(Funcoes.formataData("dd/MM/yyyy", this.pgto.getDataVencimento()));
        this.preencheDadosBanco();
    }

    private void montaPix(JPanel painelPrincipal, int tipoCheque) {
        this.setTitle("Pix");
        this.setSize(new Dimension(350, 170));
        Dimension d = new Dimension(65, 20);
        this.textBancoTransferencia.setPreferredSize(d);
        this.textBancoTransferencia.setMinimumSize(d);
        d = new Dimension(90, 20);
        this.textAgenciaTransferencia.setPreferredSize(d);
        this.textAgenciaTransferencia.setMinimumSize(d);
        this.textContaTransferencia.setPreferredSize(d);
        this.textContaTransferencia.setMinimumSize(d);
        this.textPix.setPreferredSize(d);
        this.textPix.setMinimumSize(d);
        this.textDataTransferencia.setPreferredSize(d);
        this.textDataTransferencia.setMinimumSize(d);
        d = new Dimension(270, 20);
        this.textSacado.setPreferredSize(d);
        this.textSacado.setMinimumSize(d);
        painelPrincipal.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 0);
        painelPrincipal.add((Component)this.lblBanco, c);
        ++c.gridx;
        painelPrincipal.add((Component)this.textBancoTransferencia, c);
        ++c.gridx;
        c.insets = new Insets(1, 5, 1, 0);
        painelPrincipal.add((Component)this.lblAgencia, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 0);
        painelPrincipal.add((Component)this.textAgenciaTransferencia, c);
        ++c.gridy;
        c.gridx = 0;
        painelPrincipal.add((Component)this.lblContaCheque, c);
        ++c.gridx;
        painelPrincipal.add((Component)this.textContaTransferencia, c);
        ++c.gridx;
        c.insets = new Insets(1, 5, 1, 0);
        painelPrincipal.add((Component)this.lblPix, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 0);
        painelPrincipal.add((Component)this.textPix, c);
        ++c.gridy;
        c.gridx = 0;
        painelPrincipal.add((Component)this.lblDataTransferencia, c);
        ++c.gridx;
        painelPrincipal.add((Component)this.textDataTransferencia, c);
        ++c.gridy;
        c.gridx = 0;
        painelPrincipal.add((Component)this.lblSacado, c);
        ++c.gridx;
        c.gridwidth = 4;
        c.fill = 2;
        painelPrincipal.add((Component)this.textSacado, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 6;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        painelPrincipal.add((Component)new JPanel(), c);
        this.textBancoTransferencia.setText(String.valueOf(this.pgto.getBanco()));
        this.textAgenciaTransferencia.setText(this.pgto.getAgencia());
        this.textContaTransferencia.setText(this.pgto.getConta());
        this.textSacado.setText(this.pgto.getSacado());
        this.textPix.setText(this.pgto.getPix());
        this.textDataTransferencia.setText(Funcoes.formataData("dd/MM/yyyy", this.pgto.getDataVencimento()));
        this.preencheDadosBanco();
    }

    private void montaCheque(JPanel painelPrincipal, int tipoCheque) {
        this.setTitle("Detalhes Cheque");
        this.setSize(new Dimension(330, 125));
        Dimension d = new Dimension(65, 20);
        this.textBanco.setPreferredSize(d);
        this.textBanco.setMinimumSize(d);
        d = new Dimension(90, 20);
        this.textAgencia.setPreferredSize(d);
        this.textAgencia.setMinimumSize(d);
        this.textContaCheque.setPreferredSize(d);
        this.textContaCheque.setMinimumSize(d);
        this.textNumeroCheque.setPreferredSize(d);
        this.textNumeroCheque.setMinimumSize(d);
        this.textVctoChequePre.setPreferredSize(d);
        this.textVctoChequePre.setMinimumSize(d);
        painelPrincipal.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 0);
        painelPrincipal.add((Component)this.lblBanco, c);
        ++c.gridx;
        painelPrincipal.add((Component)this.textBanco, c);
        ++c.gridx;
        JPanel aux1 = new JPanel();
        d = new Dimension(20, 20);
        aux1.setPreferredSize(d);
        aux1.setMinimumSize(d);
        painelPrincipal.add((Component)aux1, c);
        ++c.gridx;
        painelPrincipal.add((Component)this.lblAgencia, c);
        ++c.gridx;
        painelPrincipal.add((Component)this.textAgencia, c);
        ++c.gridy;
        c.gridx = 0;
        painelPrincipal.add((Component)this.lblContaCheque, c);
        ++c.gridx;
        painelPrincipal.add((Component)this.textContaCheque, c);
        c.gridx += 2;
        painelPrincipal.add((Component)this.lblNumeroCheque, c);
        ++c.gridx;
        painelPrincipal.add((Component)this.textNumeroCheque, c);
        if (tipoCheque == 4) {
            this.setTitle("Detalhes Cheque Pr\u00e9-Datado");
            this.setSize(new Dimension(360, 160));
            ++c.gridy;
            c.gridx = 0;
            painelPrincipal.add((Component)this.lblVctoChequePre, c);
            ++c.gridx;
            c.gridwidth = 1;
            c.fill = 2;
            painelPrincipal.add((Component)this.textVctoChequePre, c);
        }
        if (tipoCheque == 5 || tipoCheque == 4) {
            this.setTitle("Detalhes Cheque de Terceiro");
            if (tipoCheque == 4) {
                this.setSize(new Dimension(360, 160));
            } else {
                this.setSize(new Dimension(330, 140));
            }
            ++c.gridy;
            c.gridx = 0;
            painelPrincipal.add((Component)this.lblSacado, c);
            ++c.gridx;
            c.gridwidth = 4;
            c.fill = 2;
            painelPrincipal.add((Component)this.textSacado, c);
        }
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 6;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        painelPrincipal.add((Component)new JPanel(), c);
        this.textBanco.setText(String.valueOf(this.pgto.getBanco()));
        this.textAgencia.setText(this.pgto.getAgencia());
        this.textContaCheque.setText(this.pgto.getConta());
        this.textNumeroCheque.setText(this.pgto.getNumeroCheque());
        this.textSacado.setText(this.pgto.getSacado());
        this.textVctoChequePre.setText(Funcoes.formataData("dd/MM/yyyy", this.pgto.getDataVencimento()));
        this.preencheDadosBanco();
    }

    private void preencheDadosBanco() {
        if (this.pgto != null && this.pgto.getContaCorrente() != null) {
            ContaCorrenteVO conta = this.pgto.getContaCorrente();
            ContaCorrenteBean contaBean = null;
            try {
                contaBean = (ContaCorrenteBean)new ContaCorrenteDao().getBean(Variaveis.filialPadrao, String.valueOf(conta.getReduzido()));
            }
            catch (ThreadDaoException e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar os detalhes da conta.", 2);
            }
            if (contaBean != null && contaBean.getTipo() != null && contaBean.getTipo().equalsIgnoreCase("C")) {
                if (Funcoes.textoVazio(this.textBanco)) {
                    this.textBanco.setText(String.valueOf(contaBean.getBanco().getCodigo()));
                }
                if (Funcoes.textoVazio(this.textAgencia)) {
                    this.textAgencia.setText(contaBean.getAgencia().getCodigo());
                }
                if (Funcoes.textoVazio(this.textContaCheque)) {
                    this.textContaCheque.setText(contaBean.getConta());
                }
            }
        }
    }

    private void montaCartao(JPanel painelPrincipal, int tipoOperacao) {
        BandeirasCartoes aux;
        int i;
        this.setSize(new Dimension(440, 120));
        this.comboCartaoCredito.removeAllItems();
        if (tipoOperacao == 7) {
            this.setTitle("Detalhes do Cart\u00e3o de D\u00e9bito");
            for (i = 0; i < this.cartoes.length; ++i) {
                aux = this.cartoes[i];
                if (!aux.getOperacao().equalsIgnoreCase("D")) continue;
                this.comboCartaoCredito.addItem(aux);
            }
        } else {
            this.setTitle("Detalhes do Cart\u00e3o de Cr\u00e9dito");
            for (i = 0; i < this.cartoes.length; ++i) {
                aux = this.cartoes[i];
                if (!aux.getOperacao().equalsIgnoreCase("C")) continue;
                this.comboCartaoCredito.addItem(aux);
            }
        }
        Dimension d = new Dimension(100, 20);
        this.textValidadeCartao.setSize(d);
        this.textValidadeCartao.setPreferredSize(d);
        this.textValidadeCartao.setMinimumSize(d);
        d = new Dimension(150, 20);
        this.textNumeroCartao.setSize(d);
        this.textNumeroCartao.setPreferredSize(d);
        this.textNumeroCartao.setMinimumSize(d);
        d = new Dimension(110, 20);
        this.comboCartaoCredito.setSize(d);
        this.comboCartaoCredito.setPreferredSize(d);
        this.comboCartaoCredito.setMinimumSize(d);
        painelPrincipal.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 0);
        painelPrincipal.add((Component)this.lblValidadeCartao, c);
        ++c.gridx;
        painelPrincipal.add((Component)this.textValidadeCartao, c);
        ++c.gridx;
        painelPrincipal.add((Component)this.lblNumeroCartao, c);
        ++c.gridx;
        painelPrincipal.add((Component)this.textNumeroCartao, c);
        ++c.gridy;
        c.gridx = 0;
        painelPrincipal.add((Component)this.lblCartaoCredito, c);
        ++c.gridx;
        painelPrincipal.add((Component)this.comboCartaoCredito, c);
        this.listener();
        if (this.pgto.getValidadeCartao() != null) {
            this.textValidadeCartao.setText(Funcoes.formataData(this.pgto.getValidadeCartao()));
        }
        this.textNumeroCartao.setText(this.pgto.getNumeroCartao());
        if (this.pgto.getCartaoCredito() == null || this.pgto.getCartaoCredito().equals("")) {
            this.comboCartaoCredito.setSelectedIndex(0);
        } else {
            String aux2 = this.pgto.getCartaoCredito();
            for (int i2 = 0; i2 < this.comboCartaoCredito.getItemCount(); ++i2) {
                BandeirasCartoes bandeira = (BandeirasCartoes)this.comboCartaoCredito.getItemAt(i2);
                if (!bandeira.toString().equals(aux2)) continue;
                this.comboCartaoCredito.setSelectedIndex(i2);
                break;
            }
        }
    }

    private void listener() {
        this.textValidadeCartao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary() && !DialogDetalhesObservacao.this.validarData(DialogDetalhesObservacao.this.textValidadeCartao.getText())) {
                    Funcoes.mensagem(DialogDetalhesObservacao.this, "A data de Validade do cart\u00e3o \u00e9 inferior a Data Atual. Efetuar a corre\u00e7\u00e3o", 2);
                    ScreenUtil.requisitarFoco(DialogDetalhesObservacao.this.textValidadeCartao);
                    return;
                }
            }
        });
    }

    private boolean validarData(String data) {
        if (!Funcoes.textoVazio(data) && Funcoes.verificaData(data)) {
            int mesAtual = Funcoes.retornaMes(new Date());
            int anoAtual = Funcoes.retornaAno(new Date());
            Date mesInformado = Funcoes.getData("dd/MM/yyyy", data);
            int mes = Funcoes.retornaMes(mesInformado);
            int ano = Funcoes.retornaAno(mesInformado);
            if (anoAtual > ano || mesAtual > mes && anoAtual == ano) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonSalvar) {
            if (this.tipoDialog == 3) {
                this.setDadosAutDebito(this.pgto);
                this.setVisible(false);
            } else if (this.tipoDialog == 7 || this.tipoDialog == 8) {
                this.setDadosCartao(this.pgto);
                this.setVisible(false);
            } else if (this.tipoDialog == 2 || this.tipoDialog == 4 || this.tipoDialog == 5) {
                this.setDadosCheque(this.pgto);
            } else if (this.tipoDialog == 6) {
                this.setDadosObservacao(this.pgto);
                this.setVisible(false);
            } else if (this.tipoDialog == 9) {
                this.setDadosTransferenciaBancaria(this.pgto);
                this.setVisible(false);
            } else if (this.tipoDialog == 10) {
                this.setDadosPix(this.pgto);
            }
        }
    }

    private void setDadosPix(LancamentoBean forma) {
        if (Funcoes.textoVazio(this.textPix.getText())) {
            Funcoes.mensagem(this, "Pix n\u00e3o preenchido!", 2);
            if (this.textPix.isFocusable()) {
                this.textPix.grabFocus();
            }
            return;
        }
        if (Funcoes.textoVazio(this.textDataTransferencia.getText())) {
            Funcoes.mensagem(this, "Data n\u00e3o preenchida!", 2);
            if (this.textDataTransferencia.isFocusable()) {
                this.textDataTransferencia.grabFocus();
            }
            return;
        }
        forma.setAgencia(this.textAgenciaTransferencia.getText());
        forma.setConta(this.textContaTransferencia.getText());
        if (!Funcoes.textoVazio(this.textBancoTransferencia.getText())) {
            forma.setBanco(Integer.parseInt(this.textBancoTransferencia.getText()));
        }
        if (!Funcoes.textoVazio(this.textDataTransferencia)) {
            forma.setDataVencimento(Funcoes.getData("dd/MM/yyyy", this.textDataTransferencia.getText()));
        }
        forma.setSacado(this.textSacado.getText());
        forma.setPix(this.textPix.getText());
        this.setVisible(false);
    }

    private void setDadosTransferenciaBancaria(LancamentoBean forma) {
        forma.setAgencia(this.textAgenciaTransferencia.getText());
        forma.setConta(this.textContaTransferencia.getText());
        forma.setBanco(Integer.parseInt(this.textBancoTransferencia.getText()));
        forma.setDataVencimento(Funcoes.textoVazio(this.textDataTransferencia) ? null : Funcoes.getData("dd/MM/yyyy", this.textDataTransferencia.getText()));
        forma.setSacado(this.textSacado.getText());
        forma.setTipoTransferencia(this.textTransferencia.getText());
    }

    private void setDadosObservacao(LancamentoBean forma) {
        forma.setObservacao(this.txtObs.getText());
    }

    private void setDadosCartao(LancamentoBean forma) {
        forma.setValidadeCartao(Funcoes.textoVazio(this.textValidadeCartao.getText()) ? null : Funcoes.stringToDate(this.textValidadeCartao.getText()));
        forma.setNumeroCartao(Funcoes.textoVazio(this.textNumeroCartao.getText()) ? null : this.textNumeroCartao.getText());
        forma.setCartaoCredito(this.comboCartaoCredito.getSelectedIndex() < 0 ? null : ((BandeirasCartoes)this.comboCartaoCredito.getSelectedItem()).getBandeira());
    }

    private void setDadosCheque(LancamentoBean forma) {
        if (ParametrosGerais.getObrigaDadosChequeCaixa()) {
            if (Funcoes.textoVazio(this.textBanco.getText())) {
                Funcoes.mensagem(this, "Banco n\u00e3o preenchido!", 2);
                if (this.textBanco.isFocusable()) {
                    this.textBanco.grabFocus();
                }
                return;
            }
            if (Funcoes.textoVazio(this.textAgencia.getText())) {
                Funcoes.mensagem(this, "Banco n\u00e3o preenchido!", 2);
                if (this.textAgencia.isFocusable()) {
                    this.textAgencia.grabFocus();
                }
                return;
            }
            if (Funcoes.textoVazio(this.textNumeroCheque.getText())) {
                Funcoes.mensagem(this, "Banco n\u00e3o preenchido!", 2);
                if (this.textNumeroCheque.isFocusable()) {
                    this.textNumeroCheque.grabFocus();
                }
                return;
            }
            if (Funcoes.textoVazio(this.textContaCheque.getText())) {
                Funcoes.mensagem(this, "Banco n\u00e3o preenchido!", 2);
                if (this.textContaCheque.isFocusable()) {
                    this.textContaCheque.grabFocus();
                }
                return;
            }
        }
        forma.setBanco(Funcoes.textoVazio(this.textBanco) ? null : Integer.valueOf(Integer.parseInt(this.textBanco.getText())));
        forma.setAgencia(Funcoes.textoVazio(this.textAgencia) ? null : this.textAgencia.getText());
        forma.setNumeroCheque(Funcoes.textoVazio(this.textNumeroCheque) ? null : this.textNumeroCheque.getText());
        forma.setConta(Funcoes.textoVazio(this.textContaCheque) ? null : this.textContaCheque.getText());
        forma.setSacado(this.textSacado.getText());
        forma.setDataVencimento(Funcoes.textoVazio(this.textVctoChequePre) ? null : Funcoes.getData("dd/MM/yyyy", this.textVctoChequePre.getText()));
        this.setVisible(false);
    }

    private void setDadosAutDebito(LancamentoBean forma) {
        forma.setNumeroDocumento(Funcoes.textoVazio(this.textAutorizacao.getText()) ? null : this.textAutorizacao.getText());
    }

    private void setDescontoFolha(LancamentoBean forma) {
        forma.setNomePagador(Funcoes.textoVazio(this.textNomeFuncionario.getText()) ? null : this.textNomeFuncionario.getText());
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonSalvar) {
            if (this.tipoDialog == 3) {
                this.setDadosAutDebito(this.pgto);
            } else if (this.tipoDialog == 7 || this.tipoDialog == 8) {
                this.setDadosCartao(this.pgto);
            } else if (this.tipoDialog == 2 || this.tipoDialog == 4 || this.tipoDialog == 5) {
                this.setDadosCheque(this.pgto);
            } else if (this.tipoDialog == 6) {
                this.setDadosObservacao(this.pgto);
            } else if (this.tipoDialog == 9) {
                this.setDadosTransferenciaBancaria(this.pgto);
            }
            this.setVisible(false);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

