/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;

class DialogBuscaTitulos
extends JDialog
implements ActionListener {
    private static final String SELECIONADO = "selecionado";
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'n', this);
    private JButton buttonDesmarcarTodos = ComponenteFactory.novoJButton("Desmarcar Todos", 'D', this);
    private JButton buttonMarcarTodos = ComponenteFactory.novoJButton("Selecionar Todos", 'S', this);
    private JButton buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JButton buttonDataVctoIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataVctoFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private TTextField textDataVctoIni = new TTextField(0, 4);
    private TTextField textDataVctoFin = new TTextField(0, 4);
    private TTextField textValorIni = new TTextField(0, 2);
    private TTextField textValorFin = new TTextField(0, 2);
    private TTextField textNumeroDoc = new TTextField(40, 3);
    private ModeloGridTable modTit = new ModeloGridTable(new String[]{"C\u00f3digo", "C\u00f3d. Cad.", "Cadastro", "N\u00fam. Doc.", "Vencimento", "Valor Total", "Sel"}){

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == this.getColumnCount() - 1;
        }

        public Class getColumnClass(int c) {
            if (c == this.getColumnCount() - 1) {
                return Boolean.class;
            }
            return super.getColumnClass(c);
        }
    };
    private CheckItemFiltro itemPaciente;
    private CheckItemFiltro itemEntidade;
    private CheckItemFiltro itemConvenio;
    private boolean ok;

    public DialogBuscaTitulos(Frame pai) {
        super(pai, "Pesquisando T\u00edtulos", true);
        this.iniciar();
    }

    public DialogBuscaTitulos(Dialog pai) {
        super(pai, "Pesquisando T\u00edtulos", true);
        this.iniciar();
    }

    public boolean getOk() {
        return this.ok;
    }

    public List<HashMap<String, Object>> getTitulosSelecionados() {
        ArrayList<HashMap<String, Object>> sel = new ArrayList<HashMap<String, Object>>();
        for (int i = 0; i < this.modTit.getRowCount(); ++i) {
            HashMap<String, Object> hash = this.modTit.getLine(i);
            if (!hash.get("Sel").equals(true)) continue;
            sel.add(hash);
        }
        return sel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOK || o == this.buttonCancelar) {
            this.ok = o == this.buttonOK;
            this.dispose();
        } else if (o == this.buttonMarcarTodos || o == this.buttonDesmarcarTodos) {
            boolean marcar = o == this.buttonMarcarTodos;
            for (int i = 0; i < this.modTit.getRowCount(); ++i) {
                this.modTit.setValueAt(marcar, i, this.modTit.findColumn("Sel"));
            }
            this.modTit.fireTableDataChanged();
        } else if (o == this.buttonDataVctoIni) {
            Funcoes.mostraData(this.textDataVctoIni, this.buttonDataVctoIni, (JPanel)this.buttonDataVctoIni.getParent(), true);
        } else if (o == this.buttonDataVctoFin) {
            Funcoes.mostraData(this.textDataVctoFin, this.buttonDataVctoFin, (JPanel)this.buttonDataVctoFin.getParent(), true);
        } else if (o == this.buttonConsultar) {
            this.consultarTitulos();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consultarTitulos() {
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                this.buttonConsultar.setEnabled(false);
                this.modTit.clear();
                ResultSet res = Conexao.executeQuery(st, this.getSelect());
                while (res.next()) {
                    Object[] obj = new Object[]{res.getInt("rpg_codigo"), res.getInt("cod_pessoa"), res.getString("razao_social"), res.getString("rpg_numerodocumento"), Funcoes.formataData("dd/MM/yyyy", res.getDate("rpg_vencimento")), Funcoes.formataDecimal(res.getDouble("rpg_valortotal")), new Boolean(false)};
                    this.modTit.addLine(obj);
                }
                this.modTit.fireTableDataChanged();
            }
            catch (SQLException e) {
                try {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel adicionar t\u00edtulo.", 2);
                }
                catch (Throwable throwable) {
                    this.buttonConsultar.setEnabled(true);
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                this.buttonConsultar.setEnabled(true);
                Conexao.fecharStatement(st);
            }
            this.buttonConsultar.setEnabled(true);
            Conexao.fecharStatement(st);
        }
    }

    private String getSelect() {
        StringBuilder buf = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        try {
            buf.append(" select rpg.rpg_codigo \n");
            buf.append("       ,cad.cod_pessoa \n");
            buf.append("       ,cad.razao_social \n");
            buf.append("       ,rpg.rpg_numerodocumento \n");
            buf.append("       ,rpg.rpg_vencimento \n");
            buf.append("       ,rpg.rpg_valortotal \n");
            buf.append("  \t\t ,false as ").append(SELECIONADO).append(" \n");
            buf.append("   from receberpagar rpg \n");
            buf.append("   left join (select case when rpg.rpg_tipocadastro = upper('").append("P").append("') then pac.pac_nome \n");
            buf.append("                       when rpg.rpg_tipocadastro = upper('").append("O").append("') then con.con_fantasia  \n");
            buf.append("                       else ent.ent_fantasia end as razao_social \n");
            buf.append("                    ,case when upper(rpg.rpg_tipocadastro) = upper('").append("P").append("') then pac.pac_codigo \n");
            buf.append("                       when upper(rpg.rpg_tipocadastro) = upper('").append("O").append("') then con.con_codigo \n");
            buf.append("                       else ent.ent_codigo end as cod_pessoa \n");
            buf.append("                    ,rpg.rpg_codigo \n");
            buf.append("                    ,rpg.fil_codigo \n");
            buf.append("               from receberpagar rpg \n");
            buf.append("               left join entidade ent on rpg.fil_codigo = ent.fil_codigo and rpg.ent_codigo = ent.ent_codigo \n");
            buf.append("               left join paciente pac on rpg.fil_codigo = pac.fil_codigo and rpg.pac_codigo = pac.pac_codigo \n");
            buf.append("               left join convenios con on rpg.fil_codigo = con.fil_codigo and rpg.con_codigo = con.con_codigo \n");
            buf.append("             ) cad on (rpg.fil_codigo = cad.fil_codigo and rpg.rpg_codigo = cad.rpg_codigo) \n");
            buf.append("  where \n");
            buf.append("        rpg.fil_codigo = ").append(Variaveis.filialPadrao).append(" ");
            buf.append("    and rpg.rpg_tipo = '").append("R").append("' ");
            buf.append("    and rpg.rpg_situacao IN ('");
            buf.append("A").append("', '");
            buf.append("S").append("', '");
            buf.append("V").append("', '");
            buf.append("T").append("') ");
            if (Funcoes.verificaData(this.textDataVctoIni.getText())) {
                buf.append("and \n  rpg.rpg_vencimento >= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", sdf.parse(this.textDataVctoIni.getText()))).append("' ");
            }
            if (Funcoes.verificaData(this.textDataVctoFin.getText())) {
                buf.append("and \n  rpg.rpg_vencimento <= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", sdf.parse(this.textDataVctoFin.getText()))).append("' ");
            }
            if (!Funcoes.textoVazio(this.textNumeroDoc)) {
                buf.append(" and rpg_numerodocumento ilike '%").append(this.textNumeroDoc.getText()).append("%' ");
            }
            if (!Funcoes.textoVazio(this.textValorIni)) {
                buf.append(" and rpg_valortotal >= ").append(Funcoes.limpaDecimal(this.textValorIni.getText()));
            }
            if (!Funcoes.textoVazio(this.textValorFin)) {
                buf.append(" and rpg_valortotal <= ").append(Funcoes.limpaDecimal(this.textValorFin.getText()));
            }
            StringBuilder bufWhere = new StringBuilder();
            String aux = this.getSelecionadosFiltro(this.itemPaciente, 0);
            if (aux != null) {
                bufWhere.append(" (cad.cod_pessoa IN (").append(aux).append(") and rpg_tipocadastro = 'P') ");
            }
            if ((aux = this.getSelecionadosFiltro(this.itemEntidade, 0)) != null) {
                if (bufWhere.length() > 0) {
                    bufWhere.append(" or ");
                }
                bufWhere.append(" (cad.cod_pessoa IN (").append(aux).append(") and rpg_tipocadastro NOT IN ('P', 'O')) ");
            }
            if ((aux = this.getSelecionadosFiltro(this.itemConvenio, 0)) != null) {
                if (bufWhere.length() > 0) {
                    bufWhere.append(" or ");
                }
                bufWhere.append(" (cad.cod_pessoa IN (").append(aux).append(") and rpg_tipocadastro = 'O') ");
            }
            if (bufWhere.toString().length() > 0) {
                buf.append(" and ( ");
                buf.append(bufWhere.toString());
                buf.append(" ) ");
            }
            buf.append("  order by rpg.rpg_codigo ");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DialogoFiltro: 3353");
        }
        return buf.toString();
    }

    private String getSelecionadosFiltro(CheckItemFiltro itemFiltro, int coluna) {
        if (itemFiltro == null || coluna < 0) {
            return null;
        }
        String[] aux = itemFiltro.getSelecionados(coluna);
        StringBuilder result = new StringBuilder();
        if (aux == null || aux.length == 0) {
            return null;
        }
        for (int i = 0; i < aux.length; ++i) {
            result.append(aux[i]);
            if (i >= aux.length - 1) continue;
            result.append(",");
        }
        return result.toString();
    }

    private void iniciar() {
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel panelBotoes = new JPanel(new BorderLayout());
        panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, this.buttonMarcarTodos, this.buttonDesmarcarTodos), "West");
        panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonOK, this.buttonCancelar), "East");
        JPanel panelTabela = new JPanel(new BorderLayout());
        panelTabela.setBorder(BorderFactory.createTitledBorder("T\u00edtulos em aberto"));
        JTable table = new JTable(this.modTit);
        this.modTit.setColumnSize(new int[]{60, 80, 0, 85, 90, 85, 20}, table);
        table.getTableHeader().addMouseListener(this.modTit);
        table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row;
                int[] colunas = ((JTable)e.getSource()).getSelectedColumns();
                boolean colunaSelecionada = false;
                for (int i = 0; i < colunas.length; ++i) {
                    if (colunas[i] != ((JTable)e.getSource()).getColumnCount() - 1) continue;
                    colunaSelecionada = true;
                    break;
                }
                if (e.getKeyCode() == 32 && !colunaSelecionada && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0) {
                    Boolean valor = (Boolean)DialogBuscaTitulos.this.modTit.getValueAt(row, DialogBuscaTitulos.this.modTit.getColumnCount() - 1);
                    DialogBuscaTitulos.this.modTit.setValueAt(valor == false, row, DialogBuscaTitulos.this.modTit.getColumnCount() - 1);
                }
            }
        });
        JScrollPane scroll = new JScrollPane(table);
        scroll.setPreferredSize(new Dimension(600, 200));
        panelTabela.add((Component)scroll, "Center");
        JPanel panelFiltros = new JPanel(new GridBagLayout());
        panelFiltros.setBorder(BorderFactory.createTitledBorder("Filtros"));
        this.itemPaciente = new CheckItemFiltro("Paciente", "Filtrar", "Filtrando pacientes", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemPaciente.setDados("paciente", new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome Paciente"}, new int[]{70, 0});
        this.itemPaciente.setColunaHint(1);
        Dimension d = new Dimension(100, 20);
        this.itemPaciente.setPreferredSize(d);
        this.itemPaciente.setMinimumSize(d);
        d = new Dimension(90, 20);
        this.textDataVctoIni.setPreferredSize(d);
        this.textDataVctoIni.setMinimumSize(d);
        this.buttonDataVctoIni.setFocusable(false);
        this.itemEntidade = new CheckItemFiltro("Entidade", "Filtrar", "Filtrando entidades", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemEntidade.setDados("entidade", new String[]{"ent_codigo", "ent_fantasia"}, new String[]{"C\u00f3digo", "Fantasia Cadastro"}, new int[]{70, 0});
        this.itemEntidade.setColunaHint(1);
        d = new Dimension(100, 20);
        this.itemEntidade.setPreferredSize(d);
        this.itemEntidade.setMinimumSize(d);
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia Conv\u00eanio"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        d = new Dimension(100, 20);
        this.itemConvenio.setPreferredSize(d);
        this.itemConvenio.setMinimumSize(d);
        this.textDataVctoFin.setPreferredSize(new Dimension(90, 20));
        this.buttonDataVctoFin.setFocusable(false);
        d = new Dimension(90, 20);
        this.textNumeroDoc.setPreferredSize(d);
        this.textNumeroDoc.setMinimumSize(d);
        this.textValorIni.setPreferredSize(d);
        this.textValorIni.setMinimumSize(d);
        this.textValorFin.setPreferredSize(d);
        this.textValorFin.setMinimumSize(d);
        this.buttonConsultar.setPreferredSize(d);
        this.buttonConsultar.setMinimumSize(d);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.fill = 2;
        panelFiltros.add((Component)this.itemPaciente, c);
        c.fill = 0;
        c.gridx += 3;
        JPanel branco = new JPanel();
        d = new Dimension(20, 20);
        branco.setPreferredSize(d);
        branco.setMinimumSize(d);
        c.gridwidth = 1;
        panelFiltros.add((Component)branco, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.fill = 2;
        panelFiltros.add((Component)this.itemEntidade, c);
        c.fill = 0;
        c.gridx += 3;
        c.gridwidth = 1;
        branco = new JPanel();
        d = new Dimension(20, 20);
        branco.setPreferredSize(d);
        branco.setMinimumSize(d);
        panelFiltros.add((Component)branco, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        panelFiltros.add((Component)new JLabel(""), c);
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridwidth = 2;
        panelFiltros.add((Component)this.itemConvenio, c);
        c.fill = 0;
        c.gridx += 4;
        c.gridwidth = 1;
        panelFiltros.add((Component)new JLabel("N\u00famero Doc.:"), c);
        ++c.gridx;
        panelFiltros.add((Component)this.textNumeroDoc, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        c.gridwidth = 1;
        panelFiltros.add((Component)new JLabel("Dt. Vencto. Inicial:"), c);
        ++c.gridx;
        panelFiltros.add((Component)this.textDataVctoIni, c);
        ++c.gridx;
        panelFiltros.add((Component)this.buttonDataVctoIni, c);
        c.gridx += 2;
        panelFiltros.add((Component)new JLabel("Dt. Vencto. Final:"), c);
        ++c.gridx;
        panelFiltros.add((Component)this.textDataVctoFin, c);
        ++c.gridx;
        panelFiltros.add((Component)this.buttonDataVctoFin, c);
        ++c.gridy;
        c.gridx = 0;
        panelFiltros.add((Component)new JLabel("Vl. Total Inicial:"), c);
        ++c.gridx;
        panelFiltros.add((Component)this.textValorIni, c);
        c.gridx += 3;
        panelFiltros.add((Component)new JLabel("Vl. Total Final:"), c);
        ++c.gridx;
        panelFiltros.add((Component)this.textValorFin, c);
        c.gridx += 2;
        c.fill = 2;
        panelFiltros.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.fill = 0;
        c.anchor = 12;
        panelFiltros.add((Component)this.buttonConsultar, c);
        Container panelPrinc = this.getContentPane();
        panelPrinc.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelPrinc.add((Component)panelFiltros, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.fill = 1;
        panelPrinc.add((Component)panelTabela, c);
        ++c.gridy;
        panelPrinc.add((Component)panelBotoes, c);
        Funcoes.montaEnter((JComponent)this.getContentPane());
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(113, 0, true), "F2", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogBuscaTitulos.this.textDataVctoIni.hasFocus()) {
                    Funcoes.mostraData(DialogBuscaTitulos.this.textDataVctoIni, DialogBuscaTitulos.this.buttonDataVctoIni, (JPanel)DialogBuscaTitulos.this.buttonDataVctoIni.getParent(), true);
                } else if (DialogBuscaTitulos.this.textDataVctoFin.hasFocus()) {
                    Funcoes.mostraData(DialogBuscaTitulos.this.textDataVctoFin, DialogBuscaTitulos.this.buttonDataVctoFin, (JPanel)DialogBuscaTitulos.this.buttonDataVctoFin.getParent(), true);
                }
            }
        });
        this.pack();
        d = new Dimension(250, 200);
        this.setPreferredSize(d);
        this.setMinimumSize(d);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        this.setVisible(true);
    }
}

