/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.detalhes.Detalhes;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.lancamentos.ContaCorrente;
import jalis.laboratorio.financeiro.lancamentos.Lancamento;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.financeiro.ContaCorrenteBean;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.financeiro.ContaCorrenteVO;
import jalis.service.cadastro.financeiro.ContaCorrenteService;
import jalis.service.financeiro.LancamentoService;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

public class Conciliacao
extends FrmCadPadrao {
    private JButton buttonLancamento;
    private JButton buttonDataConciliacao;
    private JLabel labelAux1;
    private JLabel labelAux2;
    private JLabel labelLancamento;
    private JLabel labelDataConciliacao;
    private JLabel labelConta;
    private JPanel panelLegenda;
    private JPanel panelDataConciliacao;
    private DetalhesLancamento panelDetalhes;
    private JScrollPane scrollLancamentos;
    private JTable tableLancamentos;
    private ModeloGridTable modelLancamentos;
    private TTextField textLancamento;
    private TTextField textDataConciliacao;
    private JComboBox comboConta;
    private long ACESSO_CONCILIAR = Long.parseLong("0600400201");
    private long ACESSO_TELA_LANCAMENTO = Long.parseLong("0600400100");
    private long ACESSO_EDITAR_LANCAMENTO = Long.parseLong("0600400102");
    private long ACESSO_ALTERAR_CONTA = Long.parseLong("0600400202");
    private static final String STRING_NAO_ALTERAR = "N\u00e3o alterar";
    private static final int COLUNA_CODIGO = 0;
    private static final int COLUNA_TIPO = 1;
    private static final int COLUNA_CODIGO_CONTA = 2;
    private static final int COLUNA_DESCRICAO_CONTA = 3;
    private static final int COLUNA_VENCIMENTO = 4;
    private static final int COLUNA_COMPETENCIA = 5;
    private static final int COLUNA_VALOR_TOTAL = 6;
    private static final int COLUNA_OBJETO = 7;
    private boolean isJanela = false;
    private JDialog dialog = null;

    public void setJanela(JDialog dialog) {
        this.isJanela = true;
        this.dialog = dialog;
        this.botaoNovo.setVisible(false);
        this.botaoFechar.setVisible(false);
        this.textLancamento.setEnabled(false);
        this.buttonLancamento.setEnabled(false);
    }

    public Conciliacao() {
        this.labelLancamento = new JLabel();
        this.textLancamento = new TTextField(10, 1);
        this.labelAux1 = new JLabel();
        this.labelAux2 = new JLabel();
        this.buttonLancamento = new JButton();
        this.scrollLancamentos = new JScrollPane();
        this.tableLancamentos = new JTable();
        this.panelDetalhes = new DetalhesLancamento(2);
        this.panelLegenda = new JPanel();
        this.panelDataConciliacao = new JPanel();
        this.labelDataConciliacao = new JLabel();
        this.textDataConciliacao = new TTextField(10, 4);
        this.buttonDataConciliacao = new JButton();
        this.labelConta = new JLabel("Conta de Concilia\u00e7\u00e3o:");
        this.comboConta = new JComboBox();
        this.botaoEditar.setVisible(false);
        this.botaoExcluir.setVisible(false);
        this.botaoSalvar.setText("Conciliar");
        this.botaoSalvar.setMnemonic('o');
        this.painelCentral.setLayout(new GridBagLayout());
        Funcoes.criaBarraDescricao(this, "Concilia\u00e7\u00e3o de Lan\u00e7amentos", "Concilia\u00e7\u00e3o de Lan\u00e7amentos Financeiros", "financeiro/concil_lancamento.jpg");
        Funcoes.imagemPesquisa(this.buttonLancamento);
        this.buttonLancamento.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonDataConciliacao);
        this.buttonDataConciliacao.setFocusable(false);
        this.modelLancamentos = new ModeloGridTable(new String[]{"C\u00f3digo", "Tipo", "Conta", "Descri\u00e7\u00e3o Conta", "Vencimento", "Compet\u00eancia", "Valor Total", "Objeto"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    Conciliacao.this.tableLancamentos.removeColumn(Conciliacao.this.tableLancamentos.getColumn("Objeto"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.tableLancamentos = new JTable(this.modelLancamentos);
        this.tableLancamentos.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row;
                if (e.getKeyCode() == 32 && (row = Conciliacao.this.tableLancamentos.getSelectedRow()) >= 0) {
                    if (!Acesso.getAcesso(Conciliacao.this.ACESSO_TELA_LANCAMENTO)) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "Seu usu\u00e1rio n\u00e3o possui acesso para visualizar a tela de Lan\u00e7amentos.", 2);
                        return;
                    }
                    if (!Acesso.getAcesso(Conciliacao.this.ACESSO_EDITAR_LANCAMENTO)) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "Seu usu\u00e1rio n\u00e3o possui acesso para editar lan\u00e7amentos.", 2);
                        return;
                    }
                    LancamentoBean lancto = (LancamentoBean)Conciliacao.this.modelLancamentos.getValueAt(row, 7);
                    lancto = Lancamento.novaInstanciaDialog(Laboratorio.getInstancia(), lancto);
                    if (lancto != null) {
                        Conciliacao.this.salvarAlteracoesLancamento(lancto);
                        try {
                            lancto = (LancamentoBean)new LancamentoService().get(lancto.getFilial().getCodigo().toString(), lancto.getCodigo().toString(), lancto.getEstacao().getCodigo().toString());
                        }
                        catch (Exception e1) {
                            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel atualizar lan\u00e7amento.\n" + e1.getMessage(), e1.getStackTrace());
                        }
                        Conciliacao.this.modelLancamentos.setValueAt(lancto, row, 7);
                        FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)lancto);
                        Conciliacao.this.atualizaLancamentos();
                    }
                }
                if (e.getKeyCode() == 127) {
                    Conciliacao.this.removerLancamento();
                    if (Conciliacao.this.textLancamento.isFocusable()) {
                        Conciliacao.this.textLancamento.grabFocus();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                LancamentoBean lancto;
                int row = Conciliacao.this.tableLancamentos.getSelectedRow();
                if (row >= 0 && (lancto = (LancamentoBean)Conciliacao.this.modelLancamentos.getValueAt(row, 7)) != null) {
                    Conciliacao.this.panelDetalhes.setDados(lancto.getHistoricoPadrao().getCodigo(), lancto.getHistoricoPadrao().getDescricao(), Tipos.tipoDocumento(lancto.getTipoDocumento()), lancto.getNumeroDocumento(), Tipos.tipoPagamento(lancto.getTipoPagamento()), lancto.getValor(), lancto.getValorDesconto(), lancto.getValorJuro(), lancto.getValorAcrescimo(), lancto.getValorMulta());
                }
            }
        });
        this.tableLancamentos.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = Conciliacao.this.tableLancamentos.getSelectedRow();
                if (row >= 0) {
                    LancamentoBean lancto = (LancamentoBean)Conciliacao.this.modelLancamentos.getValueAt(row, 7);
                    if (e.getClickCount() == 2) {
                        if (!Acesso.getAcesso(Conciliacao.this.ACESSO_TELA_LANCAMENTO)) {
                            Funcoes.mensagem(Laboratorio.getInstancia(), "Seu usu\u00e1rio n\u00e3o possui acesso para visualizar a tela de Lan\u00e7amentos.", 2);
                            return;
                        }
                        if (!Acesso.getAcesso(Conciliacao.this.ACESSO_EDITAR_LANCAMENTO)) {
                            Funcoes.mensagem(Laboratorio.getInstancia(), "Seu usu\u00e1rio n\u00e3o possui acesso para editar lan\u00e7amentos.", 2);
                            return;
                        }
                        lancto = Lancamento.novaInstanciaDialog(Laboratorio.getInstancia(), lancto);
                        if (lancto != null) {
                            Conciliacao.this.salvarAlteracoesLancamento(lancto);
                            try {
                                lancto = (LancamentoBean)new LancamentoService().get(lancto.getFilial().getCodigo().toString(), lancto.getCodigo().toString(), lancto.getEstacao().getCodigo().toString());
                            }
                            catch (Exception e1) {
                                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel atualizar lan\u00e7amento.\n" + e1.getMessage(), e1.getStackTrace());
                            }
                            Conciliacao.this.modelLancamentos.setValueAt(lancto, row, 7);
                            FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)lancto);
                            Conciliacao.this.atualizaLancamentos();
                        }
                    }
                    if (lancto != null) {
                        Conciliacao.this.panelDetalhes.setDados(lancto.getHistoricoPadrao().getCodigo(), lancto.getHistoricoPadrao().getDescricao(), Tipos.tipoDocumento(lancto.getTipoDocumento()), lancto.getNumeroDocumento(), Tipos.tipoPagamento(lancto.getTipoPagamento()), lancto.getValor(), lancto.getValorDesconto(), lancto.getValorJuro(), lancto.getValorAcrescimo(), lancto.getValorMulta());
                    }
                }
            }
        });
        this.modelLancamentos.setColumnSize(new int[]{65, 65, 75, 0, 95, 95, 85, 0}, this.tableLancamentos);
        this.tableLancamentos.removeColumn(this.tableLancamentos.getColumn("Objeto"));
        this.tableLancamentos.getTableHeader().addMouseListener(this.modelLancamentos);
        LancamentoRenderer rendererLancamento = new LancamentoRenderer();
        this.tableLancamentos.setDefaultRenderer(Object.class, rendererLancamento);
        this.scrollLancamentos = new JScrollPane(this.tableLancamentos);
        this.botaoFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Conciliacao.this.fechar();
            }
        });
        this.buttonLancamento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<HashMap<String, Object>> lancamentos = null;
                DialogoFiltroLancamentos diag = new DialogoFiltroLancamentos(Laboratorio.getInstancia());
                diag.setVisible(true);
                if (diag.getOk() && (lancamentos = diag.getLancamentosSelecionados()) != null) {
                    Iterator<HashMap<String, Object>> it = lancamentos.iterator();
                    if (!lancamentos.isEmpty()) {
                        SplashMensagem janelaEspera = SplashMensagem.getInstancia(Conciliacao.this);
                        janelaEspera.mostrar("Adicionando lan\u00e7amentos");
                        int i = 0;
                        int qtde = lancamentos.size();
                        while (it.hasNext()) {
                            HashMap<String, Object> reg = it.next();
                            janelaEspera.setText("Adicionando lan\u00e7amentos - " + (int)Funcoes.arredondar(++i * 100 / qtde, 2) + "%");
                            LancamentoBean lancamento = null;
                            try {
                                lancamento = (LancamentoBean)new LancamentoService().get(Variaveis.filialPadrao, String.valueOf(reg.get("C\u00f3digo")), reg.get("codigoEstacao").toString());
                            }
                            catch (Exception e1) {
                                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar dados do lan\u00e7amento: " + reg.get("C\u00f3digo") + ".\n" + e1.getMessage(), 2);
                                continue;
                            }
                            if (lancamento == null) continue;
                            Conciliacao.this.adicionarLancamento(lancamento);
                        }
                        janelaEspera.apagar();
                    }
                }
            }
        });
        this.textDataConciliacao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Conciliacao.this.buttonDataConciliacao.doClick();
                }
            }
        });
        this.textLancamento.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Conciliacao.this.textLancamento.setText("");
                    Conciliacao.this.buttonLancamento.doClick();
                }
            }
        });
        this.textLancamento.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Conciliacao.this.textLancamento.getText().isEmpty()) {
                    Conciliacao.this.buscaLancamento(Conciliacao.this.textLancamento.getText());
                }
            }
        });
        this.painelCentral.setLayout(new GridBagLayout());
        this.labelLancamento.setText("Lan\u00e7amento:");
        this.labelLancamento.setLabelFor(this.textLancamento);
        this.labelLancamento.setDisplayedMnemonic('L');
        this.painelCentral.add((Component)this.labelLancamento, new GridBagConstraints());
        this.textLancamento.setMinimumSize(new Dimension(70, 20));
        this.textLancamento.setPreferredSize(new Dimension(70, 20));
        this.painelCentral.add((Component)this.textLancamento, new GridBagConstraints());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.labelAux1, gridBagConstraints);
        this.buttonLancamento.setMinimumSize(new Dimension(20, 20));
        this.buttonLancamento.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.painelCentral.add((Component)this.buttonLancamento, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.painelCentral.add((Component)this.scrollLancamentos, gridBagConstraints);
        this.panelDataConciliacao.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.labelDataConciliacao.setText("Data de Concilia\u00e7\u00e3o:");
        this.labelDataConciliacao.setLabelFor(this.textDataConciliacao);
        this.labelDataConciliacao.setDisplayedMnemonic('D');
        this.panelDataConciliacao.add((Component)this.labelDataConciliacao, gridBagConstraints);
        this.textDataConciliacao.setMinimumSize(new Dimension(90, 20));
        this.textDataConciliacao.setPreferredSize(new Dimension(90, 20));
        ++gridBagConstraints.gridx;
        this.panelDataConciliacao.add((Component)this.textDataConciliacao, gridBagConstraints);
        this.buttonDataConciliacao.setMinimumSize(new Dimension(20, 20));
        this.buttonDataConciliacao.setPreferredSize(new Dimension(20, 20));
        this.buttonDataConciliacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Funcoes.mostraData(Conciliacao.this.textDataConciliacao, Conciliacao.this.buttonDataConciliacao, Conciliacao.this.panelDataConciliacao, true);
            }
        });
        ++gridBagConstraints.gridx;
        this.panelDataConciliacao.add((Component)this.buttonDataConciliacao, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.labelConta.setLabelFor(this.comboConta);
        this.labelConta.setDisplayedMnemonic('n');
        this.panelDataConciliacao.add((Component)this.labelConta, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.panelDataConciliacao.add((Component)this.comboConta, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelDataConciliacao.add((Component)this.labelAux2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.panelDataConciliacao, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.painelCentral.add((Component)this.panelDetalhes, gridBagConstraints);
        this.panelLegenda.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.painelCentral.add((Component)this.panelLegenda, gridBagConstraints);
        this.panelLegenda = FinanceiroUtil.montaPanelLegenda(this.panelLegenda);
        this.modelLancamentos.ordenarColuna(0);
        this.tableLancamentos.removeColumn(this.tableLancamentos.getColumn(this.tableLancamentos.getColumnName(7)));
        this.preencherContas();
        this.controlaCampos();
    }

    private void preencherContas() {
        ContaCorrente contaNaoAlterar = new ContaCorrente();
        contaNaoAlterar.setConta(STRING_NAO_ALTERAR);
        contaNaoAlterar.setReduzido(0);
        this.comboConta.addItem(contaNaoAlterar);
        ArrayList<ContaCorrenteVO> lista = null;
        try {
            lista = new ContaCorrenteService().getContasAtivas(Variaveis.filialPadrao);
            for (int i = 0; i < lista.size(); ++i) {
                this.comboConta.addItem(new ContaCorrente(lista.get(i)));
            }
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar contas correntes.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void salvarAlteracoesLancamento(LancamentoBean lancto) {
        try {
            new LancamentoService().gravaAutoCopiaSemCommit(lancto, 1, Variaveis.filialPadrao, null);
            Conexao.arquivaSQL();
            Funcoes.mensagem(Laboratorio.getInstancia(), "Lan\u00e7amento alterado com sucesso.", 2);
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel salvar altera\u00e7\u00f5es do Lan\u00e7amento.\n" + e.getMessage(), 2);
        }
    }

    private void removerLancamento() {
        if (Funcoes.mensagem(this, "Deseja remover o Lan\u00e7amento?", 4, true) == 1) {
            return;
        }
        int row = this.tableLancamentos.getSelectedRow();
        this.modelLancamentos.removeLine(row);
    }

    private void buscaLancamento(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            return;
        }
        try {
            LancamentoBean lancto = (LancamentoBean)new LancamentoService().getLancamentoAberto(Variaveis.filialPadrao, codigo, Variaveis.codigoEstacao);
            if (lancto == null) {
                throw new Exception("Lan\u00e7amento n\u00e3o encontrado.");
            }
            this.adicionarLancamento(lancto);
        }
        catch (Exception e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "O Lan\u00e7amento n\u00e3o foi encontrado.", 2);
            this.textLancamento.selectAll();
            this.textLancamento.grabFocus();
        }
    }

    public void adicionarLancamento(LancamentoBean lancto) {
        for (int i = 0; i < this.modelLancamentos.getRowCount(); ++i) {
            LancamentoBean aux = (LancamentoBean)this.modelLancamentos.getValueAt(i, 7);
            if (aux.getFilial().getCodigo().intValue() != lancto.getFilial().getCodigo().intValue() || aux.getCodigo().intValue() != lancto.getCodigo().intValue()) continue;
            this.textLancamento.clear();
            ScreenUtil.requisitarFoco(this.textLancamento);
            return;
        }
        try {
            FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)lancto);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Conciliacao:adicionarLancamento");
        }
        this.modelLancamentos.addLine(new Object[]{null, null, null, null, null, null, null, lancto});
        this.atualizaLancamentos();
        this.textLancamento.setText("");
        if (this.modelLancamentos.getColunaOrdenacao() != -1) {
            this.modelLancamentos.ordenarColunaSemTrocarSentido(this.modelLancamentos.getColunaOrdenacao());
        }
        try {
            this.tableLancamentos.removeColumn(this.tableLancamentos.getColumn("Objeto"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.textLancamento.isFocusable()) {
            this.textLancamento.grabFocus();
        }
    }

    private void atualizaLancamentos() {
        for (int i = 0; i < this.modelLancamentos.getRowCount(); ++i) {
            LancamentoBean lancto = (LancamentoBean)this.modelLancamentos.getValueAt(i, 7);
            if (lancto == null) continue;
            this.modelLancamentos.setValueAt(lancto.getCodigo(), i, 0);
            this.modelLancamentos.setValueAt(Tipos.tipoLancamentoCaixa(lancto.getTipo()), i, 1);
            this.modelLancamentos.setValueAt(lancto.getContaCorrente().getReduzido(), i, 2);
            this.modelLancamentos.setValueAt(lancto.getContaCorrente().getConta(), i, 3);
            this.modelLancamentos.setValueAt(Funcoes.formataData(lancto.getDataVencimento()), i, 4);
            this.modelLancamentos.setValueAt(Funcoes.formataData(lancto.getDataCompetencia()), i, 5);
            this.modelLancamentos.setValueAt(Funcoes.formataDecimal(lancto.getValorTotal()), i, 6);
        }
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            if (this.isJanela) {
                this.dialog.setVisible(false);
            } else {
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
        }
    }

    @Override
    public void editar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    private void limparCampos() {
        this.textLancamento.setText("");
        this.modelLancamentos.clear();
        this.textDataConciliacao.setText("");
        this.panelDetalhes.limpaDados();
    }

    private void controlaCampos() {
        boolean habilitar = this.getStatus() == 2;
        this.textLancamento.setEnabled(habilitar);
        this.buttonLancamento.setEnabled(habilitar);
        this.tableLancamentos.setEnabled(habilitar);
        this.textDataConciliacao.setEnabled(habilitar);
        this.buttonDataConciliacao.setEnabled(habilitar);
        this.labelConta.setEnabled(habilitar);
        this.comboConta.setEnabled(habilitar);
        if (!Acesso.getAcesso(this.ACESSO_CONCILIAR)) {
            this.botaoSalvar.setVisible(false);
        }
        if (!Acesso.getAcesso(this.ACESSO_ALTERAR_CONTA)) {
            this.labelConta.setVisible(false);
            this.comboConta.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.textDataConciliacao.setText(Funcoes.formataData(new Date()));
        if (this.textLancamento.isEnabled() && this.textLancamento.isFocusable()) {
            this.textLancamento.grabFocus();
        }
    }

    @Override
    public void salvar() {
        LancamentoService service = new LancamentoService();
        if (this.validaCampos()) {
            try {
                ContaCorrenteVO conta = (ContaCorrente)this.comboConta.getSelectedItem();
                conta = conta.getConta().equalsIgnoreCase(STRING_NAO_ALTERAR) ? null : (ContaCorrenteVO)new ContaCorrenteService().getVO(conta.getReduzido().toString());
                for (int i = 0; i < this.modelLancamentos.getRowCount(); ++i) {
                    LancamentoBean bean = (LancamentoBean)this.modelLancamentos.getValueAt(i, 7);
                    if (bean == null || service.conciliarLancamentoConta(bean, conta == null ? bean.getContaCorrente() : conta, Funcoes.getData("dd/MM/yyyy", this.textDataConciliacao.getText()))) continue;
                    throw new Exception("N\u00e3o foi poss\u00edvel conciliar o lan\u00e7amento " + bean.getCodigo() + ".");
                }
                Conexao.arquivaSQL();
                Funcoes.mensagem(Laboratorio.getInstancia(), "Lan\u00e7amentos conciliados com sucesso.", 5);
                if (!this.isJanela) {
                    this.limparCampos();
                    this.setStatus(1);
                    this.controlaCampos();
                }
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel salvar as altera\u00e7\u00f5es.\n" + e.getMessage(), e.getStackTrace());
            }
            if (this.isJanela) {
                this.dialog.setVisible(false);
            }
        }
    }

    @Override
    public boolean validaCampos() {
        if (this.modelLancamentos.getRowCount() <= 0) {
            Funcoes.mensagem(this, "Pelo menos um lan\u00e7amento deve ser selecionado.", 2);
            return false;
        }
        int resp = -1;
        resp = this.comboConta.getSelectedItem().toString().equalsIgnoreCase(STRING_NAO_ALTERAR) ? Funcoes.mensagem(this, "Todos os lan\u00e7amentos ser\u00e3o conciliados na data: \"" + this.textDataConciliacao.getText() + "\" em suas respectivas contas.\nDeseja continuar?", 4, true) : Funcoes.mensagem(this, "Todos os lan\u00e7amentos ser\u00e3o conciliados na data: \"" + this.textDataConciliacao.getText() + "\".\nA conta de concila\u00e7\u00e3o ser\u00e1: \"" + this.comboConta.getSelectedItem().toString() + "\".\nDeseja continuar?", 4, true);
        if (resp == 1) {
            return false;
        }
        Date dataConciliacao = Funcoes.stringToDate("dd/MM/yyyy", this.textDataConciliacao.getText());
        for (int i = 0; i < this.modelLancamentos.getRowCount(); ++i) {
            LancamentoBean lancto = (LancamentoBean)this.modelLancamentos.getValueAt(i, 7);
            if (this.comboConta.getSelectedItem().toString().equalsIgnoreCase(STRING_NAO_ALTERAR) && (!this.comboConta.getSelectedItem().toString().equalsIgnoreCase(STRING_NAO_ALTERAR) || lancto.getContaCorrente() == null)) continue;
            ContaCorrenteBean conta = null;
            try {
                if (!this.comboConta.getSelectedItem().toString().equalsIgnoreCase(STRING_NAO_ALTERAR)) {
                    ContaCorrenteVO aux = (ContaCorrenteVO)this.comboConta.getSelectedItem();
                    conta = (ContaCorrenteBean)new ContaCorrenteService().get(aux.getFilial().getCodigo().toString(), aux.getReduzido().toString());
                } else {
                    conta = (ContaCorrenteBean)new ContaCorrenteService().get(lancto.getContaCorrente().getFilial().getCodigo().toString(), lancto.getContaCorrente().getReduzido().toString());
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar dados da Conta Corrente/Caixa: " + lancto.getContaCorrente().getConta() + ".\n" + e.getMessage(), e.getStackTrace());
                return false;
            }
            if (conta == null) continue;
            if (conta.getDataSaldoInicial() == null) {
                Funcoes.mensagem(this, "A conta n\u00e3o possui data/saldo inicial. Reduzido: '" + conta.getReduzido() + "', Conta: '" + conta.getConta() + "'.", 2);
                return false;
            }
            if (conta.getDataSaldoInicial().compareTo(dataConciliacao) <= 0) continue;
            Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel conciliar o Lan\u00e7amento c\u00f3d: " + lancto.getCodigo() + " est.: " + lancto.getEstacao().getCodigo() + ".\nA data de saldo inicial da Conta Corrente/Caixa \u00e9 posterior \u00e0 " + this.textDataConciliacao.getText() + ".\nA data de Saldo Inicial da conta: \"" + conta.getConta() + "\" \u00e9 " + Funcoes.formataData("dd/MM/yyyy", conta.getDataSaldoInicial()) + ".", 2);
            return false;
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600400200");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    class DialogoFiltroLancamentos
    extends JDialog
    implements ActionListener {
        private static final String SELECIONADO = "selecionado";
        private JButton buttonConsultar;
        private JButton buttonDesmarcarTodos;
        private JButton buttonMarcarTodos;
        private JButton buttonOK;
        private JButton buttonCancelar;
        private JButton buttonDataVctoIni;
        private JButton buttonDataVctoFin;
        private TTextField textDataVctoIni;
        private TTextField textDataVctoFin;
        private TTextField textValorIni;
        private TTextField textValorFin;
        private TTextField textNumeroDoc;
        private TTextField textCheque;
        private CheckItemFiltro itemConta;
        private JTable table;
        private boolean ok;
        private ModeloGridTable modTit;

        public DialogoFiltroLancamentos(Frame pai) {
            super(pai, "Pesquisando Lan\u00e7amentos n\u00e3o conciliados", true);
            this.buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'n', this);
            this.buttonDesmarcarTodos = ComponenteFactory.novoJButton("Desmarcar Todos", 'D', this);
            this.buttonMarcarTodos = ComponenteFactory.novoJButton("Selecionar Todos", 'S', this);
            this.buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
            this.buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
            this.buttonDataVctoIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
            this.buttonDataVctoFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
            this.textDataVctoIni = new TTextField(0, 4);
            this.textDataVctoFin = new TTextField(0, 4);
            this.textValorIni = new TTextField(0, 2);
            this.textValorFin = new TTextField(0, 2);
            this.textNumeroDoc = new TTextField(40, 3);
            this.textCheque = new TTextField(10, 3);
            this.table = null;
            this.modTit = new ModeloGridTable(new String[]{"C\u00f3digo", "Tipo", "Documento", "Ch./Aut.D\u00e9b.", "Conta", "Vencimento", "Valor Total", "Sel", "codigoEstacao"}){

                @Override
                public boolean isCellEditable(int row, int col) {
                    return col == DialogoFiltroLancamentos.this.modTit.findColumn("Sel");
                }

                public Class getColumnClass(int c) {
                    if (c == DialogoFiltroLancamentos.this.modTit.findColumn("Sel")) {
                        return Boolean.class;
                    }
                    return super.getColumnClass(c);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    try {
                        DialogoFiltroLancamentos.this.table.getColumn("codigoEstacao").setMaxWidth(-1);
                        DialogoFiltroLancamentos.this.table.getColumn("codigoEstacao").setMinWidth(-1);
                        DialogoFiltroLancamentos.this.table.getColumn("codigoEstacao").setWidth(-1);
                        DialogoFiltroLancamentos.this.table.getColumn("codigoEstacao").setPreferredWidth(-1);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            };
            this.iniciar();
        }

        public DialogoFiltroLancamentos(Dialog pai) {
            super(pai, "Pesquisando Lan\u00e7amentos n\u00e3o conciliados", true);
            this.buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'n', this);
            this.buttonDesmarcarTodos = ComponenteFactory.novoJButton("Desmarcar Todos", 'D', this);
            this.buttonMarcarTodos = ComponenteFactory.novoJButton("Selecionar Todos", 'S', this);
            this.buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
            this.buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
            this.buttonDataVctoIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
            this.buttonDataVctoFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
            this.textDataVctoIni = new TTextField(0, 4);
            this.textDataVctoFin = new TTextField(0, 4);
            this.textValorIni = new TTextField(0, 2);
            this.textValorFin = new TTextField(0, 2);
            this.textNumeroDoc = new TTextField(40, 3);
            this.textCheque = new TTextField(10, 3);
            this.table = null;
            this.modTit = new /* invalid duplicate definition of identical inner class */;
            this.iniciar();
        }

        public boolean getOk() {
            return this.ok;
        }

        public List<HashMap<String, Object>> getLancamentosSelecionados() {
            ArrayList<HashMap<String, Object>> sel = new ArrayList<HashMap<String, Object>>();
            for (int i = 0; i < this.modTit.getRowCount(); ++i) {
                HashMap<String, Object> hash = this.modTit.getLine(i);
                hash.put("Esta\u00e7\u00e3o", this.modTit.getValueAt(i, this.modTit.findColumn("codigoEstacao")));
                if (!hash.get("Sel").equals(true)) continue;
                sel.add(hash);
            }
            return sel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o == this.buttonOK || o == this.buttonCancelar) {
                this.ok = o == this.buttonOK;
                this.dispose();
            } else if (o == this.buttonMarcarTodos || o == this.buttonDesmarcarTodos) {
                boolean marcar = o == this.buttonMarcarTodos;
                for (int i = 0; i < this.modTit.getRowCount(); ++i) {
                    this.modTit.setValueAt(marcar, i, this.modTit.findColumn("Sel"));
                }
                this.modTit.fireTableDataChanged();
            } else if (o == this.buttonDataVctoIni) {
                Funcoes.mostraData(this.textDataVctoIni, this.buttonDataVctoIni, (JPanel)this.buttonDataVctoIni.getParent(), true);
            } else if (o == this.buttonDataVctoFin) {
                Funcoes.mostraData(this.textDataVctoFin, this.buttonDataVctoFin, (JPanel)this.buttonDataVctoFin.getParent(), true);
            } else if (o == this.buttonConsultar) {
                this.consultarLancamentos();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void consultarLancamentos() {
            Statement st = Conexao.getStatement();
            if (st != null) {
                try {
                    this.buttonConsultar.setEnabled(false);
                    this.modTit.clear();
                    ResultSet res = Conexao.executeQuery(st, this.getSelect());
                    while (res.next()) {
                        Object[] obj = new Object[]{res.getInt("codigoLancto"), Tipos.tipoLancamentoCaixa(res.getString("tipoLancto")), res.getString("documentoLancto"), res.getString("cheque"), res.getString("descricaoConta"), Funcoes.formataData("dd/MM/yyyy", res.getDate("vencimentoLancto")), Funcoes.formataDecimal(res.getDouble("valorTotalLancto")), new Boolean(false), res.getInt("codigoEstacao")};
                        this.modTit.addLine(obj);
                    }
                    this.modTit.fireTableDataChanged();
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                }
                finally {
                    this.buttonConsultar.setEnabled(true);
                }
            }
        }

        private String getSelect() {
            StringBuilder buf = new StringBuilder();
            try {
                buf.append(" select lcx.lcx_codigo as codigoLancto, ");
                buf.append("        lcx.lcx_tipo as tipoLancto, ");
                buf.append("        lcx.lcx_documento as documentoLancto, ");
                buf.append("        lcx.lcx_nrcheque as cheque, ");
                buf.append("        cco.cco_conta as descricaoConta, ");
                buf.append("        lcx.lcx_vencimento as vencimentoLancto, ");
                buf.append("        lcx.lcx_valortotal as valorTotalLancto, ");
                buf.append("  \t\tfalse as ").append(SELECIONADO).append(", ");
                buf.append("        lcx.est_codigo as codigoEstacao ");
                buf.append("   from lanctocaixa lcx ");
                buf.append("   left join contacorrente cco on (lcx.fil_codigo = cco.fil_codigo and lcx.cco_reduzido = cco.cco_reduzido)");
                buf.append("  where lcx.fil_codigo = ").append(Variaveis.filialPadrao).append(" ");
                buf.append("    and lcx.lcx_situacao = '").append("A").append("' ");
                if (Funcoes.verificaData(this.textDataVctoIni.getText())) {
                    buf.append("and lcx.lcx_vencimento >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.textDataVctoIni.getText())).append("' ");
                }
                if (Funcoes.verificaData(this.textDataVctoFin.getText())) {
                    buf.append("and lcx.lcx_vencimento <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.textDataVctoFin.getText())).append("' ");
                }
                if (!Funcoes.textoVazio(this.textNumeroDoc)) {
                    buf.append(" and lcx.lcx_documento ilike '%").append(this.textNumeroDoc.getText()).append("%' ");
                }
                if (!Funcoes.textoVazio(this.textCheque)) {
                    buf.append(" and lcx.lcx_nrcheque ilike '%").append(this.textCheque.getText()).append("%' ");
                }
                if (!Funcoes.textoVazio(this.textValorIni)) {
                    buf.append(" and lcx.lcx_valortotal >= ").append(Funcoes.limpaDecimal(this.textValorIni.getText()));
                }
                if (!Funcoes.textoVazio(this.textValorFin)) {
                    buf.append(" and lcx.lcx_valortotal <= ").append(Funcoes.limpaDecimal(this.textValorFin.getText()));
                }
                StringBuilder bufWhere = new StringBuilder();
                String aux = this.getSelecionadosFiltro(this.itemConta, 0);
                if (aux != null) {
                    bufWhere.append(" cco.cco_reduzido IN (").append(aux).append(") ");
                }
                if (bufWhere.toString().length() > 0) {
                    buf.append(" and ( ");
                    buf.append(bufWhere.toString());
                    buf.append(" ) ");
                }
                buf.append("  order by lcx.lcx_codigo ");
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Conciliacao:DialogoFiltroLancamentos:getSelect()");
            }
            return buf.toString();
        }

        private String getSelecionadosFiltro(CheckItemFiltro itemFiltro, int coluna) {
            if (itemFiltro == null || coluna < 0) {
                return null;
            }
            String[] aux = itemFiltro.getSelecionados(coluna);
            StringBuilder result = new StringBuilder();
            if (aux == null || aux.length == 0) {
                return null;
            }
            for (int i = 0; i < aux.length; ++i) {
                result.append(aux[i]);
                if (i >= aux.length - 1) continue;
                result.append(",");
            }
            return result.toString();
        }

        private void iniciar() {
            this.getContentPane().setLayout(new GridBagLayout());
            JPanel panelBotoes = new JPanel(new BorderLayout());
            panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, this.buttonMarcarTodos, this.buttonDesmarcarTodos), "West");
            panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonOK, this.buttonCancelar), "East");
            JPanel panelTabela = new JPanel(new BorderLayout());
            panelTabela.setBorder(BorderFactory.createTitledBorder("Lan\u00e7amentos"));
            this.table = new JTable(this.modTit);
            this.modTit.setColumnSize(new int[]{60, 70, 85, 97, 0, 90, 90, 20, -1}, this.table);
            this.table.getTableHeader().addMouseListener(this.modTit);
            this.table.getColumn("codigoEstacao").setMaxWidth(-1);
            this.table.getColumn("codigoEstacao").setMinWidth(-1);
            this.table.getColumn("codigoEstacao").setWidth(-1);
            this.table.getColumn("codigoEstacao").setPreferredWidth(-1);
            this.table.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int row;
                    int[] colunas = ((JTable)e.getSource()).getSelectedColumns();
                    boolean colunaSelecionada = false;
                    for (int i = 0; i < colunas.length; ++i) {
                        if (colunas[i] != DialogoFiltroLancamentos.this.modTit.findColumn("Sel")) continue;
                        colunaSelecionada = true;
                        break;
                    }
                    if (e.getKeyCode() == 32 && !colunaSelecionada && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0) {
                        Boolean valor = (Boolean)DialogoFiltroLancamentos.this.modTit.getValueAt(row, DialogoFiltroLancamentos.this.modTit.findColumn("Sel"));
                        DialogoFiltroLancamentos.this.modTit.setValueAt(valor == false, row, DialogoFiltroLancamentos.this.modTit.findColumn("Sel"));
                    }
                }
            });
            JScrollPane scroll = new JScrollPane(this.table);
            scroll.setPreferredSize(new Dimension(670, 200));
            panelTabela.add((Component)scroll, "Center");
            JPanel panelFiltros = new JPanel(new GridBagLayout());
            panelFiltros.setBorder(BorderFactory.createTitledBorder("Filtros"));
            this.itemConta = new CheckItemFiltro("Conta", "Filtrar", "Filtrando Contas Corrente/Caixa", "fil_codigo = " + Variaveis.filialPadrao);
            this.itemConta.setDados("contacorrente", new String[]{"cco_reduzido", "cco_conta"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
            this.itemConta.setColunaHint(1);
            Dimension d = new Dimension(40, 20);
            this.itemConta.setPreferredSize(d);
            this.itemConta.setMinimumSize(d);
            d = new Dimension(90, 20);
            this.textDataVctoIni.setPreferredSize(d);
            this.textDataVctoIni.setMinimumSize(d);
            this.buttonDataVctoIni.setFocusable(false);
            this.textDataVctoFin.setPreferredSize(new Dimension(90, 20));
            this.buttonDataVctoFin.setFocusable(false);
            d = new Dimension(90, 20);
            this.textNumeroDoc.setPreferredSize(d);
            this.textNumeroDoc.setMinimumSize(d);
            d = new Dimension(90, 20);
            this.textCheque.setPreferredSize(d);
            this.textCheque.setMinimumSize(d);
            this.textValorIni.setPreferredSize(d);
            this.textValorIni.setMinimumSize(d);
            this.textValorFin.setPreferredSize(d);
            this.textValorFin.setMinimumSize(d);
            this.buttonConsultar.setPreferredSize(d);
            this.buttonConsultar.setMinimumSize(d);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.anchor = 17;
            c.gridwidth = 2;
            c.gridheight = 1;
            c.fill = 2;
            panelFiltros.add((Component)this.itemConta, c);
            c.fill = 0;
            c.gridx += 3;
            c.gridwidth = 1;
            c.insets = new Insets(0, 20, 0, 0);
            panelFiltros.add((Component)new JLabel("N\u00famero Doc.:"), c);
            c.insets = new Insets(0, 0, 0, 0);
            ++c.gridx;
            panelFiltros.add((Component)this.textNumeroDoc, c);
            c.gridx += 2;
            c.insets = new Insets(0, 20, 0, 0);
            panelFiltros.add((Component)new JLabel("Cheque/Aut. D\u00e9b.:"), c);
            ++c.gridx;
            c.insets = new Insets(0, 0, 0, 0);
            panelFiltros.add((Component)this.textCheque, c);
            ++c.gridy;
            c.gridx = 0;
            c.fill = 0;
            c.gridwidth = 1;
            c.weightx = 0.0;
            panelFiltros.add((Component)new JLabel("Dt. Vencto. Inicial:"), c);
            ++c.gridx;
            panelFiltros.add((Component)this.textDataVctoIni, c);
            ++c.gridx;
            panelFiltros.add((Component)this.buttonDataVctoIni, c);
            ++c.gridx;
            c.insets = new Insets(0, 20, 0, 0);
            panelFiltros.add((Component)new JLabel("Dt. Vencto. Final:"), c);
            c.insets = new Insets(0, 0, 0, 0);
            ++c.gridx;
            panelFiltros.add((Component)this.textDataVctoFin, c);
            ++c.gridx;
            panelFiltros.add((Component)this.buttonDataVctoFin, c);
            ++c.gridy;
            c.gridx = 0;
            panelFiltros.add((Component)new JLabel("Vl. Total Inicial:"), c);
            ++c.gridx;
            panelFiltros.add((Component)this.textValorIni, c);
            c.gridx += 2;
            c.insets = new Insets(0, 20, 0, 0);
            panelFiltros.add((Component)new JLabel("Vl. Total Final:"), c);
            c.insets = new Insets(0, 0, 0, 0);
            ++c.gridx;
            panelFiltros.add((Component)this.textValorFin, c);
            c.gridx += 3;
            c.fill = 0;
            c.anchor = 12;
            panelFiltros.add((Component)this.buttonConsultar, c);
            Container panelPrinc = this.getContentPane();
            panelPrinc.setLayout(new GridBagLayout());
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 18;
            c.fill = 2;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.insets = new Insets(1, 1, 1, 1);
            c.weightx = 0.0;
            c.weighty = 0.0;
            panelPrinc.add((Component)panelFiltros, c);
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 1.0;
            c.fill = 1;
            panelPrinc.add((Component)panelTabela, c);
            ++c.gridy;
            panelPrinc.add((Component)panelBotoes, c);
            Funcoes.montaEnter((JComponent)this.getContentPane());
            ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(113, 0, true), "F2", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogoFiltroLancamentos.this.textDataVctoIni.hasFocus()) {
                        Funcoes.mostraData(DialogoFiltroLancamentos.this.textDataVctoIni, DialogoFiltroLancamentos.this.buttonDataVctoIni, (JPanel)DialogoFiltroLancamentos.this.buttonDataVctoIni.getParent(), true);
                    } else if (DialogoFiltroLancamentos.this.textDataVctoFin.hasFocus()) {
                        Funcoes.mostraData(DialogoFiltroLancamentos.this.textDataVctoFin, DialogoFiltroLancamentos.this.buttonDataVctoFin, (JPanel)DialogoFiltroLancamentos.this.buttonDataVctoFin.getParent(), true);
                    }
                }
            });
            this.pack();
            d = new Dimension(250, 200);
            this.setPreferredSize(d);
            this.setMinimumSize(d);
            this.setResizable(false);
            ScreenUtil.centralizar(this);
        }
    }

    public class DetalhesLancamento
    extends Detalhes {
        Integer codigoHistorico;
        String descricaoHistorico;
        String tipoDocumento;
        String documento;
        String tipoPagamento;
        Double valorBruto;
        Double valorDesconto;
        Double valorJuro;
        Double valorAcrescimo;
        Double valorMulta;

        public DetalhesLancamento(int situacao) {
            super(situacao);
            this.valorAcrescimo = this.valorMulta = Double.valueOf(0.0);
            this.valorJuro = this.valorMulta;
            this.valorDesconto = this.valorMulta;
            this.valorBruto = this.valorMulta;
            this.tipoPagamento = "";
            this.documento = "";
            this.tipoDocumento = "";
            this.descricaoHistorico = "";
            this.codigoHistorico = 0;
            this.setFont(this.getFont().deriveFont(11.0f));
        }

        @Override
        public void montaExpandido() {
            this.setPreferredSize(new Dimension(10, 60));
            super.montaExpandido();
        }

        @Override
        public void montaReduzido() {
            this.setPreferredSize(new Dimension(10, 20));
            super.montaReduzido();
        }

        public void setDados(Integer codigoHistorico, String descricaoHistorico, String tipoDocumento, String documento, String tipoPagamento, Double valorBruto, Double valorDesconto, Double valorJuro, Double valorAcrescimo, Double valorMulta) {
            this.codigoHistorico = codigoHistorico;
            this.descricaoHistorico = descricaoHistorico;
            this.tipoDocumento = tipoDocumento;
            this.documento = documento;
            this.tipoPagamento = tipoPagamento;
            this.valorAcrescimo = valorAcrescimo;
            this.valorBruto = valorBruto;
            this.valorDesconto = valorDesconto;
            this.valorJuro = valorJuro;
            this.valorAcrescimo = valorAcrescimo;
            this.valorMulta = valorMulta;
            this.atualizarDados();
        }

        @Override
        public void atualizarDados() {
            if (this.getSituacao() == 2) {
                this.limpaDados();
            } else {
                StringBuilder html = new StringBuilder();
                html.append("<html>");
                html.append("<table>");
                html.append("<font size=4>");
                html.append("<tr>");
                html.append("<td><b>Hist\u00f3rico:</b></td>");
                html.append("<td width=180>").append(this.codigoHistorico == 0 ? "" : this.codigoHistorico + " - ").append(this.descricaoHistorico).append("</td>");
                html.append("<td> - </td>");
                html.append("<td><b>Documento:</b></td>");
                html.append("<td width=65>").append(this.documento == null ? "" : this.documento).append("</td>");
                html.append("<td> - </td>");
                html.append("<td><b>Valor Bruto:</b></td>");
                html.append("<td align=\"right\" width=65>").append(Funcoes.formataDecimal("0.00", this.valorBruto)).append("</td>");
                html.append("</tr><tr>");
                html.append("<td><b>Tp. Documento:</b></td>");
                html.append("<td>").append(this.tipoDocumento).append("</td>");
                html.append("<td> - </td>");
                html.append("<td><b>Valor Desconto:</b></td>");
                html.append("<td align=\"right\">").append(Funcoes.formataDecimal("0.00", this.valorDesconto)).append("</td>");
                html.append("<td> - </td>");
                html.append("<td><b>Valor Juro:</b></td>");
                html.append("<td align=\"right\">").append(Funcoes.formataDecimal("0.00", this.valorJuro)).append("</td>");
                html.append("</tr><tr>");
                html.append("<td><b>Tp. Pagamento:</b></td>");
                html.append("<td>").append(this.tipoPagamento).append("</td>");
                html.append("<td> - </td>");
                html.append("<td><b>Valor Multa:</b></td>");
                html.append("<td align=\"right\">").append(Funcoes.formataDecimal("0.00", this.valorMulta)).append("</td>");
                html.append("<td> - </td>");
                html.append("<td><b>Valor Acr\u00e9scimo:</b></td>");
                html.append("<td align=\"right\">").append(Funcoes.formataDecimal("0.00", this.valorAcrescimo)).append("</td>");
                html.append("</tr>");
                html.append("</font>");
                html.append("</table>");
                html.append("</html>");
                this.setDetalhes(html.toString());
            }
        }

        public void atualizarDados(String html) {
            if (html.toString().equals("") || this.getSituacao() == 2) {
                this.limpaDados();
            } else {
                this.setDetalhes(html.toString());
            }
        }
    }

    class LancamentoRenderer
    extends DefaultTableCellRenderer {
        @Override
        public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            this.setValue(value);
            if (selected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (Conciliacao.this.modelLancamentos.getValueAt(row, Conciliacao.this.modelLancamentos.getColumnCount() - 1) != null) {
                LancamentoBean b = (LancamentoBean)Conciliacao.this.modelLancamentos.getValueAt(row, Conciliacao.this.modelLancamentos.getColumnCount() - 1);
                if (b.isPlanoContaErrado() && b.isCentroCustoErrado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_CENTROCUSTO_ERRADO);
                } else if (b.isPlanoContaErrado() && b.isPlanoContaNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_NAO_CONFIGURADO);
                } else if (b.isPlanoContaErrado() && !b.isPlanoContaNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_ERRADO);
                } else if (b.isCentroCustoErrado() && b.isCentroCustoNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_CENTROCUSTO_NAO_CONFIGURADO);
                } else if (b.isCentroCustoErrado() && !b.isCentroCustoNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_CENTROCUSTO_ERRADO);
                } else if (b.isPlanoContaNaoConfigurado() && b.isCentroCustoNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_CENTROCUSTO_NAO_CONFIGURADO);
                } else if (b.isPlanoContaNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_NAO_CONFIGURADO);
                } else if (b.isCentroCustoNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_CENTROCUSTO_NAO_CONFIGURADO);
                }
                if (selected && c.getBackground() != table.getSelectionBackground()) {
                    c.setBackground(ScreenUtil.escurecerCor(c.getBackground(), 30));
                }
            }
            if (focused) {
                Border border = selected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.focusCellHighlightBorder");
                ((JComponent)c).setBorder(border);
                if (!selected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        c.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        c.setBackground(col);
                    }
                }
            } else {
                ((JComponent)c).setBorder(noFocusBorder);
            }
            return c;
        }
    }
}

