/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.financeiro.lancamentos.FrmCadPadraoBeanLancamento;
import jalis.laboratorio.financeiro.lancamentos.SelecionarLancamentoLocalizado;
import jalis.laboratorio.financeiro.lancamentos.componente.PanelPlanoContaCentroCusto;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.financeiro.MotivoCancelamentoBean;
import jalis.model.bean.financeiro.BaixaBean;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.financeiro.MotivoCancelamentoVO;
import jalis.model.vo.financeiro.LancamentoVO;
import jalis.service.cadastro.financeiro.MotivoCancelamentoService;
import jalis.service.financeiro.LancamentoService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class Cancelamento
extends FrmCadPadraoBeanLancamento {
    private JLabel lblCodigo = new JLabel("C\u00f3digo:");
    private JLabel lblContaCorrente = new JLabel("Conta Corrente:");
    private JLabel lblDocumento = new JLabel("Documento:");
    private JLabel lblVencimento = new JLabel("Vencimento:");
    private JLabel lblValor = new JLabel("Valor:");
    private JLabel lblConciliacao = new JLabel("Concilia\u00e7\u00e3o:");
    private JLabel lblTipo = new JLabel("Tipo:");
    private JLabel lblTipoDocumento = new JLabel("Tipo Documento:");
    private JLabel lblObservacao = new JLabel("Observa\u00e7\u00e3o:");
    private JLabel lblValorMulta = new JLabel(" (+) Multa:");
    private JLabel lblValorJuro = new JLabel(" (+) Juro:");
    private JLabel lblValorAcrescimo = new JLabel(" (+) Acr\u00e9scimo:");
    private JLabel lblValorDesconto = new JLabel(" (-) Desconto:");
    private JLabel lblPercentualMulta = new JLabel("%");
    private JLabel lblPercentualJuro = new JLabel("%");
    private JLabel lblPercentualAcrescimo = new JLabel("%");
    private JLabel lblPercentualDesconto = new JLabel("%");
    private JLabel lblValorTotal = new JLabel("Valor Total");
    private JLabel lblDataCancelamento = new JLabel("Data Cancelamento:");
    private JLabel lblMotivoCancelamento = new JLabel("Motivo:");
    private JLabel lblDescricaoCancelamento = new JLabel("Observa\u00e7\u00e3o:");
    private JLabel lblVlrContaCorrente = new JLabel("");
    private JLabel lblVlrDocumento = new JLabel("");
    private JLabel lblVlrVencimento = new JLabel("");
    private JLabel lblVlrValor = new JLabel("");
    private JLabel lblVlrConciliacao = new JLabel("");
    private JLabel lblVlrTipo = new JLabel("");
    private JLabel lblVlrTipoDocumento = new JLabel("");
    private JLabel lblVlrValorMulta = new JLabel("");
    private JLabel lblVlrValorJuro = new JLabel("");
    private JLabel lblVlrValorDesconto = new JLabel("");
    private JLabel lblVlrValorAcrescimo = new JLabel("");
    private JLabel lblVlrPercentualMulta = new JLabel("");
    private JLabel lblVlrPercentualJuro = new JLabel("");
    private JLabel lblVlrPercentualDesconto = new JLabel("");
    private JLabel lblVlrPercentualAcrescimo = new JLabel("");
    private JLabel lblVlrValorTotal = new JLabel("");
    private JLabel lblVlrObservacao = new JLabel("");
    private TTextField textCodigo = new TTextField(10, 1);
    private TTextField textDataCancelamento = new TTextField(10, 4);
    private TTextField textCodigoMotivo = new TTextField(5, 1);
    private TTextField textDescricaoMotivo = new TTextField();
    private JButton buttonBuscaLancamento = new JButton();
    private JButton buttonBuscaMotivo = new JButton();
    private JButton buttonDataCancelamento = new JButton();
    private PanelPlanoContaCentroCusto panelPlanoContaCentroCusto = new PanelPlanoContaCentroCusto(null, PanelPlanoContaCentroCusto.TIPO_LANCAMENTO, 0L, 0L, Variaveis.filialPadrao);
    private JTextArea textObservacaoCancelamento = new JTextArea();
    private JScrollPane scrObservacao = new JScrollPane(this.lblVlrObservacao);
    private JScrollPane scrObservacaoCancelamento = new JScrollPane(this.textObservacaoCancelamento);
    JPanel panelMotivo;
    private HashSet planosContas;
    private HashSet centrosCusto;
    private EstacaoVO estacao = null;
    private MotivoCancelamentoService motivoCancelamentoService = new MotivoCancelamentoService();
    private boolean validacaoFeita = false;
    private long ACESSO_CANCELAMENTO_VISUALIZAR_PLANOCONTA_CENTROCUSTO = Long.parseLong("0600400302");
    private long ACESSO_ESTORNO_LANCAMENTO_VISUALIZAR_PLANOCONTA_CENTROCUSTO = Long.parseLong("0600400804");
    private long ACESSO_ESTORNO_TRANSFERENCIA_VISUALIZAR_PLANOCONTA_CENTROCUSTO = Long.parseLong("0600401004");
    private long ACESSO_CANCELAMENTO_EDITAR = Long.parseLong("0600400303");
    private long ACESSO_CANCELAMENTO_APAGAR = Long.parseLong("0600400304");
    public static final int TIPO_CANCELAMENTO = 1;
    public static final int TIPO_ESTORNO = 2;
    public static final int TIPO_ESTORNO_TRANSFERENCIA = 3;
    private static int tipoTela = 1;

    public Cancelamento(int tipoTela) {
        Cancelamento.tipoTela = tipoTela;
        if (tipoTela == 1) {
            this.setLabelDescricao("Realiza o cancelamento de lan\u00e7amentos financeiros n\u00e3o conciliados");
            this.setLabelFormulario("Cancelamento de Lan\u00e7amentos");
            this.setIcone(ImagemUtils.carregaImagemJalis("financeiro/cancela_lancamento.jpg"));
        } else if (tipoTela == 2) {
            this.setLabelDescricao("Realiza o estorno de lan\u00e7amentos financeiros conciliados");
            this.setLabelFormulario("Estorno de Lan\u00e7amentos");
            this.setIcone(ImagemUtils.carregaImagemJalis("financeiro/estorno_lancamento.jpg"));
        } else if (tipoTela == 3) {
            this.setLabelDescricao("Realiza o estorno de transfer\u00eancias entre contas");
            this.setLabelFormulario("Estorno de Transfer\u00eancias entre Contas");
            this.setIcone(ImagemUtils.carregaImagemJalis("financeiro/cancel_conciliacao.jpg"));
        }
        ScreenUtil.setBorda(new Component[]{this.lblVlrTipo, this.lblVlrTipoDocumento, this.lblVlrContaCorrente, this.lblVlrDocumento, this.lblVlrVencimento, this.lblVlrValor, this.lblVlrValorTotal, this.lblVlrValorMulta, this.lblVlrValorJuro, this.lblVlrValorDesconto, this.lblVlrValorAcrescimo, this.lblVlrPercentualMulta, this.lblVlrPercentualJuro, this.lblVlrPercentualDesconto, this.lblVlrPercentualAcrescimo, this.lblVlrValorTotal, this.lblVlrConciliacao}, new TitledBorder(""));
        Dimension d = new Dimension(78, 20);
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setMinimumSize(d);
        this.textCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Cancelamento.this.buscaCodigo(Cancelamento.this.textCodigo.getText(), Variaveis.codigoEstacao);
            }
        });
        this.buttonBuscaLancamento.setFocusable(false);
        this.buttonBuscaLancamento.setText("");
        d = new Dimension(20, 20);
        this.buttonBuscaLancamento.setPreferredSize(d);
        this.buttonBuscaLancamento.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaLancamento);
        this.buttonBuscaLancamento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cancelamento.this.buscaCodigo();
            }
        });
        d = new Dimension(100, 20);
        this.lblVlrConciliacao.setPreferredSize(d);
        this.lblVlrConciliacao.setMinimumSize(d);
        this.lblVlrVencimento.setPreferredSize(d);
        this.lblVlrVencimento.setMinimumSize(d);
        this.lblVlrValor.setPreferredSize(d);
        this.lblVlrValor.setMinimumSize(d);
        this.lblVlrValorMulta.setPreferredSize(d);
        this.lblVlrValorMulta.setMinimumSize(d);
        this.lblVlrTipo.setPreferredSize(d);
        this.lblVlrTipo.setMinimumSize(d);
        this.lblVlrTipoDocumento.setPreferredSize(d);
        this.lblVlrTipoDocumento.setMinimumSize(d);
        this.lblVlrValorJuro.setPreferredSize(d);
        this.lblVlrValorJuro.setMinimumSize(d);
        this.lblVlrValorAcrescimo.setPreferredSize(d);
        this.lblVlrValorAcrescimo.setMinimumSize(d);
        this.lblVlrValorDesconto.setPreferredSize(d);
        this.lblVlrValorDesconto.setMinimumSize(d);
        this.lblVlrValorTotal.setPreferredSize(d);
        this.lblVlrValorTotal.setMinimumSize(d);
        this.textDataCancelamento.setPreferredSize(d);
        this.textDataCancelamento.setMinimumSize(d);
        d = new Dimension(230, 20);
        this.lblVlrContaCorrente.setPreferredSize(d);
        this.lblVlrContaCorrente.setMinimumSize(d);
        d = new Dimension(300, 20);
        this.lblVlrDocumento.setPreferredSize(d);
        this.lblVlrDocumento.setMinimumSize(d);
        d = new Dimension(70, 20);
        this.lblVlrPercentualMulta.setPreferredSize(d);
        this.lblVlrPercentualMulta.setMinimumSize(d);
        this.lblVlrPercentualJuro.setPreferredSize(d);
        this.lblVlrPercentualJuro.setMinimumSize(d);
        this.lblVlrPercentualAcrescimo.setPreferredSize(d);
        this.lblVlrPercentualAcrescimo.setMinimumSize(d);
        this.lblVlrPercentualDesconto.setPreferredSize(d);
        this.lblVlrPercentualDesconto.setMinimumSize(d);
        this.textCodigoMotivo.setPreferredSize(d);
        this.textCodigoMotivo.setMinimumSize(d);
        this.textCodigoMotivo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Cancelamento.this.buscaMotivo(Cancelamento.this.textCodigoMotivo.getText());
            }
        });
        d = new Dimension(100, 30);
        this.scrObservacao.setPreferredSize(d);
        this.scrObservacao.setMinimumSize(d);
        ScreenUtil.montaSaidaTextArea(this.textObservacaoCancelamento);
        d = new Dimension(20, 20);
        this.buttonDataCancelamento.setPreferredSize(d);
        this.buttonDataCancelamento.setMinimumSize(d);
        this.buttonDataCancelamento.setMargin(new Insets(2, 2, 2, 2));
        Funcoes.imagemPesquisa(this.buttonDataCancelamento);
        this.buttonDataCancelamento.setFocusable(false);
        this.buttonDataCancelamento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cancelamento.this.buscaDataCancelamento();
            }
        });
        this.buttonBuscaMotivo.setFocusable(false);
        this.buttonBuscaMotivo.setText("");
        this.buttonBuscaMotivo.setPreferredSize(d);
        this.buttonBuscaMotivo.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaMotivo);
        this.buttonBuscaMotivo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cancelamento.this.buscaMotivo();
            }
        });
        d = new Dimension(200, 20);
        this.textDescricaoMotivo.setPreferredSize(d);
        this.textDescricaoMotivo.setMinimumSize(d);
        this.textDescricaoMotivo.setEditable(false);
        this.textDescricaoMotivo.setFocusable(false);
        d = new Dimension(20, 30);
        this.scrObservacaoCancelamento.setPreferredSize(d);
        this.scrObservacaoCancelamento.setMinimumSize(d);
        this.painelCentral.setLayout(new GridBagLayout());
        this.panelPlanoContaCentroCusto.setBorder(null);
        d = new Dimension(20, 20);
        this.panelPlanoContaCentroCusto.setPreferredSize(d);
        this.panelPlanoContaCentroCusto.setMinimumSize(d);
        this.panelPlanoContaCentroCusto.controlaCampos(false);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.lblCodigo.setLabelFor(this.textCodigo);
        this.lblCodigo.setDisplayedMnemonic('i');
        this.painelCentral.add((Component)this.lblCodigo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.buttonBuscaLancamento, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.lblTipo, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.lblVlrTipo, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.lblContaCorrente, c);
        ++c.gridx;
        c.gridwidth = 9;
        c.fill = 2;
        c.weightx = 1.0;
        this.painelCentral.add((Component)this.lblVlrContaCorrente, c);
        c.fill = 0;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.painelCentral.add((Component)this.lblTipoDocumento, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.lblVlrTipoDocumento, c);
        c.gridx += 2;
        c.insets = new Insets(1, 20, 1, 1);
        this.painelCentral.add((Component)this.lblDocumento, c);
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx += 2;
        c.gridwidth = 5;
        c.fill = 2;
        this.painelCentral.add((Component)this.lblVlrDocumento, c);
        c.fill = 0;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.lblObservacao, c);
        ++c.gridx;
        c.gridwidth = 9;
        c.fill = 2;
        this.painelCentral.add((Component)this.scrObservacao, c);
        c.fill = 0;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.lblVencimento, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.lblVlrVencimento, c);
        c.gridx += 2;
        c.insets = new Insets(1, 20, 1, 1);
        this.painelCentral.add((Component)this.lblConciliacao, c);
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx += 2;
        this.painelCentral.add((Component)this.lblVlrConciliacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.lblValor, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.lblVlrValor, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.lblValorMulta, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.lblVlrValorMulta, c);
        c.gridx += 2;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.lblVlrPercentualMulta, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.lblPercentualMulta, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.lblValorJuro, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.lblVlrValorJuro, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.lblVlrPercentualJuro, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.lblPercentualJuro, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.lblValorAcrescimo, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.lblVlrValorAcrescimo, c);
        c.gridx += 2;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.lblVlrPercentualAcrescimo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.lblPercentualAcrescimo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.lblValorDesconto, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.lblVlrValorDesconto, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.lblVlrPercentualDesconto, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.lblPercentualDesconto, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.lblValorTotal, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.lblVlrValorTotal, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 10;
        c.fill = 1;
        if (tipoTela == 1 && Acesso.getAcesso(this.ACESSO_CANCELAMENTO_VISUALIZAR_PLANOCONTA_CENTROCUSTO)) {
            this.painelCentral.add((Component)this.panelPlanoContaCentroCusto, c);
        } else if (tipoTela == 2 && Acesso.getAcesso(this.ACESSO_ESTORNO_LANCAMENTO_VISUALIZAR_PLANOCONTA_CENTROCUSTO)) {
            this.painelCentral.add((Component)this.panelPlanoContaCentroCusto, c);
        } else if (tipoTela == 3 && Acesso.getAcesso(this.ACESSO_ESTORNO_TRANSFERENCIA_VISUALIZAR_PLANOCONTA_CENTROCUSTO)) {
            this.painelCentral.add((Component)this.panelPlanoContaCentroCusto, c);
        } else {
            this.painelCentral.add((Component)new JPanel(), c);
        }
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 2;
        this.panelMotivo = new JPanel(new GridBagLayout());
        this.painelCentral.add((Component)this.panelMotivo, c);
        c.gridx = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = new Insets(10, 1, 1, 1);
        this.lblDataCancelamento.setLabelFor(this.textDataCancelamento);
        this.lblDataCancelamento.setDisplayedMnemonic('D');
        this.panelMotivo.add((Component)this.lblDataCancelamento, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.panelMotivo.add((Component)this.textDataCancelamento, c);
        c.gridx += 2;
        c.gridwidth = 1;
        this.panelMotivo.add((Component)this.buttonDataCancelamento, c);
        ++c.gridx;
        c.insets = new Insets(10, 20, 1, 1);
        this.lblMotivoCancelamento.setLabelFor(this.textCodigoMotivo);
        this.lblMotivoCancelamento.setDisplayedMnemonic('M');
        this.panelMotivo.add((Component)this.lblMotivoCancelamento, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.insets = new Insets(10, 1, 1, 1);
        this.panelMotivo.add((Component)this.textCodigoMotivo, c);
        c.gridx += 2;
        c.gridwidth = 1;
        this.panelMotivo.add((Component)this.buttonBuscaMotivo, c);
        ++c.gridx;
        c.fill = 2;
        c.gridwidth = 5;
        this.panelMotivo.add((Component)this.textDescricaoMotivo, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = new Insets(1, 1, 1, 1);
        this.lblDescricaoCancelamento.setLabelFor(this.textObservacaoCancelamento);
        this.lblDescricaoCancelamento.setDisplayedMnemonic('b');
        this.panelMotivo.add((Component)this.lblDescricaoCancelamento, c);
        ++c.gridx;
        c.gridwidth = 12;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelMotivo.add((Component)this.scrObservacaoCancelamento, c);
        this.service = new LancamentoService();
        this.controlaCampos();
    }

    @Override
    protected void controlaCampos() {
        boolean habilitar = this.getStatus() == 3 || this.getStatus() == 2;
        this.textCodigo.setEnabled(habilitar);
        this.buttonBuscaLancamento.setEnabled(habilitar);
        this.textDataCancelamento.setEnabled(habilitar);
        this.buttonDataCancelamento.setEnabled(habilitar);
        this.textObservacaoCancelamento.setEnabled(habilitar);
        this.textCodigoMotivo.setEnabled(habilitar);
        this.textDescricaoMotivo.setEnabled(habilitar);
        this.buttonBuscaMotivo.setEnabled(habilitar);
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        LancamentoBean lancamento = new LancamentoBean();
        lancamento.setFilial(filial);
        lancamento.setEstacao(this.estacao);
        lancamento.setUsuarioCancelado(usuario);
        if (this.getStatus() == 3) {
            lancamento.setCodigo(Integer.parseInt(this.textCodigo.getText()));
        }
        lancamento.setDataCancelado(Funcoes.textoVazio(this.textDataCancelamento.getText()) ? null : Funcoes.stringToDate(this.textDataCancelamento.getText()));
        lancamento.setSituacao("C");
        MotivoCancelamentoVO motivo = new MotivoCancelamentoVO();
        motivo.setFilial(filial);
        motivo.setCodigo(Integer.parseInt(this.textCodigoMotivo.getText()));
        motivo.setDescricao(this.textDescricaoMotivo.getTextDB());
        lancamento.setMotivoCancelado(motivo);
        lancamento.setDescricaoCancelado(this.textObservacaoCancelamento.getText());
        if (!Funcoes.textoVazio(this.lblTipo.getText())) {
            if (this.lblTipo.getText().equalsIgnoreCase(Tipos.tipoLancamentoCaixa("C"))) {
                lancamento.setTipo("C");
            } else {
                lancamento.setTipo("D");
            }
        }
        return lancamento;
    }

    @Override
    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    protected void limparCampos() {
        this.textCodigo.setText("");
        this.lblVlrContaCorrente.setText("");
        this.lblVlrDocumento.setText("");
        this.lblVlrVencimento.setText("");
        this.lblVlrValor.setText("");
        this.lblVlrConciliacao.setText("");
        this.lblVlrTipo.setText("");
        this.lblVlrTipoDocumento.setText("");
        this.lblVlrValorMulta.setText("");
        this.lblVlrValorJuro.setText("");
        this.lblVlrValorDesconto.setText("");
        this.lblVlrValorAcrescimo.setText("");
        this.lblVlrPercentualMulta.setText("");
        this.lblVlrPercentualJuro.setText("");
        this.lblVlrPercentualDesconto.setText("");
        this.lblVlrPercentualAcrescimo.setText("");
        this.lblVlrValorTotal.setText("");
        this.lblVlrObservacao.setText("");
        this.textDataCancelamento.setText("");
        this.textCodigoMotivo.setText("");
        this.textDescricaoMotivo.setText("");
        this.textObservacaoCancelamento.setText("");
        this.estacao = null;
        this.panelPlanoContaCentroCusto.limparCampos();
        this.validacaoFeita = false;
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        LancamentoBean lancamento = (LancamentoBean)bean;
        this.textCodigo.setText(Integer.toString(lancamento.getCodigo()));
        this.lblVlrContaCorrente.setText(lancamento.getContaCorrente().getConta());
        this.lblVlrDocumento.setText(lancamento.getNumeroDocumento());
        this.lblVlrVencimento.setText(Funcoes.formataData("dd/MM/yyyy", lancamento.getDataVencimento()));
        this.lblVlrValor.setText(Funcoes.formataDecimal("0.00", lancamento.getValor()));
        this.lblVlrConciliacao.setText(Funcoes.formataData("dd/MM/yyyy", lancamento.getDataConciliacao()));
        this.lblVlrTipo.setText(Tipos.tipoLancamentoCaixa(lancamento.getTipo()));
        this.lblVlrTipoDocumento.setText(Tipos.tipoDocumento(lancamento.getTipoDocumento()));
        this.lblVlrValorMulta.setText(Funcoes.formataDecimal("0.00", lancamento.getValorMulta()));
        this.lblVlrValorJuro.setText(Funcoes.formataDecimal("0.00", lancamento.getValorJuro()));
        this.lblVlrValorDesconto.setText(Funcoes.formataDecimal("0.00", lancamento.getValorDesconto()));
        this.lblVlrValorAcrescimo.setText(Funcoes.formataDecimal("0.00", lancamento.getValorAcrescimo()));
        this.lblVlrPercentualMulta.setText(Funcoes.formataDecimal("0.00", lancamento.getPercentualMulta()));
        this.lblVlrPercentualJuro.setText(Funcoes.formataDecimal("0.00", lancamento.getPercentualJuro()));
        this.lblVlrPercentualDesconto.setText(Funcoes.formataDecimal("0.00", lancamento.getPercentualDesconto()));
        this.lblVlrPercentualAcrescimo.setText(Funcoes.formataDecimal("0.00", lancamento.getPercentualAcrescimo()));
        this.lblVlrValorTotal.setText(Funcoes.formataDecimal("0.00", lancamento.getValorTotal()));
        if (lancamento.getObservacao() != null) {
            this.lblVlrObservacao.setText("<html>" + lancamento.getObservacao() + "</html>");
        } else {
            this.lblVlrObservacao.setText("");
        }
        this.estacao = lancamento.getEstacao();
        this.textCodigo.setEnabled(false);
        this.panelPlanoContaCentroCusto.limparCampos();
        this.panelPlanoContaCentroCusto.setBean(lancamento);
        this.planosContas = (HashSet)lancamento.getPlanosContas();
        this.panelPlanoContaCentroCusto.setPlanoContas(this.planosContas);
        this.panelPlanoContaCentroCusto.popularPlanoConta();
        this.centrosCusto = (HashSet)lancamento.getCentrosCusto();
        this.panelPlanoContaCentroCusto.setCentrosCusto(this.centrosCusto);
        this.panelPlanoContaCentroCusto.popularCentroCusto();
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textCodigo)) {
            Funcoes.mensagem(this, "O lan\u00e7amento deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
            return false;
        }
        if (Funcoes.textoVazio(this.textDataCancelamento.getText()) || !Funcoes.verificaData(this.textDataCancelamento.getText())) {
            Funcoes.mensagem(this, "Data de cancelamento inv\u00e1lida", 2);
            ScreenUtil.requisitarFoco(this.textDataCancelamento);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodigoMotivo.getText()) || this.textDescricaoMotivo.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Motivo cancelamento n\u00e3o preenchido", 2);
            ScreenUtil.requisitarFoco(this.textCodigoMotivo);
            return false;
        }
        try {
            MotivoCancelamentoVO motivo = (MotivoCancelamentoVO)this.motivoCancelamentoService.getVO(Variaveis.filialPadrao, this.textCodigoMotivo.getText());
            MotivoCancelamentoBean m = (MotivoCancelamentoBean)this.motivoCancelamentoService.voToBean(motivo, MotivoCancelamentoBean.class);
            if (m.getExigeJustificativa().booleanValue() && Funcoes.textoVazio(this.textObservacaoCancelamento.getText())) {
                Funcoes.mensagem(this, "Observa\u00e7\u00e3o do motivo cancelamento n\u00e3o preenchido", 2);
                ScreenUtil.requisitarFoco(this.textObservacaoCancelamento);
                return false;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "Cancelamento:667");
        }
        return true;
    }

    private void buscaCodigo(String codigoLancamento, String codigoEstacao) {
        if (Funcoes.textoVazio(codigoLancamento)) {
            this.limparCampos();
            return;
        }
        try {
            Set lancamentos = ((LancamentoService)this.service).getVOs(Variaveis.filialPadrao, codigoLancamento);
            if (lancamentos == null || lancamentos != null && lancamentos.size() == 0) {
                Funcoes.mensagem(this, "Lan\u00e7amento n\u00e3o localizado", 2);
                ScreenUtil.requisitarFoco(this.textCodigo);
            } else if (lancamentos != null && lancamentos.size() == 1) {
                LancamentoBean lcto = (LancamentoBean)this.service.voToBean((LancamentoVO)lancamentos.toArray()[0], LancamentoBean.class);
                if (!this.validacaoFeita && !this.validaLancamento(lcto)) {
                    this.limparCampos();
                    this.textCodigo.setEnabled(true);
                    ScreenUtil.requisitarFoco(this.textCodigo);
                    return;
                }
                this.preencherCampos(lcto);
            } else {
                SelecionarLancamentoLocalizado sel = SelecionarLancamentoLocalizado.novaInstancia(this.getTopLevelAncestor());
                if (sel != null) {
                    for (Object o : lancamentos) {
                        if (!(o instanceof LancamentoVO)) continue;
                        sel.adicionarLancamentoVO((LancamentoVO)o);
                    }
                    sel.setVisible(true);
                    if (sel.getOK() && sel.getLancamentoSelecionado() != null) {
                        this.preencherCampos((LancamentoBean)this.service.voToBean(sel.getLancamentoSelecionado(), LancamentoBean.class));
                    } else {
                        Funcoes.mensagem(this, "Lan\u00e7amento n\u00e3o selecionado", 2);
                        ScreenUtil.requisitarFoco(this.textCodigo);
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Cancelamento:646");
        }
    }

    private void buscaCodigo() {
        try {
            this.limparCampos();
            LancamentoVO lancamento = null;
            if (tipoTela == 1) {
                lancamento = (LancamentoVO)((LancamentoService)this.service).pesquisaVO(this.getTopLevelAncestor(), new LancamentoVO(), "Pesquisando Lan\u00e7amentos Abertos", " and lcx_situacao = upper('A') ", true);
            } else if (tipoTela == 2) {
                lancamento = (LancamentoVO)((LancamentoService)this.service).pesquisaVO(this.getTopLevelAncestor(), new LancamentoVO(), "Pesquisando Lan\u00e7amentos Conciliados", " and lcx_situacao = upper('O') ", true);
            } else if (tipoTela == 3) {
                lancamento = (LancamentoVO)((LancamentoService)this.service).pesquisaVO(this.getTopLevelAncestor(), new LancamentoVO(), "Pesquisando Lan\u00e7amentos Conciliados", " and lcx_situacao <> upper('C') and lcx_tipoorigem = upper('E') ", true);
            }
            if (lancamento != null) {
                LancamentoVO v = lancamento;
                AbstractThreadBean tmp = ((LancamentoService)this.service).get(v.getFilial().getCodigo().toString(), v.getCodigo().toString(), v.getEstacao().getCodigo().toString());
                LancamentoBean lcto = null;
                if (null != tmp) {
                    lcto = (LancamentoBean)tmp;
                }
                if (!this.validaLancamento(lcto)) {
                    this.textCodigo.setEnabled(true);
                    ScreenUtil.requisitarFoco(this.textCodigo);
                    return;
                }
                this.preencherCampos(lcto);
                if (this.textDataCancelamento.isEnabled() && this.textDataCancelamento.isFocusable()) {
                    this.textDataCancelamento.grabFocus();
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Cancelamento:658");
        }
    }

    private void buscaDataCancelamento() {
        Funcoes.mostraData(this.textDataCancelamento, this.buttonDataCancelamento, this.panelMotivo, true);
    }

    private void buscaMotivo(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoMotivo.setText("");
            this.textDescricaoMotivo.setText("");
            return;
        }
        try {
            MotivoCancelamentoVO motivo = (MotivoCancelamentoVO)this.motivoCancelamentoService.getVO(Variaveis.filialPadrao, codigo);
            if (motivo != null) {
                this.textCodigoMotivo.setText(motivo.getCodigo().toString());
                this.textDescricaoMotivo.setText(motivo.getDescricao());
            } else {
                this.textDescricaoMotivo.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Cancelamento:576");
        }
    }

    private void buscaMotivo() {
        try {
            this.textCodigoMotivo.setText("");
            this.textDescricaoMotivo.setText("");
            MotivoCancelamentoVO motivo = (MotivoCancelamentoVO)this.motivoCancelamentoService.pesquisaVO(this.getTopLevelAncestor(), new MotivoCancelamentoVO(), "Pesquisando motivos de cancelamentos", true);
            if (motivo != null) {
                this.textCodigoMotivo.setText(motivo.getCodigo().toString());
                this.textDescricaoMotivo.setText(motivo.getDescricao());
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Cancelamento:591");
        }
    }

    @Override
    public void novo() {
        super.novo();
        this.setStatus(3);
        ScreenUtil.requisitarFoco(this.textCodigo);
    }

    @Override
    public void pressioneiF2() {
        if (this.textCodigoMotivo.hasFocus()) {
            this.buscaMotivo();
        } else if (this.textDataCancelamento.hasFocus()) {
            this.buscaDataCancelamento();
        } else if (this.textCodigo.hasFocus()) {
            this.buscaCodigo();
        }
    }

    @Override
    public void salvar() {
        AbstractThreadBean bean;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                if (tipoTela == 1) {
                    LancamentoBean auxBean = (LancamentoBean)bean;
                    boolean isCancelamentoOk = ((LancamentoService)this.service).estornoCancelamento((LancamentoBean)new LancamentoService().get(String.valueOf(auxBean.getFilial().getCodigo()), String.valueOf(auxBean.getCodigo()), String.valueOf(auxBean.getEstacao().getCodigo())), "T", true, null);
                    if (isCancelamentoOk) {
                        Funcoes.mensagem(this, "Lan\u00e7amento cancelado com sucesso.", 5);
                    } else {
                        Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel cancelar o lan\u00e7amento.", 2);
                    }
                } else if (tipoTela == 2) {
                    LancamentoBean auxBean = (LancamentoBean)bean;
                    boolean isEstornoOk = false;
                    isEstornoOk = Funcoes.mensagem(this, "Deseja gerar um lan\u00e7amento em aberto id\u00eantico ao original?", 4) == 0 ? ((LancamentoService)this.service).estornoCancelamento((LancamentoBean)new LancamentoService().get(String.valueOf(auxBean.getFilial().getCodigo()), String.valueOf(auxBean.getCodigo()), String.valueOf(auxBean.getEstacao().getCodigo())), "L", true, null) : ((LancamentoService)this.service).estornoCancelamento((LancamentoBean)new LancamentoService().get(String.valueOf(auxBean.getFilial().getCodigo()), String.valueOf(auxBean.getCodigo()), String.valueOf(auxBean.getEstacao().getCodigo())), "L", false, null);
                    if (isEstornoOk) {
                        Funcoes.mensagem(this, "Lan\u00e7amento estornado com sucesso.", 5);
                    } else {
                        Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel estornar o lan\u00e7amento.", 2);
                    }
                } else {
                    LancamentoBean auxBean = (LancamentoBean)bean;
                    boolean isEstornoOk = ((LancamentoService)this.service).estornoCancelamento((LancamentoBean)new LancamentoService().get(String.valueOf(auxBean.getFilial().getCodigo()), String.valueOf(auxBean.getCodigo()), String.valueOf(auxBean.getEstacao().getCodigo())), "S", true, null);
                    if (isEstornoOk) {
                        Funcoes.mensagem(this, "Lan\u00e7amento estornado com sucesso.", 5);
                    } else {
                        Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel estornar o lan\u00e7amento.", 2);
                    }
                }
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace());
            }
        }
    }

    private boolean validaLancamento(LancamentoBean lancamento) {
        this.validacaoFeita = false;
        if (lancamento.getSituacao() != null && lancamento.getSituacao().equalsIgnoreCase("C")) {
            Funcoes.mensagem(this, "O Lan\u00e7amento j\u00e1 foi cancelado.", 2);
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
            return false;
        }
        if (tipoTela == 1) {
            if (lancamento.getSituacao() != null && lancamento.getSituacao().equalsIgnoreCase("O")) {
                Funcoes.mensagem(this, "O Lan\u00e7amento est\u00e1 conciliado.\nLan\u00e7amentos conciliados apenas podem ser estornados.", 2);
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
                return false;
            }
        } else if (tipoTela == 2) {
            if (lancamento.getSituacao() != null && !lancamento.getSituacao().equalsIgnoreCase("O")) {
                Funcoes.mensagem(this, "O Lan\u00e7amento n\u00e3o est\u00e1 conciliado.\nLan\u00e7amentos n\u00e3o conciliados apenas podem ser cancelados.", 2);
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
                return false;
            }
            if (lancamento.getTipoOrigem() != null && lancamento.getTipoOrigem().equalsIgnoreCase("E")) {
                Funcoes.mensagem(this, "A origem do lan\u00e7amento \u00e9: " + Tipos.tipoOrigemLancamento(lancamento.getTipoOrigem()) + ".\nUse o Estorno de Transfer\u00eancia para estornar esse lan\u00e7amento.", 2);
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
                return false;
            }
        } else {
            boolean erro = false;
            if (lancamento.getTipoOrigem() != null && !lancamento.getTipoOrigem().equalsIgnoreCase("E")) {
                Funcoes.mensagem(this, "A origem do lan\u00e7amento \u00e9: " + Tipos.tipoOrigemLancamento(lancamento.getTipoOrigem()) + ".\nSomente lan\u00e7amentos de origem Transfer\u00eancia entre Contas podem usar o Estorno de Transfer\u00eancia.", 2);
                erro = true;
            }
            if (!erro && lancamento.getSituacao() != null && !lancamento.getSituacao().equalsIgnoreCase("O")) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel estornar a transfer\u00eancia.", 2);
                erro = true;
            }
            if (erro) {
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
                return false;
            }
        }
        if (!Funcoes.textoVazio(lancamento.getTipoOrigem())) {
            String auxTipoOrigem = lancamento.getTipoOrigem();
            if (auxTipoOrigem.equalsIgnoreCase("P")) {
                try {
                    lancamento = new LancamentoService().getPagamentoOrigem(lancamento);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar lan\u00e7amento de origem do pagamento.\n" + e.getMessage(), e.getStackTrace());
                    return false;
                }
                if (lancamento == null) {
                    Funcoes.mensagem(this, "Lan\u00e7amento de origem do pagamento n\u00e3o foi localizado.", 2);
                    return false;
                }
                auxTipoOrigem = lancamento.getTipoOrigem();
            }
            if (auxTipoOrigem.equalsIgnoreCase("B")) {
                try {
                    BaixaBean baixaBean = new LancamentoService().getBaixaOrigem(lancamento);
                    Funcoes.mensagem(this, "A origem do Lan\u00e7amento \u00e9: " + Tipos.tipoOrigemLancamento(lancamento.getTipoOrigem()) + ".\nEstorne a Baixa: " + baixaBean.getCodigo() + ", Filial: " + baixaBean.getFilial().getCodigo() + " para estornar o lan\u00e7amento.", 2);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar baixa associada ao lan\u00e7amento.\n" + e.getMessage(), e.getStackTrace());
                }
                return false;
            }
            if (auxTipoOrigem.equalsIgnoreCase("C")) {
                try {
                    Integer requisicao = new LancamentoService().getRequisicaoOrigem(lancamento);
                    if (requisicao != null) {
                        Funcoes.mensagem(this, "A origem do Lan\u00e7amento \u00e9: " + Tipos.tipoOrigemLancamento(lancamento.getTipoOrigem()) + ".\nEstorne a Requisi\u00e7\u00e3o: " + requisicao + ", Filial: " + lancamento.getFilial().getCodigo() + " para estornar o lan\u00e7amento.", 2);
                    }
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar requisi\u00e7\u00e3o associada ao lan\u00e7amento.\n" + e.getMessage(), e.getStackTrace());
                }
                return false;
            }
            if (auxTipoOrigem.equalsIgnoreCase("X") || auxTipoOrigem.equalsIgnoreCase("L") || auxTipoOrigem.equalsIgnoreCase("R")) {
                Funcoes.mensagem(this, "A origem do Lan\u00e7amento \u00e9: " + Tipos.tipoOrigemLancamento(lancamento.getTipoOrigem()) + ".\nN\u00e3o \u00e9 poss\u00edvel estornar o lan\u00e7amento.\nO c\u00f3digo do lan\u00e7amento de origem \u00e9: " + lancamento.getComplementarCodigo() + ", Filial: " + lancamento.getFilial().getCodigo() + ", Estacao: " + lancamento.getEstacao().getCodigo() + ".", 2);
                return false;
            }
            this.limparCampos();
            this.setStatus(3);
            this.controlaCampos();
            this.validacaoFeita = true;
            return true;
        }
        this.validacaoFeita = true;
        return true;
    }

    public static long getModuloAcesso(int tipoTela) {
        if (tipoTela == 1) {
            return Long.parseLong("0600400300");
        }
        if (tipoTela == 2) {
            return Long.parseLong("0600400800");
        }
        return Long.parseLong("0600401000");
    }

    @Override
    public void defineAcessos() {
        if (tipoTela == 1) {
            this.setModuloAcesso(Cancelamento.getModuloAcesso(tipoTela));
            this.setModuloInsere(Long.parseLong("0600400301"));
            this.setModuloEdita(this.ACESSO_CANCELAMENTO_EDITAR);
            this.setModuloApaga(this.ACESSO_CANCELAMENTO_APAGAR);
        } else if (tipoTela == 2) {
            this.setModuloAcesso(Cancelamento.getModuloAcesso(tipoTela));
            this.setModuloInsere(Long.parseLong("0600400801"));
            this.setModuloEdita(Long.parseLong("0600400802"));
            this.setModuloApaga(Long.parseLong("0600400803"));
        } else {
            this.setModuloAcesso(Cancelamento.getModuloAcesso(tipoTela));
            this.setModuloInsere(Long.parseLong("0600401001"));
            this.setModuloEdita(Long.parseLong("0600401002"));
            this.setModuloApaga(Long.parseLong("0600401003"));
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }
}

