/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.detalhes.DetalhesTitulo;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.lancamentos.AlterarPlanoCustoPagamentos;
import jalis.laboratorio.financeiro.lancamentos.Conciliacao;
import jalis.laboratorio.financeiro.lancamentos.DialogDetalhesObservacao;
import jalis.laboratorio.financeiro.lancamentos.EscolhaParcela;
import jalis.laboratorio.financeiro.lancamentos.ParcelamentoReceberPagar;
import jalis.laboratorio.financeiro.lancamentos.ReceberPagar;
import jalis.laboratorio.financeiro.lancamentos.TelaPlanoCusto;
import jalis.laboratorio.financeiro.lancamentos.componente.AlterarTituloBaixa;
import jalis.laboratorio.financeiro.lancamentos.componente.BuscaBeanPreenchido;
import jalis.laboratorio.financeiro.lancamentos.componente.PanelPlanoContaCentroCusto;
import jalis.laboratorio.relatorios.financeiro.movimento.RelatorioAutorizacaoDebito;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.financeiro.ContaCorrenteBean;
import jalis.model.bean.financeiro.BaixaBean;
import jalis.model.bean.financeiro.BaixaLancamentoBean;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.dao.cadastro.financeiro.ContaCorrenteDao;
import jalis.model.dao.financeiro.ReceberPagarDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.HistoricoPadraoVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.financeiro.ContaCorrenteVO;
import jalis.model.vo.financeiro.BaixaVO;
import jalis.service.cadastro.auxiliares.HistoricoPadraoService;
import jalis.service.cadastro.financeiro.CentroCustoService;
import jalis.service.cadastro.financeiro.ContaCorrenteService;
import jalis.service.cadastro.financeiro.PlanoContaService;
import jalis.service.financeiro.BaixaService;
import jalis.service.financeiro.LancamentoService;
import jalis.service.financeiro.ReceberPagarService;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class Baixa
extends FrmPadrao
implements BuscaBeanPreenchido,
ThreadFinalizadaListener {
    private long moduloAcesso = 0L;
    private long moduloInsere = 0L;
    private long moduloApaga = 0L;
    private long moduloDataBaixa = Long.parseLong("0600400607");
    private long moduloDataCompetenciaBaixa = Long.parseLong("0600400608");
    private long moduloAlteraTitulo = Long.parseLong("0600400602");
    private long moduloNovoTitulo = Long.parseLong("0600400501");
    public static final long PROIBIR_BAIXA_SEM_APROPRIAR_CENTRO_CUSTO = Long.parseLong("0600400609");
    public static final long PROIBIR_BAIXA_SEM_APROPRIAR_PLANO_CONTAS = Long.parseLong("0600400610");
    protected JButton buttonNovo = new JButton("Novo");
    protected JButton buttonCancelar = new JButton("Cancelar");
    protected JButton buttonFechar = new JButton("Fechar");
    protected JButton buttonImprimir = new JButton("Imprimir");
    protected JButton buttonSalvar = new JButton("Salvar");
    protected JButton buttonExcluir = new JButton("Excluir");
    protected JButton buttonEditar = new JButton("Editar");
    private AbstractThreadBean beanDelete = null;
    private BaixaBean beanEstorno = null;
    private JPanel panelTitulos = new JPanel(new GridBagLayout());
    private JPanel panelPagamentosResumo = new JPanel(new GridBagLayout());
    private JPanel pnlTipoPagamento = new JPanel(new BorderLayout());
    private JPanel pnlResumoBaixa = new JPanel(new GridBagLayout());
    private JPanel pnlResumoImpostos = new JPanel(new GridBagLayout());
    private JPanel pnlLegenda = new JPanel(new GridBagLayout());
    private BaixaService service = null;
    private int status = 1;
    private JTabbedPane tabResumo = new JTabbedPane();
    private JLabel labelTipoRecPag = new JLabel("Tipo:");
    private JLabel lblTitulo = new JLabel("C\u00f3digo:");
    private JLabel lblTipoPagamento = new JLabel("Tipo:");
    private JLabel lblValor = new JLabel("Valor:");
    private JLabel lblContaCorrente = new JLabel("Conta:");
    private JLabel lblHistorico = new JLabel("Hist\u00f3rico:");
    private JComboBox comboTipoRecPag = new JComboBox<Object>(new Object[]{"Receber", "Pagar"});
    private TTextField textTitulo = new TTextField(8, 1);
    private JButton buttonBuscaTitulo = new JButton();
    private ModeloGridTable modelTitulos;
    private JTable tableTitulos;
    private JScrollPane scrollTitulos;
    private JComboBox comboTipoPagamento = new JComboBox<String>(new String[]{Tipos.tipoPagamento("D"), Tipos.tipoPagamento("H"), Tipos.tipoPagamento("O"), Tipos.tipoPagamento("I"), Tipos.tipoPagamento("P"), Tipos.tipoPagamento("A"), Tipos.tipoPagamento("T"), Tipos.tipoPagamento("B"), Tipos.tipoPagamento("E"), Tipos.tipoPagamento("Z"), Tipos.tipoPagamento("U"), Tipos.tipoPagamento("N"), Tipos.tipoPagamento("W"), Tipos.tipoPagamento("Y")});
    private TTextField textValor = new TTextField(10, 2, 2);
    private JButton buttonAdicionaFormaPagamento = new JButton("OK");
    private ModeloGridTable modelFormasPagamento;
    private JTable tableFormasPagamento;
    private JScrollPane scrollFormasPagamento;
    private TTextField textCodigoContaCorrente = new TTextField(5, 1);
    private TTextField textDescricaoContaCorrente = new TTextField();
    private JButton buttonBuscaContaCorrente = new JButton();
    private TTextField textCodigoHistorico = new TTextField(5, 1);
    private TTextField textDescricaoHistorico = new TTextField(100, 3);
    private JButton buttonBuscaHistorico = new JButton();
    private JLabel lblDataBaixa = new JLabel("Data Baixa:");
    private JLabel labelDataBaixa = new JLabel("");
    private JButton buttonDataBaixa = new JButton();
    private JLabel lblSubTotal = new JLabel("Sub-Total:");
    private JLabel lblVlrSubTotal = new JLabel("");
    private JLabel lblTaxa = new JLabel("Taxa:");
    private JLabel lblVlrTaxa = new JLabel("");
    private JLabel lblMulta = new JLabel("Multa:");
    private JLabel lblVlrMulta = new JLabel("");
    private JLabel lblJuro = new JLabel("Juro:");
    private JLabel lblVlrJuro = new JLabel("");
    private JLabel lblAcrescimo = new JLabel("Acr\u00e9scimo:");
    private JLabel lblVlrAcrescimo = new JLabel("");
    private JLabel lblDesconto = new JLabel("Desconto:");
    private JLabel lblVlrDesconto = new JLabel("");
    private JLabel lblTotal = new JLabel("Total:");
    private JLabel lblVlrTotal = new JLabel("");
    private JLabel lblValorPago = new JLabel("Valor Pago:");
    private JLabel lblVlrValorPago = new JLabel("");
    private JLabel lblSaldoTroco = new JLabel("Saldo/Troco:");
    private JLabel lblVlrSaldoTroco = new JLabel("");
    private JLabel lblTituloImpostos = new JLabel(" ");
    private JLabel lblTituloImpostosRetido = new JLabel("Retido");
    private JLabel lblIrrf = new JLabel("Irrf:");
    private JLabel lblVlrIrrf = new JLabel("");
    private JLabel lblVlrIrrfRetido = new JLabel("");
    private JLabel lblIss = new JLabel("ISS:");
    private JLabel lblVlrIssRetido = new JLabel("");
    private JLabel lblVlrIss = new JLabel("");
    private JLabel lblPis = new JLabel("PIS:");
    private JLabel lblVlrPis = new JLabel("");
    private JLabel lblVlrPisRetido = new JLabel("");
    private JLabel lblCsll = new JLabel("Csll:");
    private JLabel lblVlrCsll = new JLabel("");
    private JLabel lblVlrCsllRetido = new JLabel("");
    private JLabel lblCofins = new JLabel("Cofins:");
    private JLabel lblVlrCofins = new JLabel("");
    private JLabel lblVlrCofinsRetido = new JLabel("");
    private JLabel lblInss = new JLabel("Inss:");
    private JLabel lblVlrInss = new JLabel("");
    private JLabel lblVlrInssRetido = new JLabel("");
    private DetalhesTitulo detalhesTitulo = new DetalhesTitulo(2);
    private LancamentoBean pagamentoAlteracao = null;
    private ReceberPagarService tituloService = new ReceberPagarService();
    private ContaCorrenteService contaCorrenteService = new ContaCorrenteService();
    private HistoricoPadraoService historicoService = new HistoricoPadraoService();
    private JButton btnImprimir = new JButton("Imprimir");
    private JPopupMenu menuTitulo = new JPopupMenu();
    private JMenuItem itemAlterarTitulo = new JMenuItem("Alterar");
    private JMenuItem itemAlterarPlanoTitulo = new JMenuItem("Plano de Contas / Centro de Custo");
    private JMenuItem itemParcelarTitulo = new JMenuItem("Parcelar t\u00edtulo");
    private JPopupMenu menuPagamento = new JPopupMenu();
    private JMenuItem itemAlterarPagamento = new JMenuItem("Alterar");
    private JMenuItem itemAlterarPlanoPagamento = new JMenuItem("Plano de Contas / Centro de Custo");
    private PanelPlanoContaCentroCusto pnlPlanoCustoTitulo = new PanelPlanoContaCentroCusto(this, PanelPlanoContaCentroCusto.TIPO_RECEBER_PAGAR, -1L, -1L, Variaveis.filialPadrao);
    private PanelPlanoContaCentroCusto pnlPlanoCustoPagamento = new PanelPlanoContaCentroCusto(this, PanelPlanoContaCentroCusto.TIPO_LANCAMENTO, -1L, -1L, Variaveis.filialPadrao);
    private JButton buttonDetalheFormaPgto = new JButton();
    private JButton buttonObservacao = new JButton();
    private JLabel lblDescricaoHistorico = new JLabel("Descri\u00e7\u00e3o:");
    private TTextField textDescricaoHistoricoUsuario = new TTextField(60, 3);
    public static final int COLUNA_PGTO_CONTA = 0;
    public static final int COLUNA_PGTO_TIPO = 1;
    public static final int COLUNA_PGTO_VALOR = 2;
    public static final int COLUNA_PGTO_OBSERVACAO = 3;
    public static final int COLUNA_PGTO_OBJETO = 4;
    public static final int COLUNA_TIT_CODIGO = 0;
    public static final int COLUNA_TIT_FAVORECIDO = 1;
    public static final int COLUNA_TIT_DOCUMENTO = 2;
    public static final int COLUNA_TIT_VENCIMENTO = 3;
    public static final int COLUNA_TIT_VALOR = 4;
    public static final int COLUNA_TIT_TOTAL = 5;
    public static final int COLUNA_TIT_OBJETO = 6;
    protected static final int FORMA_PGTO_NONE = 0;
    protected static final int FORMA_PGTO_CHEQUE = 2;
    protected static final int FORMA_PGTO_AUT_DEBITO = 3;
    protected static final int FORMA_PGTO_CHEQUE_PRE = 4;
    protected static final int FORMA_PGTO_CHEQUE_TERCEIRO = 5;
    protected static final int OBSERVACAO = 6;
    protected static final int FORMA_PGTO_CARTAO_DEBITO = 7;
    protected static final int FORMA_PGTO_CARTAO_CREDITO = 8;
    protected static final int FORMA_PGTO_TRANSFERENCIA_BANCARIA = 9;
    protected static final int FORMA_PGTO_PIX = 10;
    private JPanel painelCentral = new JPanel(new GridBagLayout());
    private boolean bloqueiaAlteracoes = false;
    private boolean executandoOperacoes = false;
    private Date dataVencimento = null;
    private Date dataCompetencia = null;
    private boolean isHistoricoUsuarioAutomatica = true;
    private String favorecidoAnterior = null;

    public BaixaBean getBeanEstorno() {
        return this.beanEstorno;
    }

    public Baixa() {
        this.montaTela("Baixa de t\u00edtulos", "Realiza a concilia\u00e7\u00e3o de t\u00edtulos a receber/pagar", true, true, true, 1.0f, this.buttonNovo, this.buttonSalvar, this.buttonCancelar, this.buttonFechar);
    }

    public Baixa(String titulo, String descricao, boolean adicionaBotoes, boolean adicionaBarraDescricao, boolean adicionaBuscaTitulo, float propComps) {
        this.montaTela(titulo, descricao, adicionaBotoes, adicionaBarraDescricao, adicionaBuscaTitulo, propComps, null);
    }

    protected void montaTela(String titulo, String descricao, boolean adicionaBotoes, boolean adicionaBarraDescricao, boolean adicionaBuscaTitulo, float propComps, Component ... botoes) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.painelCentral, "Center");
        boolean naoPossuiPlanosECentros = false;
        try {
            naoPossuiPlanosECentros = !new PlanoContaService().haPlanosContas(Variaveis.filialPadrao) && !new CentroCustoService().haCentrosCusto(Variaveis.filialPadrao);
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar informa\u00e7\u00f5es sobre plano de contas e centro de custo.", e1.getStackTrace());
        }
        if (adicionaBotoes) {
            this.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, botoes), "South");
        }
        if (adicionaBarraDescricao) {
            Funcoes.criaBarraDescricao(this, titulo, descricao, "financeiro/baixa.jpg");
        }
        if (!adicionaBuscaTitulo) {
            this.labelTipoRecPag.setVisible(false);
            this.comboTipoRecPag.setVisible(false);
            this.lblTitulo.setVisible(false);
            this.textTitulo.setVisible(false);
            this.buttonBuscaTitulo.setVisible(false);
        }
        this.menuTitulo.add(this.itemAlterarTitulo);
        if (!naoPossuiPlanosECentros) {
            this.menuTitulo.add(this.itemAlterarPlanoTitulo);
        }
        this.menuTitulo.add(this.itemParcelarTitulo);
        this.menuPagamento.add(this.itemAlterarPagamento);
        if (!naoPossuiPlanosECentros) {
            this.menuPagamento.add(this.itemAlterarPlanoPagamento);
        }
        this.inserirAcaoDeTecla("F5", "atalhoF5", new AbstractAction("atalhoF5"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Baixa.this.getStatus() == 3 || Baixa.this.getStatus() == 2) {
                    Baixa.this.tabResumo.setSelectedComponent(Baixa.this.pnlResumoBaixa);
                }
            }
        });
        this.inserirAcaoDeTecla("F6", "atalhoF6", new AbstractAction("atalhoF6"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Baixa.this.getStatus() == 3 || Baixa.this.getStatus() == 2) {
                    Baixa.this.tabResumo.setSelectedComponent(Baixa.this.pnlResumoImpostos);
                }
            }
        });
        this.itemAlterarTitulo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Baixa.this.alterarTitulo();
            }
        });
        this.itemParcelarTitulo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Baixa.this.parcelarTitulo();
            }
        });
        this.itemAlterarPlanoTitulo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Baixa.this.alterarPlanoTitulo();
            }
        });
        this.itemAlterarPagamento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Baixa.this.alterarFormaPagamento();
            }
        });
        this.itemAlterarPlanoPagamento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Baixa.this.alterarPlanoPagamento();
            }
        });
        Dimension d = new Dimension(78, 20);
        this.textTitulo.setSize(d);
        this.textTitulo.setPreferredSize(d);
        this.textTitulo.setMinimumSize(d);
        this.textTitulo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Baixa.this.buscaTitulo(Baixa.this.textTitulo.getText());
            }
        });
        this.buttonBuscaTitulo.setFocusable(false);
        d = new Dimension(20, 20);
        this.buttonBuscaTitulo.setPreferredSize(d);
        d = new Dimension(20, 20);
        this.buttonBuscaTitulo.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaTitulo);
        this.buttonBuscaTitulo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Baixa.this.buscaTitulo();
            }
        });
        this.modelTitulos = new ModeloGridTable(new String[]{"C\u00f3digo", "Favorecido", "Documento", "Vencimento", "Valor", "Total", "Objeto"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    Baixa.this.tableTitulos.removeColumn(Baixa.this.tableTitulos.getColumnModel().getColumn(6));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (Baixa.this.tableTitulos != null) {
                        Baixa.this.tableTitulos.removeColumn(Baixa.this.tableTitulos.getColumnModel().getColumn(6));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.tableTitulos = new JTable(this.modelTitulos);
        this.tableTitulos.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    Baixa.this.removerTitulo();
                    if (Baixa.this.textTitulo.isFocusable()) {
                        Baixa.this.textTitulo.grabFocus();
                    }
                } else if (e.getKeyCode() == 32) {
                    Baixa.this.abrirPopupTitulo();
                }
            }
        });
        this.tableTitulos.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int row = Baixa.this.tableTitulos.getSelectedRow();
                if (row >= 0 && Baixa.this.modelTitulos.getRowCount() > 0) {
                    Baixa.this.mostrarDadosTitulos((ReceberPagarBean)Baixa.this.modelTitulos.getValueAt(row, 6));
                }
            }
        });
        this.tableTitulos.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Baixa.this.abrirPopupTitulo();
                }
            }
        });
        this.modelTitulos.setColumnSize(new int[]{60, 0, 0, 90, 75, 75, 0}, this.tableTitulos);
        this.tableTitulos.removeColumn(this.tableTitulos.getColumnModel().getColumn(6));
        this.tableTitulos.getTableHeader().addMouseListener(this.modelTitulos);
        TituloRenderer rendererTitulo = new TituloRenderer();
        this.tableTitulos.setDefaultRenderer(Object.class, rendererTitulo);
        this.scrollTitulos = new JScrollPane(this.tableTitulos);
        d = new Dimension(150, 20);
        this.comboTipoPagamento.setSize(d);
        this.comboTipoPagamento.setPreferredSize(d);
        this.comboTipoPagamento.setMinimumSize(d);
        this.comboTipoPagamento.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                LancamentoBean aux = null;
                Object o = Baixa.this.comboTipoPagamento.getSelectedItem();
                if (o == null) {
                    return;
                }
                String s = (String)o;
                if (Baixa.this.pagamentoAlteracao != null) {
                    aux = Baixa.this.pagamentoAlteracao;
                } else {
                    aux = new LancamentoBean();
                    Baixa.this.pagamentoAlteracao = aux;
                }
                ContaCorrenteVO conta = null;
                if (!Funcoes.textoVazio(Baixa.this.textCodigoContaCorrente)) {
                    conta = new ContaCorrenteVO();
                    conta.setReduzido(Integer.parseInt(Baixa.this.textCodigoContaCorrente.getText()));
                }
                aux.setContaCorrente(conta);
                if (s.equalsIgnoreCase(Tipos.tipoPagamento("H")) || s.equalsIgnoreCase(Tipos.tipoPagamento("A"))) {
                    new DialogDetalhesObservacao(aux, 2);
                } else if (s.equalsIgnoreCase(Tipos.tipoPagamento("P"))) {
                    new DialogDetalhesObservacao(aux, 4);
                } else if (s.equalsIgnoreCase(Tipos.tipoPagamento("T"))) {
                    new DialogDetalhesObservacao(aux, 5);
                } else if (s.equalsIgnoreCase(Tipos.tipoPagamento("Z"))) {
                    if (Baixa.this.modelFormasPagamento.getRowCount() > 0) {
                        LancamentoBean lancto = (LancamentoBean)Baixa.this.modelFormasPagamento.getValueAt(0, 4);
                        if (lancto != aux) {
                            Funcoes.mensagem(Laboratorio.getInstancia(), "A forma de pagamento \"" + Tipos.tipoPagamento("Z") + "\" deve ser \na \u00daNICA forma de pagamento da Baixa.", 2);
                            Baixa.this.comboTipoPagamento.setSelectedIndex(0);
                            if (Baixa.this.comboTipoPagamento.isFocusable()) {
                                Baixa.this.comboTipoPagamento.grabFocus();
                            }
                        } else {
                            new DialogDetalhesObservacao(aux, 3);
                        }
                    } else {
                        new DialogDetalhesObservacao(aux, 3);
                    }
                } else if (s.equalsIgnoreCase(Tipos.tipoPagamento("I"))) {
                    new DialogDetalhesObservacao(aux, 7);
                } else if (s.equalsIgnoreCase(Tipos.tipoPagamento("O"))) {
                    new DialogDetalhesObservacao(aux, 8);
                } else if (s.equalsIgnoreCase(Tipos.tipoPagamento("W"))) {
                    new DialogDetalhesObservacao(aux, 9);
                } else if (s.equalsIgnoreCase(Tipos.tipoPagamento("Y"))) {
                    new DialogDetalhesObservacao(aux, 10);
                }
                ScreenUtil.requisitarFoco(Baixa.this.textValor);
            }
        });
        d = new Dimension(60, 20);
        this.textCodigoContaCorrente.setSize(d);
        this.textCodigoContaCorrente.setPreferredSize(d);
        this.textCodigoContaCorrente.setMinimumSize(d);
        this.textCodigoContaCorrente.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Baixa.this.buscaContaCorrente(Baixa.this.textCodigoContaCorrente.getText());
            }
        });
        this.buttonBuscaContaCorrente.setFocusable(false);
        this.buttonBuscaContaCorrente.setText("");
        d = new Dimension(20, 20);
        this.buttonBuscaContaCorrente.setSize(d);
        this.buttonBuscaContaCorrente.setPreferredSize(d);
        this.buttonBuscaContaCorrente.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaContaCorrente);
        this.buttonBuscaContaCorrente.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Baixa.this.buscaContaCorrente();
            }
        });
        d = new Dimension(200, 20);
        this.textDescricaoContaCorrente.setSize(d);
        this.textDescricaoContaCorrente.setPreferredSize(d);
        this.textDescricaoContaCorrente.setMinimumSize(d);
        this.textDescricaoContaCorrente.setEditable(false);
        this.textDescricaoContaCorrente.setFocusable(false);
        d = new Dimension(60, 20);
        this.textCodigoHistorico.setSize(d);
        this.textCodigoHistorico.setPreferredSize(d);
        this.textCodigoHistorico.setMinimumSize(d);
        this.textCodigoHistorico.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Baixa.this.buscaHistorico(Baixa.this.textCodigoHistorico.getText());
                Baixa.this.controlaCampos();
                if (e.getOppositeComponent() == Baixa.this.comboTipoPagamento && Baixa.this.textDescricaoHistoricoUsuario.isEnabled()) {
                    Baixa.this.textDescricaoHistoricoUsuario.grabFocus();
                }
                if (e.getOppositeComponent() == Baixa.this.comboTipoPagamento && !Baixa.this.textDescricaoHistoricoUsuario.isEnabled()) {
                    Baixa.this.comboTipoPagamento.grabFocus();
                }
                if (e.getOppositeComponent() == Baixa.this.textCodigoContaCorrente) {
                    Baixa.this.textCodigoContaCorrente.grabFocus();
                }
                if (e.getOppositeComponent() == Baixa.this.textDescricaoHistoricoUsuario && !Baixa.this.textDescricaoHistoricoUsuario.isEnabled()) {
                    Baixa.this.comboTipoPagamento.grabFocus();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                Baixa.this.controlaCampos();
            }
        });
        this.buttonBuscaHistorico.setFocusable(false);
        this.buttonBuscaHistorico.setText("");
        d = new Dimension(20, 20);
        this.buttonBuscaHistorico.setSize(d);
        this.buttonBuscaHistorico.setPreferredSize(d);
        this.buttonBuscaHistorico.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaHistorico);
        this.buttonBuscaHistorico.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Baixa.this.buscaHistorico();
            }
        });
        d = new Dimension(200, 20);
        this.textDescricaoHistorico.setSize(d);
        this.textDescricaoHistorico.setPreferredSize(d);
        this.textDescricaoHistorico.setMinimumSize(d);
        this.textDescricaoHistorico.setEditable(false);
        this.textDescricaoHistorico.setFocusable(false);
        this.textDescricaoHistoricoUsuario.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    Baixa.this.preencheHistoricoUsuario();
                }
            }
        });
        d = new Dimension(100, 20);
        this.textValor.setSize(d);
        this.textValor.setPreferredSize(d);
        this.textValor.setMinimumSize(d);
        this.textValor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (Baixa.this.pagamentoAlteracao != null && Baixa.this.pagamentoAlteracao.getValor() != null) {
                    return;
                }
                BigDecimal aux = new BigDecimal("0");
                aux = new BigDecimal(String.valueOf(Baixa.this.getSomatorioTitulos()));
                aux = aux.doubleValue() == 0.0 ? new BigDecimal("0") : aux.subtract(new BigDecimal(String.valueOf(Baixa.this.getSomatorioBaixas())));
                ((TTextField)e.getSource()).setText(Funcoes.formataDecimal(aux.doubleValue()));
            }
        });
        d = new Dimension(30, 20);
        this.buttonAdicionaFormaPagamento.setSize(d);
        this.buttonAdicionaFormaPagamento.setPreferredSize(d);
        this.buttonAdicionaFormaPagamento.setMinimumSize(d);
        this.buttonAdicionaFormaPagamento.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAdicionaFormaPagamento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Baixa.this.adicionarFormaPagamento();
                Baixa.this.pagamentoAlteracao = null;
                Baixa.this.controlaCampos();
            }
        });
        this.modelFormasPagamento = new ModeloGridTable(new String[]{"Conta Pgto", "Tipo Pgto", "Valor", "Observa\u00e7\u00e3o", "Objeto"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    Baixa.this.tableFormasPagamento.removeColumn(Baixa.this.tableFormasPagamento.getColumnModel().getColumn(4));
                    Baixa.this.pagamentoAlteracao = null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.tableFormasPagamento = new JTable(this.modelFormasPagamento);
        this.tableFormasPagamento.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    Baixa.this.removerFormaPagamento();
                } else if (e.getKeyCode() == 32) {
                    Baixa.this.abrirPopupPagamento();
                }
                Baixa.this.controlaBotoesPagamentos(true);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                Baixa.this.controlaBotoesPagamentos(true);
            }
        });
        this.tableFormasPagamento.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int row = Baixa.this.tableFormasPagamento.getSelectedRow();
                if (Baixa.this.modelFormasPagamento != null && row >= 0) {
                    Baixa.this.pagamentoAlteracao = (LancamentoBean)Baixa.this.modelFormasPagamento.getValueAt(row, 4);
                }
                Baixa.this.controlaBotoesPagamentos(true);
            }
        });
        this.tableFormasPagamento.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Baixa.this.abrirPopupPagamento();
                }
            }
        });
        this.modelFormasPagamento.setColumnSize(new int[]{95, 110, 90, 0, 0}, this.tableFormasPagamento);
        this.tableFormasPagamento.removeColumn(this.tableFormasPagamento.getColumnModel().getColumn(4));
        this.tableFormasPagamento.getTableHeader().addMouseListener(this.modelFormasPagamento);
        PagamentoRenderer rendererPagamento = new PagamentoRenderer();
        this.tableFormasPagamento.setDefaultRenderer(Object.class, rendererPagamento);
        this.scrollFormasPagamento = new JScrollPane(this.tableFormasPagamento);
        d = new Dimension(450, 100);
        this.scrollFormasPagamento.setSize(d);
        this.scrollFormasPagamento.setPreferredSize(d);
        this.scrollFormasPagamento.setMinimumSize(d);
        d = new Dimension(90, 20);
        this.labelDataBaixa.setSize(d);
        this.labelDataBaixa.setPreferredSize(d);
        this.labelDataBaixa.setMinimumSize(d);
        this.buttonDataBaixa.setFocusable(false);
        this.buttonDataBaixa.setText("...");
        d = new Dimension(20, 20);
        this.buttonDataBaixa.setSize(d);
        this.buttonDataBaixa.setPreferredSize(d);
        this.buttonDataBaixa.setMinimumSize(d);
        this.buttonDataBaixa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelaDatas telaDatas = new TelaDatas(Laboratorio.getInstancia(), Funcoes.getData("dd/MM/yyyy", Baixa.this.labelDataBaixa.getText()), Baixa.this.dataVencimento, Baixa.this.dataCompetencia);
                if (telaDatas.getOK()) {
                    Baixa.this.labelDataBaixa.setText(Funcoes.formataData("dd/MM/yyyy", telaDatas.getDataBaixa()));
                    Baixa.this.dataVencimento = telaDatas.getDataVencimento();
                    Baixa.this.dataCompetencia = telaDatas.getDataCompetencia();
                    Baixa.this.setDataVencimento(Baixa.this.dataVencimento);
                    Baixa.this.setDataCompetencia(Baixa.this.dataCompetencia);
                    Baixa.this.atualizarValoresTitulos();
                    for (int i = 0; i < Baixa.this.modelTitulos.getRowCount(); ++i) {
                        FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)Baixa.this.modelTitulos.getValueAt(i, 6));
                    }
                    Baixa.this.atualizarTitulos();
                    Baixa.this.atualizarResumo();
                }
            }
        });
        d = new Dimension(90, 20);
        this.lblVlrSubTotal.setSize(d);
        this.lblVlrSubTotal.setPreferredSize(d);
        this.lblVlrSubTotal.setMinimumSize(d);
        d = new Dimension(90, 20);
        this.lblVlrTaxa.setSize(d);
        this.lblVlrTaxa.setPreferredSize(d);
        this.lblVlrTaxa.setMinimumSize(d);
        d = new Dimension(90, 20);
        this.lblVlrMulta.setSize(d);
        this.lblVlrMulta.setPreferredSize(d);
        this.lblVlrMulta.setMinimumSize(d);
        d = new Dimension(90, 20);
        this.lblVlrJuro.setSize(d);
        this.lblVlrJuro.setPreferredSize(d);
        this.lblVlrJuro.setMinimumSize(d);
        d = new Dimension(90, 20);
        this.lblVlrAcrescimo.setSize(d);
        this.lblVlrAcrescimo.setPreferredSize(d);
        this.lblVlrAcrescimo.setMinimumSize(d);
        d = new Dimension(90, 20);
        this.lblVlrDesconto.setSize(d);
        this.lblVlrDesconto.setPreferredSize(d);
        this.lblVlrDesconto.setMinimumSize(d);
        d = new Dimension(90, 20);
        this.lblVlrTotal.setSize(d);
        this.lblVlrTotal.setPreferredSize(d);
        this.lblVlrTotal.setMinimumSize(d);
        d = new Dimension(90, 20);
        this.lblVlrValorPago.setSize(d);
        this.lblVlrValorPago.setPreferredSize(d);
        this.lblVlrValorPago.setMinimumSize(d);
        d = new Dimension(90, 20);
        this.lblVlrSaldoTroco.setSize(d);
        this.lblVlrSaldoTroco.setPreferredSize(d);
        this.lblVlrSaldoTroco.setMinimumSize(d);
        d = new Dimension(60, 20);
        this.lblVlrIrrf.setSize(d);
        this.lblVlrIrrf.setPreferredSize(d);
        this.lblVlrIrrf.setMinimumSize(d);
        d = new Dimension(60, 20);
        this.lblVlrIrrfRetido.setSize(d);
        this.lblVlrIrrfRetido.setPreferredSize(d);
        this.lblVlrIrrfRetido.setMinimumSize(d);
        d = new Dimension(60, 20);
        this.lblVlrIss.setSize(d);
        this.lblVlrIss.setPreferredSize(d);
        this.lblVlrIss.setMinimumSize(d);
        d = new Dimension(60, 20);
        this.lblVlrIssRetido.setSize(d);
        this.lblVlrIssRetido.setPreferredSize(d);
        this.lblVlrIssRetido.setMinimumSize(d);
        d = new Dimension(60, 20);
        this.lblVlrPis.setSize(d);
        this.lblVlrPis.setPreferredSize(d);
        this.lblVlrPis.setMinimumSize(d);
        d = new Dimension(60, 20);
        this.lblVlrPisRetido.setSize(d);
        this.lblVlrPisRetido.setPreferredSize(d);
        this.lblVlrPisRetido.setMinimumSize(d);
        d = new Dimension(60, 20);
        this.lblVlrCsll.setSize(d);
        this.lblVlrCsll.setPreferredSize(d);
        this.lblVlrCsll.setMinimumSize(d);
        d = new Dimension(60, 20);
        this.lblVlrCsllRetido.setSize(d);
        this.lblVlrCsllRetido.setPreferredSize(d);
        this.lblVlrCsllRetido.setMinimumSize(d);
        d = new Dimension(60, 20);
        this.lblVlrCofins.setSize(d);
        this.lblVlrCofins.setPreferredSize(d);
        this.lblVlrCofins.setMinimumSize(d);
        d = new Dimension(60, 20);
        this.lblVlrCofinsRetido.setSize(d);
        this.lblVlrCofinsRetido.setPreferredSize(d);
        this.lblVlrCofinsRetido.setMinimumSize(d);
        d = new Dimension(60, 20);
        this.lblVlrInss.setSize(d);
        this.lblVlrInss.setPreferredSize(d);
        this.lblVlrInss.setMinimumSize(d);
        d = new Dimension(60, 20);
        this.lblVlrInssRetido.setSize(d);
        this.lblVlrInssRetido.setPreferredSize(d);
        this.lblVlrInssRetido.setMinimumSize(d);
        ScreenUtil.setBorda(new Component[]{this.lblVlrSubTotal, this.lblVlrTaxa, this.lblVlrMulta, this.lblVlrJuro, this.lblVlrAcrescimo, this.lblVlrDesconto, this.lblVlrTotal, this.lblVlrValorPago, this.lblVlrSaldoTroco, this.lblVlrIrrf, this.lblVlrIrrfRetido, this.lblVlrIss, this.lblVlrIssRetido, this.lblVlrPis, this.lblVlrPisRetido, this.lblVlrCsll, this.lblVlrCsllRetido, this.lblVlrCofins, this.lblVlrCofinsRetido, this.lblVlrInss, this.lblVlrInssRetido, this.labelDataBaixa}, new TitledBorder(""));
        this.painelCentral.setLayout(new GridBagLayout());
        this.tabResumo.addTab("Baixa (F5)", this.pnlResumoBaixa);
        this.tabResumo.addTab("Impostos (F6)", this.pnlResumoImpostos);
        JPanel pnlFormaPagamento = new JPanel();
        pnlFormaPagamento.setLayout(new GridBagLayout());
        pnlFormaPagamento.setBorder(BorderFactory.createTitledBorder("Pagamento"));
        d = new Dimension(80, 20);
        this.comboTipoRecPag.setPreferredSize(d);
        d = new Dimension(80, 20);
        this.comboTipoRecPag.setMinimumSize(d);
        this.buttonDetalheFormaPgto.setFocusable(false);
        this.buttonDetalheFormaPgto.setText("Detalhes Forma Pagamento");
        d = new Dimension(200, 20);
        this.buttonDetalheFormaPgto.setPreferredSize(d);
        d = new Dimension(200, 20);
        this.buttonDetalheFormaPgto.setMinimumSize(d);
        this.buttonDetalheFormaPgto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Baixa.this.tableFormasPagamento.getSelectedRowCount() < 0 || Baixa.this.tableFormasPagamento.getSelectedRow() == -1 || Baixa.this.modelFormasPagamento.getRowCount() <= 0) {
                    return;
                }
                int row = Baixa.this.tableFormasPagamento.getSelectedRow();
                LancamentoBean aux = (LancamentoBean)Baixa.this.modelFormasPagamento.getValueAt(row, 4);
                if (aux.getTipoPagamento().equals("Z")) {
                    new DialogDetalhesObservacao(aux, 3);
                } else if (aux.getTipoPagamento().equals("I")) {
                    new DialogDetalhesObservacao(aux, 7);
                } else if (aux.getTipoPagamento().equals("O")) {
                    new DialogDetalhesObservacao(aux, 8);
                } else if (aux.getTipoPagamento().equals("H") || aux.getTipoPagamento().equals("A")) {
                    new DialogDetalhesObservacao(aux, 2);
                } else if (aux.getTipoPagamento().equals("T")) {
                    new DialogDetalhesObservacao(aux, 5);
                } else if (aux.getTipoPagamento().equals("P")) {
                    new DialogDetalhesObservacao(aux, 4);
                } else if (aux.getTipoPagamento().equals("W")) {
                    new DialogDetalhesObservacao(aux, 9);
                } else if (aux.getTipoPagamento().equals("Y")) {
                    new DialogDetalhesObservacao(aux, 10);
                }
            }
        });
        this.buttonObservacao.setFocusable(false);
        this.buttonObservacao.setText("Observa\u00e7\u00e3o");
        d = new Dimension(110, 20);
        this.buttonObservacao.setPreferredSize(d);
        d = new Dimension(110, 20);
        this.buttonObservacao.setMinimumSize(d);
        this.buttonObservacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Baixa.this.tableFormasPagamento.getSelectedRowCount() < 0 || Baixa.this.tableFormasPagamento.getSelectedRow() == -1) {
                    return;
                }
                int row = Baixa.this.tableFormasPagamento.getSelectedRow();
                if (row >= 0 && Baixa.this.modelFormasPagamento.getRowCount() > 0) {
                    Baixa.createDialogDetalhesObservacao((LancamentoBean)Baixa.this.modelFormasPagamento.getValueAt(row, 4), 6);
                }
                Baixa.this.atualizarFormasPagamento();
            }
        });
        this.buttonNovo.setMnemonic('N');
        this.buttonNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Baixa.this.novo();
            }
        });
        this.buttonEditar.setMnemonic('d');
        this.buttonEditar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Baixa.this.editar();
            }
        });
        this.buttonSalvar.setMnemonic('S');
        this.buttonSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Baixa.this.salvar();
            }
        });
        this.buttonCancelar.setMnemonic('C');
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Baixa.this.cancelar();
            }
        });
        this.buttonExcluir.setMnemonic('x');
        this.buttonExcluir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Baixa.this.excluir();
            }
        });
        this.buttonFechar.setMnemonic('F');
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Baixa.this.fechar();
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 1;
        this.painelCentral.add((Component)this.panelTitulos, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 2;
        this.painelCentral.add((Component)this.panelPagamentosResumo, c);
        ++c.gridy;
        c.weighty = 0.0;
        this.painelCentral.add((Component)this.pnlLegenda, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 0);
        this.labelTipoRecPag.setLabelFor(this.comboTipoRecPag);
        this.labelTipoRecPag.setDisplayedMnemonic('T');
        this.panelTitulos.add((Component)this.labelTipoRecPag, c);
        ++c.gridx;
        this.panelTitulos.add((Component)this.comboTipoRecPag, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 1, 0);
        this.lblTitulo.setLabelFor(this.textTitulo);
        this.lblTitulo.setDisplayedMnemonic('i');
        this.panelTitulos.add((Component)this.lblTitulo, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 0);
        this.panelTitulos.add((Component)this.textTitulo, c);
        ++c.gridx;
        this.panelTitulos.add((Component)this.buttonBuscaTitulo, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelTitulos.add((Component)new JLabel(""), c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 6;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panelTitulos.add((Component)this.scrollTitulos, c);
        ++c.gridy;
        c.gridwidth = 6;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.panelTitulos.add((Component)this.detalhesTitulo, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panelPagamentosResumo.add((Component)pnlFormaPagamento, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.panelPagamentosResumo.add((Component)this.tabResumo, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.lblContaCorrente.setLabelFor(this.textCodigoContaCorrente);
        this.lblContaCorrente.setDisplayedMnemonic('a');
        pnlFormaPagamento.add((Component)this.lblContaCorrente, c);
        ++c.gridx;
        pnlFormaPagamento.add((Component)this.textCodigoContaCorrente, c);
        ++c.gridx;
        pnlFormaPagamento.add((Component)this.buttonBuscaContaCorrente, c);
        ++c.gridx;
        c.gridwidth = 6;
        c.weightx = 1.0;
        c.fill = 2;
        pnlFormaPagamento.add((Component)this.textDescricaoContaCorrente, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        this.lblHistorico.setLabelFor(this.textCodigoHistorico);
        this.lblHistorico.setDisplayedMnemonic('H');
        pnlFormaPagamento.add((Component)this.lblHistorico, c);
        ++c.gridx;
        pnlFormaPagamento.add((Component)this.textCodigoHistorico, c);
        ++c.gridx;
        pnlFormaPagamento.add((Component)this.buttonBuscaHistorico, c);
        ++c.gridx;
        c.gridwidth = 6;
        c.weightx = 1.0;
        c.fill = 2;
        pnlFormaPagamento.add((Component)this.textDescricaoHistorico, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        pnlFormaPagamento.add((Component)this.lblDescricaoHistorico, c);
        ++c.gridx;
        c.gridwidth = 8;
        c.fill = 2;
        pnlFormaPagamento.add((Component)this.textDescricaoHistoricoUsuario, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        this.lblTipoPagamento.setLabelFor(this.comboTipoPagamento);
        this.lblTipoPagamento.setDisplayedMnemonic('i');
        pnlFormaPagamento.add((Component)this.lblTipoPagamento, c);
        ++c.gridx;
        c.gridwidth = 3;
        pnlFormaPagamento.add((Component)this.comboTipoPagamento, c);
        c.gridx += 3;
        c.gridwidth = 1;
        c.insets = new Insets(1, 20, 1, 0);
        this.lblValor.setLabelFor(this.textValor);
        this.lblValor.setDisplayedMnemonic('V');
        pnlFormaPagamento.add((Component)this.lblValor, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 0);
        pnlFormaPagamento.add((Component)this.textValor, c);
        ++c.gridx;
        this.buttonAdicionaFormaPagamento.setMnemonic('O');
        pnlFormaPagamento.add((Component)this.buttonAdicionaFormaPagamento, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        pnlFormaPagamento.add(new JLabel(""));
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 9;
        c.weightx = 1.0;
        c.fill = 2;
        pnlFormaPagamento.add((Component)this.pnlTipoPagamento, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 9;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        pnlFormaPagamento.add((Component)this.scrollFormasPagamento, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 9;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        JPanel painelBotoes = new JPanel();
        pnlFormaPagamento.add((Component)painelBotoes, c);
        painelBotoes.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 0;
        this.buttonObservacao.setMnemonic('b');
        painelBotoes.add((Component)this.buttonObservacao, c);
        ++c.gridx;
        painelBotoes.add((Component)new JLabel("  "), c);
        ++c.gridx;
        painelBotoes.add((Component)this.buttonDetalheFormaPgto, c);
        c.weightx = 1.0;
        c.fill = 2;
        painelBotoes.add((Component)new JLabel(""), c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 0);
        this.pnlResumoBaixa.add((Component)this.lblDataBaixa, c);
        ++c.gridx;
        this.pnlResumoBaixa.add((Component)this.labelDataBaixa, c);
        ++c.gridx;
        this.pnlResumoBaixa.add((Component)this.buttonDataBaixa, c);
        ++c.gridy;
        c.gridx = 0;
        this.pnlResumoBaixa.add((Component)this.lblSubTotal, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.lblVlrSubTotal.setHorizontalAlignment(4);
        this.pnlResumoBaixa.add((Component)this.lblVlrSubTotal, c);
        ++c.gridy;
        c.gridx = 0;
        this.pnlResumoBaixa.add((Component)this.lblTaxa, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.lblVlrTaxa.setHorizontalAlignment(4);
        this.pnlResumoBaixa.add((Component)this.lblVlrTaxa, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.pnlResumoBaixa.add((Component)this.lblMulta, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.lblVlrMulta.setHorizontalAlignment(4);
        this.pnlResumoBaixa.add((Component)this.lblVlrMulta, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.pnlResumoBaixa.add((Component)this.lblJuro, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.lblVlrJuro.setHorizontalAlignment(4);
        this.pnlResumoBaixa.add((Component)this.lblVlrJuro, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.pnlResumoBaixa.add((Component)this.lblAcrescimo, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.lblVlrAcrescimo.setHorizontalAlignment(4);
        this.pnlResumoBaixa.add((Component)this.lblVlrAcrescimo, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.pnlResumoBaixa.add((Component)this.lblDesconto, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.lblVlrDesconto.setHorizontalAlignment(4);
        this.pnlResumoBaixa.add((Component)this.lblVlrDesconto, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.pnlResumoBaixa.add((Component)this.lblTotal, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.lblVlrTotal.setHorizontalAlignment(4);
        this.pnlResumoBaixa.add((Component)this.lblVlrTotal, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.pnlResumoBaixa.add((Component)this.lblValorPago, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.lblVlrValorPago.setHorizontalAlignment(4);
        this.pnlResumoBaixa.add((Component)this.lblVlrValorPago, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.pnlResumoBaixa.add((Component)this.lblSaldoTroco, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.lblVlrSaldoTroco.setHorizontalAlignment(4);
        this.pnlResumoBaixa.add((Component)this.lblVlrSaldoTroco, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.pnlResumoBaixa.add((Component)new JPanel(), c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.pnlResumoImpostos.add((Component)this.lblTituloImpostos, c);
        c.gridx += 2;
        this.pnlResumoImpostos.add((Component)this.lblTituloImpostosRetido, c);
        ++c.gridy;
        c.gridx = 0;
        this.pnlResumoImpostos.add((Component)this.lblIrrf, c);
        ++c.gridx;
        this.lblVlrIrrf.setHorizontalAlignment(4);
        this.pnlResumoImpostos.add((Component)this.lblVlrIrrf, c);
        ++c.gridx;
        c.weightx = 3.0;
        this.lblVlrIrrfRetido.setHorizontalAlignment(4);
        this.pnlResumoImpostos.add((Component)this.lblVlrIrrfRetido, c);
        ++c.gridy;
        c.gridx = 0;
        this.pnlResumoImpostos.add((Component)this.lblIss, c);
        ++c.gridx;
        this.lblVlrIss.setHorizontalAlignment(4);
        this.pnlResumoImpostos.add((Component)this.lblVlrIss, c);
        ++c.gridx;
        this.lblVlrIssRetido.setHorizontalAlignment(4);
        this.pnlResumoImpostos.add((Component)this.lblVlrIssRetido, c);
        ++c.gridy;
        c.gridx = 0;
        this.pnlResumoImpostos.add((Component)this.lblPis, c);
        ++c.gridx;
        this.lblVlrPis.setHorizontalAlignment(4);
        this.pnlResumoImpostos.add((Component)this.lblVlrPis, c);
        ++c.gridx;
        this.lblVlrPisRetido.setHorizontalAlignment(4);
        this.pnlResumoImpostos.add((Component)this.lblVlrPisRetido, c);
        ++c.gridy;
        c.gridx = 0;
        this.pnlResumoImpostos.add((Component)this.lblCsll, c);
        ++c.gridx;
        this.lblVlrCsll.setHorizontalAlignment(4);
        this.pnlResumoImpostos.add((Component)this.lblVlrCsll, c);
        ++c.gridx;
        this.lblVlrCsllRetido.setHorizontalAlignment(4);
        this.pnlResumoImpostos.add((Component)this.lblVlrCsllRetido, c);
        ++c.gridy;
        c.gridx = 0;
        this.pnlResumoImpostos.add((Component)this.lblCofins, c);
        ++c.gridx;
        this.lblVlrCofins.setHorizontalAlignment(4);
        this.pnlResumoImpostos.add((Component)this.lblVlrCofins, c);
        ++c.gridx;
        this.lblVlrCofinsRetido.setHorizontalAlignment(4);
        this.pnlResumoImpostos.add((Component)this.lblVlrCofinsRetido, c);
        ++c.gridy;
        c.gridx = 0;
        this.pnlResumoImpostos.add((Component)this.lblInss, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.lblVlrInss.setHorizontalAlignment(4);
        this.pnlResumoImpostos.add((Component)this.lblVlrInss, c);
        ++c.gridx;
        this.lblVlrInssRetido.setHorizontalAlignment(4);
        this.pnlResumoImpostos.add((Component)this.lblVlrInssRetido, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.pnlResumoImpostos.add((Component)new JPanel(), c);
        this.controlaCampos();
        this.service = new BaixaService();
        this.btnImprimir.setEnabled(false);
        this.pnlLegenda = FinanceiroUtil.montaPanelLegenda(this.pnlLegenda);
    }

    private void preencheHistoricoUsuario() {
        if (!this.getPodeDescreverHistoricoPadrao()) {
            return;
        }
        boolean isDiferente = false;
        for (int i = 0; i < this.modelTitulos.getRowCount(); ++i) {
            ReceberPagarBean titulo = (ReceberPagarBean)this.modelTitulos.getValueAt(i, 6);
            String favorecido = "";
            if (titulo.getConvenio() != null) {
                favorecido = titulo.getConvenio().getFantasia();
            } else if (titulo.getPaciente() != null) {
                favorecido = titulo.getPaciente().getNome();
            } else if (titulo.getEntidade() != null) {
                favorecido = titulo.getEntidade().getRazaoSocial();
            }
            if (Funcoes.textoVazio(this.favorecidoAnterior)) {
                this.favorecidoAnterior = favorecido;
            }
            if (this.favorecidoAnterior.equalsIgnoreCase(favorecido)) continue;
            isDiferente = true;
            break;
        }
        if (!Funcoes.textoVazio(this.textDescricaoHistoricoUsuario.getText()) && !this.textDescricaoHistoricoUsuario.getText().equalsIgnoreCase(this.favorecidoAnterior)) {
            this.isHistoricoUsuarioAutomatica = false;
        }
        if (Funcoes.textoVazio(this.textDescricaoHistoricoUsuario)) {
            this.isHistoricoUsuarioAutomatica = true;
        }
        if (!isDiferente && (Funcoes.textoVazio(this.textDescricaoHistoricoUsuario.getText()) || this.isHistoricoUsuarioAutomatica)) {
            this.textDescricaoHistoricoUsuario.setText(this.favorecidoAnterior);
            this.isHistoricoUsuarioAutomatica = true;
        } else if (isDiferente && this.isHistoricoUsuarioAutomatica) {
            this.textDescricaoHistoricoUsuario.setText("");
            this.isHistoricoUsuarioAutomatica = true;
        }
    }

    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    public void editar() {
        this.limparCampos();
        AbstractThreadBean bean = this.pesquisar();
        if (bean != null) {
            this.setStatus(3);
            this.controlaCampos();
            this.preencherCampos(bean);
            this.painelCentral.grabFocus();
        }
    }

    public void excluir() {
        this.beanDelete = this.pesquisar();
        if (this.beanDelete != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Baixa.this.preencherCampos(Baixa.this.beanDelete);
                    if (Funcoes.mensagem(Baixa.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                        try {
                            Baixa.this.service.gravaAutoCopiaSemCommit(Baixa.this.beanDelete, 2, Variaveis.filialPadrao, Baixa.this.getCopiaFiliais());
                        }
                        catch (Exception e) {
                            ErrorLogger.mostraMensagem(Baixa.this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "Baixa:excluir");
                        }
                    }
                    Baixa.this.limparCampos();
                    Baixa.this.beanDelete = null;
                }
            });
        }
    }

    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        if (!this.textDescricaoHistoricoUsuario.isEnabled()) {
            this.textDescricaoHistoricoUsuario.setText("");
            this.isHistoricoUsuarioAutomatica = false;
        }
        this.painelCentral.grabFocus();
        this.labelDataBaixa.setText(Funcoes.formataData("dd/MM/yyyy", new Date()));
        this.dataVencimento = new Date();
        this.dataCompetencia = new Date();
        if (this.comboTipoRecPag.isFocusable()) {
            this.comboTipoRecPag.grabFocus();
        }
        this.btnImprimir.setEnabled(false);
    }

    protected static void createDialogDetalhesObservacao(LancamentoBean pgto, int tipo) {
        new DialogDetalhesObservacao(pgto, tipo);
    }

    private int getStatus() {
        return this.status;
    }

    protected void controlaCampos() {
        boolean habilitar = this.getStatus() == 3 || this.getStatus() == 2;
        this.textTitulo.setEnabled(habilitar && !this.executandoOperacoes);
        this.buttonBuscaTitulo.setEnabled(habilitar && !this.executandoOperacoes);
        this.buttonDataBaixa.setEnabled(habilitar && !this.executandoOperacoes);
        this.textDescricaoContaCorrente.setEnabled(habilitar && !this.executandoOperacoes);
        this.textDescricaoHistorico.setEnabled(habilitar && !this.executandoOperacoes);
        this.comboTipoRecPag.setEnabled(habilitar && this.modelTitulos.getRowCount() == 0 && !this.executandoOperacoes);
        this.textDescricaoHistoricoUsuario.setEnabled(habilitar && !this.executandoOperacoes);
        this.textDescricaoHistoricoUsuario.setEnabled(this.textDescricaoHistoricoUsuario.isEnabled() && this.getPodeDescreverHistoricoPadrao() && !this.executandoOperacoes);
        this.controlaBotoesPagamentos(habilitar && !this.executandoOperacoes);
        this.controlaCamposPagamentos(habilitar && !this.executandoOperacoes);
        this.tableFormasPagamento.setEnabled(this.pagamentoAlteracao == null ? !this.executandoOperacoes : false);
        this.habilitaBotoes();
    }

    private boolean getPodeDescreverHistoricoPadrao() {
        int row;
        LancamentoBean aux;
        if (this.tableFormasPagamento.getSelectedRowCount() > 0 && this.tableFormasPagamento.getSelectedRow() != -1 && (aux = (LancamentoBean)this.modelFormasPagamento.getValueAt(row = this.tableFormasPagamento.getSelectedRow(), 4)) != null && aux.getHistoricoPadrao() != null && aux.getHistoricoPadrao().getPermiteDescrever() != null) {
            return aux.getHistoricoPadrao().getPermiteDescrever();
        }
        if (!Funcoes.textoVazio(this.textCodigoHistorico.getText())) {
            HistoricoPadraoVO auxHist;
            try {
                auxHist = (HistoricoPadraoVO)new HistoricoPadraoService().getVO(Variaveis.filialPadrao, this.textCodigoHistorico.getText());
            }
            catch (Exception e) {
                return false;
            }
            if (auxHist != null && auxHist.getPermiteDescrever() != null) {
                return auxHist.getPermiteDescrever();
            }
        }
        return false;
    }

    private void controlaCamposPagamentos(boolean habilitar) {
        if (!this.bloqueiaAlteracoes) {
            this.textCodigoContaCorrente.setEnabled(habilitar);
            this.textCodigoHistorico.setEnabled(habilitar);
            this.comboTipoPagamento.setEnabled(habilitar);
            this.textValor.setEnabled(habilitar);
            this.buttonAdicionaFormaPagamento.setEnabled(habilitar);
            this.buttonBuscaContaCorrente.setEnabled(habilitar);
            this.buttonBuscaHistorico.setEnabled(habilitar);
        } else {
            this.textCodigoContaCorrente.setEnabled(false);
            this.textCodigoHistorico.setEnabled(false);
            this.comboTipoPagamento.setEnabled(false);
            this.textValor.setEnabled(false);
            this.buttonAdicionaFormaPagamento.setEnabled(false);
            this.buttonBuscaContaCorrente.setEnabled(false);
            this.buttonBuscaHistorico.setEnabled(false);
        }
    }

    protected void controlaBotoesPagamentos(boolean habilitar) {
        if (habilitar && !this.bloqueiaAlteracoes) {
            if (this.tableFormasPagamento.getSelectedRowCount() > 0 && this.tableFormasPagamento.getSelectedRow() != -1) {
                int row = this.tableFormasPagamento.getSelectedRow();
                LancamentoBean aux = (LancamentoBean)this.modelFormasPagamento.getValueAt(row, 4);
                String tipoAux = aux.getTipoPagamento();
                this.buttonObservacao.setEnabled(true);
                this.buttonDetalheFormaPgto.setVisible(false);
                if (tipoAux.equals("Z")) {
                    this.buttonDetalheFormaPgto.setText("Detalhes Aut. D\u00e9bito");
                    this.buttonDetalheFormaPgto.setVisible(true);
                } else if (tipoAux.equals("I")) {
                    this.buttonDetalheFormaPgto.setText("Detalhes Cart\u00e3o de D\u00e9bito");
                    this.buttonDetalheFormaPgto.setVisible(true);
                } else if (tipoAux.equals("O")) {
                    this.buttonDetalheFormaPgto.setText("Detalhes Cart\u00e3o de Cr\u00e9dito");
                    this.buttonDetalheFormaPgto.setVisible(true);
                } else if (tipoAux.equals("H") || tipoAux.equals("T") || tipoAux.equals("A") || tipoAux.equals("P")) {
                    this.buttonDetalheFormaPgto.setText("Detalhes Cheque");
                    this.buttonDetalheFormaPgto.setVisible(true);
                } else if (tipoAux.equals("W")) {
                    this.buttonDetalheFormaPgto.setText("Detalhes Transfer\u00eancia Banc\u00e1ria");
                    this.buttonDetalheFormaPgto.setVisible(true);
                } else if (tipoAux.equals("Y")) {
                    this.buttonDetalheFormaPgto.setText("Detalhes Pix");
                    this.buttonDetalheFormaPgto.setVisible(true);
                }
            } else {
                this.buttonObservacao.setEnabled(false);
                this.buttonDetalheFormaPgto.setVisible(false);
            }
        } else {
            this.buttonObservacao.setEnabled(false);
            this.buttonDetalheFormaPgto.setVisible(false);
        }
    }

    private void setDataVencimento(Date dataVencimento) {
        this.dataVencimento = dataVencimento;
        for (int i = 0; i < this.modelFormasPagamento.getRowCount(); ++i) {
            ((LancamentoBean)this.modelFormasPagamento.getValueAt(i, 4)).setDataVencimento(dataVencimento);
        }
    }

    private void setDataCompetencia(Date dataCompetencia) {
        this.dataCompetencia = dataCompetencia;
        for (int i = 0; i < this.modelFormasPagamento.getRowCount(); ++i) {
            ((LancamentoBean)this.modelFormasPagamento.getValueAt(i, 4)).setDataCompetencia(dataCompetencia);
        }
    }

    protected AbstractThreadBean getBeanPreenchido() {
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        Date data = Funcoes.textoVazio(this.labelDataBaixa.getText()) ? null : Funcoes.stringToDate(this.labelDataBaixa.getText());
        String hora = Funcoes.formataData("HH:mm:ss", new Date());
        hora = Funcoes.formataData("dd/MM/yyyy", data) + " " + hora;
        Date dataHora = Funcoes.stringToDate("dd/MM/yyyy HH:mm:ss", hora);
        BaixaBean bxa = new BaixaBean();
        bxa.setFilial(filial);
        bxa.setDataHora(dataHora);
        bxa.setQuantidadeTitulos(new Integer(this.modelTitulos.getRowCount()));
        bxa.setValorTotal(Funcoes.textoVazio(this.lblVlrTotal.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.lblVlrTotal.getText())));
        bxa.setValorJuros(Funcoes.textoVazio(this.lblVlrJuro.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.lblVlrJuro.getText())));
        bxa.setValorAcrescimo(Funcoes.textoVazio(this.lblVlrAcrescimo.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.lblVlrAcrescimo.getText())));
        bxa.setValorDescontos(Funcoes.textoVazio(this.lblVlrDesconto.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.lblVlrDesconto.getText())));
        bxa.setValorTaxas(Funcoes.textoVazio(this.lblVlrTaxa.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.lblVlrTaxa.getText())));
        bxa.setValorMultas(Funcoes.textoVazio(this.lblVlrMulta.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.lblVlrMulta.getText())));
        bxa.setUsuario(usuario);
        bxa.setUsuarioCancelado(null);
        bxa.setSituacao("Q");
        bxa.setDataCancelado(null);
        bxa.setIrrfValor(Funcoes.textoVazio(this.lblVlrIrrf.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.lblVlrIrrf.getText())));
        bxa.setIssValor(Funcoes.textoVazio(this.lblVlrIss.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.lblVlrIss.getText())));
        bxa.setPisValor(Funcoes.textoVazio(this.lblVlrPis.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.lblVlrPis.getText())));
        bxa.setCsllValor(Funcoes.textoVazio(this.lblVlrCsll.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.lblVlrCsll.getText())));
        bxa.setCofinsValor(Funcoes.textoVazio(this.lblVlrCofins.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.lblVlrCofins.getText())));
        bxa.setInssValor(Funcoes.textoVazio(this.lblVlrInss.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.lblVlrInss.getText())));
        bxa.setIrrfRetidoValor(Funcoes.textoVazio(this.lblVlrIrrfRetido.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.lblVlrIrrfRetido.getText())));
        bxa.setIssRetidoValor(Funcoes.textoVazio(this.lblVlrIssRetido.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.lblVlrIssRetido.getText())));
        bxa.setPisRetidoValor(Funcoes.textoVazio(this.lblVlrPisRetido.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.lblVlrPisRetido.getText())));
        bxa.setCofinsRetidoValor(Funcoes.textoVazio(this.lblVlrCofinsRetido.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.lblVlrCofinsRetido.getText())));
        bxa.setCsllRetidoValor(Funcoes.textoVazio(this.lblVlrCsllRetido.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.lblVlrCsllRetido.getText())));
        bxa.setInssRetidoValor(Funcoes.textoVazio(this.lblVlrInssRetido.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.lblVlrInssRetido.getText())));
        if (this.comboTipoRecPag.getSelectedItem().equals("Receber")) {
            bxa.setTipo("C");
        } else {
            bxa.setTipo("D");
        }
        this.setDataVencimento(this.dataVencimento);
        this.setDataCompetencia(this.dataCompetencia);
        ArrayList<ReceberPagarBean> listaRecPag = new ArrayList<ReceberPagarBean>();
        for (int i = 0; i < this.modelTitulos.getRowCount(); ++i) {
            listaRecPag.add((ReceberPagarBean)this.modelTitulos.getValueAt(i, 6));
        }
        bxa.setTitulos(new HashSet(listaRecPag));
        ArrayList<LancamentoBean> listaLancto = new ArrayList<LancamentoBean>();
        for (int i = 0; i < this.modelFormasPagamento.getRowCount(); ++i) {
            listaLancto.add((LancamentoBean)this.modelFormasPagamento.getValueAt(i, 4));
        }
        bxa.setFormasPagamento(new HashSet(listaLancto));
        return bxa;
    }

    protected String getCopiaFiliais() {
        return null;
    }

    protected void limparCampos() {
        this.textTitulo.setText("");
        this.limparTitulos();
        this.detalhesTitulo.limpaDados();
        this.comboTipoPagamento.setSelectedIndex(0);
        this.textValor.setText("");
        this.limparFormasPagamento();
        this.labelDataBaixa.setText("");
        this.lblVlrSubTotal.setText("");
        this.lblVlrTaxa.setText("");
        this.lblVlrMulta.setText("");
        this.lblVlrJuro.setText("");
        this.lblVlrAcrescimo.setText("");
        this.lblVlrDesconto.setText("");
        this.lblVlrTotal.setText("");
        this.lblVlrValorPago.setText("");
        this.lblVlrSaldoTroco.setText("");
        this.lblVlrIrrf.setText("");
        this.lblVlrIss.setText("");
        this.lblVlrPis.setText("");
        this.lblVlrCsll.setText("");
        this.lblVlrCofins.setText("");
        this.lblVlrInss.setText("");
        this.lblVlrIrrfRetido.setText("");
        this.lblVlrIssRetido.setText("");
        this.lblVlrPisRetido.setText("");
        this.lblVlrCsllRetido.setText("");
        this.lblVlrCofinsRetido.setText("");
        this.lblVlrInssRetido.setText("");
        this.textCodigoContaCorrente.setText("");
        this.textDescricaoContaCorrente.setText("");
        this.textCodigoHistorico.setText("");
        this.textDescricaoHistorico.setText("");
        this.textDescricaoHistoricoUsuario.setText("");
        this.pnlPlanoCustoPagamento.limparCampos();
        this.pnlPlanoCustoTitulo.limparCampos();
        this.isHistoricoUsuarioAutomatica = false;
        this.favorecidoAnterior = null;
        this.pagamentoAlteracao = null;
    }

    protected AbstractThreadBean pesquisar() {
        BaixaService service = new BaixaService();
        BaixaVO baixa = new BaixaVO();
        baixa = (BaixaVO)service.pesquisaVO(Laboratorio.getInstancia(), baixa, "Pesquisando baixas", false);
        if (baixa != null) {
            try {
                BaixaBean bean = (BaixaBean)service.get(baixa.getFilial().getCodigo().toString(), baixa.getCodigo().toString());
                if (bean == null) {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel localizar a baixa.", 2);
                    return null;
                }
                return bean;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar baixa.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        return null;
    }

    protected void preencherCampos(AbstractThreadBean bean) {
        AbstractThreadBean beanAux;
        int i;
        this.beanEstorno = (BaixaBean)bean;
        ArrayList arrayTitulos = null;
        ArrayList arrayPagamentos = null;
        LancamentoService servicePagamentos = new LancamentoService();
        this.labelDataBaixa.setText(Funcoes.formataData("dd/MM/yyyy", ((BaixaBean)bean).getDataHora()));
        arrayTitulos = new ArrayList(((BaixaBean)bean).getTitulos());
        for (i = 0; i < arrayTitulos.size(); ++i) {
            beanAux = null;
            try {
                beanAux = (ReceberPagarBean)arrayTitulos.get(i);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar as informa\u00e7\u00f5es da baixa.\n" + e.getMessage(), e.getStackTrace());
            }
            this.adicionarTitulo((ReceberPagarBean)beanAux);
        }
        arrayPagamentos = new ArrayList(((BaixaBean)bean).getFormasPagamento());
        for (i = 0; i < arrayPagamentos.size(); ++i) {
            beanAux = null;
            try {
                beanAux = (LancamentoBean)servicePagamentos.voToBean(((BaixaLancamentoBean)arrayPagamentos.get(i)).getLancamento(), LancamentoBean.class);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar as informa\u00e7\u00f5es da baixa.\n" + e.getMessage(), e.getStackTrace());
            }
            this.adicionarFormasPagamento((LancamentoBean)beanAux);
        }
        this.atualizarResumo();
    }

    protected void carregaBaixa(BaixaBean bean) {
        if (bean != null) {
            this.preencherCampos(bean);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validaCampos() {
        String retorno;
        BaixaBean bxa = (BaixaBean)this.getBeanPreenchido();
        if (this.modelTitulos.getRowCount() == 0) {
            Funcoes.mensagem(this, "N\u00e3o foi informado nenhum t\u00edtulo na baixa.", 2);
            if (this.textTitulo.isFocusable()) {
                this.textTitulo.grabFocus();
            }
            return false;
        }
        if (this.modelFormasPagamento.getRowCount() == 0) {
            Funcoes.mensagem(this, "N\u00e3o foi informado nenhum pagamento na baixa.", 2);
            if (this.textCodigoContaCorrente.isFocusable()) {
                this.textCodigoContaCorrente.grabFocus();
            }
            return false;
        }
        if (this.getSomatorioBaixas().doubleValue() != this.getSomatorioTitulos().doubleValue()) {
            Funcoes.mensagem(this, "Os pagamentos somados devem totalizar R$ " + Funcoes.formataDecimal(this.getSomatorioTitulos()) + ".", 2);
            return false;
        }
        for (int i = 0; i < this.modelFormasPagamento.getRowCount(); ++i) {
            int resposta;
            LancamentoBean lancto = (LancamentoBean)this.modelFormasPagamento.getValueAt(i, 4);
            ContaCorrenteBean conta = null;
            try {
                conta = (ContaCorrenteBean)new ContaCorrenteDao().getBean(Variaveis.filialPadrao, String.valueOf(lancto.getContaCorrente().getReduzido()));
            }
            catch (ThreadDaoException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar dados da Conta Corrente/Caixa. " + e.getMessage(), e.getStackTrace());
            }
            if (conta != null && conta.getDataSaldoInicial() != null) {
                if (lancto.getDataVencimento() == null) {
                    Funcoes.mensagem(this, "A data de Vencimento do Lan\u00e7amento esta incorreta.\nLancamento: " + Tipos.tipoPagamento(lancto.getTipoPagamento()) + ", Conta: " + conta.getConta() + ".\nA data de Saldo Inicial da Conta \u00e9: " + Funcoes.formataData(conta.getDataSaldoInicial()) + ".", 2);
                    return false;
                }
                if (lancto.getDataVencimento().compareTo(conta.getDataSaldoInicial()) < 0) {
                    Funcoes.mensagem(this, "A data de Vencimento deve ser maior ou igual a data de Saldo Inicial da Conta Corrente/Caixa.\nLancamento: " + Tipos.tipoPagamento(lancto.getTipoPagamento()) + ", Conta: " + conta.getConta() + ".\nA data de Saldo Inicial da Conta \u00e9: " + Funcoes.formataData(conta.getDataSaldoInicial()) + ".", 2);
                    return false;
                }
                if (lancto.getDataCompetencia().compareTo(conta.getDataSaldoInicial()) < 0) {
                    Funcoes.mensagem(this, "A data de Compet\u00eancia deve ser maior ou igual a data de Saldo Inicial da Conta Corrente/Caixa.\nLancamento: " + Tipos.tipoPagamento(lancto.getTipoPagamento()) + ", Conta: " + conta.getConta() + ".\nA data de Saldo Inicial da Conta \u00e9: " + Funcoes.formataData(conta.getDataSaldoInicial()) + ".", 2);
                    return false;
                }
            }
            boolean validaCheque = false;
            try {
                validaCheque = new LancamentoService().validaCheque(lancto);
            }
            catch (SQLException e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel verificar se o cheque j\u00e1 foi usado em outros pagamentos.", 2);
                return false;
            }
            if (validaCheque || (resposta = Funcoes.mensagem(this, "O cheque: \"" + lancto.getNumeroCheque() + "\" j\u00e1 foi usado em outro pagamento.\nDeseja usar o mesmo cheque?", 4)) != 1) continue;
            return false;
        }
        if (Acesso.getAcesso(PROIBIR_BAIXA_SEM_APROPRIAR_PLANO_CONTAS)) {
            HashMap<Boolean, String> planosDeContasInvalidos = this.service.validarPlanosDeContasNosPagamentos(this.modelTitulos, this.modelFormasPagamento);
            if (!planosDeContasInvalidos.isEmpty()) {
                Map.Entry invalidos = (Map.Entry)planosDeContasInvalidos.entrySet().stream().findFirst().get();
                if (!((Boolean)invalidos.getKey()).booleanValue()) {
                    Funcoes.mensagem(this, (String)invalidos.getValue(), 2);
                    return false;
                }
                if (Funcoes.textoVazio((String)invalidos.getValue())) {
                    Funcoes.mensagem(this, "O valor total da baixa do t\u00edtulo deve ser apropriado nos planos de conta", 2);
                    this.alterarPlanoPagamento();
                    return false;
                }
                int opcao = Funcoes.mensagem(Laboratorio.getInstancia(), (String)invalidos.getValue(), 4);
                if (opcao != 0) {
                    return false;
                }
                this.service.copiarPlanosDeContasParaOsPagamentos(this.modelTitulos, this.modelFormasPagamento, this.pnlPlanoCustoPagamento);
            }
        } else {
            int resp;
            boolean possuiPlanoContas = this.service.titulosPossuemPlanoDeContas(this.modelTitulos);
            if (possuiPlanoContas && this.modelFormasPagamento.getRowCount() == 1 && (resp = Funcoes.mensagem(Laboratorio.getInstancia(), "Deseja copiar as informa\u00e7\u00f5es do(s) Plano(s) de Contas do t\u00edtulo para o pagamento?", 4, true)) == 0) {
                this.service.copiarPlanosDeContasParaOsPagamentos(this.modelTitulos, this.modelFormasPagamento, this.pnlPlanoCustoPagamento);
            }
        }
        if (Acesso.getAcesso(PROIBIR_BAIXA_SEM_APROPRIAR_CENTRO_CUSTO)) {
            HashMap<Boolean, String> centrosDeCustosInvalidos = this.service.validarCentrosDeCustosNosPagamentos(this.modelTitulos, this.modelFormasPagamento);
            if (!centrosDeCustosInvalidos.isEmpty()) {
                Map.Entry invalidos = (Map.Entry)centrosDeCustosInvalidos.entrySet().stream().findFirst().get();
                if (!((Boolean)invalidos.getKey()).booleanValue()) {
                    Funcoes.mensagem(this, (String)invalidos.getValue(), 2);
                    return false;
                }
                if (Funcoes.textoVazio((String)invalidos.getValue())) {
                    Funcoes.mensagem(this, "O valor total da baixa do titulo deve ser apropriado nos centros de custo", 2);
                    this.alterarPlanoPagamento();
                    return false;
                }
                int opcao = Funcoes.mensagem(Laboratorio.getInstancia(), (String)invalidos.getValue(), 4);
                if (opcao != 0) {
                    return false;
                }
                this.service.copiarCentrosDeCustoParaOsPagamentos(this.modelTitulos, this.modelFormasPagamento, this.pnlPlanoCustoPagamento);
            }
        } else {
            int resp;
            boolean possuiCentroCusto = this.service.titulosPossuemCentroDeCustos(this.modelTitulos);
            if (possuiCentroCusto && (resp = Funcoes.mensagem(Laboratorio.getInstancia(), "Deseja copiar as informa\u00e7\u00f5es do(s) Centro(s) de Custo do t\u00edtulo para o pagamento?", 4, true)) == 0) {
                this.service.copiarCentrosDeCustoParaOsPagamentos(this.modelTitulos, this.modelFormasPagamento, this.pnlPlanoCustoPagamento);
            }
        }
        if (!Funcoes.textoVazio(retorno = this.service.validar(bxa))) {
            Funcoes.mensagem(this, retorno, 2);
            return false;
        }
        return true;
    }

    public void defineAcessos() {
        this.setModuloAcesso(Baixa.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0600400601"));
        this.setModuloAlteraTitulo(Long.parseLong("0600400602"));
        this.setModuloApaga(Long.parseLong("0600400603"));
    }

    public void setModuloAcesso(long modulo) {
        this.moduloAcesso = modulo;
        this.buttonFechar.setVisible(this.moduloAcesso == 0L || Acesso.getAcesso(this.moduloAcesso));
    }

    public void setModuloInsere(long modulo) {
        this.moduloInsere = modulo;
        this.buttonNovo.setVisible(this.moduloInsere == 0L || Acesso.getAcesso(this.moduloInsere));
        this.buttonSalvar.setVisible(this.moduloInsere == 0L || Acesso.getAcesso(this.moduloInsere));
        this.buttonCancelar.setVisible(this.moduloInsere == 0L || Acesso.getAcesso(this.moduloInsere));
    }

    public void setModuloApaga(long modulo) {
        this.moduloApaga = modulo;
        this.buttonExcluir.setVisible(this.moduloApaga == 0L || Acesso.getAcesso(this.moduloApaga));
    }

    public void setModuloAlteraTitulo(long modulo) {
        this.moduloAlteraTitulo = modulo;
        this.itemAlterarTitulo.setEnabled(this.moduloAlteraTitulo == 0L || Acesso.getAcesso(this.moduloAlteraTitulo));
    }

    public void habilitaBotoes() {
        boolean habilita = this.status == 2 || this.status == 3;
        this.buttonNovo.setEnabled(this.status == 1 && !this.executandoOperacoes);
        this.buttonNovo.setFocusable(this.status == 1 && !this.executandoOperacoes);
        this.buttonEditar.setEnabled(this.status == 1 && !this.executandoOperacoes);
        this.buttonEditar.setFocusable(this.status == 1 && !this.executandoOperacoes);
        this.buttonFechar.setEnabled(this.status == 1 && !this.executandoOperacoes);
        this.buttonFechar.setFocusable(this.status == 1 && !this.executandoOperacoes);
        this.buttonExcluir.setEnabled(this.status == 1 && !this.executandoOperacoes);
        this.buttonExcluir.setFocusable(this.status == 1 && !this.executandoOperacoes);
        this.buttonSalvar.setEnabled(habilita && !this.executandoOperacoes);
        this.buttonSalvar.setFocusable(habilita && !this.executandoOperacoes);
        this.buttonCancelar.setEnabled(habilita && !this.executandoOperacoes);
        this.buttonCancelar.setFocusable(habilita && !this.executandoOperacoes);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600400600");
    }

    private void buscaTitulo() {
        try {
            List<HashMap<String, Object>> titulos = null;
            String tipoRecPag = "";
            tipoRecPag = this.comboTipoRecPag.getSelectedItem().equals(Tipos.tipoReceberPagar("R")) ? "R" : "P";
            DialogoFiltroBaixa diag = new DialogoFiltroBaixa(Laboratorio.getInstancia(), tipoRecPag);
            diag.setVisible(true);
            if (diag.getOk() && (titulos = diag.getTitulosAbertosSelecionados()) != null) {
                Iterator<HashMap<String, Object>> it = titulos.iterator();
                if (!titulos.isEmpty()) {
                    SplashMensagem janelaEspera = SplashMensagem.getInstancia(this);
                    janelaEspera.mostrar("Adicionando t\u00edtulos");
                    int i = 0;
                    int qtde = titulos.size();
                    while (it.hasNext()) {
                        HashMap<String, Object> reg = it.next();
                        janelaEspera.setText("Adicionando t\u00edtulos - " + (int)Funcoes.arredondar(++i * 100 / qtde, 2) + "%");
                        ReceberPagarBean titulo = (ReceberPagarBean)new ReceberPagarDao().getBean(Variaveis.filialPadrao, String.valueOf(reg.get("C\u00f3digo")));
                        if (titulo == null || !this.validaTitulo(titulo)) continue;
                        this.adicionarTitulo(titulo);
                    }
                    janelaEspera.apagar();
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Baixa:220");
        }
    }

    private void buscaTitulo(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            return;
        }
        try {
            String tipo = this.comboTipoRecPag.getSelectedItem().equals("Receber") ? "R" : "P";
            ReceberPagarBean titulo = (ReceberPagarBean)new ReceberPagarDao().getBean(Variaveis.filialPadrao, codigo);
            if (null == titulo) {
                Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel localizar o " + (tipo.equalsIgnoreCase("R") ? "receber." : "pagar."), 2);
                return;
            }
            if (null != titulo) {
                if (!this.validaTitulo(titulo)) {
                    return;
                }
                this.adicionarTitulo(titulo);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Baixa:239");
        }
    }

    private void removerTitulo() {
        if (!this.bloqueiaAlteracoes) {
            if (this.tableTitulos.getSelectedRowCount() < 0) {
                return;
            }
            if (Funcoes.mensagem(this, "Confirma exclus\u00e3o do t\u00edtulo selecionado?", 4, true) == 1) {
                return;
            }
            int row = this.tableTitulos.getSelectedRow();
            this.modelTitulos.removeLine(row);
            this.atualizarTitulos();
            this.atualizarResumo();
            if (this.modelTitulos.getColunaOrdenacao() != -1) {
                this.modelTitulos.ordenarColunaSemTrocarSentido(this.modelTitulos.getColunaOrdenacao());
            }
        }
    }

    private void adicionarTitulo(ReceberPagarBean titulo) {
        for (int i = 0; i < this.modelTitulos.getRowCount(); ++i) {
            if (!this.modelTitulos.getValueAt(i, 6).equals(titulo)) continue;
            return;
        }
        try {
            titulo.setSituacao("Q");
            FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)titulo);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Baixa:1075");
        }
        this.modelTitulos.addLine(new Object[]{null, null, null, null, null, null, titulo});
        this.atualizarTitulos();
        this.atualizarResumo();
        this.preencheHistoricoUsuario();
        if (titulo.getTipo().equals("P")) {
            this.comboTipoRecPag.setSelectedItem("Pagar");
        } else {
            this.comboTipoRecPag.setSelectedItem("Receber");
        }
        this.comboTipoRecPag.setEnabled(false);
        this.textTitulo.setText("");
        if (this.modelTitulos.getColunaOrdenacao() != -1) {
            this.modelTitulos.ordenarColunaSemTrocarSentido(this.modelTitulos.getColunaOrdenacao());
        }
        if (this.textTitulo.isFocusable()) {
            this.textTitulo.grabFocus();
        }
    }

    private boolean validaTitulo(ReceberPagarBean titulo) {
        boolean erro = false;
        if (titulo.getSituacao() != null && !titulo.getSituacao().equalsIgnoreCase("A")) {
            Funcoes.mensagem(this, "Somente t\u00edtulos com situa\u00e7\u00e3o 'Aberto' podem ser baixados.\nA situa\u00e7\u00e3o do t\u00edtulo \u00e9: '" + Tipos.tipoSituacaoReceberPagar(titulo.getSituacao()) + "'.", 2);
            erro = true;
        }
        if (erro) {
            this.textTitulo.selectAll();
            if (this.textTitulo.isFocusable()) {
                this.textTitulo.grabFocus();
            }
            return false;
        }
        return true;
    }

    private boolean validaFormaPagamento() {
        if (this.comboTipoPagamento.getSelectedIndex() < 0) {
            Funcoes.mensagem(this, "Tipo pagamento n\u00e3o selecionado.", 2);
            if (this.comboTipoPagamento.isFocusable()) {
                this.comboTipoPagamento.grabFocus();
            }
            return false;
        }
        if (Funcoes.textoVazio(this.textValor)) {
            Funcoes.mensagem(this, "Valor do pagamento n\u00e3o informado.", 2);
            if (this.textValor.isFocusable()) {
                this.textValor.grabFocus();
            }
            return false;
        }
        try {
            if (Float.parseFloat(this.textValor.getText()) <= 0.0f) {
                Funcoes.mensagem(this, "O Valor do pagamento deve ser maior que zero.", 2);
                if (this.textValor.isFocusable()) {
                    this.textValor.grabFocus();
                }
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            Funcoes.mensagem(this, "O valor inserido n\u00e3o \u00e9 num\u00e9rico.", 2);
            if (this.textValor.isFocusable()) {
                this.textValor.grabFocus();
            }
            return false;
        }
        if (Funcoes.textoVazio(this.textCodigoContaCorrente.getText())) {
            Funcoes.mensagem(this, "Conta corrente n\u00e3o selecionada para o lan\u00e7amento.", 2);
            if (this.textCodigoContaCorrente.isFocusable()) {
                this.textCodigoContaCorrente.grabFocus();
            }
            return false;
        }
        if (this.textDescricaoContaCorrente.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Conta corrente selecionada n\u00e3o localizada.", 2);
            if (this.textCodigoContaCorrente.isFocusable()) {
                this.textCodigoContaCorrente.grabFocus();
            }
            return false;
        }
        if (Funcoes.textoVazio(this.textCodigoHistorico.getText())) {
            Funcoes.mensagem(this, "Hist\u00f3rico n\u00e3o selecionado para o lan\u00e7amento.", 2);
            if (this.textCodigoHistorico.isFocusable()) {
                this.textCodigoHistorico.grabFocus();
            }
            return false;
        }
        if (this.textDescricaoHistorico.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Hist\u00f3rico selecionado n\u00e3o localizado.", 2);
            if (this.textCodigoHistorico.isFocusable()) {
                this.textCodigoHistorico.grabFocus();
            }
            return false;
        }
        return true;
    }

    private void adicionarFormaPagamento() {
        if (!this.validaFormaPagamento()) {
            return;
        }
        try {
            LancamentoBean forma = null;
            forma = this.pagamentoAlteracao != null ? this.pagamentoAlteracao : new LancamentoBean();
            FilialVO filial = new FilialVO();
            filial.setCodigo(Integer.valueOf(Variaveis.filialPadrao));
            forma.setFilial(filial);
            EstacaoVO estacao = new EstacaoVO();
            estacao.setCodigo(Integer.parseInt(Variaveis.codigoEstacao));
            forma.setEstacao(estacao);
            UsuarioVO usuario = new UsuarioVO();
            usuario.setCodigo(Variaveis.login);
            forma.setUsuario(usuario);
            forma.setDataHora(new Date());
            forma.setSituacao("A");
            if (Arrays.asList(this.comboTipoRecPag.getSelectedObjects()).contains("Receber")) {
                forma.setTipo("C");
            } else {
                forma.setTipo("D");
            }
            forma.setValor(Funcoes.textoVazio(this.textValor.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValor.getText())));
            forma.setValorTotal(Funcoes.textoVazio(this.textValor.getText()) ? new Double(0.0) : Double.valueOf(Funcoes.limpaDecimal(this.textValor.getText())));
            if (!Funcoes.textoVazio(this.textCodigoContaCorrente.getText()) && !this.textDescricaoContaCorrente.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
                ContaCorrenteVO conta = new ContaCorrenteVO();
                conta.setReduzido(Integer.parseInt(this.textCodigoContaCorrente.getText()));
                conta.setConta(this.textDescricaoContaCorrente.getText());
                forma.setContaCorrente(conta);
            }
            if (!Funcoes.textoVazio(this.textCodigoHistorico.getText()) && !this.textDescricaoHistorico.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
                HistoricoPadraoVO historico = new HistoricoPadraoVO();
                historico.setCodigo(Integer.parseInt(this.textCodigoHistorico.getText()));
                historico.setDescricao(this.textDescricaoHistorico.getText());
                forma.setHistoricoPadrao(historico);
            }
            if (this.getPodeDescreverHistoricoPadrao()) {
                forma.setDescricaoHistorico(this.textDescricaoHistoricoUsuario.getText());
            } else {
                forma.setDescricaoHistorico("");
            }
            String tipo = (String)this.comboTipoPagamento.getSelectedItem();
            if (tipo.equalsIgnoreCase(Tipos.tipoPagamento("D"))) {
                forma.setTipoPagamento("D");
            } else if (tipo.equalsIgnoreCase(Tipos.tipoPagamento("H"))) {
                forma.setTipoPagamento("H");
            } else if (tipo.equalsIgnoreCase(Tipos.tipoPagamento("I"))) {
                forma.setTipoPagamento("I");
            } else if (tipo.equalsIgnoreCase(Tipos.tipoPagamento("O"))) {
                forma.setTipoPagamento("O");
            } else if (tipo.equalsIgnoreCase(Tipos.tipoPagamento("P"))) {
                forma.setTipoPagamento("P");
            } else if (tipo.equalsIgnoreCase(Tipos.tipoPagamento("A"))) {
                forma.setTipoPagamento("A");
            } else if (tipo.equalsIgnoreCase(Tipos.tipoPagamento("T"))) {
                forma.setTipoPagamento("T");
            } else if (tipo.equalsIgnoreCase(Tipos.tipoPagamento("B"))) {
                forma.setTipoPagamento("B");
            } else if (tipo.equalsIgnoreCase(Tipos.tipoPagamento("E"))) {
                forma.setTipoPagamento("E");
            } else if (tipo.equalsIgnoreCase(Tipos.tipoPagamento("U"))) {
                forma.setTipoPagamento("U");
            } else if (tipo.equalsIgnoreCase(Tipos.tipoPagamento("N"))) {
                forma.setTipoPagamento("N");
            } else if (tipo.equalsIgnoreCase(Tipos.tipoPagamento("Z"))) {
                forma.setTipoPagamento("Z");
                this.controlaCamposPagamentos(false);
            } else if (tipo.equalsIgnoreCase(Tipos.tipoPagamento("W"))) {
                forma.setTipoPagamento("W");
            } else if (tipo.equalsIgnoreCase(Tipos.tipoPagamento("Y"))) {
                forma.setTipoPagamento("Y");
            }
            forma.setTipoDocumento("C");
            if (forma.getDataVencimento() == null) {
                forma.setDataVencimento(this.dataVencimento);
            }
            forma.setDataCompetencia(this.dataCompetencia);
            forma.setValorMulta(0.0);
            forma.setValorJuro(0.0);
            forma.setValorAcrescimo(0.0);
            forma.setValorDesconto(0.0);
            forma.setPercentualMulta(0.0);
            forma.setPercentualJuro(0.0);
            forma.setPercentualAcrescimo(0.0);
            forma.setPercentualDesconto(0.0);
            forma.setTipoOrigem("B");
            if (this.comboTipoRecPag.getSelectedItem().equals(Tipos.tipoReceberPagar("R"))) {
                forma.setTipo("C");
            } else {
                forma.setTipo("D");
            }
            this.adicionarFormasPagamento(forma);
            FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)forma);
            this.atualizarFormasPagamento();
            this.atualizarResumo();
            this.textCodigoContaCorrente.setText("");
            this.textDescricaoContaCorrente.setText("");
            this.textCodigoHistorico.setText("");
            this.textDescricaoHistorico.setText("");
            this.comboTipoPagamento.setSelectedIndex(0);
            this.textValor.setText("");
            this.pagamentoAlteracao = null;
            if (this.textCodigoContaCorrente.isFocusable()) {
                this.textCodigoContaCorrente.grabFocus();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel inserir o pagamento.\n" + ex.getMessage(), ex.getStackTrace());
        }
    }

    private void removerFormaPagamento() {
        if (!this.bloqueiaAlteracoes) {
            if (this.tableFormasPagamento.getSelectedRowCount() < 0) {
                return;
            }
            if (Funcoes.mensagem(this, "Confirma exclus\u00e3o da forma de pagamento selecionada?", 4, true) == 1) {
                return;
            }
            int row = this.tableFormasPagamento.getSelectedRow();
            this.modelFormasPagamento.removeLine(row);
            this.pagamentoAlteracao = null;
            this.atualizarFormasPagamento();
            this.atualizarResumo();
            this.controlaCamposPagamentos(true);
            if (this.textCodigoContaCorrente.isEnabled() && this.textCodigoContaCorrente.isFocusable()) {
                ScreenUtil.requisitarFoco(this.textCodigoContaCorrente);
            }
        }
    }

    private void atualizarTitulos() {
        for (int i = 0; i < this.modelTitulos.getRowCount(); ++i) {
            ReceberPagarBean titulo = (ReceberPagarBean)this.modelTitulos.getValueAt(i, 6);
            String favorecido = "";
            if (titulo.getConvenio() != null) {
                favorecido = titulo.getConvenio().getFantasia();
            } else if (titulo.getPaciente() != null) {
                favorecido = titulo.getPaciente().getNome();
            } else if (titulo.getEntidade() != null) {
                favorecido = titulo.getEntidade().getRazaoSocial();
            }
            this.modelTitulos.setValueAt(titulo.getCodigo(), i, 0);
            this.modelTitulos.setValueAt(favorecido, i, 1);
            this.modelTitulos.setValueAt(titulo.getNumeroDocumento(), i, 2);
            this.modelTitulos.setValueAt(Funcoes.formataData("dd/MM/yyyy", titulo.getDataVencimento()), i, 3);
            this.modelTitulos.setValueAt(Funcoes.formataDecimal(titulo.getValor()), i, 4);
            this.modelTitulos.setValueAt(titulo.getValorTotal() == null ? "" : Funcoes.formataDecimal(titulo.getValorTotal()), i, 5);
        }
    }

    private void limparTitulos() {
        while (this.modelTitulos.getRowCount() > 0) {
            this.modelTitulos.clear();
        }
        this.detalhesTitulo.limpaDados();
    }

    private void adicionarFormasPagamento(LancamentoBean lancto) {
        for (int i = 0; i < this.modelFormasPagamento.getRowCount(); ++i) {
            if (!this.modelFormasPagamento.getValueAt(i, 4).equals(lancto)) continue;
            this.modelFormasPagamento.setValueAt(lancto, i, 4);
            return;
        }
        this.modelFormasPagamento.addLine(new Object[]{lancto.getContaCorrente().getConta(), Tipos.tipoPagamento(lancto.getTipoPagamento()), Funcoes.formataDecimal(lancto.getValor()), lancto.getObservacao() == null ? "" : lancto.getObservacao(), lancto});
        this.controlaBotoesPagamentos(true);
    }

    private void atualizarFormasPagamento() {
        for (int i = 0; i < this.modelFormasPagamento.getRowCount(); ++i) {
            LancamentoBean lancto = (LancamentoBean)this.modelFormasPagamento.getValueAt(i, 4);
            this.modelFormasPagamento.setValueAt(lancto.getContaCorrente().getConta(), i, 0);
            this.modelFormasPagamento.setValueAt(Tipos.tipoPagamento(lancto.getTipoPagamento()), i, 1);
            this.modelFormasPagamento.setValueAt(Funcoes.formataDecimal(lancto.getValor()), i, 2);
            this.modelFormasPagamento.setValueAt(lancto.getObservacao() == null ? "" : lancto.getObservacao(), i, 3);
            this.modelFormasPagamento.setValueAt(lancto, i, 4);
        }
        this.pagamentoAlteracao = null;
        this.controlaBotoesPagamentos(true);
    }

    private void limparFormasPagamento() {
        if (this.modelFormasPagamento != null) {
            this.modelFormasPagamento.clear();
        }
    }

    private boolean validaImpressaoAutorizacao(BaixaBean bean) {
        boolean ret = false;
        if (bean != null) {
            for (LancamentoBean l : bean.getFormasPagamento()) {
                if (!l.getTipoPagamento().equalsIgnoreCase("Z")) continue;
                return true;
            }
        }
        return ret;
    }

    public void setStatus(int newStatus) {
        if (this.status != newStatus) {
            this.status = newStatus;
        }
        this.controlaCampos();
        if (this.status == 1 && this.buttonNovo.isEnabled()) {
            this.buttonNovo.grabFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void salvar() {
        AbstractThreadBean bean;
        SplashMensagem janelaEspera = null;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                int resp;
                janelaEspera = SplashMensagem.getInstancia(this);
                janelaEspera.mostrar("Salvando baixa...");
                this.service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                Conexao.arquivaSQL();
                janelaEspera.apagar();
                Funcoes.mensagem(this, "Baixa gerada com o c\u00f3digo: " + ((BaixaBean)bean).getCodigo() + ".", 5);
                if (this.validaImpressaoAutorizacao((BaixaBean)bean) && (resp = Funcoes.mensagem(this, "Deseja imprimir a autoriza\u00e7\u00e3o de d\u00e9bito?", 4, true)) == 0) {
                    this.imprimir((BaixaBean)bean);
                }
                if ((resp = Funcoes.mensagem(this, "Deseja conciliar a baixa?", 4)) == 0) {
                    JDialog diag = new JDialog((Frame)Laboratorio.getInstancia(), true);
                    Conciliacao conciliacao = new Conciliacao();
                    conciliacao.novo();
                    conciliacao.setJanela(diag);
                    Iterator it = ((BaixaBean)bean).getFormasPagamento().iterator();
                    while (it.hasNext()) {
                        conciliacao.adicionarLancamento((LancamentoBean)it.next());
                    }
                    diag.setContentPane(conciliacao);
                    diag.setSize(new Dimension(600, 500));
                    diag.setResizable(false);
                    diag.setDefaultCloseOperation(0);
                    ScreenUtil.centralizar(diag);
                    diag.setVisible(true);
                }
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "FrmCadPadraoBean:86");
            }
            finally {
                if (janelaEspera != null) {
                    janelaEspera.apagar();
                }
            }
        }
    }

    private void atualizarResumo() {
        BaixaBean bxa = (BaixaBean)this.getBeanPreenchido();
        if (this.service == null) {
            this.service = new BaixaService();
        }
        this.service.atualizarValores(bxa);
        this.lblVlrSubTotal.setText(Funcoes.formataDecimal(bxa.getSubTotal()));
        this.lblVlrTaxa.setText(Funcoes.formataDecimal(bxa.getValorTaxas()));
        this.lblVlrMulta.setText(Funcoes.formataDecimal(bxa.getValorMultas()));
        this.lblVlrJuro.setText(Funcoes.formataDecimal(bxa.getValorJuros()));
        this.lblVlrAcrescimo.setText(Funcoes.formataDecimal(bxa.getValorAcrescimo()));
        this.lblVlrDesconto.setText(Funcoes.formataDecimal(bxa.getValorDescontos()));
        this.lblVlrTotal.setText(Funcoes.formataDecimal(bxa.getValorTotal()));
        this.lblVlrValorPago.setText(Funcoes.formataDecimal(bxa.getValorPago()));
        this.lblVlrSaldoTroco.setText(Funcoes.formataDecimal(bxa.getSaldoTroco()));
        this.lblVlrIrrf.setText(Funcoes.formataDecimal(bxa.getIrrfValor()));
        this.lblVlrIss.setText(Funcoes.formataDecimal(bxa.getIssValor()));
        this.lblVlrPis.setText(Funcoes.formataDecimal(bxa.getPisValor()));
        this.lblVlrCsll.setText(Funcoes.formataDecimal(bxa.getCsllValor()));
        this.lblVlrCofins.setText(Funcoes.formataDecimal(bxa.getCofinsValor()));
        this.lblVlrInss.setText(Funcoes.formataDecimal(bxa.getInssValor()));
        this.lblVlrIrrfRetido.setText(Funcoes.formataDecimal(bxa.getIrrfRetidoValor()));
        this.lblVlrIssRetido.setText(Funcoes.formataDecimal(bxa.getIssRetidoValor()));
        this.lblVlrPisRetido.setText(Funcoes.formataDecimal(bxa.getPisRetidoValor()));
        this.lblVlrCsllRetido.setText(Funcoes.formataDecimal(bxa.getCsllRetidoValor()));
        this.lblVlrCofinsRetido.setText(Funcoes.formataDecimal(bxa.getCofinsRetidoValor()));
        this.lblVlrInssRetido.setText(Funcoes.formataDecimal(bxa.getInssRetidoValor()));
    }

    @Override
    public void pressioneiF2() {
        if (this.textTitulo.hasFocus()) {
            this.buscaTitulo();
        } else if (this.textCodigoContaCorrente.hasFocus()) {
            this.buscaContaCorrente();
        } else if (this.textCodigoHistorico.hasFocus()) {
            this.buscaHistorico();
        }
    }

    private void atualizarValoresTitulos() {
        Date data = null;
        if (Funcoes.verificaData("dd/MM/yyyy", this.labelDataBaixa.getText())) {
            data = Funcoes.stringToDate("dd/MM/yyyy", this.labelDataBaixa.getText());
        }
        for (int i = 0; i < this.modelTitulos.getRowCount(); ++i) {
            ReceberPagarBean titulo = (ReceberPagarBean)this.modelTitulos.getValueAt(i, 6);
            ReceberPagarBean receberPagarBean = (ReceberPagarBean)FinanceiroUtil.atualizaValores(titulo, data);
        }
    }

    private void mostrarDadosTitulos(ReceberPagarBean titulo) {
        this.detalhesTitulo.setDados(titulo.getTaxa(), titulo.getValorMulta(), titulo.getPercentualMulta(), titulo.getValorJuro(), titulo.getPercentualJuro(), titulo.getValorAcrescimo(), titulo.getPercentualAcrescimo(), titulo.getValorDesconto(), titulo.getPercentualDesconto());
        this.detalhesTitulo.atualizarDados();
    }

    private void alterarTitulo() {
        if (this.tableTitulos.getSelectedRowCount() < 0) {
            return;
        }
        int row = this.tableTitulos.getSelectedRow();
        Date data = null;
        if (Funcoes.verificaData("dd/MM/yyyy", this.labelDataBaixa.getText())) {
            data = Funcoes.stringToDate("dd/MM/yyyy", this.labelDataBaixa.getText());
        }
        AlterarTituloBaixa tela = new AlterarTituloBaixa(Laboratorio.getInstancia());
        ReceberPagarBean titulo = (ReceberPagarBean)this.modelTitulos.getValueAt(row, 6);
        tela.setTitulo((ReceberPagarBean)titulo.clonar());
        tela.setService(this.tituloService);
        tela.setDataConciliacao(data);
        tela.setVisible(true);
        titulo = tela.getTitulo();
        if (titulo != null) {
            this.modelTitulos.setValueAt(titulo, row, 6);
            FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)titulo);
            this.atualizarTitulos();
            this.mostrarDadosTitulos(titulo);
            this.atualizarResumo();
        }
    }

    private void alterarFormaPagamento() {
        if (this.tableFormasPagamento.getSelectedRowCount() < 0) {
            return;
        }
        int row = this.tableFormasPagamento.getSelectedRow();
        this.pagamentoAlteracao = (LancamentoBean)this.modelFormasPagamento.getValueAt(row, 4);
        this.textCodigoContaCorrente.setText(this.pagamentoAlteracao.getContaCorrente() == null ? "" : Integer.toString(this.pagamentoAlteracao.getContaCorrente().getReduzido()));
        this.textDescricaoContaCorrente.setText(this.pagamentoAlteracao.getContaCorrente() == null ? "" : this.pagamentoAlteracao.getContaCorrente().getConta());
        this.textCodigoHistorico.setText(this.pagamentoAlteracao.getHistoricoPadrao() == null ? "" : Integer.toString(this.pagamentoAlteracao.getHistoricoPadrao().getCodigo()));
        this.textDescricaoHistorico.setText(this.pagamentoAlteracao.getHistoricoPadrao() == null ? "" : this.pagamentoAlteracao.getHistoricoPadrao().getDescricao());
        this.textValor.setText(Funcoes.formataDecimal(this.textValor.getMaskDecimal(), this.pagamentoAlteracao.getHistoricoPadrao() == null ? 0.0 : this.pagamentoAlteracao.getValor()));
        this.textDescricaoHistoricoUsuario.setText(this.pagamentoAlteracao.getHistoricoPadrao() == null ? "" : this.pagamentoAlteracao.getDescricaoHistorico());
        String tipo = this.pagamentoAlteracao.getTipoPagamento();
        if (tipo != null) {
            if (tipo.equalsIgnoreCase("D")) {
                this.comboTipoPagamento.setSelectedItem(Tipos.tipoPagamento("D"));
            } else if (tipo.equalsIgnoreCase("H")) {
                this.comboTipoPagamento.setSelectedItem(Tipos.tipoPagamento("H"));
            } else if (tipo.equalsIgnoreCase("I")) {
                this.comboTipoPagamento.setSelectedItem(Tipos.tipoPagamento("I"));
            } else if (tipo.equalsIgnoreCase("O")) {
                this.comboTipoPagamento.setSelectedItem(Tipos.tipoPagamento("O"));
            } else if (tipo.equalsIgnoreCase("P")) {
                this.comboTipoPagamento.setSelectedItem(Tipos.tipoPagamento("P"));
            } else if (tipo.equalsIgnoreCase("A")) {
                this.comboTipoPagamento.setSelectedItem(Tipos.tipoPagamento("A"));
            } else if (tipo.equalsIgnoreCase("T")) {
                this.comboTipoPagamento.setSelectedItem(Tipos.tipoPagamento("T"));
            } else if (tipo.equalsIgnoreCase("B")) {
                this.comboTipoPagamento.setSelectedItem(Tipos.tipoPagamento("B"));
            } else if (tipo.equalsIgnoreCase("E")) {
                this.comboTipoPagamento.setSelectedItem(Tipos.tipoPagamento("E"));
            } else if (tipo.equalsIgnoreCase("Z")) {
                this.comboTipoPagamento.setSelectedItem(Tipos.tipoPagamento("Z"));
            } else if (tipo.equalsIgnoreCase("U")) {
                this.comboTipoPagamento.setSelectedItem(Tipos.tipoPagamento("U"));
            } else if (tipo.equalsIgnoreCase("N")) {
                this.comboTipoPagamento.setSelectedItem(Tipos.tipoPagamento("N"));
            } else if (tipo.equalsIgnoreCase("Y")) {
                this.comboTipoPagamento.setSelectedItem(Tipos.tipoPagamento("Y"));
            }
        }
        this.controlaCampos();
    }

    private void imprimir(BaixaBean bean) {
        if (bean != null) {
            Statement st1 = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            Dimension d = new Dimension(600, 400);
            JDialog relatorio = new RelatorioAutorizacaoDebito().gerarRelatorio(Laboratorio.getInstancia(), d, st1, st2, Variaveis.filialPadrao, Integer.toString(bean.getCodigo()));
            relatorio.setVisible(true);
        }
    }

    private void abrirPopupPagamento() {
        if (this.tableFormasPagamento.getSelectedRowCount() > 0) {
            int x = this.tableFormasPagamento.getX() + this.tableFormasPagamento.getWidth() / 2;
            int y = this.tableFormasPagamento.getY() + this.tableFormasPagamento.getSelectedRow() * 18;
            if (!this.bloqueiaAlteracoes) {
                this.menuPagamento.show(this.tableFormasPagamento, x, y);
            }
        }
    }

    private void abrirPopupTitulo() {
        if (this.tableTitulos.getSelectedRowCount() > 0) {
            int x = this.tableTitulos.getWidth() / 2 - this.menuTitulo.getWidth() / 2;
            int y = this.tableTitulos.getSelectedRow() * this.tableTitulos.getRowHeight() + this.tableTitulos.getRowHeight() / 2;
            if (!this.bloqueiaAlteracoes) {
                this.menuTitulo.show(this.tableTitulos, x, y);
            }
        }
    }

    private void parcelarTitulo() {
        int row = this.tableTitulos.getSelectedRow();
        ReceberPagarBean bean = (ReceberPagarBean)this.modelTitulos.getValueAt(row, 6);
        bean.setSituacao("A");
        JDialog diag = new JDialog((Frame)Laboratorio.getInstancia(), true);
        final ParcelamentoReceberPagar parcelamento = new ParcelamentoReceberPagar(bean, diag);
        diag.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
                parcelamento.focalizarData();
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        });
        diag.setContentPane(parcelamento);
        diag.setSize(new Dimension(700, 500));
        diag.setResizable(false);
        diag.setDefaultCloseOperation(0);
        diag.setTitle("Parcelar t\u00edtulo");
        ScreenUtil.centralizar(diag);
        diag.setVisible(true);
        if (parcelamento.isOk()) {
            ArrayList<ReceberPagarBean> parcelas = parcelamento.getParcelas();
            EscolhaParcela escolherParcela = new EscolhaParcela(parcelas);
            escolherParcela.setVisible(true);
            ReceberPagarBean parcela = escolherParcela.getParcelaSelecionada();
            if (parcela != null) {
                parcela.setSituacao("Q");
                this.modelTitulos.setValueAt(parcela, row, 6);
                this.atualizarTitulos();
                this.atualizarResumo();
            }
        } else {
            bean.setSituacao("Q");
        }
    }

    private void alterarPlanoTitulo() {
        if (Funcoes.verificaData(this.labelDataBaixa.getText())) {
            this.pnlPlanoCustoTitulo.setDataBaixa(Funcoes.getData("dd/MM/yyyy", this.labelDataBaixa.getText()));
        }
        if (this.comboTipoRecPag.getSelectedItem().equals(Tipos.tipoReceberPagar("R"))) {
            this.pnlPlanoCustoTitulo.setTipoDebitoCredito("C");
        } else {
            this.pnlPlanoCustoTitulo.setTipoDebitoCredito("D");
        }
        this.pnlPlanoCustoTitulo.controlaCampos(true);
        this.pnlPlanoCustoTitulo.setSomenteLeitura(false);
        int row = this.tableTitulos.getSelectedRow();
        ReceberPagarBean bean = (ReceberPagarBean)this.modelTitulos.getValueAt(row, 6);
        ReceberPagarBean b = (ReceberPagarBean)bean.clonar();
        this.pnlPlanoCustoTitulo.limparCampos();
        this.pnlPlanoCustoTitulo.setBean(b);
        this.pnlPlanoCustoTitulo.setPlanoContas(b.getPlanosContas());
        this.pnlPlanoCustoTitulo.atualizar(b);
        if (b.getTipo().equalsIgnoreCase("R")) {
            this.pnlPlanoCustoTitulo.setTipoDebitoCredito("C");
        } else {
            this.pnlPlanoCustoTitulo.setTipoDebitoCredito("D");
        }
        TelaPlanoCusto tela = new TelaPlanoCusto(Laboratorio.getInstancia(), b, this.pnlPlanoCustoTitulo);
        tela.setVisible(true);
        if (tela.getOK()) {
            bean.setPlanosContas(new HashSet<AbstractThreadBean>(this.pnlPlanoCustoTitulo.getPlanoContas()));
            bean.setCentrosCusto(new HashSet<AbstractThreadBean>(this.pnlPlanoCustoTitulo.getCentrosCusto()));
        }
        FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)bean);
        this.tableTitulos.revalidate();
        this.tableTitulos.repaint();
    }

    private void alterarPlanoPagamento() {
        if (this.comboTipoRecPag.getSelectedItem().equals(Tipos.tipoReceberPagar("R"))) {
            this.pnlPlanoCustoTitulo.setTipoDebitoCredito("C");
        } else {
            this.pnlPlanoCustoTitulo.setTipoDebitoCredito("D");
        }
        this.pnlPlanoCustoTitulo.controlaCampos(false);
        this.pnlPlanoCustoTitulo.setSomenteLeitura(true);
        int pagamentoSelecionado = this.tableFormasPagamento.getSelectedRow();
        LancamentoBean bean = (LancamentoBean)this.modelFormasPagamento.getValueAt(pagamentoSelecionado < 0 ? 0 : pagamentoSelecionado, 4);
        LancamentoBean lanctoSelecionado = null;
        ArrayList<ReceberPagarBean> titulos = new ArrayList<ReceberPagarBean>();
        for (int i = 0; i < this.modelTitulos.getRowCount(); ++i) {
            titulos.add((ReceberPagarBean)this.modelTitulos.getValueAt(i, 6));
        }
        ArrayList<LancamentoBean> lancamentos = new ArrayList<LancamentoBean>();
        for (int i = 0; i < this.modelFormasPagamento.getRowCount(); ++i) {
            LancamentoBean lancto = (LancamentoBean)this.modelFormasPagamento.getValueAt(i, 4);
            LancamentoBean clone = (LancamentoBean)lancto.clonar();
            lancamentos.add(clone);
            if (lancto != bean) continue;
            lanctoSelecionado = clone;
        }
        AlterarPlanoCustoPagamentos tela = new AlterarPlanoCustoPagamentos(Laboratorio.getInstancia(), titulos, lancamentos, lanctoSelecionado);
        tela.setVisible(true);
        if (tela.getOK()) {
            this.limparFormasPagamento();
            ArrayList<LancamentoBean> listaLancamentos = tela.getLancamentos();
            for (int i = 0; i < listaLancamentos.size(); ++i) {
                LancamentoBean lancto = listaLancamentos.get(i);
                FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)lancto);
                this.adicionarFormasPagamento(lancto);
            }
            this.atualizarFormasPagamento();
        }
        this.tableFormasPagamento.revalidate();
        this.tableFormasPagamento.repaint();
    }

    @Override
    public AbstractThreadBean buscaBeanPreenchido(PanelPlanoContaCentroCusto source) {
        if (source == this.pnlPlanoCustoPagamento) {
            if (this.tableFormasPagamento.getSelectedRowCount() > 0) {
                int row = this.tableFormasPagamento.getSelectedRow();
                LancamentoBean bean = (LancamentoBean)this.modelFormasPagamento.getValueAt(row, 4);
                LancamentoBean b = (LancamentoBean)bean.clonar();
                return b;
            }
        } else if (source == this.pnlPlanoCustoTitulo && this.tableTitulos.getSelectedRowCount() > 0) {
            ReceberPagarBean bean = (ReceberPagarBean)this.modelTitulos.getValueAt(this.tableTitulos.getSelectedRow(), 6);
            ReceberPagarBean b = (ReceberPagarBean)bean.clonar();
            return b;
        }
        return null;
    }

    private void buscaContaCorrente(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoContaCorrente.setText("");
            this.textDescricaoContaCorrente.setText("");
            return;
        }
        try {
            ContaCorrenteVO conta = (ContaCorrenteVO)this.contaCorrenteService.getVO(Variaveis.filialPadrao, codigo);
            if (conta != null) {
                this.textCodigoContaCorrente.setText(conta.getReduzido().toString());
                this.textDescricaoContaCorrente.setText(conta.getConta());
            } else {
                this.textDescricaoContaCorrente.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Lancamento:686");
        }
    }

    private void buscaContaCorrente() {
        try {
            this.textCodigoContaCorrente.setText("");
            this.textDescricaoContaCorrente.setText("");
            ContaCorrenteVO conta = (ContaCorrenteVO)this.contaCorrenteService.pesquisaVO(this.getTopLevelAncestor(), new ContaCorrenteVO(), "Pesquisando contas correntes", true);
            if (conta != null) {
                this.textCodigoContaCorrente.setText(conta.getReduzido().toString());
                this.textDescricaoContaCorrente.setText(conta.getConta());
            } else {
                this.textDescricaoContaCorrente.setText("N\u00e3o cadastrado");
            }
            if (this.textCodigoContaCorrente.isFocusable()) {
                this.textCodigoContaCorrente.grabFocus();
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Lancamento:701");
        }
    }

    private void buscaHistorico(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoHistorico.setText("");
            this.textDescricaoHistorico.setText("");
            return;
        }
        try {
            HistoricoPadraoVO historico = (HistoricoPadraoVO)this.historicoService.getVO(Variaveis.filialPadrao, codigo);
            if (historico != null) {
                this.textCodigoHistorico.setText(historico.getCodigo().toString());
                this.textDescricaoHistorico.setText(historico.getDescricao());
            } else {
                this.textDescricaoHistorico.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Baixa:1783");
        }
    }

    private void buscaHistorico() {
        try {
            this.textCodigoHistorico.setText("");
            this.textDescricaoHistorico.setText("");
            HistoricoPadraoVO historico = (HistoricoPadraoVO)this.historicoService.pesquisaVO(this.getTopLevelAncestor(), new HistoricoPadraoVO(), "Pesquisando hist\u00f3ricos", true);
            if (historico != null) {
                this.textCodigoHistorico.setText(historico.getCodigo().toString());
                this.textDescricaoHistorico.setText(historico.getDescricao());
            } else {
                this.textDescricaoHistorico.setText("N\u00e3o cadastrado");
            }
            if (this.textCodigoHistorico.isFocusable()) {
                this.textCodigoHistorico.grabFocus();
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Baixa:1802");
        }
    }

    private Double getSomatorioTitulos() {
        BigDecimal aux = new BigDecimal("0");
        if (this.modelTitulos.getRowCount() > 0) {
            for (int i = 0; i < this.modelTitulos.getRowCount(); ++i) {
                ReceberPagarBean recPag = (ReceberPagarBean)this.modelTitulos.getValueAt(i, 6);
                if (recPag == null) continue;
                aux = aux.add(new BigDecimal(String.valueOf(recPag.getValorTotal())));
            }
        }
        return aux.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()).doubleValue();
    }

    private Double getSomatorioBaixas() {
        BigDecimal aux = new BigDecimal("0");
        if (this.modelFormasPagamento.getRowCount() > 0) {
            for (int i = 0; i < this.modelFormasPagamento.getRowCount(); ++i) {
                LancamentoBean lancto = (LancamentoBean)this.modelFormasPagamento.getValueAt(i, 4);
                if (lancto == null) continue;
                aux = aux.add(new BigDecimal(String.valueOf(lancto.getValor())));
            }
        }
        return aux.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()).doubleValue();
    }

    public void setBloqueiaAlteracoes(boolean bloqueiaAlteracoes) {
        this.bloqueiaAlteracoes = bloqueiaAlteracoes;
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.executandoOperacoes = true;
        this.controlaCampos();
        this.repaint();
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.executandoOperacoes = false;
        this.controlaCampos();
        this.repaint();
    }

    protected void inserirAcaoDeTecla(String key_stroke, String action_name, AbstractAction action) {
        this.getInputMap(0).put(KeyStroke.getKeyStroke(key_stroke), action_name);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(key_stroke), action_name);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(key_stroke), action_name);
        this.getActionMap().put(action_name, action);
    }

    class DialogoFiltroBaixa
    extends JDialog
    implements ActionListener {
        private static final String SELECIONADO = "selecionado";
        private JButton buttonConsultar;
        private JButton buttonDesmarcarTodos;
        private JButton buttonMarcarTodos;
        private JButton buttonOK;
        private JButton buttonCancelar;
        private JButton buttonDataVctoIni;
        private JButton buttonDataVctoFin;
        private JButton buttonNovo;
        private TTextField textDataVctoIni;
        private TTextField textDataVctoFin;
        private TTextField textValorIni;
        private TTextField textValorFin;
        private TTextField textNumeroDoc;
        private TTextField textNumeroNotaFiscal;
        private String tipoRecPag;
        private final int COLUNA_CODIGO = 0;
        private final int COLUNA_COD_CADASTRO = 1;
        private final int COLUNA_DESC_CADASTRO = 2;
        private final int COLUNA_DOCUMENTO = 3;
        private final int COLUNA_NUMERO_NF = 4;
        private final int COLUNA_VENCIMENTO = 5;
        private final int COLUNA_TOTAL = 6;
        private final int COLUNA_SEL = 7;
        private ModeloGridTable modTit;
        private CheckItemFiltro itemPaciente;
        private CheckItemFiltro itemEntidade;
        private CheckItemFiltro itemConvenio;
        private boolean ok;

        public DialogoFiltroBaixa(Frame pai, String tipoReceberPagar) {
            super(pai, "Pesquisando Receber/Pagar", true);
            this.buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'n', this);
            this.buttonDesmarcarTodos = ComponenteFactory.novoJButton("Desmarcar Todos", 'D', this);
            this.buttonMarcarTodos = ComponenteFactory.novoJButton("Selecionar Todos", 'S', this);
            this.buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
            this.buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
            this.buttonDataVctoIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
            this.buttonDataVctoFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
            this.buttonNovo = ComponenteFactory.novoJButton("Novo", 'v', this);
            this.textDataVctoIni = new TTextField(0, 4);
            this.textDataVctoFin = new TTextField(0, 4);
            this.textValorIni = new TTextField(10, 2, 2);
            this.textValorFin = new TTextField(10, 2, 2);
            this.textNumeroDoc = new TTextField(40, 3);
            this.textNumeroNotaFiscal = new TTextField(10, 1);
            this.tipoRecPag = "";
            this.COLUNA_CODIGO = 0;
            this.COLUNA_COD_CADASTRO = 1;
            this.COLUNA_DESC_CADASTRO = 2;
            this.COLUNA_DOCUMENTO = 3;
            this.COLUNA_NUMERO_NF = 4;
            this.COLUNA_VENCIMENTO = 5;
            this.COLUNA_TOTAL = 6;
            this.COLUNA_SEL = 7;
            this.modTit = new ModeloGridTable(new String[]{"C\u00f3digo", "C\u00f3d. Cad.", "Cadastro", "N\u00fam. Doc.", "N\u00fam. NF", "Vencimento", "Valor Total", "Sel"}){

                @Override
                public boolean isCellEditable(int row, int col) {
                    return col == 7;
                }

                public Class getColumnClass(int c) {
                    if (c == 7) {
                        return Boolean.class;
                    }
                    return super.getColumnClass(c);
                }
            };
            this.tipoRecPag = tipoReceberPagar;
            this.iniciar();
        }

        public DialogoFiltroBaixa(Dialog pai, String tipoReceberPagar) {
            super(pai, "Pesquisando Receber/Pagar", true);
            this.buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'n', this);
            this.buttonDesmarcarTodos = ComponenteFactory.novoJButton("Desmarcar Todos", 'D', this);
            this.buttonMarcarTodos = ComponenteFactory.novoJButton("Selecionar Todos", 'S', this);
            this.buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
            this.buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
            this.buttonDataVctoIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
            this.buttonDataVctoFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
            this.buttonNovo = ComponenteFactory.novoJButton("Novo", 'v', this);
            this.textDataVctoIni = new TTextField(0, 4);
            this.textDataVctoFin = new TTextField(0, 4);
            this.textValorIni = new TTextField(10, 2, 2);
            this.textValorFin = new TTextField(10, 2, 2);
            this.textNumeroDoc = new TTextField(40, 3);
            this.textNumeroNotaFiscal = new TTextField(10, 1);
            this.tipoRecPag = "";
            this.COLUNA_CODIGO = 0;
            this.COLUNA_COD_CADASTRO = 1;
            this.COLUNA_DESC_CADASTRO = 2;
            this.COLUNA_DOCUMENTO = 3;
            this.COLUNA_NUMERO_NF = 4;
            this.COLUNA_VENCIMENTO = 5;
            this.COLUNA_TOTAL = 6;
            this.COLUNA_SEL = 7;
            this.modTit = new /* invalid duplicate definition of identical inner class */;
            this.tipoRecPag = tipoReceberPagar;
            this.iniciar();
        }

        public boolean getOk() {
            return this.ok;
        }

        public List<HashMap<String, Object>> getTitulosAbertosSelecionados() {
            ArrayList<HashMap<String, Object>> sel = new ArrayList<HashMap<String, Object>>();
            for (int i = 0; i < this.modTit.getRowCount(); ++i) {
                HashMap<String, Object> hash = this.modTit.getLine(i);
                if (!hash.get("Sel").equals(true)) continue;
                sel.add(hash);
            }
            return sel;
        }

        private String getTipoReceberPagar() {
            return this.tipoRecPag;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o == this.buttonOK || o == this.buttonCancelar) {
                this.ok = o == this.buttonOK;
                this.dispose();
            } else if (o == this.buttonMarcarTodos || o == this.buttonDesmarcarTodos) {
                boolean marcar = o == this.buttonMarcarTodos;
                for (int i = 0; i < this.modTit.getRowCount(); ++i) {
                    this.modTit.setValueAt(marcar, i, 7);
                }
                this.modTit.fireTableDataChanged();
            } else if (o == this.buttonNovo) {
                ReceberPagarBean recPag = ReceberPagar.novaInstanciaDialog(Laboratorio.getInstancia(), null, "Novo T\u00edtulo", true, 4);
                if (recPag != null) {
                    try {
                        new ReceberPagarService().gravaAutoCopiaSemCommit(recPag, 0, Variaveis.filialPadrao, Baixa.this.getCopiaFiliais());
                        Conexao.arquivaSQL();
                    }
                    catch (Exception e1) {
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel salvar novo t\u00edtulo. - Baixa:DialogoFiltroBaixa", 2);
                    }
                }
            } else if (o == this.buttonDataVctoIni) {
                Funcoes.mostraData(this.textDataVctoIni, this.buttonDataVctoIni, (JPanel)this.buttonDataVctoIni.getParent(), true);
            } else if (o == this.buttonDataVctoFin) {
                Funcoes.mostraData(this.textDataVctoFin, this.buttonDataVctoFin, (JPanel)this.buttonDataVctoFin.getParent(), true);
            } else if (o == this.buttonConsultar) {
                this.consultarTitulosAberto(this.getTipoReceberPagar());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void consultarTitulosAberto(String tipoReceberPagar) {
            Statement st = Conexao.getStatement();
            if (st != null) {
                try {
                    this.buttonConsultar.setEnabled(false);
                    this.modTit.clear();
                    ResultSet res = Conexao.executeQuery(st, this.getSelect(tipoReceberPagar));
                    while (res.next()) {
                        Object[] obj = new Object[]{res.getInt("rpg_codigo"), res.getInt("cod_pessoa"), res.getString("razao_social"), res.getString("rpg_numerodocumento"), res.getString("nfi_numero"), Funcoes.formataData("dd/MM/yyyy", res.getDate("rpg_vencimento")), Funcoes.formataDecimal(res.getDouble("rpg_valortotal")), new Boolean(false)};
                        this.modTit.addLine(obj);
                    }
                    this.modTit.fireTableDataChanged();
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                }
                finally {
                    this.buttonConsultar.setEnabled(true);
                }
            }
        }

        private String getSelect(String tipoReceberPagar) {
            StringBuilder buf = new StringBuilder();
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            try {
                buf.append(" select rpg.rpg_codigo \n");
                buf.append("       ,cad.cod_pessoa \n");
                buf.append("       ,cad.razao_social \n");
                buf.append("       ,rpg.rpg_numerodocumento \n");
                buf.append("       ,nfi.nfi_numero \n");
                buf.append("       ,rpg.rpg_vencimento \n");
                buf.append("       ,rpg.rpg_valortotal \n");
                buf.append("  \t\t ,false as ").append(SELECIONADO).append(" \n");
                buf.append("   from receberpagar rpg \n");
                buf.append("   left join notafiscal nfi on rpg.fil_codigo = nfi.fil_codigo and rpg.nfi_codigo = nfi.nfi_codigo \n");
                buf.append("   left join (select case when rpg.rpg_tipocadastro = upper('").append("P").append("') then pac.pac_nome \n");
                buf.append("                       when rpg.rpg_tipocadastro = upper('").append("O").append("') then con.con_fantasia  \n");
                buf.append("                       else ent.ent_fantasia end as razao_social \n");
                buf.append("                    ,case when upper(rpg.rpg_tipocadastro) = upper('").append("P").append("') then pac.pac_codigo \n");
                buf.append("                       when upper(rpg.rpg_tipocadastro) = upper('").append("O").append("') then con.con_codigo \n");
                buf.append("                       else ent.ent_codigo end as cod_pessoa \n");
                buf.append("                    ,rpg.rpg_codigo \n");
                buf.append("                    ,rpg.fil_codigo \n");
                buf.append("               from receberpagar rpg \n");
                buf.append("               left join entidade ent on rpg.fil_codigo = ent.fil_codigo and rpg.ent_codigo = ent.ent_codigo \n");
                buf.append("               left join paciente pac on rpg.fil_codigo = pac.fil_codigo and rpg.pac_codigo = pac.pac_codigo \n");
                buf.append("               left join convenios con on rpg.fil_codigo = con.fil_codigo and rpg.con_codigo = con.con_codigo \n");
                buf.append("             ) cad on (rpg.fil_codigo = cad.fil_codigo and rpg.rpg_codigo = cad.rpg_codigo) \n");
                buf.append("  where \n");
                buf.append("        rpg.fil_codigo = ").append(Variaveis.filialPadrao).append(" ");
                buf.append("    and rpg.rpg_tipo = '").append(tipoReceberPagar).append("' ");
                buf.append("    and rpg.rpg_situacao = 'A' ");
                if (Funcoes.verificaData(this.textDataVctoIni.getText())) {
                    buf.append("and \n  rpg.rpg_vencimento >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", sdf.parse(this.textDataVctoIni.getText()))).append("' ");
                }
                if (Funcoes.verificaData(this.textDataVctoFin.getText())) {
                    buf.append("and \n  rpg.rpg_vencimento <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", sdf.parse(this.textDataVctoFin.getText()))).append("' ");
                }
                if (!Funcoes.textoVazio(this.textNumeroDoc)) {
                    buf.append(" and rpg_numerodocumento ilike '%").append(this.textNumeroDoc.getText()).append("%' ");
                }
                if (!Funcoes.textoVazio(this.textValorIni)) {
                    buf.append(" and rpg_valortotal >= ").append(Funcoes.limpaDecimal(this.textValorIni.getText()));
                }
                if (!Funcoes.textoVazio(this.textValorFin)) {
                    buf.append(" and rpg_valortotal <= ").append(Funcoes.limpaDecimal(this.textValorFin.getText()));
                }
                if (!Funcoes.textoVazio(this.textNumeroNotaFiscal)) {
                    buf.append(" and nfi.nfi_numero = ").append(this.textNumeroNotaFiscal.getText());
                }
                StringBuilder bufWhere = new StringBuilder();
                String aux = this.getSelecionadosFiltro(this.itemPaciente, 0);
                if (aux != null) {
                    bufWhere.append(" (cad.cod_pessoa IN (").append(aux).append(") and rpg_tipocadastro = 'P') ");
                }
                if ((aux = this.getSelecionadosFiltro(this.itemEntidade, 0)) != null) {
                    if (bufWhere.length() > 0) {
                        bufWhere.append(" or ");
                    }
                    bufWhere.append(" (cad.cod_pessoa IN (").append(aux).append(") and rpg_tipocadastro NOT IN ('P', 'O')) ");
                }
                if ((aux = this.getSelecionadosFiltro(this.itemConvenio, 0)) != null) {
                    if (bufWhere.length() > 0) {
                        bufWhere.append(" or ");
                    }
                    bufWhere.append(" (cad.cod_pessoa IN (").append(aux).append(") and rpg_tipocadastro = 'O') ");
                }
                if (bufWhere.toString().length() > 0) {
                    buf.append(" and ( ");
                    buf.append(bufWhere.toString());
                    buf.append(" ) ");
                }
                buf.append("  order by rpg.rpg_codigo ");
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DialogoFiltro: 3353");
            }
            return buf.toString();
        }

        private String getSelecionadosFiltro(CheckItemFiltro itemFiltro, int coluna) {
            if (itemFiltro == null || coluna < 0) {
                return null;
            }
            String[] aux = itemFiltro.getSelecionados(coluna);
            StringBuilder result = new StringBuilder();
            if (aux == null || aux.length == 0) {
                return null;
            }
            for (int i = 0; i < aux.length; ++i) {
                result.append(aux[i]);
                if (i >= aux.length - 1) continue;
                result.append(",");
            }
            return result.toString();
        }

        private void iniciar() {
            this.getContentPane().setLayout(new GridBagLayout());
            JPanel panelBotoes = new JPanel(new BorderLayout());
            if (Acesso.getAcesso(Baixa.this.moduloNovoTitulo)) {
                panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, this.buttonNovo, this.buttonMarcarTodos, this.buttonDesmarcarTodos), "West");
            } else {
                panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, this.buttonMarcarTodos, this.buttonDesmarcarTodos), "West");
            }
            panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonOK, this.buttonCancelar), "East");
            JPanel panelTabela = new JPanel(new BorderLayout());
            panelTabela.setBorder(BorderFactory.createTitledBorder("T\u00edtulos em aberto"));
            JTable table = new JTable(this.modTit);
            this.modTit.setColumnSize(new int[]{60, 80, 0, 85, 85, 90, 85, 20}, table);
            table.getTableHeader().addMouseListener(this.modTit);
            table.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int row;
                    int[] colunas = ((JTable)e.getSource()).getSelectedColumns();
                    boolean colunaSelecionada = false;
                    for (int i = 0; i < colunas.length; ++i) {
                        if (colunas[i] != ((JTable)e.getSource()).getColumnCount() - 1) continue;
                        colunaSelecionada = true;
                        break;
                    }
                    if (e.getKeyCode() == 32 && !colunaSelecionada && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0) {
                        Boolean valor = (Boolean)DialogoFiltroBaixa.this.modTit.getValueAt(row, 7);
                        DialogoFiltroBaixa.this.modTit.setValueAt(valor == false, row, 7);
                    }
                }
            });
            JScrollPane scroll = new JScrollPane(table);
            scroll.setPreferredSize(new Dimension(600, 200));
            panelTabela.add((Component)scroll, "Center");
            JPanel panelFiltros = new JPanel(new GridBagLayout());
            panelFiltros.setBorder(BorderFactory.createTitledBorder("Filtros"));
            this.itemPaciente = new CheckItemFiltro("Paciente", "Filtrar", "Filtrando pacientes", "fil_codigo = " + Variaveis.filialPadrao);
            this.itemPaciente.setDados("paciente", new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome Paciente"}, new int[]{70, 0});
            this.itemPaciente.setColunaHint(1);
            Dimension d = new Dimension(100, 20);
            this.itemPaciente.setPreferredSize(d);
            this.itemPaciente.setMinimumSize(d);
            d = new Dimension(90, 20);
            this.textDataVctoIni.setPreferredSize(d);
            this.textDataVctoIni.setMinimumSize(d);
            this.buttonDataVctoIni.setFocusable(false);
            this.itemEntidade = new CheckItemFiltro("Entidade", "Filtrar", "Filtrando entidades", "fil_codigo = " + Variaveis.filialPadrao);
            this.itemEntidade.setDados("entidade", new String[]{"ent_codigo", "ent_fantasia"}, new String[]{"C\u00f3digo", "Fantasia Cadastro"}, new int[]{70, 0});
            this.itemEntidade.setColunaHint(1);
            d = new Dimension(100, 20);
            this.itemEntidade.setPreferredSize(d);
            this.itemEntidade.setMinimumSize(d);
            this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
            this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia Conv\u00eanio"}, new int[]{70, 0});
            this.itemConvenio.setColunaHint(1);
            d = new Dimension(100, 20);
            this.itemConvenio.setPreferredSize(d);
            this.itemConvenio.setMinimumSize(d);
            this.textDataVctoFin.setPreferredSize(new Dimension(90, 20));
            this.buttonDataVctoFin.setFocusable(false);
            d = new Dimension(90, 20);
            this.textNumeroDoc.setPreferredSize(d);
            this.textNumeroDoc.setMinimumSize(d);
            this.textNumeroNotaFiscal.setPreferredSize(d);
            this.textNumeroNotaFiscal.setMinimumSize(d);
            this.textValorIni.setPreferredSize(d);
            this.textValorIni.setMinimumSize(d);
            this.textValorFin.setPreferredSize(d);
            this.textValorFin.setMinimumSize(d);
            this.buttonConsultar.setPreferredSize(d);
            this.buttonConsultar.setMinimumSize(d);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(1, 1, 1, 0);
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.anchor = 17;
            c.gridwidth = 2;
            c.gridheight = 1;
            c.fill = 2;
            panelFiltros.add((Component)this.itemPaciente, c);
            c.gridx += 3;
            c.insets = new Insets(1, 20, 1, 0);
            panelFiltros.add((Component)this.itemEntidade, c);
            ++c.gridy;
            c.gridx = 0;
            c.insets = new Insets(1, 1, 1, 0);
            panelFiltros.add((Component)this.itemConvenio, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 1;
            c.fill = 0;
            c.insets = new Insets(1, 1, 1, 0);
            panelFiltros.add((Component)new JLabel("Dt. Vencto. Inicial:"), c);
            ++c.gridx;
            panelFiltros.add((Component)this.textDataVctoIni, c);
            ++c.gridx;
            panelFiltros.add((Component)this.buttonDataVctoIni, c);
            ++c.gridx;
            c.insets = new Insets(1, 20, 1, 0);
            panelFiltros.add((Component)new JLabel("Dt. Vencto. Final:"), c);
            ++c.gridx;
            c.insets = new Insets(1, 1, 1, 0);
            panelFiltros.add((Component)this.textDataVctoFin, c);
            ++c.gridx;
            panelFiltros.add((Component)this.buttonDataVctoFin, c);
            ++c.gridy;
            c.gridx = 0;
            panelFiltros.add((Component)new JLabel("Vl. Total Inicial:"), c);
            ++c.gridx;
            panelFiltros.add((Component)this.textValorIni, c);
            c.gridx += 2;
            c.insets = new Insets(1, 20, 1, 0);
            panelFiltros.add((Component)new JLabel("Vl. Total Final:"), c);
            ++c.gridx;
            c.insets = new Insets(1, 1, 1, 0);
            panelFiltros.add((Component)this.textValorFin, c);
            ++c.gridy;
            c.gridx = 0;
            panelFiltros.add((Component)new JLabel("N\u00famero Doc.:"), c);
            ++c.gridx;
            panelFiltros.add((Component)this.textNumeroDoc, c);
            c.gridx += 2;
            c.insets = new Insets(1, 20, 1, 0);
            panelFiltros.add((Component)new JLabel("N\u00famero Nota Fiscal:"), c);
            ++c.gridx;
            c.insets = new Insets(1, 1, 1, 0);
            panelFiltros.add((Component)this.textNumeroNotaFiscal, c);
            c.gridx += 2;
            c.anchor = 13;
            c.weightx = 1.0;
            panelFiltros.add((Component)this.buttonConsultar, c);
            Container panelPrinc = this.getContentPane();
            panelPrinc.setLayout(new GridBagLayout());
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 17;
            c.fill = 2;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.insets = new Insets(1, 1, 1, 0);
            c.weightx = 0.0;
            c.weighty = 0.0;
            panelPrinc.add((Component)panelFiltros, c);
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 1.0;
            c.fill = 1;
            panelPrinc.add((Component)panelTabela, c);
            ++c.gridy;
            panelPrinc.add((Component)panelBotoes, c);
            Funcoes.montaEnter((JComponent)this.getContentPane());
            ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(113, 0, true), "F2", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogoFiltroBaixa.this.textDataVctoIni.hasFocus()) {
                        Funcoes.mostraData(DialogoFiltroBaixa.this.textDataVctoIni, DialogoFiltroBaixa.this.buttonDataVctoIni, (JPanel)DialogoFiltroBaixa.this.buttonDataVctoIni.getParent(), true);
                    } else if (DialogoFiltroBaixa.this.textDataVctoFin.hasFocus()) {
                        Funcoes.mostraData(DialogoFiltroBaixa.this.textDataVctoFin, DialogoFiltroBaixa.this.buttonDataVctoFin, (JPanel)DialogoFiltroBaixa.this.buttonDataVctoFin.getParent(), true);
                    }
                }
            });
            this.pack();
            this.setResizable(false);
            ScreenUtil.centralizar(this);
        }
    }

    private class TelaDatas
    extends AbstractDialogoOKCancelar {
        private JLabel labelDataBaixa;
        private JLabel labelDataCompetencia;
        private TTextField textDataBaixa;
        private TTextField textDataCompetencia;
        private JButton buttonDataBaixa;
        private JButton buttonDataCompetencia;

        public TelaDatas(JFrame owner, Date dataBaixa, Date dataVencimento, Date DataCompetencia) {
            super((Frame)owner, "Datas da Baixa");
            this.labelDataBaixa = new JLabel("Data Baixa:");
            this.labelDataCompetencia = new JLabel("Data Compet\u00eancia:");
            this.textDataBaixa = new TTextField(10, 4);
            this.textDataCompetencia = new TTextField(10, 4);
            this.buttonDataBaixa = new JButton();
            this.buttonDataCompetencia = new JButton();
            this.setModal(true);
            this.setResizable(false);
            JPanel panelPrinc = this.getPanelCentral();
            panelPrinc.setLayout(new GridBagLayout());
            Funcoes.imagemPesquisa(this.buttonDataBaixa);
            this.buttonDataBaixa.setEnabled(Acesso.getAcesso(Baixa.this.moduloDataBaixa));
            this.buttonDataBaixa.setFocusable(false);
            this.buttonDataBaixa.setPreferredSize(new Dimension(20, 20));
            this.buttonDataBaixa.setMinimumSize(new Dimension(20, 20));
            this.buttonDataBaixa.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Funcoes.mostraData(TelaDatas.this.textDataBaixa, TelaDatas.this.buttonDataBaixa, (JPanel)TelaDatas.this.buttonDataBaixa.getParent(), true);
                }
            });
            Funcoes.imagemPesquisa(this.buttonDataCompetencia);
            this.buttonDataCompetencia.setEnabled(Acesso.getAcesso(Baixa.this.moduloDataCompetenciaBaixa));
            this.buttonDataCompetencia.setFocusable(false);
            this.buttonDataCompetencia.setPreferredSize(new Dimension(20, 20));
            this.buttonDataCompetencia.setMinimumSize(new Dimension(20, 20));
            this.buttonDataCompetencia.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Funcoes.mostraData(TelaDatas.this.textDataCompetencia, TelaDatas.this.buttonDataCompetencia, (JPanel)TelaDatas.this.buttonDataCompetencia.getParent(), true);
                }
            });
            this.textDataBaixa.setEnabled(Acesso.getAcesso(Baixa.this.moduloDataBaixa));
            this.textDataBaixa.setPreferredSize(new Dimension(90, 20));
            if (dataBaixa == null) {
                this.textDataBaixa.setText(Funcoes.formataData("dd/MM/yyyy", new Date()));
            } else {
                this.textDataBaixa.setText(Funcoes.formataData("dd/MM/yyyy", dataBaixa));
            }
            this.textDataCompetencia.setEnabled(Acesso.getAcesso(Baixa.this.moduloDataCompetenciaBaixa));
            this.textDataCompetencia.setPreferredSize(new Dimension(90, 20));
            if (Baixa.this.dataCompetencia == null) {
                this.textDataCompetencia.setText(Funcoes.formataData("dd/MM/yyyy", new Date()));
            } else {
                this.textDataCompetencia.setText(Funcoes.formataData("dd/MM/yyyy", Baixa.this.dataCompetencia));
            }
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 0;
            c.anchor = 17;
            c.insets = new Insets(1, 1, 1, 0);
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 0;
            panelPrinc.add((Component)this.labelDataBaixa, c);
            ++c.gridx;
            panelPrinc.add((Component)this.textDataBaixa, c);
            ++c.gridx;
            panelPrinc.add((Component)this.buttonDataBaixa, c);
            c.insets = new Insets(1, 1, 1, 0);
            ++c.gridy;
            c.gridx = 0;
            panelPrinc.add((Component)this.labelDataCompetencia, c);
            ++c.gridx;
            panelPrinc.add((Component)this.textDataCompetencia, c);
            ++c.gridx;
            panelPrinc.add((Component)this.buttonDataCompetencia, c);
            this.setPreferredSize(new Dimension(250, 140));
            this.setMinimumSize(new Dimension(250, 140));
            this.setLocationRelativeTo(Laboratorio.getInstancia());
            Funcoes.montaEnter((JComponent)panelPrinc);
            if (this.textDataBaixa.isFocusable()) {
                this.textDataBaixa.grabFocus();
            }
            this.setVisible(true);
        }

        public Date getDataBaixa() {
            return Funcoes.getData("dd/MM/yyyy", this.textDataBaixa.getText());
        }

        public Date getDataVencimento() {
            return Funcoes.getData("dd/MM/yyyy", this.textDataBaixa.getText());
        }

        public Date getDataCompetencia() {
            return Funcoes.getData("dd/MM/yyyy", this.textDataCompetencia.getText());
        }

        @Override
        protected boolean acaoOk() {
            if (!Funcoes.verificaData(this.textDataBaixa.getText())) {
                Funcoes.mensagem(this, "Data Baixa inv\u00e1lida. Por favor, informe uma data v\u00e1lida.", 2);
                return false;
            }
            if (!Funcoes.verificaData(this.textDataCompetencia.getText())) {
                Funcoes.mensagem(this, "Data Compet\u00eancia inv\u00e1lida. Por favor, informe uma data v\u00e1lida.", 2);
                return false;
            }
            return true;
        }
    }

    class PagamentoRenderer
    extends DefaultTableCellRenderer {
        @Override
        public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            this.setValue(value);
            if (selected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (row < Baixa.this.modelFormasPagamento.getRowCount() && Baixa.this.modelFormasPagamento.getValueAt(row, 4) != null) {
                LancamentoBean b = (LancamentoBean)Baixa.this.modelFormasPagamento.getValueAt(row, 4);
                if (b.isPlanoContaErrado() && b.isCentroCustoErrado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_CENTROCUSTO_ERRADO);
                } else if (b.isPlanoContaErrado() && b.isPlanoContaNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_NAO_CONFIGURADO);
                } else if (b.isPlanoContaErrado() && !b.isPlanoContaNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_ERRADO);
                } else if (b.isCentroCustoErrado() && b.isCentroCustoNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_CENTROCUSTO_NAO_CONFIGURADO);
                } else if (b.isCentroCustoErrado() && !b.isCentroCustoNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_CENTROCUSTO_ERRADO);
                } else if (b.isPlanoContaNaoConfigurado() && b.isCentroCustoNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_CENTROCUSTO_NAO_CONFIGURADO);
                } else if (b.isPlanoContaNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_NAO_CONFIGURADO);
                } else if (b.isCentroCustoNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_CENTROCUSTO_NAO_CONFIGURADO);
                }
                if (selected && c.getBackground() != table.getSelectionBackground()) {
                    c.setBackground(ScreenUtil.escurecerCor(c.getBackground(), 30));
                }
            }
            if (focused) {
                Border border = selected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.focusCellHighlightBorder");
                ((JComponent)c).setBorder(border);
                if (!selected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        c.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        c.setBackground(col);
                    }
                }
            } else {
                ((JComponent)c).setBorder(noFocusBorder);
            }
            return c;
        }
    }

    class TituloRenderer
    extends DefaultTableCellRenderer {
        @Override
        public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            this.setValue(value);
            if (selected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (row < Baixa.this.modelTitulos.getRowCount() && Baixa.this.modelTitulos.getValueAt(row, 6) != null) {
                ReceberPagarBean b = (ReceberPagarBean)Baixa.this.modelTitulos.getValueAt(row, 6);
                if (b.isPlanoContaErrado() && b.isCentroCustoErrado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_CENTROCUSTO_ERRADO);
                } else if (b.isPlanoContaErrado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_ERRADO);
                } else if (b.isCentroCustoErrado()) {
                    c.setBackground(FinanceiroUtil.COR_CENTROCUSTO_ERRADO);
                } else if (b.isPlanoContaNaoConfigurado() && b.isCentroCustoNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_CENTROCUSTO_NAO_CONFIGURADO);
                } else if (b.isPlanoContaNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_NAO_CONFIGURADO);
                } else if (b.isCentroCustoNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_CENTROCUSTO_NAO_CONFIGURADO);
                }
                if (selected && c.getBackground() != table.getSelectionBackground()) {
                    c.setBackground(ScreenUtil.escurecerCor(c.getBackground(), 30));
                }
            }
            if (focused) {
                Border border = selected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.focusCellHighlightBorder");
                ((JComponent)c).setBorder(border);
                if (!selected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        c.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        c.setBackground(col);
                    }
                }
            } else {
                ((JComponent)c).setBorder(noFocusBorder);
            }
            return c;
        }
    }
}

