/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos;

import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.financeiro.lancamentos.componente.BuscaBeanPreenchido;
import jalis.laboratorio.financeiro.lancamentos.componente.PanelPlanoContaCentroCusto;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.model.bean.financeiro.LancamentoCentroCustoBean;
import jalis.model.bean.financeiro.LancamentoCentroCustoRPBean;
import jalis.model.bean.financeiro.LancamentoPlanoContaBean;
import jalis.model.bean.financeiro.LancamentoPlanoContaRPBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.bean.financeiro.ReceberPagarCentroCustoBean;
import jalis.model.bean.financeiro.ReceberPagarPlanoContaBean;
import jalis.model.vo.financeiro.LancamentoVO;
import jalis.model.vo.financeiro.ReceberPagarVO;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;

public class AlterarPlanoCustoPagamentos
extends AbstractDialogoOKCancelar
implements ActionListener,
ListSelectionListener,
BuscaBeanPreenchido,
ItemListener {
    private JButton buttonCopiarTitulos = new JButton("Copiar dos T\u00edtulos");
    private JButton buttonSugerirTodos = new JButton("Sugerir Todos");
    private JComboBox comboPagamento = new JComboBox();
    private JLabel labelPagamento = new JLabel();
    private JLabel labelTotPlanoContas = new JLabel(Funcoes.formataDecimal(0));
    private JLabel labelTotCentroCusto = new JLabel(Funcoes.formataDecimal(0));
    private JPanel panelPagamento = new JPanel();
    private JPanel panelTitulos = new JPanel();
    private JPanel panelSugerir = new JPanel(new FlowLayout(0));
    private JPanel panelTotalizadores = new JPanel(new FlowLayout(2));
    private ModeloGridTable modelTitulos;
    private JTable tableTitulos;
    private JScrollPane scrollTitulos;
    private final int POSICAO_CODIGO = 0;
    private final int POSICAO_PLANO_CONTAS = 4;
    private final int POSICAO_CENTRO_CUSTO = 5;
    private final int POSICAO_OBJETO = 6;
    private PanelPlanoContaCentroCusto panelPlanoCentro = null;
    private ArrayList<ReceberPagarBean> titulos = null;
    private ArrayList<LancamentoBean> lancamentos = null;
    private ArrayList<LancamentoPlanoContaRPBean> lancamentosPlanoContaRP = null;
    private ArrayList<LancamentoCentroCustoRPBean> lancamentosCentroCustoRP = null;
    BigDecimal somatorioRecPag = BigDecimal.ZERO;
    BigDecimal valorRestante = BigDecimal.ZERO;
    private LancamentoPlanoContaBean lanctoPlano = null;
    private LancamentoCentroCustoBean lanctoCentro = null;
    boolean ok;

    public AlterarPlanoCustoPagamentos(JFrame owner, ArrayList<ReceberPagarBean> titulos, ArrayList<LancamentoBean> lancamentos, LancamentoBean lanctoSelecionado) {
        super((Frame)owner, "Alterar Plano de Contas e Centros de Custo");
        this.panelPlanoCentro = new PanelPlanoContaCentroCusto(this, PanelPlanoContaCentroCusto.TIPO_LANCAMENTO, -1L, -1L, null != lanctoSelecionado.getFilial() ? lanctoSelecionado.getFilial().getCodigo().toString() : Variaveis.filialPadrao);
        this.panelPlanoCentro.addListSelectionListener(this);
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.buttonCopiarTitulos.setMnemonic('T');
        this.buttonCopiarTitulos.addActionListener(this);
        this.buttonSugerirTodos.setMnemonic('d');
        this.buttonSugerirTodos.addActionListener(this);
        this.panelTitulos.setBorder(BorderFactory.createTitledBorder("T\u00edtulos"));
        this.modelTitulos = new ModeloGridTable(new String[]{"C\u00f3digo", "Favorecido", "Vencimento", "Total", "Plano de Contas", "Centro de Custo", "Objeto"}){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Class[] valores = new Class[]{Integer.class, String.class, String.class, String.class, CheckValorPlano.class, CheckValorCentro.class, LancamentoPlanoContaRPBean.class};
                return valores[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                boolean planoSelecionado = AlterarPlanoCustoPagamentos.this.lanctoPlano != null;
                boolean centroSelecionado = AlterarPlanoCustoPagamentos.this.lanctoCentro != null;
                boolean[] valores = new boolean[]{true, false, false, false, planoSelecionado, centroSelecionado, false};
                return valores[columnIndex];
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    AlterarPlanoCustoPagamentos.this.tableTitulos.removeColumn(AlterarPlanoCustoPagamentos.this.tableTitulos.getColumn("Objeto"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (AlterarPlanoCustoPagamentos.this.tableTitulos != null) {
                        AlterarPlanoCustoPagamentos.this.tableTitulos.removeColumn(AlterarPlanoCustoPagamentos.this.tableTitulos.getColumn("Objeto"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.tableTitulos = new JTable(this.modelTitulos);
        this.modelTitulos.setColumnSize(new int[]{60, 0, 90, 90, 115, 115, 0}, this.tableTitulos);
        this.tableTitulos.removeColumn(this.tableTitulos.getColumnModel().getColumn(this.tableTitulos.getColumnCount() - 1));
        this.tableTitulos.getTableHeader().addMouseListener(this.modelTitulos);
        this.tableTitulos.setRowHeight(21);
        CheckValorPlanoRenderer rendererCheckValorPlano = new CheckValorPlanoRenderer();
        CheckValorCentroRenderer rendererCheckValorCentro = new CheckValorCentroRenderer();
        this.tableTitulos.setDefaultRenderer(CheckValorPlano.class, rendererCheckValorPlano);
        this.tableTitulos.setDefaultRenderer(CheckValorCentro.class, rendererCheckValorCentro);
        CheckValorPlanoEditor editorCheckValorPlano = new CheckValorPlanoEditor();
        CheckValorCentroEditor editorCheckValorCentro = new CheckValorCentroEditor();
        this.tableTitulos.setDefaultEditor(CheckValorPlano.class, editorCheckValorPlano);
        this.tableTitulos.setDefaultEditor(CheckValorCentro.class, editorCheckValorCentro);
        this.scrollTitulos = new JScrollPane(this.tableTitulos);
        GridBagConstraints c = null;
        this.panelTotalizadores.add(new JLabel("Total da Conta:"));
        this.labelTotPlanoContas.setHorizontalAlignment(4);
        this.panelTotalizadores.add(this.labelTotPlanoContas);
        this.panelTotalizadores.add(new JLabel("  "));
        this.panelTotalizadores.add(new JLabel("Total do Centro:"));
        this.labelTotCentroCusto.setHorizontalAlignment(4);
        this.panelTotalizadores.add(this.labelTotCentroCusto);
        this.panelTitulos.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 17;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelTitulos.add((Component)this.scrollTitulos, c);
        ++c.gridy;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.panelTitulos.add((Component)this.panelTotalizadores, c);
        ++c.gridy;
        c.fill = 2;
        c.weighty = 0.0;
        this.panelSugerir.add(this.buttonSugerirTodos);
        this.panelTitulos.add((Component)this.panelSugerir, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.fill = 1;
        c.anchor = 17;
        c.weightx = 1.0;
        c.weighty = 0.3;
        c.insets = new Insets(2, 1, 1, 1);
        this.getPanelCentral().add((Component)this.panelPlanoCentro, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.fill = 1;
        c.anchor = 17;
        c.weightx = 1.0;
        c.weighty = 0.7;
        this.getPanelCentral().add((Component)this.panelTitulos, c);
        this.panelPagamento.setLayout(new GridBagLayout());
        this.labelPagamento.setText("Pagamento:");
        this.labelPagamento.setDisplayedMnemonic('P');
        this.labelPagamento.setLabelFor(this.comboPagamento);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.panelPagamento.add((Component)this.labelPagamento, c);
        this.comboPagamento.addItemListener(this);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(1, 1, 1, 1);
        this.panelPagamento.add((Component)this.comboPagamento, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.panelPagamento.add((Component)this.buttonCopiarTitulos, c);
        c = new GridBagConstraints();
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.getPanelCentral().add((Component)this.panelPagamento, c);
        this.setPreferredSize(new Dimension(700, 500));
        this.setMinimumSize(new Dimension(700, 500));
        Funcoes.montaEnter((JComponent)this.getPanelCentral());
        this.setLocationRelativeTo(owner);
        this.limparCampos();
        this.titulos = titulos;
        this.lancamentos = lancamentos;
        this.preencherDados(lanctoSelecionado);
        this.controlarCampos();
    }

    public ArrayList<LancamentoBean> getLancamentos() {
        for (int i = 0; i < this.lancamentos.size(); ++i) {
            LancamentoBean lancto = this.lancamentos.get(i);
            Set lanctoPlano = lancto.getPlanosContas();
            Iterator it = lanctoPlano.iterator();
            while (it.hasNext()) {
                ((LancamentoPlanoContaBean)it.next()).setInserir(true);
            }
            lancto.setPlanosContasRP(new HashSet<LancamentoPlanoContaRPBean>());
            for (int j = 0; j < this.lancamentosPlanoContaRP.size(); ++j) {
                LancamentoPlanoContaRPBean lanctoPlanoRP = this.lancamentosPlanoContaRP.get(j);
                if (lanctoPlanoRP.getLancamento().getCodigo().intValue() != lancto.getCodigo().intValue() || !(lanctoPlanoRP.getValor() > 0.0)) continue;
                lancto.addPlanoContaRP(lanctoPlanoRP);
            }
            Set lanctoCentro = lancto.getCentrosCusto();
            it = lanctoCentro.iterator();
            while (it.hasNext()) {
                ((LancamentoCentroCustoBean)it.next()).setInserir(true);
            }
            lancto.setCentroCustoRP(new HashSet<LancamentoCentroCustoRPBean>());
            for (int j = 0; j < this.lancamentosCentroCustoRP.size(); ++j) {
                LancamentoCentroCustoRPBean lanctoCentroRP = this.lancamentosCentroCustoRP.get(j);
                if (lanctoCentroRP.getLancamento().getCodigo().intValue() != lancto.getCodigo().intValue() || !(lanctoCentroRP.getValor() > 0.0)) continue;
                lancto.addCentroCustoRP(lanctoCentroRP);
            }
            lancto.setCodigo(null);
        }
        return this.lancamentos;
    }

    private void limparCampos() {
        this.comboPagamento.removeAllItems();
        this.modelTitulos.clear();
        this.panelPlanoCentro.limparCampos();
        if (this.titulos != null) {
            this.titulos.clear();
        }
        if (this.lancamentos != null) {
            this.lancamentos.clear();
        }
        this.somatorioRecPag = BigDecimal.ZERO;
        this.valorRestante = BigDecimal.ZERO;
    }

    @Override
    protected boolean acaoOk() {
        int k;
        BigDecimal somatorio;
        ReceberPagarBean tit;
        int iTit;
        Iterator<AbstractThreadBean> it;
        Set<AbstractThreadBean> set;
        int i;
        if (this.tableTitulos.getCellEditor() != null) {
            this.tableTitulos.getCellEditor().stopCellEditing();
        }
        this.itemStateChanged(new ItemEvent(this.comboPagamento, 0, this.comboPagamento.getSelectedItem(), 2));
        LancamentoBean aux = (LancamentoBean)this.comboPagamento.getSelectedItem();
        ArrayList planos = new ArrayList(aux.getPlanosContas());
        for (int i2 = 0; i2 < planos.size(); ++i2) {
            this.planoContasAlterado((LancamentoPlanoContaBean)planos.get(i2));
        }
        ArrayList centros = new ArrayList(aux.getCentrosCusto());
        for (int i3 = 0; i3 < centros.size(); ++i3) {
            this.centroCustoAlterado((LancamentoCentroCustoBean)centros.get(i3));
        }
        this.comboPagamento.setSelectedIndex(0);
        for (i = 0; i < this.lancamentos.size(); ++i) {
            set = this.lancamentos.get(i).getPlanosContasRP();
            it = set.iterator();
            while (it.hasNext()) {
                LancamentoPlanoContaRPBean lanctoPlanoRP = it.next();
                boolean haPlano = false;
                for (LancamentoPlanoContaBean lanctoPlano : this.lancamentos.get(i).getPlanosContas()) {
                    if (lanctoPlano.isRemover() || lanctoPlano.getPlanoConta().getReduzido().intValue() != lanctoPlanoRP.getPlanoConta().getReduzido().intValue()) continue;
                    haPlano = true;
                    break;
                }
                if (haPlano) continue;
                this.lancamentosPlanoContaRP.remove(lanctoPlanoRP);
                it.remove();
            }
        }
        for (i = 0; i < this.lancamentos.size(); ++i) {
            set = this.lancamentos.get(i).getCentrosCustoRP();
            it = set.iterator();
            while (it.hasNext()) {
                LancamentoCentroCustoRPBean lanctoCentroRP = (LancamentoCentroCustoRPBean)it.next();
                boolean haCentro = false;
                for (LancamentoCentroCustoBean lanctoCentro : this.lancamentos.get(i).getCentrosCusto()) {
                    if (lanctoCentro.isRemover() || lanctoCentro.getCentroCusto().getReduzido().intValue() != lanctoCentroRP.getCentroCusto().getReduzido().intValue()) continue;
                    haCentro = true;
                    break;
                }
                if (haCentro) continue;
                this.lancamentosCentroCustoRP.remove(lanctoCentroRP);
                it.remove();
            }
        }
        for (int iLancto = 0; iLancto < this.lancamentos.size(); ++iLancto) {
            LancamentoBean lancto = this.lancamentos.get(iLancto);
            PanelPlanoContaCentroCusto panelAux = new PanelPlanoContaCentroCusto(lancto, PanelPlanoContaCentroCusto.TIPO_LANCAMENTO, 0L, 0L, lancto.getFilial().getCodigo().toString());
            panelAux.atualizar(lancto);
            if (panelAux.validar()) continue;
            Funcoes.mensagem(this, "Os valores dos planos de contas e/ou centros de custo est\u00e3o incorretos.\nPagamento: \"" + lancto + "\".", 2);
            return false;
        }
        for (iTit = 0; iTit < this.titulos.size(); ++iTit) {
            tit = this.titulos.get(iTit);
            somatorio = BigDecimal.ZERO;
            for (k = 0; k < this.lancamentosPlanoContaRP.size(); ++k) {
                LancamentoPlanoContaRPBean lanctoPlanoRP = this.lancamentosPlanoContaRP.get(k);
                if (lanctoPlanoRP.getReceberPagar().getCodigo().intValue() != tit.getCodigo().intValue() || !lanctoPlanoRP.getOrigem().getCodigo().equalsIgnoreCase(tit.getOrigem())) continue;
                somatorio = somatorio.add(new BigDecimal(lanctoPlanoRP.getValor())).setScale(2, RoundingMode.HALF_UP);
            }
            if (somatorio.doubleValue() == new BigDecimal(tit.getValorTotal()).setScale(2, RoundingMode.HALF_UP).doubleValue() || !(somatorio.doubleValue() > 0.0)) continue;
            Funcoes.mensagem(this, "O valor do receber/pagar n\u00e3o coincide com o valor configurado nos Planos de Contas.\nCod. T\u00edt.: " + tit.getCodigo() + " - Valor T\u00edt.: \"" + Funcoes.formataDecimal(tit.getValorTotal()) + "\" - Valor configurado: \"" + Funcoes.formataDecimal(somatorio.setScale(2, RoundingMode.HALF_UP).doubleValue()) + "\".", 2);
            return false;
        }
        for (iTit = 0; iTit < this.titulos.size(); ++iTit) {
            tit = this.titulos.get(iTit);
            somatorio = BigDecimal.ZERO;
            for (k = 0; k < this.lancamentosCentroCustoRP.size(); ++k) {
                LancamentoCentroCustoRPBean lanctoCentroRP = this.lancamentosCentroCustoRP.get(k);
                if (lanctoCentroRP.getReceberPagar().getCodigo().intValue() != tit.getCodigo().intValue() || !lanctoCentroRP.getOrigem().getCodigo().equalsIgnoreCase(tit.getOrigem())) continue;
                somatorio = somatorio.add(new BigDecimal(lanctoCentroRP.getValor())).setScale(2, RoundingMode.HALF_UP);
            }
            if (somatorio.doubleValue() == new BigDecimal(tit.getValorTotal()).setScale(2, RoundingMode.HALF_UP).doubleValue() || !(somatorio.doubleValue() > 0.0)) continue;
            Funcoes.mensagem(this, "O valor do receber/pagar n\u00e3o coincide com o valor configurado nos Centros de Custo.\nCod. T\u00edt.: " + tit.getCodigo() + " - Valor T\u00edt.: \"" + Funcoes.formataDecimal(tit.getValorTotal()) + "\" - Valor configurado: \"" + Funcoes.formataDecimal(somatorio.setScale(2, RoundingMode.HALF_UP).doubleValue()) + "\".", 2);
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.buttonSugerirTodos) {
            Comparable check;
            ReceberPagarBean aux;
            ReceberPagarBean recPag;
            int codigoTitulo;
            int i;
            int i2;
            String[] opcoes = new String[]{"Plano de Contas", "Centro de Custo", "Ambos"};
            int escolha = 2;
            ArrayList<LancamentoPlanoContaBean> listaLanctoPlano = new ArrayList<LancamentoPlanoContaBean>();
            ArrayList<LancamentoCentroCustoBean> listaLanctoCentro = new ArrayList<LancamentoCentroCustoBean>();
            if (this.tableTitulos.getCellEditor() != null) {
                this.tableTitulos.getCellEditor().stopCellEditing();
            }
            this.planoContasAlterado(null);
            this.panelPlanoCentro.limparSelecaoPlanoContas();
            this.centroCustoAlterado(null);
            this.panelPlanoCentro.limparSelecaoCentroCusto();
            ArrayList<AbstractThreadBean> auxListaPlano = this.panelPlanoCentro.getPlanoContas();
            ArrayList<AbstractThreadBean> auxListaCentro = this.panelPlanoCentro.getCentrosCusto();
            for (i2 = 0; i2 < auxListaPlano.size(); ++i2) {
                listaLanctoPlano.add((LancamentoPlanoContaBean)auxListaPlano.get(i2));
            }
            for (i2 = 0; i2 < auxListaCentro.size(); ++i2) {
                listaLanctoCentro.add((LancamentoCentroCustoBean)auxListaCentro.get(i2));
            }
            this.lancamentosPlanoContaRP.clear();
            this.lancamentosCentroCustoRP.clear();
            for (int iPlano = 0; iPlano < listaLanctoPlano.size(); ++iPlano) {
                LancamentoPlanoContaBean lanctoPlano = (LancamentoPlanoContaBean)listaLanctoPlano.get(iPlano);
                if (escolha != 0 && escolha != 2) continue;
                if (lanctoPlano != null && lanctoPlano.getLancamento().getValorTotal().doubleValue() == this.somatorioRecPag.doubleValue()) {
                    for (i = 0; i < this.modelTitulos.getRowCount(); ++i) {
                        codigoTitulo = (Integer)this.modelTitulos.getValueAt(i, 0);
                        recPag = null;
                        for (int j = 0; j < this.titulos.size(); ++j) {
                            aux = this.titulos.get(j);
                            if (aux.getCodigo() != codigoTitulo) continue;
                            recPag = aux;
                            break;
                        }
                        AbstractThreadBean recPagPlano = null;
                        if (recPag.getPlanosContas() != null) {
                            for (AbstractThreadBean aux2 : recPag.getPlanosContas()) {
                                if (((ReceberPagarPlanoContaBean)aux2).getPlanoConta().getReduzido().intValue() != lanctoPlano.getPlanoConta().getReduzido().intValue() || !((ReceberPagarPlanoContaBean)aux2).getOrigem().getCodigo().equalsIgnoreCase(lanctoPlano.getOrigem().getCodigo())) continue;
                                recPagPlano = aux2;
                                break;
                            }
                        }
                        if (recPagPlano == null) continue;
                        LancamentoPlanoContaRPBean lanctoPlanoRP = new LancamentoPlanoContaRPBean();
                        lanctoPlanoRP.setEstacao(lanctoPlano.getEstacao());
                        lanctoPlanoRP.setFilial(lanctoPlano.getFilial());
                        lanctoPlanoRP.setLancamento(lanctoPlano.getLancamento());
                        lanctoPlanoRP.setOrigem(lanctoPlano.getOrigem());
                        lanctoPlanoRP.setPlanoConta(lanctoPlano.getPlanoConta());
                        lanctoPlanoRP.setReceberPagar((ReceberPagarVO)((ReceberPagarBean)this.modelTitulos.getValueAt(i, 6)).toVO());
                        lanctoPlanoRP.setValor(((ReceberPagarPlanoContaBean)recPagPlano).getValor());
                        if (e.getSource() == this.buttonSugerirTodos) {
                            this.lancamentosPlanoContaRP.add(lanctoPlanoRP);
                            continue;
                        }
                        check = new CheckValorPlano(lanctoPlanoRP);
                        this.modelTitulos.setValueAt(check, i, 4);
                    }
                    continue;
                }
                Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel sugerir os valores do Plano de Contas.\nInforme os valores manualmente.", 2);
                break;
            }
            for (int iCentro = 0; iCentro < listaLanctoCentro.size(); ++iCentro) {
                LancamentoCentroCustoBean lanctoCentro = (LancamentoCentroCustoBean)listaLanctoCentro.get(iCentro);
                if (escolha != 1 && escolha != 2) continue;
                if (lanctoCentro != null && lanctoCentro.getLancamento().getValorTotal().doubleValue() == this.somatorioRecPag.doubleValue()) {
                    for (i = 0; i < this.modelTitulos.getRowCount(); ++i) {
                        codigoTitulo = (Integer)this.modelTitulos.getValueAt(i, 0);
                        recPag = null;
                        for (int j = 0; j < this.titulos.size(); ++j) {
                            aux = this.titulos.get(j);
                            if (aux.getCodigo() != codigoTitulo) continue;
                            recPag = aux;
                            break;
                        }
                        AbstractThreadBean recPagCentro = null;
                        if (recPag.getCentrosCusto() != null) {
                            for (AbstractThreadBean aux2 : recPag.getCentrosCusto()) {
                                if (((ReceberPagarCentroCustoBean)aux2).getCentroCusto().getReduzido().intValue() != lanctoCentro.getCentroCusto().getReduzido().intValue() || !((ReceberPagarCentroCustoBean)aux2).getOrigem().getCodigo().equalsIgnoreCase(lanctoCentro.getOrigem().getCodigo())) continue;
                                recPagCentro = aux2;
                                break;
                            }
                        }
                        if (recPagCentro == null) continue;
                        LancamentoCentroCustoRPBean lanctoCentroRP = new LancamentoCentroCustoRPBean();
                        lanctoCentroRP.setEstacao(lanctoCentro.getEstacao());
                        lanctoCentroRP.setFilial(lanctoCentro.getFilial());
                        lanctoCentroRP.setLancamento(lanctoCentro.getLancamento());
                        lanctoCentroRP.setOrigem(lanctoCentro.getOrigem());
                        lanctoCentroRP.setCentroCusto(lanctoCentro.getCentroCusto());
                        lanctoCentroRP.setReceberPagar((ReceberPagarVO)((ReceberPagarBean)this.modelTitulos.getValueAt(i, 6)).toVO());
                        lanctoCentroRP.setValor(((ReceberPagarCentroCustoBean)recPagCentro).getValor());
                        if (e.getSource() == this.buttonSugerirTodos) {
                            this.lancamentosCentroCustoRP.add(lanctoCentroRP);
                            continue;
                        }
                        check = new CheckValorCentro(lanctoCentroRP);
                        this.modelTitulos.setValueAt(check, i, 5);
                    }
                    continue;
                }
                Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel sugerir os valores do Centro de Custo.\nInforme os valores manualmente.", 2);
                break;
            }
        }
        if (e.getSource() == this.buttonCopiarTitulos) {
            LancamentoBean lancto = (LancamentoBean)this.comboPagamento.getSelectedItem();
            lancto.setPlanosContas(new HashSet());
            lancto.setCentrosCusto(new HashSet());
            this.panelPlanoCentro.limparCampos();
            this.panelPlanoCentro.setTipoDebitoCredito(lancto.getTipo());
            for (int i = 0; i < this.titulos.size(); ++i) {
                ReceberPagarBean titulo = this.titulos.get(i);
                if (titulo.getPlanosContas() != null) {
                    for (ReceberPagarPlanoContaBean recPagPlano : titulo.getPlanosContas()) {
                        LancamentoPlanoContaBean auxLanctoPlano = new LancamentoPlanoContaBean();
                        auxLanctoPlano.setEstacao(lancto.getEstacao());
                        auxLanctoPlano.setFilial(recPagPlano.getFilial());
                        auxLanctoPlano.setLancamento((LancamentoVO)lancto.toVO());
                        auxLanctoPlano.setOrigem(recPagPlano.getOrigem());
                        auxLanctoPlano.setPlanoConta(recPagPlano.getPlanoConta());
                        auxLanctoPlano.setValor(recPagPlano.getValor());
                        this.panelPlanoCentro.adicionarPlanoConta(auxLanctoPlano, false, true);
                    }
                    ArrayList<AbstractThreadBean> listaLanctoPlano = this.panelPlanoCentro.getPlanoContas();
                    for (int j = 0; j < listaLanctoPlano.size(); ++j) {
                        lancto.addPlanoConta((LancamentoPlanoContaBean)listaLanctoPlano.get(j));
                    }
                }
                if (titulo.getCentrosCusto() == null) continue;
                for (ReceberPagarCentroCustoBean recPagCentro : titulo.getCentrosCusto()) {
                    LancamentoCentroCustoBean auxLanctoCentro = new LancamentoCentroCustoBean();
                    auxLanctoCentro.setEstacao(lancto.getEstacao());
                    auxLanctoCentro.setFilial(recPagCentro.getFilial());
                    auxLanctoCentro.setLancamento((LancamentoVO)lancto.toVO());
                    auxLanctoCentro.setOrigem(recPagCentro.getOrigem());
                    auxLanctoCentro.setCentroCusto(recPagCentro.getCentroCusto());
                    auxLanctoCentro.setValor(recPagCentro.getValor());
                    this.panelPlanoCentro.adicionarCentroCusto(auxLanctoCentro, true);
                }
                ArrayList<AbstractThreadBean> listaLanctoCentro = this.panelPlanoCentro.getCentrosCusto();
                for (int j = 0; j < listaLanctoCentro.size(); ++j) {
                    lancto.addCentroCusto((LancamentoCentroCustoBean)listaLanctoCentro.get(j));
                }
            }
        }
    }

    public static void setPlanoContasRPAutomatico(LancamentoBean bean, ArrayList<ReceberPagarBean> titulos) {
        bean.setPlanosContasRP(new HashSet<LancamentoPlanoContaRPBean>());
        ArrayList listaLanctoPlano = new ArrayList(bean.getPlanosContas());
        for (int i = 0; i < listaLanctoPlano.size(); ++i) {
            LancamentoPlanoContaBean lanctoPlano = (LancamentoPlanoContaBean)listaLanctoPlano.get(i);
            for (int j = 0; j < titulos.size(); ++j) {
                ReceberPagarBean recPag = titulos.get(j);
                LancamentoPlanoContaRPBean lanctoPlanoRP = new LancamentoPlanoContaRPBean();
                lanctoPlanoRP.setEstacao(lanctoPlano.getEstacao());
                lanctoPlanoRP.setFilial(lanctoPlano.getFilial());
                lanctoPlanoRP.setLancamento(lanctoPlano.getLancamento());
                lanctoPlanoRP.setOrigem(lanctoPlano.getOrigem());
                lanctoPlanoRP.setPlanoConta(lanctoPlano.getPlanoConta());
                lanctoPlanoRP.setReceberPagar((ReceberPagarVO)recPag.toVO());
                lanctoPlanoRP.setValor(0.0);
                for (ReceberPagarPlanoContaBean recPagPlano : recPag.getPlanosContas()) {
                    if (recPagPlano.getPlanoConta().getReduzido().intValue() != lanctoPlano.getPlanoConta().getReduzido().intValue()) continue;
                    lanctoPlanoRP.setValor(recPagPlano.getValor());
                }
                if (lanctoPlanoRP.getValor() == null || !(lanctoPlanoRP.getValor() > 0.0)) continue;
                bean.getPlanosContasRP().add(lanctoPlanoRP);
            }
        }
    }

    public static void setCentrosCustoRPAutomatico(LancamentoBean bean, ArrayList<ReceberPagarBean> titulos) {
        bean.setCentroCustoRP(new HashSet<LancamentoCentroCustoRPBean>());
        ArrayList listaCentroCusto = new ArrayList(bean.getCentrosCusto());
        for (int i = 0; i < listaCentroCusto.size(); ++i) {
            LancamentoCentroCustoBean lanctoCentro = (LancamentoCentroCustoBean)listaCentroCusto.get(i);
            for (int j = 0; j < titulos.size(); ++j) {
                ReceberPagarBean recPag = titulos.get(j);
                LancamentoCentroCustoRPBean lanctoCentroRP = new LancamentoCentroCustoRPBean();
                lanctoCentroRP.setEstacao(lanctoCentro.getEstacao());
                lanctoCentroRP.setFilial(lanctoCentro.getFilial());
                lanctoCentroRP.setLancamento(lanctoCentro.getLancamento());
                lanctoCentroRP.setOrigem(lanctoCentro.getOrigem());
                lanctoCentroRP.setCentroCusto(lanctoCentro.getCentroCusto());
                lanctoCentroRP.setReceberPagar((ReceberPagarVO)recPag.toVO());
                lanctoCentroRP.setValor(0.0);
                for (ReceberPagarCentroCustoBean recPagCentro : recPag.getCentrosCusto()) {
                    if (recPagCentro.getCentroCusto().getReduzido().intValue() != lanctoCentro.getCentroCusto().getReduzido().intValue()) continue;
                    lanctoCentroRP.setValor(recPagCentro.getValor());
                }
                if (lanctoCentroRP.getValor() == null || !(lanctoCentroRP.getValor() > 0.0)) continue;
                bean.getCentrosCustoRP().add(lanctoCentroRP);
            }
        }
    }

    private void controlarCampos() {
        if (this.comboPagamento.getItemCount() == 1) {
            LancamentoBean aux = (LancamentoBean)this.comboPagamento.getSelectedItem();
            if (aux.getValorTotal().doubleValue() == this.somatorioRecPag.doubleValue()) {
                this.buttonSugerirTodos.setEnabled(true);
                this.buttonCopiarTitulos.setEnabled(true);
            } else {
                this.buttonSugerirTodos.setEnabled(false);
                this.buttonCopiarTitulos.setEnabled(false);
            }
        } else {
            this.buttonSugerirTodos.setEnabled(false);
            this.buttonCopiarTitulos.setEnabled(false);
        }
    }

    private void preencherDados(LancamentoBean lancto) {
        int i;
        this.comboPagamento.removeAllItems();
        this.lancamentosPlanoContaRP = new ArrayList();
        this.lancamentosCentroCustoRP = new ArrayList();
        for (i = 0; i < this.lancamentos.size(); ++i) {
            Iterator<AbstractThreadBean> it;
            LancamentoBean aux = this.lancamentos.get(i);
            aux.setCodigo(i);
            this.comboPagamento.addItem(aux);
            this.lancamentos.set(i, aux);
            if (aux.getPlanosContasRP() != null) {
                it = aux.getPlanosContasRP().iterator();
                while (it.hasNext()) {
                    this.lancamentosPlanoContaRP.add((LancamentoPlanoContaRPBean)it.next());
                }
            }
            if (aux.getCentrosCustoRP() == null) continue;
            it = aux.getCentrosCustoRP().iterator();
            while (it.hasNext()) {
                this.lancamentosCentroCustoRP.add((LancamentoCentroCustoRPBean)it.next());
            }
        }
        this.comboPagamento.setSelectedItem(lancto);
        this.panelPlanoCentro.atualizar(lancto);
        this.somatorioRecPag = BigDecimal.ZERO;
        this.modelTitulos.clear();
        for (i = 0; i < this.titulos.size(); ++i) {
            ReceberPagarBean titulo = this.titulos.get(i);
            this.somatorioRecPag = this.somatorioRecPag.add(new BigDecimal(titulo.getValorTotal())).setScale(2, RoundingMode.HALF_UP);
            this.modelTitulos.addLine(new Object[]{titulo.getCodigo(), titulo.getRazaoSocial(), Funcoes.formataData("dd/MM/yyyy", titulo.getDataVencimento()), Funcoes.formataDecimal(titulo.getValorTotal()), null, null, titulo});
        }
    }

    @Override
    public AbstractThreadBean buscaBeanPreenchido(PanelPlanoContaCentroCusto source) {
        return (LancamentoBean)this.comboPagamento.getSelectedItem();
    }

    @Override
    public void valueChanged(final ListSelectionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (AlterarPlanoCustoPagamentos.this.tableTitulos.getCellEditor() != null) {
                    AlterarPlanoCustoPagamentos.this.tableTitulos.getCellEditor().stopCellEditing();
                }
                LancamentoPlanoContaBean lanctoPlano = AlterarPlanoCustoPagamentos.this.panelPlanoCentro.getLancamentoPlanoContaSelecionado();
                LancamentoCentroCustoBean lanctoCentro = AlterarPlanoCustoPagamentos.this.panelPlanoCentro.getLancamentoCentroCustoSelecionado();
                if (AlterarPlanoCustoPagamentos.this.lanctoPlano != lanctoPlano) {
                    AlterarPlanoCustoPagamentos.this.planoContasAlterado(lanctoPlano);
                    AlterarPlanoCustoPagamentos.this.lanctoPlano = lanctoPlano;
                }
                if (AlterarPlanoCustoPagamentos.this.lanctoCentro != lanctoCentro) {
                    AlterarPlanoCustoPagamentos.this.centroCustoAlterado(lanctoCentro);
                    AlterarPlanoCustoPagamentos.this.lanctoCentro = lanctoCentro;
                }
                AlterarPlanoCustoPagamentos.this.tableTitulos.repaint();
            }
        });
    }

    private void planoContasAlterado(LancamentoPlanoContaBean novoLanctoPlano) {
        int codigoRecPag;
        int i;
        if (this.lanctoPlano != null) {
            for (i = 0; i < this.modelTitulos.getRowCount(); ++i) {
                if (this.modelTitulos.getValueAt(i, 4) == null) continue;
                LancamentoPlanoContaRPBean lanctoPlanoRP = ((CheckValorPlano)this.modelTitulos.getValueAt(i, 4)).getLancamentoPlanoContaRP();
                codigoRecPag = (Integer)this.modelTitulos.getValueAt(i, 0);
                boolean alterado = false;
                for (int j = 0; j < this.lancamentosPlanoContaRP.size(); ++j) {
                    LancamentoPlanoContaRPBean aux = this.lancamentosPlanoContaRP.get(j);
                    if (aux.getLancamento().getCodigo().intValue() != this.lanctoPlano.getLancamento().getCodigo().intValue() || aux.getReceberPagar().getCodigo() != codigoRecPag || aux.getPlanoConta().getReduzido().intValue() != this.lanctoPlano.getPlanoConta().getReduzido().intValue() || !aux.getOrigem().getCodigo().equalsIgnoreCase(this.lanctoPlano.getOrigem().getCodigo())) continue;
                    this.lancamentosPlanoContaRP.set(j, lanctoPlanoRP);
                    alterado = true;
                    break;
                }
                if (alterado) continue;
                this.lancamentosPlanoContaRP.add(lanctoPlanoRP);
            }
        }
        for (i = 0; i < this.modelTitulos.getRowCount(); ++i) {
            this.modelTitulos.setValueAt(null, i, 4);
        }
        if (novoLanctoPlano != null && novoLanctoPlano.getLancamento() != null) {
            BigDecimal somatorio = BigDecimal.ZERO;
            for (int i2 = 0; i2 < this.modelTitulos.getRowCount(); ++i2) {
                codigoRecPag = (Integer)this.modelTitulos.getValueAt(i2, 0);
                for (int j = 0; j < this.lancamentosPlanoContaRP.size(); ++j) {
                    LancamentoPlanoContaRPBean aux = this.lancamentosPlanoContaRP.get(j);
                    if (aux == null || aux.getLancamento() == null || aux.getLancamento().getCodigo() == null || aux.getLancamento().getCodigo().intValue() != novoLanctoPlano.getLancamento().getCodigo().intValue() || aux.getReceberPagar().getCodigo() != codigoRecPag || aux.getPlanoConta().getReduzido().intValue() != novoLanctoPlano.getPlanoConta().getReduzido().intValue() || !aux.getOrigem().getCodigo().equalsIgnoreCase(novoLanctoPlano.getOrigem().getCodigo())) continue;
                    CheckValorPlano check = new CheckValorPlano(aux);
                    this.modelTitulos.setValueAt(check, i2, 4);
                    somatorio = somatorio.add(new BigDecimal(check.getValor())).setScale(2, RoundingMode.HALF_UP);
                    break;
                }
                this.labelTotPlanoContas.setText(Funcoes.formataDecimal(somatorio.doubleValue()));
                if (this.modelTitulos.getValueAt(i2, 4) != null) continue;
                LancamentoPlanoContaRPBean lanctoPlanoRP = new LancamentoPlanoContaRPBean();
                lanctoPlanoRP.setEstacao(novoLanctoPlano.getEstacao());
                lanctoPlanoRP.setFilial(novoLanctoPlano.getFilial());
                lanctoPlanoRP.setLancamento(novoLanctoPlano.getLancamento());
                lanctoPlanoRP.setOrigem(novoLanctoPlano.getOrigem());
                lanctoPlanoRP.setPlanoConta(novoLanctoPlano.getPlanoConta());
                lanctoPlanoRP.setReceberPagar((ReceberPagarVO)((ReceberPagarBean)this.modelTitulos.getValueAt(i2, 6)).toVO());
                lanctoPlanoRP.setValor(0.0);
                CheckValorPlano check = new CheckValorPlano(lanctoPlanoRP);
                this.modelTitulos.setValueAt(check, i2, 4);
            }
        }
    }

    private void centroCustoAlterado(LancamentoCentroCustoBean novoLanctoCentro) {
        int codigoRecPag;
        int i;
        if (this.lanctoCentro != null) {
            for (i = 0; i < this.modelTitulos.getRowCount(); ++i) {
                if (this.modelTitulos.getValueAt(i, 5) == null) continue;
                LancamentoCentroCustoRPBean lanctoCentroRP = ((CheckValorCentro)this.modelTitulos.getValueAt(i, 5)).getLancamentoCentroCustoRP();
                codigoRecPag = (Integer)this.modelTitulos.getValueAt(i, 0);
                boolean alterado = false;
                for (int j = 0; j < this.lancamentosCentroCustoRP.size(); ++j) {
                    LancamentoCentroCustoRPBean aux = this.lancamentosCentroCustoRP.get(j);
                    if (aux == null || aux.getLancamento() == null || aux.getLancamento().getCodigo() == null || aux.getLancamento().getCodigo().intValue() != this.lanctoCentro.getLancamento().getCodigo().intValue() || aux.getReceberPagar().getCodigo() != codigoRecPag || aux.getCentroCusto().getReduzido().intValue() != this.lanctoCentro.getCentroCusto().getReduzido().intValue() || !aux.getOrigem().getCodigo().equalsIgnoreCase(this.lanctoCentro.getOrigem().getCodigo())) continue;
                    this.lancamentosCentroCustoRP.set(j, lanctoCentroRP);
                    alterado = true;
                    break;
                }
                if (alterado) continue;
                this.lancamentosCentroCustoRP.add(lanctoCentroRP);
            }
        }
        for (i = 0; i < this.modelTitulos.getRowCount(); ++i) {
            this.modelTitulos.setValueAt(null, i, 5);
        }
        if (novoLanctoCentro != null) {
            BigDecimal somatorio = BigDecimal.ZERO;
            for (int i2 = 0; i2 < this.modelTitulos.getRowCount(); ++i2) {
                codigoRecPag = (Integer)this.modelTitulos.getValueAt(i2, 0);
                for (int j = 0; j < this.lancamentosCentroCustoRP.size(); ++j) {
                    LancamentoCentroCustoRPBean aux = this.lancamentosCentroCustoRP.get(j);
                    if (aux == null || aux.getLancamento() == null || aux.getLancamento().getCodigo().intValue() != novoLanctoCentro.getLancamento().getCodigo().intValue() || aux.getReceberPagar().getCodigo() != codigoRecPag || aux.getCentroCusto().getReduzido().intValue() != novoLanctoCentro.getCentroCusto().getReduzido().intValue() || !aux.getOrigem().getCodigo().equalsIgnoreCase(novoLanctoCentro.getOrigem().getCodigo())) continue;
                    CheckValorCentro check = new CheckValorCentro(aux);
                    this.modelTitulos.setValueAt(check, i2, 5);
                    somatorio = somatorio.add(new BigDecimal(check.getValor())).setScale(2, RoundingMode.HALF_UP);
                    break;
                }
                this.labelTotCentroCusto.setText(Funcoes.formataDecimal(somatorio.doubleValue()));
                if (this.modelTitulos.getValueAt(i2, 5) != null) continue;
                LancamentoCentroCustoRPBean lanctoCentroRP = new LancamentoCentroCustoRPBean();
                lanctoCentroRP.setEstacao(novoLanctoCentro.getEstacao());
                lanctoCentroRP.setFilial(novoLanctoCentro.getFilial());
                lanctoCentroRP.setLancamento(novoLanctoCentro.getLancamento());
                lanctoCentroRP.setOrigem(novoLanctoCentro.getOrigem());
                lanctoCentroRP.setCentroCusto(novoLanctoCentro.getCentroCusto());
                lanctoCentroRP.setReceberPagar((ReceberPagarVO)((ReceberPagarBean)this.modelTitulos.getValueAt(i2, 6)).toVO());
                lanctoCentroRP.setValor(0.0);
                CheckValorCentro check = new CheckValorCentro(lanctoCentroRP);
                this.modelTitulos.setValueAt(check, i2, 5);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        LancamentoBean lancto = (LancamentoBean)e.getItem();
        if (e.getStateChange() == 2) {
            if (this.tableTitulos.getCellEditor() != null) {
                this.tableTitulos.getCellEditor().stopCellEditing();
            }
            if (this.panelPlanoCentro.getPlanoContas() != null && this.panelPlanoCentro.getPlanoContas().size() > 0) {
                lancto.setPlanosContas(new HashSet<AbstractThreadBean>(this.panelPlanoCentro.getPlanoContas()));
            }
            if (this.panelPlanoCentro.getCentrosCusto() != null && this.panelPlanoCentro.getCentrosCusto().size() > 0) {
                lancto.setCentrosCusto(new HashSet<AbstractThreadBean>(this.panelPlanoCentro.getCentrosCusto()));
            }
            for (int i = 0; i < this.lancamentos.size(); ++i) {
                LancamentoBean aux = this.lancamentos.get(i);
                if (aux.getCodigo().intValue() != lancto.getCodigo().intValue()) continue;
                this.lancamentos.set(i, lancto);
                this.comboPagamento.validate();
                break;
            }
        } else {
            this.panelPlanoCentro.limparCampos();
            this.panelPlanoCentro.atualizar(lancto);
        }
    }

    public Double getSomatorioPlanoRP(CheckValorPlano checkAtual) {
        BigDecimal somatorio = BigDecimal.ZERO;
        for (int i = 0; i < this.modelTitulos.getRowCount(); ++i) {
            CheckValorPlano check = (CheckValorPlano)this.modelTitulos.getValueAt(i, 4);
            if (check == checkAtual || check == null) continue;
            somatorio = somatorio.add(new BigDecimal(check.getValor()));
        }
        return somatorio.setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public Double getValorPlanoContaSelecionado() {
        LancamentoPlanoContaBean lancto = this.panelPlanoCentro.getLancamentoPlanoContaSelecionado();
        if (lancto != null) {
            return lancto.getValor();
        }
        return 0.0;
    }

    public Double getSomatorioCentroRP(CheckValorCentro checkAtual) {
        BigDecimal somatorio = BigDecimal.ZERO;
        for (int i = 0; i < this.modelTitulos.getRowCount(); ++i) {
            CheckValorCentro check = (CheckValorCentro)this.modelTitulos.getValueAt(i, 5);
            if (check == checkAtual || check == null) continue;
            somatorio = somatorio.add(new BigDecimal(check.getValor()));
        }
        return somatorio.setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public Double getValorCentroCustoSelecionado() {
        LancamentoCentroCustoBean lancto = this.panelPlanoCentro.getLancamentoCentroCustoSelecionado();
        if (lancto != null) {
            return lancto.getValor();
        }
        return 0.0;
    }

    class CheckValorCentroEditor
    extends DefaultCellEditor {
        JTable table;
        int row;
        int column;
        double valorInicial;
        CheckValorCentro checkCentro;

        public CheckValorCentroEditor() {
            this(this$0.new CheckValorCentroRenderer());
        }

        @Override
        public boolean stopCellEditing() {
            if (this.checkCentro.validar((CheckValorCentro)this.getCellEditorValue(), (CheckValorCentroRenderer)this.editorComponent)) {
                return super.stopCellEditing();
            }
            this.cancelCellEditing();
            return false;
        }

        @Override
        public void cancelCellEditing() {
            this.checkCentro.setValor(this.valorInicial);
            ((CheckValorCentroRenderer)this.editorComponent).setValor(this.valorInicial);
        }

        public CheckValorCentroEditor(final CheckValorCentroRenderer checkValor) {
            super(new JTextField());
            this.table = null;
            this.row = -1;
            this.column = -1;
            this.valorInicial = 0.0;
            this.checkCentro = null;
            if (this.table != null && !this.table.isCellEditable(this.row, this.column)) {
                return;
            }
            this.editorComponent = checkValor;
            this.clickCountToStart = 1;
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void setValue(Object value) {
                    CheckValorCentroEditor.this.checkCentro = (CheckValorCentro)value;
                    checkValor.setValor(((CheckValorCentro)value).getValor());
                }

                @Override
                public Object getCellEditorValue() {
                    CheckValorCentroEditor.this.checkCentro.setValor(checkValor.getValor());
                    return CheckValorCentroEditor.this.checkCentro;
                }
            };
            checkValor.addActionListener(this.delegate);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.delegate.setValue(value);
            this.table = table;
            this.row = row;
            this.column = column;
            if (value != null) {
                this.valorInicial = ((CheckValorCentro)value).getValor();
            }
            return this.editorComponent;
        }
    }

    class CheckValorPlanoEditor
    extends DefaultCellEditor {
        JTable table;
        int row;
        int column;
        double valorInicial;
        CheckValorPlano checkPlano;

        public CheckValorPlanoEditor() {
            this(this$0.new CheckValorPlanoRenderer());
        }

        @Override
        public boolean stopCellEditing() {
            if (this.checkPlano.validar((CheckValorPlano)this.getCellEditorValue(), (CheckValorPlanoRenderer)this.editorComponent)) {
                return super.stopCellEditing();
            }
            this.cancelCellEditing();
            return false;
        }

        @Override
        public void cancelCellEditing() {
            this.checkPlano.setValor(this.valorInicial);
            ((CheckValorPlanoRenderer)this.editorComponent).setValor(this.valorInicial);
        }

        public CheckValorPlanoEditor(final CheckValorPlanoRenderer checkValor) {
            super(new JTextField());
            this.table = null;
            this.row = -1;
            this.column = -1;
            this.valorInicial = 0.0;
            this.checkPlano = null;
            if (this.table != null && !this.table.isCellEditable(this.row, this.column)) {
                return;
            }
            this.editorComponent = checkValor;
            this.clickCountToStart = 1;
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void setValue(Object value) {
                    CheckValorPlanoEditor.this.checkPlano = (CheckValorPlano)value;
                    checkValor.setValor(((CheckValorPlano)value).getValor());
                }

                @Override
                public Object getCellEditorValue() {
                    CheckValorPlanoEditor.this.checkPlano.setValor(checkValor.getValor());
                    return CheckValorPlanoEditor.this.checkPlano;
                }
            };
            checkValor.addActionListener(this.delegate);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.delegate.setValue(value);
            this.table = table;
            this.row = row;
            this.column = column;
            if (value != null) {
                this.valorInicial = ((CheckValorPlano)value).getValor();
            }
            return this.editorComponent;
        }
    }

    class CheckValorCentroRenderer
    extends JPanel
    implements TableCellRenderer,
    Serializable,
    KeyListener,
    FocusListener,
    ItemListener {
        private CheckValorCentro valorCentro;
        private JCheckBox checkValor = new JCheckBox();
        private TTextField textValor = new TTextField(12, 2);
        private Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        private Color unselectedForeground;
        private Color unselectedBackground = null;

        public CheckValorCentro getCheckCentro() {
            return this.valorCentro;
        }

        public void focalizar() {
            this.textValor.selectAll();
            ScreenUtil.requisitarFoco(this.textValor);
        }

        public CheckValorCentroRenderer() {
            this.setOpaque(true);
            this.setBorder(this.getNoFocusBorder());
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            this.checkValor.setOpaque(false);
            this.checkValor.addItemListener(this);
            this.checkValor.addKeyListener(this);
            c.insets = new Insets(0, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            this.add((Component)this.checkValor, c);
            this.textValor.setMinimumSize(new Dimension(60, 20));
            this.textValor.setText(Funcoes.formataDecimal(0.0));
            this.textValor.addFocusListener(this);
            this.textValor.addKeyListener(this);
            ++c.gridx;
            c.insets = new Insets(0, 0, 0, 1);
            c.fill = 2;
            c.weightx = 1.0;
            this.add((Component)this.textValor, c);
        }

        public void limpar() {
            this.textValor.setText("");
            this.checkValor.setSelected(false);
        }

        public void setValor(Double valor) {
            if (valor == null) {
                this.textValor.setText(Funcoes.formataDecimal(0));
                this.checkValor.setSelected(false);
            } else {
                this.textValor.setText(Funcoes.formataDecimal(valor));
                if (valor > 0.0) {
                    this.checkValor.setSelected(true);
                } else {
                    this.checkValor.setSelected(false);
                }
            }
        }

        public void setSelected(boolean isSelected) {
            this.checkValor.setSelected(isSelected);
            if (!isSelected) {
                this.textValor.setText(Funcoes.formataDecimal(0));
            }
        }

        public double getValor() {
            if (Funcoes.textoVazio(this.textValor)) {
                return 0.0;
            }
            return Double.parseDouble(Funcoes.limpaDecimal(this.textValor.getText()));
        }

        public boolean getSelected() {
            return this.checkValor.isSelected();
        }

        private Border getNoFocusBorder() {
            if (System.getSecurityManager() != null) {
                return this.SAFE_NO_FOCUS_BORDER;
            }
            return this.noFocusBorder;
        }

        @Override
        public void setForeground(Color c) {
            super.setForeground(c);
            this.unselectedForeground = c;
        }

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            if (this.unselectedBackground == null) {
                this.unselectedBackground = c;
            }
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setForeground(null);
            this.setBackground(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color fg = null;
            Color bg = null;
            JTable.DropLocation dropLocation = table.getDropLocation();
            if (dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == row && dropLocation.getColumn() == column) {
                fg = UIManager.getColor("Table.dropCellForeground");
                bg = UIManager.getColor("Table.dropCellBackground");
                isSelected = true;
            }
            if (isSelected) {
                this.setForeground(fg == null ? table.getSelectionForeground() : fg);
                this.setBackground(bg == null ? table.getSelectionBackground() : bg);
            } else {
                this.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                this.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
            }
            this.setFont(table.getFont());
            if (hasFocus) {
                Border border = null;
                if (isSelected) {
                    border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("Table.focusCellHighlightBorder");
                }
                this.setBorder(border);
                if (!isSelected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        this.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        this.setBackground(col);
                    }
                }
            } else {
                this.setBorder(this.getNoFocusBorder());
            }
            this.textValor.setEnabled(table.isCellEditable(row, column));
            this.checkValor.setEnabled(table.isCellEditable(row, column));
            if (value != null) {
                if (value instanceof CheckValorPlano) {
                    this.setValor(((CheckValorPlano)value).getValor());
                } else {
                    this.setValor(((CheckValorCentro)value).getValor());
                }
                this.setSelected(this.getValor() != 0.0);
            } else {
                this.limpar();
            }
            return this;
        }

        @Override
        public boolean isOpaque() {
            Color back = this.getBackground();
            Container p = this.getParent();
            if (p != null) {
                p = p.getParent();
            }
            boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
            return !colorMatch && super.isOpaque();
        }

        protected void setValue(Object value) {
            this.setValor(((CheckValorCentro)value).getValor());
            this.setSelected(((CheckValorCentro)value).getSelected());
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!Funcoes.textoVazio(this.textValor)) {
                if (!Funcoes.textoVazio(this.textValor)) {
                    this.checkValor.setSelected(true);
                } else {
                    this.checkValor.setSelected(false);
                }
            }
        }

        @Override
        @Deprecated
        public void focusGained(FocusEvent e) {
        }

        @Override
        @Deprecated
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 9 || e.getKeyCode() == 10) {
                if (e.getSource() == this.textValor) {
                    ScreenUtil.consumirEventoAtual();
                    ScreenUtil.consumirEventoAtual();
                    if (AlterarPlanoCustoPagamentos.this.tableTitulos.getCellEditor().stopCellEditing()) {
                        this.transferFocus();
                    }
                } else if (e.getSource() == this.checkValor) {
                    this.requestFocus();
                }
            }
        }

        @Override
        @Deprecated
        public void keyReleased(KeyEvent e) {
        }

        public synchronized void addActionListener(ActionListener l) {
            this.listenerList.add(ActionListener.class, l);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                Double somatorio = AlterarPlanoCustoPagamentos.this.getSomatorioCentroRP(null);
                somatorio = somatorio - Double.parseDouble(Funcoes.limpaDecimal(Funcoes.textoVazio(this.textValor.getText()) ? "0" : this.textValor.getText()));
                this.textValor.setText(Funcoes.formataDecimal(0));
                if (AlterarPlanoCustoPagamentos.this.tableTitulos.getCellEditor() != null) {
                    AlterarPlanoCustoPagamentos.this.tableTitulos.getCellEditor().stopCellEditing();
                }
                AlterarPlanoCustoPagamentos.this.labelTotCentroCusto.setText(Funcoes.formataDecimal(somatorio));
            }
        }
    }

    class CheckValorPlanoRenderer
    extends JPanel
    implements TableCellRenderer,
    Serializable,
    KeyListener,
    FocusListener,
    ItemListener {
        private CheckValorPlano valorPlano;
        private JCheckBox checkValor = new JCheckBox();
        private TTextField textValor = new TTextField(12, 2);
        private Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        private Color unselectedForeground;
        private Color unselectedBackground = null;

        public void focalizar() {
            this.textValor.selectAll();
            ScreenUtil.requisitarFoco(this.textValor);
        }

        public CheckValorPlano getCheckPlano() {
            return this.valorPlano;
        }

        public CheckValorPlanoRenderer() {
            this.setOpaque(true);
            this.setBorder(this.getNoFocusBorder());
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            this.checkValor.setOpaque(false);
            this.checkValor.addItemListener(this);
            this.checkValor.addKeyListener(this);
            c.insets = new Insets(0, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            this.add((Component)this.checkValor, c);
            this.textValor.setMinimumSize(new Dimension(60, 20));
            this.textValor.setText(Funcoes.formataDecimal(0.0));
            this.textValor.addFocusListener(this);
            this.textValor.addKeyListener(this);
            ++c.gridx;
            c.insets = new Insets(0, 0, 0, 1);
            c.fill = 2;
            c.weightx = 1.0;
            this.add((Component)this.textValor, c);
        }

        public void limpar() {
            this.textValor.setText("");
            this.checkValor.setSelected(false);
        }

        public void setValor(Double valor) {
            if (valor == null) {
                this.textValor.setText(Funcoes.formataDecimal(0));
                this.checkValor.setSelected(false);
            } else {
                this.textValor.setText(Funcoes.formataDecimal(valor));
                if (valor > 0.0) {
                    this.checkValor.setSelected(true);
                } else {
                    this.checkValor.setSelected(false);
                }
            }
        }

        public void setSelected(boolean isSelected) {
            this.checkValor.setSelected(isSelected);
            if (!isSelected) {
                this.textValor.setText(Funcoes.formataDecimal(0));
            }
        }

        public double getValor() {
            if (Funcoes.textoVazio(this.textValor)) {
                return 0.0;
            }
            return Double.parseDouble(Funcoes.limpaDecimal(this.textValor.getText()));
        }

        public boolean getSelected() {
            return this.checkValor.isSelected();
        }

        private Border getNoFocusBorder() {
            if (System.getSecurityManager() != null) {
                return this.SAFE_NO_FOCUS_BORDER;
            }
            return this.noFocusBorder;
        }

        @Override
        public void setForeground(Color c) {
            super.setForeground(c);
            this.unselectedForeground = c;
        }

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            if (this.unselectedBackground == null) {
                this.unselectedBackground = c;
            }
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setForeground(null);
            this.setBackground(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color fg = null;
            Color bg = null;
            JTable.DropLocation dropLocation = table.getDropLocation();
            if (dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == row && dropLocation.getColumn() == column) {
                fg = UIManager.getColor("Table.dropCellForeground");
                bg = UIManager.getColor("Table.dropCellBackground");
                isSelected = true;
            }
            if (isSelected) {
                this.setForeground(fg == null ? table.getSelectionForeground() : fg);
                this.setBackground(bg == null ? table.getSelectionBackground() : bg);
            } else {
                this.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                this.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
            }
            this.setFont(table.getFont());
            if (hasFocus) {
                Border border = null;
                if (isSelected) {
                    border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("Table.focusCellHighlightBorder");
                }
                this.setBorder(border);
                if (!isSelected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        this.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        this.setBackground(col);
                    }
                }
            } else {
                this.setBorder(this.getNoFocusBorder());
            }
            this.textValor.setEnabled(table.isCellEditable(row, column));
            this.checkValor.setEnabled(table.isCellEditable(row, column));
            if (value != null) {
                if (value instanceof CheckValorPlano) {
                    this.setValor(((CheckValorPlano)value).getValor());
                } else {
                    this.setValor(((CheckValorCentro)value).getValor());
                }
                this.setSelected(this.getValor() != 0.0);
            } else {
                this.limpar();
            }
            return this;
        }

        @Override
        public boolean isOpaque() {
            Color back = this.getBackground();
            Container p = this.getParent();
            if (p != null) {
                p = p.getParent();
            }
            boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
            return !colorMatch && super.isOpaque();
        }

        protected void setValue(Object value) {
            this.setValor(((CheckValorPlano)value).getValor());
            this.setSelected(((CheckValorPlano)value).getSelected());
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!Funcoes.textoVazio(this.textValor)) {
                if (!Funcoes.textoVazio(this.textValor)) {
                    this.checkValor.setSelected(true);
                } else {
                    this.checkValor.setSelected(false);
                }
            }
        }

        @Override
        @Deprecated
        public void focusGained(FocusEvent e) {
        }

        @Override
        @Deprecated
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 9 || e.getKeyCode() == 10) {
                if (e.getSource() == this.textValor) {
                    ScreenUtil.consumirEventoAtual();
                    ScreenUtil.consumirEventoAtual();
                    if (AlterarPlanoCustoPagamentos.this.tableTitulos.getCellEditor().stopCellEditing()) {
                        this.transferFocus();
                    }
                } else if (e.getSource() == this.checkValor) {
                    this.requestFocus();
                }
            }
        }

        @Override
        @Deprecated
        public void keyReleased(KeyEvent e) {
        }

        public synchronized void addActionListener(ActionListener l) {
            this.listenerList.add(ActionListener.class, l);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                Double somatorio = AlterarPlanoCustoPagamentos.this.getSomatorioPlanoRP(null);
                somatorio = somatorio - Double.parseDouble(Funcoes.limpaDecimal(Funcoes.textoVazio(this.textValor.getText()) ? "0" : this.textValor.getText()));
                this.textValor.setText(Funcoes.formataDecimal(0));
                if (AlterarPlanoCustoPagamentos.this.tableTitulos.getCellEditor() != null) {
                    AlterarPlanoCustoPagamentos.this.tableTitulos.getCellEditor().stopCellEditing();
                }
                AlterarPlanoCustoPagamentos.this.labelTotPlanoContas.setText(Funcoes.formataDecimal(somatorio));
            }
        }
    }

    class CheckValorCentro
    implements Comparable {
        private boolean isSelected = false;
        private LancamentoCentroCustoRPBean lanctoCentroRP;

        public boolean validar(CheckValorCentro checkEditando, final CheckValorCentroRenderer render) {
            double somatorio = AlterarPlanoCustoPagamentos.this.getSomatorioCentroRP(this);
            if (checkEditando.getValor() == 0.0) {
                AlterarPlanoCustoPagamentos.this.labelTotCentroCusto.setText(Funcoes.formataDecimal(somatorio));
                return true;
            }
            if (checkEditando.getValor() > checkEditando.getLancamentoCentroCustoRP().getReceberPagar().getValorTotal()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Funcoes.mensagem(AlterarPlanoCustoPagamentos.this, "O valor configurado ultrapassa o total do t\u00edtulo.", 2);
                        render.focalizar();
                    }
                });
                return false;
            }
            if ((somatorio += checkEditando.getValor()) > AlterarPlanoCustoPagamentos.this.getValorCentroCustoSelecionado()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Funcoes.mensagem(AlterarPlanoCustoPagamentos.this, "O valor configurado ultrapassa o total para o Centro de Custo.", 2);
                        render.focalizar();
                    }
                });
                return false;
            }
            AlterarPlanoCustoPagamentos.this.labelTotCentroCusto.setText(Funcoes.formataDecimal(somatorio));
            return true;
        }

        public LancamentoCentroCustoRPBean getLancamentoCentroCustoRP() {
            return this.lanctoCentroRP;
        }

        public CheckValorCentro(LancamentoCentroCustoRPBean bean) {
            this.lanctoCentroRP = bean;
        }

        public void setValor(double valor) {
            this.lanctoCentroRP.setValor(valor);
            if (valor == 0.0) {
                this.isSelected = false;
            }
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
            if (!isSelected) {
                this.lanctoCentroRP.setValor(0.0);
            }
        }

        public boolean getSelected() {
            return this.isSelected;
        }

        public double getValor() {
            return this.lanctoCentroRP.getValor();
        }

        public int compareTo(Object o) {
            if (!(o instanceof Double)) {
                return 0;
            }
            return new Double(this.lanctoCentroRP.getValor()).compareTo(new Double((Double)o));
        }
    }

    class CheckValorPlano
    implements Comparable {
        private boolean isSelected = false;
        private LancamentoPlanoContaRPBean lanctoPlanoRP;

        public boolean validar(CheckValorPlano checkEditando, final CheckValorPlanoRenderer render) {
            double somatorio = AlterarPlanoCustoPagamentos.this.getSomatorioPlanoRP(this);
            if (checkEditando.getValor() == 0.0) {
                AlterarPlanoCustoPagamentos.this.labelTotPlanoContas.setText(Funcoes.formataDecimal(somatorio));
                return true;
            }
            if (checkEditando.getValor() > checkEditando.getLancamentoPlanoContaRP().getReceberPagar().getValorTotal()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Funcoes.mensagem(AlterarPlanoCustoPagamentos.this, "O valor configurado ultrapassa o total para o Plano de Contas.", 2);
                        render.focalizar();
                    }
                });
                return false;
            }
            if ((somatorio += checkEditando.getValor()) > AlterarPlanoCustoPagamentos.this.getValorPlanoContaSelecionado()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Funcoes.mensagem(AlterarPlanoCustoPagamentos.this, "O valor configurado ultrapassa o total para o Plano de Contas.", 2);
                        render.focalizar();
                    }
                });
                return false;
            }
            AlterarPlanoCustoPagamentos.this.labelTotPlanoContas.setText(Funcoes.formataDecimal(somatorio));
            return true;
        }

        public LancamentoPlanoContaRPBean getLancamentoPlanoContaRP() {
            return this.lanctoPlanoRP;
        }

        public CheckValorPlano(LancamentoPlanoContaRPBean bean) {
            this.lanctoPlanoRP = bean;
        }

        public void setValor(double valor) {
            this.lanctoPlanoRP.setValor(valor);
            if (valor == 0.0) {
                this.isSelected = false;
            }
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
            if (!isSelected) {
                this.lanctoPlanoRP.setValor(0.0);
            }
        }

        public boolean getSelected() {
            return this.isSelected;
        }

        public double getValor() {
            return this.lanctoPlanoRP.getValor();
        }

        public int compareTo(Object o) {
            if (!(o instanceof Double)) {
                return 0;
            }
            return new Double(this.lanctoPlanoRP.getValor()).compareTo(new Double((Double)o));
        }
    }
}

