/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.lancamentos;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.detalhes.Detalhes;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.lancamentos.FrmCadPadraoBeanLancamento;
import jalis.laboratorio.financeiro.lancamentos.ReceberPagar;
import jalis.laboratorio.financeiro.lancamentos.componente.BuscaBeanPreenchido;
import jalis.laboratorio.financeiro.lancamentos.componente.PanelPlanoContaCentroCusto;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.EntidadeBean;
import jalis.model.bean.financeiro.AgrupamentoBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.dao.financeiro.ReceberPagarDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.financeiro.SeriesVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.EntidadeService;
import jalis.service.cadastro.PacienteService;
import jalis.service.financeiro.AgrupamentoService;
import jalis.service.financeiro.ReceberPagarService;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class AgrupamentoReceberPagar
extends FrmCadPadraoBeanLancamento
implements BuscaBeanPreenchido {
    private static final long ACESSO_ACESSAR_RECEBERPAGAR = Long.parseLong("0600410104");
    private static final long ACESSO_ALTERAR_RECEBERPAGAR = Long.parseLong("0600410105");
    private JPanel panelTitulosAgrupados = new JPanel(new GridBagLayout());
    private JPanel panelTituloAgrupador = new JPanel(new GridBagLayout());
    private JPanel panelAddTitulo = new JPanel(new GridBagLayout());
    private JComboBox comboTipo = new JComboBox<String>(new String[]{Tipos.tipoReceberPagar("R"), Tipos.tipoReceberPagar("P")});
    private TTextField textCodigo = new TTextField(8, 1);
    private JButton buttonAdicionarTitulo = new JButton();
    private ModeloGridTable modelTitulos;
    private JTable tableTitulos;
    private JScrollPane scrollTitulos;
    private TotalizadorTitulos totalizadorTitulos = new TotalizadorTitulos(1);
    private DetalhesAgrupador detalhesAgrupador = new DetalhesAgrupador(1);
    private JButton buttonEditarAgrupador = new JButton("Editar Agrupador");
    private JButton buttonRemoverTodos = new JButton("Remover Todos");
    private TTextField textCodigoCadastro = new TTextField(8, 1);
    private JButton buttonBuscaCadastro = new JButton();
    private JComboBox comboTipoCadastro = new JComboBox<String>(new String[]{Tipos.tipoCadastro("U"), Tipos.tipoCadastro("F"), Tipos.tipoCadastro("C"), Tipos.tipoCadastro("R"), Tipos.tipoCadastro("P"), Tipos.tipoCadastro("O")});
    private JLabel labelTipo = new JLabel("Tipo:");
    private JLabel labelCodigo = new JLabel("C\u00f3digo T\u00edtulo:");
    private JLabel labelCodigoCadastro = new JLabel("Cadastro:");
    private JLabel labelCadastro = new JLabel();
    private JLabel labelTipoCadastro = new JLabel("Tipo Cadastro:");
    private static final int CADASTRO_CONFIGURADO = 1;
    private static final int CADASTRO_NAO_CONFIGURADO = 2;
    private int configCadastro = 2;
    private JPanel pnlLegenda = new JPanel(new GridBagLayout());
    private ConvenioService convenioService = new ConvenioService();
    private PacienteService pacienteService = new PacienteService();
    private EntidadeService entidadeService = new EntidadeService();
    private ArrayList<ReceberPagarBean> titulos = new ArrayList();
    private ReceberPagarBean beanAgrupador = null;
    private SplashMensagem janelaEspera = null;

    public AgrupamentoReceberPagar() {
        this.service = new AgrupamentoService();
        this.setLabelDescricao("Agrupamento de t\u00edtulos a Receber e Pagar");
        this.setLabelFormulario("Agrupamento de Receber/Pagar");
        this.setIcone(ImagemUtils.carregaImagemJalis("financeiro/agrupamento_receber_pagar.jpg"));
        this.botaoExcluir.setText("Desagrupar");
        ScreenUtil.setBorda(new Component[]{this.labelCadastro}, new TitledBorder(""));
        this.painelCentral.setLayout(new GridBagLayout());
        this.panelTituloAgrupador.setBorder(BorderFactory.createTitledBorder("T\u00edtulo Agrupador (Resumo)"));
        this.panelTitulosAgrupados.setBorder(BorderFactory.createTitledBorder("T\u00edtulos Originais"));
        Dimension d = new Dimension(80, 20);
        this.comboTipo.setPreferredSize(d);
        this.comboTipo.setMinimumSize(d);
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setMinimumSize(d);
        this.textCodigoCadastro.setPreferredSize(d);
        this.textCodigoCadastro.setMinimumSize(d);
        this.buttonRemoverTodos.setMnemonic('R');
        this.buttonRemoverTodos.setMargin(new Insets(0, 0, 0, 0));
        d = new Dimension(110, 20);
        this.buttonRemoverTodos.setPreferredSize(d);
        this.buttonRemoverTodos.setMinimumSize(d);
        this.buttonRemoverTodos.setFocusable(false);
        d = new Dimension(20, 20);
        this.buttonAdicionarTitulo.setPreferredSize(d);
        this.buttonAdicionarTitulo.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonAdicionarTitulo);
        this.buttonAdicionarTitulo.setFocusable(false);
        d = new Dimension(20, 20);
        this.buttonBuscaCadastro.setPreferredSize(d);
        this.buttonBuscaCadastro.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaCadastro);
        this.buttonBuscaCadastro.setFocusable(false);
        this.labelCadastro.setPreferredSize(d);
        this.labelCadastro.setMinimumSize(d);
        d = new Dimension(120, 20);
        this.comboTipoCadastro.setPreferredSize(d);
        this.comboTipoCadastro.setMinimumSize(d);
        this.buttonRemoverTodos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int resp = Funcoes.mensagem(AgrupamentoReceberPagar.this, "Deseja remover todos os t\u00edtulos Originais?", 4);
                if (resp == 0) {
                    AgrupamentoReceberPagar.this.removerTodosTitulos();
                }
            }
        });
        this.comboTipoCadastro.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AgrupamentoReceberPagar.this.textCodigoCadastro.setText("");
                AgrupamentoReceberPagar.this.labelCadastro.setText("");
            }
        });
        this.textCodigo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AgrupamentoReceberPagar.this.pesquisaTitulosAgrupados();
                }
            }
        });
        this.textCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ReceberPagarBean bean = null;
                if (!Funcoes.textoVazio(AgrupamentoReceberPagar.this.textCodigo)) {
                    bean = AgrupamentoReceberPagar.this.pesquisaTituloCodigo(AgrupamentoReceberPagar.this.textCodigo.getText());
                    if (bean != null) {
                        AgrupamentoReceberPagar.this.adicionarTitulo(bean);
                    } else {
                        AgrupamentoReceberPagar.this.textCodigo.selectAll();
                        if (AgrupamentoReceberPagar.this.textCodigo.isFocusable()) {
                            AgrupamentoReceberPagar.this.textCodigo.grabFocus();
                        }
                    }
                }
            }
        });
        this.buttonAdicionarTitulo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AgrupamentoReceberPagar.this.pesquisaTitulosAgrupados();
            }
        });
        this.textCodigoCadastro.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(AgrupamentoReceberPagar.this.textCodigoCadastro)) {
                    AgrupamentoReceberPagar.this.pesquisaCadastro(AgrupamentoReceberPagar.this.getTipoCadastroSelecionado(), AgrupamentoReceberPagar.this.textCodigoCadastro.getText());
                }
                if (!(Funcoes.textoVazio(AgrupamentoReceberPagar.this.textCodigoCadastro) || Funcoes.textoVazio(AgrupamentoReceberPagar.this.labelCadastro.getText()) || AgrupamentoReceberPagar.this.labelCadastro.getText().equals("N\u00e3o cadastrado"))) {
                    AgrupamentoReceberPagar.this.configCadastro = 1;
                }
                AgrupamentoReceberPagar.this.controlaCampos();
                if (e.getOppositeComponent() == AgrupamentoReceberPagar.this.tableTitulos && AgrupamentoReceberPagar.this.textCodigo.isEnabled() && AgrupamentoReceberPagar.this.textCodigo.isFocusable()) {
                    AgrupamentoReceberPagar.this.textCodigo.grabFocus();
                }
            }
        });
        this.textCodigoCadastro.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AgrupamentoReceberPagar.this.pesquisaCadastro();
                }
                if (!(Funcoes.textoVazio(AgrupamentoReceberPagar.this.textCodigoCadastro) || Funcoes.textoVazio(AgrupamentoReceberPagar.this.labelCadastro.getText()) || AgrupamentoReceberPagar.this.labelCadastro.getText().equals("N\u00e3o cadastrado"))) {
                    AgrupamentoReceberPagar.this.configCadastro = 1;
                }
                AgrupamentoReceberPagar.this.controlaCampos();
            }
        });
        this.buttonBuscaCadastro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AgrupamentoReceberPagar.this.pesquisaCadastro();
                if (!Funcoes.textoVazio(AgrupamentoReceberPagar.this.textCodigoCadastro) && !AgrupamentoReceberPagar.this.labelCadastro.getText().equals("N\u00e3o cadastrado")) {
                    AgrupamentoReceberPagar.this.configCadastro = 1;
                }
                AgrupamentoReceberPagar.this.controlaCampos();
            }
        });
        this.buttonEditarAgrupador.setMnemonic('A');
        this.buttonEditarAgrupador.setMargin(new Insets(1, 1, 1, 1));
        this.buttonEditarAgrupador.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Acesso.getAcesso(ACESSO_ACESSAR_RECEBERPAGAR)) {
                    AgrupamentoReceberPagar.this.alteraTituloAgrupador();
                }
            }
        });
        this.modelTitulos = new ModeloGridTable(new String[]{"Tipo Doc.", "N\u00fam. Doc.", "Parc.", "Observa\u00e7\u00e3o", "Vencimento", "Vl. Bruto", "Vl. L\u00edquido", "Objeto"}){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    AgrupamentoReceberPagar.this.tableTitulos.removeColumn(AgrupamentoReceberPagar.this.tableTitulos.getColumn("Objeto"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.tableTitulos = new JTable(this.modelTitulos);
        this.modelTitulos.setColumnSize(new int[]{100, 90, 50, 0, 90, 85, 85, 0}, this.tableTitulos);
        this.tableTitulos.getTableHeader().addMouseListener(this.modelTitulos);
        this.tableTitulos.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    int resposta = Funcoes.mensagem(AgrupamentoReceberPagar.this, "Deseja remover o t\u00edtulo selecionado?", 4);
                    if (resposta == 0) {
                        AgrupamentoReceberPagar.this.removerTituloAgrupadoSelecionado();
                        if (AgrupamentoReceberPagar.this.textCodigo.isFocusable()) {
                            AgrupamentoReceberPagar.this.textCodigo.grabFocus();
                        }
                    }
                } else if (e.getKeyCode() == 32 && Acesso.getAcesso(ACESSO_ACESSAR_RECEBERPAGAR)) {
                    AgrupamentoReceberPagar.this.alteraTituloAgrupadoSelecionado();
                }
            }
        });
        this.tableTitulos.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && Acesso.getAcesso(ACESSO_ACESSAR_RECEBERPAGAR)) {
                    AgrupamentoReceberPagar.this.alteraTituloAgrupadoSelecionado();
                }
            }
        });
        this.tableTitulos.removeColumn(this.tableTitulos.getColumnModel().getColumn(this.tableTitulos.getColumnCount() - 1));
        this.tableTitulos.setToolTipText("<html>Pressione DELETE para excluir o t\u00edtulo.<br>Pressione BARRA DE ESPA\u00c7O para editar o t\u00edtulo.</html>");
        TituloRenderer rendererTitulo = new TituloRenderer();
        this.tableTitulos.setDefaultRenderer(Object.class, rendererTitulo);
        this.scrollTitulos = new JScrollPane(this.tableTitulos);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelCodigo.setLabelFor(this.textCodigo);
        this.labelCodigo.setDisplayedMnemonic('d');
        this.panelAddTitulo.add((Component)this.labelCodigo, c);
        ++c.gridx;
        this.panelAddTitulo.add((Component)this.textCodigo, c);
        ++c.gridx;
        this.panelAddTitulo.add((Component)this.buttonAdicionarTitulo, c);
        ++c.gridx;
        this.panelAddTitulo.add(this.getPanelEspacamento(10, 20));
        ++c.gridx;
        this.panelAddTitulo.add((Component)this.buttonRemoverTodos, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelTipo.setLabelFor(this.comboTipo);
        this.labelTipo.setDisplayedMnemonic('T');
        this.painelCentral.add((Component)this.labelTipo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.comboTipo, c);
        c.insets = new Insets(1, 1, 2, 1);
        ++c.gridy;
        c.gridx = 0;
        this.labelTipoCadastro.setLabelFor(this.comboTipoCadastro);
        this.labelTipoCadastro.setDisplayedMnemonic('i');
        this.painelCentral.add((Component)this.labelTipoCadastro, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.comboTipoCadastro, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.getPanelEspacamento(10, 20), c);
        ++c.gridx;
        this.labelCodigoCadastro.setLabelFor(this.textCodigoCadastro);
        this.labelCodigoCadastro.setDisplayedMnemonic('a');
        this.painelCentral.add((Component)this.labelCodigoCadastro, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigoCadastro, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.buttonBuscaCadastro, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.fill = 2;
        this.painelCentral.add((Component)this.labelCadastro, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 7;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(2, 1, 2, 1);
        this.painelCentral.add((Component)this.panelTitulosAgrupados, c);
        ++c.gridy;
        c.weighty = 0.0;
        this.painelCentral.add((Component)this.panelTituloAgrupador, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.pnlLegenda, c);
        c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 0;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        this.panelTitulosAgrupados.add((Component)this.panelAddTitulo, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 7;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelTitulosAgrupados.add((Component)this.scrollTitulos, c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 0.0;
        this.panelTitulosAgrupados.add((Component)this.totalizadorTitulos, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelTituloAgrupador.add((Component)this.detalhesAgrupador, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        c.weightx = 0.0;
        this.panelTituloAgrupador.add((Component)this.buttonEditarAgrupador, c);
        this.pnlLegenda = FinanceiroUtil.montaPanelLegenda(this.pnlLegenda);
        this.controlaCampos();
    }

    private void alteraTituloAgrupadoSelecionado() {
        int row = this.tableTitulos.getSelectedRow();
        if (row >= 0) {
            ReceberPagarBean auxBean = (ReceberPagarBean)this.modelTitulos.getValueAt(row, this.modelTitulos.findColumn("Objeto"));
            int indiceArray = this.titulos.indexOf(auxBean);
            boolean isInserir = auxBean.isInserir();
            auxBean.setSituacao("G");
            auxBean = ReceberPagar.novaInstanciaDialog(Laboratorio.getInstancia(), auxBean, "T\u00edtulo Original", this.beanAgrupador == null || this.beanAgrupador.getSituacao().equalsIgnoreCase("A") && Acesso.getAcesso(ACESSO_ALTERAR_RECEBERPAGAR), 3);
            if (auxBean != null) {
                auxBean.setInserir(isInserir);
                FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)auxBean);
                this.titulos.set(indiceArray, auxBean);
            }
            this.popularTitulos();
            ReceberPagarBean bean = this.gerarTituloAgrupador();
            if (bean != null) {
                this.adicionarTituloAgrupador(bean);
            }
        }
    }

    private void alteraTituloAgrupador() {
        if (this.beanAgrupador != null) {
            ReceberPagarBean aux = ReceberPagar.novaInstanciaDialog(Laboratorio.getInstancia(), this.beanAgrupador, "T\u00edtulo Agrupador", this.beanAgrupador.getSituacao().equalsIgnoreCase("A") && Acesso.getAcesso(ACESSO_ALTERAR_RECEBERPAGAR), 1);
            if (aux != null) {
                this.beanAgrupador = aux;
                if (aux.getCamposAlterados().size() > 0) {
                    aux.setAlterar(true);
                }
                FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)this.beanAgrupador);
            }
            this.popularTituloAgrupador();
        }
    }

    private void removerTodosTitulos() {
        for (int row = 0; row < this.tableTitulos.getRowCount(); ++row) {
            ReceberPagarBean auxBean = (ReceberPagarBean)this.modelTitulos.getValueAt(row, this.modelTitulos.findColumn("Objeto"));
            auxBean.setRemover(true);
        }
        this.popularTitulos();
        this.removerTituloAgrupador();
    }

    private void removerTituloAgrupadoSelecionado() {
        int row = this.tableTitulos.getSelectedRow();
        if (row >= 0) {
            ReceberPagarBean auxBean = (ReceberPagarBean)this.modelTitulos.getValueAt(row, this.modelTitulos.findColumn("Objeto"));
            auxBean.setRemover(true);
            this.popularTitulos();
            if (this.getQtdeTitulos() > 0) {
                ReceberPagarBean bean = this.gerarTituloAgrupador();
                if (bean != null) {
                    this.adicionarTituloAgrupador(bean);
                }
            } else {
                this.removerTituloAgrupador();
            }
        }
    }

    private int getQtdeTitulos() {
        int qtde = 0;
        Iterator<ReceberPagarBean> it = this.titulos.iterator();
        while (it.hasNext()) {
            if (it.next().isRemover()) continue;
            ++qtde;
        }
        return qtde;
    }

    private void removerTituloAgrupador() {
        this.gerarTituloAgrupador();
        this.popularTituloAgrupador();
        this.controlaCampos();
    }

    private JLabel getPanelEspacamento(int width, int height) {
        JLabel aux = new JLabel();
        Dimension d = new Dimension(width, height);
        aux.setPreferredSize(d);
        aux.setMinimumSize(d);
        return aux;
    }

    @Override
    protected void controlaCampos() {
        boolean haTitulos = false;
        for (ReceberPagarBean aux : this.titulos) {
            if (aux.isRemover()) continue;
            haTitulos = true;
            break;
        }
        this.comboTipo.setEnabled((this.getStatus() == 2 || this.getStatus() == 3) && !haTitulos && this.beanAgrupador == null);
        this.comboTipoCadastro.setEnabled((this.getStatus() == 2 || this.getStatus() == 3) && !haTitulos && this.beanAgrupador == null);
        this.textCodigoCadastro.setEnabled((this.getStatus() == 2 || this.getStatus() == 3) && !haTitulos && this.beanAgrupador == null);
        this.buttonBuscaCadastro.setEnabled((this.getStatus() == 2 || this.getStatus() == 3) && !haTitulos && this.beanAgrupador == null);
        this.textCodigo.setEnabled((this.getStatus() == 2 || this.getStatus() == 3) && this.configCadastro == 1);
        this.buttonAdicionarTitulo.setEnabled((this.getStatus() == 2 || this.getStatus() == 3) && this.configCadastro == 1);
        this.buttonRemoverTodos.setEnabled((this.getStatus() == 2 || this.getStatus() == 3) && haTitulos);
        this.buttonEditarAgrupador.setEnabled((this.getStatus() == 2 || this.getStatus() == 3) && this.beanAgrupador != null && Acesso.getAcesso(ACESSO_ACESSAR_RECEBERPAGAR));
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        AgrupamentoBean bean = new AgrupamentoBean();
        HashSet<ReceberPagarBean> setTitulos = new HashSet<ReceberPagarBean>();
        bean.setAgrupador(this.beanAgrupador);
        for (int i = 0; i < this.titulos.size(); ++i) {
            setTitulos.add(this.titulos.get(i));
        }
        bean.setTitulosOriginais(setTitulos);
        return bean;
    }

    @Override
    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    protected void limparCampos() {
        this.comboTipo.setSelectedIndex(0);
        this.comboTipoCadastro.setSelectedIndex(0);
        this.textCodigoCadastro.setText("");
        this.labelCadastro.setText("");
        this.textCodigo.setText("");
        this.titulos.clear();
        this.beanAgrupador = null;
        this.popularTitulos();
        this.popularTituloAgrupador();
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        Hashtable titulos = Pesquisas.tituloAgrupador(Laboratorio.getInstancia());
        AgrupamentoBean bean = null;
        if (titulos != null) {
            try {
                bean = (AgrupamentoBean)new AgrupamentoService().get(Variaveis.filialPadrao, String.valueOf(titulos.get("rpg_codigo")));
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar Agrupamento.", e.getStackTrace());
            }
        }
        return bean;
    }

    private void pesquisaCadastro(String tipoCadastro, String codigoCadastro) {
        block7: {
            if (tipoCadastro != null && codigoCadastro != null && !Funcoes.textoVazio(tipoCadastro) && !Funcoes.textoVazio(codigoCadastro)) {
                try {
                    if (tipoCadastro.equalsIgnoreCase("O")) {
                        ConvenioVO convenio = (ConvenioVO)this.convenioService.getVO(Variaveis.filialPadrao, codigoCadastro);
                        this.textCodigoCadastro.setText(Integer.toString(convenio.getCodigo()));
                        this.labelCadastro.setText(convenio.getFantasia());
                    } else if (tipoCadastro.equalsIgnoreCase("P")) {
                        PacienteVO paciente = (PacienteVO)this.pacienteService.getVO(Variaveis.filialPadrao, codigoCadastro);
                        this.textCodigoCadastro.setText(Integer.toString(paciente.getCodigo()));
                        this.labelCadastro.setText(paciente.getNome());
                    } else {
                        EntidadeBean entidade = (EntidadeBean)this.entidadeService.get(Variaveis.filialPadrao, codigoCadastro, Tipos.getTipoCadastro((String)this.comboTipoCadastro.getSelectedItem()));
                        this.textCodigoCadastro.setText(Integer.toString(entidade.getCodigo()));
                        this.labelCadastro.setText(entidade.getFantasia());
                    }
                }
                catch (Exception e) {
                    Funcoes.mensagem(this, "Cadastro n\u00e3o encontrado.", 2);
                    this.textCodigoCadastro.setText("");
                    this.textCodigoCadastro.selectAll();
                    if (!this.textCodigoCadastro.isFocusable()) break block7;
                    this.textCodigoCadastro.grabFocus();
                }
            }
        }
    }

    private void pesquisaCadastro() {
        try {
            this.textCodigoCadastro.setText("");
            this.labelCadastro.setText("");
            if (this.comboTipo.getSelectedIndex() < 0) {
                return;
            }
            String tipo = this.getTipoCadastroSelecionado();
            if (tipo.equalsIgnoreCase("O")) {
                ConvenioVO convenio = (ConvenioVO)this.convenioService.pesquisaVO(this.getTopLevelAncestor(), new ConvenioVO(), "Pesquisando Conv\u00eanios", true);
                if (convenio != null) {
                    this.textCodigoCadastro.setText(Integer.toString(convenio.getCodigo()));
                    this.labelCadastro.setText(convenio.getFantasia());
                }
            } else if (tipo.equalsIgnoreCase("P")) {
                PacienteVO paciente = (PacienteVO)this.pacienteService.pesquisaVO(this.getTopLevelAncestor(), new PacienteVO(), "Pesquisando Pacientes", true);
                if (paciente != null) {
                    this.textCodigoCadastro.setText(Integer.toString(paciente.getCodigo()));
                    this.labelCadastro.setText(paciente.getNome());
                }
            } else {
                String titulo = "";
                int tipoTelaModulo = 4;
                if (tipo.equalsIgnoreCase("C")) {
                    titulo = "Pesquisando Coletadores";
                    tipoTelaModulo = 3;
                } else if (tipo.equalsIgnoreCase("F")) {
                    titulo = "Pesquisando Fornecedores";
                    tipoTelaModulo = 1;
                } else if (tipo.equalsIgnoreCase("U")) {
                    titulo = "Pesquisando Funcion\u00e1rios";
                    tipoTelaModulo = 2;
                } else {
                    titulo = "Pesquisando Representantes";
                }
                EntidadeVO entidade = (EntidadeVO)this.entidadeService.pesquisaVO((Object)this.getTopLevelAncestor(), (AbstractThreadVO)new EntidadeVO(), titulo, tipoTelaModulo, tipo, true);
                if (entidade != null) {
                    if (!entidade.getTipo().equalsIgnoreCase(tipo)) {
                        this.labelCadastro.setText("N\u00e3o cadastrado");
                    } else {
                        this.textCodigoCadastro.setText(Integer.toString(entidade.getCodigo()));
                        this.labelCadastro.setText(entidade.getFantasia());
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ReceberPagar:1061");
        }
    }

    private String getTipoCadastroSelecionado() {
        String tipo = (String)this.comboTipoCadastro.getSelectedItem();
        if (tipo.equalsIgnoreCase(Tipos.tipoCadastro("U"))) {
            return "U";
        }
        if (tipo.equalsIgnoreCase(Tipos.tipoCadastro("F"))) {
            return "F";
        }
        if (tipo.equalsIgnoreCase(Tipos.tipoCadastro("C"))) {
            return "C";
        }
        if (tipo.equalsIgnoreCase(Tipos.tipoCadastro("R"))) {
            return "R";
        }
        if (tipo.equalsIgnoreCase(Tipos.tipoCadastro("P"))) {
            return "P";
        }
        return "O";
    }

    private ReceberPagarBean pesquisaTituloAgrupador() {
        String tipoReceberPagar = "";
        String tipoCadastro = "";
        ReceberPagarBean recPag = null;
        tipoReceberPagar = Tipos.getTipoReceberPagar((String)this.comboTipo.getSelectedItem());
        tipoCadastro = this.getTipoCadastroSelecionado();
        String codigoCadastro = this.textCodigoCadastro.getText();
        Hashtable hash = Pesquisas.titulo(Laboratorio.getInstancia(), tipoReceberPagar, tipoCadastro, codigoCadastro, "A", true);
        if (hash != null) {
            String codigoRecPag = String.valueOf((Integer)hash.get("rpg_codigo"));
            try {
                recPag = (ReceberPagarBean)new ReceberPagarService().get(Variaveis.filialPadrao, codigoRecPag);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar receber/pagar.", e.getStackTrace());
                return null;
            }
            for (int i = 0; i < this.titulos.size(); ++i) {
                ReceberPagarBean aux = this.titulos.get(i);
                if (!aux.getCodigo().equals(recPag.getCodigo())) continue;
                Funcoes.mensagem(this, "O Receber/Pagar selecionado est\u00e1 na lista de t\u00edtulos originais.\nSelecione outro t\u00edtulo ou gere um novo para agrupar os t\u00edtulos originais.", 2);
                return null;
            }
            return recPag;
        }
        return null;
    }

    private ReceberPagarBean pesquisaTituloCodigo(String codigoRecPag) {
        if (codigoRecPag != null && !Funcoes.textoVazio(codigoRecPag)) {
            StringBuilder bufWhere = new StringBuilder();
            String tipoRecPag = Tipos.getTipoReceberPagar((String)this.comboTipo.getSelectedItem());
            String tipoCadastro = this.getTipoCadastroSelecionado();
            String codigoCadastro = this.textCodigoCadastro.getText();
            ReceberPagarBean bean = null;
            bufWhere.append(" and rpg_situacao = '").append("A").append("' ");
            bufWhere.append(" and rpg_tipo = '").append(tipoRecPag).append("' ");
            bufWhere.append(" and rpg_tipocadastro = '").append(this.getTipoCadastroSelecionado()).append("' ");
            if (tipoCadastro.equalsIgnoreCase("O")) {
                bufWhere.append(" and con_codigo = ").append(codigoCadastro);
            } else if (tipoCadastro.equalsIgnoreCase("P")) {
                bufWhere.append(" and pac_codigo = ").append(codigoCadastro);
            } else {
                bufWhere.append(" and ent_codigo = ").append(codigoCadastro);
            }
            try {
                bean = (ReceberPagarBean)new ReceberPagarDao().getBean(Variaveis.filialPadrao, codigoRecPag, bufWhere.toString());
            }
            catch (ThreadDaoException e) {
                Funcoes.mensagem(this, "O t\u00edtulo n\u00e3o foi encontrado.", 2);
                return bean;
            }
            if (bean == null) {
                Funcoes.mensagem(this, "O t\u00edtulo n\u00e3o foi encontrado.", 2);
                return null;
            }
            return bean;
        }
        return null;
    }

    private ReceberPagarBean gerarTituloAgrupador() {
        int i;
        ReceberPagarBean bean = null;
        bean = this.beanAgrupador != null ? this.beanAgrupador : new ReceberPagarBean();
        String tipoCadastro = "";
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        bean.setInserir(true);
        bean.setFilial(filial);
        bean.setUsuario(usuario);
        bean.setSituacao("A");
        bean.setOrigem("R");
        bean.setTipo(Tipos.getTipoReceberPagar((String)this.comboTipo.getSelectedItem()));
        if (bean.getTipoDocumento() == null) {
            bean.setTipoDocumento("D");
        }
        bean.setParcela(1);
        StringBuilder buf = new StringBuilder();
        buf.append("Gerado pelo Agrupamento dos T\u00edtulos -> C\u00f3d:(");
        ArrayList<Integer> codigos = new ArrayList<Integer>();
        for (i = 0; i < this.titulos.size(); ++i) {
            ReceberPagarBean auxBean = this.titulos.get(i);
            codigos.add(auxBean.getCodigo());
        }
        Collections.sort(codigos);
        for (i = 0; i < codigos.size(); ++i) {
            buf.append(codigos.get(i));
            if (i >= codigos.size() - 1) continue;
            buf.append(",");
        }
        buf.append(") Fil: ");
        buf.append(bean.getFilial().getCodigo());
        bean.setObservacao(buf.toString());
        tipoCadastro = this.getTipoCadastroSelecionado();
        bean.setTipoCadastro(tipoCadastro);
        try {
            if (tipoCadastro.equalsIgnoreCase("O")) {
                ConvenioVO convenio = (ConvenioVO)this.convenioService.getVO(String.valueOf(Variaveis.filialPadrao), this.textCodigoCadastro.getText());
                bean.setConvenio(convenio);
            } else if (tipoCadastro.equalsIgnoreCase("P")) {
                PacienteVO paciente = (PacienteVO)this.pacienteService.getVO(String.valueOf(Variaveis.filialPadrao), this.textCodigoCadastro.getText());
                bean.setPaciente(paciente);
            } else {
                EntidadeVO entidade = (EntidadeVO)this.entidadeService.getVO(String.valueOf(Variaveis.filialPadrao), this.textCodigoCadastro.getText());
                bean.setEntidade(entidade);
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do cadastro.", 2);
            return null;
        }
        boolean seriesIguais = true;
        SeriesVO serie = null;
        for (int i2 = 0; i2 < this.titulos.size(); ++i2) {
            ReceberPagarBean aux = this.titulos.get(i2);
            if (aux.isRemover()) continue;
            if (serie != null) {
                if (serie.getCodigo() == aux.getSerie().getCodigo()) continue;
                seriesIguais = false;
                break;
            }
            serie = aux.getSerie();
        }
        if (seriesIguais && serie != null) {
            bean.setSerie(serie);
        }
        Date auxDataDocumento = null;
        Date auxDataProcessamento = null;
        Date auxDataCompetencia = null;
        Date auxDataVencimento = null;
        for (int i3 = 0; i3 < this.titulos.size(); ++i3) {
            ReceberPagarBean aux = this.titulos.get(i3);
            if (aux.isRemover()) continue;
            if (bean.getDataDocumento() == null) {
                if (auxDataDocumento == null) {
                    auxDataDocumento = aux.getDataDocumento();
                } else if (auxDataDocumento.before(aux.getDataDocumento())) {
                    auxDataDocumento = aux.getDataDocumento();
                }
            }
            if (bean.getDataProcessamento() == null) {
                if (auxDataProcessamento == null) {
                    auxDataProcessamento = aux.getDataProcessamento();
                } else if (auxDataProcessamento.before(aux.getDataProcessamento())) {
                    auxDataProcessamento = aux.getDataProcessamento();
                }
            }
            if (bean.getDataCompetencia() == null) {
                if (auxDataCompetencia == null) {
                    auxDataCompetencia = aux.getDataCompetencia();
                } else if (auxDataCompetencia.before(aux.getDataCompetencia())) {
                    auxDataCompetencia = aux.getDataCompetencia();
                }
            }
            if (bean.getDataVencimento() != null) continue;
            if (auxDataVencimento == null) {
                auxDataVencimento = aux.getDataVencimento();
                continue;
            }
            if (!auxDataVencimento.before(aux.getDataVencimento())) continue;
            auxDataVencimento = aux.getDataVencimento();
        }
        if (auxDataDocumento != null) {
            bean.setDataDocumento(auxDataDocumento);
        }
        if (auxDataProcessamento != null) {
            bean.setDataProcessamento(auxDataProcessamento);
        }
        if (auxDataCompetencia != null) {
            bean.setDataCompetencia(auxDataCompetencia);
        }
        if (auxDataVencimento != null) {
            bean.setDataVencimento(auxDataVencimento);
        }
        BigDecimal auxValorBruto = BigDecimal.ZERO;
        BigDecimal auxValorLiquido = BigDecimal.ZERO;
        BigDecimal auxValorTaxa = BigDecimal.ZERO;
        BigDecimal auxValorJuro = BigDecimal.ZERO;
        BigDecimal auxValorDesconto = BigDecimal.ZERO;
        BigDecimal auxValorAcrescimo = BigDecimal.ZERO;
        BigDecimal auxValorMulta = BigDecimal.ZERO;
        BigDecimal auxIrrf = BigDecimal.ZERO;
        BigDecimal auxIss = BigDecimal.ZERO;
        BigDecimal auxPis = BigDecimal.ZERO;
        BigDecimal auxCsll = BigDecimal.ZERO;
        BigDecimal auxCofins = BigDecimal.ZERO;
        BigDecimal auxInss = BigDecimal.ZERO;
        for (int i4 = 0; i4 < this.titulos.size(); ++i4) {
            ReceberPagarBean aux = this.titulos.get(i4);
            if (aux.isRemover()) continue;
            auxValorBruto = auxValorBruto.add(new BigDecimal(aux.getValor() == null ? 0.0 : aux.getValor()));
            auxValorLiquido = auxValorLiquido.add(new BigDecimal(aux.getValorTotal() == null ? 0.0 : aux.getValorTotal()));
            auxValorTaxa = auxValorTaxa.add(new BigDecimal(aux.getTaxa() == null ? 0.0 : aux.getTaxa()));
            auxValorJuro = auxValorJuro.add(new BigDecimal(aux.getValorJuro() == null ? 0.0 : aux.getValorJuro()));
            auxValorDesconto = auxValorDesconto.add(new BigDecimal(aux.getValorDesconto() == null ? 0.0 : aux.getValorDesconto()));
            auxValorAcrescimo = auxValorAcrescimo.add(new BigDecimal(aux.getValorAcrescimo() == null ? 0.0 : aux.getValorAcrescimo()));
            auxValorMulta = auxValorMulta.add(new BigDecimal(aux.getValorMulta() == null ? 0.0 : aux.getValorMulta()));
            auxIrrf = auxIrrf.add(new BigDecimal(aux.getIrrfValor() == null ? 0.0 : aux.getIrrfValor()));
            auxIss = auxIss.add(new BigDecimal(aux.getIssValor() == null ? 0.0 : aux.getIssValor()));
            auxPis = auxPis.add(new BigDecimal(aux.getPisValor() == null ? 0.0 : aux.getPisValor()));
            auxCsll = auxCsll.add(new BigDecimal(aux.getCsllValor() == null ? 0.0 : aux.getCsllValor()));
            auxCofins = auxCofins.add(new BigDecimal(aux.getCofinsValor() == null ? 0.0 : aux.getCofinsValor()));
            auxInss = auxInss.add(new BigDecimal(aux.getInssValor() == null ? 0.0 : aux.getInssValor()));
        }
        bean.setValor(auxValorBruto.setScale(2, RoundingMode.HALF_UP).doubleValue());
        bean.setValorTotal(auxValorLiquido.setScale(2, RoundingMode.HALF_UP).doubleValue());
        bean.setTaxa(auxValorTaxa.setScale(2, RoundingMode.HALF_UP).doubleValue());
        bean.setValorJuro(auxValorJuro.setScale(2, RoundingMode.HALF_UP).doubleValue());
        bean.setValorDesconto(auxValorDesconto.setScale(2, RoundingMode.HALF_UP).doubleValue());
        bean.setValorAcrescimo(auxValorAcrescimo.setScale(2, RoundingMode.HALF_UP).doubleValue());
        bean.setValorMulta(auxValorMulta.setScale(2, RoundingMode.HALF_UP).doubleValue());
        bean.setIrrfValor(auxIrrf.setScale(2, RoundingMode.HALF_UP).doubleValue());
        bean.setIssValor(auxIss.setScale(2, RoundingMode.HALF_UP).doubleValue());
        bean.setPisValor(auxPis.setScale(2, RoundingMode.HALF_UP).doubleValue());
        bean.setCsllValor(auxCsll.setScale(2, RoundingMode.HALF_UP).doubleValue());
        bean.setCofinsValor(auxCofins.setScale(2, RoundingMode.HALF_UP).doubleValue());
        bean.setInssValor(auxInss.setScale(2, RoundingMode.HALF_UP).doubleValue());
        FinanceiroUtil.calculaPercentualImposto(bean);
        FinanceiroUtil.calculaPercentuais(bean);
        PanelPlanoContaCentroCusto pnlPlanoCentro = null;
        pnlPlanoCentro = new PanelPlanoContaCentroCusto(bean, PanelPlanoContaCentroCusto.TIPO_RECEBER_PAGAR, 0L, 0L, bean.getFilial().getCodigo().toString());
        pnlPlanoCentro.setPlanoContas(bean.getPlanosContas());
        pnlPlanoCentro.setCentrosCusto(bean.getCentrosCusto());
        pnlPlanoCentro.removerTodosPlanosContas();
        pnlPlanoCentro.removerTodosCentrosCusto();
        for (int i5 = 0; i5 < this.titulos.size(); ++i5) {
            if (this.titulos.get(i5).isRemover()) continue;
            FinanceiroUtil.copiaPlanoConta(this.titulos.get(i5), (AbstractThreadBean)bean, pnlPlanoCentro);
            FinanceiroUtil.copiaCentroCusto(this.titulos.get(i5), (AbstractThreadBean)bean, pnlPlanoCentro);
        }
        return bean;
    }

    private void pesquisaTitulosAgrupados() {
        try {
            List<HashMap<String, Object>> titulos = null;
            String tipoRecPag = "";
            String tipoCadastro = "";
            if (Funcoes.textoVazio(this.textCodigoCadastro)) {
                Funcoes.mensagem(this, "Selecione um cadastro antes de buscar os t\u00edtulos.", 2);
                ScreenUtil.requisitarFoco(this.textCodigoCadastro);
                return;
            }
            tipoRecPag = this.comboTipo.getSelectedItem().equals(Tipos.tipoReceberPagar("R")) ? "R" : "P";
            tipoCadastro = Tipos.getTipoCadastro((String)this.comboTipoCadastro.getSelectedItem());
            DialogoFiltro diag = new DialogoFiltro(Laboratorio.getInstancia(), tipoRecPag, tipoCadastro, this.textCodigoCadastro.getText());
            diag.setVisible(true);
            if (diag.getOk() && (titulos = diag.getTitulosAbertosSelecionados()) != null) {
                Iterator<HashMap<String, Object>> it = titulos.iterator();
                if (!titulos.isEmpty()) {
                    this.janelaEspera = SplashMensagem.getInstancia(this);
                    this.janelaEspera.mostrar("Adicionando t\u00edtulos");
                    int i = 0;
                    int qtde = titulos.size();
                    while (it.hasNext()) {
                        HashMap<String, Object> hash = it.next();
                        this.janelaEspera.setText("Adicionando t\u00edtulos - " + (int)Funcoes.arredondar(++i * 100 / qtde, 2) + "%");
                        ReceberPagarBean titulo = (ReceberPagarBean)new ReceberPagarDao().getBean(Variaveis.filialPadrao, String.valueOf(hash.get("C\u00f3digo")));
                        if (titulo == null || !this.validaTitulo(titulo)) continue;
                        this.adicionarTitulo(titulo);
                    }
                    this.janelaEspera.apagar();
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "AgrupamentoReceberPagar:pesquisar:518");
        }
    }

    private void adicionarTitulo(ReceberPagarBean titulo) {
        if (this.titulos.contains(titulo)) {
            for (ReceberPagarBean aux : this.titulos) {
                if (!aux.isRemover()) continue;
                aux.setRemover(false);
                break;
            }
            this.popularTitulos();
            ReceberPagarBean bean = this.gerarTituloAgrupador();
            if (bean != null) {
                this.adicionarTituloAgrupador(bean);
            }
            return;
        }
        if (this.beanAgrupador != null && titulo.getCodigo().equals(this.beanAgrupador.getCodigo())) {
            this.janelaEspera.apagar();
            Funcoes.mensagem(Laboratorio.getInstancia(), "O t\u00edtulo selecionado j\u00e1 foi inserido como t\u00edtulo agrupador.\nN\u00e3o \u00e9 poss\u00edvel inserir o t\u00edtulo na lista de t\u00edtulos originais.", 2);
            return;
        }
        try {
            FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)titulo);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "AgrupamentoReceberPagar:adicionarTitulo:544");
        }
        this.titulos.add(titulo);
        titulo.setInserir(true);
        ReceberPagarBean bean = this.gerarTituloAgrupador();
        if (bean != null) {
            this.adicionarTituloAgrupador(bean);
        }
        this.popularTitulos();
        this.comboTipo.setEnabled(false);
        this.textCodigo.setText("");
        if (this.textCodigo.isFocusable()) {
            this.textCodigo.grabFocus();
        }
        this.controlaCampos();
    }

    private void adicionarTituloAgrupador(ReceberPagarBean titulo) {
        if (titulo.getCodigo() != null && this.titulos.contains(titulo)) {
            Funcoes.mensagem(this, "O Receber/Pagar selecionado est\u00e1 na lista de t\u00edtulos originais.\nSelecione outro t\u00edtulo ou gere um novo para agrupar os t\u00edtulos originais.", 2);
            return;
        }
        this.beanAgrupador = titulo;
        try {
            titulo.setSituacao("A");
            FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)titulo);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "AgrupamentoReceberPagar:adicionarTitulo:544");
        }
        this.popularTituloAgrupador();
        this.controlaCampos();
    }

    private void popularTituloAgrupador() {
        if (this.beanAgrupador != null) {
            this.detalhesAgrupador.setValores(this.beanAgrupador.getCodigo(), Tipos.tipoDocumento(this.beanAgrupador.getTipoDocumento()), this.beanAgrupador.getNumeroDocumento(), this.beanAgrupador.getDataVencimento(), this.beanAgrupador.getValor(), this.beanAgrupador.getValorTotal());
        } else {
            this.detalhesAgrupador.limparDetalhes();
        }
    }

    private void popularTitulos() {
        BigDecimal somaLiquido = BigDecimal.ZERO;
        BigDecimal somaBruto = BigDecimal.ZERO;
        int qtdeTitulos = 0;
        while (this.modelTitulos.getRowCount() > 0) {
            this.modelTitulos.removeLine(0);
        }
        for (ReceberPagarBean titulo : this.titulos) {
            if (titulo.isRemover()) continue;
            ++qtdeTitulos;
            somaBruto = somaBruto.add(new BigDecimal(titulo.getValor() == null ? "0" : titulo.getValor().toString()).setScale(2, RoundingMode.HALF_UP));
            somaLiquido = somaLiquido.add(new BigDecimal(titulo.getValorTotal() == null ? "0" : titulo.getValorTotal().toString()).setScale(2, RoundingMode.HALF_UP));
            this.modelTitulos.addLine(new Object[]{Tipos.tipoDocumento(titulo.getTipoDocumento()), titulo.getNumeroDocumento(), titulo.getParcela() + " ", titulo.getObservacao(), Funcoes.formataData("dd/MM/yyyy", titulo.getDataVencimento()), Funcoes.formataDecimal(titulo.getValor()), titulo.getValorTotal() == null ? "" : Funcoes.formataDecimal(titulo.getValorTotal()), titulo});
        }
        somaBruto = somaBruto.setScale(2, RoundingMode.HALF_UP);
        somaLiquido = somaLiquido.setScale(2, RoundingMode.HALF_UP);
        if (this.totalizadorTitulos != null) {
            this.totalizadorTitulos.setValores(qtdeTitulos, somaBruto, somaLiquido);
        }
    }

    private boolean validaTitulo(ReceberPagarBean titulo) {
        boolean erro = false;
        if (titulo.getSituacao() != null && !titulo.getSituacao().equalsIgnoreCase("A")) {
            Funcoes.mensagem(this, "Somente t\u00edtulos com situa\u00e7\u00e3o 'Aberto' podem ser agrupados.\nA situa\u00e7\u00e3o do t\u00edtulo \u00e9: '" + Tipos.tipoSituacaoReceberPagar(titulo.getSituacao()) + "'.", 2);
            erro = true;
        }
        if (erro) {
            this.textCodigo.selectAll();
            if (this.textCodigo.isFocusable()) {
                this.textCodigo.grabFocus();
            }
            return false;
        }
        return true;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        AgrupamentoBean beanAgrup = null;
        ReceberPagarBean agrupador = null;
        Set<ReceberPagarBean> titulos = null;
        if (bean == null) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "AgrupamentoReceberPagar:preencherCampos", null);
            return;
        }
        if (!(bean instanceof AgrupamentoBean)) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Tipo incorreto. AgrupamentoReceberPagar:preencherCampos", null);
            return;
        }
        beanAgrup = (AgrupamentoBean)bean;
        agrupador = beanAgrup.getAgrupador();
        titulos = beanAgrup.getTitulosOriginais();
        if (agrupador == null) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Agrupador n\u00e3o configurado. AgrupamentoReceberPagar:preencherCampos", null);
            return;
        }
        if (titulos == null) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "T\u00edtulos originais n\u00e3o configurados. AgrupamentoReceberPagar:preencherCampos", null);
            return;
        }
        this.comboTipo.setSelectedItem(Tipos.tipoReceberPagar(agrupador.getTipo()));
        this.comboTipoCadastro.setSelectedItem(Tipos.tipoCadastro(agrupador.getTipoCadastro()));
        if (agrupador.getTipoCadastro().equalsIgnoreCase("P")) {
            this.textCodigoCadastro.setText(String.valueOf(agrupador.getPaciente().getCodigo()));
            this.labelCadastro.setText(agrupador.getPaciente().getNome());
        } else if (agrupador.getTipoCadastro().equalsIgnoreCase("O")) {
            this.textCodigoCadastro.setText(String.valueOf(agrupador.getConvenio().getCodigo()));
            this.labelCadastro.setText(agrupador.getConvenio().getFantasia());
        } else {
            this.textCodigoCadastro.setText(String.valueOf(agrupador.getEntidade().getCodigo()));
            this.labelCadastro.setText(agrupador.getEntidade().getRazaoSocial());
        }
        for (ReceberPagarBean beanAux : titulos) {
            FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)beanAux);
            this.titulos.add(beanAux);
        }
        this.beanAgrupador = agrupador;
        FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)agrupador);
        this.configCadastro = 1;
        this.popularTitulos();
        this.popularTituloAgrupador();
    }

    @Override
    public boolean validaCampos() {
        int resp;
        int i;
        boolean isErrado = false;
        if (this.getQtdeTitulos() <= 0) {
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 t\u00edtulos Originais para serem agrupados.", 2);
            return false;
        }
        if (this.getQtdeTitulos() == 1) {
            Funcoes.mensagem(this, "H\u00e1 somente um t\u00edtulo Original para ser agrupado.\nO Agrupamento deve conter mais de um t\u00edtulo Original.", 2);
            return false;
        }
        if (this.beanAgrupador == null) {
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 t\u00edtulo Agrupador.", 2);
            return false;
        }
        if (this.beanAgrupador.getSerie() == null) {
            Funcoes.mensagem(this, "A S\u00e9rie do t\u00edtulo Agrupador n\u00e3o foi configurada.\nConfigure a S\u00e9rie antes de salvar.", 2);
            return false;
        }
        BigDecimal somaTitulos = BigDecimal.ZERO;
        for (i = 0; i < this.titulos.size(); ++i) {
            if (this.titulos.get(i).isRemover()) continue;
            somaTitulos = somaTitulos.add(new BigDecimal(this.titulos.get(i).getValorTotal()));
        }
        if ((somaTitulos = somaTitulos.setScale(2, RoundingMode.HALF_UP)).doubleValue() != this.beanAgrupador.getValorTotal().doubleValue() && (resp = Funcoes.mensagem(this, "O Valor Total do t\u00edtulo Agrupador n\u00e3o coincide com o somat\u00f3rio do Valor Total dos t\u00edtulos originais.\nDeseja continuar?", 4)) == 1) {
            return false;
        }
        for (i = 0; i < this.titulos.size(); ++i) {
            if (this.titulos.get(i).isRemover() || !this.titulos.get(i).isPlanoContaErrado() && !this.titulos.get(i).isPlanoContaNaoConfigurado()) continue;
            isErrado = true;
            break;
        }
        if (isErrado && (resp = Funcoes.mensagem(this, "H\u00e1 algum t\u00edtulo Original com Plano de Contas errado ou n\u00e3o configurado.\nDeseja continuar?", 4)) == 1) {
            return false;
        }
        isErrado = false;
        for (i = 0; i < this.titulos.size(); ++i) {
            if (this.titulos.get(i).isRemover() || !this.titulos.get(i).isCentroCustoErrado() && !this.titulos.get(i).isCentroCustoNaoConfigurado()) continue;
            isErrado = true;
            break;
        }
        if (isErrado && (resp = Funcoes.mensagem(this, "H\u00e1 algum t\u00edtulo original com Centro de Custo errado ou n\u00e3o configurado.\nDeseja continuar?", 4)) == 1) {
            return false;
        }
        if ((this.beanAgrupador.isPlanoContaErrado() || this.beanAgrupador.isPlanoContaNaoConfigurado()) && (resp = Funcoes.mensagem(this, "O Plano de Contas do t\u00edtulo Agrupador est\u00e1 errado ou n\u00e3o configurado.\nDeseja continuar?", 4)) == 1) {
            return false;
        }
        return !this.beanAgrupador.isCentroCustoErrado() && !this.beanAgrupador.isCentroCustoNaoConfigurado() || (resp = Funcoes.mensagem(this, "O Centro de Custo do t\u00edtulo Agrupador est\u00e1 errado ou n\u00e3o configurado.\nDeseja continuar?", 4)) != 1;
    }

    @Override
    @Deprecated
    public AbstractThreadBean buscaBeanPreenchido(PanelPlanoContaCentroCusto source) {
        return null;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600410100");
    }

    @Override
    public void novo() {
        super.novo();
        if (this.comboTipo.isFocusable()) {
            this.comboTipo.grabFocus();
        }
    }

    @Override
    public void salvar(boolean limparCampos) {
        AbstractThreadBean bean;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                if (this.getStatus() == 2) {
                    new AgrupamentoService().insert(bean, Variaveis.filialPadrao, this.getCopiaFiliais());
                } else if (this.getStatus() == 3) {
                    new AgrupamentoService().update(bean, Variaveis.filialPadrao, this.getCopiaFiliais());
                }
                if (limparCampos) {
                    this.limparCampos();
                    this.setStatus(1);
                    this.controlaCampos();
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "AgrupamentoReceberPagar:salvar:1725");
            }
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        AbstractThreadBean bean = this.pesquisar();
        if (bean != null) {
            ReceberPagarBean beanAux = ((AgrupamentoBean)bean).getAgrupador();
            if (beanAux.getSituacao().equalsIgnoreCase("A")) {
                this.setStatus(3);
            } else {
                Funcoes.mensagem(this, "A situa\u00e7\u00e3o do T\u00edtulo Agrupador \u00e9: \"" + Tipos.tipoSituacaoReceberPagar(beanAux.getSituacao()) + "\".\nO Agrupamento n\u00e3o pode ser alterado.", 5);
                this.setStatus(5);
            }
            this.preencherCampos(bean);
            this.controlaCampos();
            this.textCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        final AgrupamentoBean bean = (AgrupamentoBean)this.pesquisar();
        if (bean != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AgrupamentoReceberPagar.this.preencherCampos(bean);
                    if (bean != null && bean.getAgrupador() != null && bean.getAgrupador().getSituacao() != null && !bean.getAgrupador().getSituacao().equalsIgnoreCase("A") && !bean.getAgrupador().getSituacao().equalsIgnoreCase("E")) {
                        Funcoes.mensagem(AgrupamentoReceberPagar.this, "O t\u00edtulo agrupador est\u00e1 com a situa\u00e7\u00e3o \"" + Tipos.tipoSituacaoReceberPagar(bean.getAgrupador().getSituacao()) + "\".\nO t\u00edtulo agrupador deve estar \"Aberto\" para que possa ser desagrupado.", 2);
                        AgrupamentoReceberPagar.this.limparCampos();
                        return;
                    }
                    if (Funcoes.mensagem(AgrupamentoReceberPagar.this, "Deseja desagrupar os t\u00edtulos?", 4) == 0) {
                        try {
                            new AgrupamentoService().delete(bean, Variaveis.filialPadrao, AgrupamentoReceberPagar.this.getCopiaFiliais());
                        }
                        catch (Exception e) {
                            ErrorLogger.mostraMensagem(AgrupamentoReceberPagar.this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "AgrupamentoReceberPagar:excluir:1849");
                        }
                    }
                    AgrupamentoReceberPagar.this.limparCampos();
                }
            });
        }
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(AgrupamentoReceberPagar.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0600410101"));
        this.setModuloEdita(Long.parseLong("0600410102"));
        this.setModuloApaga(Long.parseLong("0600410103"));
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    class DialogoFiltro
    extends JDialog
    implements ActionListener {
        private static final String SELECIONADO = "selecionado";
        private static final String CAMPO_VENCIMENTO = "Vencimento";
        private static final String CAMPO_EMISSAO = "Emiss\u00e3o";
        private static final String CAMPO_COMPETENCIA = "Compet\u00eancia";
        private static final String CAMPO_BANCO_VENCIMENTO = "rpg_vencimento";
        private static final String CAMPO_BANCO_EMISSAO = "rpg_datahora";
        private static final String CAMPO_BANCO_COMPETENCIA = "rpg_competencia";
        private JButton buttonConsultar;
        private JButton buttonDesmarcarTodos;
        private JButton buttonMarcarTodos;
        private JButton buttonOK;
        private JButton buttonCancelar;
        private JButton buttonDataVctoIni;
        private JButton buttonDataVctoFin;
        private TTextField textDataIni;
        private TTextField textDataFin;
        private TTextField textValorIni;
        private TTextField textValorFin;
        private TTextField textNumeroDoc;
        private JComboBox comboCampoData;
        private String tipoRecPag;
        private String tipoCadastro;
        private String codigoCadastro;
        private static final int POSICAO_CODIGO = 0;
        private static final int POSICAO_CODIGO_CADASTRO = 1;
        private static final int POSICAO_CADASTRO = 2;
        private static final int POSICAO_NUMERO_DOCUMENTO = 3;
        private static final int POSICAO_CAMPO_DATA = 4;
        private static final int POSICAO_VALOR_TOTAL = 5;
        private static final int POSICAO_SEL = 6;
        private JTable table;
        private ModeloGridTable modTit;
        private CheckItemFiltro itemPaciente;
        private CheckItemFiltro itemEntidade;
        private CheckItemFiltro itemConvenio;
        private boolean ok;

        public DialogoFiltro(Frame pai, String tipoReceberPagar, String tipoCadastro, String codigoCadastro) {
            super(pai, "Pesquisando Receber/Pagar", true);
            this.buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'n', this);
            this.buttonDesmarcarTodos = ComponenteFactory.novoJButton("Desmarcar Todos", 'D', this);
            this.buttonMarcarTodos = ComponenteFactory.novoJButton("Selecionar Todos", 'S', this);
            this.buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
            this.buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
            this.buttonDataVctoIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
            this.buttonDataVctoFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
            this.textDataIni = new TTextField(0, 4);
            this.textDataFin = new TTextField(0, 4);
            this.textValorIni = new TTextField(0, 2);
            this.textValorFin = new TTextField(0, 2);
            this.textNumeroDoc = new TTextField(40, 3);
            this.comboCampoData = new JComboBox<Object>(new Object[]{CAMPO_VENCIMENTO, CAMPO_EMISSAO, CAMPO_COMPETENCIA});
            this.tipoRecPag = "";
            this.tipoCadastro = "";
            this.codigoCadastro = "";
            this.table = null;
            this.modTit = new ModeloGridTable(new String[]{"C\u00f3digo", "C\u00f3d. Cad.", "Cadastro", "N\u00fam. Doc.", CAMPO_VENCIMENTO, "Valor Total", "Sel"}){

                @Override
                public boolean isCellEditable(int row, int col) {
                    return col == this.getColumnCount() - 1;
                }

                public Class getColumnClass(int c) {
                    if (c == this.getColumnCount() - 1) {
                        return Boolean.class;
                    }
                    return super.getColumnClass(c);
                }
            };
            this.tipoRecPag = tipoReceberPagar;
            this.tipoCadastro = tipoCadastro;
            this.codigoCadastro = codigoCadastro;
            this.iniciar();
        }

        public DialogoFiltro(Dialog pai, String tipoReceberPagar, String tipoCadastro, String codigoCadastro) {
            super(pai, "Pesquisando Receber/Pagar", true);
            this.buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'n', this);
            this.buttonDesmarcarTodos = ComponenteFactory.novoJButton("Desmarcar Todos", 'D', this);
            this.buttonMarcarTodos = ComponenteFactory.novoJButton("Selecionar Todos", 'S', this);
            this.buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
            this.buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
            this.buttonDataVctoIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
            this.buttonDataVctoFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
            this.textDataIni = new TTextField(0, 4);
            this.textDataFin = new TTextField(0, 4);
            this.textValorIni = new TTextField(0, 2);
            this.textValorFin = new TTextField(0, 2);
            this.textNumeroDoc = new TTextField(40, 3);
            this.comboCampoData = new JComboBox<Object>(new Object[]{CAMPO_VENCIMENTO, CAMPO_EMISSAO, CAMPO_COMPETENCIA});
            this.tipoRecPag = "";
            this.tipoCadastro = "";
            this.codigoCadastro = "";
            this.table = null;
            this.modTit = new /* invalid duplicate definition of identical inner class */;
            this.tipoRecPag = tipoReceberPagar;
            this.tipoCadastro = tipoCadastro;
            this.codigoCadastro = codigoCadastro;
            this.iniciar();
        }

        public boolean getOk() {
            return this.ok;
        }

        public List<HashMap<String, Object>> getTitulosAbertosSelecionados() {
            ArrayList<HashMap<String, Object>> sel = new ArrayList<HashMap<String, Object>>();
            for (int i = 0; i < this.modTit.getRowCount(); ++i) {
                HashMap<String, Object> hash = this.modTit.getLine(i);
                if (!hash.get("Sel").equals(true)) continue;
                sel.add(hash);
            }
            return sel;
        }

        private String getTipoReceberPagar() {
            return this.tipoRecPag;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o == this.buttonOK || o == this.buttonCancelar) {
                this.ok = o == this.buttonOK;
                this.dispose();
            } else if (o == this.buttonMarcarTodos || o == this.buttonDesmarcarTodos) {
                boolean marcar = o == this.buttonMarcarTodos;
                for (int i = 0; i < this.modTit.getRowCount(); ++i) {
                    this.modTit.setValueAt(marcar, i, this.modTit.findColumn("Sel"));
                }
                this.modTit.fireTableDataChanged();
            } else if (o == this.buttonDataVctoIni) {
                Funcoes.mostraData(this.textDataIni, this.buttonDataVctoIni, (JPanel)this.buttonDataVctoIni.getParent(), true);
            } else if (o == this.buttonDataVctoFin) {
                Funcoes.mostraData(this.textDataFin, this.buttonDataVctoFin, (JPanel)this.buttonDataVctoFin.getParent(), true);
            } else if (o == this.buttonConsultar) {
                this.consultarTitulosAberto(this.getTipoReceberPagar());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void consultarTitulosAberto(String tipoReceberPagar) {
            Statement st = Conexao.getStatement();
            if (st != null) {
                try {
                    this.buttonConsultar.setEnabled(false);
                    this.modTit.clear();
                    ResultSet res = Conexao.executeQuery(st, this.getSelect(tipoReceberPagar, this.tipoCadastro, this.codigoCadastro));
                    while (res.next()) {
                        String campo = "";
                        switch (this.comboCampoData.getSelectedIndex()) {
                            case 0: {
                                campo = CAMPO_BANCO_VENCIMENTO;
                                break;
                            }
                            case 1: {
                                campo = CAMPO_BANCO_EMISSAO;
                                break;
                            }
                            case 2: {
                                campo = CAMPO_BANCO_COMPETENCIA;
                            }
                        }
                        Object[] obj = new Object[]{res.getInt("rpg_codigo"), res.getInt("cod_pessoa"), res.getString("razao_social"), res.getString("rpg_numerodocumento"), Funcoes.formataData("dd/MM/yyyy", res.getDate(campo)), Funcoes.formataDecimal(res.getDouble("rpg_valortotal")), new Boolean(false)};
                        this.modTit.addLine(obj);
                    }
                    this.modTit.fireTableDataChanged();
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                }
                finally {
                    this.buttonConsultar.setEnabled(true);
                }
            }
        }

        private String getSelect(String tipoReceberPagar, String tipoCadastro, String codigoCadastro) {
            StringBuilder buf = new StringBuilder();
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            String campo = "";
            switch (this.comboCampoData.getSelectedIndex()) {
                case 0: {
                    campo = CAMPO_BANCO_VENCIMENTO;
                    break;
                }
                case 1: {
                    campo = CAMPO_BANCO_EMISSAO;
                    break;
                }
                case 2: {
                    campo = CAMPO_BANCO_COMPETENCIA;
                }
            }
            try {
                buf.append(" select rpg.rpg_codigo \n");
                buf.append("       ,cad.cod_pessoa \n");
                buf.append("       ,cad.razao_social \n");
                buf.append("       ,rpg.rpg_numerodocumento \n");
                buf.append("       ,rpg.").append(campo).append(" \n");
                buf.append("       ,rpg.rpg_valortotal \n");
                buf.append("  \t\t ,false as ").append(SELECIONADO).append(" \n");
                buf.append("   from receberpagar rpg \n");
                buf.append("   left join (select case when rpg.rpg_tipocadastro = upper('").append("P").append("') then pac.pac_nome \n");
                buf.append("                       when rpg.rpg_tipocadastro = upper('").append("O").append("') then con.con_fantasia  \n");
                buf.append("                       else ent.ent_fantasia end as razao_social \n");
                buf.append("                    ,case when upper(rpg.rpg_tipocadastro) = upper('").append("P").append("') then pac.pac_codigo \n");
                buf.append("                       when upper(rpg.rpg_tipocadastro) = upper('").append("O").append("') then con.con_codigo \n");
                buf.append("                       else ent.ent_codigo end as cod_pessoa \n");
                buf.append("                    ,rpg.rpg_codigo \n");
                buf.append("                    ,rpg.fil_codigo \n");
                buf.append("               from receberpagar rpg \n");
                buf.append("               left join entidade ent on rpg.fil_codigo = ent.fil_codigo and rpg.ent_codigo = ent.ent_codigo \n");
                buf.append("               left join paciente pac on rpg.fil_codigo = pac.fil_codigo and rpg.pac_codigo = pac.pac_codigo \n");
                buf.append("               left join convenios con on rpg.fil_codigo = con.fil_codigo and rpg.con_codigo = con.con_codigo \n");
                buf.append("             ) cad on (rpg.fil_codigo = cad.fil_codigo and rpg.rpg_codigo = cad.rpg_codigo) \n");
                buf.append("  where \n");
                buf.append("        rpg.fil_codigo = ").append(Variaveis.filialPadrao).append(" ");
                buf.append("    and rpg.rpg_tipo = '").append(tipoReceberPagar).append("' ");
                buf.append("    and rpg.rpg_situacao = 'A' ");
                if (Funcoes.verificaData(this.textDataIni.getText())) {
                    buf.append("and \n rpg.").append(campo).append(" >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", sdf.parse(this.textDataIni.getText()))).append("' ");
                }
                if (Funcoes.verificaData(this.textDataFin.getText())) {
                    buf.append("and \n rpg.").append(campo).append(" <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", sdf.parse(this.textDataFin.getText()))).append("' ");
                }
                if (!Funcoes.textoVazio(this.textNumeroDoc)) {
                    buf.append(" and rpg_numerodocumento ilike '%").append(this.textNumeroDoc.getText()).append("%' ");
                }
                if (!Funcoes.textoVazio(this.textValorIni)) {
                    buf.append(" and rpg_valortotal >= ").append(Funcoes.limpaDecimal(this.textValorIni.getText()));
                }
                if (!Funcoes.textoVazio(this.textValorFin)) {
                    buf.append(" and rpg_valortotal <= ").append(Funcoes.limpaDecimal(this.textValorFin.getText()));
                }
                StringBuilder bufWhere = new StringBuilder();
                bufWhere.append(" (cad.cod_pessoa = ").append(codigoCadastro).append(" and rpg_tipocadastro = '").append(tipoCadastro).append("') ");
                if (bufWhere.toString().length() > 0) {
                    buf.append(" and ( ");
                    buf.append(bufWhere.toString());
                    buf.append(" ) ");
                }
                buf.append("  order by rpg.rpg_codigo ");
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DialogoFiltro: 3353");
            }
            return buf.toString();
        }

        private void iniciar() {
            this.getContentPane().setLayout(new GridBagLayout());
            JPanel panelBotoes = new JPanel(new BorderLayout());
            panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, this.buttonMarcarTodos, this.buttonDesmarcarTodos), "West");
            panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonOK, this.buttonCancelar), "East");
            JPanel panelTabela = new JPanel(new BorderLayout());
            panelTabela.setBorder(BorderFactory.createTitledBorder("T\u00edtulos em aberto"));
            this.table = new JTable(this.modTit);
            this.modTit.setColumnSize(new int[]{60, 80, 0, 85, 90, 85, 20}, this.table);
            this.table.getTableHeader().addMouseListener(this.modTit);
            this.table.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int[] colunas = ((JTable)e.getSource()).getSelectedColumns();
                    boolean colunaSelecionada = false;
                    for (int i = 0; i < colunas.length; ++i) {
                        if (colunas[i] != ((JTable)e.getSource()).getColumnCount() - 1) continue;
                        colunaSelecionada = true;
                        break;
                    }
                    if (e.getKeyCode() == 32 && !colunaSelecionada) {
                        int row = ((JTable)e.getSource()).getSelectedRow();
                        if (row < 0) {
                            return;
                        }
                        Boolean valor = (Boolean)DialogoFiltro.this.modTit.getValueAt(row, DialogoFiltro.this.modTit.getColumnCount() - 1);
                        DialogoFiltro.this.modTit.setValueAt(valor == false, row, DialogoFiltro.this.modTit.getColumnCount() - 1);
                    }
                }
            });
            JScrollPane scroll = new JScrollPane(this.table);
            scroll.setPreferredSize(new Dimension(600, 200));
            panelTabela.add((Component)scroll, "Center");
            JPanel panelFiltros = new JPanel(new GridBagLayout());
            panelFiltros.setBorder(BorderFactory.createTitledBorder("Filtros"));
            this.itemPaciente = new CheckItemFiltro("Paciente", "Filtrar", "Filtrando pacientes", "fil_codigo = " + Variaveis.filialPadrao);
            this.itemPaciente.setDados("paciente", new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome Paciente"}, new int[]{70, 0});
            this.itemPaciente.setColunaHint(1);
            Dimension d = new Dimension(100, 20);
            this.itemPaciente.setPreferredSize(d);
            this.itemPaciente.setMinimumSize(d);
            d = new Dimension(90, 20);
            this.textDataIni.setPreferredSize(d);
            this.textDataIni.setMinimumSize(d);
            this.buttonDataVctoIni.setFocusable(false);
            this.itemEntidade = new CheckItemFiltro("Entidade", "Filtrar", "Filtrando entidades", "fil_codigo = " + Variaveis.filialPadrao);
            this.itemEntidade.setDados("entidade", new String[]{"ent_codigo", "ent_fantasia"}, new String[]{"C\u00f3digo", "Fantasia Cadastro"}, new int[]{70, 0});
            this.itemEntidade.setColunaHint(1);
            d = new Dimension(100, 20);
            this.itemEntidade.setPreferredSize(d);
            this.itemEntidade.setMinimumSize(d);
            this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
            this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia Conv\u00eanio"}, new int[]{70, 0});
            this.itemConvenio.setColunaHint(1);
            d = new Dimension(100, 20);
            this.itemConvenio.setPreferredSize(d);
            this.itemConvenio.setMinimumSize(d);
            this.textDataFin.setPreferredSize(new Dimension(90, 20));
            this.buttonDataVctoFin.setFocusable(false);
            d = new Dimension(90, 20);
            this.textNumeroDoc.setPreferredSize(d);
            this.textNumeroDoc.setMinimumSize(d);
            this.textValorIni.setPreferredSize(d);
            this.textValorIni.setMinimumSize(d);
            this.textValorFin.setPreferredSize(d);
            this.textValorFin.setMinimumSize(d);
            this.buttonConsultar.setPreferredSize(d);
            this.buttonConsultar.setMinimumSize(d);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(1, 1, 1, 0);
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.anchor = 17;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = 2;
            panelFiltros.add((Component)new JLabel("N\u00famero Doc.:"), c);
            ++c.gridx;
            c.gridwidth = 2;
            panelFiltros.add((Component)this.textNumeroDoc, c);
            c.gridx = 4;
            c.gridwidth = 1;
            panelFiltros.add((Component)new JLabel("Campo Data:"), c);
            ++c.gridx;
            c.gridwidth = 2;
            panelFiltros.add((Component)this.comboCampoData, c);
            ++c.gridy;
            c.gridx = 0;
            c.fill = 0;
            c.gridwidth = 1;
            panelFiltros.add((Component)new JLabel("Data Inicial:"), c);
            ++c.gridx;
            panelFiltros.add((Component)this.textDataIni, c);
            ++c.gridx;
            panelFiltros.add((Component)this.buttonDataVctoIni, c);
            ++c.gridx;
            panelFiltros.add((Component)new JLabel("    "), c);
            ++c.gridx;
            panelFiltros.add((Component)new JLabel("Data Final:"), c);
            ++c.gridx;
            panelFiltros.add((Component)this.textDataFin, c);
            ++c.gridx;
            panelFiltros.add((Component)this.buttonDataVctoFin, c);
            ++c.gridy;
            c.gridx = 0;
            panelFiltros.add((Component)new JLabel("Vl. Total Inicial:"), c);
            ++c.gridx;
            panelFiltros.add((Component)this.textValorIni, c);
            c.gridx += 3;
            panelFiltros.add((Component)new JLabel("Vl. Total Final:"), c);
            ++c.gridx;
            panelFiltros.add((Component)this.textValorFin, c);
            c.gridx += 2;
            c.weightx = 1.0;
            c.fill = 2;
            panelFiltros.add((Component)new JLabel(""), c);
            ++c.gridx;
            c.weightx = 0.0;
            c.fill = 0;
            c.anchor = 12;
            panelFiltros.add((Component)this.buttonConsultar, c);
            Container panelPrinc = this.getContentPane();
            panelPrinc.setLayout(new GridBagLayout());
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 18;
            c.fill = 2;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.insets = new Insets(1, 1, 1, 1);
            c.weightx = 0.0;
            c.weighty = 0.0;
            panelPrinc.add((Component)panelFiltros, c);
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 1.0;
            c.fill = 1;
            panelPrinc.add((Component)panelTabela, c);
            ++c.gridy;
            panelPrinc.add((Component)panelBotoes, c);
            Funcoes.montaEnter((JComponent)this.getContentPane());
            ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(113, 0, true), "F2", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogoFiltro.this.textDataIni.hasFocus()) {
                        Funcoes.mostraData(DialogoFiltro.this.textDataIni, DialogoFiltro.this.buttonDataVctoIni, (JPanel)DialogoFiltro.this.buttonDataVctoIni.getParent(), true);
                    } else if (DialogoFiltro.this.textDataFin.hasFocus()) {
                        Funcoes.mostraData(DialogoFiltro.this.textDataFin, DialogoFiltro.this.buttonDataVctoFin, (JPanel)DialogoFiltro.this.buttonDataVctoFin.getParent(), true);
                    }
                }
            });
            this.comboCampoData.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DialogoFiltro.this.modTit.clear();
                        DialogoFiltro.this.modTit.setColumnName(4, e.getItem().toString());
                        DialogoFiltro.this.modTit.setColumnSize(new int[]{60, 80, 0, 85, 90, 85, 20}, DialogoFiltro.this.table);
                    }
                }
            });
            this.pack();
            d = new Dimension(250, 200);
            this.setPreferredSize(d);
            this.setMinimumSize(d);
            this.setResizable(false);
            ScreenUtil.centralizar(this);
        }
    }

    private class DetalhesAgrupador
    extends Detalhes {
        private Integer codigo;
        private String tipoDocumento;
        private String numeroDocumento;
        private Date dataVencimento;
        private Double valorBruto;
        private Double valorLiquido;

        public DetalhesAgrupador(int situacao) {
            super(situacao);
            this.codigo = 0;
            this.tipoDocumento = "";
            this.numeroDocumento = "";
            this.dataVencimento = new Date();
            this.valorBruto = new Double(0.0);
            this.valorLiquido = new Double(0.0);
            this.codigo = 0;
            this.tipoDocumento = "";
            this.numeroDocumento = "";
            this.dataVencimento = new Date();
            this.valorBruto = new Double(0.0);
            this.valorLiquido = new Double(0.0);
            this.setFont(this.getFont().deriveFont(11.0f));
            this.setBotaoExpandirVisible(false);
        }

        public void setValores(Integer codigo, String tipoDocumento, String numeroDocumento, Date dataVencimento, Double valorBruto, Double valorLiquido) {
            this.codigo = codigo;
            this.tipoDocumento = tipoDocumento;
            this.numeroDocumento = numeroDocumento;
            this.dataVencimento = dataVencimento;
            this.valorBruto = valorBruto;
            this.valorLiquido = valorLiquido;
            this.atualizarDados();
        }

        @Override
        protected void atualizarDados() {
            StringBuilder html = new StringBuilder();
            html.append("<html>");
            html.append("<table>");
            html.append("<font size=20>");
            html.append("<tr>");
            html.append("<td><b>C\u00f3digo: ").append("</b></td>");
            html.append("<td align=\"right\" width=85>").append(this.codigo == null ? "---" : this.codigo).append("</td>");
            html.append("<td width=30>-</td>");
            html.append("<td><b>Tipo Documento: ").append("</b></td>");
            html.append("<td width=85>").append(this.tipoDocumento == null ? "" : this.tipoDocumento).append("</td>");
            html.append("<td width=30>-</td>");
            html.append("<td><b>Vl. Bruto: ").append("</b></td>");
            html.append("<td align=\"right\" width=70>").append(this.valorBruto == null ? "" : Funcoes.formataDecimal("0.00", this.valorBruto)).append("</td>");
            html.append("</tr>");
            html.append("<tr>");
            html.append("<td><b>Data Vencimento: ").append("</b></td>");
            html.append("<td width=85>").append(this.dataVencimento == null ? "" : Funcoes.formataData("dd/MM/yyyy", this.dataVencimento)).append("</td>");
            html.append("<td width=30>-</td>");
            html.append("<td><b>N\u00famero Documento: ").append("</b></td>");
            html.append("<td width=85>").append(this.numeroDocumento == null ? "" : this.numeroDocumento).append("</td>");
            html.append("<td width=30>-</td>");
            html.append("<td><b>Vl. L\u00edquido: ").append("</b></td>");
            html.append("<td align=\"right\" width=70>").append(this.valorLiquido == null ? "" : Funcoes.formataDecimal("0.00", this.valorLiquido)).append("</td>");
            html.append("</tr>");
            html.append("</font>");
            html.append("</table>");
            html.append("</html>");
            this.setDetalhes(html.toString());
            this.repaint();
        }

        public void limparDetalhes() {
            this.setValores(null, null, null, null, null, null);
        }
    }

    private class TotalizadorTitulos
    extends Detalhes {
        private int quantidadeTitulos;
        private BigDecimal somatorioBruto;
        private BigDecimal somatorioLiquido;

        public TotalizadorTitulos(int situacao) {
            super(situacao);
            this.quantidadeTitulos = 0;
            this.somatorioBruto = new BigDecimal(0);
            this.somatorioLiquido = new BigDecimal(0);
            this.quantidadeTitulos = 0;
            this.somatorioBruto = new BigDecimal(0);
            this.somatorioLiquido = new BigDecimal(0);
            this.setBotaoExpandirVisible(false);
        }

        public void setValores(int quantidadeTitulos, BigDecimal somatorioBruto, BigDecimal somatorioLiquido) {
            this.quantidadeTitulos = quantidadeTitulos;
            this.somatorioBruto = somatorioBruto;
            this.somatorioLiquido = somatorioLiquido;
            this.atualizarDados();
        }

        @Override
        protected void atualizarDados() {
            if (this.somatorioBruto == null) {
                this.somatorioBruto = new BigDecimal(0);
            }
            if (this.somatorioLiquido == null) {
                this.somatorioLiquido = new BigDecimal(0);
            }
            StringBuilder html = new StringBuilder();
            html.append("<html>");
            html.append("<table>");
            html.append("<font size=4>");
            html.append("<tr>");
            html.append("<td><b>Quantidade de T\u00edtulos: ").append("</b></td>");
            html.append("<td align=\"right\" width=20><b>").append(this.quantidadeTitulos).append("</b></td>");
            html.append("<td width=30>-</td>");
            html.append("<td><b>Somat\u00f3rio Vl. Bruto: ").append("</b></td>");
            html.append("<td align=\"right\" width=60><b>").append(Funcoes.formataDecimal("0.00", this.somatorioBruto.doubleValue())).append("</b></td>");
            html.append("<td width=30>-</td>");
            html.append("<td><b>Somat\u00f3rio Vl. L\u00edquido: ").append("</b></td>");
            html.append("<td align=\"right\" width=60><b>").append(Funcoes.formataDecimal("0.00", this.somatorioLiquido.doubleValue())).append("</b></td>");
            html.append("</tr>");
            html.append("</font>");
            html.append("</table>");
            html.append("</html>");
            this.setDetalhes(html.toString());
            this.repaint();
        }
    }

    class TituloRenderer
    extends DefaultTableCellRenderer {
        @Override
        public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            ReceberPagarBean b;
            Component c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            this.setValue(value);
            if (selected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (row < AgrupamentoReceberPagar.this.titulos.size() && AgrupamentoReceberPagar.this.titulos.get(row) != null && !(b = (ReceberPagarBean)AgrupamentoReceberPagar.this.modelTitulos.getValueAt(row, AgrupamentoReceberPagar.this.modelTitulos.getColumnCount() - 1)).isRemover()) {
                if (b.isPlanoContaErrado() && b.isCentroCustoErrado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_CENTROCUSTO_ERRADO);
                } else if (b.isPlanoContaErrado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_ERRADO);
                } else if (b.isCentroCustoErrado()) {
                    c.setBackground(FinanceiroUtil.COR_CENTROCUSTO_ERRADO);
                } else if (b.isPlanoContaNaoConfigurado() && b.isCentroCustoNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_CENTROCUSTO_NAO_CONFIGURADO);
                } else if (b.isPlanoContaNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_NAO_CONFIGURADO);
                } else if (b.isCentroCustoNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_CENTROCUSTO_NAO_CONFIGURADO);
                }
                if (selected && c.getBackground() != table.getSelectionBackground()) {
                    c.setBackground(ScreenUtil.escurecerCor(c.getBackground(), 30));
                }
            }
            if (focused) {
                Border border = selected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.focusCellHighlightBorder");
                ((JComponent)c).setBorder(border);
                if (!selected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        c.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        c.setBackground(col);
                    }
                }
            } else {
                ((JComponent)c).setBorder(noFocusBorder);
            }
            return c;
        }
    }

    class AgrupadorRenderer
    extends DefaultTableCellRenderer {
        @Override
        public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            this.setValue(value);
            row = table.getRowSorter().convertRowIndexToModel(row);
            if (selected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (row >= 0 && AgrupamentoReceberPagar.this.beanAgrupador != null) {
                ReceberPagarBean b = AgrupamentoReceberPagar.this.beanAgrupador;
                if (b.isPlanoContaErrado() && b.isCentroCustoErrado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_CENTROCUSTO_ERRADO);
                } else if (b.isPlanoContaErrado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_ERRADO);
                } else if (b.isCentroCustoErrado()) {
                    c.setBackground(FinanceiroUtil.COR_CENTROCUSTO_ERRADO);
                } else if (b.isPlanoContaNaoConfigurado() && b.isCentroCustoNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_CENTROCUSTO_NAO_CONFIGURADO);
                } else if (b.isPlanoContaNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_PLANOCONTA_NAO_CONFIGURADO);
                } else if (b.isCentroCustoNaoConfigurado()) {
                    c.setBackground(FinanceiroUtil.COR_CENTROCUSTO_NAO_CONFIGURADO);
                }
            }
            if (focused) {
                Border border = selected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.focusCellHighlightBorder");
                ((JComponent)c).setBorder(border);
                if (!selected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        c.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        c.setBackground(col);
                    }
                }
            } else {
                ((JComponent)c).setBorder(noFocusBorder);
            }
            return c;
        }
    }
}

