/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed;

import jalis.laboratorio.financeiro.faturamento.integracao.DadosEspeciaisCombo;

public class TecnospeedUtil {
    public static final String METODO_ENVIO_RPS = "envia";
    public static final String METODO_IMPRIME_PDF = "imprime";
    public static final String METODO_EXPORTA_XML = "exportaxml";
    public static final String METODO_CANCELA = "cancela";
    public static final String METODO_RESOLVE = "resolve";
    public static final String METODO_DESCARTA = "descarta";
    public static final String METODO_CONSULTA = "consulta";

    public static enum TipoExportacaoXML {
        EMISSAO("EMISSAO"),
        AUTORIZACAO("AUTORIZACAO"),
        CANCELAMENTO("CANCELAMENTO");

        private String descricao = null;

        private TipoExportacaoXML(String descricao) {
            this.descricao = descricao;
        }
    }

    public static enum TipoDocumentoTomador {
        CPF("CPF", 1),
        CNPJ("CNPJ", 2),
        ESTRANGEIRO("Estrangeiro", 3);

        private int codigo = -1;
        private String descricao = null;

        private TipoDocumentoTomador(String descricao, int codigo) {
            this.descricao = descricao;
            this.codigo = codigo;
        }

        public String toString() {
            return this.descricao;
        }

        public static TipoDocumentoTomador get(int codigo) {
            TipoDocumentoTomador[] todos = TipoDocumentoTomador.values();
            for (int i = 0; i < todos.length; ++i) {
                TipoDocumentoTomador aux = todos[i];
                if (aux.codigo != codigo) continue;
                return aux;
            }
            return null;
        }

        public int getCodigo() {
            return this.codigo;
        }
    }

    public static enum OpcaoIncentivadorCultural {
        SIM("Sim (Incentivador)", 1),
        NAO("N\u00e3o (N\u00e3o Incentivador)", 2);

        private int codigo = -1;
        private String descricao = null;

        private OpcaoIncentivadorCultural(String descricao, int codigo) {
            this.descricao = descricao;
            this.codigo = codigo;
        }

        public String toString() {
            return this.descricao;
        }

        public static OpcaoIncentivadorCultural get(int codigo) {
            OpcaoIncentivadorCultural[] todos = OpcaoIncentivadorCultural.values();
            for (int i = 0; i < todos.length; ++i) {
                OpcaoIncentivadorCultural aux = todos[i];
                if (aux.codigo != codigo) continue;
                return aux;
            }
            return null;
        }

        public int getCodigo() {
            return this.codigo;
        }
    }

    public static enum OptanteSimplesNacional {
        SIM_OPTANTE("Sim (Optante)", 1),
        NAO_OPTANTE("N\u00e3o optante", 2);

        private int codigo = -1;
        private String descricao = null;

        private OptanteSimplesNacional(String descricao, int codigo) {
            this.descricao = descricao;
            this.codigo = codigo;
        }

        public String toString() {
            return this.descricao;
        }

        public static OptanteSimplesNacional get(int codigo) {
            OptanteSimplesNacional[] todos = OptanteSimplesNacional.values();
            for (int i = 0; i < todos.length; ++i) {
                OptanteSimplesNacional aux = todos[i];
                if (aux.codigo != codigo) continue;
                return aux;
            }
            return null;
        }

        public int getCodigo() {
            return this.codigo;
        }
    }

    public static enum NaturezaOperacao implements DadosEspeciaisCombo
    {
        SEM_DEDUCAO("Sem Dedu\u00e7\u00e3o", "A"),
        COM_DEDUCAO_MATERIAIS("Com Dedu\u00e7\u00e3o/Materiais", "B"),
        IMUNE_ISENTA_ISSQN("Imune/Isenta de ISSQN", "C"),
        DEVOLUCAO_SIMPLES_REMESSA("Devolu\u00e7\u00e3o/Simples Remessa", "D"),
        INTERMEDIACAO("Intermedia\u00e7\u00e3o", "J");

        String codigo = null;
        String descricao = null;

        private NaturezaOperacao(String descricao, String codigo) {
            this.descricao = descricao;
            this.codigo = codigo;
        }

        public String toString() {
            return this.descricao;
        }

        public static NaturezaOperacao get(String codigo) {
            NaturezaOperacao[] todos = NaturezaOperacao.values();
            for (int i = 0; i < todos.length; ++i) {
                NaturezaOperacao aux = todos[i];
                if (!aux.codigo.equalsIgnoreCase(codigo)) continue;
                return aux;
            }
            return null;
        }

        @Override
        public Object getCodigo() {
            return this.codigo;
        }
    }

    public static enum Tributavel implements DadosEspeciaisCombo
    {
        ITEM_TRIBUTAVEL("Sim", "S"),
        NAO_TRIBUTAVEL("N\u00e3o", "N");

        String descricao = null;
        public String codigo = null;

        private Tributavel(String descricao, String codigo) {
            this.descricao = descricao;
            this.codigo = codigo;
        }

        public String toString() {
            return this.descricao;
        }

        public static Tributavel get(String codigo) {
            Tributavel[] todos = Tributavel.values();
            for (int i = 0; i < todos.length; ++i) {
                Tributavel aux = todos[i];
                if (!aux.codigo.equalsIgnoreCase(codigo)) continue;
                return aux;
            }
            return null;
        }

        @Override
        public Object getCodigo() {
            return this.codigo;
        }
    }

    public static enum ExigibilidadeISS implements DadosEspeciaisCombo
    {
        NAO_SE_APLICA("N\u00e3o se aplica", null),
        EXIGIVEL("Exig\u00edvel", 1),
        NAO_INCIDENCIA("N\u00e3o Incid\u00eancia", 2),
        ISENCAO("Isen\u00e7\u00e3o", 3),
        EXPORTACAO("Exporta\u00e7\u00e3o", 4),
        IMUNIDADE("Imunidade", 5),
        EXIGIBILIDADE_SUSPENSA_DECISAO_JUDICIAL("Exigibilidade Suspensa por Decis\u00e3o Judicial", 6),
        EXIGIBILIDADE_SUSPENSA_PROCESSO_ADIMINISTRATIVO("Exigibilidade Suspensa por Processo Administrativo", 7);

        private String descricao = null;
        private Integer codigo = -1;

        private ExigibilidadeISS(String descricao, Integer codigo) {
            this.descricao = descricao;
            this.codigo = codigo;
        }

        public String toString() {
            return this.descricao;
        }

        @Override
        public Object getCodigo() {
            return this.codigo;
        }

        public static ExigibilidadeISS get(String codigo) {
            ExigibilidadeISS[] todos = ExigibilidadeISS.values();
            for (int i = 0; i < todos.length; ++i) {
                ExigibilidadeISS aux = todos[i];
                if (!String.valueOf(aux.codigo).equalsIgnoreCase(codigo)) continue;
                return aux;
            }
            return null;
        }
    }

    public static enum SituacaoNota {
        NORMAL(1),
        CANCELADA(2);

        private int codigo = -1;

        private SituacaoNota(int codigo) {
            this.codigo = codigo;
        }

        public int getCodigo() {
            return this.codigo;
        }
    }

    public static enum RegimeEspecialTributacao {
        TRIBUTACAO_NORMAL("Tributa\u00e7\u00e3o normal", 0),
        MICROEMPRESA_MUNICIPAL("Microempresa Municipal", 1),
        ESTIMATIVA("Estimativa", 2),
        SOCIEDADE_PROFISSIONAIS("Sociedade de Profissionais", 3),
        COOPERATIVA("Cooperativa", 4),
        MICROEMPRESARIO_INDIVIDUAL_MEI("Microempres\u00e1rio Individual (MEI)", 5),
        MICROEMPRESARIO_EMPRESA_PEQUENO_PORTE_ME_EPP("Microempres\u00e1rio e Empresa de Pequeno Porte (ME EPP)", 6),
        LUCRO_REAL("Lucro Real", 7),
        LUCRO_PRESUMIDO("Lucro Presumido", 8);

        private int codigo = -1;
        private String descricao = null;

        private RegimeEspecialTributacao(String descricao, int codigo) {
            this.descricao = descricao;
            this.codigo = codigo;
        }

        public String toString() {
            return this.descricao;
        }

        public int getCodigo() {
            return this.codigo;
        }

        public static RegimeEspecialTributacao get(int codigo) {
            for (RegimeEspecialTributacao aux : RegimeEspecialTributacao.values()) {
                if (aux.codigo != codigo) continue;
                return aux;
            }
            return null;
        }
    }

    public static enum NaturezaTributacao {
        SIMPLES_NACIONAL("Simples Nacional", 1),
        FIXO("Fixo", 2),
        DEPOSITO_JUIZO("Dep\u00f3sito em Ju\u00edzo", 3),
        EXIGIBILIDADE_SUSPENSA_DECISAO_JUDICIAL("Exigibilidade Suspensa por Decis\u00e3o Judicial", 4),
        EXIGIBILIDADE_SUSPENSA_PROCEDIMENTO_ADMINISTRATIVO("Exigibilidade Suspensa por Procedimento Administrativo", 5);

        private int codigo = -1;
        private String descricao = null;

        private NaturezaTributacao(String descricao, int codigo) {
            this.descricao = descricao;
            this.codigo = codigo;
        }

        public String toString() {
            return this.descricao;
        }

        public int getCodigo() {
            return this.codigo;
        }
    }

    public static enum Tributacao implements DadosEspeciaisCombo
    {
        ISENTA_ISS("Isenta de ISS", 1),
        IMUNE("Imune", 2),
        NAO_INCIDENCIA_MUNICIPIO("N\u00e3o Incid\u00eancia no Munic\u00edpio", 3),
        NAO_TRIBUTAVEL("N\u00e3o Tribut\u00e1vel", 4),
        RETIDA("Retida", 5),
        TRIBUTAVEL_DENTRO_MUNICIPIO("Tribut\u00e1vel dentro do Munic\u00edpio", 6),
        TRIBUTAVEL_FORA_MUNICIPIO("Tribut\u00e1vel fora do Munic\u00edpio", 7);

        private String descricao = null;
        private int codigo = -1;

        private Tributacao(String descricao, int codigo) {
            this.descricao = descricao;
            this.codigo = codigo;
        }

        public String toString() {
            return this.descricao;
        }

        @Override
        public Object getCodigo() {
            return this.codigo;
        }

        public static Tributacao get(String codigo) {
            Tributacao[] todos = Tributacao.values();
            for (int i = 0; i < todos.length; ++i) {
                Tributacao aux = todos[i];
                if (!String.valueOf(aux.codigo).equalsIgnoreCase(codigo)) continue;
                return aux;
            }
            return null;
        }
    }

    public static enum TipoDado {
        INDEFINIDO(-1, 3),
        INTEIRO(0, 1),
        TEXTO(1, 3),
        MONETARIO(2, 10),
        DATA(3, 4),
        DATA_HORA(4, 14),
        CEP(5, 9),
        CNPJ(6, 7),
        CPF(7, 8);

        private int tipo = -1;
        private int tipoJalis = 3;

        private TipoDado(int tipo, int tipoJalis) {
            this.tipo = tipo;
            this.tipoJalis = tipoJalis;
        }

        public int getTipoJalis() {
            return this.tipoJalis;
        }
    }

    public static enum Padrao {
        ABRASF("ABRASF", 0),
        ABRASF_2("ABRASF 2", 1),
        ABRASF_2_1("ABRASF 2.1", 2),
        ABRASF_2_2("ABRASF 2.2", 3),
        AMTEC("AMTEC", 4),
        DEVEL("DEVEL", 5),
        DSF("DSF", 6),
        E_GOVERNE("E GOVERNE", 7),
        ENOTAS("ENOTAS", 26),
        EQUIPLANO("EQUIPLANO", 8),
        FGMAISS_OFFLINE("FGMAISS OFFLINE", 9),
        FIORILLI("FIORILLI", 10),
        IPM("IPM", 11),
        ISSONLINE("ISSONLINE", 12),
        ISSSIMPLES("ISSSIMPLES", 13),
        ISSWEB("ISSWEB", 14),
        LONDRINA("LONDRINA", 15),
        METROPOLIS("METROPOLIS", 16),
        NOTA_CONTROL("NOTA CONTROL", 17),
        PRODAM("PRODAM", 18),
        SAATRI("SAATRI", 19),
        SEMFAZONLINE("SEMFAZONLINE", 20),
        SIGISS("SIGISS", 21),
        SIL_TECNOLOGIA("SIL TECNOLOGIA", 22),
        SIM("SIM", 23),
        TECSYSTEM("TECSYSTEM", 24),
        TECNOSPEED("TECNOSPEED", 25);

        private int codigo = -1;
        private String descricao = null;

        public int getCodigo() {
            return this.codigo;
        }

        private Padrao(String descricao, int codigo) {
            this.descricao = descricao;
            this.codigo = codigo;
        }

        public String toString() {
            return this.descricao;
        }

        public static Padrao get(Integer codigo) {
            if (codigo == null) {
                return null;
            }
            Padrao[] todos = Padrao.values();
            for (int i = 0; i < todos.length; ++i) {
                Padrao aux = todos[i];
                if (aux.codigo != codigo) continue;
                return aux;
            }
            return null;
        }
    }
}

