/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.faturamento.integracao.DialogoErros;
import jalis.laboratorio.financeiro.faturamento.integracao.ErrosCampos;
import jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed.Campo;
import jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed.ComunicacaoTecnospeed;
import jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed.Grupo;
import jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed.IntegracaoTecnospeedException;
import jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed.TecnospeedUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.BairroBean;
import jalis.model.bean.cadastro.CidadeBean;
import jalis.model.bean.cadastro.FilialBean;
import jalis.model.bean.cadastro.convenio.ConvenioBean;
import jalis.model.bean.cadastro.financeiro.SeriesBean;
import jalis.model.bean.cadastro.financeiro.ServicoBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.bean.financeiro.NotaFiscalServicoBean;
import jalis.model.bean.recepcao.PacienteBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.CidadeVO;
import jalis.model.vo.cadastro.financeiro.ServicoVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.PacienteService;
import jalis.service.cadastro.financeiro.ServicoService;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class IntegracaoTecnospeed {
    private static final String CARACTERE_ATRIBUICAO = "=";
    private static final String CARACTERE_SEPARACAO_CAMPOS = "\n";
    private static final String TAG_INCLUIR_RPS = "INCLUIRRPS";
    private static final String TAG_INCLUIR = "INCLUIR";
    private static final String TAG_SALVAR_RPS = "SALVARRPS";
    final int CASAS = ParametrosGerais.getCasasPrecoImposto();
    final RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoImposto();
    private TecnospeedUtil.Padrao padraoNFSe = null;
    private ServicoBean servico = null;
    private FilialBean filialBean = null;
    private NotaFiscalBean notaBean = null;
    private PacienteBean paciente = null;
    private ConvenioBean convenio = null;
    private NotaFiscalServicoBean notaServico = null;
    private String tipoCadastro = "";
    public static boolean debug = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private ArrayList<ErrosCampos> listaErros = new ArrayList<ErrosCampos>(){

        @Override
        public boolean add(ErrosCampos e) {
            if (e != null) {
                boolean jaExiste = false;
                for (ErrosCampos erro : this) {
                    try {
                        if (!e.getDescricao().equalsIgnoreCase(erro.getDescricao()) || e.getCampoTecnospeed().getBean() == null || e.getCampoTecnospeed().getBean().getClass() != erro.getCampoTecnospeed().getBean().getClass() || e.getCampoTecnospeed().getBean().getValorPrimaryKey() == null || erro.getCampoTecnospeed().getBean().getValorPrimaryKey() == null || !e.getCampoTecnospeed().getBean().getValorPrimaryKey().toString().equals(erro.getCampoTecnospeed().getBean().getValorPrimaryKey().toString())) continue;
                        jaExiste = true;
                        break;
                    }
                    catch (Exception e1) {
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel comparar os objetos. \n" + e1.getMessage(), e1.getStackTrace());
                    }
                }
                if (jaExiste) {
                    return false;
                }
                return super.add(e);
            }
            return false;
        }
    };

    private void getPDFNota(boolean apenasLinkDownload) {
        block3: {
            try {
                String xmlPDFNota = this.getDadosPDFNota(apenasLinkDownload);
                String retorno = ComunicacaoTecnospeed.enviaGet("imprime", xmlPDFNota, this.notaBean.getFilial().getCnpj(), String.valueOf(this.filialBean.getCodigo()), true);
                if (Funcoes.textoVazio(retorno)) {
                    return;
                }
                this.processaRetornoPDFTecnospeed(this.notaBean, this.getObjetoRetornoPDFTecnospeed(retorno, apenasLinkDownload));
            }
            catch (Exception e) {
                if (e.getMessage().contains("N\u00e3o foi poss\u00edvel realizar get: Invalid uri")) break block3;
                Funcoes.mensagem(Laboratorio.getInstancia(), "A DANFE n\u00e3o pode ser gerada, servidor n\u00e3o respondeu em tempo h\u00e1bil.", 2);
                System.out.println("N\u00e3o foi poss\u00edvel obter PDF: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private ByteArrayOutputStream downloadFile(String link) {
        CloseableHttpClient httpCliente = HttpClientBuilder.create().build();
        HttpGet httpGet = new HttpGet(link);
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        try {
            HttpResponse httpResponse = httpCliente.execute((HttpUriRequest)httpGet);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                httpEntity.writeTo((OutputStream)outBytes);
                outBytes.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return outBytes;
    }

    private void processaRetornoPDFTecnospeed(NotaFiscalBean notaBean, RetornoPDFTecnospeed objetoRetornoPDFTecnospeed) throws Exception {
        if (!objetoRetornoPDFTecnospeed.isRejeicao()) {
            Long id = DBUtil.gravaLargeObject(objetoRetornoPDFTecnospeed.getPDF(), Conexao.getConnection());
            StringBuilder buf = new StringBuilder();
            buf.append(" update notafiscal ");
            buf.append("    set nfi_pdfrps = ").append(id);
            buf.append("  where fil_codigo = ").append(notaBean.getFilial().getCodigo());
            buf.append("    and nfi_codigo = ").append(notaBean.getCodigo());
            Statement st = Conexao.getStatement();
            try {
                int qtde = Conexao.executeUpdate(notaBean.getFilial().getCodigo().toString(), st, buf.toString(), false);
                if (qtde == 0) {
                    throw new Exception("A nota fiscal n\u00e3o foi localizada. Filial = " + notaBean.getFilial().getCodigo() + ", c\u00f3digo nota = " + notaBean.getCodigo());
                }
                notaBean.setPdfRps(id);
            }
            catch (Exception sqle) {
                Conexao.anulaSQL();
            }
            Conexao.arquivaSQL();
        }
    }

    private RetornoPDFTecnospeed getObjetoRetornoPDFTecnospeed(String mensagemRetorno, boolean isURL) {
        if (Funcoes.textoVazio(mensagemRetorno)) {
            return null;
        }
        RetornoPDFTecnospeed retorno = new RetornoPDFTecnospeed();
        if (mensagemRetorno.toLowerCase().startsWith("exception")) {
            retorno.setRejeicao(true);
            retorno.setStatusRetorno(mensagemRetorno.length() > 500 ? mensagemRetorno.substring(0, 500) : mensagemRetorno);
            return retorno;
        }
        if (isURL && !Funcoes.textoVazio(mensagemRetorno)) {
            ByteArrayOutputStream pdfOut = this.downloadFile(mensagemRetorno);
            if (pdfOut != null && pdfOut.size() > 0) {
                retorno.setPDF(pdfOut.toByteArray());
            }
            retorno.setURL(mensagemRetorno);
        } else {
            retorno.setPDF(mensagemRetorno.getBytes());
        }
        return retorno;
    }

    private void getZipXMLNota(boolean apenasLinkDownload) {
        try {
            Map<String, String> parametros = this.getParametrosXMLNota(apenasLinkDownload);
            String retorno = ComunicacaoTecnospeed.comunicaPost("exportaxml", parametros, this.notaBean.getFilial().getCnpj(), String.valueOf(this.filialBean.getCodigo()), true);
            this.processaRetornoXMLTecnospeed(this.notaBean, this.getObjetoRetornoXMLTecnospeed(retorno, apenasLinkDownload));
        }
        catch (Exception e) {
            System.out.println("N\u00e3o foi poss\u00edvel obter o ZIP do XML: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void processaRetornoXMLTecnospeed(NotaFiscalBean notaBean, RetornoXMLTecnospeed objetoRetornoXMLTecnospeed) throws Exception {
        if (!objetoRetornoXMLTecnospeed.isRejeicao()) {
            Long id = DBUtil.gravaLargeObject(objetoRetornoXMLTecnospeed.getZipXML(), Conexao.getConnection());
            StringBuilder buf = new StringBuilder();
            buf.append(" update notafiscal ");
            buf.append("    set nfi_xmlnfse = ").append(id);
            buf.append("  where fil_codigo = ").append(notaBean.getFilial().getCodigo());
            buf.append("    and nfi_codigo = ").append(notaBean.getCodigo());
            Statement st = Conexao.getStatement();
            try {
                int qtde = Conexao.executeUpdate(notaBean.getFilial().getCodigo().toString(), st, buf.toString(), false);
                if (qtde == 0) {
                    throw new Exception("A nota fiscal n\u00e3o foi localizada. Filial = " + notaBean.getFilial().getCodigo() + ", c\u00f3digo nota = " + notaBean.getCodigo());
                }
                notaBean.setXmlNfse(id);
            }
            catch (Exception sqle) {
                Conexao.anulaSQL();
            }
            Conexao.arquivaSQL();
        }
    }

    private RetornoXMLTecnospeed getObjetoRetornoXMLTecnospeed(String mensagemRetorno, boolean isURL) {
        if (Funcoes.textoVazio(mensagemRetorno)) {
            return null;
        }
        RetornoXMLTecnospeed retorno = new RetornoXMLTecnospeed();
        if (mensagemRetorno.toLowerCase().startsWith("exception")) {
            retorno.setRejeicao(true);
            retorno.setStatusRetorno(mensagemRetorno.length() > 500 ? mensagemRetorno.substring(0, 500) : mensagemRetorno);
            return retorno;
        }
        if (isURL) {
            ByteArrayOutputStream pdfOut = this.downloadFile(mensagemRetorno);
            if (pdfOut != null && pdfOut.size() > 0) {
                retorno.setZipXML(pdfOut.toByteArray());
            }
            retorno.setURL(mensagemRetorno);
        } else {
            retorno.setZipXML(mensagemRetorno.getBytes());
        }
        return retorno;
    }

    private String getDadosEnvioRps(ArrayList<ErrosCampos> listaErros) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getCabecalhoEnvioRps(listaErros));
        buf.append(TAG_INCLUIR).append(CARACTERE_SEPARACAO_CAMPOS);
        buf.append(this.getDadosLoteRPS(listaErros));
        buf.append(TAG_SALVAR_RPS).append(CARACTERE_SEPARACAO_CAMPOS);
        buf.append(TAG_INCLUIR_RPS).append(CARACTERE_SEPARACAO_CAMPOS);
        buf.append(this.getIdentificadoresRPS(listaErros));
        buf.append(this.getDataEmissaoRPS(listaErros));
        buf.append(this.getOptanteSimplesNacional(listaErros));
        buf.append(this.getOpcaoIncentivadorCultural(listaErros));
        buf.append(this.getOpcaoTipoTributacao(listaErros));
        buf.append(this.getNaturezaTributacao(listaErros));
        buf.append(this.getRegimeEspecialTributacao(listaErros));
        buf.append(this.getSituacaoNota(listaErros));
        buf.append(this.getSubstituicaoRPS(listaErros));
        buf.append(this.getServicoPrestado(listaErros));
        buf.append(this.getValoresServicoPrestado(listaErros));
        buf.append(this.getPrestadorServico(listaErros));
        buf.append(this.getTomadorServico(listaErros));
        buf.append(this.getIntermediarioServico(listaErros));
        buf.append(this.getNFSeSubstituida(listaErros));
        buf.append(this.getConstrucaoCivil(listaErros));
        buf.append(this.getIdentificadorSistemaLegado(listaErros));
        buf.append(this.getAssinatura(listaErros));
        buf.append(this.getEquipamentoEmissorRPS(listaErros));
        buf.append(this.getNotaFiscalServicos(listaErros));
        buf.append("CamposRetorno=handle,nlote,nnfse,nrps,motivo, idintegracao\n");
        buf.append(TAG_SALVAR_RPS);
        return buf.toString();
    }

    private String getDadosEnvioRpsDescarte() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getCabecalhoEnvioRps(this.listaErros));
        buf.append(TAG_INCLUIR).append(CARACTERE_SEPARACAO_CAMPOS);
        buf.append(this.getDadosLoteRPS(this.listaErros));
        buf.append(TAG_SALVAR_RPS).append(CARACTERE_SEPARACAO_CAMPOS);
        buf.append(TAG_INCLUIR_RPS).append(CARACTERE_SEPARACAO_CAMPOS);
        buf.append(this.getIdentificadoresRPS(this.listaErros));
        buf.append(this.getDataEmissaoRPS(this.listaErros));
        buf.append(this.getOptanteSimplesNacional(this.listaErros));
        buf.append(this.getOpcaoIncentivadorCultural(this.listaErros));
        buf.append(this.getOpcaoTipoTributacao(this.listaErros));
        buf.append(this.getNaturezaTributacao(this.listaErros));
        buf.append(this.getRegimeEspecialTributacao(this.listaErros));
        buf.append(this.getSituacaoNota(this.listaErros));
        buf.append(this.getSubstituicaoRPS(this.listaErros));
        buf.append(this.getServicoPrestado(this.listaErros));
        buf.append(this.getValoresServicoPrestado(this.listaErros));
        buf.append(this.getPrestadorServico(this.listaErros));
        buf.append(this.getTomadorServico(this.listaErros));
        buf.append(this.getIntermediarioServico(this.listaErros));
        buf.append(this.getNFSeSubstituida(this.listaErros));
        buf.append(this.getConstrucaoCivil(this.listaErros));
        buf.append(this.getIdentificadorSistemaLegado(this.listaErros));
        buf.append(this.getAssinatura(this.listaErros));
        buf.append(this.getEquipamentoEmissorRPS(this.listaErros));
        buf.append(this.getNotaFiscalServicos(this.listaErros));
        buf.append(TAG_SALVAR_RPS);
        return buf.toString();
    }

    private String getDadosPDFNota(boolean apenasLinkDownload) throws IntegracaoTecnospeedException {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getCabecalhoPDFNota(apenasLinkDownload));
        return buf.toString();
    }

    private Map<String, String> getParametrosXMLNota(boolean apenasLinkDownload) {
        HashMap<String, String> parametros = new HashMap<String, String>();
        String nomeCidade = this.filialBean.getCidade().getNome().replace(" ", "");
        parametros.put("NomeCidade", nomeCidade);
        parametros.put("dtInicial", Funcoes.formataData("dd/MM/yyyy", this.notaBean.getDataEmissao()));
        parametros.put("dtFinal", Funcoes.formataData("dd/MM/yyyy", this.notaBean.getDataEmissao()));
        parametros.put("Tipo", TecnospeedUtil.TipoExportacaoXML.AUTORIZACAO.toString());
        parametros.put("nInicial", this.notaBean.getNumero().toString());
        parametros.put("nFinal", this.notaBean.getNumero().toString());
        if (apenasLinkDownload) {
            parametros.put("URL", "1");
        }
        return parametros;
    }

    private String getCabecalhoEnvioRps(ArrayList<ErrosCampos> listaErros) {
        GrupoCabecalhoEnvioRps grupo = new GrupoCabecalhoEnvioRps();
        String nomeCidade = this.filialBean.getCidade().getNome().replace(" ", "");
        grupo.nomeCidade.setValor(nomeCidade, null, null, null);
        grupo.formato.setValor("tx2", null, null, null);
        grupo.padrao.setValor("TecnoNFSe", null, null, null);
        listaErros.addAll(grupo.getListaErros());
        return grupo.escreveGrupo(this.padraoNFSe);
    }

    private String getCabecalhoPDFNota(boolean apenasLinkDownload) throws IntegracaoTecnospeedException {
        GrupoCabecalhoPDFNota grupo = new GrupoCabecalhoPDFNota();
        String nomeCidade = this.filialBean.getCidade().getNome().replace(" ", "");
        grupo.nomeCidade.setValor(nomeCidade, this.filialBean.getCidade(), this.filialBean, "nome");
        grupo.numNFSe.setValor(this.notaBean.getNumero(), this.notaBean, null, "numero");
        if (apenasLinkDownload) {
            grupo.url.setValor(1, null, null, null);
        }
        return grupo.escreveGrupo(this.padraoNFSe);
    }

    private String getDadosLoteRPS(ArrayList<ErrosCampos> listaErros) {
        GrupoDadosLoteRPS grupo = new GrupoDadosLoteRPS();
        grupo.idLote.setValor(null, null, null, null);
        grupo.numeroLote.setValor(1, null, null, null);
        grupo.cpfCnpjRemetente.setValor(StringUtil.limpaString(this.filialBean.getCnpj(), new String[]{"-", ".", "/"}), this.filialBean, null, "cnpj", true);
        grupo.inscricaoMunicipalRemetente.setValor(this.filialBean.getInscricaoMunicipal(), this.tipoCadastro.equals("P") || this.tipoCadastro.equals("E") ? null : this.filialBean, null, "inscrMunicipal", false);
        grupo.razaoSocialRemetente.setValor(this.filialBean.getRazaoSocial(), this.filialBean, null, "razaoSocial", true);
        grupo.codigoCidadeRemetente.setValor(this.filialBean.getCidade() == null ? null : this.filialBean.getCidade().getCodigoIbge(), this.filialBean.getCidade() == null ? new CidadeVO() : this.filialBean.getCidade(), this.filialBean, "codigoIbge", true);
        grupo.quantidadeRps.setValor(1, null, null, null);
        grupo.transacao.setValor("true", null, null, null);
        grupo.dataInicio.setValor(new Date(), null, null, null);
        grupo.dataFim.setValor(new Date(), null, null, null);
        grupo.versao.setValor(null, null, null, null);
        grupo.metodoEnvio.setValor("WS", null, null, null);
        grupo.valorTotalServicos.setValor(this.notaServico.getValor(), this.notaServico, null, "valor", true);
        grupo.valorTotalDeducoes.setValor(this.notaBean.getValorDeducoes(), this.notaBean, null, "valorDeducoes", true);
        grupo.valorTotalBaseCalculo.setValor(this.getBaseCalculoNota().doubleValue(), this.notaBean, null, "baseCalculo", true);
        return this.getValorGrupo(listaErros, grupo);
    }

    private String getIdentificadoresRPS(ArrayList<ErrosCampos> listaErros) {
        GrupoIdentificadoresRPS grupo = new GrupoIdentificadoresRPS();
        grupo.idRps.setValor(null, null, null, null);
        if (this.notaBean.getNumeroRps() < 0L) {
            grupo.numeroRps.setValor(0, this.notaBean, null, "numeroRps", true);
            grupo.idIntegracao.setValor(this.notaBean.getNumeroRps() * -1L, this.notaBean, null, "IDIntegracao", true);
        } else if (this.notaBean.getSerie().getSolicitarRps().booleanValue()) {
            Long rpsTemp = NotaFiscalService.getRpsTemporario(this.notaBean);
            grupo.idIntegracao.setValor(rpsTemp, this.notaBean, null, "IDIntegracao", true);
            grupo.numeroRps.setValor(this.notaBean.getNumeroRps(), this.notaBean, null, "numeroRps", true);
        } else {
            grupo.numeroRps.setValor(this.notaBean.getNumeroRps(), this.notaBean, null, "numeroRps", true);
        }
        grupo.serieRps.setValor(this.notaBean.getSerie() == null ? null : this.notaBean.getSerie().getCodigo(), this.notaBean.getSerie() == null ? new SeriesBean() : this.notaBean.getSerie(), this.notaBean, "codigo", true);
        grupo.tipoRps.setValor("1", null, null, null);
        return this.getValorGrupo(listaErros, grupo);
    }

    private String getDataEmissaoRPS(ArrayList<ErrosCampos> listaErros) {
        GrupoDataEmissaoRPS grupo = new GrupoDataEmissaoRPS();
        grupo.dataEmissao.setValor(new Date(), null, null, null);
        return this.getValorGrupo(listaErros, grupo);
    }

    private String getOptanteSimplesNacional(ArrayList<ErrosCampos> listaErros) {
        GrupoOptanteSimplesNacional grupo = new GrupoOptanteSimplesNacional();
        grupo.optanteSimplesNacional.setValor(this.filialBean.getOptanteSimplesNacional() != false ? TecnospeedUtil.OptanteSimplesNacional.SIM_OPTANTE.getCodigo() : TecnospeedUtil.OptanteSimplesNacional.NAO_OPTANTE.getCodigo(), this.filialBean, null, "optanteSimplesNacional", true);
        return this.getValorGrupo(listaErros, grupo);
    }

    private String getOpcaoIncentivadorCultural(ArrayList<ErrosCampos> listaErros) {
        GrupoOpcaoIncentivadorCultural grupo = new GrupoOpcaoIncentivadorCultural();
        grupo.incentivadorCultural.setValor(this.filialBean.getIncentivadorCultural() != false ? TecnospeedUtil.OpcaoIncentivadorCultural.SIM.getCodigo() : TecnospeedUtil.OpcaoIncentivadorCultural.NAO.getCodigo(), this.filialBean, null, "incentivadorCultural", true);
        grupo.incentivoFiscal.setValor(this.filialBean.getIncentivoFiscal() != false ? 1 : 2, this.filialBean, null, "incentivoFiscal", true);
        return this.getValorGrupo(listaErros, grupo);
    }

    private String getOpcaoTipoTributacao(ArrayList<ErrosCampos> listaErros) {
        GrupoOpcaoTipoTributacao grupo = new GrupoOpcaoTipoTributacao();
        if (this.servico.getTipoTributacao() != null && Funcoes.isNumeric(this.servico.getTipoTributacao())) {
            grupo.tipoTributacao.setValor(Integer.parseInt(this.servico.getTipoTributacao()), this.servico, null, "tipoTributacao", true);
        } else {
            grupo.tipoTributacao.setValor(null, this.servico, null, "tipoTributacao", true);
        }
        return this.getValorGrupo(listaErros, grupo);
    }

    private String getValorGrupo(ArrayList<ErrosCampos> listaErros, Grupo grupo) {
        String valorGrupo = grupo.escreveGrupo(this.padraoNFSe);
        listaErros.addAll(grupo.getListaErros());
        return valorGrupo;
    }

    private String getNaturezaTributacao(ArrayList<ErrosCampos> listaErros) {
        GrupoNaturezaTributacao grupo = new GrupoNaturezaTributacao();
        if (!Funcoes.isNumeric(this.servico.getTipoTributacao())) {
            grupo.naturezaTributacao.setValor(null, this.servico, null, "naturezaOperacao");
        } else {
            grupo.naturezaTributacao.setValor(this.servico.getTipoTributacao() != null ? Integer.parseInt(this.servico.getTipoTributacao()) : 0, this.servico, null, "naturezaOperacao", true);
        }
        return this.getValorGrupo(listaErros, grupo);
    }

    private String getRegimeEspecialTributacao(ArrayList<ErrosCampos> listaErros) {
        GrupoRegimeEspecialTributacao grupo = new GrupoRegimeEspecialTributacao();
        if (this.filialBean.getRegimeEspecialTributacao() != null) {
            grupo.regimeEspecialTributacao.setValor(Integer.parseInt(this.filialBean.getRegimeEspecialTributacao()), this.filialBean, null, "regimeEspecialTributacao", true);
        } else {
            grupo.regimeEspecialTributacao.setValor(null, null, null, null, true);
        }
        return this.getValorGrupo(listaErros, grupo);
    }

    private String getSituacaoNota(ArrayList<ErrosCampos> listaErros) {
        GrupoSituacaoNota grupo = new GrupoSituacaoNota();
        grupo.situacaoNota.setValor(TecnospeedUtil.SituacaoNota.NORMAL.getCodigo(), null, null, null);
        grupo.motCancelamento.setValor(null, null, null, null);
        return this.getValorGrupo(listaErros, grupo);
    }

    private String getSubstituicaoRPS(ArrayList<ErrosCampos> listaErros) {
        GrupoSubstituicaoRPS grupo = new GrupoSubstituicaoRPS();
        grupo.numeroRpsSubstituido.setValor(null, null, null, null);
        grupo.serieRpsSubstituido.setValor(null, null, null, null);
        grupo.tipoRpsSubstituido.setValor(null, null, null, null);
        return this.getValorGrupo(listaErros, grupo);
    }

    private String getServicoPrestado(ArrayList<ErrosCampos> listaErros) {
        GrupoServicoPrestado grupo = new GrupoServicoPrestado();
        grupo.quantidadeServicos.setValor(1, null, null, null);
        grupo.issRetido.setValor(this.notaBean.getValorISSRetido() > 0.0 ? 1 : 2, this.notaBean, null, "valorISSRetido");
        grupo.codigoItemListaServico.setValor(this.servico.getItemLista(), this.servico, null, "itemLista", true);
        grupo.codigoSubItemListaServico.setValor(null, null, null, null);
        grupo.codigoCnae.setValor(Funcoes.textoVazio(this.filialBean.getCodigoCnae()) ? null : Integer.valueOf(Integer.parseInt(this.filialBean.getCodigoCnae())), this.filialBean, null, "codigoCnae");
        grupo.codigoTributacaoMunicipio.setValor(this.servico.getCodigoTributacaoMunicipio(), this.servico, null, "codigoTributacaoMunicipio", true);
        String discriminacao = this.servico.getDescricao();
        if (!Funcoes.textoVazio(this.notaBean.getObservacao())) {
            discriminacao = discriminacao.replace(CARACTERE_SEPARACAO_CAMPOS, "|") + " | " + this.notaBean.getObservacao().replace(CARACTERE_SEPARACAO_CAMPOS, "|");
        }
        grupo.discriminacaoServico.setValor(discriminacao, this.servico, null, "descricao", true);
        grupo.descricaoRPS.setValor(!Funcoes.textoVazio(this.notaBean.getObservacao()) ? this.notaBean.getObservacao().replace(CARACTERE_SEPARACAO_CAMPOS, "|") : this.servico.getDescricao(), this.servico, null, "descricao", true);
        if (this.servico.getTipoTributacao() != null && this.servico.getTipoTributacao().equalsIgnoreCase(String.valueOf(TecnospeedUtil.Tributacao.TRIBUTAVEL_FORA_MUNICIPIO.getCodigo())) && null != this.convenio) {
            grupo.codigoCidadePrestacao.setValor(this.convenio.getCidade() == null ? null : this.convenio.getCidade().getCodigoIbge(), this.convenio.getCidade() == null ? new CidadeBean() : this.convenio.getCidade(), this.filialBean, "codigoIbge", true);
            grupo.descricaoCidadePrestacao.setValor(this.convenio.getCidade() == null ? null : this.convenio.getCidade().getNome(), this.convenio.getCidade() == null ? new CidadeBean() : this.convenio.getCidade(), this.filialBean, "nome", true);
            grupo.municipioIncidencia.setValor(this.convenio.getCidade() == null ? null : this.convenio.getCidade().getCodigoIbge(), this.convenio.getCidade() == null ? new CidadeVO() : this.convenio.getCidade(), this.filialBean, "codigoIbge", true);
        } else {
            grupo.codigoCidadePrestacao.setValor(this.filialBean.getCidade() == null ? null : this.filialBean.getCidade().getCodigoIbge(), this.filialBean.getCidade() == null ? new CidadeBean() : this.filialBean.getCidade(), this.filialBean, "codigoIbge", true);
            grupo.descricaoCidadePrestacao.setValor(this.filialBean.getCidade() == null ? null : this.filialBean.getCidade().getNome(), this.filialBean.getCidade() == null ? new CidadeBean() : this.filialBean.getCidade(), this.filialBean, "nome", true);
            grupo.municipioIncidencia.setValor(this.filialBean.getCidade() == null ? null : this.filialBean.getCidade().getCodigoIbge(), this.filialBean.getCidade() == null ? new CidadeBean() : this.filialBean.getCidade(), this.filialBean, "codigoIbge", true);
        }
        grupo.exigibilidadeISS.setValor(this.servico.getExigibilidadeIss(), this.servico, null, "exigibilidadeIss", true);
        grupo.competencia.setValor(new Date(), null, null, null);
        if (this.notaBean.getValorISSRetido() > 0.0) {
            grupo.responsavelRetencao.setValor(1, null, null, null);
        }
        if (!Funcoes.textoVazio(this.servico.getTributavel())) {
            grupo.tributavel.setValor(this.servico.getTributavel().equalsIgnoreCase("S") ? 1 : 0, this.servico, null, "tributavel", true);
        }
        grupo.codigoPais.setValor(null, null, null, null);
        grupo.operacao.setValor(this.servico.getNaturezaOperacao(), this.servico, null, "naturezaOperacao", true);
        return this.getValorGrupo(listaErros, grupo);
    }

    private String getValoresServicoPrestado(ArrayList<ErrosCampos> listaErros) {
        GrupoValoresServicoPrestado grupo = new GrupoValoresServicoPrestado();
        grupo.valorServicos.setValor(this.notaBean.getSubTotal(), this.notaBean, null, "subTotal");
        boolean isDeducao = this.notaBean.getServico() != null && this.notaBean.getServico().getServico() != null && this.notaBean.getServico().getServico().getEnviaDeducaoNfe() != false;
        grupo.valorDeducoes.setValor(isDeducao ? this.notaBean.getValorDeducoes() : Integer.valueOf(0), this.notaBean, null, null);
        if (this.notaBean.getIssValor() > 0.0 && !this.notaBean.getFilial().getSimplesNacional().booleanValue()) {
            grupo.valorIss.setValor(this.notaBean.getIssValor(), this.notaBean, null, "issValor");
        } else if (this.notaBean.getValorISSRetido() > 0.0) {
            grupo.valorIss.setValor(this.notaBean.getValorISSRetido(), null, null, "issRetido");
        }
        if (this.notaBean.getValorPisRetido() > 0.0) {
            grupo.valorPis.setValor(this.notaBean.getValorPisRetido(), this.notaBean, null, "pisValor");
        }
        if (this.notaBean.getValorCofinsRetido() > 0.0) {
            grupo.valorCofins.setValor(this.notaBean.getValorCofinsRetido(), this.notaBean, null, "cofinsValor");
        }
        if (this.notaBean.getValorInssRetido() > 0.0) {
            grupo.valorInss.setValor(this.notaBean.getValorInssRetido(), this.notaBean, null, "inssValor");
        }
        if (this.notaBean.getValorIrrfRetido() > 0.0) {
            grupo.valorIr.setValor(this.notaBean.getValorIrrfRetido(), this.notaBean, null, "irrfValor");
        }
        if (this.notaBean.getValorCsllRetido() > 0.0) {
            grupo.valorCsll.setValor(this.notaBean.getValorCsllRetido(), this.notaBean, null, "csllValor");
        }
        grupo.baseCalculo.setValor(this.getBaseCalculoNota().doubleValue(), this.notaBean, null, "baseCalculo");
        grupo.valorLiquidoNfse.setValor(this.notaBean.getValorLiquido(), this.notaBean, null, "valorLiquido");
        grupo.valorUnitarioServico.setValor(this.notaServico.getValor(), this.notaServico, null, "valor");
        grupo.descontoIncondicionado.setValor(this.notaBean.getValorDescontoIncondicionado(), this.notaBean, null, "valorDescontoIncondicionado");
        grupo.descontoCondicionado.setValor(0.0, null, null, null);
        grupo.aliquotaISS.setValor(this.notaBean.getPercentualISSRetido() > 0.0 ? this.notaBean.getPercentualISSRetido() : this.notaBean.getIssPercentual(), this.notaBean, null, "issPercentual");
        grupo.aliquotaPIS.setValor(this.notaBean.getPercentualPisRetido() > 0.0 ? this.notaBean.getPercentualPisRetido() : this.notaBean.getPisPercentual(), this.notaBean, null, "pisPercentual");
        grupo.aliquotaCOFINS.setValor(this.notaBean.getPercentualCofinsRetido() > 0.0 ? this.notaBean.getPercentualCofinsRetido() : this.notaBean.getCofinsPercentual(), this.notaBean, null, "cofinsPercentual");
        grupo.aliquotaINSS.setValor(this.notaBean.getPercentualInssRetido() > 0.0 ? this.notaBean.getPercentualInssRetido() : this.notaBean.getInssPercentual(), this.notaBean, null, "inssPercentual");
        grupo.aliquotaIR.setValor(this.notaBean.getPercentualIrrfRetido() > 0.0 ? this.notaBean.getPercentualIrrfRetido() : this.notaBean.getIrrfPercentual(), this.notaBean, null, "irrfPercentual");
        grupo.aliquotaCSLL.setValor(this.notaBean.getPercentualCsllRetido() > 0.0 ? this.notaBean.getPercentualCsllRetido() : this.notaBean.getCsllPercentual(), this.notaBean, null, "csllPercentual");
        return this.getValorGrupo(listaErros, grupo);
    }

    private BigDecimal getBaseCalculoNota() {
        double valorBaseCalculo = this.notaBean.getImpostoAcumulado();
        BigDecimal baseCalculo = new BigDecimal(valorBaseCalculo);
        baseCalculo = baseCalculo.setScale(this.CASAS, this.ROUND);
        return baseCalculo;
    }

    private String getPrestadorServico(ArrayList<ErrosCampos> listaErros) {
        String foneCompleto = this.filialBean.getFone();
        Integer ddd = Funcoes.getDDD(foneCompleto);
        Integer fone = Funcoes.getTelefone(foneCompleto);
        GrupoPrestadorServico grupo = new GrupoPrestadorServico();
        grupo.cpfCnpjPrestador.setValor(StringUtil.limpaString(this.filialBean.getCnpj(), new String[]{"-", ".", "/"}), this.filialBean, null, "cnpj", true);
        grupo.inscricaoMunicipalPrestador.setValor(this.filialBean.getInscricaoMunicipal(), this.filialBean, null, "inscricaoMunicipal", true);
        grupo.razaoSocialPrestador.setValor(StringUtil.trataCaracteresEspeciais(this.filialBean.getRazaoSocial()), this.filialBean, null, "razaoSocial", true);
        grupo.dddPrestador.setValor(ddd, this.filialBean, null, "fone");
        grupo.telefonePrestador.setValor(fone, this.filialBean, null, "fone");
        grupo.seriePrestacao.setValor(99, null, null, null);
        grupo.enderecoPrestador.setValor(this.filialBean.getEndereco(), this.filialBean, null, "endereco", true);
        return this.getValorGrupo(listaErros, grupo);
    }

    private String getTomadorServico(ArrayList<ErrosCampos> listaErros) {
        ArrayList<String> listaEmails;
        String email;
        Integer codigoMunicipio;
        String bairro;
        GrupoTomadorServico grupo = new GrupoTomadorServico();
        String cpfCnpj = this.getCpfCnpj();
        if (this.isConvenio()) {
            grupo.cpfCnpjTomador.setValor(cpfCnpj, this.convenio, null, "cnpjCpf", true);
        } else {
            grupo.cpfCnpjTomador.setValor(cpfCnpj, this.notaBean, null, "cpfPagador", true);
        }
        String razaSocialTomador = this.getRazaoSocialTomador();
        grupo.razaoSocialTomador.setValor(razaSocialTomador, this.isConvenio() ? this.convenio : this.notaBean, null, this.tipoCadastro.equals("P") ? "nomePagador" : "razaoSocial", true);
        grupo.inscricaoMunicipalTomador.setValor(this.isConvenio() ? this.convenio.getInscrMunicipal() : null, this.isConvenio() ? this.convenio : null, null, "inscrMunicipal");
        grupo.inscricaoEstadualTomador.setValor(this.isConvenio() ? this.convenio.getInscrEstadual() : null, this.isConvenio() ? this.convenio : null, null, "inscrEstadual");
        grupo.docTomadorEstrangeiro.setValor(null, null, null, null);
        grupo.tipoLogradouroTomador.setValor(this.isConvenio() ? this.convenio.getTipoLogradouro() : this.paciente.getTipoLogradouro(), this.isConvenio() ? this.convenio : this.paciente, null, "tipoLogradouro");
        grupo.enderecoTomador.setValor(this.isConvenio() ? this.convenio.getEndereco() : this.paciente.getEndereco(), this.isConvenio() ? this.convenio : this.paciente, null, "endereco", true);
        String numero = null;
        if (this.paciente != null && !Funcoes.textoVazio(this.paciente.getNumeroEndereco()) && this.paciente.getNumeroEndereco() != null || this.convenio != null && !Funcoes.textoVazio(this.convenio.getNumeroEndereco()) && this.convenio.getNumeroEndereco() != null) {
            numero = this.isConvenio() ? this.convenio.getNumeroEndereco() : this.paciente.getNumeroEndereco();
        }
        grupo.numeroTomador.setValor(numero, this.isConvenio() ? this.convenio : this.paciente, null, "numeroEndereco", true);
        grupo.complementoTomador.setValor(this.isConvenio() ? this.convenio.getComplemento() : this.paciente.getComplemento(), this.isConvenio() ? this.convenio : this.paciente, null, "complemento");
        grupo.tipoBairroTomador.setValor(null, null, null, null);
        String string = this.isConvenio() ? (this.convenio.getBairro() == null ? null : this.convenio.getBairro().getDescricao()) : (bairro = this.paciente.getBairro() == null ? null : this.paciente.getBairro().getDescricao());
        AbstractThreadBean bean = this.isConvenio() ? (this.convenio.getBairro() == null ? new BairroBean() : this.convenio.getBairro()) : (this.paciente.getBairro() == null ? new BairroBean() : this.paciente.getBairro());
        AbstractThreadBean beanPai = this.isConvenio() ? this.convenio : this.paciente;
        grupo.bairroTomador.setValor(bairro, bean, beanPai, "descricao");
        Integer n = this.isConvenio() ? (this.convenio.getCidade() == null ? null : this.convenio.getCidade().getCodigoIbge()) : (codigoMunicipio = this.paciente.getCidade() == null ? null : this.paciente.getCidade().getCodigoIbge());
        AbstractThreadBean beanCidade = this.isConvenio() ? (this.convenio.getCidade() == null ? new CidadeBean() : this.convenio.getCidade()) : (this.paciente.getCidade() == null ? new CidadeBean() : this.paciente.getCidade());
        grupo.codigoCidadeTomador.setValor(codigoMunicipio, beanCidade, beanPai, "codigoIbge", true);
        String descricaoMunicipio = this.isConvenio() ? (this.convenio.getCidade() == null ? null : this.convenio.getCidade().getNome()) : (this.paciente.getCidade() == null ? null : this.paciente.getCidade().getNome());
        grupo.descricaoCidadeTomador.setValor(descricaoMunicipio, beanCidade, beanPai, "nome", true);
        String uf = this.isConvenio() ? (this.convenio.getCidade() == null ? null : this.convenio.getCidade().getUf()) : (this.paciente.getCidade() == null ? null : this.paciente.getCidade().getUf());
        grupo.ufTomador.setValor(uf, beanCidade, beanPai, "uf", true);
        String cep = this.isConvenio() ? (Funcoes.textoVazio(this.convenio.getCep()) ? null : this.convenio.getCep().replace("-", "")) : (Funcoes.textoVazio(this.paciente.getCep()) ? null : this.paciente.getCep().replaceAll("-", ""));
        grupo.cepTomador.setValor(cep, this.isConvenio() ? this.convenio : this.paciente, null, "cep");
        String telefonePessoaFisica = "";
        if (!this.isConvenio()) {
            telefonePessoaFisica = !Funcoes.textoVazio(StringUtil.limpaString(this.paciente.getFone(), new String[]{"(", ")", "-"})) ? this.paciente.getFone() : this.paciente.getCelular();
        }
        String foneCompleto = this.isConvenio() ? this.convenio.getFone() : telefonePessoaFisica;
        Integer ddd = 0;
        Integer fone = 0;
        String auxFone = StringUtil.limpaString(foneCompleto, new String[]{"(", ")", "-"});
        if (!Funcoes.textoVazio(foneCompleto) && foneCompleto.contains("(") && !Funcoes.textoVazio(auxFone)) {
            ddd = Funcoes.getDDD(foneCompleto);
            fone = Funcoes.getTelefone(foneCompleto);
        } else if (!Funcoes.textoVazio(auxFone) && auxFone.length() > 8) {
            ddd = Integer.parseInt(auxFone.substring(0, 2));
            fone = Integer.parseInt(auxFone.substring(2));
        }
        grupo.dddTomador.setValor(ddd, null, null, null);
        grupo.telefoneTomador.setValor(fone, this.isConvenio() ? this.convenio : this.paciente, null, "fone");
        grupo.tipoTelefoneTomador.setValor(null, null, null, null);
        String string2 = email = this.isConvenio() ? this.convenio.getEmail1() : this.paciente.getEmail();
        if (!Funcoes.textoVazio(email) && (listaEmails = StringUtil.explode(email, ";, ")) != null) {
            email = listaEmails.get(0);
        }
        grupo.emailTomador.setValor(email, this.isConvenio() ? this.convenio : this.paciente, null, this.isConvenio() ? "email1" : "email");
        grupo.tipoDocumentoTomador.setValor(cpfCnpj.length() == 11 ? TecnospeedUtil.TipoDocumentoTomador.CPF.getCodigo() : TecnospeedUtil.TipoDocumentoTomador.CNPJ.getCodigo(), null, null, null);
        grupo.descricaoDocumentoTomador.setValor(null, null, null, null);
        grupo.cidadeEstrangeiraTomador.setValor(null, null, null, null);
        grupo.paisTomador.setValor(null, null, null, null);
        return this.getValorGrupo(listaErros, grupo);
    }

    private boolean isConvenio() {
        return this.tipoCadastro.equals("O");
    }

    private String getCpfCnpj() {
        String numDoc = "";
        if (this.tipoCadastro.equals("P")) {
            numDoc = StringUtil.limpaString(this.notaBean.getCpfPagador(), new String[]{".", "-", "/"});
        } else if (this.tipoCadastro.equals("E")) {
            numDoc = !Funcoes.textoVazio(this.paciente.getCnpj()) ? StringUtil.limpaString(this.paciente.getCnpj(), new String[]{".", "-", "/"}) : StringUtil.limpaString(this.paciente.getCpf(), new String[]{".", "-", "/"});
        } else if (this.tipoCadastro.equals("E")) {
            numDoc = StringUtil.limpaString(this.convenio.getCnpjCpf(), new String[]{".", "-", "/"});
        }
        return numDoc;
    }

    private String getRazaoSocialTomador() {
        StringBuilder razao = new StringBuilder();
        razao.append(this.isConvenio() ? this.convenio.getRazaoSocial() : "");
        razao.append(this.tipoCadastro.equals("E") ? this.paciente.getRazaoSocial() : "");
        razao.append(this.tipoCadastro.equals("P") ? this.notaBean.getNomePagador() : "");
        return razao.toString();
    }

    private String getIntermediarioServico(ArrayList<ErrosCampos> listaErros) {
        GrupoIntermediarioServico grupo = new GrupoIntermediarioServico();
        grupo.cpfCnpjIntermediario.setValor(null, null, null, null);
        grupo.inscricaoMunicipalIntermediario.setValor(null, null, null, null);
        grupo.razaoSocialIntermediario.setValor(null, null, null, null);
        return this.getValorGrupo(listaErros, grupo);
    }

    private String getNFSeSubstituida(ArrayList<ErrosCampos> listaErros) {
        GrupoNFSeSubstituida grupo = new GrupoNFSeSubstituida();
        grupo.numeroNfseSubstituida.setValor(null, null, null, null);
        grupo.dataEmissaoNfseSubstituida.setValor(null, null, null, null);
        return this.getValorGrupo(listaErros, grupo);
    }

    private String getConstrucaoCivil(ArrayList<ErrosCampos> listaErros) {
        GrupoConstrucaoCivil grupo = new GrupoConstrucaoCivil();
        grupo.codigoObra.setValor(null, null, null, null);
        grupo.art.setValor(null, null, null, null);
        return this.getValorGrupo(listaErros, grupo);
    }

    private String getDeducaoServico() throws IntegracaoTecnospeedException {
        GrupoDeducaoServico grupo = new GrupoDeducaoServico();
        grupo.deducaoPor.setValor(this.servico.getTipoCalculoDeducao(), this.servico, null, "tipoCalculoDeducao");
        grupo.tipoDeducao.setValor(this.servico.getTipoDeducao(), this.servico, null, "tipoDeducao");
        grupo.percentualDeduzir.setValor(this.servico.getPercentualDeduzir(), this.servico, null, "percentualDeduzir");
        grupo.cpfCNPJReferencia.setValor(null, null, null, null);
        grupo.numeroNfReferencia.setValor(null, null, null, null);
        grupo.valorTotalReferencia.setValor(null, null, null, null);
        grupo.justificativaDeducao.setValor(null, null, null, null);
        return grupo.escreveGrupo(this.padraoNFSe);
    }

    private String getIdentificadorSistemaLegado(ArrayList<ErrosCampos> listaErros) {
        GrupoIdentificadorSistemaLegado grupo = new GrupoIdentificadorSistemaLegado();
        grupo.identificadorSistemaLegado.setValor(null, null, null, null);
        return this.getValorGrupo(listaErros, grupo);
    }

    private String getAssinatura(ArrayList<ErrosCampos> listaErros) {
        GrupoAssinatura grupo = new GrupoAssinatura();
        grupo.assinatura.setValor(null, null, null, null);
        return this.getValorGrupo(listaErros, grupo);
    }

    private String getEquipamentoEmissorRPS(ArrayList<ErrosCampos> listaErros) {
        GrupoEquipamentoEmissorRPS grupo = new GrupoEquipamentoEmissorRPS();
        grupo.numEmissorRps.setValor(null, null, null, null);
        return this.getValorGrupo(listaErros, grupo);
    }

    private String getNotaFiscalServicos(ArrayList<ErrosCampos> listaErros) {
        GrupoNotaFiscalServicos grupo = new GrupoNotaFiscalServicos();
        grupo.numeroNfse.setValor(null, null, null, null);
        grupo.serieNfse.setValor(null, null, null, null);
        grupo.dataEmissaoNfse.setValor(null, null, null, null);
        return this.getValorGrupo(listaErros, grupo);
    }

    public boolean resolveNotaFiscalEletronica(NotaFiscalBean notaBean) throws Exception {
        if (notaBean == null) {
            return false;
        }
        this.notaBean = notaBean;
        try {
            this.filialBean = (FilialBean)new FilialService().get(String.valueOf(notaBean.getFilial().getCodigo()));
        }
        catch (Exception e) {
            throw new Exception("N\u00e3o foi poss\u00edvel buscar dados da filial. C\u00f3digo: " + String.valueOf(notaBean.getFilial().getCodigo()) + ".\n" + e.getMessage());
        }
        if (this.filialBean.getPadraoLayoutNFSe() == null) {
            throw new Exception("Padr\u00e3o de layout de nota fiscal eletr\u00f4nica n\u00e3o definido.");
        }
        this.padraoNFSe = TecnospeedUtil.Padrao.get(this.filialBean.getPadraoLayoutNFSe());
        Map<String, String> parametros = this.getParametrosResolveNota();
        try {
            String retorno = ComunicacaoTecnospeed.comunicaPost("resolve", parametros, this.filialBean.getCnpj(), String.valueOf(this.filialBean.getCodigo()), false);
            if (Funcoes.textoVazio(retorno)) {
                return false;
            }
            if (Funcoes.isNumeric(retorno)) {
                return true;
            }
            if (debug) {
                System.out.println(retorno);
            }
            return this.processaRetornoTecnospeed(notaBean, this.getObjetoRetornoTecnospeed(retorno));
        }
        catch (Exception e) {
            System.out.println("N\u00e3o foi poss\u00edvel resolver RPS: " + e.getMessage());
            e.printStackTrace();
            return true;
        }
    }

    public boolean consultarNotaFiscalEletronica(NotaFiscalBean notaBean) throws Exception {
        if (notaBean == null) {
            return false;
        }
        this.notaBean = notaBean;
        try {
            this.filialBean = (FilialBean)new FilialService().get(String.valueOf(notaBean.getFilial().getCodigo()));
        }
        catch (Exception e) {
            throw new Exception("N\u00e3o foi poss\u00edvel buscar dados da filial. C\u00f3digo: " + String.valueOf(notaBean.getFilial().getCodigo()) + ".\n" + e.getMessage());
        }
        if (this.filialBean.getPadraoLayoutNFSe() == null) {
            throw new Exception("Padr\u00e3o de layout de nota fiscal eletr\u00f4nica n\u00e3o definido.");
        }
        this.padraoNFSe = TecnospeedUtil.Padrao.get(this.filialBean.getPadraoLayoutNFSe());
        String parametros = this.getParametrosConsultaNota();
        try {
            String retorno = ComunicacaoTecnospeed.enviaGet("consulta", parametros, this.filialBean.getCnpj(), String.valueOf(this.filialBean.getCodigo()), false);
            if (debug) {
                System.out.println(retorno);
            }
            return this.processaRetornoConsulta(notaBean, retorno);
        }
        catch (Exception e) {
            if (e.toString().contains("N\u00e3o foi poss\u00edvel realizar get") || e.toString().contains("managersaas.tecnospeed.com.br")) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar no servidor Tecnospeed.\nFavor verifique a conex\u00e3o com a internet.", 2);
            } else {
                e.printStackTrace();
            }
            return true;
        }
    }

    private boolean processaRetornoConsulta(NotaFiscalBean notaBean, String retorno) {
        String[] dados = retorno.split(",");
        if (null != dados && dados.length > 0) {
            String numeroNfse = dados[0];
            String situacao = dados[1];
            String numeroProtocolo = dados[2];
            String lote = dados[3];
            String numeroRps = dados[4];
            String idIntegracao = dados[5];
            RetornoTecnospeed objRetorno = new RetornoTecnospeed();
            objRetorno.setNumeroNFSe(Long.parseLong(numeroNfse));
            objRetorno.setHandle(Long.parseLong(numeroProtocolo));
            objRetorno.setLote(Long.parseLong(lote));
            objRetorno.setStatusRetorno(situacao);
            objRetorno.setNumeroRps(Long.parseLong(numeroRps));
            objRetorno.setIdIntegracao(Long.parseLong(idIntegracao));
            if (!Funcoes.textoVazio(situacao) && situacao.equalsIgnoreCase("AUTORIZADA") && !Funcoes.textoVazio(numeroNfse)) {
                String retornoAutorizacaoJalis = this.autorizaNFSeJalis(notaBean, objRetorno);
                if (Funcoes.textoVazio(retornoAutorizacaoJalis)) {
                    this.getPDFNota(true);
                    this.getZipXMLNota(true);
                    Funcoes.mensagem(Laboratorio.getInstancia(), "A nota fiscal foi autorizada com o n\u00famero \"" + objRetorno.getNumeroNFSe() + "\".", 5);
                    return true;
                }
                Funcoes.mensagem(Laboratorio.getInstancia(), "Um erro ocorreu ao autorizar a NFSe na base de dados do Jalis.\n" + retornoAutorizacaoJalis, 2);
                return false;
            }
            if (!Funcoes.textoVazio(situacao) && situacao.equalsIgnoreCase("ENVIADA")) {
                try {
                    return this.resolveNotaFiscalEletronica(notaBean);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel resolver o pedido de rps.\n" + e.getMessage(), e.getStackTrace());
                }
            } else if (!Funcoes.textoVazio(situacao) && situacao.equalsIgnoreCase("REJEITADA")) {
                try {
                    this.rejeitaNFSeJalis(notaBean, objRetorno);
                    return false;
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel resolver o pedido de rps.\n" + e.getMessage(), e.getStackTrace());
                }
            }
        } else {
            return false;
        }
        return false;
    }

    private boolean processaRetornoTecnospeed(NotaFiscalBean notaBean, RetornoTecnospeed objetoRetorno) {
        if (objetoRetorno == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar-se ao servidor, por favor verifique sua conex\u00e3o com a internet.", 2);
            return false;
        }
        if (objetoRetorno.isRejeicao()) {
            boolean isTimeOut;
            StringBuilder mensagem;
            String retornoRejeicaoJalis;
            block13: {
                retornoRejeicaoJalis = this.rejeitaNFSeJalis(notaBean, objetoRetorno);
                mensagem = new StringBuilder();
                String[] retorno = objetoRetorno.getStatusRetorno().split(",");
                isTimeOut = false;
                if (retorno != null) {
                    for (String s : retorno) {
                        if ((s = StringUtil.trocaCaracterUTF(s)).contains("Exeption") || s.contains("EXCEPTION") || s.contains("Espd")) continue;
                        if (s.contains("time out") || s.contains("tempo") && s.contains("limite")) {
                            isTimeOut = true;
                        }
                        mensagem.append(s).append(CARACTERE_SEPARACAO_CAMPOS);
                    }
                }
                if (mensagem.indexOf("idIntegracao") > 0 && mensagem.toString().contains("existe uma NFSe")) {
                    try {
                        if (!this.consultarNotaFiscalEletronica(notaBean)) {
                            if (this.descartaRPS(notaBean) ? this.enviaNotaFiscalEletronica(notaBean, true) : notaBean.getNumeroRps() < 0L && this.consultarNotaFiscalEletronica(notaBean)) {
                                return true;
                            }
                            break block13;
                        }
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (isTimeOut) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Problemas na comunica\u00e7\u00e3o com a prefeitura.\nPor favor aguarde alguns minutos e tente novamente.", 2);
                return false;
            }
            if (Funcoes.textoVazio(retornoRejeicaoJalis)) {
                Funcoes.mensagem(Laboratorio.getInstancia(), !Funcoes.textoVazio(objetoRetorno.getStatusRetorno()) ? objetoRetorno.getStatusRetorno() : mensagem.toString(), 2);
                return true;
            }
            Funcoes.mensagem(Laboratorio.getInstancia(), "Um erro ocorreu ao rejeitar a NFSe na base de dados do Jalis.\n" + retornoRejeicaoJalis, 2);
            return false;
        }
        String retornoAutorizacaoJalis = this.autorizaNFSeJalis(notaBean, objetoRetorno);
        if (Funcoes.textoVazio(retornoAutorizacaoJalis)) {
            this.getPDFNota(true);
            this.getZipXMLNota(true);
            Funcoes.mensagem(Laboratorio.getInstancia(), "A nota fiscal foi autorizada com o n\u00famero \"" + objetoRetorno.getNumeroNFSe() + "\".", 5);
            return true;
        }
        Funcoes.mensagem(Laboratorio.getInstancia(), "Um erro ocorreu ao autorizar a NFSe na base de dados do Jalis.\n" + retornoAutorizacaoJalis, 2);
        return false;
    }

    public boolean enviaNotaFiscalEletronica(NotaFiscalBean notaBean, boolean gerarNumeracaoRPS) {
        String xmlEnvio;
        block13: {
            if (notaBean == null) {
                return false;
            }
            if (gerarNumeracaoRPS || notaBean.getNumeroRps() == null || notaBean.getNumeroRps() == 0L || notaBean.getSerieAlterada().booleanValue()) {
                try {
                    notaBean.setNumeroRps(NotaFiscalService.getNumeroRPSComLock(notaBean));
                }
                catch (SQLException sqle) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter sequ\u00eancia do RPS.\n" + sqle.getMessage(), sqle.getStackTrace());
                    return false;
                }
            } else if (notaBean.getNumeroRps() == -1L) {
                notaBean.setNumeroRps(0L);
            }
            xmlEnvio = null;
            do {
                try {
                    this.preencheBean(notaBean);
                }
                catch (Exception sqle) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel montar os dados de envio para Tecnospeed.\n" + sqle.getMessage(), sqle.getStackTrace());
                    return false;
                }
                this.listaErros.clear();
                xmlEnvio = this.getDadosEnvioRps(this.listaErros);
                xmlEnvio = StringUtil.trataCaracteresEspeciais(xmlEnvio);
                if (debug) {
                    System.out.println(xmlEnvio);
                }
                if (this.listaErros.size() <= 0) break block13;
                DialogoErros janelaErro = new DialogoErros((Frame)Laboratorio.getInstancia(), this.listaErros);
                janelaErro.setVisible(true);
            } while (janelaErro.isOk());
            return false;
        }
        if (notaBean.getNumeroRps() == 0L) {
            this.enviaNotaFiscalEletronica(notaBean, true);
        } else {
            gerarNumeracaoRPS = false;
            if (!notaBean.getSituacao().equalsIgnoreCase("A")) {
                return this.enviaNotaFiscal(notaBean, xmlEnvio);
            }
        }
        return true;
    }

    private boolean enviaNotaFiscal(NotaFiscalBean notaBean, String xmlEnvio) {
        String retorno = null;
        try {
            retorno = ComunicacaoTecnospeed.enviaPost("envia", xmlEnvio, notaBean.getFilial().getCnpj(), String.valueOf(notaBean.getFilial().getCodigo()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Funcoes.textoVazio(retorno)) {
            return false;
        }
        if (debug) {
            System.out.println(retorno);
        }
        return this.processaRetornoTecnospeed(notaBean, this.getObjetoRetornoTecnospeed(retorno));
    }

    private String rejeitaNFSeJalis(NotaFiscalBean notaBean, RetornoTecnospeed objetoRetorno) {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append(" update notafiscal ");
        buf.append("    set nfi_statusnfse = null ");
        buf.append("       ,nfi_motivonfse = '").append(StringUtil.trocaCaracterUTF(objetoRetorno.getStatusRetorno())).append("' ");
        buf.append("       ,nfi_datastatusnfse = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date())).append("' ");
        buf.append("       ,nfi_protocolonfse = '").append(objetoRetorno.getHandle()).append("' ");
        buf.append("       ,nfi_chaverpsnfse = '").append(objetoRetorno.getLote()).append("' ");
        if (objetoRetorno.getNumeroRps() != null) {
            buf.append("       ,nfi_numerorps = ").append(objetoRetorno.getNumeroRps());
        }
        buf.append("       ,nfi_chavenfse = null ");
        buf.append("       ,nfi_situacao = '").append("R").append("' ");
        buf.append("       ,nfi_numero = ").append(objetoRetorno.getNumeroNFSe());
        buf.append("  where fil_codigo = ").append(notaBean.getFilial().getCodigo());
        buf.append("    and nfi_codigo = ").append(notaBean.getCodigo());
        try {
            int qtde = Conexao.executeUpdate(notaBean.getFilial().getCodigo().toString(), st, buf.toString(), false);
            if (qtde == 0) {
                throw new Exception("A nota fiscal n\u00e3o foi localizada. Filial = " + notaBean.getFilial().getCodigo() + ", c\u00f3digo nota = " + notaBean.getCodigo());
            }
            notaBean.setMotivoNfse(objetoRetorno.getStatusRetorno());
            notaBean.setDataStatusNfse(new Date());
            notaBean.setProtocoloNfse(objetoRetorno.getHandle() != null ? objetoRetorno.getHandle().toString() : null);
            if (objetoRetorno.getLote() != null) {
                notaBean.setChaveRpsNfse(objetoRetorno.getLote().toString());
            }
            if (objetoRetorno.getNumeroRps() != null && objetoRetorno.getNumeroRps() > 0L) {
                notaBean.setNumeroRps(objetoRetorno.getNumeroRps());
            }
            notaBean.setSituacao("R");
            Conexao.arquivaSQL();
        }
        catch (Exception sqle) {
            return sqle.getMessage();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String autorizaNFSeJalis(NotaFiscalBean notaBean, RetornoTecnospeed objetoRetorno) {
        int qtde;
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append(" update notafiscal ");
        buf.append("    set nfi_statusnfse = null ");
        buf.append("       ,nfi_motivonfse = '").append(StringUtil.trocaCaracterUTF(objetoRetorno.getStatusRetorno())).append("' ");
        buf.append("       ,nfi_datastatusnfse = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date())).append("' ");
        buf.append("       ,nfi_protocolonfse = '").append(objetoRetorno.getHandle()).append("' ");
        buf.append("       ,nfi_chaverpsnfse = '").append(objetoRetorno.getLote()).append("' ");
        buf.append("       ,nfi_chavenfse = null ");
        if (objetoRetorno.getNumeroRps() != null) {
            buf.append("       ,nfi_numerorps = ").append(objetoRetorno.getNumeroRps());
        }
        buf.append("       ,nfi_situacao = '").append("A").append("' ");
        buf.append("       ,nfi_numero = ").append(objetoRetorno.getNumeroNFSe());
        buf.append("  where fil_codigo = ").append(notaBean.getFilial().getCodigo());
        buf.append("    and nfi_codigo = ").append(notaBean.getCodigo());
        try {
            qtde = Conexao.executeUpdate(notaBean.getFilial().getCodigo().toString(), st, buf.toString(), false);
            if (qtde == 0) {
                throw new Exception("A nota fiscal n\u00e3o foi localizada. Filial = " + notaBean.getFilial().getCodigo() + ", c\u00f3digo nota = " + notaBean.getCodigo());
            }
            notaBean.setNumero(objetoRetorno.getNumeroNFSe());
            notaBean.setMotivoNfse(objetoRetorno.getStatusRetorno());
            notaBean.setDataStatusNfse(new Date());
            notaBean.setProtocoloNfse(objetoRetorno.getHandle().toString());
            notaBean.setNumeroRps(objetoRetorno.getNumeroRps());
            if (objetoRetorno.getLote() != null) {
                notaBean.setChaveRpsNfse(objetoRetorno.getLote().toString());
            }
            notaBean.setSituacao("A");
        }
        catch (Exception sqle) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return sqle.getMessage();
        }
        if (notaBean.getTipo().equalsIgnoreCase("F")) {
            buf.setLength(0);
            buf.append(" update receberpagar ");
            buf.append("    set rpg_situacao = '").append("Q").append("' ");
            buf.append("  where fil_codigo = ").append(notaBean.getFilial().getCodigo());
            buf.append("    and nfi_codigo = ").append(notaBean.getCodigo());
            buf.append("    and rpg_situacao = '").append("P").append("' ");
            try {
                qtde = Conexao.executeUpdate(notaBean.getFilial().getCodigo().toString(), st, buf.toString(), false);
                if (qtde == 0) {
                    throw new Exception("Os t\u00edtulos associados \u00e0 nota n\u00e3o foram localizados. Filial = " + notaBean.getFilial().getCodigo() + ", c\u00f3digo nota = " + notaBean.getCodigo());
                }
            }
            catch (Exception sqle) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return sqle.getMessage();
            }
            buf.setLength(0);
            buf.append(" select bxa.bxa_codigo as codigo ");
            buf.append("   from baixa bxa ");
            buf.append("   join baixareceberpagar brp on bxa.fil_codigo = brp.fil_codigo and bxa.bxa_codigo = brp.bxa_codigo ");
            buf.append("   join receberpagar rpg on brp.fil_codigo = rpg.fil_codigo and brp.rpg_codigo = rpg.rpg_codigo ");
            buf.append("   join notafiscal nfi on rpg.fil_codigo = nfi.fil_codigo and rpg.nfi_codigo = nfi.nfi_codigo ");
            buf.append("  where nfi.fil_codigo = ").append(notaBean.getFilial().getCodigo());
            buf.append("    and nfi.nfi_codigo = ").append(notaBean.getCodigo());
            buf.append("    and rpg.rpg_situacao = '").append("Q").append("' ");
            buf.append("    and bxa.bxa_situacao = '").append("P").append("' ");
            ResultSet rs = null;
            int codigoBaixa = -1;
            try {
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs != null && rs.next()) {
                    codigoBaixa = rs.getInt("codigo");
                }
            }
            catch (SQLException e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return "N\u00e3o foi poss\u00edvel buscar os dados da baixa associada aos t\u00edtulos da nota fiscal. Filial = " + notaBean.getFilial().getCodigo() + ", c\u00f3digo nota = " + notaBean.getCodigo() + CARACTERE_SEPARACAO_CAMPOS + e.getMessage();
            }
            if (codigoBaixa > -1) {
                buf.setLength(0);
                buf.append(" update baixa ");
                buf.append("    set bxa_situacao = '").append("Q").append("' ");
                buf.append("  where fil_codigo = ").append(notaBean.getFilial().getCodigo());
                buf.append("    and bxa_codigo = ").append(codigoBaixa);
                try {
                    int qtde2 = Conexao.executeUpdate(notaBean.getFilial().getCodigo().toString(), st, buf.toString(), false);
                    if (qtde2 == 0) {
                        throw new Exception("A baixa associada aos t\u00edtulos da nota n\u00e3o foi localizada. Filial = " + notaBean.getFilial().getCodigo() + ", c\u00f3digo baixa = " + codigoBaixa);
                    }
                }
                catch (Exception sqle) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    return sqle.getMessage();
                }
            }
        } else {
            buf.setLength(0);
            buf.append(" update receberpagar ");
            buf.append("    set rpg_situacao = '").append("A").append("' ");
            buf.append("  where fil_codigo = ").append(notaBean.getFilial().getCodigo());
            buf.append("    and nfi_codigo = ").append(notaBean.getCodigo());
            buf.append("    and rpg_situacao = '").append("P").append("' ");
            try {
                qtde = Conexao.executeUpdate(notaBean.getFilial().getCodigo().toString(), st, buf.toString(), false);
                if (qtde == 0) {
                    throw new Exception("Os t\u00edtulos associados \u00e0 nota n\u00e3o foram localizados. Filial = " + notaBean.getFilial().getCodigo() + ", c\u00f3digo nota = " + notaBean.getCodigo());
                }
            }
            catch (Exception sqle) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return sqle.getMessage();
            }
        }
        try {
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            String string;
            try {
                string = "N\u00e3o foi poss\u00edvel commitar as altera\u00e7\u00f5es.\n" + e.getMessage();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return string;
        }
        Conexao.fecharStatement(st);
        return null;
    }

    public String rejeitaNotaFiscal(NotaFiscalBean bean, RetornoTecnospeed objetoRetorno) {
        if (bean == null || objetoRetorno == null) {
            return null;
        }
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append(" update notafiscal ");
        buf.append("    set nfi_statusnfse = null ");
        buf.append("       ,nfi_motivonfse = '").append(StringUtil.trocaCaracterUTF(objetoRetorno.getStatusRetorno())).append("' ");
        buf.append("       ,nfi_datastatusnfse = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date())).append("' ");
        buf.append("       ,nfi_protocolonfse = '").append(objetoRetorno.getHandle()).append("' ");
        buf.append("       ,nfi_situacao = '").append("R").append("' ");
        buf.append("  where fil_codigo = ").append(this.notaBean.getFilial().getCodigo());
        buf.append("    and nfi_codigo = ").append(this.notaBean.getCodigo());
        try {
            int qtde = Conexao.executeUpdate(this.notaBean.getFilial().getCodigo().toString(), st, buf.toString(), false);
            if (qtde == 0) {
                throw new Exception("A nota fiscal n\u00e3o foi localizada. Filial = " + this.notaBean.getFilial().getCodigo() + ", c\u00f3digo nota = " + this.notaBean.getCodigo());
            }
            this.notaBean.setMotivoNfse(objetoRetorno.getStatusRetorno());
            this.notaBean.setDataStatusNfse(new Date());
            this.notaBean.setProtocoloNfse(objetoRetorno.getHandle().toString());
            if (objetoRetorno.getLote() != null) {
                this.notaBean.setChaveRpsNfse(objetoRetorno.getLote().toString());
            }
            this.notaBean.setSituacao("R");
        }
        catch (Exception sqle) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return sqle.getMessage();
        }
        return null;
    }

    private RetornoTecnospeed getObjetoRetornoTecnospeed(String mensagemRetorno) {
        if (Funcoes.textoVazio(mensagemRetorno)) {
            return null;
        }
        mensagemRetorno = mensagemRetorno.replaceAll(",,", ", ,");
        RetornoTecnospeed retorno = new RetornoTecnospeed();
        StringTokenizer tokenizer = new StringTokenizer(mensagemRetorno, ",", false);
        boolean isErro = false;
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equalsIgnoreCase(",")) {
                token = tokenizer.nextToken();
            }
            if (token.toLowerCase().indexOf("exception") > -1) {
                isErro = true;
            } else {
                if (isErro && i == 2) {
                    retorno.setStatusRetorno(token.length() > 500 ? token.substring(0, 500) : token);
                    retorno.setRejeicao(true);
                    retorno.setNumeroNFSe(null);
                }
                if (isErro) break;
                if (i == 5 && token.indexOf("|") > 0) {
                    token = StringUtil.limpaString(token.trim(), new String[]{"|", CARACTERE_SEPARACAO_CAMPOS, "\t"});
                }
                if (i == 2) {
                    retorno.setRejeicao(Funcoes.textoVazio(token) ? false : Long.parseLong(token) < 1L);
                    if (!Funcoes.textoVazio(token) && token.matches("[0-9]+") && Funcoes.isNumeric(token) && Long.parseLong(token) < 1L) {
                        token = null;
                    }
                }
                if (i == 4) {
                    String[] aux = token.split(":");
                    StringBuilder buf = new StringBuilder();
                    for (int j = 0; j < aux.length; ++j) {
                        if (j % 2 != 1 || aux[j].trim().equalsIgnoreCase("E")) continue;
                        buf.append(aux[j].trim()).append(CARACTERE_SEPARACAO_CAMPOS);
                        token = buf.toString();
                    }
                }
                switch (i) {
                    case 0: {
                        retorno.setHandle(Funcoes.textoVazio(token) ? null : Long.valueOf(Long.parseLong(token)));
                        break;
                    }
                    case 1: {
                        retorno.setLote(Funcoes.textoVazio(token) ? null : Long.valueOf(Long.parseLong(token)));
                        break;
                    }
                    case 2: {
                        retorno.setNumeroNFSe(Funcoes.textoVazio(token) ? null : Long.valueOf(Long.parseLong(token)));
                        break;
                    }
                    case 3: {
                        retorno.setNumeroRps(Funcoes.textoVazio(token) ? null : Long.valueOf(Long.parseLong(token)));
                        break;
                    }
                    case 4: {
                        retorno.setStatusRetorno(token.length() > 500 ? token.substring(0, 500) : token);
                        break;
                    }
                    case 5: {
                        retorno.setIdIntegracao(Funcoes.textoVazio(token) ? null : Long.valueOf(Funcoes.isNumeric(token.trim()) ? Long.parseLong(token.trim()) : 0L));
                    }
                }
            }
            ++i;
        }
        return retorno;
    }

    private void preencheBean(NotaFiscalBean notaBean) throws Exception {
        this.notaBean = notaBean;
        this.notaServico = notaBean.getServico();
        try {
            this.filialBean = (FilialBean)new FilialService().get(String.valueOf(notaBean.getFilial().getCodigo()));
        }
        catch (Exception e) {
            throw new Exception("N\u00e3o foi poss\u00edvel buscar dados da filial. C\u00f3digo: " + String.valueOf(notaBean.getFilial().getCodigo()) + ".\n" + e.getMessage());
        }
        this.tipoCadastro = notaBean.getTipoCadastro();
        this.paciente = null;
        this.convenio = null;
        if (this.tipoCadastro.equals("P") || this.tipoCadastro.equals("E")) {
            try {
                this.paciente = (PacienteBean)new PacienteService().get(notaBean.getPaciente().getFilial().getCodigo().toString(), notaBean.getPaciente().getCodigo().toString());
            }
            catch (Exception e) {
                throw new Exception("N\u00e3o foi poss\u00edvel buscar dados do paciente.\n" + e.getMessage());
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fil_codigo", notaBean.getFilial().getCodigo());
        map.put("con_codigo", notaBean.getConvenio().getCodigo());
        try {
            this.convenio = (ConvenioBean)new ConvenioService().getBean(map);
        }
        catch (ThreadDaoException e) {
            throw new Exception("N\u00e3o foi poss\u00edvel buscar dados do conv\u00eanio.\n" + e.getMessage());
        }
        if (notaBean.getServico() != null && notaBean.getServico().getServico() != null) {
            ServicoVO aux = notaBean.getServico().getServico();
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put("fil_codigo", aux.getFilial().getCodigo());
            map2.put("svc_codigo", aux.getCodigo());
            try {
                this.servico = (ServicoBean)new ServicoService().getBean(map2);
            }
            catch (ThreadDaoException e) {
                throw new Exception("N\u00e3o foi poss\u00edvel buscar dados do servi\u00e7o.\n" + e.getMessage());
            }
        }
        if (this.filialBean.getPadraoLayoutNFSe() == null) {
            throw new Exception("Padr\u00e3o de layout de nota fiscal eletr\u00f4nica n\u00e3o definido.");
        }
        this.padraoNFSe = TecnospeedUtil.Padrao.get(this.filialBean.getPadraoLayoutNFSe());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean descartaRPS(NotaFiscalBean notaBean) throws Exception {
        if (notaBean == null) {
            return false;
        }
        this.notaBean = notaBean;
        try {
            this.filialBean = (FilialBean)new FilialService().get(String.valueOf(notaBean.getFilial().getCodigo()));
        }
        catch (Exception e) {
            throw new Exception("N\u00e3o foi poss\u00edvel buscar dados da filial. C\u00f3digo: " + String.valueOf(notaBean.getFilial().getCodigo()) + ".\n" + e.getMessage());
        }
        if (this.filialBean.getPadraoLayoutNFSe() == null) {
            throw new Exception("Padr\u00e3o de layout de nota fiscal eletr\u00f4nica n\u00e3o definido.");
        }
        this.padraoNFSe = TecnospeedUtil.Padrao.get(this.filialBean.getPadraoLayoutNFSe());
        Map<String, String> parametros = this.getParametrosDescartaRPS();
        if (notaBean.getNumeroRps() <= 0L) return false;
        try {
            String retorno = ComunicacaoTecnospeed.comunicaPost("descarta", parametros, this.filialBean.getCnpj(), String.valueOf(this.filialBean.getCodigo()), false);
            if (!debug) return true;
            System.out.println(retorno);
            return true;
        }
        catch (Exception e) {
            System.out.println("N\u00e3o foi poss\u00edvel cancelar NFSE: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean cancelaNotaFiscalEletronica(NotaFiscalBean notaBean) throws Exception {
        if (notaBean == null) {
            return false;
        }
        this.notaBean = notaBean;
        try {
            this.filialBean = (FilialBean)new FilialService().get(String.valueOf(notaBean.getFilial().getCodigo()));
        }
        catch (Exception e) {
            throw new Exception("N\u00e3o foi poss\u00edvel buscar dados da filial. C\u00f3digo: " + String.valueOf(notaBean.getFilial().getCodigo()) + ".\n" + e.getMessage());
        }
        if (this.filialBean.getPadraoLayoutNFSe() == null) {
            throw new Exception("Padr\u00e3o de layout de nota fiscal eletr\u00f4nica n\u00e3o definido.");
        }
        this.padraoNFSe = TecnospeedUtil.Padrao.get(this.filialBean.getPadraoLayoutNFSe());
        Map<String, String> parametros = this.getParametrosCancelamentoNota();
        String retorno = null;
        try {
            retorno = ComunicacaoTecnospeed.comunicaPost("cancela", parametros, this.filialBean.getCnpj(), String.valueOf(this.filialBean.getCodigo()), false);
            if (debug) {
                System.out.println(retorno);
            }
        }
        catch (Exception e) {
            System.out.println("N\u00e3o foi poss\u00edvel cancelar NFSE: " + e.getMessage());
            e.printStackTrace();
            if (e.getMessage() != null && e.getMessage().contains("Erro ao realizar post")) {
                return false;
            }
            return this.processaRetornoTecnospeed(notaBean, this.getObjetoRetornoTecnospeed(retorno));
        }
        return true;
    }

    private Map<String, String> getParametrosCancelamentoNota() {
        HashMap<String, String> parametros = new HashMap<String, String>();
        String nomeCidade = this.filialBean.getCidade().getNome().replace(" ", "");
        parametros.put("NomeCidade", nomeCidade);
        parametros.put("NumNFSe", this.notaBean.getNumero().toString());
        return parametros;
    }

    private Map<String, String> getParametrosDescartaRPS() {
        HashMap<String, String> parametros = new HashMap<String, String>();
        String nomeCidade = this.filialBean.getCidade().getNome().replace(" ", "");
        parametros.put("NomeCidade", nomeCidade);
        parametros.put("SerieRPS", this.notaBean.getSerie().getCodigo().toString());
        parametros.put("NumRPS", this.notaBean.getNumeroRps().toString());
        parametros.put("TipoRPS", "1");
        return parametros;
    }

    private Map<String, String> getParametrosResolveNota() {
        HashMap<String, String> parametros = new HashMap<String, String>();
        String nomeCidade = this.filialBean.getCidade().getNome().replace(" ", "");
        parametros.put("NomeCidade", nomeCidade);
        parametros.put("SerieRPS", this.notaBean.getSerie().getCodigo());
        parametros.put("NumRPS", this.notaBean.getNumeroRps().toString());
        parametros.put("TipoRPS", "1");
        return parametros;
    }

    private String getParametrosConsultaNota() {
        StringBuilder consulta = new StringBuilder();
        consulta.append("Campos=nnfse,situacao,handle,nlote,nrps,idintegracao");
        if (this.notaBean.getNumeroRps() < -1L) {
            Long rps = this.notaBean.getNumeroRps() * -1L;
            consulta.append("&Filtro=").append("serie='" + this.notaBean.getSerie().getCodigo() + "'+and+idintegracao=" + rps);
        } else {
            consulta.append("&Filtro=").append("serie='" + this.notaBean.getSerie().getCodigo() + "'+and+nrps=" + this.notaBean.getNumeroRps().toString());
        }
        consulta.append("&Limite=").append("1");
        consulta.append("&Inicio=&Ordem=handle&Visao=");
        return consulta.toString();
    }

    class GrupoNotaFiscalServicos
    extends Grupo {
        Campo numeroNfse = new Campo("NumeroNfse", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.NOTA_CONTROL, TecnospeedUtil.Padrao.IPM}, "n\u00famero da NFSe");
        Campo serieNfse = new Campo("SerieNfse", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.NOTA_CONTROL}, "s\u00e9rie da NFSe");
        Campo dataEmissaoNfse = new Campo("DataEmissaoNfse", TecnospeedUtil.TipoDado.DATA, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.NOTA_CONTROL, TecnospeedUtil.Padrao.SIGISS}, "data de emiss\u00e3o da NFSe");

        public GrupoNotaFiscalServicos() {
            this.nomeGrupo = "NotaFiscalServicos";
            this.campos = new Campo[]{this.numeroNfse, this.serieNfse, this.dataEmissaoNfse};
        }
    }

    class GrupoEquipamentoEmissorRPS
    extends Grupo {
        Campo numEmissorRps = new Campo("NumEmissorRps", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.EQUIPLANO}, "n\u00famero do equipamento emissor de RPS");

        public GrupoEquipamentoEmissorRPS() {
            this.nomeGrupo = "EquipamentoEmissorRPS";
            this.campos = new Campo[]{this.numEmissorRps};
        }
    }

    class GrupoAssinatura
    extends Grupo {
        Campo assinatura = new Campo("Assinatura", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM}, "assinatura");

        public GrupoAssinatura() {
            this.nomeGrupo = "Assinatura";
            this.campos = new Campo[]{this.assinatura};
        }
    }

    class GrupoIdentificadorSistemaLegado
    extends Grupo {
        Campo identificadorSistemaLegado = new Campo("IdentificadorSistemaLegado", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.SIGISS}, "identificador do sistema legado");

        public GrupoIdentificadorSistemaLegado() {
            this.nomeGrupo = "IdentificadorSistemaLegado";
            this.campos = new Campo[]{this.identificadorSistemaLegado};
        }
    }

    class GrupoDeducaoServico
    extends Grupo {
        Campo deducaoPor = new Campo("DeducaoPor", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF}, "dedu\u00e7\u00e3o por");
        Campo tipoDeducao = new Campo("TipoDeducao", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF}, "tipo de dedu\u00e7\u00e3o");
        Campo percentualDeduzir = new Campo("PercentualDeduzir", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF}, "percentual a deduzir");
        Campo cpfCNPJReferencia = new Campo("CPFCNPJReferencia", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF}, "CPF/CNPJ de refer\u00eancia");
        Campo numeroNfReferencia = new Campo("NumeroNfReferencia", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF}, "n\u00famero da NF de refer\u00eancia");
        Campo valorTotalReferencia = new Campo("ValorTotalReferencia", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF}, "valor total de refer\u00eancia");
        Campo justificativaDeducao = new Campo("JustificativaDeducao", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.EQUIPLANO}, "justificativa de dedu\u00e7\u00e3o");

        public GrupoDeducaoServico() {
            this.nomeGrupo = "DeducaoServico";
            this.campos = new Campo[]{this.deducaoPor, this.tipoDeducao, this.percentualDeduzir, this.cpfCNPJReferencia, this.numeroNfReferencia, this.valorTotalReferencia, this.justificativaDeducao};
        }
    }

    class GrupoConstrucaoCivil
    extends Grupo {
        Campo codigoObra = new Campo("CodigoObra", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "c\u00f3digo da obra");
        Campo art = new Campo("Art", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "ART");

        public GrupoConstrucaoCivil() {
            this.nomeGrupo = "ConstrucaoCivil";
            this.campos = new Campo[]{this.codigoObra, this.art};
        }
    }

    class GrupoNFSeSubstituida
    extends Grupo {
        Campo numeroNfseSubstituida = new Campo("NumeroNfseSubstituida", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF}, "n\u00famero da NFSe substitu\u00edda");
        Campo dataEmissaoNfseSubstituida = new Campo("DataEmissaoNfseSubstituida", TecnospeedUtil.TipoDado.DATA, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF}, "data de emiss\u00e3o da NFSe substitu\u00edda");

        public GrupoNFSeSubstituida() {
            this.nomeGrupo = "NFSeSubstituida";
            this.campos = new Campo[]{this.numeroNfseSubstituida, this.dataEmissaoNfseSubstituida};
        }
    }

    class GrupoIntermediarioServico
    extends Grupo {
        Campo cpfCnpjIntermediario = new Campo("CpfCnpjIntermediario", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "CPF/CNPJ do intermedi\u00e1rio");
        Campo inscricaoMunicipalIntermediario = new Campo("InscricaoMunicipalIntermediario", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "inscri\u00e7\u00e3o municipal do intermedi\u00e1rio");
        Campo razaoSocialIntermediario = new Campo("RazaoSocialIntermediario", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "raz\u00e3o social do intermedi\u00e1rio");

        public GrupoIntermediarioServico() {
            this.nomeGrupo = "IntermediarioServico";
            this.campos = new Campo[]{this.cpfCnpjIntermediario, this.inscricaoMunicipalIntermediario, this.razaoSocialIntermediario};
        }
    }

    class GrupoTomadorServico
    extends Grupo {
        Campo cpfCnpjTomador = new Campo("CpfCnpjTomador", TecnospeedUtil.TipoDado.INDEFINIDO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.E_GOVERNE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "CPF/CNPJ do tomador");
        Campo razaoSocialTomador = new Campo("RazaoSocialTomador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.E_GOVERNE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "raz\u00e3o social do tomador");
        Campo inscricaoMunicipalTomador = new Campo("InscricaoMunicipalTomador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.E_GOVERNE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "inscri\u00e7\u00e3o municipal do tomador", false);
        Campo inscricaoEstadualTomador = new Campo("InscricaoEstadualTomador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE}, "inscri\u00e7\u00e3o estadual do tomador", false);
        Campo docTomadorEstrangeiro = new Campo("DocTomadorEstrangeiro", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF}, "documento do tomador estrangeiro", false);
        Campo tipoLogradouroTomador = new Campo("TipoLogradouroTomador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.E_GOVERNE, TecnospeedUtil.Padrao.ISSWEB}, "tipo de logradouro do tomador", false);
        Campo enderecoTomador = new Campo("EnderecoTomador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.E_GOVERNE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "endere\u00e7o do tomador");
        Campo numeroTomador = new Campo("NumeroTomador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.E_GOVERNE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "n\u00famero do tomador");
        Campo complementoTomador = new Campo("ComplementoTomador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.E_GOVERNE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "complemento do tomador", false);
        Campo tipoBairroTomador = new Campo("TipoBairroTomador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF}, "tipo de bairro do tomador", false);
        Campo bairroTomador = new Campo("BairroTomador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.E_GOVERNE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "bairro do tomasdor", false);
        Campo codigoCidadeTomador = new Campo("CodigoCidadeTomador", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.E_GOVERNE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "c\u00f3digo da cidade do tomador");
        Campo descricaoCidadeTomador = new Campo("DescricaoCidadeTomador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.FGMAISS_OFFLINE}, "nome da cidade do tomador");
        Campo ufTomador = new Campo("UfTomador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.E_GOVERNE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "UF do tomador");
        Campo cepTomador = new Campo("CepTomador", TecnospeedUtil.TipoDado.CEP, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.E_GOVERNE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "CEP do tomador", true);
        Campo dddTomador = new Campo("DDDTomador", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.E_GOVERNE, TecnospeedUtil.Padrao.ISSWEB}, "DDD do tomador", false);
        Campo telefoneTomador = new Campo("TelefoneTomador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.E_GOVERNE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "telefone do tomador", false);
        Campo tipoTelefoneTomador = new Campo("TipoTelefoneTomador", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ISSWEB}, "tipo de telefone do tomador", false);
        Campo emailTomador = new Campo("EmailTomador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.E_GOVERNE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "e-mail do tomador", false);
        Campo tipoDocumentoTomador = new Campo("TipoDocumentoTomador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.EQUIPLANO}, "tipo do documento do tomador", (Object[])TecnospeedUtil.TipoDocumentoTomador.values());
        Campo descricaoDocumentoTomador = new Campo("DescricaoDocumentoTomador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIGISS}, "descri\u00e7\u00e3o do documento do tomador", false);
        Campo cidadeEstrangeiraTomador = new Campo("CidadeEstrangeiraTomador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.EQUIPLANO}, "cidade estrangeira do tomador", false);
        Campo paisTomador = new Campo("PaisTomador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.E_GOVERNE, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE}, "pa\u00eds do tomador", false);

        public GrupoTomadorServico() {
            this.nomeGrupo = "TomadorServico";
            this.campos = new Campo[]{this.cpfCnpjTomador, this.razaoSocialTomador, this.inscricaoMunicipalTomador, this.inscricaoEstadualTomador, this.docTomadorEstrangeiro, this.tipoLogradouroTomador, this.enderecoTomador, this.numeroTomador, this.complementoTomador, this.tipoBairroTomador, this.bairroTomador, this.codigoCidadeTomador, this.descricaoCidadeTomador, this.ufTomador, this.cepTomador, this.dddTomador, this.telefoneTomador, this.tipoTelefoneTomador, this.emailTomador, this.tipoDocumentoTomador, this.descricaoDocumentoTomador, this.cidadeEstrangeiraTomador, this.paisTomador};
        }
    }

    class GrupoPrestadorServico
    extends Grupo {
        Campo cpfCnpjPrestador = new Campo("CpfCnpjPrestador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "CPF/CNPJ do prestador");
        Campo inscricaoMunicipalPrestador = new Campo("InscricaoMunicipalPrestador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "inscri\u00e7\u00e3o municipal do prestador");
        Campo razaoSocialPrestador = new Campo("RazaoSocialPrestador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2_2}, "raz\u00e3o social do prestador");
        Campo dddPrestador = new Campo("DDDPrestador", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF}, "DDD do prestador", false);
        Campo telefonePrestador = new Campo("TelefonePrestador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF}, "telefone do prestador", false);
        Campo seriePrestacao = new Campo("SeriePrestacao", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF}, "s\u00e9rie de presta\u00e7\u00e3o");
        Campo enderecoPrestador = new Campo("EnderecoPrestador", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF_2_2}, "Endere\u00e7o do prestador", true);

        public GrupoPrestadorServico() {
            this.nomeGrupo = "PrestadorServico";
            this.campos = new Campo[]{this.cpfCnpjPrestador, this.inscricaoMunicipalPrestador, this.razaoSocialPrestador, this.dddPrestador, this.telefonePrestador, this.seriePrestacao, this.enderecoPrestador};
        }
    }

    private class RetornoXMLTecnospeed {
        private boolean isRejeicao = false;
        private byte[] zipXML = null;
        private String url = null;
        private String statusRetorno = null;

        public String getStatusRetorno() {
            return this.statusRetorno;
        }

        public void setStatusRetorno(String statusRetorno) {
            this.statusRetorno = statusRetorno;
        }

        public boolean isRejeicao() {
            return this.isRejeicao;
        }

        public void setRejeicao(boolean isRejeicao) {
            this.isRejeicao = isRejeicao;
        }

        public void setZipXML(byte[] zipXML) {
            this.zipXML = zipXML;
        }

        public void setURL(String url) {
            this.url = url;
        }

        public byte[] getZipXML() {
            return this.zipXML;
        }

        public String getURL() {
            return this.url;
        }
    }

    private class RetornoPDFTecnospeed {
        private boolean isRejeicao = false;
        private byte[] pdf = null;
        private String url = null;
        private String statusRetorno = null;

        public String getStatusRetorno() {
            return this.statusRetorno;
        }

        public void setStatusRetorno(String statusRetorno) {
            this.statusRetorno = statusRetorno;
        }

        public boolean isRejeicao() {
            return this.isRejeicao;
        }

        public void setRejeicao(boolean isRejeicao) {
            this.isRejeicao = isRejeicao;
        }

        public void setPDF(byte[] pdf) {
            this.pdf = pdf;
        }

        public void setURL(String url) {
            this.url = url;
        }

        public byte[] getPDF() {
            return this.pdf;
        }

        public String getURL() {
            return this.url;
        }
    }

    private class RetornoTecnospeed {
        private boolean isRejeicao = false;
        private Long handle = null;
        private Long lote = null;
        private Long numeroNFSe = null;
        private String statusRetorno = null;
        private String statusRetornoOriginal = "";
        private String protocolo = null;
        private Long numeroRps = null;
        private Long idIntegracao = null;

        public void setStatusRetornoOriginal(String statusRetornoOriginal) {
            this.statusRetornoOriginal = statusRetornoOriginal;
        }

        public String getStatusRetornoOriginal() {
            return this.statusRetornoOriginal;
        }

        public boolean isRejeicao() {
            return this.isRejeicao;
        }

        public void setRejeicao(boolean isRejeicao) {
            this.isRejeicao = isRejeicao;
        }

        public void setHandle(Long handle) {
            this.handle = handle;
        }

        public void setLote(Long lote) {
            this.lote = lote;
        }

        public void setNumeroNFSe(Long numeroNFSe) {
            this.numeroNFSe = numeroNFSe;
        }

        public void setStatusRetorno(String statusRetorno) {
            this.statusRetorno = statusRetorno;
        }

        public void setProtocolo(String protocolo) {
            this.protocolo = protocolo;
        }

        public String getProtocolo() {
            return this.protocolo;
        }

        public Long getHandle() {
            return this.handle;
        }

        public Long getLote() {
            return this.lote;
        }

        public Long getNumeroNFSe() {
            return this.numeroNFSe;
        }

        public String getStatusRetorno() {
            return this.statusRetorno.replace("'", " ");
        }

        public Long getNumeroRps() {
            return this.numeroRps;
        }

        public void setNumeroRps(Long numeroRps) {
            this.numeroRps = numeroRps;
        }

        public Long getIdIntegracao() {
            return this.idIntegracao;
        }

        public void setIdIntegracao(Long idIntegracao) {
            this.idIntegracao = idIntegracao;
        }

        public RetornoTecnospeed() {
        }

        public RetornoTecnospeed(Long handle, Long lote, Long numeroNFSe, String statusRetorno) {
            this.handle = handle;
            this.lote = lote;
            this.numeroNFSe = numeroNFSe;
            this.statusRetorno = statusRetorno;
        }
    }

    class GrupoValoresServicoPrestado
    extends Grupo {
        Campo valorServicos = new Campo("ValorServicos", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.E_GOVERNE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "valor dos servi\u00e7os");
        Campo valorDeducoes = new Campo("ValorDeducoes", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.E_GOVERNE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "valor das dedu\u00e7\u00f5es");
        Campo valorPis = new Campo("ValorPis", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.NOTA_CONTROL, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "valor do PIS");
        Campo valorCofins = new Campo("ValorCofins", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.NOTA_CONTROL, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "valor do COFINS");
        Campo valorInss = new Campo("ValorInss", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.NOTA_CONTROL, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "valor do INSS");
        Campo valorIr = new Campo("ValorIr", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.NOTA_CONTROL, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "valor do IR");
        Campo valorCsll = new Campo("ValorCsll", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.NOTA_CONTROL, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "valor do CSLL");
        Campo valorIss = new Campo("ValorIss", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "valor do ISS");
        Campo valorIssRetido = new Campo("ValorIssRetido", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "valor do ISS retido");
        Campo outrasRetencoes = new Campo("OutrasRetencoes", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "outras reten\u00e7\u00f5es");
        Campo baseCalculo = new Campo("BaseCalculo", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "base de c\u00e1lculo");
        Campo valorLiquidoNfse = new Campo("ValorLiquidoNfse", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "valor l\u00edquido da NFSe");
        Campo valorUnitarioServico = new Campo("ValorUnitarioServico", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.NOTA_CONTROL, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FGMAISS_OFFLINE}, "valor unit\u00e1rio do servi\u00e7o");
        Campo valorIssServico = new Campo("ValorIssServico", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.EQUIPLANO}, "valor do ISS do servi\u00e7o");
        Campo descontoIncondicionado = new Campo("DescontoIncondicionado", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "desconto incondicionado");
        Campo descontoCondicionado = new Campo("DescontoCondicionado", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "desconto condicional");
        Campo aliquotaISS = new Campo("AliquotaISS", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.NOTA_CONTROL, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.E_GOVERNE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "al\u00edquota do ISS");
        Campo aliquotaPIS = new Campo("AliquotaPIS", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.FGMAISS_OFFLINE}, "al\u00edquota do PIS");
        Campo aliquotaCOFINS = new Campo("AliquotaCOFINS", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.FGMAISS_OFFLINE}, "al\u00edquota COFINS");
        Campo aliquotaINSS = new Campo("AliquotaINSS", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.FGMAISS_OFFLINE}, "al\u00edquota INSS");
        Campo aliquotaIR = new Campo("AliquotaIR", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.FGMAISS_OFFLINE}, "al\u00edquota IR");
        Campo aliquotaCSLL = new Campo("AliquotaCSLL", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.FGMAISS_OFFLINE}, "al\u00edquota CSLL");

        public GrupoValoresServicoPrestado() {
            this.nomeGrupo = "ValoresServicoPrestado";
            this.campos = new Campo[]{this.valorServicos, this.valorDeducoes, this.valorPis, this.valorCofins, this.valorInss, this.valorIr, this.valorCsll, this.valorIss, this.valorIssRetido, this.outrasRetencoes, this.baseCalculo, this.valorLiquidoNfse, this.valorUnitarioServico, this.valorIssServico, this.descontoIncondicionado, this.descontoCondicionado, this.aliquotaISS, this.aliquotaPIS, this.aliquotaCOFINS, this.aliquotaINSS, this.aliquotaIR, this.aliquotaCSLL};
        }
    }

    class GrupoServicoPrestado
    extends Grupo {
        Campo quantidadeServicos = new Campo("QuantidadeServicos", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.NOTA_CONTROL, TecnospeedUtil.Padrao.IPM}, "quantidade do servi\u00e7o");
        Campo issRetido = new Campo("IssRetido", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.NOTA_CONTROL, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "reten\u00e7\u00e3o de iss");
        Campo codigoItemListaServico = new Campo("CodigoItemListaServico", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.E_GOVERNE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "c\u00f3digo do item da lista de servi\u00e7o");
        Campo codigoSubItemListaServico = new Campo("CodigoSubItemListaServico", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.EQUIPLANO}, "c\u00f3digo do sub-item da lista de servi\u00e7o");
        Campo codigoCnae = new Campo("CodigoCnae", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "classifica\u00e7\u00e3o nacional de atividade (CNAE)");
        Campo codigoTributacaoMunicipio = new Campo("CodigoTributacaoMunicipio", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.NOTA_CONTROL, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "c\u00f3digo de tributa\u00e7\u00e3o do munic\u00edpio");
        Campo discriminacaoServico = new Campo("DiscriminacaoServico", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.NOTA_CONTROL, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.E_GOVERNE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "discrimina\u00e7\u00e3o do servi\u00e7o");
        Campo descricaoRPS;
        Campo codigoCidadePrestacao;
        Campo descricaoCidadePrestacao;
        Campo exigibilidadeISS;
        Campo municipioIncidencia;
        Campo competencia;
        Campo responsavelRetencao;
        Campo tributavel;
        Campo codigoPais;
        Campo operacao;

        public GrupoServicoPrestado() {
            TecnospeedUtil.Padrao[] padraoArray = new TecnospeedUtil.Padrao[4];
            padraoArray[0] = TecnospeedUtil.Padrao.TECNOSPEED;
            padraoArray[1] = TecnospeedUtil.Padrao.DSF;
            padraoArray[2] = TecnospeedUtil.Padrao.ISSONLINE;
            IntegracaoTecnospeed.this.padraoNFSe;
            padraoArray[3] = TecnospeedUtil.Padrao.ABRASF_2_2;
            this.descricaoRPS = new Campo("DescricaoRPS", TecnospeedUtil.TipoDado.TEXTO, padraoArray, "descri\u00e7\u00e3o do RPS");
            this.codigoCidadePrestacao = new Campo("CodigoCidadePrestacao", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "c\u00f3digo da cidade de presta\u00e7\u00e3o");
            this.descricaoCidadePrestacao = new Campo("DescricaoCidadePrestacao", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.LONDRINA}, "nome da cidade de presta\u00e7\u00e3o");
            this.exigibilidadeISS = new Campo("ExigibilidadeISS", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSWEB}, "exigibilidade do ISS", TecnospeedUtil.ExigibilidadeISS.values());
            this.municipioIncidencia = new Campo("MunicipioIncidencia", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE}, "munic\u00edpio de incid\u00eancia");
            this.competencia = new Campo("Competencia", TecnospeedUtil.TipoDado.DATA, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "data de compet\u00eancia", false);
            this.responsavelRetencao = new Campo("ResponsavelRetencao", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE}, "respons\u00e1vel pela reten\u00e7\u00e3o do ISS");
            this.tributavel = new Campo("Tributavel", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.NOTA_CONTROL}, "tribut\u00e1vel");
            this.codigoPais = new Campo("CodigoPais", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE}, "c\u00f3digo do pa\u00eds", false);
            this.operacao = new Campo("Operacao", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF}, "natureza da opera\u00e7\u00e3o", TecnospeedUtil.NaturezaOperacao.values());
            this.nomeGrupo = "ServicoPrestado";
            this.campos = new Campo[]{this.quantidadeServicos, this.issRetido, this.codigoItemListaServico, this.codigoSubItemListaServico, this.codigoCnae, this.codigoTributacaoMunicipio, this.discriminacaoServico, this.descricaoRPS, this.codigoCidadePrestacao, this.descricaoCidadePrestacao, this.exigibilidadeISS, this.municipioIncidencia, this.competencia, this.responsavelRetencao, this.tributavel, this.codigoPais, this.operacao};
        }
    }

    class GrupoSubstituicaoRPS
    extends Grupo {
        Campo numeroRpsSubstituido = new Campo("NumeroRpsSubstituido", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "n\u00famero do RPS substitu\u00eddo");
        Campo serieRpsSubstituido = new Campo("SerieRpsSubstituido", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "s\u00e9rie do RPS substitu\u00eddo");
        Campo tipoRpsSubstituido = new Campo("TipoRpsSubstituido", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "tipo do RPS substitu\u00eddo");

        public GrupoSubstituicaoRPS() {
            this.nomeGrupo = "SubstituicaoRPS";
            this.campos = new Campo[]{this.numeroRpsSubstituido, this.serieRpsSubstituido, this.tipoRpsSubstituido};
        }
    }

    class GrupoSituacaoNota
    extends Grupo {
        Campo situacaoNota = new Campo("SituacaoNota", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "situa\u00e7\u00e3o da NFSe", (Object[])TecnospeedUtil.SituacaoNota.values());
        Campo motCancelamento = new Campo("MotCancelamento", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF}, "motivo de cancelamento");

        public GrupoSituacaoNota() {
            this.nomeGrupo = "SituacaoNota";
            this.campos = new Campo[]{this.situacaoNota, this.motCancelamento};
        }
    }

    class GrupoRegimeEspecialTributacao
    extends Grupo {
        Campo regimeEspecialTributacao = new Campo("RegimeEspecialTributacao", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "regime especial de tributa\u00e7\u00e3o", (Object[])TecnospeedUtil.RegimeEspecialTributacao.values());

        public GrupoRegimeEspecialTributacao() {
            this.nomeGrupo = "RegimeEspecialTributacao";
            this.campos = new Campo[]{this.regimeEspecialTributacao};
        }
    }

    class GrupoNaturezaTributacao
    extends Grupo {
        Campo naturezaTributacao = new Campo("NaturezaTributacao", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "natureza da tributa\u00e7\u00e3o", (Object[])TecnospeedUtil.NaturezaTributacao.values());

        public GrupoNaturezaTributacao() {
            this.nomeGrupo = "NaturezaTributacao";
            this.campos = new Campo[]{this.naturezaTributacao};
        }
    }

    class GrupoOpcaoTipoTributacao
    extends Grupo {
        Campo tipoTributacao = new Campo("TipoTributacao", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.NOTA_CONTROL, TecnospeedUtil.Padrao.IPM, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "tipo de tributa\u00e7\u00e3o", TecnospeedUtil.Tributacao.values());

        public GrupoOpcaoTipoTributacao() {
            this.nomeGrupo = "OpcaoTipoTributacao";
            this.campos = new Campo[]{this.tipoTributacao};
        }
    }

    class GrupoOpcaoIncentivadorCultural
    extends Grupo {
        Campo incentivadorCultural = new Campo("IncentivadorCultural", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "incentivador cultural", (Object[])TecnospeedUtil.OpcaoIncentivadorCultural.values());
        Campo incentivoFiscal = new Campo("IncentivoFiscal", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE}, "incentivo fiscal");

        public GrupoOpcaoIncentivadorCultural() {
            this.nomeGrupo = "OpcaoIncentivadorCultural";
            this.campos = new Campo[]{this.incentivadorCultural, this.incentivoFiscal};
        }
    }

    class GrupoOptanteSimplesNacional
    extends Grupo {
        Campo optanteSimplesNacional = new Campo("OptanteSimplesNacional", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "optante do simples nacional", (Object[])TecnospeedUtil.OptanteSimplesNacional.values());

        public GrupoOptanteSimplesNacional() {
            this.nomeGrupo = "OptanteSimplesNacional";
            this.campos = new Campo[]{this.optanteSimplesNacional};
        }
    }

    class GrupoDataEmissaoRPS
    extends Grupo {
        Campo dataEmissao = new Campo("DataEmissao", TecnospeedUtil.TipoDado.DATA_HORA, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.NOTA_CONTROL, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "data de emiss\u00e3o");

        public GrupoDataEmissaoRPS() {
            this.nomeGrupo = "DataEmissaoRPS";
            this.campos = new Campo[]{this.dataEmissao};
        }
    }

    class GrupoIdentificadoresRPS
    extends Grupo {
        Campo idRps = new Campo("IdRps", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "id do RPS", false);
        Campo numeroRps = new Campo("NumeroRps", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.NOTA_CONTROL, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "n\u00famero do RPS");
        Campo serieRps = new Campo("SerieRps", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.LONDRINA, TecnospeedUtil.Padrao.NOTA_CONTROL, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "s\u00e9rie do RPS");
        Campo tipoRps = new Campo("TipoRps", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.SIGISS, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.ISSWEB, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "tipo do RPS");
        Campo idIntegracao = new Campo("idIntegracao", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED}, "ID Integra\u00e7\u00e3o");

        public GrupoIdentificadoresRPS() {
            this.nomeGrupo = "IdentificadoresRPS";
            this.campos = new Campo[]{this.idRps, this.numeroRps, this.serieRps, this.tipoRps, this.idIntegracao};
        }
    }

    class GrupoDadosLoteRPS
    extends Grupo {
        Campo idLote = new Campo("IdLote", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "id do lote", false);
        Campo numeroLote = new Campo("NumeroLote", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "n\u00famero do lote", false);
        Campo cpfCnpjRemetente = new Campo("CpfCnpjRemetente", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "CPF/CNPJ do remetente");
        Campo inscricaoMunicipalRemetente = new Campo("InscricaoMunicipalRemetente", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.SIL_TECNOLOGIA, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.ISSONLINE, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.TECSYSTEM, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "inscri\u00e7\u00e3o municipal do remetente", false);
        Campo razaoSocialRemetente = new Campo("RazaoSocialRemetente", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.AMTEC}, "raz\u00e3o social do remetente");
        Campo codigoCidadeRemetente = new Campo("CodigoCidadeRemetente", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.AMTEC}, "c\u00f3digo da cidade do remetente");
        Campo quantidadeRps = new Campo("QuantidadeRps", TecnospeedUtil.TipoDado.INTEIRO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.ABRASF, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE, TecnospeedUtil.Padrao.ISSSIMPLES, TecnospeedUtil.Padrao.METROPOLIS, TecnospeedUtil.Padrao.DEVEL}, "quantidade do RPS");
        Campo transacao = new Campo("Transacao", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.AMTEC}, "transa\u00e7\u00e3o");
        Campo dataInicio = new Campo("DataInicio", TecnospeedUtil.TipoDado.DATA, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.AMTEC}, "data inicial");
        Campo dataFim = new Campo("DataFim", TecnospeedUtil.TipoDado.DATA, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.AMTEC}, "data final");
        Campo versao = new Campo("Versao", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.ABRASF_2_1, TecnospeedUtil.Padrao.ABRASF_2_2, TecnospeedUtil.Padrao.FIORILLI, TecnospeedUtil.Padrao.AMTEC, TecnospeedUtil.Padrao.SIM, TecnospeedUtil.Padrao.SAATRI, TecnospeedUtil.Padrao.SEMFAZONLINE}, "vers\u00e3o");
        Campo metodoEnvio = new Campo("MetodoEnvio", TecnospeedUtil.TipoDado.TEXTO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.AMTEC}, "m\u00e9todo de envio");
        Campo valorTotalServicos = new Campo("ValorTotalServicos", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.AMTEC}, "valor total dos servi\u00e7os");
        Campo valorTotalDeducoes = new Campo("ValorTotalDeducoes", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.DSF, TecnospeedUtil.Padrao.PRODAM, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.FGMAISS_OFFLINE, TecnospeedUtil.Padrao.AMTEC}, "valor total das dedu\u00e7\u00f5es");
        Campo valorTotalBaseCalculo = new Campo("ValorTotalBaseCalculo", TecnospeedUtil.TipoDado.MONETARIO, new TecnospeedUtil.Padrao[]{TecnospeedUtil.Padrao.TECNOSPEED, TecnospeedUtil.Padrao.EQUIPLANO, TecnospeedUtil.Padrao.ABRASF_2, TecnospeedUtil.Padrao.AMTEC}, "valor total da base de c\u00e1lculo");

        public GrupoDadosLoteRPS() {
            this.nomeGrupo = "DadosLoteRPS";
            this.campos = new Campo[]{this.idLote, this.numeroLote, this.cpfCnpjRemetente, this.inscricaoMunicipalRemetente, this.razaoSocialRemetente, this.codigoCidadeRemetente, this.quantidadeRps, this.transacao, this.dataInicio, this.dataFim, this.versao, this.metodoEnvio, this.valorTotalServicos, this.valorTotalDeducoes, this.valorTotalBaseCalculo};
        }
    }

    class GrupoCabecalhoPDFNota
    extends Grupo {
        Campo numNFSe = new Campo("NumNFSe", TecnospeedUtil.TipoDado.TEXTO, null, "n\u00famero da NFSe");
        Campo nomeCidade = new Campo("NomeCidade", TecnospeedUtil.TipoDado.TEXTO, null, "nome da cidade");
        Campo url = new Campo("URL", TecnospeedUtil.TipoDado.INTEIRO, null, "retornar URL");

        public GrupoCabecalhoPDFNota() {
            this.nomeGrupo = "CabecalhoPDFNota";
            this.campos = new Campo[]{this.numNFSe, this.nomeCidade, this.url};
        }
    }

    class GrupoCabecalhoEnvioRps
    extends Grupo {
        Campo nomeCidade = new Campo("NomeCidade", TecnospeedUtil.TipoDado.TEXTO, null, "nome da cidade", true);
        Campo formato = new Campo("formato", TecnospeedUtil.TipoDado.TEXTO, null, "formato de integra\u00e7\u00e3o", true);
        Campo padrao = new Campo("padrao", TecnospeedUtil.TipoDado.TEXTO, null, "padr\u00e3o da prefeitura", true);

        public GrupoCabecalhoEnvioRps() {
            this.nomeGrupo = "CabecalhoEnvioRps";
            this.campos = new Campo[]{this.formato, this.nomeCidade, this.padrao};
        }
    }
}

