/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed;

import jalis.laboratorio.financeiro.faturamento.integracao.ErrosCampos;
import jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed.Campo;
import jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed.IntegracaoTecnospeedException;
import jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed.TecnospeedUtil;
import jalis.util.Funcoes;
import java.util.ArrayList;

class Grupo {
    protected String nomeGrupo = null;
    protected Campo[] campos = null;
    protected ArrayList<ErrosCampos> listaErros = new ArrayList();

    Grupo() {
    }

    public ArrayList<ErrosCampos> getListaErros() {
        return this.listaErros;
    }

    @Deprecated
    public String toString() {
        return null;
    }

    public String escreveGrupo(TecnospeedUtil.Padrao padraoAtual) {
        if (this.nomeGrupo == null || Funcoes.textoVazio(this.nomeGrupo)) {
            this.trataExcecao(new IntegracaoTecnospeedException("Nome do grupo n\u00e3o informado.\nClasse: " + this.getClass().getSimpleName() + ".", null), null);
            return null;
        }
        if (this.campos == null || this.campos.length == 0) {
            this.trataExcecao(new IntegracaoTecnospeedException("Os campos do grupo n\u00e3o foram informados.\nGrupo \"" + this.nomeGrupo + "\".", null), null);
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.campos.length; ++i) {
            String valorCampo = null;
            try {
                valorCampo = this.campos[i].escreveCampo(padraoAtual);
            }
            catch (IntegracaoTecnospeedException ite) {
                this.trataExcecao(ite, this.campos[i]);
            }
            if (Funcoes.textoVazio(valorCampo)) continue;
            buf.append(valorCampo);
            buf.append("\n");
        }
        return buf.toString();
    }

    private void trataExcecao(IntegracaoTecnospeedException ite, Campo campo) {
        ErrosCampos erro = new ErrosCampos(ite.getMessage(), campo);
        this.listaErros.add(erro);
    }
}

