/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.faturamento.integracao.ConfiguradorIntegracao;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConfiguradorTecnospeed
extends JDialog
implements ConfiguradorIntegracao {
    public static final String TAG_PORTA = "porta";
    public static final String TAG_URL = "url";
    public static final String TAG_SENHA = "senha";
    public static final String TAG_USUARIO = "usuario";
    public static final String TAG_GRUPO = "grupo";
    public static final String TAG_OBSERVACAO = "campoObs";
    public static final String TAG_CONFIGURACAO_TECNOSPEED = "configuracaoTecnospeed";
    private JPanel panel = new JPanel(new GridBagLayout());
    private JButton botaoCancelar = new JButton("Cancelar");
    private JButton botaoOK = new JButton("OK");
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JLabel labelUrl = new JLabel("URL:");
    private JLabel labelPorta = new JLabel("Porta:");
    private JLabel labelGrupo = new JLabel("Grupo:");
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private JLabel labelSenha = new JLabel("Senha:");
    private JLabel labelObservacao = new JLabel("Campo Obs:");
    private JLabel labelCaracteres = new JLabel("caracteres");
    private TTextField textUrl = new TTextField(40, 3);
    private TTextField textPorta = new TTextField(4, 3);
    private TTextField textGrupo = new TTextField(10, 3);
    private TTextField textUsuario = new TTextField(10, 3);
    private TTextField textSenha = new TTextField(10, 3);
    private TTextField textObservacao = new TTextField(4, 1);
    private boolean ok = false;

    public static ConfiguradorTecnospeed novaInstancia(Window owner) {
        if (owner instanceof JFrame) {
            return new ConfiguradorTecnospeed((JFrame)owner, "Configura\u00e7\u00e3o Tecnospeed");
        }
        if (owner instanceof JDialog) {
            return new ConfiguradorTecnospeed((JDialog)owner, "Configura\u00e7\u00e3o Tecnospeed");
        }
        return null;
    }

    private ConfiguradorTecnospeed(JDialog owner, String title) {
        super((Dialog)owner, title);
        this.montaTela();
    }

    private ConfiguradorTecnospeed(JFrame owner, String title) {
        super((Frame)owner, title);
        this.montaTela();
    }

    private void montaTela() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(410, 240);
        this.setModal(true);
        this.setResizable(false);
        this.setLocationRelativeTo(this.getOwner());
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.botaoOK.setMnemonic('O');
        this.botaoCancelar.setMnemonic('C');
        this.botaoOK.addActionListener(this);
        this.botaoCancelar.addActionListener(this);
        this.panel.setBorder(new TitledBorder("Configura\u00e7\u00f5es"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        this.panel.add((Component)this.labelPorta, c);
        c.gridx = 1;
        this.textPorta.setPreferredSize(new Dimension(100, 20));
        this.textPorta.setMinimumSize(new Dimension(100, 20));
        this.panel.add((Component)this.textPorta, c);
        ++c.gridy;
        c.gridx = 0;
        this.panel.add((Component)this.labelGrupo, c);
        c.gridx = 1;
        this.textGrupo.setPreferredSize(new Dimension(100, 20));
        this.textGrupo.setMinimumSize(new Dimension(100, 20));
        this.panel.add((Component)this.textGrupo, c);
        ++c.gridy;
        c.gridx = 0;
        this.labelUsuario.setPreferredSize(new Dimension(80, 20));
        this.panel.add((Component)this.labelUsuario, c);
        c.gridx = 1;
        this.textUsuario.setPreferredSize(new Dimension(100, 20));
        this.textUsuario.setMinimumSize(new Dimension(100, 20));
        this.panel.add((Component)this.textUsuario, c);
        ++c.gridy;
        c.gridx = 0;
        this.labelSenha.setPreferredSize(new Dimension(80, 20));
        this.panel.add((Component)this.labelSenha, c);
        c.gridx = 1;
        this.textSenha.setPreferredSize(new Dimension(100, 20));
        this.textSenha.setMinimumSize(new Dimension(100, 20));
        this.panel.add((Component)this.textSenha, c);
        ++c.gridy;
        c.gridx = 0;
        this.labelUrl.setPreferredSize(new Dimension(80, 20));
        this.panel.add((Component)this.labelUrl, c);
        c.gridx = 1;
        this.textUrl.setPreferredSize(new Dimension(310, 20));
        this.textUrl.setMinimumSize(new Dimension(310, 20));
        this.panel.add((Component)this.textUrl, c);
        ++c.gridy;
        c.gridx = 0;
        this.labelObservacao.setPreferredSize(new Dimension(100, 20));
        this.panel.add((Component)this.labelObservacao, c);
        c.gridx = 1;
        c.weightx = 1.0;
        this.textObservacao.setPreferredSize(new Dimension(100, 20));
        this.textObservacao.setMinimumSize(new Dimension(100, 20));
        this.panel.add((Component)this.textObservacao, c);
        c.gridx = 2;
        c.weightx = 0.0;
        this.labelCaracteres.setPreferredSize(new Dimension(50, 20));
        c.fill = 0;
        this.panel.add((Component)this.labelCaracteres, c);
        this.panelBotoes.add(this.botaoOK);
        this.panelBotoes.add(this.botaoCancelar);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(ScreenUtil.criarBordaVazia());
        p.add((Component)this.panel, "Center");
        this.getContentPane().add((Component)p, "Center");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        Funcoes.montaEnter((JComponent)this.panel);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        Funcoes.defineUpperCase(this.getContentPane(), ParametrosGerais.getUpperCase());
    }

    @Override
    public void setXML(String xml) {
        String grupo = StringUtil.getValor(xml, TAG_GRUPO);
        String usuario = StringUtil.getValor(xml, TAG_USUARIO);
        String senha = StringUtil.getValor(xml, TAG_SENHA);
        String url = StringUtil.getValor(xml, TAG_URL);
        String porta = StringUtil.getValor(xml, TAG_PORTA);
        String observacao = StringUtil.getValor(xml, TAG_OBSERVACAO);
        if (!Funcoes.textoVazio(grupo)) {
            this.textGrupo.setText(grupo);
        }
        if (!Funcoes.textoVazio(usuario)) {
            this.textUsuario.setText(usuario);
        }
        if (!Funcoes.textoVazio(senha)) {
            this.textSenha.setText(senha);
        }
        if (!Funcoes.textoVazio(url)) {
            this.textUrl.setText(url);
        }
        if (!Funcoes.textoVazio(porta)) {
            this.textPorta.setText(porta);
        }
        if (!Funcoes.textoVazio(observacao)) {
            this.textObservacao.setText(observacao);
        }
    }

    @Override
    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(TAG_CONFIGURACAO_TECNOSPEED);
        xml.escrever(TAG_GRUPO, this.textGrupo.getText());
        xml.escrever(TAG_USUARIO, this.textUsuario.getText());
        xml.escrever(TAG_SENHA, this.textSenha.getText());
        xml.escrever(TAG_URL, this.textUrl.getText());
        xml.escrever(TAG_PORTA, this.textPorta.getText());
        xml.escrever(TAG_OBSERVACAO, this.textObservacao.getText());
        try {
            xml.fechar(TAG_CONFIGURACAO_TECNOSPEED);
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel obter o xml de configura\u00e7\u00e3o da tecnospeed. \n" + e.getMessage(), e.getStackTrace());
        }
        return xml.getXML();
    }

    @Override
    public boolean isOK() {
        return this.ok;
    }

    @Override
    public void exibirTela(boolean exibirTela) {
        this.setVisible(exibirTela);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.botaoCancelar) {
            this.setVisible(false);
        } else if (e.getSource() == this.botaoOK && this.camposValidos()) {
            this.ok = true;
            this.setVisible(false);
        }
    }

    private boolean camposValidos() {
        if (!Funcoes.textoVazio(this.textObservacao.getText()) && Integer.parseInt(this.textObservacao.getText()) > 8000) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "A quantidade m\u00e1xima permitida para o Campo Observa\u00e7\u00e3o \u00e9 de 8000 caracteres.", 2);
            ScreenUtil.requisitarFoco(this.textObservacao);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String buscaConfiguracoes(String filial) {
        Statement st;
        block4: {
            String string;
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append("select fil_confignfse from filiais_postocoleta ");
            buf.append(" where fil_codigo = ").append(filial);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block4;
                string = rs.getString("fil_confignfse");
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return string;
        }
        Conexao.fecharStatement(st);
        return null;
    }
}

