/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed;

import jalis.comum.ParametrosLocais;
import jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed.ConfiguradorTecnospeed;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.protocol.BasicHttpContext;

public class ComunicacaoTecnospeed {
    public static final String TIPO_DOCUMENTO = "nfse";
    public static final String URL_HOMOLOGACAO = "managersaashom.tecnospeed.com.br";
    public static final String URL_PRODUCAO = "managersaas.tecnospeed.com.br";
    private static int TIMEOUT_CONEXAO = 60000;
    private static final String PARAMETRO_CONEXAO_GRUPO = "grupo";
    private static final String PARAMETRO_CONEXAO_CNPJ = "cnpj";
    private static final String PARAMETRO_CONEXAO_ARQUIVO = "arquivo";
    private static final String PARAMETRO_CONEXAO_USUARIO = "usuario";
    private static final String PARAMETRO_CONEXAO_SENHA = "senha";
    public static boolean debug = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private String cnpj = null;
    private String senha = null;
    private String servidor = null;
    private String grupo = null;
    private String login = null;
    private String porta = null;

    private ComunicacaoTecnospeed(String cnpj, String filial, Boolean isDownloadFile) {
        String configuracao = ConfiguradorTecnospeed.buscaConfiguracoes(filial);
        if (Funcoes.textoVazio(ParametrosLocais.getParametro("tempoRetornoNfse")) || !Funcoes.textoVazio(ParametrosLocais.getParametro("tempoRetornoNfse")) && Integer.parseInt(ParametrosLocais.getParametro("tempoRetornoNfse")) == 0) {
            ParametrosLocais.setParametro("tempoRetornoNfse", "60");
        }
        TIMEOUT_CONEXAO = !isDownloadFile.booleanValue() && !Funcoes.textoVazio(ParametrosLocais.getParametro("tempoRetornoNfse")) ? Integer.parseInt(ParametrosLocais.getParametro("tempoRetornoNfse")) * 1000 : (TIMEOUT_CONEXAO /= 3);
        this.cnpj = cnpj;
        this.grupo = StringUtil.getValor(configuracao, PARAMETRO_CONEXAO_GRUPO);
        this.senha = StringUtil.getValor(configuracao, PARAMETRO_CONEXAO_SENHA);
        this.servidor = StringUtil.getValor(configuracao, "url");
        this.login = StringUtil.getValor(configuracao, PARAMETRO_CONEXAO_USUARIO);
        this.porta = StringUtil.getValor(configuracao, "porta");
    }

    private HttpClient getRequest() {
        HttpClient httpClient = new HttpClient();
        BasicCookieStore cookieStore = new BasicCookieStore();
        BasicHttpContext localContext = new BasicHttpContext();
        HttpState initialState = new HttpState();
        initialState.addCookie(this.gerarCookie());
        if (debug) {
            System.out.println("Timeout: " + TIMEOUT_CONEXAO);
        }
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(TIMEOUT_CONEXAO / 3);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(TIMEOUT_CONEXAO);
        httpClient.getParams().setSoTimeout(TIMEOUT_CONEXAO);
        httpClient.setState(initialState);
        httpClient.getParams().setCookiePolicy("rfc2109");
        localContext.setAttribute("http.cookie-store", (Object)cookieStore);
        return httpClient;
    }

    public String doRequestPost(String metodo, Map<String, String> parametros) throws Exception {
        HttpClient httpclient = this.getRequest();
        PostMethod httpPost = new PostMethod(this.getUrlComunicacaoEdocPost(metodo));
        httpPost.setRequestHeader("Content-Type", "application/x-www- form-urlencoded");
        this.getParamsUrlByRequisicao(httpPost, parametros);
        try {
            httpclient.executeMethod((HttpMethod)httpPost);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return httpPost.getResponseBodyAsString();
    }

    public String doRequestGet(String metodo, String dados) throws Exception {
        try {
            HttpClient httpclient = this.getRequest();
            GetMethod httpGet = new GetMethod(this.getUrlComunicacaoEdocGet(metodo, dados));
            httpGet.setRequestHeader("Content-Type", "application/x-www- form-urlencoded");
            httpclient.executeMethod((HttpMethod)httpGet);
            return httpGet.getResponseBodyAsString();
        }
        catch (Exception e) {
            throw new Exception("N\u00e3o foi poss\u00edvel se comunicar com o servidor (chamada GET): " + e.getMessage());
        }
    }

    private Cookie gerarCookie() {
        String conteudo = "grupo=" + this.grupo + "&" + PARAMETRO_CONEXAO_CNPJ + "=" + this.cnpj + "&" + PARAMETRO_CONEXAO_USUARIO + "=" + this.login + "&" + PARAMETRO_CONEXAO_SENHA + "=" + this.senha;
        return new Cookie(this.servidor, "ManagerAPIWeb", conteudo, "/", null, false);
    }

    private String getUrlComunicacaoEdocGet(String metodo, String dados) {
        dados = dados.replaceAll("\n", "&");
        dados = dados.substring(0, dados.length() - 1);
        String aux = "https://" + this.servidor + ":" + this.porta + "/ManagerAPIWeb/" + TIPO_DOCUMENTO + "/" + metodo + "?grupo=" + this.grupo + "&cnpj=" + this.cnpj + "&" + dados;
        if (debug) {
            System.out.println(aux);
        }
        return aux;
    }

    private String getUrlComunicacaoEdocPost(String metodo) {
        String aux = "https://" + this.servidor + ":" + this.porta + "/ManagerAPIWeb/" + TIPO_DOCUMENTO + "/" + metodo;
        if (debug) {
            System.out.println(aux);
        }
        return aux;
    }

    private void getParamsUrlByRequisicao(PostMethod metodoPost, Map<String, String> parametros) throws IllegalArgumentException {
        for (Map.Entry<String, String> entry : parametros.entrySet()) {
            metodoPost.addParameter(entry.getKey(), entry.getValue());
        }
    }

    public static String enviaPost(String metodo, String dados, String cnpjPrestador, String filial) throws Exception {
        cnpjPrestador = StringUtil.limpaString(cnpjPrestador, new String[]{".", "-", "/"});
        ComunicacaoTecnospeed comunicacao = new ComunicacaoTecnospeed(cnpjPrestador, filial, false);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PARAMETRO_CONEXAO_GRUPO, comunicacao.grupo);
        params.put(PARAMETRO_CONEXAO_CNPJ, cnpjPrestador);
        params.put(PARAMETRO_CONEXAO_ARQUIVO, dados);
        return comunicacao.doRequestPost(metodo, params);
    }

    public static String comunicaPost(String metodo, Map<String, String> parametros, String cnpjPrestador, String filial, Boolean isDownloadArquivo) throws Exception {
        cnpjPrestador = StringUtil.limpaString(cnpjPrestador, new String[]{".", "-", "/"});
        ComunicacaoTecnospeed comunicacao = new ComunicacaoTecnospeed(cnpjPrestador, filial, isDownloadArquivo);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PARAMETRO_CONEXAO_GRUPO, comunicacao.grupo);
        params.put(PARAMETRO_CONEXAO_CNPJ, cnpjPrestador);
        params.putAll(parametros);
        return comunicacao.doRequestPost(metodo, params);
    }

    public static String enviaGet(String metodo, String dados, String cnpjPrestador, String filial, Boolean isDownloadArquivo) throws Exception {
        cnpjPrestador = StringUtil.limpaString(cnpjPrestador, new String[]{".", "-", "/"});
        ComunicacaoTecnospeed comunicacao = new ComunicacaoTecnospeed(cnpjPrestador, filial, isDownloadArquivo);
        return comunicacao.doRequestGet(metodo, dados);
    }
}

