/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed;

import jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed.IntegracaoTecnospeedException;
import jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed.TecnospeedUtil;
import jalis.model.AbstractThreadBean;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ValidaDoc;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Date;

public class Campo {
    private String nome = null;
    private String nomeAmigavel = null;
    private TecnospeedUtil.TipoDado tipo = TecnospeedUtil.TipoDado.INDEFINIDO;
    private TecnospeedUtil.Padrao[] padroes = null;
    private Object valor = null;
    private Field field = null;
    private AbstractThreadBean bean = null;
    private AbstractThreadBean beanPai = null;
    private Object[] listaValores = null;
    private boolean isObrigatorio = false;

    public Object[] getListaValores() {
        return this.listaValores;
    }

    public TecnospeedUtil.TipoDado getTipo() {
        return this.tipo;
    }

    public String getNomeAmigavel() {
        return this.nomeAmigavel;
    }

    public Field getField() {
        return this.field;
    }

    public Object getValor() {
        return this.valor;
    }

    public AbstractThreadBean getBean() {
        return this.bean;
    }

    public AbstractThreadBean getBeanPai() {
        return this.beanPai;
    }

    public Campo(String nome, TecnospeedUtil.TipoDado tipo, TecnospeedUtil.Padrao[] padroes, String nomeAmigavel) {
        this.nome = nome;
        this.tipo = tipo;
        this.padroes = padroes;
        this.nomeAmigavel = nomeAmigavel;
    }

    public Campo(String nome, TecnospeedUtil.TipoDado tipo, TecnospeedUtil.Padrao[] padroes, String nomeAmigavel, boolean isObrigatorio) {
        this.nome = nome;
        this.tipo = tipo;
        this.padroes = padroes;
        this.nomeAmigavel = nomeAmigavel;
        this.isObrigatorio = isObrigatorio;
    }

    public Campo(String nome, TecnospeedUtil.TipoDado tipo, TecnospeedUtil.Padrao[] padroes, String nomeAmigavel, Object[] listaValores) {
        this.nome = nome;
        this.tipo = tipo;
        this.padroes = padroes;
        this.nomeAmigavel = nomeAmigavel;
        this.listaValores = listaValores;
    }

    public void setValor(Object valor, AbstractThreadBean bean, AbstractThreadBean beanPai, String nomeCampo, boolean isObrigatorio) {
        this.bean = bean;
        this.valor = valor;
        this.beanPai = beanPai;
        this.isObrigatorio = isObrigatorio;
        if (bean != null && !Funcoes.textoVazio(nomeCampo)) {
            this.field = this.getField(bean.getClass(), nomeCampo);
        }
    }

    public void setValor(Object valor, AbstractThreadBean bean, AbstractThreadBean beanPai, String nomeCampo) {
        this.bean = bean;
        this.valor = valor;
        this.beanPai = beanPai;
        if (bean != null && !Funcoes.textoVazio(nomeCampo)) {
            this.field = this.getField(bean.getClass(), nomeCampo);
        }
    }

    private Field getField(Class classe, String nomeCampo) {
        if (classe != null) {
            try {
                return classe.getDeclaredField(nomeCampo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Deprecated
    public String toString() {
        return null;
    }

    public String escreveCampo(TecnospeedUtil.Padrao padraoAtual) throws IntegracaoTecnospeedException {
        if (this.padroes != null && !ArraysUtil.contem((Object[])this.padroes, (Object)padraoAtual)) {
            return "";
        }
        if (this.isObrigatorio && (this.valor == null || Funcoes.textoVazio(this.valor.toString()))) {
            throw new IntegracaoTecnospeedException("Valor inv\u00e1lida para campo \"" + this.nome, this);
        }
        if (!this.isObrigatorio && (this.valor == null || Funcoes.textoVazio(this.valor.toString()))) {
            return "";
        }
        if (this.tipo == TecnospeedUtil.TipoDado.TEXTO) {
            return this.nome + "=" + this.valor.toString();
        }
        if (this.tipo == TecnospeedUtil.TipoDado.DATA) {
            if (!(this.valor instanceof Date)) {
                throw new IntegracaoTecnospeedException("Classe inv\u00e1lida para campo \"" + this.nome + ". Tipo = \"" + this.valor.getClass() + "\".", this);
            }
            return this.nome + "=" + Funcoes.formataData("yyyy-MM-dd", (Date)this.valor);
        }
        if (this.tipo == TecnospeedUtil.TipoDado.DATA_HORA) {
            if (!(this.valor instanceof Date)) {
                throw new IntegracaoTecnospeedException("Classe inv\u00e1lida para campo \"" + this.nome + ". Tipo = \"" + this.valor.getClass() + "\".", this);
            }
            return this.nome + "=" + Funcoes.formataData("yyyy-MM-dd", (Date)this.valor) + "T" + Funcoes.formataData("HH:mm:ss", (Date)this.valor);
        }
        if (this.tipo == TecnospeedUtil.TipoDado.MONETARIO) {
            if (!(this.valor instanceof Integer || this.valor instanceof Double || this.valor instanceof BigDecimal)) {
                throw new IntegracaoTecnospeedException("Classe inv\u00e1lida para campo \"" + this.nome + ". Tipo = \"" + this.valor.getClass() + "\".", this);
            }
            Double aux = Double.valueOf(this.valor.toString());
            BigDecimal valorAux = new BigDecimal(aux.toString());
            return this.nome + "=" + Funcoes.formataDecimal("##############0.00##", Double.parseDouble(valorAux.toString())).replace(',', '.');
        }
        if (this.tipo == TecnospeedUtil.TipoDado.INTEIRO) {
            if (!(this.valor instanceof Integer || this.valor instanceof Double || this.valor instanceof Long)) {
                throw new IntegracaoTecnospeedException("Classe inv\u00e1lida para campo \"" + this.nome + ". Tipo = \"" + this.valor.getClass() + "\".", this);
            }
            return this.nome + "=" + String.valueOf(Long.parseLong(Funcoes.limpaDecimal(this.valor.toString())));
        }
        if (this.tipo == TecnospeedUtil.TipoDado.CEP) {
            if (!(Funcoes.isNumeric(Funcoes.limpaDecimal(this.valor.toString())) && (this.valor instanceof Integer || this.valor instanceof Double || this.valor instanceof Long || this.valor instanceof String))) {
                throw new IntegracaoTecnospeedException("Classe inv\u00e1lida para campo \"" + this.nome + ". Tipo = \"" + this.valor.getClass() + "\".", this);
            }
            String valorAux = String.valueOf(Funcoes.limpaDecimal(this.valor.toString()));
            if (this.isObrigatorio && this.valor.toString().length() < 8) {
                throw new IntegracaoTecnospeedException("Valor inv\u00e1lida para campo \"" + this.nome, this);
            }
            return this.nome + "=" + String.valueOf(Funcoes.limpaDecimal(this.valor.toString()));
        }
        if (this.tipo == TecnospeedUtil.TipoDado.INDEFINIDO) {
            boolean isValidado = false;
            if (this.isObrigatorio && this.valor instanceof String && ValidaDoc.checkDoc(this.valor.toString(), 7)) {
                isValidado = true;
                this.tipo = TecnospeedUtil.TipoDado.CNPJ;
            }
            if (!isValidado && this.isObrigatorio && this.valor instanceof String && ValidaDoc.checkDoc(this.valor.toString(), 8)) {
                isValidado = true;
                this.tipo = TecnospeedUtil.TipoDado.CPF;
            }
            if (!isValidado) {
                throw new IntegracaoTecnospeedException("Valor inv\u00e1lido para campo \"" + this.nome + ". Tipo = \"" + this.valor.getClass() + "\".", this);
            }
            return this.nome + "=" + this.valor.toString();
        }
        throw new IntegracaoTecnospeedException("Tipo inv\u00e1lido para campo \"" + this.nome + ". Tipo = \"" + this.valor.getClass() + "\".", this);
    }
}

