/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento.integracao.remover;

import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.faturamento.integracao.DadosEspeciaisCombo;
import jalis.laboratorio.financeiro.faturamento.integracao.DialogoErros;
import jalis.laboratorio.financeiro.faturamento.integracao.ErrosCampos;
import jalis.laboratorio.financeiro.faturamento.integracao.remover.Padrao;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.BairroBean;
import jalis.model.bean.cadastro.CidadeBean;
import jalis.model.bean.cadastro.FilialBean;
import jalis.model.bean.cadastro.convenio.ConvenioBean;
import jalis.model.bean.cadastro.financeiro.MotivoCancelamentoBean;
import jalis.model.bean.cadastro.financeiro.SeriesBean;
import jalis.model.bean.cadastro.financeiro.ServicoBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.bean.financeiro.NotaFiscalServicoBean;
import jalis.model.bean.recepcao.PacienteBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.CidadeVO;
import jalis.model.vo.cadastro.financeiro.ServicoVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.PacienteService;
import jalis.service.cadastro.financeiro.ServicoService;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.ValidaDoc;
import jalis.util.logger.ErrorLogger;
import java.awt.Frame;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.swing.SwingUtilities;

public class IntegracaoG2KA {
    private final String VERSAO_MANUAL = "1.36.0";
    private NotaFiscalBean notaBean = null;
    private NotaFiscalBean notaAnterior = null;
    private FilialBean filialBean = null;
    private PacienteBean paciente = null;
    private ConvenioBean convenio = null;
    private boolean isPessoaFisica = false;
    private boolean isUtilizarConvenio = false;
    private NotaFiscalServicoBean notaServico = null;
    private ServicoBean servico = null;
    private Padrao padrao = null;
    private ArrayList<ErrosCampos> listaErros = null;
    private final int CASAS = ParametrosGerais.getCasasPrecoImposto();
    private final RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoImposto();
    private boolean isNaturezaOperacao110 = false;
    public static final int TIPO_CARACTER = 3;
    public static final int TIPO_DATA = 4;
    public static final int TIPO_MONETARIO = 2;
    public static final int TIPO_PERCENTUAL = 10;
    public static final int TIPO_NUMERICO = 1;
    public static final int TIPO_CPF = 8;
    public static final int TIPO_CNPJ = 7;
    public static final int TIPO_CEP = 9;
    public static final int TIPO_EMAIL = 15;
    public static final int TIPO_BOOLEANO = 100;
    public static final int TIPO_TELEFONE = 101;
    public static boolean debug = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private final String CAMINHO_INTEGRACAO_WSDL = "/sped/integracao?WSDL";
    private final String CAMINHO_IMPRESSAO_WSDL = "/sped/print?WSDL";
    private final String OPERACAO_ENVIAR_TEXTO = "enviarDocumentoFormatoTexto";
    private final String OPERACAO_ENVIAR_XML = "enviarDocumentoFormatoXML";
    private final String OPERACAO_CANCELAR_TEXTO = "enviarCancelamentoFormatoTexto";
    private final String OPERACAO_CANCELAR_XML = "enviarCancelamentoFormatoXML";
    private final String OPERACAO_IMPRIMIR = "imprimirDocumento";
    private final String GET_DADOS_ENVIO = "getDadosEnvio";
    private final String GET_PDF_COMPACTADO = "getPDFCompactado";
    private final String GET_PDF_DOCUMENTOS = "getPDFDocumentos";

    private static Field getField(Class classe, String nomeCampo) {
        if (classe != null) {
            try {
                return classe.getDeclaredField(nomeCampo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean enviarNotaFiscalEletronica(NotaFiscalBean notaBean, boolean gerarNumeracaoRPS) throws Exception {
        StringBuilder buf;
        block8: {
            if (notaBean == null) {
                return false;
            }
            if (gerarNumeracaoRPS || notaBean.getNumeroRps() == null || notaBean.getNumeroRps() <= 0L || notaBean.getSerieAlterada().booleanValue()) {
                notaBean.setNumeroRps(NotaFiscalService.getNumeroRPSComLock(notaBean));
            } else if (notaBean.getNumeroRps() == null || notaBean.getNumeroRps() < 1L) {
                notaBean.setNumeroRps(0L);
            }
            buf = null;
            do {
                this.preencheBean(notaBean);
                this.listaErros = new ArrayList<ErrosCampos>(){

                    @Override
                    public boolean add(ErrosCampos e) {
                        if (e != null) {
                            boolean jaExiste = false;
                            for (ErrosCampos erro : this) {
                                try {
                                    if (!e.getDescricao().equalsIgnoreCase(erro.getDescricao()) || e.getCampoNeogrid().bean == null || e.getCampoNeogrid().bean.getClass() != erro.getCampoNeogrid().bean.getClass() || e.getCampoNeogrid().bean.getValorPrimaryKey() == null || erro.getCampoNeogrid().bean.getValorPrimaryKey() == null || !e.getCampoNeogrid().bean.getValorPrimaryKey().toString().equals(erro.getCampoNeogrid().bean.getValorPrimaryKey().toString())) continue;
                                    jaExiste = true;
                                    break;
                                }
                                catch (Exception e1) {
                                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel comparar os objetos. \n" + e1.getMessage(), e1.getStackTrace());
                                }
                            }
                            if (jaExiste) {
                                return false;
                            }
                            return super.add(e);
                        }
                        return false;
                    }
                };
                this.listaErros.clear();
                buf = new StringBuilder();
                buf.append(this.escreveGrupoIdentificadorCodigoMunicipio());
                buf.append(this.escreveGrupoRPS());
                buf.append(this.escreveGrupoA());
                buf.append(this.escreveGrupoB(TipoRPS.RPS));
                buf.append(this.escreveGrupoC());
                buf.append(this.escreveGrupoD());
                buf.append(this.escreveGrupoE());
                buf.append(this.escreveGrupoF());
                buf.append(this.escreveGrupoG());
                buf.append(this.escreveGrupoH(StatusRPS.Normal));
                buf.append(this.escreveGrupoI());
                buf.append(this.escreveGrupoJ());
                buf.append(this.escreveGrupoJ1());
                buf.append(this.escreveGrupoK());
                buf.append(this.escreveGrupoKD());
                buf.append(this.escreveGrupoK1());
                buf.append(this.escreveGrupoKI());
                buf.append(this.escreveGrupoK2());
                buf.append(this.escreveGrupoL());
                buf.append(this.escreveGrupoL1());
                buf.append(this.escreveGrupoM());
                buf.append(this.escreveGrupoN());
                buf.append(this.escreveGrupoO());
                buf.append(this.escreveGrupoP());
                buf.append(this.escreveGrupoQ());
                buf.append(this.escreveGrupoY());
                buf.append(this.escreveGrupoZ());
                if (debug) {
                    System.out.println(buf.toString());
                }
                if (this.listaErros.size() <= 0) break block8;
                DialogoErros janelaErro = new DialogoErros((Frame)Laboratorio.getInstancia(), this.listaErros);
                janelaErro.setVisible(true);
            } while (janelaErro.isOk());
            return false;
        }
        if (notaBean.getNumeroRps() <= 0L) {
            this.enviarNotaFiscalEletronica(notaBean, true);
        } else {
            this.enviarNFSeWS(buf);
            gerarNumeracaoRPS = false;
        }
        return true;
    }

    public ArrayList<ErrosCampos> getListaErros() {
        return this.listaErros;
    }

    private void preencheBean(NotaFiscalBean notaBean) throws Exception {
        this.notaBean = notaBean;
        this.notaServico = notaBean.getServico();
        try {
            this.filialBean = (FilialBean)new FilialService().get(Variaveis.filialPadrao);
        }
        catch (Exception e) {
            throw new Exception("N\u00e3o foi poss\u00edvel buscar dados da filial. C\u00f3digo: " + Variaveis.filialPadrao + ".\n" + e.getMessage());
        }
        boolean bl = this.isUtilizarConvenio = notaBean.getConvenio() != null;
        this.isPessoaFisica = this.isUtilizarConvenio ? notaBean.getConvenio().getTipoPessoa().equalsIgnoreCase("F") : true;
        this.paciente = null;
        this.convenio = null;
        if (!this.isUtilizarConvenio) {
            try {
                this.paciente = (PacienteBean)new PacienteService().get(notaBean.getPaciente().getFilial().getCodigo().toString(), notaBean.getPaciente().getCodigo().toString());
            }
            catch (Exception e) {
                throw new Exception("Paciente n\u00e3o identificado.\n" + e.getMessage());
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fil_codigo", notaBean.getFilial().getCodigo());
        map.put("con_codigo", notaBean.getConvenio().getCodigo());
        try {
            this.convenio = (ConvenioBean)new ConvenioService().getBean(map);
        }
        catch (ThreadDaoException e) {
            throw new Exception("Conv\u00eanio n\u00e3o identificado.\n" + e.getMessage());
        }
        if (notaBean.getServico() != null && notaBean.getServico().getServico() != null) {
            ServicoVO aux = notaBean.getServico().getServico();
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put("fil_codigo", aux.getFilial().getCodigo());
            map2.put("svc_codigo", aux.getCodigo());
            try {
                this.servico = (ServicoBean)new ServicoService().getBean(map2);
            }
            catch (ThreadDaoException e) {
                throw new Exception("Servi\u00e7o n\u00e3o identificado.\n" + e.getMessage());
            }
        }
        if (this.filialBean.getPadraoLayoutNFSe() == null) {
            throw new Exception("Padr\u00e3o de layout de nota fiscal eletr\u00f4nica n\u00e3o definido.");
        }
        this.padrao = Padrao.get(this.filialBean.getPadraoLayoutNFSe());
    }

    public void enviarNFSeWS(StringBuilder buf) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public boolean cancelarNotaFiscalEletronica(NotaFiscalBean notaBean) throws Exception {
        if (notaBean == null) {
            return false;
        }
        this.notaBean = notaBean;
        try {
            this.filialBean = (FilialBean)new FilialService().get(Variaveis.filialPadrao);
        }
        catch (Exception e) {
            throw new Exception("N\u00e3o foi poss\u00edvel buscar dados da filial. C\u00f3digo: " + Variaveis.filialPadrao + ".\n" + e.getMessage());
        }
        if (this.filialBean.getPadraoLayoutNFSe() == null) {
            throw new Exception("Padr\u00e3o de layout de nota fiscal eletr\u00f4nica n\u00e3o definido.");
        }
        this.padrao = Padrao.get(this.filialBean.getPadraoLayoutNFSe());
        this.listaErros = new ArrayList();
        StringBuilder buf = new StringBuilder();
        buf.append(this.escreveGrupoIdentificador());
        buf.append(this.escreveGrupoCancelamento());
        if (this.listaErros.size() > 0) {
            DialogoErros erros = new DialogoErros((Frame)Laboratorio.getInstancia(), this.listaErros);
            erros.setVisible(true);
            if (!erros.isOk()) {
                return false;
            }
            this.cancelarNotaFiscalEletronica(notaBean);
        }
        return true;
    }

    public boolean imprimirNotaFiscalEletronica(NotaFiscalBean notaBean) throws Exception {
        if (notaBean == null) {
            return false;
        }
        this.notaBean = notaBean;
        try {
            this.filialBean = (FilialBean)new FilialService().get(Variaveis.filialPadrao);
        }
        catch (Exception e) {
            throw new Exception("Filial n\u00e3o identificada. C\u00f3digo: " + Variaveis.filialPadrao + ".\n" + e.getMessage());
        }
        if (this.filialBean.getPadraoLayoutNFSe() == null) {
            throw new Exception("Padr\u00e3o de layout de nota fiscal eletr\u00f4nica n\u00e3o definido.");
        }
        this.padrao = Padrao.get(this.filialBean.getPadraoLayoutNFSe());
        this.listaErros = new ArrayList();
        StringBuilder buf = new StringBuilder();
        buf.append(this.escreveGrupoImpressaoA());
        buf.append(this.escreveGrupoImpressaoI());
        if (this.listaErros.size() > 0) {
            DialogoErros erros = new DialogoErros((Frame)Laboratorio.getInstancia(), this.listaErros);
            erros.setVisible(true);
            return false;
        }
        return true;
    }

    private String escreveGrupoImpressaoA() {
        GrupoImpressaoA grupo = new GrupoImpressaoA();
        grupo.cnpj.setValor(StringUtil.limpaString(this.filialBean.getCnpj(), new String[]{"-", ".", "/"}), this.filialBean, null, "cnpj");
        return grupo.toString();
    }

    private String escreveGrupoImpressaoI() {
        GrupoImpressaoI grupo = new GrupoImpressaoI();
        grupo.chave.setValor(this.notaBean.getChaveRpsNfse(), this.notaBean, null, "chaveRpsNfse");
        grupo.vias.setValor(1, null, null, null);
        grupo.usuario.setValor(Variaveis.login, null, null, null);
        return grupo.toString();
    }

    private String escreveGrupoCancelamento() {
        GrupoCancelamento grupo = new GrupoCancelamento();
        grupo.cnpj.setValor(this.filialBean.getCnpj() == null ? null : StringUtil.limpaString(this.filialBean.getCnpj(), new String[]{"-", ".", "/"}), this.filialBean, null, "cnpj");
        grupo.chaveRps.setValor(this.notaBean.getChaveRpsNfse(), this.notaBean, null, "chaveRpsNfse");
        grupo.numeroNfse.setValor(this.notaBean.getNumero(), this.notaBean, null, "numero");
        grupo.protocoloRecebimento.setValor(this.notaBean.getProtocoloNfse(), this.notaBean, null, "protocoloNfse");
        grupo.motivo.setValor(this.notaBean.getMotivoCancelamento() == null ? null : this.notaBean.getMotivoCancelamento().getDescricao(), this.notaBean.getMotivoCancelamento(), this.notaBean, "descricao");
        grupo.codigoMotivo.setValor(this.notaBean.getMotivoCancelamento() == null ? null : this.notaBean.getMotivoCancelamento().getCodigoNfse(), this.notaBean.getMotivoCancelamento(), this.notaBean, "codigoNfse");
        return grupo.toString();
    }

    private String escreveGrupoIdentificador() {
        GrupoIdentificador grupo = new GrupoIdentificador();
        grupo.codigoMunicipio.setValor(this.filialBean.getCidade() == null ? null : this.filialBean.getCidade().getCodigoIbge(), this.filialBean.getCidade() == null ? new CidadeBean() : this.filialBean.getCidade(), this.filialBean, "codigoIbge");
        return grupo.toString();
    }

    private String escreveGrupoIdentificadorCodigoMunicipio() {
        GrupoIdentificadorCodigoMunicipio grupo = new GrupoIdentificadorCodigoMunicipio();
        grupo.codigoMunicipio.setValor(this.filialBean.getCidade() == null ? null : this.filialBean.getCidade().getCodigoIbge(), this.filialBean.getCidade() == null ? new CidadeBean() : this.filialBean.getCidade(), this.filialBean, "codigoIbge");
        return grupo.toString();
    }

    private String escreveGrupoY() {
        GrupoY grupo = new GrupoY();
        grupo.sequencial.setValor(null, null, null, null);
        grupo.numeroParcela.setValor(null, null, null, null);
        grupo.dataVencimento.setValor(null, null, null, null);
        grupo.valor.setValor(null, null, null, null);
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private String escreveGrupoZ() {
        GrupoZ grupo = new GrupoZ();
        grupo.outrasInformacoes.setValor(null, null, null, null);
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private String escreveGrupoQ() {
        GrupoQ grupo = new GrupoQ();
        grupo.codigoObra.setValor(null, null, null, null);
        grupo.art.setValor(null, null, null, null);
        grupo.aliqDeducConstCivil.setValor(null, null, null, null);
        grupo.servPrestViaPublica.setValor(null, null, null, null);
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private String escreveGrupoP() {
        GrupoP grupo = new GrupoP();
        grupo.razaoSocial.setValor(null, null, null, null);
        grupo.cpf.setValor(null, null, null, null);
        grupo.cnpj.setValor(null, null, null, null);
        grupo.inscricaoMunicipal.setValor(null, null, null, null);
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private String escreveGrupoO() {
        ArrayList<String> listaEmails;
        String email;
        String foneCompleto = !this.isUtilizarConvenio ? this.paciente.getFone() : this.convenio.getFone();
        Integer ddd = 0;
        Integer fone = 0;
        String auxFone = StringUtil.limpaString(foneCompleto, new String[]{"(", ")", "-"});
        if (foneCompleto.contains("(") && !Funcoes.textoVazio(auxFone)) {
            ddd = Funcoes.getDDD(foneCompleto);
            fone = Funcoes.getTelefone(foneCompleto);
        } else if (!Funcoes.textoVazio(auxFone) && auxFone.length() > 8) {
            ddd = Integer.parseInt(auxFone.substring(0, 2));
            fone = Integer.parseInt(auxFone.substring(2));
        }
        String foneComercialCompleto = !this.isUtilizarConvenio ? this.paciente.getFoneComercial() : this.convenio.getFone();
        Integer dddComercial = !this.isUtilizarConvenio ? Funcoes.getDDD(foneComercialCompleto) : null;
        Integer foneComercial = !this.isUtilizarConvenio ? Funcoes.getTelefone(foneComercialCompleto) : null;
        String faxCompleto = !this.isUtilizarConvenio ? null : this.convenio.getFax();
        Integer dddFax = !this.isUtilizarConvenio ? null : Funcoes.getDDD(faxCompleto);
        Integer foneFax = !this.isUtilizarConvenio ? null : Funcoes.getTelefone(faxCompleto);
        String string = email = !this.isUtilizarConvenio ? this.paciente.getEmail() : this.convenio.getEmail1();
        if (!Funcoes.textoVazio(email) && (listaEmails = StringUtil.explode(email, ";, ")) != null) {
            email = listaEmails.get(0);
        }
        GrupoO grupo = new GrupoO();
        grupo.telefone.setValor(ddd + "" + fone, !this.isUtilizarConvenio ? this.paciente : this.convenio, null, "fone");
        grupo.email.setValor(email, !this.isUtilizarConvenio ? this.paciente : this.convenio, null, !this.isUtilizarConvenio ? "email" : "email1");
        grupo.dddTomador.setValor(ddd, null, null, null);
        grupo.dddTelefoneComercial.setValor(dddComercial, !this.isUtilizarConvenio ? this.paciente : this.convenio, null, !this.isUtilizarConvenio ? "foneComercial" : "fone");
        grupo.telefoneComercial.setValor(foneComercial, !this.isUtilizarConvenio ? this.paciente : this.convenio, null, !this.isUtilizarConvenio ? "foneComercial" : "fone");
        grupo.dddFax.setValor(dddFax, !this.isUtilizarConvenio ? this.paciente : this.convenio, null, "fax");
        grupo.telefoneFax.setValor(foneFax, !this.isUtilizarConvenio ? this.paciente : this.convenio, null, "fax");
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private String escreveGrupoN() {
        Integer codigoMunicipio;
        AbstractThreadBean bean = null;
        AbstractThreadBean beanPai = null;
        String valor = "";
        String numero = null;
        if (this.paciente != null && !Funcoes.textoVazio(this.paciente.getNumeroEndereco()) && this.paciente.getNumeroEndereco() != null || this.convenio != null && !Funcoes.textoVazio(this.convenio.getNumeroEndereco()) && this.convenio.getNumeroEndereco() != null) {
            numero = !this.isUtilizarConvenio ? this.paciente.getNumeroEndereco() : this.convenio.getNumeroEndereco();
        }
        GrupoN grupo = new GrupoN();
        grupo.logradouroTomador.setValor(!this.isUtilizarConvenio ? this.paciente.getEndereco() : this.convenio.getEndereco(), !this.isUtilizarConvenio ? this.paciente : this.convenio, null, "endereco");
        grupo.numero.setValor(numero, !this.isUtilizarConvenio ? this.paciente : this.convenio, null, "numeroEndereco");
        grupo.complemento.setValor(!this.isUtilizarConvenio ? this.paciente.getComplemento() : this.convenio.getComplemento(), !this.isUtilizarConvenio ? this.paciente : this.convenio, null, "complemento");
        String string = !this.isUtilizarConvenio ? (this.paciente.getBairro() == null ? null : this.paciente.getBairro().getDescricao()) : (valor = this.convenio.getBairro() == null ? null : this.convenio.getBairro().getDescricao());
        bean = !this.isUtilizarConvenio ? (this.paciente.getBairro() == null ? new BairroBean() : this.paciente.getBairro()) : (this.convenio.getBairro() == null ? new BairroBean() : this.convenio.getBairro());
        beanPai = !this.isUtilizarConvenio ? this.paciente : this.convenio;
        grupo.bairro.setValor(valor, bean, beanPai, "descricao");
        Integer n = !this.isUtilizarConvenio ? (this.paciente.getCidade() == null ? null : this.paciente.getCidade().getCodigoIbge()) : (codigoMunicipio = this.convenio.getCidade() == null ? null : this.convenio.getCidade().getCodigoIbge());
        bean = !this.isUtilizarConvenio ? (this.paciente.getCidade() == null ? new CidadeBean() : this.paciente.getCidade()) : (this.convenio.getCidade() == null ? new CidadeBean() : this.convenio.getCidade());
        beanPai = !this.isUtilizarConvenio ? this.paciente : this.convenio;
        grupo.codigoMunicipio.setValor(codigoMunicipio, bean, beanPai, "codigoIbge");
        String string2 = !this.isUtilizarConvenio ? (this.paciente.getCidade() == null ? null : this.paciente.getCidade().getUf()) : (valor = this.convenio.getCidade() == null ? null : this.convenio.getCidade().getUf());
        bean = !this.isUtilizarConvenio ? (this.paciente.getCidade() == null ? new CidadeBean() : this.paciente.getCidade()) : (this.convenio.getCidade() == null ? new CidadeBean() : this.convenio.getCidade());
        beanPai = !this.isUtilizarConvenio ? this.paciente : this.convenio;
        grupo.uf.setValor(valor, bean, beanPai, "uf");
        grupo.cepTomador.setValor(!this.isUtilizarConvenio ? (this.paciente.getCep() == null ? null : this.paciente.getCep().replaceAll("-", "")) : (this.convenio.getCep() == null ? null : this.convenio.getCep().replace("-", "")), !this.isUtilizarConvenio ? this.paciente : this.convenio, null, "cep");
        grupo.tipoLogradouroTomador.setValor(!this.isUtilizarConvenio ? this.paciente.getTipoLogradouro() : this.convenio.getTipoLogradouro(), !this.isUtilizarConvenio ? this.paciente : this.convenio, null, "tipoLogradouro");
        grupo.tipoBairroTomador.setValor(null, null, null, null);
        String string3 = !this.isUtilizarConvenio ? (this.paciente.getCidade() == null ? null : this.paciente.getCidade().getNome()) : (valor = this.convenio.getCidade() == null ? null : this.convenio.getCidade().getNome());
        bean = !this.isUtilizarConvenio ? (this.paciente.getCidade() == null ? new CidadeBean() : this.paciente.getCidade()) : (this.convenio.getCidade() == null ? new CidadeBean() : this.convenio.getCidade());
        beanPai = !this.isUtilizarConvenio ? this.paciente : this.convenio;
        grupo.cidadeTomadorDescricao.setValor(valor, bean, beanPai, "nome");
        grupo.pontoDeReferencia.setValor(null, null, null, null);
        grupo.pais.setValor("brasil", null, null, null);
        grupo.codigoPais.setValor(null, null, null, null);
        grupo.siglaPais.setValor(null, null, null, null);
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private String escreveGrupoM() {
        GrupoM grupo = new GrupoM();
        String cpf = this.isUtilizarConvenio ? (this.isPessoaFisica ? this.convenio.getCnpjCpf() : null) : this.notaBean.getCpfPagador();
        String cnpj = this.isUtilizarConvenio && !this.isPessoaFisica ? this.convenio.getCnpjCpf() : null;
        grupo.cpf.setValor(StringUtil.limpaString(cpf, new String[]{"-", ".", "/"}), this.isUtilizarConvenio ? (this.isPessoaFisica ? this.convenio : null) : this.notaBean, null, this.isUtilizarConvenio ? (this.isPessoaFisica ? "cnpjCpf" : null) : "cpfPagador");
        grupo.cnpj.setValor(StringUtil.limpaString(cnpj, new String[]{"-", ".", "/"}), this.isUtilizarConvenio && !this.isPessoaFisica ? this.convenio : null, null, this.isUtilizarConvenio && !this.isPessoaFisica ? "cnpjCpf" : null);
        grupo.inscricaoMunicipal.setValor(this.isPessoaFisica ? null : this.convenio.getInscrMunicipal(), this.isPessoaFisica ? null : this.convenio, null, "inscrMunicipal");
        grupo.razaoSocial.setValor(!this.isUtilizarConvenio ? this.notaBean.getNomePagador() : this.convenio.getRazaoSocial(), !this.isUtilizarConvenio ? this.notaBean : this.convenio, null, !this.isUtilizarConvenio ? "nomePagador" : "razaoSocial");
        grupo.nomeFantasia.setValor(!this.isUtilizarConvenio ? this.notaBean.getNomePagador() : this.convenio.getFantasia(), !this.isUtilizarConvenio ? this.notaBean : this.convenio, null, !this.isUtilizarConvenio ? "nomePagador" : "fantasia");
        grupo.inscricaoEstadual.setValor(this.isPessoaFisica ? null : this.convenio.getInscrEstadual(), this.isPessoaFisica ? null : this.convenio, null, "inscrEstadual");
        grupo.inscricaoMunicipalSubstituto.setValor(null, null, null, null);
        grupo.situacaoEspecialTomador.setValor(null, null, null, null);
        grupo.tomadorEstrangeiro.setValor(false, null, null, null);
        grupo.tomadorNaoIdentificado.setValor(false, null, null, null);
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private String escreveGrupoL1() {
        GrupoL1 grupo = new GrupoL1();
        grupo.logradouro.setValor(this.filialBean.getEndereco(), this.filialBean, null, "endereco");
        grupo.numero.setValor("S/N", null, null, null);
        grupo.complemento.setValor(this.filialBean.getComplemento(), this.filialBean, null, "complemento");
        grupo.bairro.setValor(this.filialBean.getBairro() == null ? null : this.filialBean.getBairro().getDescricao(), this.filialBean.getBairro() == null ? new BairroBean() : this.filialBean.getBairro(), this.filialBean, "descricao");
        grupo.codigoMunicipio.setValor(this.filialBean.getCidade() == null ? null : this.filialBean.getCidade().getCodigoIbge(), this.filialBean.getCidade() == null ? new CidadeVO() : this.filialBean.getCidade(), this.filialBean, "codigoIbge");
        grupo.uf.setValor(this.filialBean.getCidade() == null ? null : this.filialBean.getCidade().getUf(), this.filialBean.getCidade() == null ? new CidadeVO() : this.filialBean.getCidade(), this.filialBean, "uf");
        grupo.cep.setValor(this.filialBean.getCep(), this.filialBean, null, "cep");
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private String escreveGrupoL() {
        String foneCompleto = this.filialBean.getFone();
        Integer ddd = Funcoes.getDDD(foneCompleto);
        Integer fone = Funcoes.getTelefone(foneCompleto);
        GrupoL grupo = new GrupoL();
        grupo.cnpj.setValor(StringUtil.limpaString(this.filialBean.getCnpj(), new String[]{"-", ".", "/"}), this.filialBean, null, "cnpj");
        grupo.inscricaoMunicipal.setValor(this.filialBean.getInscricaoMunicipal(), this.filialBean, null, "inscricaoMunicipal");
        grupo.seriePrestacao.setValor(this.notaBean.getSerie() == null ? null : this.notaBean.getSerie().getCodigo(), this.notaBean.getSerie() == null ? new SeriesBean() : this.notaBean.getSerie(), this.notaBean, "codigo");
        grupo.razaoSocialPrestador.setValor(this.filialBean.getRazaoSocial(), this.filialBean, null, "razaoSocial");
        grupo.dddPrestador.setValor(ddd, this.filialBean, null, "fone");
        grupo.telefonePrestador.setValor(fone, this.filialBean, null, "fone");
        grupo.dataAdesaoSN.setValor(null, null, null, null);
        grupo.email.setValor(null, null, null, null);
        grupo.nomeFantasia.setValor(this.filialBean.getRazaoSocial(), this.filialBean, null, "razaoSocial");
        grupo.aEDF.setValor(null, null, null, null);
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private String escreveGrupoK2() {
        GrupoK2 grupo = new GrupoK2();
        grupo.descricaoServico.setValor(this.servico.getDescricao(), this.servico, null, "descricao");
        grupo.quantidade.setValor(1, null, null, null);
        grupo.valorUnitario.setValor(this.notaServico.getValor(), this.notaServico, null, "valor");
        grupo.valorTotal.setValor(this.notaServico.getValor(), this.notaServico, null, "valor");
        grupo.tributavel.setValor(this.servico.getTributavel(), this.servico, null, "tributavel", Tributavel.getItens(this.padrao));
        grupo.valorDeduzir.setValor(this.notaBean.getValorDeducoes(), this.notaBean, null, "valorDeducoes");
        grupo.valorISSRetido.setValor(this.notaBean.getValorISSRetido(), this.notaBean, null, "valorISSRetido");
        grupo.codigoMunicipioPrestacao.setValor(this.filialBean.getCidade() == null ? null : this.filialBean.getCidade().getCodigoIbge(), this.filialBean.getCidade() == null ? new CidadeBean() : this.filialBean.getCidade(), this.filialBean, "codigoIbge");
        grupo.codigoItemListaServico.setValor(this.servico.getItemLista(), this.servico, null, "itemLista");
        grupo.aliquotaItemListaServico.setValor(this.notaBean.getIssPercentual(), this.notaBean, null, "issPercentual");
        grupo.unidadeItemServico.setValor(null, null, null, null);
        grupo.codigoUnidadeItemServico.setValor(null, null, null, null);
        grupo.baseCalculo.setValor(this.notaBean.getBaseCalculo(), this.notaBean, null, "baseCalculo");
        grupo.valorIss.setValor(this.notaBean.getIssValor(), this.notaBean, null, "issValor");
        grupo.justificativaDeducao.setValor(null, null, null, null);
        grupo.codigoTributacaoMunicipio.setValor(this.servico.getCodigoTributacaoMunicipio(), this.servico, null, "codigoTributacaoMunicipio");
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private String escreveGrupoKI() {
        GrupoKI grupo = new GrupoKI();
        grupo.ki.setValor("", null, null, null);
        return grupo.toString();
    }

    private Object escreveGrupoK1() {
        GrupoK1 grupo = new GrupoK1();
        grupo.deducaoPor.setValor(this.servico.getTipoCalculoDeducao(), this.servico, null, "tipoCalculoDeducao");
        grupo.tipoDeducao.setValor(this.servico.getTipoDeducao(), this.servico, null, "tipoDeducao");
        grupo.cpfCnpjReferencia.setValor(null, null, null, null);
        grupo.numeroNFReferencia.setValor(null, null, null, null);
        grupo.valorTotalReferencia.setValor(null, null, null, null);
        grupo.percentualDeduzir.setValor(this.servico.getPercentualDeduzir(), this.servico, null, "percentualDeduzir");
        grupo.valorDeduzir.setValor(this.notaBean.getBaseCalculo(), this.notaBean, null, "baseCalculo");
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private Object escreveGrupoKD() {
        GrupoKD grupo = new GrupoKD();
        grupo.kd.setValor("", null, null, null);
        return grupo.toString();
    }

    private String escreveGrupoK() {
        GrupoK grupo = new GrupoK();
        BigDecimal deducoes = this.notaBean.getValorDeducoes();
        deducoes = deducoes.setScale((int)grupo.valorDeducoes.tamanhoMaximo, this.ROUND);
        Double deducoesAux = deducoes.doubleValue();
        BigDecimal baseCalculo = this.notaBean.getBaseCalculo();
        baseCalculo = baseCalculo.setScale((int)grupo.baseCalculo.tamanhoMaximo, this.ROUND);
        Double baseCalculoAux = baseCalculo.doubleValue();
        BigDecimal valorLiquido = this.notaBean.getValorLiquido();
        valorLiquido = valorLiquido.setScale((int)grupo.valorLiquidoNFSe.tamanhoMaximo, this.ROUND);
        Double valorLiquidoAux = valorLiquido.doubleValue();
        grupo.valorServicos.setValor(this.notaBean.getSubTotal(), this.notaBean, null, "subTotal");
        boolean isDeducao = this.notaBean.getServico() != null && this.notaBean.getServico().getServico() != null && this.notaBean.getServico().getServico().getEnviaDeducaoNfe() != false;
        grupo.valorDeducoes.setValor(isDeducao ? deducoesAux : 0.0, this.notaBean.getServico(), this.notaBean, "enviaDeducaoNfe");
        grupo.valorPis.setValor(this.notaBean.getPisValor(), this.notaBean, null, "pisValor");
        grupo.valorCofins.setValor(this.notaBean.getCofinsValor(), this.notaBean, null, "cofinsValor");
        grupo.valorInss.setValor(this.notaBean.getInssValor(), this.notaBean, null, "inssValor");
        grupo.valorCsll.setValor(this.notaBean.getCsllValor(), this.notaBean, null, "csllValor");
        grupo.issRetido.setValor(this.notaBean.getValorISSRetido() > 0.0, null, null, "issRetido");
        grupo.valorIss.setValor(this.notaBean.getIssValor(), this.notaBean, null, "issValor");
        grupo.valorIr.setValor(this.notaBean.getIrrfValor(), this.notaBean, null, "irrfValor");
        grupo.valorIssRetido.setValor(this.notaBean.getValorISSRetido(), this.notaBean, null, "valorISSRetido");
        grupo.outrasRetencoes.setValor(0.0, null, null, null);
        grupo.baseCalculo.setValor(baseCalculoAux, this.notaBean, null, "baseCalculo");
        Double aliquotaISS = this.notaBean.getIssPercentual();
        String nomeCampoISS = "issPercentual";
        if ((this.notaBean.getIssPercentual() == null || this.notaBean.getIssPercentual() <= 0.0) && this.notaBean.getPercentualISSRetido() != null && this.notaBean.getPercentualISSRetido() > 0.0) {
            aliquotaISS = this.notaBean.getPercentualISSRetido();
            nomeCampoISS = "percentualISSRetido";
        }
        grupo.aliquota.setValor(aliquotaISS, this.notaBean, null, nomeCampoISS);
        grupo.valorLiquidoNFSe.setValor(valorLiquidoAux, this.notaBean, null, "valorLiquido");
        grupo.descontoIncondicionado.setValor(this.notaBean.getValorDescontoIncondicionado(), this.notaBean, null, "valorDescontoIncondicionado");
        grupo.descontoCondicionado.setValor(0.0, null, null, null);
        grupo.aliquotaPIS.setValor(this.notaBean.getPisPercentual(), this.notaBean, null, "pisPercentual");
        grupo.aliquotaCOFINS.setValor(this.notaBean.getCofinsPercentual(), this.notaBean, null, "cofinsPercentual");
        grupo.aliquotaINSS.setValor(this.notaBean.getInssPercentual(), this.notaBean, null, "inssPercentual");
        grupo.aliquotaIR.setValor(this.notaBean.getIrrfPercentual(), this.notaBean, null, "irrfPercentual");
        grupo.aliquotaCSLL.setValor(this.notaBean.getCsllPercentual(), this.notaBean, null, "csllPercentual");
        grupo.justificativaDeducao.setValor(null, null, null, null);
        grupo.aliquotaOutroMunicipio.setValor(null, null, null, null);
        grupo.aliquotaSNIP.setValor(null, null, null, null);
        grupo.valorDeducaoBaseInss.setValor(null, null, null, null);
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private String escreveGrupoJ() {
        GrupoJ grupo = new GrupoJ();
        grupo.itemListaServico.setValor(this.servico.getItemLista(), this.servico, null, "itemLista");
        if (this.padrao.equals((Object)Padrao.PRODAM)) {
            grupo.codigoCNAE.setValor(this.servico.getItemLista(), this.servico, null, "itemLista");
        } else {
            grupo.codigoCNAE.setValor(this.filialBean.getCodigoCnae(), this.filialBean, null, "codigoCnae");
        }
        String observacao = this.servico.getDescricao() + " " + (!Funcoes.textoVazio(this.notaBean.getObservacao()) ? this.notaBean.getObservacao().replaceAll("\n", " ") : "");
        BigDecimal calculoIBPT = BigDecimal.ZERO;
        if (this.notaBean.getServico() != null && this.notaBean.getServico().getServico() != null && this.notaBean.getServico().getServico().getPercentualIbpt() != null && this.notaBean.getServico().getServico().getPercentualIbpt() > 0.0) {
            calculoIBPT = BigDecimal.valueOf(this.notaBean.getSubTotal()).multiply(BigDecimal.valueOf(this.notaBean.getServico().getServico().getPercentualIbpt())).divide(BigDecimal.valueOf(100L));
            calculoIBPT = calculoIBPT.setScale(this.CASAS, this.ROUND);
            observacao = observacao + " - O valor aproximado dos Tributos \u00e9 de R$ " + Funcoes.formataDecimal(calculoIBPT.doubleValue()) + " (" + Funcoes.formataDecimal(this.notaBean.getServico().getServico().getPercentualIbpt()) + "%, Fonte: IBPT) ";
        }
        grupo.codigoTributacaoMunicipio.setValor(this.servico.getCodigoTributacaoMunicipio(), this.servico, null, "codigoTributacaoMunicipio");
        grupo.descricao.setValor(observacao, null, null, null);
        grupo.codigoMunicipio.setValor(this.filialBean.getCidade() == null ? null : this.filialBean.getCidade().getCodigoIbge(), this.filialBean.getCidade() == null ? new CidadeBean() : this.filialBean.getCidade(), this.filialBean, "codigoIbge");
        grupo.municipioPrestacaoDescricao.setValor(this.filialBean.getCidade() == null ? null : this.filialBean.getCidade().getNome(), this.filialBean.getCidade() == null ? new CidadeBean() : this.filialBean.getCidade(), this.filialBean, "nome");
        grupo.tributacao.setValor(this.servico.getTipoTributacao(), this.servico, null, "tipoTributacao", Tributacao.getItens(this.padrao));
        grupo.codigoCfps.setValor(null, null, null, null);
        grupo.tipoLancamento.setValor(null, null, null, null);
        grupo.servicoExportacao.setValor(null, null, null, null);
        grupo.responsavelRetencao.setValor(null, null, null, null);
        grupo.codigoPais.setValor(null, null, null, null);
        grupo.exigibilidadeISS.setValor(this.servico.getExigibilidadeIss(), this.servico, null, "exigibilidadeIss", ExigibilidadeISS.getItens(this.padrao));
        grupo.municipioIncidencia.setValor(this.filialBean.getCidade() == null ? null : this.filialBean.getCidade().getCodigoIbge(), this.filialBean.getCidade() == null ? new CidadeBean() : this.filialBean.getCidade(), this.filialBean, "codigoIbge");
        grupo.numeroProcesso.setValor(null, null, null, null);
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private String escreveGrupoJ1() {
        GrupoJ1 grupo = new GrupoJ1();
        grupo.logradouro.setValor(Funcoes.textoVazio(this.filialBean.getEndereco()) ? null : this.filialBean.getEndereco(), this.filialBean, null, "endereco");
        grupo.numero.setValor("S/N", null, null, null);
        grupo.complemento.setValor(this.filialBean.getComplemento(), this.filialBean, null, "complemento");
        grupo.bairro.setValor(this.filialBean.getBairro() == null ? null : this.filialBean.getBairro().getDescricao(), this.filialBean.getBairro() == null ? new BairroBean() : this.filialBean.getBairro(), this.filialBean, "descricao");
        grupo.codigoMunicipio.setValor(this.filialBean.getCidade() == null ? null : this.filialBean.getCidade().getCodigoIbge(), this.filialBean.getCidade() == null ? new CidadeBean() : this.filialBean.getCidade(), this.filialBean, "codigoIbge");
        grupo.uf.setValor(this.filialBean.getCidade() == null ? null : this.filialBean.getCidade().getUf(), this.filialBean.getCidade() == null ? new CidadeBean() : this.filialBean.getCidade(), this.filialBean, "uf");
        grupo.cep.setValor(this.filialBean.getCep(), this.filialBean, null, "cep");
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private String escreveGrupoI() {
        GrupoI grupo = new GrupoI();
        grupo.numero.setValor(null, null, null, null);
        grupo.serie.setValor(null, null, null, null);
        grupo.tipo.setValor(null, null, null, null);
        grupo.numeroNFSeSubstituida.setValor(null, null, null, null);
        grupo.dataEmissaoNFSeSubstituida.setValor(null, null, null, null);
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private String escreveGrupoH(StatusRPS status) {
        GrupoH grupo = new GrupoH();
        grupo.status.setValor(status.codigo, null, null, null);
        grupo.motivoCancelamento.setValor(this.notaBean.getMotivoCancelamento() != null ? this.notaBean.getMotivoCancelamento().getDescricao() : null, this.notaBean.getMotivoCancelamento() == null ? new MotivoCancelamentoBean() : this.notaBean.getMotivoCancelamento(), this.notaBean, "descricao");
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private String escreveGrupoG() {
        GrupoG grupo = new GrupoG();
        grupo.incentivadorCultural.setValor(this.filialBean.getIncentivadorCultural(), this.filialBean, null, "incentivadorCultural");
        grupo.incentivoFiscal.setValor(this.filialBean.getIncentivoFiscal(), this.filialBean, null, "incentivoFiscal");
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private String escreveGrupoF() {
        GrupoF grupo = new GrupoF();
        grupo.optanteSimplesNacional.setValor(this.filialBean.getOptanteSimplesNacional(), this.filialBean, null, "optanteSimplesNacional");
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private String escreveGrupoE() {
        GrupoE grupo = new GrupoE();
        if (this.filialBean.getRegimeEspecialTributacao() != null) {
            grupo.regimeEspecialTributacao.setValor(Integer.parseInt(this.filialBean.getRegimeEspecialTributacao()), this.filialBean, null, "regimeEspecialTributacao");
        } else {
            grupo.regimeEspecialTributacao.setValor(null, null, null, null);
        }
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private String escreveGrupoD() {
        GrupoD grupo = new GrupoD();
        if (this.servico.getNaturezaOperacao() != null && Funcoes.isNumeric(this.servico.getNaturezaOperacao())) {
            grupo.naturezaOperacao.setValor(this.servico.getNaturezaOperacao() != null ? Integer.parseInt(this.servico.getNaturezaOperacao()) : 0, this.servico, null, "naturezaOperacao", NaturezaOperacao.getItens(this.padrao));
        } else {
            grupo.naturezaOperacao.setValor(0, this.servico, null, "naturezaOperacao", NaturezaOperacao.getItens(this.padrao));
        }
        boolean bl = this.isNaturezaOperacao110 = this.servico.getNaturezaOperacao() != null && Funcoes.isNumeric(this.servico.getNaturezaOperacao()) && Integer.parseInt(this.servico.getNaturezaOperacao()) == NaturezaOperacao.Intermediacao.codigo;
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private String escreveGrupoC() {
        GrupoC grupo = new GrupoC();
        GregorianCalendar aux = new GregorianCalendar();
        aux.setTime(this.notaBean.getDataHora());
        GregorianCalendar nova = new GregorianCalendar();
        nova.setTime(this.notaBean.getDataEmissao());
        nova.add(11, aux.get(11));
        nova.add(12, aux.get(12));
        nova.add(13, aux.get(13));
        grupo.dataEmissao.setValor(nova.getTime(), this.notaBean, null, "dataEmissao");
        grupo.competencia.setValor(nova.getTime(), this.notaBean, null, "dataEmissao");
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private String escreveGrupoB(TipoRPS tipoRPS) {
        GrupoB grupo = new GrupoB();
        grupo.numero.setValor(this.notaBean.getNumeroRps(), this.notaBean, null, "numeroRps");
        grupo.serie.setValor(this.notaBean.getSerie() == null ? null : this.notaBean.getSerie().getCodigo(), this.notaBean.getSerie() == null ? new SeriesBean() : this.notaBean.getSerie(), this.notaBean, "codigo");
        grupo.tipo.setValor(tipoRPS.codigo, null, null, null);
        if (grupo.haInformacoes()) {
            return grupo.toString();
        }
        return "";
    }

    private String escreveGrupoA() {
        GrupoA grupo = new GrupoA();
        grupo.versao.setValor(null, null, null, null);
        grupo.id.setValor(null, null, null, null);
        return grupo.toString();
    }

    private String escreveGrupoRPS() {
        GrupoRPS grupo = new GrupoRPS();
        grupo.rps.setValor(null, null, null, null);
        return grupo.toString();
    }

    class GrupoImpressaoI
    extends Grupo {
        Campo chave;
        Campo vias;
        Campo usuario;

        public GrupoImpressaoI() {
            this.chave = new Campo("chave", "Chave de acesso da nota fiscal de servi\u00e7o eletr\u00f4nica", 3, null, 44, null, Padrao.GRUPO_IMPRESSAO_I_CHAVE, Padrao.GRUPO_IMPRESSAO_I_CHAVE_NAO_APLICA);
            this.vias = new Campo("vias", "N\u00famero de vias", 1, 1, 2, null, Padrao.GRUPO_IMPRESSAO_I_VIAS, Padrao.GRUPO_IMPRESSAO_I_VIAS_NAO_APLICA);
            this.usuario = new Campo("usuario", "Usu\u00e1rio solicitante", 3, 1, 255, null, Padrao.GRUPO_IMPRESSAO_I_USUARIO, Padrao.GRUPO_IMPRESSAO_I_USUARIO_NAO_APLICA);
            this.nomeGrupo = "I";
            this.ordemCampos = new Campo[]{this.chave, this.vias, this.usuario};
            this.padroes = Padrao.GRUPO_IMPRESSAO_I_OBRIGATORIO;
        }
    }

    class GrupoImpressaoA
    extends Grupo {
        Campo cnpj;

        public GrupoImpressaoA() {
            this.cnpj = new Campo("cnpj", "CNPJ do emitente", 7, null, 14, null, Padrao.GRUPO_IMPRESSAO_A_CNPJ, Padrao.GRUPO_IMPRESSAO_A_CNPJ_NAO_APLICA);
            this.nomeGrupo = "A";
            this.ordemCampos = new Campo[]{this.cnpj};
            this.padroes = Padrao.GRUPO_IMPRESSAO_A_OBRIGATORIO;
        }
    }

    class GrupoIdentificadorCodigoMunicipio
    extends Grupo {
        Campo codigoMunicipio;

        public GrupoIdentificadorCodigoMunicipio() {
            this.codigoMunicipio = new Campo("codigoMunicipio", "C\u00f3digo do Munic\u00edpio (IBGE)", 1, null, 7, null, Padrao.GRUPO_IDENTIFICADOR_CODIGO_MUNICIPIO, Padrao.GRUPO_IDENTIFICADOR_CODIGO_MUNICIPIO_NAO_APLICA);
            this.nomeGrupo = "CodigoMunicipio";
            this.ordemCampos = new Campo[]{this.codigoMunicipio};
            this.padroes = Padrao.GRUPO_IDENTIFICADOR_OBRIGATORIO;
        }
    }

    class GrupoIdentificador
    extends Grupo {
        Campo codigoMunicipio;

        public GrupoIdentificador() {
            this.codigoMunicipio = new Campo("codigoMunicipio", "C\u00f3digo do Munic\u00edpio (IBGE)", 1, null, 7, null, Padrao.GRUPO_IDENTIFICADOR_CODIGO_MUNICIPIO, Padrao.GRUPO_IDENTIFICADOR_CODIGO_MUNICIPIO_NAO_APLICA);
            this.nomeGrupo = "IDENTIFICADOR";
            this.ordemCampos = new Campo[]{this.codigoMunicipio};
            this.padroes = Padrao.GRUPO_IDENTIFICADOR_OBRIGATORIO;
        }
    }

    class GrupoCancelamento
    extends Grupo {
        Campo cnpj;
        Campo chaveRps;
        Campo numeroNfse;
        Campo protocoloRecebimento;
        Campo motivo;
        Campo codigoMotivo;

        public GrupoCancelamento() {
            this.cnpj = new Campo("cnpj", "CNPJ do prestador", 7, null, 14, null, Padrao.GRUPO_CANCELAMENTO_CNPJ, Padrao.GRUPO_CANCELAMENTO_CNPJ_NAO_APLICA);
            this.chaveRps = new Campo("chaveRps", "Chave gerada para identificar o rps", 3, null, 41, null, Padrao.GRUPO_CANCELAMENTO_CHAVE_RPS, Padrao.GRUPO_CANCELAMENTO_CHAVE_RPS_NAO_APLICA);
            this.numeroNfse = new Campo("numeroNfse", "N\u00famero da nota a ser cancelada", 1, 1, 15, null, Padrao.GRUPO_CANCELAMENTO_NUMERO_NFSE, Padrao.GRUPO_CANCELAMENTO_NUMERO_NFSE_NAO_APLICA);
            this.protocoloRecebimento = new Campo("protocoloRecebimento", "Protocolo de recebimento da nota no retorno da autoriza\u00e7\u00e3o da nota do RPS", 3, 0, 9, null, Padrao.GRUPO_CANCELAMENTO_PROTOCOLO_RECEBIMENTO, Padrao.GRUPO_CANCELAMENTO_PROTOCOLO_RECEBIMENTO_NAO_APLICA);
            this.motivo = new Campo("motivo", "Motivo do cancelamento", 3, 15, 500, null, Padrao.GRUPO_CANCELAMENTO_MOTIVO, Padrao.GRUPO_CANCELAMENTO_MOTIVO_NAO_APLICA);
            this.codigoMotivo = new Campo("codigoMotivo", "C\u00f3digo do motivo de cancelamento", 3, null, (Integer)4, null, Padrao.GRUPO_CANCELAMENTO_CODIGO_MOTIVO, Padrao.GRUPO_CANCELAMENTO_CODIGO_MOTIVO_NAO_APLICA){

                @Override
                public boolean validarValor() {
                    if (!this.isObrigatorio()) {
                        return true;
                    }
                    for (int i = 0; i < MotivoCancelamento.values().length; ++i) {
                        if (!this.getValor().toString().equalsIgnoreCase(MotivoCancelamento.values()[i].codigo)) continue;
                        return true;
                    }
                    return false;
                }
            };
            this.nomeGrupo = "CANCELAMENTO";
            this.ordemCampos = new Campo[]{this.cnpj, this.chaveRps, this.numeroNfse, this.protocoloRecebimento, this.motivo, this.codigoMotivo};
            this.padroes = Padrao.GRUPO_CANCELAMENTO_OBRIGATORIO;
        }
    }

    class GrupoZ
    extends Grupo {
        Campo outrasInformacoes;

        public GrupoZ() {
            this.outrasInformacoes = new Campo("OutrasInformacoes", "Campo Livre para Informa\u00e7\u00f5es Adicionais", 3, 0, 255, null, Padrao.GRUPO_Z_LIVRE, Padrao.GRUPO_Z_LIVRE_NAO_APLICA);
            this.nomeGrupo = "Z";
            this.ordemCampos = new Campo[]{this.outrasInformacoes};
            this.padroes = Padrao.GRUPO_Z_OBRIGATORIO;
        }
    }

    class GrupoY
    extends Grupo {
        Campo sequencial;
        Campo numeroParcela;
        Campo dataVencimento;
        Campo valor;

        public GrupoY() {
            this.sequencial = new Campo("Sequencial", "N\u00famero Sequencial das Faturas", 1, null, null, null, Padrao.GRUPO_Y_SEQUENCIAL, Padrao.GRUPO_Y_SEQUENCIAL_NAO_APLICA);
            this.numeroParcela = new Campo("NumeroParcela", "Descri\u00e7\u00e3o da Parcela para Envio para Prefeitura", 3, null, null, null, Padrao.GRUPO_Y_NUMERO_PARCELA, Padrao.GRUPO_Y_NUMERO_PARCELA_NAO_APLICA);
            this.dataVencimento = new Campo("DataVencimento", "Data de Vencimento da Fatura", 4, null, null, null, Padrao.GRUPO_Y_DATA_VENCIMENTO, Padrao.GRUPO_Y_DATA_VENCIMENTO_NAO_APLICA);
            this.valor = new Campo("Valor", "Valor da Fatura", 2, 15, 2, null, Padrao.GRUPO_Y_VALOR, Padrao.GRUPO_Y_VALOR_NAO_APLICA);
            this.nomeGrupo = "Y";
            this.ordemCampos = new Campo[]{this.sequencial, this.numeroParcela, this.dataVencimento, this.valor};
            this.padroes = Padrao.GRUPO_Y_OBRIGATORIO;
        }
    }

    class GrupoQ
    extends Grupo {
        Campo codigoObra;
        Campo art;
        Campo aliqDeducConstCivil;
        Campo servPrestViaPublica;
        Campo tipo;

        public GrupoQ() {
            this.codigoObra = new Campo("CodigoObra", "C\u00f3digo da Obra", 3, 0, 15, null, Padrao.GRUPO_Q_CODIGO_OBRA, Padrao.GRUPO_Q_CODIGO_OBRA_NAO_APLICA);
            this.art = new Campo("Art", "C\u00f3digo ART", 3, 0, 15, null, Padrao.GRUPO_Q_ART, Padrao.GRUPO_Q_ART_NAO_APLICA);
            this.aliqDeducConstCivil = new Campo("AliqDeducConstCivil", "Al\u00edquota de Dedu\u00e7\u00e3o", 10, 5, 4, null, Padrao.GRUPO_Q_ALIQ_DEDUC_CONST_CIVIL, Padrao.GRUPO_Q_ALIQ_DEDUC_CONST_CIVIL_NAO_APLICA);
            this.servPrestViaPublica = new Campo("ServPrestViaPublica", "Servi\u00e7o Prestado em Vias P\u00fablicas", 100, null, null, null, Padrao.GRUPO_Q_SERV_PREST_VIA_PUBLICA, Padrao.GRUPO_Q_SERV_PREST_VIA_PUBLICA_NAO_APLICA);
            this.tipo = new Campo("Tipo", "Tipo de empreitada", 1, 0, 1, null, Padrao.GRUPO_Q_TIPO, Padrao.GRUPO_Q_TIPO_NAO_APLICA);
            this.nomeGrupo = "Q";
            this.ordemCampos = new Campo[]{this.codigoObra, this.art, this.aliqDeducConstCivil, this.servPrestViaPublica, this.tipo};
            this.padroes = Padrao.GRUPO_Q_OBRIGATORIO;
        }
    }

    class GrupoP
    extends Grupo {
        Campo razaoSocial;
        Campo cpf;
        Campo cnpj;
        Campo inscricaoMunicipal;

        public GrupoP() {
            this.razaoSocial = new Campo("RazaoSocial", "Razao Social do Intermedi\u00e1rio do Servi\u00e7o", 3, 0, 115, null, Padrao.GRUPO_P_RAZAO_SOCIAL, Padrao.GRUPO_P_RAZAO_SOCIAL_NAO_APLICA);
            this.cpf = new Campo("Cpf", "CPF do Intermedi\u00e1rio", 8, null, 11, null, Padrao.GRUPO_P_CPF, Padrao.GRUPO_P_CPF_NAO_APLICA);
            this.cnpj = new Campo("Cnpj", "CNPJ do Intermedi\u00e1rio", 7, null, 14, null, Padrao.GRUPO_P_CNPJ, Padrao.GRUPO_P_CNPJ_NAO_APLICA);
            this.inscricaoMunicipal = new Campo("InscricaoMunicipal", "Inscri\u00e7\u00e3o Municipal do Intermedi\u00e1rio", 3, null, 15, null, Padrao.GRUPO_P_INSCRICAO_MUNICIPAL, Padrao.GRUPO_P_INSCRICAO_MUNICIPAL_NAO_APLICA);
            if (IntegracaoG2KA.this.isNaturezaOperacao110) {
                this.cpf = new Campo("Cpf", "CPF do Intermedi\u00e1rio", 8, null, 11, null, new Padrao[]{Padrao.ABRASF, Padrao.ABRASF_2, Padrao.SIMPLISS, Padrao.DSF, Padrao.GOIANIA, Padrao.BETHA}, new Padrao[]{Padrao.FIORILLI});
                this.cnpj = new Campo("Cnpj", "CNPJ do Intermedi\u00e1rio", 7, null, 14, null, new Padrao[]{Padrao.ABRASF, Padrao.ABRASF_2, Padrao.SIMPLISS, Padrao.DSF, Padrao.GOIANIA, Padrao.BETHA}, new Padrao[]{Padrao.FIORILLI});
            }
            this.nomeGrupo = "P";
            this.ordemCampos = new Campo[]{this.razaoSocial, this.cpf, this.cnpj, this.inscricaoMunicipal};
            this.padroes = Padrao.GRUPO_P_OBRIGATORIO;
        }
    }

    class GrupoO
    extends Grupo {
        Campo telefone;
        Campo email;
        Campo dddTomador;
        Campo dddTelefoneComercial;
        Campo telefoneComercial;
        Campo dddFax;
        Campo telefoneFax;

        public GrupoO() {
            this.telefone = new Campo("Telefone", "Telefone do tomador", 101, 10, 15, null, Padrao.GRUPO_O_TELEFONE, Padrao.GRUPO_O_TELEFONE_NAO_APLICA);
            this.email = new Campo("Email", "E-mail do tomador", 15, 0, 100, null, Padrao.GRUPO_O_EMAIL, Padrao.GRUPO_O_EMAIL_NAO_APLICA);
            this.dddTomador = new Campo("DDDTomador", "DDD do telefone do tomador", 1, null, 3, null, Padrao.GRUPO_O_DDD_TOMADOR, Padrao.GRUPO_O_DDD_TOMADOR_NAO_APLICA);
            this.dddTelefoneComercial = new Campo("DDDTelefoneComercial", "C\u00f3digo de \u00e1rea do estabelecimento do tomador do servi\u00e7o", 1, 2, 3, null, Padrao.GRUPO_O_DDD_TELEFONE_COMERCIAL, Padrao.GRUPO_O_DDD_TELEFONE_COMERCIAL_NAO_APLICA);
            this.telefoneComercial = new Campo("TelefoneComercial", "Telefone do estabelecimento do tomador do servi\u00e7o", 101, 8, 18, null, Padrao.GRUPO_O_TELEFONE_COMERCIAL, Padrao.GRUPO_O_TELEFONE_COMERCIAL_NAO_APLICA);
            this.dddFax = new Campo("DDDFax", "C\u00f3digo de \u00e1rea do fax do tomador do servi\u00e7o", 1, 2, 3, null, Padrao.GRUPO_O_DDD_FAX, Padrao.GRUPO_O_DDD_FAX_NAO_APLICA);
            this.telefoneFax = new Campo("TelefoneFax", "Numero do fax do tomador do servi\u00e7o", 101, 8, 18, null, Padrao.GRUPO_O_TELEFONE_FAX, Padrao.GRUPO_O_TELEFONE_FAX_NAO_APLICA);
            this.nomeGrupo = "O";
            this.ordemCampos = new Campo[]{this.telefone, this.email, this.dddTomador, this.dddTelefoneComercial, this.telefoneComercial, this.dddFax, this.telefoneFax};
            this.padroes = Padrao.GRUPO_O_OBRIGATORIO;
        }
    }

    class GrupoN
    extends Grupo {
        Campo logradouroTomador;
        Campo numero;
        Campo complemento;
        Campo bairro;
        Campo codigoMunicipio;
        Campo uf;
        Campo cepTomador;
        Campo tipoLogradouroTomador;
        Campo tipoBairroTomador;
        Campo cidadeTomadorDescricao;
        Campo pontoDeReferencia;
        Campo pais;
        Campo codigoPais;
        Campo siglaPais;

        public GrupoN() {
            this.logradouroTomador = new Campo("LogradouroTomador", "Logradouro do Tomador", 3, 0, 80, null, Padrao.GRUPO_N_LOGRADOURO_TOMADOR, Padrao.GRUPO_N_LOGRADOURO_TOMADOR_NAO_APLICA);
            this.numero = new Campo("Numero", "N\u00famero do endere\u00e7o", 3, 0, 10, null, Padrao.GRUPO_N_NUMERO, Padrao.GRUPO_N_NUMERO_NAO_APLICA);
            this.complemento = new Campo("Complemento", "Complemento de endere\u00e7o", 3, 20, 50, null, Padrao.GRUPO_N_COMPLEMENTO, Padrao.GRUPO_N_COMPLEMENTO_NAO_APLICA);
            this.bairro = new Campo("Bairro", "Bairro do endere\u00e7o", 3, 0, 60, null, Padrao.GRUPO_N_BAIRRO, Padrao.GRUPO_N_BAIRRO_NAO_APLICA);
            this.codigoMunicipio = new Campo("CodigoMunicipio", "C\u00f3digo do Munic\u00edpio (IBGE)", 1, null, 7, null, Padrao.GRUPO_N_CODIGO_MUNICIPIO, Padrao.GRUPO_N_CODIGO_MUNICIPIO_NAO_APLICA);
            this.uf = new Campo("Uf", "UF do tomador", 3, null, 2, null, Padrao.GRUPO_N_UF, Padrao.GRUPO_N_UF_NAO_APLICA);
            this.cepTomador = new Campo("CepTomador", "CEP do tomador", 9, null, 8, null, Padrao.GRUPO_N_CEP_TOMADOR, Padrao.GRUPO_N_CEP_TOMADOR_NAO_APLICA);
            this.tipoLogradouroTomador = new Campo("TipoLogradouroTomador", "Tipo de logradouro do tomador", 3, 3, 10, null, Padrao.GRUPO_N_TIPO_LOGRADOURO_TOMADOR, Padrao.GRUPO_N_TIPO_LOGRADOURO_TOMADOR_NAO_APLICA);
            this.tipoBairroTomador = new Campo("TipoBairroTomador", "Tipo de Bairro do Tomador", 3, 0, 10, null, Padrao.GRUPO_N_TIPO_BAIRRO_TOMADOR, Padrao.GRUPO_N_TIPO_BAIRRO_TOMADOR_NAO_APLICA);
            this.cidadeTomadorDescricao = new Campo("CidadeTomadorDescricao", "Nome da cidade do tomador", 3, 40, 60, null, Padrao.GRUPO_N_CIDADE_TOMADOR_DESCRICAO, Padrao.GRUPO_N_CIDADE_TOMADOR_DESCRICAO_NAO_APLICA);
            this.pontoDeReferencia = new Campo("PontoReferencia", "Ponto de refer\u00eancia do endere\u00e7o do estabelecimento", 3, 0, 100, null, Padrao.GRUPO_N_PONTO_DE_REFERENCIA, Padrao.GRUPO_N_PONTO_DE_REFERENCIA_NAO_APLICA);
            this.pais = new Campo("Pais", "Descri\u00e7\u00e3o do pa\u00eds do tomador", 3, 2, 100, null, Padrao.GRUPO_N_PAIS, Padrao.GRUPO_N_PAIS_NAO_APLICA);
            this.codigoPais = new Campo("CodigoPais", "C\u00f3digo do pa\u00eds de nacionalidade do tomador", 1, 0, 4, null, Padrao.GRUPO_N_CODIGO_PAIS, Padrao.GRUPO_N_CODIGO_PAIS_NAO_APLICA);
            this.siglaPais = new Campo("SiglaPais", "Sigla do Pa\u00eds", 3, null, 2, null, Padrao.GRUPO_N_SIGLA_PAIS, Padrao.GRUPO_N_SIGLA_PAIS_NAO_APLICA);
            this.nomeGrupo = "N";
            this.ordemCampos = new Campo[]{this.logradouroTomador, this.numero, this.complemento, this.bairro, this.codigoMunicipio, this.uf, this.cepTomador, this.tipoLogradouroTomador, this.tipoBairroTomador, this.cidadeTomadorDescricao, this.pontoDeReferencia, this.pais, this.codigoPais, this.siglaPais};
            this.padroes = Padrao.GRUPO_N_OBRIGATORIO;
        }
    }

    class GrupoM
    extends Grupo {
        Campo cpf;
        Campo cnpj;
        Campo inscricaoMunicipal;
        Campo razaoSocial;
        Campo nomeFantasia;
        Campo inscricaoEstadual;
        Campo inscricaoMunicipalSubstituto;
        Campo situacaoEspecialTomador;
        Campo tomadorEstrangeiro;
        Campo tomadorNaoIdentificado;

        public GrupoM() {
            this.cpf = new Campo("Cpf", "CPF do tomador", 8, null, 11, null, Padrao.GRUPO_M_CPF, Padrao.GRUPO_M_CPF_NAO_APLICA);
            this.cnpj = new Campo("Cnpj", "CNPJ do tomador", 7, null, 14, null, Padrao.GRUPO_M_CNPJ, Padrao.GRUPO_M_CNPJ_NAO_APLICA);
            this.inscricaoMunicipal = new Campo("InscricaoMunicipal", "Inscri\u00e7\u00e3o Municipal do tomador", 3, null, 25, null, Padrao.GRUPO_M_INSCRICAO_MUNICIPAL, Padrao.GRUPO_M_INSCRICAO_MUNICIPAL_NAO_APLICA);
            this.razaoSocial = new Campo("RazaoSocial", "Raz\u00e3o Social do Tomador", 3, null, 120, null, Padrao.GRUPO_M_RAZAO_SOCIAL, Padrao.GRUPO_M_RAZAO_SOCIAL_NAO_APLICA);
            this.nomeFantasia = new Campo("NomeFantasia", "Sobrenome ou Nome Fantasia do Tomador do Servi\u00e7o", 3, null, 100, null, Padrao.GRUPO_M_NOME_FANTASIA, Padrao.GRUPO_M_NOME_FANTASIA_NAO_APLICA);
            this.inscricaoEstadual = new Campo("InscricaoEstadual", "Inscri\u00e7\u00e3o Estadual do Tomador do Servi\u00e7o", 3, 8, 20, null, Padrao.GRUPO_M_INSCRICAO_ESTADUAL, Padrao.GRUPO_M_INSCRICAO_ESTADUAL_NAO_APLICA);
            this.inscricaoMunicipalSubstituto = new Campo("InscricaoMunicipalSubstituto", "Inscri\u00e7\u00e3o Municipal do Tomador Substituto", 3, null, 15, null, Padrao.GRUPO_M_INSCRICAO_MUNICIPAL_SUBSTITUTO, Padrao.GRUPO_M_INSCRICAO_MUNICIPAL_SUBSTITUTO_NAO_APLICA);
            this.situacaoEspecialTomador = new Campo("SituacaoEspecialTomador", "Situa\u00e7\u00e3o Especial do Tomador", 1, null, (Integer)1, null, Padrao.GRUPO_M_SITUACAO_ESPECIAL_TOMADOR, Padrao.GRUPO_M_SITUACAO_ESPECIAL_TOMADOR_NAO_APLICA){

                @Override
                public boolean validarValor() {
                    if (!this.isObrigatorio()) {
                        return true;
                    }
                    for (int i = 0; i < SituacaoEspecialTomador.values().length; ++i) {
                        if (SituacaoEspecialTomador.values()[i].codigo != Integer.parseInt(this.getValor().toString())) continue;
                        return true;
                    }
                    return false;
                }
            };
            this.tomadorEstrangeiro = new Campo("TomadorEstrangeiro", "Tomador Estrangeiro", 100, null, 1, null, Padrao.GRUPO_M_TOMADOR_ESTRANGEIRO, Padrao.GRUPO_M_TOMADOR_ESTRANGEIRO_NAO_APLICA);
            this.tomadorNaoIdentificado = new Campo("TomadorNaoIdentificado", "Tomador N\u00e3o Identificado", 100, null, 1, null, Padrao.GRUPO_M_TOMADOR_NAO_IDENTIFICADO, Padrao.GRUPO_M_TOMADOR_NAO_IDENTIFICADO_NAO_APLICA);
            if (IntegracaoG2KA.this.isPessoaFisica) {
                Campo.access$802(this.cnpj, null);
            } else {
                Campo.access$802(this.cpf, null);
            }
            this.nomeGrupo = "M";
            this.ordemCampos = new Campo[]{this.cpf, this.cnpj, this.inscricaoMunicipal, this.razaoSocial, this.nomeFantasia, this.inscricaoEstadual, this.inscricaoMunicipalSubstituto, this.situacaoEspecialTomador, this.tomadorEstrangeiro, this.tomadorNaoIdentificado};
            this.padroes = Padrao.GRUPO_M_OBRIGATORIO;
        }
    }

    class GrupoL1
    extends Grupo {
        Campo logradouro;
        Campo numero;
        Campo complemento;
        Campo bairro;
        Campo codigoMunicipio;
        Campo uf;
        Campo cep;
        Campo tipoLogradouro;

        public GrupoL1() {
            this.logradouro = new Campo("Logradouro", "Logradouro do Prestador", 3, 0, 125, null, Padrao.GRUPO_L1_LOGRADOURO, Padrao.GRUPO_L1_LOGRADOURO_NAO_APLICA);
            this.numero = new Campo("Numero", "N\u00famero do Endere\u00e7o", 3, 0, 10, null, Padrao.GRUPO_L1_NUMERO, Padrao.GRUPO_L1_NUMERO_NAO_APLICA);
            this.complemento = new Campo("Complemento", "Complemento do Endere\u00e7o do Prestador", 3, 0, 60, null, Padrao.GRUPO_L1_COMPLEMENTO, Padrao.GRUPO_L1_COMPLEMENTO_NAO_APLICA);
            this.bairro = new Campo("Bairro", "Bairro do Endere\u00e7o", 3, 0, 60, null, Padrao.GRUPO_L1_BAIRRO, Padrao.GRUPO_L1_BAIRRO_NAO_APLICA);
            this.codigoMunicipio = new Campo("CodigoMunicipio", "C\u00f3digo do Munic\u00edpio (IBGE)", 1, null, 7, null, Padrao.GRUPO_L1_CODIGO_MUNICIPIO, Padrao.GRUPO_L1_CODIGO_MUNICIPIO_NAO_APLICA);
            this.uf = new Campo("Uf", "Sigla da Unidade Federativa", 3, null, 2, null, Padrao.GRUPO_L1_UF, Padrao.GRUPO_L1_UF_NAO_APLICA);
            this.cep = new Campo("Cep", "N\u00famero do Cep", 9, null, 8, null, Padrao.GRUPO_L1_CEP, Padrao.GRUPO_L1_CEP_NAO_APLICA);
            this.tipoLogradouro = new Campo("TipoLogradouro", "Tipo de Logradouro do Prestador", 3, 3, 10, null, Padrao.GRUPO_L1_TIPO_LOGRADOURO, Padrao.GRUPO_L1_TIPO_LOGRADOURO_NAO_APLICA);
            this.nomeGrupo = "L1";
            this.ordemCampos = new Campo[]{this.logradouro, this.numero, this.complemento, this.bairro, this.codigoMunicipio, this.uf, this.cep, this.tipoLogradouro};
            this.padroes = Padrao.GRUPO_L1_OBRIGATORIO;
        }
    }

    class GrupoL
    extends Grupo {
        Campo cnpj;
        Campo inscricaoMunicipal;
        Campo seriePrestacao;
        Campo razaoSocialPrestador;
        Campo dddPrestador;
        Campo telefonePrestador;
        Campo dataAdesaoSN;
        Campo email;
        Campo nomeFantasia;
        Campo aEDF;
        Campo inscricaoEstadual;

        public GrupoL() {
            this.cnpj = new Campo("Cnpj", "CNPJ do Prestador", 7, null, 14, null, Padrao.GRUPO_L_CNPJ, Padrao.GRUPO_L_CNPJ_NAO_APLICA);
            this.inscricaoMunicipal = new Campo("InscricaoMunicipal", "Inscri\u00e7\u00e3o Municipal do Prestador", 3, null, 15, null, Padrao.GRUPO_L_INSCRICAO_MUNICIPAL, Padrao.GRUPO_L_INSCRICAO_MUNICIPAL_NAO_APLICA);
            this.seriePrestacao = new Campo("SeriePrestacao", "S\u00e9rie de Presta\u00e7\u00e3o", 1, null, 2, null, Padrao.GRUPO_L_SERIE_PRESTACAO, Padrao.GRUPO_L_SERIE_PRESTACAO_NAO_APLICA);
            this.razaoSocialPrestador = new Campo("RazaoSocialPrestador", "Raz\u00e3o Social do Prestador", 3, 60, 120, null, Padrao.GRUPO_L_RAZAO_SOCIAL_PRESTADOR, Padrao.GRUPO_L_RAZAO_SOCIAL_PRESTADOR_NAO_APLICA);
            this.dddPrestador = new Campo("DDDPrestador", "DDD do Telefone do Prestador", 1, null, 3, null, Padrao.GRUPO_L_DDD_PRESTADOR, Padrao.GRUPO_L_DDD_PRESTADOR_NAO_APLICA);
            this.telefonePrestador = new Campo("TelefonePrestador", "Telefone do Prestador", 3, null, 8, null, Padrao.GRUPO_L_TELEFONE_PRESTADOR, Padrao.GRUPO_L_TELEFONE_PRESTADOR_NAO_APLICA);
            this.dataAdesaoSN = new Campo("DataAdesaoSN", "Data de Ades\u00e3o ao Simples Nacional", 4, null, null, null, Padrao.GRUPO_L_DATA_ADESAO_SN, Padrao.GRUPO_L_DATA_ADESAO_SN_NAO_APLICA);
            this.email = new Campo("Email", "E-mail do Prestador", 15, 0, 80, null, Padrao.GRUPO_L_EMAIL, Padrao.GRUPO_L_EMAIL_NAO_APLICA);
            this.nomeFantasia = new Campo("NomeFantasia", "Nome Fantasia do Prestador", 3, null, 60, null, Padrao.GRUPO_L_NOME_FANTASIA, Padrao.GRUPO_L_NOME_FANTAISA_NAO_APLICA);
            this.aEDF = new Campo("AEDF", "Autoriza\u00e7\u00e3o Emiss\u00e3o Documento Fiscal", 3, null, 6, null, Padrao.GRUPO_L_AEDF, Padrao.GRUPO_L_AEDF_NAO_APLICA);
            this.inscricaoEstadual = new Campo("InscricaoEstadual", "Inscri\u00e7\u00e3o Estadual do Prestador do Servi\u00e7o", 3, 8, 20, null, Padrao.GRUPO_L_INSCRICAO_ESTADUAL, Padrao.GRUPO_L_INSCRICAO_ESTADUAL_NAO_APLICA);
            this.nomeGrupo = "L";
            this.ordemCampos = new Campo[]{this.cnpj, this.inscricaoMunicipal, this.seriePrestacao, this.razaoSocialPrestador, this.dddPrestador, this.telefonePrestador, this.dataAdesaoSN, this.email, this.nomeFantasia, this.aEDF, this.inscricaoEstadual};
            this.padroes = Padrao.GRUPO_L_OBRIGATORIO;
        }
    }

    class GrupoK2
    extends Grupo {
        Campo descricaoServico;
        Campo quantidade;
        Campo valorUnitario;
        Campo valorTotal;
        Campo tributavel;
        Campo valorDeduzir;
        Campo valorISSRetido;
        Campo codigoMunicipioPrestacao;
        Campo codigoItemListaServico;
        Campo aliquotaItemListaServico;
        Campo unidadeItemServico;
        Campo codigoUnidadeItemServico;
        Campo baseCalculo;
        Campo valorIss;
        Campo justificativaDeducao;
        Campo codigoTributacaoMunicipio;
        Campo codigoCNAE;

        public GrupoK2() {
            this.descricaoServico = new Campo("DescricaoServico", "Descri\u00e7\u00e3o do Servi\u00e7o", 3, 80, 255, null, Padrao.TODOS, Padrao.GRUPO_K2_DESCRICAO_SERVICO_NAO_APLICA);
            this.quantidade = new Campo("Quantidade", "Quantidade do servi\u00e7o tomado", 1, 15, 4, null, Padrao.GRUPO_K2_QUANTIDADE, Padrao.GRUPO_K2_QUANTIDADE_NAO_APLICA);
            this.valorUnitario = new Campo("ValorUnitario", "Valor Unit\u00e1rio", 1, 16, 4, null, Padrao.GRUPO_K2_VALOR_UNITARIO, Padrao.GRUPO_K2_VALOR_UNITARIO_NAO_APLICA);
            this.valorTotal = new Campo("ValorTotal", "Valor total do servi\u00e7o", 1, 15, 4, null, Padrao.GRUPO_K2_VALOR_TOTAL, Padrao.GRUPO_K2_VALOR_TOTAL_NAO_APLICA);
            this.tributavel = new Campo("Tributavel", "Tribut\u00e1vel", 3, (Integer)1, (Integer)3, null, Padrao.GRUPO_K2_TRIBUTAVEL, Padrao.GRUPO_K2_TRIBUTAVEL_NAO_APLICA){

                @Override
                public boolean validarValor() {
                    if (!this.isObrigatorio()) {
                        return true;
                    }
                    for (int i = 0; i < Tributavel.values().length; ++i) {
                        Tributavel tri = Tributavel.values()[i];
                        if (!this.getValor().toString().equalsIgnoreCase(tri.codigo)) continue;
                        for (int j = 0; j < tri.padroes.length; ++j) {
                            if (tri.padroes[j] != IntegracaoG2KA.this.padrao) continue;
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
            };
            this.valorDeduzir = new Campo("ValorDeduzir", "Valor da dedu\u00e7\u00e3o", 2, 15, 2, null, null, Padrao.GRUPO_K2_VALOR_DEDUZIR_NAO_APLICA);
            this.valorISSRetido = new Campo("ValorISSRetido", "Valor do ISS Retido na Fonte", 2, 15, 2, null, Padrao.GRUPO_K2_VALOR_ISS_RETIDO, Padrao.GRUPO_K2_VALOR_ISS_RETIDO_NAO_APLICA);
            this.codigoMunicipioPrestacao = new Campo("CodigoMunicipioPrestacao", "C\u00f3digo da cidade onde o servi\u00e7o foi prestado", 1, null, 9, null, Padrao.GRUPO_K2_CODIGO_MUNICIPIO_PRESTACAO, Padrao.GRUPO_K2_CODIGO_MUNICIPIO_PRESTACAO_NAO_APLICA);
            this.codigoItemListaServico = new Campo("CodigoItemListaServico", "C\u00f3digo do subitem da lista de servi\u00e7o", 1, null, 9, null, Padrao.GRUPO_K2_CODIGO_ITEM_LISTA_SERVICO, Padrao.GRUPO_K2_CODIGO_ITEM_LISTA_SERVICO_NAO_APLICA);
            this.aliquotaItemListaServico = new Campo("AliquotaItemListaServico", "Al\u00edquota que ir\u00e1 incidir sobre a base de c\u00e1lculo", 10, 15, 2, null, Padrao.GRUPO_K2_ALIQUOTA_ITEM_LISTA_SERVICO, Padrao.GRUPO_K2_ALIQUOTA_ITEM_LISTA_SERVICO_NAO_APLICA);
            this.unidadeItemServico = new Campo("UnidadeItemServico", "Unidade do Item de Servi\u00e7o", 3, 2, 5, null, Padrao.GRUPO_K2_UNIDADE_ITEM_SERVICO, Padrao.GRUPO_K2_UNIDADE_ITEM_SERVICO_NAO_APLICA);
            this.codigoUnidadeItemServico = new Campo("CodigoUnidadeItemServico", "C\u00f3digo da Unidade do Item de Servi\u00e7o", 1, null, 9, null, Padrao.GRUPO_K2_CODIGO_UNIDADE_ITEM_SERVICO, Padrao.GRUPO_K2_CODIGO_UNIDADE_ITEM_SERVICO_NAO_APLICA);
            this.baseCalculo = new Campo("BaseCalculo", "Base de c\u00e1lculo do Servi\u00e7o", 1, 10, 2, null, Padrao.GRUPO_K2_BASE_CALCULO, Padrao.GRUPO_K2_BASE_CALCULO_NAO_APLICA);
            this.valorIss = new Campo("valorIss", "Valor de ISS do Servi\u00e7o", 1, 10, 2, null, Padrao.GRUPO_K2_VALOR_ISS, Padrao.GRUPO_K2_VALOR_ISS_NAO_APLICA);
            this.justificativaDeducao = new Campo("JustificativaDeducao", "Justificativa do valor da dedu\u00e7\u00e3o", 3, 0, 1000, null, null, Padrao.GRUPO_K2_JUSTIFICATIVA_DEDUCAO_NAO_APLICA);
            this.codigoTributacaoMunicipio = new Campo("CodigoTributacaoMunicipio", "C\u00f3digo de Tributa\u00e7\u00e3o", 3, 0, 20, null, Padrao.GRUPO_K2_CODIGO_TRIBUTACAO_MUNICIPIO, Padrao.GRUPO_K2_CODIGO_TRIBUTACAO_MUNICIPIO_NAO_APLICA);
            this.codigoCNAE = new Campo("CodigoCNAE", "C\u00f3digo CNAE", 1, null, 7, null, Padrao.GRUPO_K2_CODIGO_CNAE, Padrao.GRUPO_K2_CODIGO_CNAE_NAO_APLICA);
            this.nomeGrupo = "K2";
            this.ordemCampos = new Campo[]{this.descricaoServico, this.quantidade, this.valorUnitario, this.valorTotal, this.tributavel, this.valorDeduzir, this.valorISSRetido, this.codigoMunicipioPrestacao, this.codigoItemListaServico, this.aliquotaItemListaServico, this.unidadeItemServico, this.codigoUnidadeItemServico, this.baseCalculo, this.valorIss, this.justificativaDeducao, this.codigoTributacaoMunicipio, this.codigoCNAE};
            this.padroes = Padrao.GRUPO_K2_OBRIGATORIO;
        }
    }

    class GrupoKI
    extends Grupo {
        Campo ki;

        public GrupoKI() {
            this.ki = new Campo("KI", "Registro agrupador de itens do RPS", 3, 0, 0, null, Padrao.GRUPO_KI_KI, Padrao.GRUPO_KI_KI_NAO_APLICA);
            this.nomeGrupo = "KI";
            this.ordemCampos = new Campo[]{this.ki};
            this.padroes = Padrao.GRUPO_KI_OBRIGATORIO;
        }
    }

    class GrupoK1
    extends Grupo {
        Campo deducaoPor;
        Campo tipoDeducao;
        Campo cpfCnpjReferencia;
        Campo numeroNFReferencia;
        Campo valorTotalReferencia;
        Campo percentualDeduzir;
        Campo valorDeduzir;

        public GrupoK1() {
            this.deducaoPor = new Campo("DeducaoPor", "Dedu\u00e7\u00e3o Por", 3, (Integer)0, (Integer)20, null, Padrao.GRUPO_K1_DEDUCAO_POR, Padrao.GRUPO_K1_DEDUCAO_POR_NAO_APLICA){
                private String[] valoresValidos;
                {
                    this.valoresValidos = new String[]{"Percentual", "Valor"};
                }

                @Override
                public boolean validarValor() {
                    if (!this.isObrigatorio()) {
                        return true;
                    }
                    for (int i = 0; i < this.valoresValidos.length; ++i) {
                        if (!this.getValor().toString().equalsIgnoreCase(this.valoresValidos[i].toString())) continue;
                        return true;
                    }
                    return false;
                }
            };
            this.tipoDeducao = new Campo("TipoDeducao", "Tipo de Dedu\u00e7\u00e3o", 3, (Integer)0, (Integer)255, null, Padrao.GRUPO_K1_TIPO_DEDUCAO, Padrao.GRUPO_K1_TIPO_DEDUCAO_NAO_APLICA){
                private String[] valoresValidos;
                {
                    this.valoresValidos = new String[]{"Despesas com Materiais", "Despesas com Sub-empreitada", ""};
                }

                @Override
                public boolean validarValor() {
                    if (!this.isObrigatorio()) {
                        return true;
                    }
                    for (int i = 0; i < this.valoresValidos.length; ++i) {
                        if (!this.getValor().toString().equalsIgnoreCase(this.valoresValidos[i].toString())) continue;
                        return true;
                    }
                    return false;
                }
            };
            this.cpfCnpjReferencia = new Campo("CPFCNPJReferencia", "CPF ou CNPJ do Fornecedor ou Prestador do Servi\u00e7o", 3, null, 14, null, Padrao.GRUPO_K1_CPF_CNPJ_REFERENCIA, Padrao.GRUPO_K1_CPF_CNPJ_REFERENCIA_NAO_APLICA);
            this.numeroNFReferencia = new Campo("NumeroNFReferencia", "N\u00famero da Nota Fiscal de Refer\u00eancia", 1, null, 10, null, Padrao.GRUPO_K1_NUMERO_NF_REFERENCIA, Padrao.GRUPO_K1_NUMERO_NF_REFERENCIA_NAO_APLICA);
            this.valorTotalReferencia = new Campo("ValorTotalReferencia", "Valor total de Nota Fiscal de Refer\u00eancia", 2, 15, 2, null, Padrao.GRUPO_K1_VALOR_TOTAL_REFERENCIA, Padrao.GRUPO_K1_VALOR_TOTAL_REFERENCIA_NAO_APLICA);
            this.percentualDeduzir = new Campo("PercentualDeduzir", "Percentual a Deduzir", 10, 5, 2, null, Padrao.GRUPO_K1_PERCENTUAL_DEDUZIR, Padrao.GRUPO_K1_PERCENTUAL_DEDUZIR_NAO_APLICA);
            this.valorDeduzir = new Campo("ValorDeduzir", "Valor a ser Deduzido", 2, 15, 2, null, Padrao.GRUPO_K1_VALOR_DEDUZIR, Padrao.GRUPO_K1_VALOR_DEDUZIR_NAO_APLICA);
            this.nomeGrupo = "K1";
            this.ordemCampos = new Campo[]{this.deducaoPor, this.tipoDeducao, this.cpfCnpjReferencia, this.numeroNFReferencia, this.valorTotalReferencia, this.percentualDeduzir, this.valorDeduzir};
            this.padroes = Padrao.GRUPO_K1_OBRIGATORIO;
        }
    }

    class GrupoKD
    extends Grupo {
        Campo kd;

        public GrupoKD() {
            this.kd = new Campo("KD", "Registro agrupador das Dedu\u00e7\u00f5es da Nota", 3, 0, 0, null, Padrao.GRUPO_KD_KD, Padrao.GRUPO_KD_KD_NAO_APLICA);
            this.nomeGrupo = "KD";
            this.ordemCampos = new Campo[]{this.kd};
            this.padroes = Padrao.GRUPO_KD_OBRIGATORIO;
        }
    }

    class GrupoK
    extends Grupo {
        Campo valorServicos;
        Campo valorDeducoes;
        Campo valorPis;
        Campo valorCofins;
        Campo valorInss;
        Campo valorIr;
        Campo valorCsll;
        Campo issRetido;
        Campo valorIss;
        Campo valorIssRetido;
        Campo outrasRetencoes;
        Campo baseCalculo;
        Campo aliquota;
        Campo valorLiquidoNFSe;
        Campo descontoIncondicionado;
        Campo descontoCondicionado;
        Campo aliquotaPIS;
        Campo aliquotaCOFINS;
        Campo aliquotaINSS;
        Campo aliquotaIR;
        Campo aliquotaCSLL;
        Campo justificativaDeducao;
        Campo aliquotaOutroMunicipio;
        Campo aliquotaSNIP;
        Campo valorDeducaoBaseInss;

        public GrupoK() {
            this.valorServicos = new Campo("ValorServicos", "Valor dos Servi\u00e7os", 2, 16, 2, null, Padrao.GRUPO_K_VALOR_SERVICOS, Padrao.GRUPO_K_VALOR_SERVICOS_NAO_APLICA);
            this.valorDeducoes = new Campo("ValorDeducoes", "Valor das Dedu\u00e7\u00f5es", 2, 15, 2, null, Padrao.GRUPO_K_VALOR_DEDUCOES, Padrao.GRUPO_K_VALOR_DEDUCOES_NAO_APLICA);
            this.valorPis = new Campo("ValorPis", "Valor do PIS", 2, 16, 2, null, Padrao.GRUPO_K_VALOR_PIS, Padrao.GRUPO_K_VALOR_PIS_NAO_APLICA);
            this.valorCofins = new Campo("ValorCofins", "Valor do Cofins", 2, 16, 2, null, Padrao.GRUPO_K_VALOR_COFINS, Padrao.GRUPO_K_VALOR_COFINS_NAO_APLICA);
            this.valorInss = new Campo("ValorInss", "Valor do INSS", 2, 16, 2, null, Padrao.GRUPO_K_VALOR_INSS, Padrao.GRUPO_K_VALOR_INSS_NAO_APLICA);
            this.valorIr = new Campo("ValorIr", "Valor do IR", 2, 16, 2, null, Padrao.GRUPO_K_VALOR_IR, Padrao.GRUPO_K_VALOR_IR_NAO_APLICA);
            this.valorCsll = new Campo("ValorCsll", "Valor do Csll", 2, 16, 2, null, Padrao.GRUPO_K_VALOR_CSLL, Padrao.GRUPO_K_VALOR_CSLL_NAO_APLICA);
            this.issRetido = new Campo("IssRetido", "ISS retido", 100, 1, 1, null, Padrao.GRUPO_K_ISS_RETIDO, Padrao.GRUPO_K_ISS_RETIDO_NAO_APLICA);
            this.valorIss = new Campo("ValorIss", "Valor do ISS", 2, 16, 2, null, Padrao.GRUPO_K_VALOR_ISS, Padrao.GRUPO_K_VALOR_ISS_NAO_APLICA);
            this.valorIssRetido = new Campo("ValorIssRetido", "Valor do ISS Retido", 2, 16, 2, null, Padrao.GRUPO_K_VALOR_ISS_RETIDO, Padrao.GRUPO_K_VALOR_ISS_RETIDO_NAO_APLICA);
            this.outrasRetencoes = new Campo("OutrasRetencoes", "Valor de Outras Reten\u00e7\u00f5es", 2, 16, 2, null, Padrao.GRUPO_K_OUTRAS_RETENCOES, Padrao.GRUPO_K_OUTRAS_RETENCOES_NAO_APLICA);
            this.baseCalculo = new Campo("BaseCalculo", "Valor da Base de C\u00e1lculo", 2, 16, 2, null, Padrao.GRUPO_K_BASE_CALCULO, Padrao.GRUPO_K_BASE_CALCULO_NAO_APLICA);
            this.aliquota = new Campo("Aliquota", "Al\u00edquota", 10, 6, 4, null, Padrao.GRUPO_K_ALIQUOTA, Padrao.GRUPO_K_ALIQUOTA_NAO_APLICA);
            this.valorLiquidoNFSe = new Campo("ValorLiquidoNfse", "Valor L\u00edquido da NFSe", 2, 15, 2, null, Padrao.GRUPO_K_VALOR_LIQUIDO_NFSE, Padrao.GRUPO_K_VALOR_LIQUIDO_NFSE_NAO_APLICA);
            this.descontoIncondicionado = new Campo("DescontoIncondicionado", "Valor do Desconto Incondicionado", 2, 15, 2, null, Padrao.GRUPO_K_DESCONTO_INCONDICIONADO, Padrao.GRUPO_K_DESCONTO_INCONDICIONADO_NAO_APLICA);
            this.descontoCondicionado = new Campo("DescontoCondicionado", "Valor do Desconto Condicionado", 2, 15, 2, null, Padrao.GRUPO_K_DESCONTO_CONDICIONADO, Padrao.GRUPO_K_DESCONTO_CONDICIONADO_NAO_APLICA);
            this.aliquotaPIS = new Campo("AliquotaPIS", "Al\u00edquota PIS", 10, 6, 4, null, Padrao.GRUPO_K_ALIQUOTA_PIS, Padrao.GRUPO_K_ALIQUOTA_PIS_NAO_APLICA);
            this.aliquotaCOFINS = new Campo("AliquotaCOFINS", "Al\u00edquota COFINS", 10, 6, 4, null, Padrao.GRUPO_K_ALIQUOTA_COFINS, Padrao.GRUPO_K_ALIQUOTA_COFINS_NAO_APLICA);
            this.aliquotaINSS = new Campo("AliquotaINSS", "Al\u00edquota INSS", 10, 6, 4, null, Padrao.GRUPO_K_ALIQUOTA_INSS, Padrao.GRUPO_K_ALIQUOTA_INSS_NAO_APLICA);
            this.aliquotaIR = new Campo("AliquotaIR", "Al\u00edquota IR", 10, 6, 4, null, Padrao.GRUPO_K_ALIQUOTA_IR, Padrao.GRUPO_K_ALIQUOTA_IR_NAO_APLICA);
            this.aliquotaCSLL = new Campo("AliquotaCSLL", "Al\u00edquota CSLL", 10, 6, 4, null, Padrao.GRUPO_K_ALIQUOTA_CSLL, Padrao.GRUPO_K_ALIQUOTA_CSLL_NAO_APLICA);
            this.justificativaDeducao = new Campo("justificativaDeducao", "Justificativa Dedu\u00e7\u00e3o", 3, 0, 1000, null, Padrao.GRUPO_K_JUSTIFICATIVA_DEDUCAO, Padrao.GRUPO_K_JUSTIFICATIVA_DEDUCAO_NAO_APLICA);
            this.aliquotaOutroMunicipio = new Campo("aliquotaOutroMunicipio", "Al\u00edquota Outro Munic\u00edpio", 10, 5, 4, null, Padrao.GRUPO_K_ALIQUOTA_OUTRO_MUNICIPIO, Padrao.GRUPO_K_ALIQUOTA_OUTRO_MUNICIPIO_NAO_APLICA);
            this.aliquotaSNIP = new Campo("aliquotaSnIp", "Al\u00edquota do Simples Nacional / Isen\u00e7\u00e3o Parcial", 10, 5, 4, null, Padrao.GRUPO_K_ALIQUOTA_SNIP, Padrao.GRUPO_K_ALIQUOTA_SNIP_NAO_APLICA);
            this.valorDeducaoBaseInss = new Campo("valorDeducaoBaseInss", "Valor de Dedu\u00e7\u00e3o do valor Base de C\u00e1lculo do INSS", 2, 12, 2, null, Padrao.GRUPO_K_VALOR_DEDUCAO_BASE_INSS, Padrao.GRUPO_K_VALOR_DEDUCAO_BASE_INSS_NAO_APLICA);
            this.nomeGrupo = "K";
            this.ordemCampos = new Campo[]{this.valorServicos, this.valorDeducoes, this.valorPis, this.valorCofins, this.valorInss, this.valorIr, this.valorCsll, this.issRetido, this.valorIss, this.valorIssRetido, this.outrasRetencoes, this.baseCalculo, this.aliquota, this.valorLiquidoNFSe, this.descontoIncondicionado, this.descontoCondicionado, this.aliquotaPIS, this.aliquotaCOFINS, this.aliquotaINSS, this.aliquotaIR, this.aliquotaCSLL, this.justificativaDeducao, this.aliquotaOutroMunicipio, this.aliquotaSNIP, this.valorDeducaoBaseInss};
            this.padroes = Padrao.GRUPO_K_OBRIGATORIO;
        }
    }

    class GrupoJ1
    extends Grupo {
        Campo logradouro;
        Campo numero;
        Campo complemento;
        Campo bairro;
        Campo codigoMunicipio;
        Campo uf;
        Campo cep;

        public GrupoJ1() {
            this.logradouro = new Campo("Logradouro", "Logradouro do Prestador", 3, 0, 80, null, Padrao.GRUPO_J1_LOGRADOURO, Padrao.GRUPO_J1_LOGRADOURO_NAO_APLICA);
            this.numero = new Campo("Numero", "N\u00famero do Endere\u00e7o prestador", 3, 0, 10, null, Padrao.GRUPO_J1_NUMERO, Padrao.GRUPO_J1_NUMERO_NAO_APLICA);
            this.complemento = new Campo("Complemento", "Complemento do Endere\u00e7o prestador", 3, 0, 50, null, Padrao.GRUPO_J1_COMPLEMENTO, Padrao.GRUPO_J1_COMPLEMENTO_NAO_APLICA);
            this.bairro = new Campo("Bairro", "Bairro do Endere\u00e7o", 3, 0, 60, null, Padrao.GRUPO_J1_BAIRRO, Padrao.GRUPO_J1_BAIRRO_NAO_APLICA);
            this.codigoMunicipio = new Campo("CodigoMunicipio", "C\u00f3digo do Munic\u00edpio (IBGE)", 1, null, 7, null, Padrao.GRUPO_J1_CODIGO_MUNICIPIO, Padrao.GRUPO_J1_CODIGO_MUNICIPIO_NAO_APLICA);
            this.uf = new Campo("Uf", "Sigla da Unidade Federativa", 3, null, 2, null, Padrao.GRUPO_J1_UF, Padrao.GRUPO_J1_UF_NAO_APLICA);
            this.cep = new Campo("Cep", "N\u00famero do Cep", 9, null, 8, null, Padrao.GRUPO_J1_CEP, Padrao.GRUPO_J1_CEP_NAO_APLICA);
            this.nomeGrupo = "J1";
            this.ordemCampos = new Campo[]{this.logradouro, this.numero, this.complemento, this.bairro, this.codigoMunicipio, this.uf, this.cep};
            this.padroes = Padrao.GRUPO_J1_OBRIGATORIO;
        }
    }

    class GrupoJ
    extends Grupo {
        Campo itemListaServico;
        Campo codigoCNAE;
        Campo codigoTributacaoMunicipio;
        Campo descricao;
        Campo codigoMunicipio;
        Campo municipioPrestacaoDescricao;
        Campo tributacao;
        Campo codigoCfps;
        Campo tipoLancamento;
        Campo servicoExportacao;
        Campo responsavelRetencao;
        Campo codigoPais;
        Campo exigibilidadeISS;
        Campo municipioIncidencia;
        Campo numeroProcesso;

        public GrupoJ() {
            this.itemListaServico = new Campo("ItemListaServico", "C\u00f3digo de item da lista de servi\u00e7o", 3, null, 5, null, Padrao.GRUPO_J_ITEM_LISTA_SERVICO, Padrao.GRUPO_J_ITEM_LISTA_SERVICO_NAO_APLICA);
            this.codigoCNAE = new Campo("CodigoCnae", "C\u00f3digo CNAE", 3, null, 7, null, Padrao.GRUPO_J_CODIGO_CNAE, Padrao.GRUPO_J_CODIGO_CNAE_NAO_APLICA);
            this.codigoTributacaoMunicipio = new Campo("CodigoTributacaoMunicipio", "C\u00f3digo de Tributa\u00e7\u00e3o", 3, 0, 20, null, Padrao.GRUPO_J_CODIGO_TRIBUTACAO_MUNICIPAL, Padrao.GRUPO_J_CODIGO_TRIBUTACAO_MUNICIPAL_NAO_APLICA);
            this.descricao = new Campo("Descricao", "Descri\u00e7\u00e3o do conte\u00fado da NFSe", 3, 0, 8000, null, Padrao.GRUPO_J_DESCRICAO, Padrao.GRUPO_J_DESCRICAO_NAO_APLICA);
            this.codigoMunicipio = new Campo("CodigoMunicipio", "C\u00f3digo do Munic\u00edpio (IBGE)", 1, null, 7, null, Padrao.GRUPO_J_CODIGO_MUNICIPIO, Padrao.GRUPO_J_CODIGO_MUNICIPIO_NAO_APLICA);
            this.municipioPrestacaoDescricao = new Campo("MunicipioPrestacaoDescricao", "Nome do Munic\u00edpio", 3, 30, 50, null, Padrao.GRUPO_J_MUNICIPIO_PRESTACAO_DESCRICAO, Padrao.GRUPO_J_MUNICIPIO_PRESTACAO_DESCRICAO_NAO_APLICA);
            this.tributacao = new Campo("Tributacao", "Tributa\u00e7\u00e3o", 3, (Integer)1, (Integer)2, null, Padrao.GRUPO_J_TRIBUTACAO, Padrao.GRUPO_J_TRIBUTACAO_NAO_APLICA){

                @Override
                public boolean validarValor() {
                    if (!this.isObrigatorio()) {
                        return true;
                    }
                    for (int i = 0; i < Tributacao.values().length; ++i) {
                        Tributacao tri = Tributacao.values()[i];
                        if (!this.getValor().toString().equalsIgnoreCase(tri.codigo)) continue;
                        for (int j = 0; j < tri.padroes.length; ++j) {
                            if (tri.padroes[j] != IntegracaoG2KA.this.padrao) continue;
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
            };
            this.codigoCfps = new Campo("CodigoCfps", "C\u00f3digo CFPS", 1, null, 3, null, Padrao.GRUPO_J_CODIGO_CFPS, Padrao.GRUPO_J_CODIGO_CFPS_NAO_APLICA);
            this.tipoLancamento = new Campo("TipoLancamento", "Tipo de lan\u00e7amento de acordo com o servi\u00e7o prestado", 3, null, (Integer)1, null, Padrao.GRUPO_J_TIPO_LANCAMENTO, Padrao.GRUPO_J_TIPO_LANCAMENTO_NAO_APLICA){

                @Override
                public boolean validarValor() {
                    if (!this.isObrigatorio()) {
                        return true;
                    }
                    for (int i = 0; i < TipoLancamento.values().length; ++i) {
                        TipoLancamento tipo = TipoLancamento.values()[i];
                        if (!this.getValor().toString().equalsIgnoreCase(tipo.codigo)) continue;
                        for (int j = 0; j < tipo.padroes.length; ++j) {
                            if (tipo.padroes[j] != IntegracaoG2KA.this.padrao) continue;
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
            };
            this.servicoExportacao = new Campo("ServicoExportacao", "Servi\u00e7o Exporta\u00e7\u00e3o", 100, 1, 1, null, Padrao.GRUPO_J_SERVICO_EXPORTACAO, Padrao.GRUPO_J_SERVICO_EXPORTACAO_NAO_APLICA);
            this.responsavelRetencao = new Campo("ResponsavelRetencao", "Identifica\u00e7\u00e3o do respons\u00e1vel pela reten\u00e7\u00e3o do ISS", 1, (Integer)1, (Integer)1, null, Padrao.GRUPO_J_RESPONSAVEL_RETENCAO, Padrao.GRUPO_J_RESPONSAVEL_RETENCAO_NAO_APLICA){
                private Integer[] valoresValidos;
                {
                    this.valoresValidos = new Integer[]{ResponsavelRetencao.Tomador.codigo, ResponsavelRetencao.Intermediario.codigo};
                }

                @Override
                public boolean validarValor() {
                    if (!this.isObrigatorio()) {
                        return true;
                    }
                    for (int i = 0; i < this.valoresValidos.length; ++i) {
                        if (!this.getValor().toString().equalsIgnoreCase(this.valoresValidos[i].toString())) continue;
                        return true;
                    }
                    return false;
                }
            };
            this.codigoPais = new Campo("CodigoPais", "C\u00f3digo de identifica\u00e7\u00e3o do Pa\u00eds conforme tabela BACEN", 3, null, 4, null, Padrao.GRUPO_J_CODIGO_PAIS, Padrao.GRUPO_J_CODIGO_PAIS_NAO_APLICA);
            this.exigibilidadeISS = new Campo("ExigibilidadeISS", "Exigibilidade ISS", 1, null, (Integer)2, null, Padrao.GRUPO_J_EXIGIBILIDADE_ISS, Padrao.GRUPO_J_EXIGIBILIDADE_ISS_NAO_APLICA){

                @Override
                public boolean validarValor() {
                    if (!this.isObrigatorio()) {
                        return true;
                    }
                    for (int i = 0; i < ExigibilidadeISS.values().length; ++i) {
                        ExigibilidadeISS exi = ExigibilidadeISS.values()[i];
                        if (Integer.parseInt(this.getValor().toString()) != exi.codigo) continue;
                        for (int j = 0; j < exi.padroes.length; ++j) {
                            if (exi.padroes[j] != IntegracaoG2KA.this.padrao) continue;
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
            };
            this.municipioIncidencia = new Campo("MunicipioIncidencia", "Munic\u00edpio Incid\u00eancia", 1, null, 7, null, Padrao.GRUPO_J_MUNICIPIO_INCIDENCIA, Padrao.GRUPO_J_MUNICIPIO_INCIDENCIA_NAO_APLICA);
            this.numeroProcesso = new Campo("NumeroProcesso", "N\u00famero do Processo Judicial ou Administrativo de Suspens\u00e3o da Exigibilidade", 3, null, 30, null, Padrao.GRUPO_J_NUMERO_PROCESSO, Padrao.GRUPO_J_NUMERO_PROCESSO_NAO_APLICA);
            this.nomeGrupo = "J";
            this.ordemCampos = new Campo[]{this.itemListaServico, this.codigoCNAE, this.codigoTributacaoMunicipio, this.descricao, this.codigoMunicipio, this.municipioPrestacaoDescricao, this.tributacao, this.codigoCfps, this.tipoLancamento, this.servicoExportacao, this.responsavelRetencao, this.codigoPais, this.exigibilidadeISS, this.municipioIncidencia, this.numeroProcesso};
            this.padroes = Padrao.GRUPO_J_OBRIGATORIO;
        }
    }

    class GrupoI
    extends Grupo {
        Campo numero;
        Campo serie;
        Campo tipo;
        Campo numeroNFSeSubstituida;
        Campo dataEmissaoNFSeSubstituida;

        public GrupoI() {
            this.numero = new Campo("Numero", "N\u00famero do RPS", 1, 10, 15, null, Padrao.GRUPO_I_NUMERO, Padrao.GRUPO_I_NUMERO_NAO_APLICA);
            this.serie = new Campo("Serie", "N\u00famero de s\u00e9rie do RPS", 3, 5, 10, null, Padrao.GRUPO_I_SERIE, Padrao.GRUPO_I_SERIE_NAO_APLICA);
            this.tipo = new Campo("Tipo", "Tipo do RPS", 1, null, (Integer)1, null, Padrao.GRUPO_I_TIPO, Padrao.GRUPO_I_TIPO_NAO_APLICA){
                private Integer[] valoresValidos;
                {
                    this.valoresValidos = new Integer[]{TipoRPS.RPS.codigo, TipoRPS.NotaFiscalConjugada.codigo, TipoRPS.CupomTipoPadrao.codigo};
                }

                @Override
                public boolean validarValor() {
                    if (!this.isObrigatorio()) {
                        return true;
                    }
                    for (int i = 0; i < this.valoresValidos.length; ++i) {
                        if (!this.getValor().toString().equalsIgnoreCase(this.valoresValidos[i].toString())) continue;
                        return true;
                    }
                    return false;
                }
            };
            this.numeroNFSeSubstituida = new Campo("NumeroNFSeSubstituida", "N\u00famero da NFSe Substituida", 1, null, 10, null, Padrao.GRUPO_I_NUMERO_NFSE_SUBSTITUIDA, Padrao.GRUPO_I_NUMERO_NFSE_SUBSTITUIDA_NAO_APLICA);
            this.dataEmissaoNFSeSubstituida = new Campo("DataEmissaoNFSeSubstituida", "Data de Emiss\u00e3o da NFSe Substituida", 4, null, null, null, Padrao.GRUPO_I_DATA_EMISSAO_NFSE_SUBSTITUIDA, Padrao.GRUPO_I_DATA_EMISSAO_NFSE_SUBSTITUIDA_NAO_APLICA);
            this.nomeGrupo = "I";
            this.ordemCampos = new Campo[]{this.numero, this.serie, this.tipo, this.numeroNFSeSubstituida, this.dataEmissaoNFSeSubstituida};
            this.padroes = Padrao.GRUPO_I_OBRIGATORIO;
        }
    }

    class GrupoH
    extends Grupo {
        Campo status;
        Campo motivoCancelamento;

        public GrupoH() {
            this.status = new Campo("Status", "Status do RPS", 1, null, (Integer)1, null, Padrao.GRUPO_H_STATUS, Padrao.GRUPO_H_STATUS_NAO_APLICA){
                private Integer[] valoresValidos;
                {
                    this.valoresValidos = new Integer[]{StatusRPS.Normal.codigo, StatusRPS.Cancelado.codigo, StatusRPS.Extraviada.codigo};
                }

                @Override
                public boolean validarValor() {
                    if (!this.isObrigatorio()) {
                        return true;
                    }
                    for (int i = 0; i < this.valoresValidos.length; ++i) {
                        if (!this.getValor().toString().equalsIgnoreCase(this.valoresValidos[i].toString())) continue;
                        return true;
                    }
                    return false;
                }
            };
            this.motivoCancelamento = new Campo("MotCancelamento", "Motivo de Cancelamento", 3, 0, 80, null, Padrao.GRUPO_H_MOTIVO_CANCELAMENTO, Padrao.GRUPO_H_MOTIVO_CANCELAMENTO_NAO_APLICA);
            this.nomeGrupo = "H";
            this.ordemCampos = new Campo[]{this.status, this.motivoCancelamento};
            this.padroes = Padrao.GRUPO_H_OBRIGATORIO;
        }
    }

    class GrupoG
    extends Grupo {
        Campo incentivadorCultural;
        Campo incentivoFiscal;

        public GrupoG() {
            this.incentivadorCultural = new Campo("IncentivadorCultural", "Incentivador Cultural", 100, 1, 1, null, Padrao.GRUPO_G_INCENTIVADOR_CULTURAL, Padrao.GRUPO_G_INCENTIVADOR_CULTURAL_NAO_APLICA);
            this.incentivoFiscal = new Campo("IncentivoFiscal", "Incentivo Fiscal", 100, 1, 1, null, Padrao.GRUPO_G_INCENTIVO_FISCAL, Padrao.GRUPO_G_INCENTIVO_FISCAL_NAO_APLICA);
            this.nomeGrupo = "G";
            this.ordemCampos = new Campo[]{this.incentivadorCultural, this.incentivoFiscal};
            this.padroes = Padrao.GRUPO_G_OBRIGATORIO;
        }
    }

    class GrupoF
    extends Grupo {
        Campo optanteSimplesNacional;

        public GrupoF() {
            this.optanteSimplesNacional = new Campo("OptanteSimplesNacional", "Optante de Simples Nacional", 100, 1, 1, null, Padrao.GRUPO_F_OPTANTE_SIMPLES_NACIONAL, Padrao.GRUPO_F_OPTANTE_SIMPLES_NACIONAL_NAO_APLICA);
            this.nomeGrupo = "F";
            this.ordemCampos = new Campo[]{this.optanteSimplesNacional};
            this.padroes = Padrao.GRUPO_F_OBRIGATORIO;
        }
    }

    class GrupoE
    extends Grupo {
        Campo regimeEspecialTributacao;

        public GrupoE() {
            this.regimeEspecialTributacao = new Campo("RegimeEspecialTributacao", "Regime Especial de Tributa\u00e7\u00e3o", 1, null, (Integer)1, null, Padrao.GRUPO_E_REGIME_ESPECIAL_TRIBUTACAO, Padrao.GRUPO_E_REGIME_ESPECIAL_TRIBUTACAO_NAO_APLICA){
                private Integer[] valoresValidos;
                {
                    this.valoresValidos = new Integer[]{RegimeEspecialTributacao.MicroempresaMunicipal.codigo, RegimeEspecialTributacao.Estimativa.codigo, RegimeEspecialTributacao.SociedadeProfissionais.codigo, RegimeEspecialTributacao.Cooperativa.codigo, RegimeEspecialTributacao.MicroempresarioIndividual.codigo, RegimeEspecialTributacao.MicroempresarioEmpresaPequenoPorte.codigo};
                }

                @Override
                public boolean validarValor() {
                    if (!this.isObrigatorio()) {
                        return true;
                    }
                    for (int i = 0; i < this.valoresValidos.length; ++i) {
                        if (!this.getValor().toString().equalsIgnoreCase(this.valoresValidos[i].toString())) continue;
                        return true;
                    }
                    return false;
                }
            };
            this.nomeGrupo = "E";
            this.ordemCampos = new Campo[]{this.regimeEspecialTributacao};
            this.padroes = Padrao.GRUPO_E_OBRIGATORIO;
        }
    }

    class GrupoD
    extends Grupo {
        Campo naturezaOperacao;

        public GrupoD() {
            this.naturezaOperacao = new Campo("NaturezaOperacao", "Natureza de Opera\u00e7\u00e3o", 1, null, (Integer)3, null, Padrao.GRUPO_D_NATUREZA_OPERACAO, Padrao.GRUPO_D_NATUREZA_OPERACAO_NAO_APLICA){

                @Override
                public boolean validarValor() {
                    if (!this.isObrigatorio()) {
                        return true;
                    }
                    for (int i = 0; i < NaturezaOperacao.values().length; ++i) {
                        NaturezaOperacao op = NaturezaOperacao.values()[i];
                        if (Integer.parseInt(this.getValor().toString()) != op.codigo) continue;
                        for (int j = 0; j < op.padroes.length; ++j) {
                            if (op.padroes[j] != IntegracaoG2KA.this.padrao) continue;
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
            };
            this.nomeGrupo = "D";
            this.ordemCampos = new Campo[]{this.naturezaOperacao};
            this.padroes = Padrao.GRUPO_D_OBRIGATORIO;
        }
    }

    class GrupoC
    extends Grupo {
        Campo dataEmissao;
        Campo competencia;

        public GrupoC() {
            this.dataEmissao = new Campo("DataEmissao", "Data de Emiss\u00e3o do RPS", 4, null, null, null, Padrao.GRUPO_C_DATAEMISSAO, Padrao.GRUPO_C_DATAEMISSAO_NAO_APLICA);
            this.competencia = new Campo("Competencia", "Data de Compet\u00eancia do RPS", 4, null, null, null, Padrao.GRUPO_C_COMPETENCIA, Padrao.GRUPO_C_COMPETENCIA_NAO_APLICA);
            this.nomeGrupo = "C";
            this.ordemCampos = new Campo[]{this.dataEmissao, this.competencia};
            this.padroes = Padrao.GRUPO_C_OBRIGATORIO;
        }
    }

    class GrupoB
    extends Grupo {
        Campo numero;
        Campo serie;
        Campo tipo;

        public GrupoB() {
            this.numero = new Campo("Numero", "N\u00famero do RPS", 1, 1, 15, null, Padrao.GRUPO_B_NUMERO, Padrao.GRUPO_B_NUMERO_NAO_APLICA);
            this.serie = new Campo("Serie", "N\u00famero de s\u00e9rie do RPS", 3, 1, 5, null, Padrao.GRUPO_B_SERIE, Padrao.GRUPO_B_SERIE_NAO_APLICA);
            this.tipo = new Campo("Tipo", "Tipo do RPS", 1, null, (Integer)1, null, Padrao.GRUPO_B_TIPO, Padrao.GRUPO_B_TIPO_NAO_APLICA){
                private Integer[] valoresValidos;
                {
                    this.valoresValidos = new Integer[]{1, 2, 3, 4};
                }

                @Override
                public boolean validarValor() {
                    if (!this.isObrigatorio()) {
                        return true;
                    }
                    for (int i = 0; i < this.valoresValidos.length; ++i) {
                        if (!this.getValor().toString().equalsIgnoreCase(this.valoresValidos[i].toString())) continue;
                        return true;
                    }
                    return false;
                }
            };
            this.nomeGrupo = "B";
            this.ordemCampos = new Campo[]{this.numero, this.serie, this.tipo};
            this.padroes = Padrao.GRUPO_B_OBRIGATORIO;
        }
    }

    class GrupoA
    extends Grupo {
        Campo versao;
        Campo id;

        public GrupoA() {
            this.versao = new Campo("versao", "Vers\u00e3o do layout", 1, null, 4, null, Padrao.GRUPO_A_VERSAO, Padrao.GRUPO_A_VERSAO_NAO_APLICA);
            this.id = new Campo("Id", "Identificador da TAG a ser assinada", 3, null, null, null, Padrao.GRUPO_A_ID, Padrao.GRUPO_A_ID_NAO_APLICA);
            this.nomeGrupo = "A";
            this.ordemCampos = new Campo[]{this.versao, this.id};
            this.padroes = Padrao.GRUPO_A_OBRIGATORIO;
        }
    }

    class GrupoRPS
    extends Grupo {
        Campo rps;

        public GrupoRPS() {
            this.rps = new Campo("RPS", "Agrupador do RPS", 1, null, null, null, Padrao.GRUPO_RPS_RPS, Padrao.GRUPO_RPS_RPS_NAO_APLICA);
            this.nomeGrupo = "RPS";
            this.ordemCampos = new Campo[]{this.rps};
            this.padroes = Padrao.GRUPO_RPS_OBRIGATORIO;
        }
    }

    class Grupo {
        protected String nomeGrupo = null;
        protected Campo[] ordemCampos = null;
        protected Padrao[] padroes = null;
        protected boolean isB2B = false;

        Grupo() {
        }

        public String toString() {
            if (this.nomeGrupo == null || Funcoes.textoVazio(this.nomeGrupo)) {
                IntegracaoG2KA.this.listaErros.add(new ErrosCampos("Nome do grupo n\u00e3o informado.\nClasse: " + this.getClass().getSimpleName() + ".", (Campo)null));
                return "";
            }
            if (this.ordemCampos == null || this.ordemCampos.length == 0) {
                IntegracaoG2KA.this.listaErros.add(new ErrosCampos("Os campos do grupo n\u00e3o foram informados.\nGrupo \"" + this.nomeGrupo + "\".", (Campo)null));
                return "";
            }
            boolean usaPadrao = false;
            if (this.padroes != null) {
                for (int i = 0; i < this.padroes.length; ++i) {
                    if (this.padroes[i] != IntegracaoG2KA.this.padrao) continue;
                    usaPadrao = true;
                    break;
                }
            }
            if (!usaPadrao) {
                return "";
            }
            StringBuilder buf = new StringBuilder();
            buf.append(this.nomeGrupo);
            int contaVazio = 0;
            for (int i = 0; i < this.ordemCampos.length; ++i) {
                String valor = this.ordemCampos[i].escrever();
                if (Funcoes.textoVazio(valor)) {
                    ++contaVazio;
                    buf.append("|");
                } else {
                    buf.append("|");
                    buf.append(valor);
                }
                if (i != this.ordemCampos.length - 1 || contaVazio != this.ordemCampos.length) continue;
                buf.setLength(0);
                buf.append(this.nomeGrupo);
                if (this.nomeGrupo.equalsIgnoreCase("RPS")) continue;
                buf.append("|");
            }
            buf.append("\n");
            return buf.toString();
        }

        public boolean haInformacoes() {
            for (int i = 0; i < this.ordemCampos.length; ++i) {
                if ((this.ordemCampos[i].valor == null || Funcoes.textoVazio(this.ordemCampos[i].valor.toString().trim())) && !this.ordemCampos[i].isObrigatorio()) continue;
                return true;
            }
            return false;
        }
    }

    public class Campo {
        private String nome = null;
        private String descricao = null;
        private int tipo = -1;
        private Integer tamanhoMinimo = null;
        private Integer tamanhoMaximo = null;
        private ExcecaoTamanho[] excecoesTamanho = null;
        private Padrao[] obrigatorio = null;
        private Padrao[] naoSeAplica = null;
        private Object valor = null;
        private Field field = null;
        private AbstractThreadBean bean = null;
        private AbstractThreadBean beanPai = null;
        private Object[] lista = null;

        public int getTipo() {
            return this.tipo;
        }

        public Integer getTamanhoMaximo() {
            return this.tamanhoMaximo;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public Field getField() {
            return this.field;
        }

        public AbstractThreadBean getBeanPai() {
            return this.beanPai;
        }

        public Object[] getLista() {
            return this.lista;
        }

        public AbstractThreadBean getBean() {
            return this.bean;
        }

        public Object getValor() {
            return this.valor;
        }

        public Campo(String nome, String descricao, int tipo, Integer tamanhoMinimo, Integer tamanhoMaximo, ExcecaoTamanho[] excecoesTamanho, Padrao[] obrigatorio, Padrao[] naoSeAplica) {
            this.nome = nome;
            this.descricao = descricao;
            this.tipo = tipo;
            this.tamanhoMaximo = tamanhoMaximo;
            this.tamanhoMinimo = tamanhoMinimo;
            this.excecoesTamanho = excecoesTamanho;
            this.obrigatorio = obrigatorio;
            this.naoSeAplica = naoSeAplica;
        }

        public boolean isObrigatorio() {
            if (this.obrigatorio == null) {
                return false;
            }
            for (int i = 0; i < this.obrigatorio.length; ++i) {
                if (!IntegracaoG2KA.this.padrao.equals((Object)this.obrigatorio[i])) continue;
                return true;
            }
            return false;
        }

        public boolean naoSeAplica() {
            if (this.naoSeAplica == null) {
                return false;
            }
            for (int i = 0; i < this.naoSeAplica.length; ++i) {
                if (!IntegracaoG2KA.this.padrao.equals((Object)this.naoSeAplica[i])) continue;
                return true;
            }
            return false;
        }

        public void setValor(Object valor, AbstractThreadBean bean, AbstractThreadBean beanPai, String nomeCampo) {
            this.bean = bean;
            this.valor = valor;
            this.beanPai = beanPai;
            if (bean != null && !Funcoes.textoVazio(nomeCampo)) {
                this.field = IntegracaoG2KA.getField(bean.getClass(), nomeCampo);
            }
        }

        public void setValor(Object valor, AbstractThreadBean bean, AbstractThreadBean beanPai, String nomeCampo, Object[] lista) {
            this.bean = bean;
            this.valor = valor;
            this.beanPai = beanPai;
            this.lista = lista;
            if (bean != null && !Funcoes.textoVazio(nomeCampo)) {
                this.field = IntegracaoG2KA.getField(bean.getClass(), nomeCampo);
            }
        }

        public boolean validarValor() {
            if (this.tipo == 100 && !(this.valor instanceof Boolean)) {
                return false;
            }
            if (this.tipo == 8 || this.tipo == 7) {
                String valorDoc;
                String string = valorDoc = this.valor != null ? (String)this.valor : "";
                if (!Funcoes.textoVazio(valorDoc) && !ValidaDoc.checkDoc(valorDoc, this.tipo)) {
                    return false;
                }
            } else if (this.tipo == 9) {
                String valorCep;
                String string = valorCep = this.valor != null ? (String)this.valor : "";
                if (valorCep.length() > 0) {
                    if (!(valorCep = valorCep.substring(0, 5) + "-" + valorCep.substring(5, valorCep.length())).matches("[0-9]{5}-[0-9]{3}")) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            return true;
        }

        public String escrever() {
            boolean obrigatorio = this.isObrigatorio();
            if (this.naoSeAplica()) {
                return "";
            }
            if ((this.valor == null || this.valor instanceof String && Funcoes.textoVazio((String)this.valor)) && obrigatorio) {
                IntegracaoG2KA.this.listaErros.add(new ErrosCampos("Campo obrigat\u00f3rio \"" + this.nome + "\" (\"" + this.descricao + "\") n\u00e3o possui valor.", this));
                return "";
            }
            if (this.valor == null && !obrigatorio) {
                return "";
            }
            if (this.tipo != 4 && this.tipo != 2 && this.tipo != 10 && this.tamanhoMinimo != null && this.valor.toString().length() < this.tamanhoMinimo && obrigatorio) {
                IntegracaoG2KA.this.listaErros.add(new ErrosCampos("Campo \"" + this.nome + "\" (\"" + this.descricao + "\") n\u00e3o possui o tamanho m\u00ednimo. Tamanho = " + this.valor.toString().length() + ", m\u00ednimo = " + this.tamanhoMinimo + ", valor = \"" + this.valor.toString() + "\".", this));
                return "";
            }
            if (this.tipo == 3 || this.tipo == 8 || this.tipo == 9 || this.tipo == 15 || this.tipo == 101 || this.tipo == 7) {
                if (!(this.valor instanceof String)) {
                    if (obrigatorio) {
                        IntegracaoG2KA.this.listaErros.add(new ErrosCampos("Classe inv\u00e1lida para campo \"" + this.nome + "\" (\"" + this.descricao + "\"). Tipo = \"" + this.valor.getClass() + "\".", this));
                    }
                    return "";
                }
                if (this.tamanhoMaximo != null && this.valor.toString().length() > this.tamanhoMaximo) {
                    this.valor = this.valor.toString().substring(0, this.tamanhoMaximo - 1);
                }
                if (this.validarValor()) {
                    return this.valor.toString();
                }
                if (obrigatorio) {
                    IntegracaoG2KA.this.listaErros.add(new ErrosCampos(this.getTextoTipo(this.tipo) + " inv\u00e1lido para o campo \"" + this.nome + "\" (\"" + this.descricao + "\"). Valor = \"" + this.valor + "\".", this));
                }
                return "";
            }
            if (this.tipo == 4) {
                if (!(this.valor instanceof Date)) {
                    if (obrigatorio) {
                        IntegracaoG2KA.this.listaErros.add(new ErrosCampos("Classe inv\u00e1lida para campo \"" + this.nome + "\" (\"" + this.descricao + "\"). Tipo = \"" + this.valor.getClass() + "\".", this));
                    }
                    return "";
                }
                return Funcoes.formataData("yyyy-MM-dd'T'HH:mm:ss", (Date)this.valor);
            }
            if (this.tipo == 2) {
                if (!(this.valor instanceof Integer) && !(this.valor instanceof Double)) {
                    if (obrigatorio) {
                        IntegracaoG2KA.this.listaErros.add(new ErrosCampos("Classe inv\u00e1lida para campo \"" + this.nome + "\" (\"" + this.descricao + "\"). Tipo = \"" + this.valor.getClass() + "\".", this));
                    }
                    return "";
                }
                Double aux = Double.valueOf(this.valor.toString());
                BigDecimal valorAux = new BigDecimal(aux.toString()).setScale((int)this.tamanhoMaximo, IntegracaoG2KA.this.ROUND);
                return Funcoes.formataDecimal("##############0.00##", Double.parseDouble(valorAux.toString())).replace(',', '.');
            }
            if (this.tipo == 10) {
                if (!(this.valor instanceof Integer) && !(this.valor instanceof Double)) {
                    if (obrigatorio) {
                        IntegracaoG2KA.this.listaErros.add(new ErrosCampos("Classe inv\u00e1lida para campo \"" + this.nome + "\" (\"" + this.descricao + "\"). Tipo = \"" + this.valor.getClass() + "\".", this));
                    }
                    return "";
                }
                BigDecimal auxValor = new BigDecimal(this.valor.toString()).setScale((int)this.tamanhoMaximo, IntegracaoG2KA.this.ROUND);
                auxValor = auxValor.divide(new BigDecimal("100"), IntegracaoG2KA.this.ROUND);
                auxValor = auxValor.setScale((int)this.tamanhoMaximo, IntegracaoG2KA.this.ROUND);
                return Funcoes.formataDecimal("##############0.00##", auxValor.doubleValue()).replace(',', '.');
            }
            if (this.tipo == 1) {
                if (!(this.valor instanceof Integer || this.valor instanceof Double || this.valor instanceof Long)) {
                    IntegracaoG2KA.this.listaErros.add(new ErrosCampos("Classe inv\u00e1lida para campo \"" + this.nome + "\" (\"" + this.descricao + "\"). Tipo = \"" + this.valor.getClass() + "\".", this));
                    return "";
                }
                String valorAux = String.valueOf(Long.parseLong(Funcoes.limpaDecimal(this.valor.toString())));
                if (this.validarValor()) {
                    return valorAux;
                }
                IntegracaoG2KA.this.listaErros.add(new ErrosCampos("Valor inv\u00e1lido para o campo \"" + this.nome + "\" (\"" + this.descricao + "\"). Valor = \"" + this.valor + "\".", this));
                return "";
            }
            if (this.tipo == 100) {
                if (Boolean.valueOf(this.valor.toString()).booleanValue()) {
                    return "1";
                }
                return "2";
            }
            IntegracaoG2KA.this.listaErros.add(new ErrosCampos("Tipo inv\u00e1lido para campo \"" + this.nome + "\" (\"" + this.descricao + "\"). Tipo = \"" + this.valor.getClass() + "\".", this));
            return "";
        }

        private String getTextoTipo(int tipo) {
            String texto;
            switch (tipo) {
                case 8: {
                    texto = "CPF";
                    break;
                }
                case 7: {
                    texto = "CNPJ";
                    break;
                }
                case 9: {
                    texto = "CEP";
                    break;
                }
                case 15: {
                    texto = "EMAIL";
                    break;
                }
                case 101: {
                    texto = "TELEFONE";
                    break;
                }
                default: {
                    texto = "Valor";
                }
            }
            return texto;
        }

        static /* synthetic */ Padrao[] access$802(Campo x0, Padrao[] x1) {
            x0.obrigatorio = x1;
            return x1;
        }
    }

    class ExcecaoTamanho {
        public Padrao padrao = null;
        Integer tamanhoMinimo = null;
        Integer tamanhoMaximo = null;

        public ExcecaoTamanho(Padrao padrao, Integer tamanhoMinimo, Integer tamanhoMaximo) {
            this.padrao = padrao;
            this.tamanhoMinimo = tamanhoMinimo;
            this.tamanhoMaximo = tamanhoMaximo;
        }
    }

    public static enum MotivoCancelamento {
        DadosTomadorIncorretos("Dados do Tomador Incorretos", "C001", Padrao.PUBLICA),
        ErroDescricaoServico("Erros na Descri\u00e7\u00e3o do Servi\u00e7o", "C002", Padrao.PUBLICA),
        ErroValorServico("Erro no Valor do Servi\u00e7o", "C003", Padrao.PUBLICA),
        NaturezaOperacaoCodigoItemIncorreto("Natureza da Opera\u00e7\u00e3o e/ou C\u00f3digo do Item da Lista Incorreto", "C004", Padrao.PUBLICA),
        Informa\u00e7\u00f5esDescontosTributosIncorretas("Informa\u00e7\u00f5es de Descontos/Outros Tributos Incorretas", "C005", Padrao.PUBLICA),
        Outros("Outros", "C999", Padrao.PUBLICA);

        String codigo = null;
        String descricao = null;
        Padrao[] padroes = null;

        public String getCodigo() {
            return this.codigo;
        }

        private MotivoCancelamento(String descricao, String codigo, Padrao ... padroes) {
            this.codigo = codigo;
            this.descricao = descricao;
            this.padroes = padroes;
        }

        public String toString() {
            return this.descricao;
        }

        public static MotivoCancelamento[] getItens(Padrao padrao) {
            ArrayList<MotivoCancelamento> lista = new ArrayList<MotivoCancelamento>();
            MotivoCancelamento[] todos = MotivoCancelamento.values();
            block0: for (int i = 0; i < todos.length; ++i) {
                MotivoCancelamento aux = todos[i];
                for (int j = 0; j < aux.padroes.length; ++j) {
                    Padrao auxPadrao = aux.padroes[j];
                    if (!auxPadrao.equals((Object)padrao)) continue;
                    lista.add(aux);
                    continue block0;
                }
            }
            return lista.toArray(new MotivoCancelamento[0]);
        }

        public static MotivoCancelamento get(String codigo) {
            MotivoCancelamento[] todos = MotivoCancelamento.values();
            for (int i = 0; i < todos.length; ++i) {
                MotivoCancelamento aux = todos[i];
                if (!aux.codigo.equalsIgnoreCase(codigo)) continue;
                return aux;
            }
            return null;
        }
    }

    private static enum SituacaoEspecialTomador {
        Outros("Outros", 0, new Padrao[0]),
        Sus("SUS", 1, new Padrao[0]),
        OrgaoPoderExecutivo("\u00d3rg\u00e3o do Poder Executivo", 2, new Padrao[0]),
        Bancos("Bancos", 3, new Padrao[0]),
        ComercioIndustria("Com\u00e9rcio/Ind\u00fastria", 4, new Padrao[0]),
        PoderLegislativoJudiciario("Poder Legislativo/Judici\u00e1rio", 5, new Padrao[0]);

        int codigo = -1;
        String descricao = null;
        Padrao[] padroes = null;

        private SituacaoEspecialTomador(String descricao, int codigo, Padrao ... padroes) {
            this.descricao = descricao;
            this.codigo = codigo;
            this.padroes = padroes;
        }

        public String toString() {
            return this.descricao;
        }
    }

    public static enum ExigibilidadeISS implements DadosEspeciaisCombo
    {
        Exigivel("Exig\u00edvel", 1, Padrao.ABRASF_2),
        NaoIncidencia("N\u00e3o Incid\u00eancia", 2, Padrao.ABRASF_2),
        Isencao("Isen\u00e7\u00e3o", 3, Padrao.ABRASF_2),
        Exportacao("Exporta\u00e7\u00e3o", 4, Padrao.ABRASF_2),
        Imunidade("Imunidade", 5, Padrao.ABRASF_2),
        ExigibilidadeSuspensaDecisaoJudicial("Exigibilidade Suspensa por Decis\u00e3o Judicial", 6, Padrao.ABRASF_2),
        ExigibilidadeSuspensaProcedimentoAdministrativo("Exigibilidade Suspensa por Procedimento Administrativo", 7, Padrao.ABRASF_2);

        int codigo = -1;
        String descricao = null;
        Padrao[] padroes = null;

        @Override
        public Object getCodigo() {
            return this.codigo;
        }

        private ExigibilidadeISS(String descricao, int codigo, Padrao ... padroes) {
            this.descricao = descricao;
            this.codigo = codigo;
            this.padroes = padroes;
        }

        public String toString() {
            return this.descricao;
        }

        public static ExigibilidadeISS[] getItens(Padrao padrao) {
            ArrayList<ExigibilidadeISS> lista = new ArrayList<ExigibilidadeISS>();
            ExigibilidadeISS[] todos = ExigibilidadeISS.values();
            block0: for (int i = 0; i < todos.length; ++i) {
                ExigibilidadeISS aux = todos[i];
                for (int j = 0; j < aux.padroes.length; ++j) {
                    Padrao auxPadrao = aux.padroes[j];
                    if (!auxPadrao.equals((Object)padrao)) continue;
                    lista.add(aux);
                    continue block0;
                }
            }
            return lista.toArray(new ExigibilidadeISS[0]);
        }

        public static ExigibilidadeISS get(String codigo) {
            ExigibilidadeISS[] todos = ExigibilidadeISS.values();
            for (int i = 0; i < todos.length; ++i) {
                ExigibilidadeISS aux = todos[i];
                if (!String.valueOf(aux.codigo).equalsIgnoreCase(codigo)) continue;
                return aux;
            }
            return null;
        }
    }

    private static enum ResponsavelRetencao implements DadosEspeciaisCombo
    {
        Tomador("Tomador", 1),
        Intermediario("Intermedi\u00e1rio", 2);

        int codigo = -1;
        String descricao = null;

        private ResponsavelRetencao(String descricao, int codigo) {
            this.descricao = descricao;
            this.codigo = codigo;
        }

        public String toString() {
            return this.descricao;
        }

        @Override
        public Object getCodigo() {
            return this.codigo;
        }

        public static ResponsavelRetencao get(String codigo) {
            ResponsavelRetencao[] todos = ResponsavelRetencao.values();
            for (int i = 0; i < todos.length; ++i) {
                ResponsavelRetencao aux = todos[i];
                if (!String.valueOf(aux.codigo).equalsIgnoreCase(codigo)) continue;
                return aux;
            }
            return null;
        }
    }

    private static enum TipoLancamento implements DadosEspeciaisCombo
    {
        DevidoMunicipioPrestador("Devido no Munic\u00edpio pelo Prestador", "N"),
        DevidoMunicipioTomador("Devido no Munic\u00edpio pelo Tomador", "T"),
        PrestadorSimplesNacionalMEI("Prestadores de Servi\u00e7o Cadastrados no Simples Nacional ou MEI com Imposto recolhido pelo DAS / ISS Fixo ou n\u00e3o Tributado", "P"),
        PrestadoresEstabelecidosMunicipioImpostoDevidoOutro("Prestadores Estabelecidos no Munic\u00edpio com o Imposto Devido em Outro Munic\u00edpio", "R");

        String codigo = null;
        String descricao = null;
        Padrao[] padroes = null;

        private TipoLancamento(String descricao, String codigo) {
            this.descricao = descricao;
            this.codigo = codigo;
            this.padroes = new Padrao[0];
        }

        public String toString() {
            return this.descricao;
        }

        @Override
        public Object getCodigo() {
            return this.codigo;
        }

        public static TipoLancamento get(String codigo) {
            TipoLancamento[] todos = TipoLancamento.values();
            for (int i = 0; i < todos.length; ++i) {
                TipoLancamento aux = todos[i];
                if (!String.valueOf(aux.codigo).equalsIgnoreCase(codigo)) continue;
                return aux;
            }
            return null;
        }
    }

    private static enum TipoRPS implements DadosEspeciaisCombo
    {
        RPS("RPS", 1),
        NotaFiscalConjugada("Nota Fiscal Conjugada (Mista)", 2),
        CupomTipoPadrao("Cupom Tipo Padr\u00e3o: 1", 3);

        int codigo = -1;
        String descricao = null;

        private TipoRPS(String descricao, int codigo) {
            this.descricao = descricao;
            this.codigo = codigo;
        }

        public String toString() {
            return this.descricao;
        }

        @Override
        public Object getCodigo() {
            return this.codigo;
        }

        public static TipoRPS get(String codigo) {
            TipoRPS[] todos = TipoRPS.values();
            for (int i = 0; i < todos.length; ++i) {
                TipoRPS aux = todos[i];
                if (!String.valueOf(aux.codigo).equalsIgnoreCase(codigo)) continue;
                return aux;
            }
            return null;
        }
    }

    public static enum NaturezaOperacao implements DadosEspeciaisCombo
    {
        TributacaoMunicipio("Tributa\u00e7\u00e3o no Munic\u00edpio", 1, Padrao.NATUREZA_OPERACAO_TRIBUTACAO_MUNICIPIO),
        TributacaoForaMunicipio("Tributa\u00e7\u00e3o Fora do Munic\u00edpio", 2, Padrao.NATUREZA_OPERACAO_TRIBUTACAO_FORA_MUNICIPIO),
        Isencao("Isen\u00e7\u00e3o", 3, Padrao.NATUREZA_OPERACAO_ISENCAO),
        Imune("Imune", 4, Padrao.NATUREZA_OPERACAO_IMUNE),
        ExigibilidadeSuspensaDecisaoJudicial("Exigibilidade Suspensa por Decis\u00e3o Judicial", 5, Padrao.NATUREZA_OPERACAO_EXIGIBILIDADE_SUSPENSA_DECISAO_JUDICIAL),
        ExigibilidadeSuspensaProcedimentoAdministrativo("Exigibilidade Suspensa por Procedimento Administrativo", 6, Padrao.NATUREZA_OPERACAO_EXIGIBILIDADE_PROCEDIMENTO_ADMINISTRATIVO),
        Exigivel("Exig\u00edvel", 7, Padrao.NATUREZA_OPERACAO_EXIGIVEL),
        NaoIncidencia("N\u00e3o Incid\u00eancia", 8, Padrao.NATUREZA_OPERACAO_NAO_INCIDENTE),
        Exportacao("Exporta\u00e7\u00e3o", 9, Padrao.NATUREZA_OPERACAO_EXPORTACAO),
        SemDeducao("Sem Dedu\u00e7\u00e3o", 107, Padrao.NATUREZA_OPERACAO_SEM_DEDUCAO),
        ComDeducao_Materiais("Com Dedu\u00e7\u00e3o/Materiais", 108, Padrao.NATUREZA_OPERACAO_COM_DEDUCAO_MATERIAL),
        Devolucao_SimplesRemessa("Devolu\u00e7\u00e3o/Simples Remessa", 109, Padrao.NATUREZA_OPERACAO_DEVOLUCAO_SIMPLES_REMESSA),
        Intermediacao("Intermedia\u00e7\u00e3o", 110, Padrao.NATUREZA_OPERACAO_INTERMEDIACAO),
        IssFixoSocProfissionais("Iss Fixo (Soc.Profissionais)", 121, Padrao.NATUREZA_OPERACAO_ISS_FIXO),
        IssRetidoTomadorIntermediario("ISS Retido pelo Tomador/Intermedi\u00e1rio", 201, Padrao.NATUREZA_OPERACAO_ISS_RETIDO_PELO_TOMADOR_INTERMEDIARIO),
        OperacaoImuneIsentaNaoTributada("Opera\u00e7\u00e3o Imune, Isenta ou N\u00e3o Tributada", 301, Padrao.NATUREZA_OPERACAO_IMUNE_ISENTA_OU_TRIBUTADA),
        MEISimplesNacional("MEI (Simples Nacional)", 541, Padrao.NATUREZA_OPERACAO_MEI_SIMPLES_NACIONAL),
        EscritorioContabil("Escrit\u00f3rio Cont\u00e1bil (Simples Nacional)", 551, Padrao.NATUREZA_OPERACAO_ESCRITORIO_COMTABIL_SIMPLES_NACIONAL),
        IssRetidoTomadorIntermediarioSimplesNacional("ISS Retido pelo Tomador/Intermedi\u00e1rio (Simples Nacional)", 601, Padrao.NATUREZA_OPERACAO_ISS_RETIDO_PELO_TOMADOR_SIMPLES_NACIONAL),
        OperacaoImuneIsentaNaoTributadaSimplesNacional("Opera\u00e7\u00e3o Imune, Isenta ou N\u00e3o Tributada (Simples Nacional)", 701, Padrao.NATUREZA_OPERACAO_IMUNE_ISENTA_NAO_TRIBUTADA_SIMPLES_NACIONAL),
        ImpostoDevidoMunicipioComObrigacaoRetencaoFontePrestadoNoMunicipio("Imposto Devido no Munic\u00edpio, com Obriga\u00e7\u00e3o de Reten\u00e7\u00e3o na Fonte (Servi\u00e7o Prestado no Munic\u00edpio)", 51, Padrao.NATUREZA_OPERACAO_IMPOSTO_DEVIDO_NO_MUNICIPIO_OBRIGACAO_RETENCAO_NO_MUNICIPIO),
        ImpostoDevidoMunicipioSemObrigacaoRetencaoFontePrestadoNoMunicipio("Imposto Devido no Munic\u00edpio, sem Obriga\u00e7\u00e3o de Reten\u00e7\u00e3o na Fonte (Servi\u00e7o Prestado no Munic\u00edpio)", 52, Padrao.NATUREZA_OPERACAO_IMPOSTO_DEVIDO_NO_MUNICIPIO_SEM_OBRIGACAO_RETENCAO_NO_MUNICIPIO),
        NaoTributavelPrestadoNoMunicipio("N\u00e3o Tribut\u00e1vel (Servi\u00e7o Prestado no Munic\u00edpio)", 58, Padrao.NATUREZA_OPERACAO_NAO_TRIBUTAVEL_NO_MUNICIPIO),
        ImpostoRecolhidoRegimeUnicoArrecadacaoSimplesNacionalPrestadoNoMunicipio("Imposto Recolhido pelo Regime \u00danico de Arrecada\u00e7\u00e3o Simples Nacional (Servi\u00e7o Prestado no Munic\u00edpio)", 59, Padrao.NATUREZA_OPERACAO_IMPOSTO_RECOLHIDO_PELO_REGIME_UNICO),
        ImpostoDevidoMunicipioComObrigacaoRetencaoFontePrestadoForaMunicipio("Imposto Devido no Munic\u00edpio, com Obriga\u00e7\u00e3o de Reten\u00e7\u00e3o na Fonte (Servi\u00e7o Prestado Fora do Munic\u00edpio)", 61, Padrao.NATUREZA_OPERACAO_IMPOSTO_DEVIDO_MUNICIPIO_COM_OBRIGACAO_RETENCAO_FORA_MUNICIPIO),
        ImpostoDevidoMunicipioSemObrigacaoRetencaoFontePrestadoForaMunicipio("Imposto Devido no Munic\u00edpio, sem Obriga\u00e7\u00e3o de Reten\u00e7\u00e3o na Fonte (Servi\u00e7o Prestado Fora do Munic\u00edpio)", 62, Padrao.NATUREZA_OPERACAO_IMPOSTO_DEVIDO_MUNICIPIO_SEM_OBRIGACAO_RETENCAO_FORA_MUNICIPIO),
        ImpostoDevidoForaMunicipioComObrigacaoRetencaoFontePrestadoForaMunicipio("Imposto Devido Fora do Munic\u00edpio, com Obriga\u00e7\u00e3o de Reten\u00e7\u00e3o na Fonte (Servi\u00e7o Prestado Fora do Munic\u00edpio)", 63, Padrao.NATUREZA_OPERACAO_IMPOSTO_DEVIDO_FORA_MUNICIPIO_COM_OBRIGACAO_RETENCAO_FORA_MUNICIPIO),
        ImpostoDevidoForaMunicipioSemObrigacaoRetencaoFontePrestadoForaMunicipio("Imposto Devido Fora do Munic\u00edpio, sem Obriga\u00e7\u00e3o de Reten\u00e7\u00e3o na Fonte (Servi\u00e7o Prestado Fora do Munic\u00edpio)", 64, Padrao.NATUREZA_OPERACAO_IMPOSTO_DEVIDO_FORA_MUNICIPIO_SEM_OBRIGACAO_RETENCAO_FORA_MUNICIPIO),
        NaoTributavelPrestadoForaMunicipio("N\u00e3o Tribut\u00e1vel (Servi\u00e7o Prestado Fora do Munic\u00edpio)", 68, Padrao.NATUREZA_OPERACAO_NAO_TRIBUTAVEL_FORA_MUNICIPIO),
        ImpostoRecolhidoRegimeUnicoArrecadacaoSimplesNacionalPrestadoForaMunicipio("Imposto Recolhido pelo Regime \u00danico de Arrecada\u00e7\u00e3o Simples Nacional (Servi\u00e7o Prestado Fora do Munic\u00edpio)", 69, Padrao.NATUREZA_OPERACAO_IMPOSTO_RECOLHIDO_REGIME_UNICO_ARRECADACAO_SIMPLES_NACIONAL_FORA),
        NaoTributavelPrestadoExterior("N\u00e3o Tribut\u00e1vel (Servi\u00e7o Prestado no Exterior)", 78, Padrao.NATUREZA_OPERACAO_NAO_TRIBUTAVEL_SERVICO_EXTERIOR),
        ImpostoRecolhidoRegimeUnicoArrecadacaoSimplesNacionalPrestadoNoExterior("Imposto Recolhido pelo Regime \u00danico de Arrecada\u00e7\u00e3o Simples Nacional (Servi\u00e7o Prestado no exterior)", 79, Padrao.NATUREZA_OPERACAO_IMPOSTO_RECOLHIDO_REGIME_UNICO_ARRECADACAO_SIMPLES_NACIONAL_EXTERIOR),
        ImpostoRecolhidoPorGuiaSemEscrituracao("Imposto recolhido por guia sem escritura\u00e7\u00e3o", 81, Padrao.NATUREZA_OPERACAO_IMPOSTO_RECOLHIDO_POR_GUIA_SEM_ESCRITURACAO);

        public int codigo = -1;
        String descricao = null;
        Padrao[] padroes = null;

        private NaturezaOperacao(String descricao, int codigo, Padrao ... padroes) {
            this.descricao = descricao;
            this.codigo = codigo;
            this.padroes = padroes;
        }

        public String toString() {
            return this.descricao;
        }

        public static NaturezaOperacao get(String codigo) {
            NaturezaOperacao[] todos = NaturezaOperacao.values();
            for (int i = 0; i < todos.length; ++i) {
                NaturezaOperacao aux = todos[i];
                if (!String.valueOf(aux.codigo).equalsIgnoreCase(codigo)) continue;
                return aux;
            }
            return null;
        }

        public static NaturezaOperacao[] getItens(Padrao padrao) {
            ArrayList<NaturezaOperacao> lista = new ArrayList<NaturezaOperacao>();
            NaturezaOperacao[] todos = NaturezaOperacao.values();
            block0: for (int i = 0; i < todos.length; ++i) {
                NaturezaOperacao aux = todos[i];
                for (int j = 0; j < aux.padroes.length; ++j) {
                    Padrao auxPadrao = aux.padroes[j];
                    if (!auxPadrao.equals((Object)padrao)) continue;
                    lista.add(aux);
                    continue block0;
                }
            }
            return lista.toArray(new NaturezaOperacao[0]);
        }

        @Override
        public Object getCodigo() {
            return this.codigo;
        }
    }

    public static enum RegimeEspecialTributacao implements DadosEspeciaisCombo
    {
        TributacaoNormal("Tributa\u00e7\u00e3o Normal", 0, Padrao.E_E_L),
        MicroempresaMunicipal("Microempresa Municipal", 1, Padrao.TODOS),
        Estimativa("Estimativa", 2, Padrao.TODOS),
        SociedadeProfissionais("Sociedade de Profissionais", 3, Padrao.TODOS),
        Cooperativa("Cooperativa", 4, Padrao.TODOS),
        MicroempresarioIndividual("Microempres\u00e1rio Individual", 5, Padrao.TODOS),
        MicroempresarioEmpresaPequenoPorte("Microempres\u00e1rio e Empresa de Pequeno Porte", 6, Padrao.TODOS),
        Autonomo("Aut\u00f4nomo", 7, Padrao.E_E_L);

        public int codigo = -1;
        String descricao = null;
        Padrao[] padroes = null;

        private RegimeEspecialTributacao(String descricao, int codigo, Padrao ... padroes) {
            this.descricao = descricao;
            this.codigo = codigo;
            this.padroes = padroes;
        }

        public String toString() {
            return this.descricao;
        }

        public static RegimeEspecialTributacao get(int codigo) {
            RegimeEspecialTributacao[] todos = RegimeEspecialTributacao.values();
            for (int i = 0; i < todos.length; ++i) {
                RegimeEspecialTributacao aux = todos[i];
                if (aux.codigo != codigo) continue;
                return aux;
            }
            return null;
        }

        public static RegimeEspecialTributacao[] getItens(Padrao padrao) {
            ArrayList<RegimeEspecialTributacao> lista = new ArrayList<RegimeEspecialTributacao>();
            RegimeEspecialTributacao[] todos = RegimeEspecialTributacao.values();
            block0: for (int i = 0; i < todos.length; ++i) {
                RegimeEspecialTributacao aux = todos[i];
                for (int j = 0; j < aux.padroes.length; ++j) {
                    Padrao auxPadrao = aux.padroes[j];
                    if (!auxPadrao.equals((Object)padrao)) continue;
                    lista.add(aux);
                    continue block0;
                }
            }
            return lista.toArray(new RegimeEspecialTributacao[0]);
        }

        @Override
        public Object getCodigo() {
            return this.codigo;
        }

        public static RegimeEspecialTributacao get(String codigo) {
            RegimeEspecialTributacao[] todos = RegimeEspecialTributacao.values();
            for (int i = 0; i < todos.length; ++i) {
                RegimeEspecialTributacao aux = todos[i];
                if (!String.valueOf(aux.codigo).equalsIgnoreCase(codigo)) continue;
                return aux;
            }
            return null;
        }
    }

    private static enum StatusRPS implements DadosEspeciaisCombo
    {
        Normal("Normal", 1),
        Cancelado("Cancelado", 2),
        Extraviada("Extraviada", 3);

        int codigo = -1;
        String descricao = null;

        private StatusRPS(String descricao, int codigo) {
            this.descricao = descricao;
            this.codigo = codigo;
        }

        public String toString() {
            return this.descricao;
        }

        @Override
        public Object getCodigo() {
            return this.codigo;
        }

        public static StatusRPS get(String codigo) {
            StatusRPS[] todos = StatusRPS.values();
            for (int i = 0; i < todos.length; ++i) {
                StatusRPS aux = todos[i];
                if (!String.valueOf(aux.codigo).equalsIgnoreCase(codigo)) continue;
                return aux;
            }
            return null;
        }
    }

    public static enum Tributacao implements DadosEspeciaisCombo
    {
        IsentaISS("Isenta de ISS", "C", Padrao.TRIBUTACAO_ISENTA_ISS),
        NaoIncidenciaMunicipio("N\u00e3o Incid\u00eancia no Munic\u00edpio", "E", Padrao.TRIBUTACAO_NAO_INCIDENCIA_MUNICIPIO),
        Imune("Imune", "F", Padrao.TRIBUTACAO_IMUNE),
        ExigibilidadeSuspDecJProcA("Exigibilidade Suspensa por Decis\u00e3o Judicial/ Procedimento Administrativo", "K", Padrao.TRIBUTACAO_EXIGIBILIDADE_SUSP_DEC_J_PROC_A),
        NaoTributavel("N\u00e3o Tribut\u00e1vel", "N", Padrao.TRIBUTACAO_NAO_TRIBUTAVEL),
        Tributavel("Tribut\u00e1vel", "T", Padrao.TRIBUTACAO_TRIBUTAVEL),
        TributavelFixo("Tribut\u00e1vel Fixo", "G", Padrao.TRIBUTACAO_TRIBUTAVEL_FIXO),
        TributavelSN("Tribut\u00e1vel S.N.", "H", Padrao.TRIBUTACAO_TTRIBUTAVEL_SN),
        MicroempreendedorIndividual("Microempreendedor Individual (MEI)", "M", Padrao.TRIBUTACAO_MICROEMPREENDEDOR_INDIVIDUAL),
        Cancelada("Cancelada", "A", Padrao.TRIBUTACAO_CANCELADA),
        Retirada("Retirada", "R", Padrao.TRIBUTACAO_RETIRADA),
        TributacaoMunicipio("Tributa\u00e7\u00e3o no Munic\u00edpio", "Z1", Padrao.TRIBUTACAO_MUNICIPIO),
        TributacaoForaMunicipio("Tributa\u00e7\u00e3o Fora do Munic\u00edpio", "Z2", Padrao.TRIBUTACAO_FORA_MUNICIPIO),
        ISSSuspensoDecisaoJudicial("ISS Suspenso por Decis\u00e3o Judicial", "Z3", Padrao.TRIBUTACAO_ISS_SUSPENSO_DECISAO_JUDICIAL),
        Estimado("ES - Estimado", "ES", Padrao.TRIBUTACAO_ESTIMADO),
        IsencaoParcial("Isen\u00e7\u00e3o Parcial", "IP", Padrao.TRIBUTACAO_ISENCAO_PARCIAL),
        SubstituicaoTributaria("Substitui\u00e7\u00e3o Tribut\u00e1ria", "ST", Padrao.TRIBUTACAO_SUBSTITUICAO_TRIBUTARIA),
        DevidoMunicipioPrestador("Devido no Munic\u00edpio pelo Prestador", "N", new Padrao[0]),
        DevidoMunicipioTomador("Devido no Munic\u00edpio pelo Tomador", "T", new Padrao[0]),
        PrestadorSimplesNacionalMEI("Prestadores de Servi\u00e7o Cadastrados no Simples Nacional ou MEI com Imposto recolhido pelo DAS / ISS Fixo ou n\u00e3o Tributado", "P", new Padrao[0]),
        PrestadoresEstabelecidosMunicipioImpostoDevidoOutro("Prestadores Estabelecidos no Munic\u00edpio com o Imposto Devido em Outro Munic\u00edpio", "R", new Padrao[0]);

        String descricao = null;
        public String codigo = null;
        Padrao[] padroes = null;

        public static Tributacao[] getItens(Padrao padrao) {
            ArrayList<Tributacao> lista = new ArrayList<Tributacao>();
            Tributacao[] todos = Tributacao.values();
            for (int i = 0; i < todos.length; ++i) {
                Tributacao aux = todos[i];
                for (Padrao padraoAux : aux.padroes) {
                    if (!padraoAux.equals((Object)padrao)) continue;
                    lista.add(aux);
                }
            }
            return lista.toArray(new Tributacao[0]);
        }

        private Tributacao(String descricao, String codigo, Padrao ... padrao) {
            this.codigo = codigo;
            this.descricao = descricao;
            this.padroes = padrao;
        }

        public String toString() {
            return this.descricao;
        }

        public static Tributacao get(String codigo) {
            Tributacao[] todos = Tributacao.values();
            for (int i = 0; i < todos.length; ++i) {
                Tributacao aux = todos[i];
                if (!aux.codigo.equalsIgnoreCase(codigo)) continue;
                return aux;
            }
            return null;
        }

        @Override
        public String getCodigo() {
            return this.codigo;
        }
    }

    public static enum Tributavel implements DadosEspeciaisCombo
    {
        ItemTributavel("Item Tribut\u00e1vel", "S", Padrao.DSF),
        NaoTributavel("N\u00e3o Tribut\u00e1vel", "N", Padrao.DSF),
        TributadaIntegralmente("Tributada Integralmente", "Z1", Padrao.IPM),
        TributadaIntegralmenteISSRF("Tributada Integralmente com ISSRF", "Z2", Padrao.IPM),
        TributadaIntegralmenteSujSubsTrib("Tributada Integralmente e Sujeita \u00e0 Substitui\u00e7\u00e3o Tribut\u00e1ria", "Z3", Padrao.IPM),
        TributadaReducaoBaseCalculo("Tributada com Redu\u00e7\u00e3o da Base de C\u00e1lculo", "Z4", Padrao.IPM),
        TributadaReducaoBaseCalculoISSRF("Tributada com Redu\u00e7\u00e3o da Base de C\u00e1lculo com ISSRF", "Z5", Padrao.IPM),
        TributadaReducaoBaseCalculoSujSubsTrib("Tributada com Redu\u00e7\u00e3o da Base de C\u00e1lculo e Sujeita \u00e0 Substitui\u00e7\u00e3o Tribut\u00e1ria", "Z6", Padrao.IPM),
        Isenta("Isenta", "Z7", Padrao.IPM),
        Imune("Imune", "Z8", Padrao.IPM),
        NaoTributadaISSRegimeFixo("N\u00e3o Tributada - ISS Regime Fixo", "Z9", Padrao.IPM),
        NaoTributadaISSRegimeEstimativa("N\u00e3o Tributada - ISS Regime Estimativa", "Z10", Padrao.IPM),
        NaoTributadaISSConstrucaoCivil("N\u00e3o Tributada - ISS Constru\u00e7\u00e3o Civil", "Z11", Padrao.IPM),
        NaoTributadaAltoCooperado("N\u00e3o Tributada - Alto Cooperado", "Z12", Padrao.IPM);

        String descricao = null;
        public String codigo = null;
        Padrao[] padroes = null;

        private Tributavel(String descricao, String codigo, Padrao ... padrao) {
            this.descricao = descricao;
            this.codigo = codigo;
            this.padroes = padrao;
        }

        public String toString() {
            return this.descricao;
        }

        public static Tributavel[] getItens(Padrao padrao) {
            ArrayList<Tributavel> lista = new ArrayList<Tributavel>();
            Tributavel[] todos = Tributavel.values();
            for (int i = 0; i < todos.length; ++i) {
                Tributavel aux = todos[i];
                for (Padrao padraoAux : aux.padroes) {
                    if (!padraoAux.equals((Object)padrao)) continue;
                    lista.add(aux);
                }
            }
            return lista.toArray(new Tributavel[0]);
        }

        public static Tributavel get(String codigo) {
            Tributavel[] todos = Tributavel.values();
            for (int i = 0; i < todos.length; ++i) {
                Tributavel aux = todos[i];
                if (!aux.codigo.equalsIgnoreCase(codigo)) continue;
                return aux;
            }
            return null;
        }

        @Override
        public String getCodigo() {
            return this.codigo;
        }
    }
}

