/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento.integracao.enotas.validador;

import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.EnderecoEnotasDto;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.ServicoEnotasDto;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.validador.CampoEnotas;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.validador.ErroCampoEnotas;
import jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed.TecnospeedUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.BairroBean;
import jalis.model.bean.cadastro.CidadeBean;
import jalis.model.bean.cadastro.FilialBean;
import jalis.model.bean.cadastro.convenio.ConvenioBean;
import jalis.model.bean.cadastro.financeiro.ServicoBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.bean.recepcao.PacienteBean;
import jalis.model.vo.cadastro.financeiro.ServicoVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.PacienteService;
import jalis.service.cadastro.financeiro.ServicoService;
import jalis.util.Funcoes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ValidacaoCampoObrigatorio {
    private NotaFiscalBean notaBean;
    private ServicoBean servico = null;
    private PacienteBean paciente = null;
    private ConvenioBean convenio = null;
    private FilialBean filialBean = null;
    private boolean isPessoaFisica;
    private ArrayList<ErroCampoEnotas> camposObrigatoriosNaoPreenchidos = new ArrayList();
    private static final String MENSAGEM_VALOR_INVALIDO = "Valor inv\u00e1lido para o campo \"%s\"";

    public ArrayList<ErroCampoEnotas> validar(NotaFiscalBean notaBean) {
        this.preencherBean(notaBean);
        this.camposObrigatoriosNaoPreenchidos.clear();
        this.validarCamposObrigatoriosEndereco();
        this.validarCamposObrigatoriosServico();
        return this.camposObrigatoriosNaoPreenchidos;
    }

    private void preencherBean(NotaFiscalBean notaBean) {
        this.notaBean = notaBean;
        this.isPessoaFisica = notaBean.getConvenio() == null ? true : notaBean.getConvenio().getTipoPessoa().equalsIgnoreCase("F");
        try {
            if (this.isPessoaFisica) {
                this.paciente = (PacienteBean)new PacienteService().get(notaBean.getPaciente().getFilial().getCodigo().toString(), notaBean.getPaciente().getCodigo().toString());
            } else {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("fil_codigo", notaBean.getFilial().getCodigo());
                map.put("con_codigo", notaBean.getConvenio().getCodigo());
                this.convenio = (ConvenioBean)new ConvenioService().getBean(map);
            }
            if (notaBean.getServico() != null && notaBean.getServico().getServico() != null) {
                ServicoVO aux = notaBean.getServico().getServico();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("fil_codigo", aux.getFilial().getCodigo());
                map.put("svc_codigo", aux.getCodigo());
                this.servico = (ServicoBean)new ServicoService().getBean(map);
            }
            this.filialBean = (FilialBean)new FilialService().get(String.valueOf(notaBean.getFilial().getCodigo()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void validarCamposObrigatoriosEndereco() {
        List<String> camposObrigatoriosEndereco = EnderecoEnotasDto.Builder.getAtributosObrigatorios();
        ArrayList<String> camposIterados = new ArrayList<String>();
        AbstractThreadBean bean = this.isPessoaFisica ? this.paciente : this.convenio;
        for (String campo : camposObrigatoriosEndereco) {
            if (campo.equals("uf")) {
                camposIterados.add("uf");
                continue;
            }
            if (campo.equals("cidade")) {
                camposIterados.add("cidade");
                if (this.isPessoaFisica && this.paciente.getCidade() == null || !this.isPessoaFisica && this.convenio.getCidade() == null) {
                    CidadeBean beanCidade = new CidadeBean();
                    CampoEnotas cidade = new CampoEnotas.Builder().tipoDado(TecnospeedUtil.TipoDado.INTEIRO).nomeAmigavel("cidade do tomador").bean(beanCidade, "codigoIbge").beanPai(bean).build();
                    this.camposObrigatoriosNaoPreenchidos.add(this.getErrosCampos(cidade));
                }
            }
            if (campo.equals("logradouro")) {
                camposIterados.add("logradouro");
                if (this.isPessoaFisica && Funcoes.textoVazio(this.paciente.getEndereco()) || !this.isPessoaFisica && Funcoes.textoVazio(this.convenio.getEndereco())) {
                    CampoEnotas logradouro = new CampoEnotas.Builder().tipoDado(TecnospeedUtil.TipoDado.TEXTO).nomeAmigavel("endere\u00e7o do tomador").bean(bean, "endereco").build();
                    this.camposObrigatoriosNaoPreenchidos.add(this.getErrosCampos(logradouro));
                }
            }
            if (campo.equals("numero")) {
                camposIterados.add("numero");
                if (this.isPessoaFisica && Funcoes.textoVazio(this.paciente.getNumeroEndereco()) || !this.isPessoaFisica && Funcoes.textoVazio(this.convenio.getNumeroEndereco())) {
                    CampoEnotas numero = new CampoEnotas.Builder().tipoDado(TecnospeedUtil.TipoDado.TEXTO).nomeAmigavel("n\u00famero do tomador").bean(bean, "numeroEndereco").build();
                    this.camposObrigatoriosNaoPreenchidos.add(this.getErrosCampos(numero));
                }
            }
            if (campo.equals("bairro")) {
                camposIterados.add("bairro");
                if (this.isPessoaFisica && this.paciente.getBairro() == null || !this.isPessoaFisica && this.convenio.getBairro() == null) {
                    BairroBean beanBairro = new BairroBean();
                    CampoEnotas bairro = new CampoEnotas.Builder().tipoDado(TecnospeedUtil.TipoDado.TEXTO).nomeAmigavel("bairro do tomador").bean(beanBairro, "descricao").beanPai(bean).build();
                    this.camposObrigatoriosNaoPreenchidos.add(this.getErrosCampos(bairro));
                }
            }
            if (campo.equals("cep")) {
                camposIterados.add("cep");
                if (this.isPessoaFisica && Funcoes.textoVazio(this.paciente.getCep()) || !this.isPessoaFisica && Funcoes.textoVazio(this.convenio.getCep())) {
                    CampoEnotas cep = new CampoEnotas.Builder().tipoDado(TecnospeedUtil.TipoDado.CEP).nomeAmigavel("CEP do tomador").bean(bean, "cep").build();
                    this.camposObrigatoriosNaoPreenchidos.add(this.getErrosCampos(cep));
                }
            }
            if (camposIterados.contains(campo)) continue;
            CampoEnotas campoObrigatorio = new CampoEnotas.Builder().tipoDado(TecnospeedUtil.TipoDado.INDEFINIDO).nomeAmigavel(campo).build();
            this.camposObrigatoriosNaoPreenchidos.add(this.getErrosCampos(campoObrigatorio));
        }
    }

    private void validarCamposObrigatoriosServico() {
        List<String> camposObrigatoriosServico = ServicoEnotasDto.Builder.getAtributosObrigatorios();
        ArrayList<String> camposIterados = new ArrayList<String>();
        for (String campo : camposObrigatoriosServico) {
            if (campo.equals("descricao")) {
                camposIterados.add("descricao");
                if (Funcoes.textoVazio(this.servico.getDescricao())) {
                    CampoEnotas descricaoServico = new CampoEnotas.Builder().tipoDado(TecnospeedUtil.TipoDado.TEXTO).nomeAmigavel("discrimina\u00e7\u00e3o do servi\u00e7o").bean(this.servico, "descricao").build();
                    this.camposObrigatoriosNaoPreenchidos.add(this.getErrosCampos(descricaoServico));
                }
            }
            if (campo.equals("issRetidoFonte")) {
                camposIterados.add("issRetidoFonte");
                continue;
            }
            if (campo.equals("codigoServicoMunicipio")) {
                camposIterados.add("codigoServicoMunicipio");
                if (Funcoes.textoVazio(this.servico.getCodigoTributacaoMunicipio())) {
                    CampoEnotas codTributacaoMunicipio = new CampoEnotas.Builder().tipoDado(TecnospeedUtil.TipoDado.TEXTO).nomeAmigavel("c\u00f3digo de tributa\u00e7\u00e3o do munic\u00edpio").bean(this.servico, "codigoTributacaoMunicipio").build();
                    this.camposObrigatoriosNaoPreenchidos.add(this.getErrosCampos(codTributacaoMunicipio));
                }
            }
            if (camposIterados.contains(campo)) continue;
            CampoEnotas campoObrigatorio = new CampoEnotas.Builder().tipoDado(TecnospeedUtil.TipoDado.INDEFINIDO).nomeAmigavel(campo).build();
            this.camposObrigatoriosNaoPreenchidos.add(this.getErrosCampos(campoObrigatorio));
        }
    }

    private String getMensagemErro(String nomeAmigavel) {
        return String.format(MENSAGEM_VALOR_INVALIDO, nomeAmigavel);
    }

    private ErroCampoEnotas getErrosCampos(CampoEnotas campoEnotas) {
        return new ErroCampoEnotas(this.getMensagemErro(campoEnotas.getNomeAmigavel()), campoEnotas);
    }
}

