/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento.integracao.enotas.validador;

import jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed.TecnospeedUtil;
import jalis.model.AbstractThreadBean;
import java.lang.reflect.Field;

public class CampoEnotas {
    private final String nomeAmigavel;
    private final TecnospeedUtil.TipoDado tipo;
    private final Object valor;
    private final Field field;
    private final AbstractThreadBean bean;
    private final AbstractThreadBean beanPai;
    private final Object[] listaValores;

    private CampoEnotas(Builder builder) {
        this.nomeAmigavel = builder.nomeAmigavel;
        this.tipo = builder.tipo;
        this.valor = builder.valor;
        this.field = builder.field;
        this.bean = builder.bean;
        this.beanPai = builder.beanPai;
        this.listaValores = builder.listaValores;
    }

    public String getNomeAmigavel() {
        return this.nomeAmigavel;
    }

    public TecnospeedUtil.TipoDado getTipo() {
        return this.tipo;
    }

    public Object getValor() {
        return this.valor;
    }

    public Field getField() {
        return this.field;
    }

    public AbstractThreadBean getBean() {
        return this.bean;
    }

    public AbstractThreadBean getBeanPai() {
        return this.beanPai;
    }

    public Object[] getListaValores() {
        return this.listaValores;
    }

    public static class Builder {
        private String nomeAmigavel;
        private TecnospeedUtil.TipoDado tipo;
        private Object valor;
        private Field field;
        private AbstractThreadBean bean;
        private AbstractThreadBean beanPai;
        private Object[] listaValores;

        public Builder nomeAmigavel(String nomeAmigavel) {
            this.nomeAmigavel = nomeAmigavel;
            return this;
        }

        public Builder tipoDado(TecnospeedUtil.TipoDado tipo) {
            this.tipo = tipo;
            return this;
        }

        public Builder valor(Object valor) {
            this.valor = valor;
            return this;
        }

        public Builder bean(AbstractThreadBean bean, String nomeAtributoBean) {
            this.field = this.getField(bean.getClass(), nomeAtributoBean);
            this.bean = bean;
            return this;
        }

        public Builder beanPai(AbstractThreadBean beanPai) {
            this.beanPai = beanPai;
            return this;
        }

        public Builder beanPai(Object[] listaValores) {
            this.listaValores = listaValores;
            return this;
        }

        public CampoEnotas build() {
            return new CampoEnotas(this);
        }

        private Field getField(Class classe, String nomeAtributoBean) {
            if (classe != null) {
                try {
                    return classe.getDeclaredField(nomeAtributoBean);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

