/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto;

public enum StatusNota {
    AGUARDANDO_AUTORIZACAO("AguardandoAutorizacao", "Status inicial da nota fiscal."),
    SOLICITANDO_AUTORIZACAO("SolicitandoAutorizacao", "Nota fiscal sendo inclu\u00edda na fila de transmiss\u00e3o."),
    AUTORIZACAO_SOLICITADA("AutorizacaoSolicitada", "Nota fiscal inclu\u00edda na fila de transmiss\u00e3o."),
    PROCESSO_AUTORIZACAO("EmProcessoDeAutorizacao", "Sua nota fiscal foi transmitida e o Gateway est\u00e1 aguardando um retorno."),
    AUTORIZADA_AGUARDANDO_GERACAO_PDF("AutorizadaAguardandoGeracaoPDF", "Sua nota foi autorizada e est\u00e1 na fila de gera\u00e7\u00e3o de PDF."),
    AUTORIZADA("Autorizada", "Nota fiscal autorizada e com PDF pronto para download."),
    SOLICITANDO_CANCELAMENTO("SolicitandoCancelamento", "Nota fiscal sendo inclu\u00edda na fila de cancelamento"),
    CANCELAMENTO_SOLICITADO("CancelamentoSolicitado", "Nota fiscal inclu\u00edda na fila de cancelamento"),
    PROCESSO_CANCELAMENTO("EmProcessoDeCancelamento", "Cancelamento solicitado e o Gateway est\u00e1 aguardando um retorno"),
    CANCELADA_AGUARDANDO_ATUALIZACAOPDF("CanceladaAguardandoAtualizacaoPDF", "Nota fiscal cancelada pela prefeitura e est\u00e1 na fila para atualiza\u00e7\u00e3o de seu PDF"),
    CANCELADA("Cancelada", "Nota fiscal cancelada e com PDF atualizado pronto para download"),
    CANCELAMENTO_NEGADO("CancelamentoNegado", "O cancelamento da nota fiscal foi rejeitado"),
    NEGADA("Negada", "A nota fiscal foi rejeitada pelo \u00f3rg\u00e3o.");

    private String descricao;
    private String legenda;

    private StatusNota(String descricao, String legenda) {
        this.descricao = descricao;
        this.legenda = legenda;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public String getLegenda() {
        return this.legenda;
    }

    public static String getStatus(String valorStatus) {
        for (StatusNota status : StatusNota.values()) {
            if (!status.getDescricao().equalsIgnoreCase(valorStatus)) continue;
            return status.getDescricao();
        }
        return valorStatus;
    }

    public static String getStatusComLegenda(String valorStatus) {
        for (StatusNota status : StatusNota.values()) {
            if (!status.getDescricao().equalsIgnoreCase(valorStatus)) continue;
            return status.getDescricao() + " - " + status.getLegenda();
        }
        return valorStatus;
    }

    public static StatusNota fromString(String status) {
        for (StatusNota s : StatusNota.values()) {
            if (!s.getDescricao().equals(status)) continue;
            return s;
        }
        return null;
    }

    public boolean processamentoFinalizado(boolean cancelamento) {
        if (cancelamento) {
            return this.equals((Object)CANCELADA) || this.equals((Object)CANCELAMENTO_NEGADO) || this.equals((Object)CANCELADA_AGUARDANDO_ATUALIZACAOPDF);
        }
        return this.equals((Object)AUTORIZADA_AGUARDANDO_GERACAO_PDF) || this.equals((Object)AUTORIZADA) || this.equals((Object)NEGADA);
    }

    public boolean processandoCancelamento() {
        return this.equals((Object)CANCELAMENTO_SOLICITADO) || this.equals((Object)PROCESSO_CANCELAMENTO) || this.equals((Object)SOLICITANDO_CANCELAMENTO);
    }

    public boolean cancelado() {
        return this.equals((Object)CANCELADA) || this.equals((Object)CANCELADA_AGUARDANDO_ATUALIZACAOPDF);
    }
}

