/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto;

import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.DadosRespostaEnotas;
import org.json.JSONException;
import org.json.JSONObject;

public class RespostaEnotas {
    private String message;
    private int httpStatusCode = 0;
    private DadosRespostaEnotas data;

    private RespostaEnotas() {
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public DadosRespostaEnotas getData() {
        return this.data;
    }

    public void setData(DadosRespostaEnotas data) {
        this.data = data;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public void setHttpStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public static RespostaEnotas getInstanciaDeConsulta() {
        RespostaEnotas resposta = new RespostaEnotas();
        DadosRespostaEnotas dadosResposta = new DadosRespostaEnotas();
        resposta.setData(dadosResposta);
        return resposta;
    }

    public static RespostaEnotas converterJSONParaRespostaEnotas(JSONObject jsonObject, int httpStatusCode) {
        RespostaEnotas resposta = new RespostaEnotas();
        try {
            resposta.setMessage(jsonObject.getString("message"));
            resposta.setHttpStatusCode(httpStatusCode);
            if (httpStatusCode == 200) {
                DadosRespostaEnotas dados = new DadosRespostaEnotas();
                JSONObject data = jsonObject.getJSONObject("data");
                for (String c : JSONObject.getNames((JSONObject)data)) {
                    if (c.equalsIgnoreCase("ambienteEmissao")) {
                        dados.setAmbienteEmissao(data.isNull("ambienteEmissao") ? "" : data.getString("ambienteEmissao"));
                        continue;
                    }
                    if (c.equalsIgnoreCase("codigoVerificacao")) {
                        dados.setCodigoVerificacao(data.isNull("codigoVerificacao") ? "" : data.getString("codigoVerificacao"));
                        continue;
                    }
                    if (c.equalsIgnoreCase("dataAutorizacao")) {
                        dados.setDataAutorizacao(data.isNull("dataAutorizacao") ? "" : data.getString("dataAutorizacao"));
                        continue;
                    }
                    if (c.equalsIgnoreCase("enviadaPorEmail")) {
                        dados.setEnviadaPorEmail(data.getBoolean("enviadaPorEmail"));
                        continue;
                    }
                    if (c.equalsIgnoreCase("id")) {
                        dados.setIdentificador(data.isNull("id") ? "" : data.getString("id"));
                        continue;
                    }
                    if (c.equalsIgnoreCase("idExterno")) {
                        dados.setIdExterno(data.isNull("idExterno") ? "" : data.getString("idExterno"));
                        continue;
                    }
                    if (c.equalsIgnoreCase("motivoStatus")) {
                        dados.setMotivoStatus(data.isNull("motivoStatus") ? "" : data.getString("motivoStatus"));
                        continue;
                    }
                    if (c.equalsIgnoreCase("numero")) {
                        dados.setNumero(data.isNull("numero") ? "" : data.getString("numero"));
                        continue;
                    }
                    if (c.equalsIgnoreCase("numeroRps")) {
                        dados.setNumeroRps(data.isNull("numeroRps") ? 0L : data.getLong("numeroRps"));
                        continue;
                    }
                    if (c.equalsIgnoreCase("serieRps")) {
                        dados.setSerieRps(data.isNull("serieRps") ? "" : data.getString("serieRps"));
                        continue;
                    }
                    if (c.equalsIgnoreCase("status")) {
                        dados.setStatus(data.isNull("status") ? "" : data.getString("status"));
                        continue;
                    }
                    if (c.equalsIgnoreCase("linkDownloadPDF")) {
                        dados.setLinkDownloadPDF(data.isNull("linkDownloadPDF") ? "" : data.getString("linkDownloadPDF"));
                        continue;
                    }
                    if (!c.equalsIgnoreCase("linkDownloadXML")) continue;
                    dados.setLinkDownloadXML(data.isNull("linkDownloadXML") ? "" : data.getString("linkDownloadXML"));
                }
                resposta.setData(dados);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return resposta;
    }
}

