/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.ClienteEnotasDto;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.EnderecoEnotasDto;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.ServicoEnotasDto;

public class NotaServicoEnotasDto {
    private final String empresaId;
    private final String ambienteEmissao;
    private final Long numeroRps;
    private final String serieRps;
    private final String dataCompetencia;
    private final Boolean enviarPorEmail;
    private final ClienteEnotasDto cliente;
    private final EnderecoEnotasDto endereco;
    private final ServicoEnotasDto servico;
    private final String naturezaOperacao;
    private final Double deducoes;
    private final Double descontos;
    private final Double valorTotal;
    private final String observacoes;

    private NotaServicoEnotasDto(Builder builder) {
        this.empresaId = builder.empresaId;
        this.ambienteEmissao = builder.ambienteEmissao;
        this.numeroRps = builder.numeroRps;
        this.serieRps = builder.serieRps;
        this.dataCompetencia = builder.dataCompetencia;
        this.enviarPorEmail = builder.enviarPorEmail;
        this.endereco = builder.endereco;
        this.cliente = builder.cliente;
        this.servico = builder.servico;
        this.naturezaOperacao = builder.naturezaOperacao;
        this.deducoes = builder.deducoes;
        this.descontos = builder.descontos;
        this.valorTotal = builder.valorTotal;
        this.observacoes = builder.observacoes;
    }

    @JsonProperty(value="empresaId")
    public String getEmpresaId() {
        return this.empresaId;
    }

    @JsonProperty(value="ambienteEmissao")
    public String getAmbienteEmissao() {
        return this.ambienteEmissao;
    }

    @JsonProperty(value="numeroRps")
    public Long getNumeroRps() {
        return this.numeroRps;
    }

    @JsonProperty(value="serieRps")
    public String getSerieRps() {
        return this.serieRps;
    }

    @JsonProperty(value="dataCompetencia")
    public String getDataCompetencia() {
        return this.dataCompetencia;
    }

    @JsonProperty(value="enviarPorEmail")
    public Boolean getEnviarPorEmail() {
        return this.enviarPorEmail;
    }

    @JsonProperty(value="cliente")
    public ClienteEnotasDto getCliente() {
        return this.cliente;
    }

    @JsonProperty(value="endereco")
    public EnderecoEnotasDto getEndereco() {
        return this.endereco;
    }

    @JsonProperty(value="servico")
    public ServicoEnotasDto getServico() {
        return this.servico;
    }

    @JsonProperty(value="naturezaOperacao")
    public String getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    @JsonProperty(value="deducoes")
    public Double getDeducoes() {
        return this.deducoes;
    }

    @JsonProperty(value="descontos")
    public Double getDescontos() {
        return this.descontos;
    }

    @JsonProperty(value="valorTotal")
    public Double getValorTotal() {
        return this.valorTotal;
    }

    @JsonProperty(value="observacoes")
    public String getObservacoes() {
        return this.observacoes;
    }

    public String toJson() {
        String json = "";
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
            json = mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return json;
    }

    public static class Builder {
        private final String empresaId;
        private final String ambienteEmissao;
        private Long numeroRps;
        private final String serieRps;
        private String dataCompetencia;
        private final Boolean enviarPorEmail;
        private final ClienteEnotasDto cliente;
        private final EnderecoEnotasDto endereco;
        private final ServicoEnotasDto servico;
        private String naturezaOperacao;
        private Double deducoes;
        private Double descontos;
        private final Double valorTotal;
        private String observacoes;

        public Builder(String empresaId, String ambienteEmissao, String serieRps, Boolean enviarPorEmail, ClienteEnotasDto cliente, EnderecoEnotasDto endereco, ServicoEnotasDto servico, Double valorTotal) {
            this.empresaId = empresaId;
            this.ambienteEmissao = ambienteEmissao;
            this.serieRps = serieRps;
            this.enviarPorEmail = enviarPorEmail;
            this.cliente = cliente;
            this.endereco = endereco;
            this.servico = servico;
            this.valorTotal = valorTotal;
        }

        public Builder numeroRps(Long numeroRps) {
            this.numeroRps = numeroRps;
            return this;
        }

        public Builder dataCompetencia(String dataCompetencia) {
            this.dataCompetencia = dataCompetencia;
            return this;
        }

        public Builder naturezaOperacao(String naturezaOperacao) {
            this.naturezaOperacao = naturezaOperacao;
            return this;
        }

        public Builder deducoes(Double deducoes) {
            this.deducoes = deducoes;
            return this;
        }

        public Builder descontos(Double descontos) {
            this.descontos = descontos;
            return this;
        }

        public Builder observacoes(String observacoes) {
            this.observacoes = observacoes;
            return this;
        }

        public NotaServicoEnotasDto build() {
            return new NotaServicoEnotasDto(this);
        }
    }
}

