/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class EnderecoEnotasDto {
    private final String uf;
    private final String cidade;
    private final String logradouro;
    private final String numero;
    private final String complemento;
    private final String bairro;
    private final String cep;

    private EnderecoEnotasDto(Builder builder) {
        this.uf = builder.uf;
        this.cidade = builder.cidade;
        this.logradouro = builder.logradouro;
        this.numero = builder.numero;
        this.complemento = builder.complemento;
        this.bairro = builder.bairro;
        this.cep = builder.cep;
    }

    @JsonProperty(value="uf")
    public String getUf() {
        return this.uf;
    }

    @JsonProperty(value="cidade")
    public String getCidade() {
        return this.cidade;
    }

    @JsonProperty(value="logradouro")
    public String getLogradouro() {
        return this.logradouro;
    }

    @JsonProperty(value="numero")
    public String getNumero() {
        return this.numero;
    }

    @JsonProperty(value="complemento")
    public String getComplemento() {
        return this.complemento;
    }

    @JsonProperty(value="bairro")
    public String getBairro() {
        return this.bairro;
    }

    @JsonProperty(value="cep")
    public String getCep() {
        return this.cep;
    }

    public static class Builder {
        private final String uf;
        private final String cidade;
        private final String logradouro;
        private final String numero;
        private String complemento;
        private final String bairro;
        private final String cep;

        public Builder(String uf, String cidade, String logradouro, String numero, String bairro, String cep) {
            this.uf = uf;
            this.cidade = cidade;
            this.logradouro = logradouro;
            this.numero = numero;
            this.bairro = bairro;
            this.cep = cep;
        }

        public Builder complemento(String complemento) {
            this.complemento = complemento;
            return this;
        }

        public EnderecoEnotasDto build() {
            return new EnderecoEnotasDto(this);
        }

        public static List<String> getAtributosObrigatorios() {
            Field[] atributos;
            ArrayList<String> atributosObrigatorios = new ArrayList<String>();
            for (Field atributo : atributos = Builder.class.getDeclaredFields()) {
                int modificadores = atributo.getModifiers();
                if (!Modifier.toString(modificadores).contains("final") || !atributo.getType().equals(String.class) && !atributo.getType().equals(Integer.class) && !atributo.getType().equals(Double.class) && !atributo.getType().equals(Boolean.class)) continue;
                atributosObrigatorios.add(atributo.getName());
            }
            return atributosObrigatorios;
        }
    }
}

