/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class ClienteEnotasDto {
    private final String tipoPessoa;
    private final String nome;
    private final String email;
    private final String cpfCnpj;
    private final String inscricaoMunicipal;
    private final String inscricaoEstadual;
    private final String telefone;

    private ClienteEnotasDto(Builder builder) {
        this.tipoPessoa = builder.tipoPessoa;
        this.nome = builder.nome;
        this.email = builder.email;
        this.cpfCnpj = builder.cpfCnpj;
        this.inscricaoMunicipal = builder.inscricaoMunicipal;
        this.inscricaoEstadual = builder.inscricaoEstadual;
        this.telefone = builder.telefone;
    }

    @JsonProperty(value="tipoPessoa")
    public String getTipoPessoa() {
        return this.tipoPessoa;
    }

    @JsonProperty(value="nome")
    public String getNome() {
        return this.nome;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="cpfCnpj")
    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    @JsonProperty(value="inscricaoMunicipal")
    public String getInscricaoMunicipal() {
        return this.inscricaoMunicipal;
    }

    @JsonProperty(value="inscricaoEstadual")
    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    @JsonProperty(value="telefone")
    public String getTelefone() {
        return this.telefone;
    }

    public static class Builder {
        private final String tipoPessoa;
        private String nome;
        private String email;
        private final String cpfCnpj;
        private String inscricaoMunicipal;
        private String inscricaoEstadual;
        private String telefone;

        public Builder(String tipoPessoa, String cpfCnpj) {
            this.tipoPessoa = tipoPessoa;
            this.cpfCnpj = cpfCnpj;
        }

        public Builder nome(String nome) {
            this.nome = nome;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder inscricaoMunicipal(String inscricaoMunicipal) {
            this.inscricaoMunicipal = inscricaoMunicipal;
            return this;
        }

        public Builder inscricaoEstadual(String inscricaoEstadual) {
            this.inscricaoEstadual = inscricaoEstadual;
            return this;
        }

        public Builder telefone(String telefone) {
            this.telefone = telefone;
            return this;
        }

        public ClienteEnotasDto build() {
            return new ClienteEnotasDto(this);
        }

        public static List<String> getAtributosObrigatorios() {
            Field[] atributos;
            ArrayList<String> atributosObrigatorios = new ArrayList<String>();
            for (Field atributo : atributos = Builder.class.getDeclaredFields()) {
                int modificadores = atributo.getModifiers();
                if (!Modifier.toString(modificadores).contains("final") || !atributo.getType().equals(String.class) && !atributo.getType().equals(Integer.class) && !atributo.getType().equals(Double.class) && !atributo.getType().equals(Boolean.class)) continue;
                atributosObrigatorios.add(atributo.getName());
            }
            return atributosObrigatorios;
        }
    }
}

