/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento.integracao.enotas.converter;

import jalis.comum.Tipos;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.ClienteEnotasDto;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.ConfiguracaoEnotasDto;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.EnderecoEnotasDto;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.NotaServicoEnotasDto;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.ServicoEnotasDto;
import jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed.TecnospeedUtil;
import jalis.model.bean.cadastro.FilialBean;
import jalis.model.bean.cadastro.convenio.ConvenioBean;
import jalis.model.bean.cadastro.financeiro.ServicoBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.bean.recepcao.PacienteBean;
import jalis.model.vo.cadastro.financeiro.ServicoVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.PacienteService;
import jalis.service.cadastro.financeiro.ServicoService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;

public class NotaFiscalBeanParaNotaServicoEnotasDto {
    private NotaFiscalBean notaBean;
    private String tipoCadastro;
    private ServicoBean servico = null;
    private PacienteBean paciente = null;
    private ConvenioBean convenio = null;
    private FilialBean filialBean = null;

    public NotaServicoEnotasDto converter(ConfiguracaoEnotasDto configuracaoEnotas, NotaFiscalBean notaBean) {
        this.preencherBean(notaBean);
        ClienteEnotasDto clienteEnotas = this.converterCliente();
        EnderecoEnotasDto endereco = this.converterEndereco();
        ServicoEnotasDto servicoEnotas = this.converterServico(configuracaoEnotas);
        String empresaId = configuracaoEnotas.getEmpresaID();
        String ambienteEmissao = configuracaoEnotas.getAmbienteProducao() != false ? "Producao" : "Homologacao";
        String serieRps = notaBean.getSerie() == null ? "" : notaBean.getSerie().getCodigo();
        Boolean enviaPorEmail = !Funcoes.textoVazio(clienteEnotas.getEmail());
        Double valorTotal = notaBean.getServico().getValor();
        Double valorDeducoes = notaBean.getValorDeducoes().compareTo(BigDecimal.ZERO) > 0 ? notaBean.getValorDeducoes().doubleValue() : 0.0;
        Double valorDesconto = notaBean.getValorDescontoIncondicionado() != null && notaBean.getValorDescontoIncondicionado() > 0.0 ? notaBean.getValorDescontoIncondicionado() : 0.0;
        String naturezaOperacao = "";
        Long numeroRps = notaBean.getNumeroRps();
        String observacao = !Funcoes.textoVazio(notaBean.getObservacao()) ? notaBean.getObservacao().replace("\n", "|") : "";
        return new NotaServicoEnotasDto.Builder(empresaId, ambienteEmissao, serieRps, enviaPorEmail, clienteEnotas, endereco, servicoEnotas, valorTotal).deducoes(valorDeducoes).descontos(valorDesconto).naturezaOperacao(naturezaOperacao).numeroRps(numeroRps).observacoes(observacao).build();
    }

    private void preencherBean(NotaFiscalBean notaBean) {
        this.notaBean = notaBean;
        this.tipoCadastro = notaBean.getTipoCadastro();
        try {
            if (this.tipoCadastro.equals("P") || this.tipoCadastro.equals("E")) {
                this.paciente = (PacienteBean)new PacienteService().get(notaBean.getPaciente().getFilial().getCodigo().toString(), notaBean.getPaciente().getCodigo().toString());
            } else {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("fil_codigo", notaBean.getFilial().getCodigo());
                map.put("con_codigo", notaBean.getConvenio().getCodigo());
                this.convenio = (ConvenioBean)new ConvenioService().getBean(map);
            }
            if (notaBean.getServico() != null && notaBean.getServico().getServico() != null) {
                ServicoVO aux = notaBean.getServico().getServico();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("fil_codigo", aux.getFilial().getCodigo());
                map.put("svc_codigo", aux.getCodigo());
                this.servico = (ServicoBean)new ServicoService().getBean(map);
            }
            this.filialBean = (FilialBean)new FilialService().get(String.valueOf(notaBean.getFilial().getCodigo()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ClienteEnotasDto converterCliente() {
        String tipoPessoa = this.getTipoPessoa();
        String cpfCnpj = this.getCpfCnpj();
        String email = this.getEmail();
        String inscricaoEstadual = this.getInscricaoEstadual();
        String inscricaoMunicipal = this.tipoCadastro.equals("O") ? this.convenio.getInscrMunicipal() : "";
        String nome = this.getNome();
        String telefone = this.getTelefone();
        return new ClienteEnotasDto.Builder(tipoPessoa, cpfCnpj).email(email).inscricaoEstadual(inscricaoEstadual).inscricaoMunicipal(inscricaoMunicipal).nome(nome).telefone(telefone).build();
    }

    private String getNome() {
        StringBuilder nome = new StringBuilder("");
        nome.append(this.tipoCadastro.equals("E") ? this.paciente.getRazaoSocial() : "");
        nome.append(this.tipoCadastro.equals("P") ? this.notaBean.getNomePagador() : "");
        nome.append(this.tipoCadastro.equals("O") ? this.convenio.getRazaoSocial() : "");
        return nome.toString();
    }

    private String getInscricaoEstadual() {
        StringBuilder ie = new StringBuilder("");
        ie.append(this.tipoCadastro.equals("E") ? this.paciente.getIe() : "");
        ie.append(this.tipoCadastro.equals("O") ? this.convenio.getInscrEstadual() : "");
        return ie.toString();
    }

    private String getCpfCnpj() {
        String cpfCnpj = "";
        if (this.tipoCadastro.equals("E")) {
            String string = cpfCnpj = !Funcoes.textoVazio(this.paciente.getCnpj()) ? StringUtil.limpaString(this.paciente.getCnpj(), new String[]{".", "-", "/"}) : StringUtil.limpaString(this.paciente.getCpf(), new String[]{".", "-", "/"});
        }
        if (this.tipoCadastro.equals("P")) {
            cpfCnpj = StringUtil.limpaString(this.notaBean.getCpfPagador(), new String[]{".", "-", "/"});
        }
        if (this.tipoCadastro.equals("O")) {
            cpfCnpj = StringUtil.limpaString(this.convenio.getCnpjCpf(), new String[]{".", "-", "/"});
        }
        return cpfCnpj;
    }

    private String getTipoPessoa() {
        String tipoPessoa = "F";
        if (this.tipoCadastro.equals("E")) {
            String string = tipoPessoa = !Funcoes.textoVazio(this.paciente.getCnpj()) ? "J" : "F";
        }
        if (this.tipoCadastro.equals("O")) {
            tipoPessoa = "J";
        }
        return tipoPessoa;
    }

    private String getEmail() {
        ArrayList<String> emails;
        StringBuilder email = new StringBuilder("");
        email.append(this.tipoCadastro.equals("E") || this.tipoCadastro.equals("P") ? this.paciente.getEmail() : "");
        email.append(this.tipoCadastro.equals("O") ? this.convenio.getEmail1() : "");
        String mail = "";
        if (!Funcoes.textoVazio(email.toString()) && !(emails = StringUtil.explode(email.toString(), ";, ")).isEmpty()) {
            mail = emails.get(0);
        }
        return mail;
    }

    private String getTelefone() {
        if (this.tipoCadastro.equals("E") || this.tipoCadastro.equals("P")) {
            return !Funcoes.textoVazio(this.paciente.getFone()) ? this.paciente.getFone() : this.paciente.getCelular();
        }
        return this.convenio.getFone();
    }

    private EnderecoEnotasDto converterEndereco() {
        String uf = this.getUf();
        String cidade = this.getCidade();
        String bairro = this.getBairro();
        String complemento = this.tipoCadastro.equals("O") ? this.convenio.getComplemento() : this.paciente.getComplemento();
        String cep = this.getCep();
        String tipoLogradouro = this.tipoCadastro.equals("O") ? this.convenio.getTipoLogradouro() : this.paciente.getTipoLogradouro();
        String descricaLogradouro = Tipos.tipoLogradouroDescricao(tipoLogradouro);
        String logradouro = this.tipoCadastro.equals("O") ? this.convenio.getEndereco() : this.paciente.getEndereco();
        String numero = this.getNumero();
        String logradouroCompleto = !Funcoes.textoVazio(logradouro) && !Funcoes.textoVazio(descricaLogradouro) ? descricaLogradouro.concat(" ").concat(logradouro) : "";
        return new EnderecoEnotasDto.Builder(uf, cidade, logradouroCompleto, numero, bairro, cep).complemento(complemento).build();
    }

    private String getCep() {
        String cep = "";
        cep = this.tipoCadastro.equals("O") ? (Funcoes.textoVazio(this.convenio.getCep()) ? null : this.convenio.getCep().replace("-", "")) : (Funcoes.textoVazio(this.paciente.getCep()) ? null : this.paciente.getCep().replace("-", ""));
        return cep;
    }

    private String getBairro() {
        String bairro = "";
        bairro = this.tipoCadastro.equals("O") ? (this.convenio.getBairro() == null ? "" : this.convenio.getBairro().getDescricao()) : (this.paciente.getBairro() == null ? "" : this.paciente.getBairro().getDescricao());
        return bairro;
    }

    private String getCidade() {
        String cidade = "";
        cidade = this.tipoCadastro.equals("O") ? (this.convenio.getCidade() == null ? "" : this.convenio.getCidade().getCodigoIbge().toString()) : (this.paciente.getCidade() == null ? "" : this.paciente.getCidade().getCodigoIbge().toString());
        return cidade;
    }

    private String getUf() {
        String uf = "";
        uf = this.tipoCadastro.equals("O") ? (this.convenio.getCidade() == null ? "" : this.convenio.getCidade().getUf()) : (this.paciente.getCidade() == null ? "" : this.paciente.getCidade().getUf());
        return uf;
    }

    private String getNumero() {
        String numero = null;
        if (this.paciente != null && !Funcoes.textoVazio(this.paciente.getNumeroEndereco()) && this.paciente.getNumeroEndereco() != null || this.convenio != null && !Funcoes.textoVazio(this.convenio.getNumeroEndereco()) && this.convenio.getNumeroEndereco() != null) {
            numero = this.tipoCadastro.equals("E") || this.tipoCadastro.equals("P") ? this.paciente.getNumeroEndereco() : this.convenio.getNumeroEndereco();
        }
        return numero;
    }

    private ServicoEnotasDto converterServico(ConfiguracaoEnotasDto configuracao) {
        boolean issRetidoFonte = this.notaBean.getValorISSRetido() > 0.0;
        String descricao = this.servico.getDescricao();
        String cnae = !Funcoes.textoVazio(this.filialBean.getCodigoCnae()) ? this.filialBean.getCodigoCnae() : "";
        String descricaoServicoMunicipio = this.servico.getDescricao();
        String municipioPrestacaoServico = this.getMunicipioPrestacaoServico();
        String ufPrestacaoServico = this.getUFPrestacaoServico();
        String codigoServicoMunicipio = configuracao.getIgnorarFormatoTributacao() != false ? this.servico.getCodigoTributacaoMunicipio() : this.padronizarCodigo(this.servico.getCodigoTributacaoMunicipio());
        String itemListaServico = configuracao.getIgnorarFormatoListaServico() != false ? this.servico.getItemLista() : this.padronizarCodigo(this.servico.getItemLista());
        Double aliquotaIss = this.notaBean.getPercentualISSRetido() > 0.0 ? this.notaBean.getPercentualISSRetido() : this.notaBean.getIssPercentual();
        Double valorCofins = this.notaBean.getValorCofinsRetido() > 0.0 ? this.notaBean.getValorCofinsRetido() : 0.0;
        Double valorCsll = this.notaBean.getValorCsllRetido() > 0.0 ? this.notaBean.getValorCsllRetido() : 0.0;
        Double valorInss = this.notaBean.getValorInssRetido() > 0.0 ? this.notaBean.getValorInssRetido() : 0.0;
        Double valorIr = this.notaBean.getValorIrrfRetido() > 0.0 ? this.notaBean.getValorIrrfRetido() : 0.0;
        Double valorPis = this.notaBean.getValorPisRetido() > 0.0 ? this.notaBean.getValorPisRetido() : 0.0;
        return new ServicoEnotasDto.Builder(descricao, issRetidoFonte, codigoServicoMunicipio).aliquotaIss(aliquotaIss).cnae(cnae).descricaoServicoMunicipio(descricaoServicoMunicipio).itemListaServicoLC116(itemListaServico).municipioPrestacaoServico(municipioPrestacaoServico).ufPrestacaoServico(ufPrestacaoServico).valorCofins(valorCofins).valorCsll(valorCsll).valorInss(valorInss).valorIr(valorIr).valorPis(valorPis).build();
    }

    private String padronizarCodigo(String codigo) {
        return Funcoes.textoVazio(codigo) ? "" : codigo.replaceAll("[^0-9]", "");
    }

    private String getMunicipioPrestacaoServico() {
        if (this.servico.getTipoTributacao() != null && this.servico.getTipoTributacao().equalsIgnoreCase(String.valueOf(TecnospeedUtil.Tributacao.TRIBUTAVEL_FORA_MUNICIPIO.getCodigo())) && null != this.convenio) {
            return this.convenio.getCidade() == null ? "" : this.convenio.getCidade().getCodigoIbge().toString();
        }
        return this.filialBean.getCidade() == null ? "" : this.filialBean.getCidade().getCodigoIbge().toString();
    }

    private String getUFPrestacaoServico() {
        if (this.servico.getTipoTributacao() != null && this.servico.getTipoTributacao().equalsIgnoreCase(String.valueOf(TecnospeedUtil.Tributacao.TRIBUTAVEL_FORA_MUNICIPIO.getCodigo())) && null != this.convenio) {
            return this.convenio.getCidade() == null ? "" : this.convenio.getCidade().getUf();
        }
        return this.filialBean.getCidade() == null ? "" : this.filialBean.getCidade().getUf();
    }
}

