/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento.integracao.enotas;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.ComunicacaoEnotas;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.DialogoErrosEnotas;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.converter.NotaFiscalBeanParaNotaServicoEnotasDto;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.ConfiguracaoEnotasDto;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.DadosRespostaEnotas;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.NotaServicoEnotasDto;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.RespostaEnotas;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.StatusNota;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.validador.ErroCampoEnotas;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.validador.ValidacaoCampoObrigatorio;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.dao.financeiro.faturamento.integracao.enotas.IntegracaoEnotasDao;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.util.ArrayList;
import java.util.Date;

public class IntegracaoEnotas {
    private final IntegracaoEnotasDao dao;
    private NotaFiscalBeanParaNotaServicoEnotasDto conversor;
    private final ComunicacaoEnotas comunicacao;
    private final ValidacaoCampoObrigatorio validacao;
    private NotaFiscalBean notaBean;
    public static final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");

    public IntegracaoEnotas(NotaFiscalBean notaBean) {
        this.notaBean = notaBean;
        this.dao = new IntegracaoEnotasDao();
        this.conversor = new NotaFiscalBeanParaNotaServicoEnotasDto();
        this.comunicacao = new ComunicacaoEnotas();
        this.validacao = new ValidacaoCampoObrigatorio();
    }

    public RespostaEnotas cancelarNotaFiscal() throws Exception {
        ConfiguracaoEnotasDto configuracaoEnotas = this.getConfiguracaoEnotas(this.notaBean.getFilial().getCodigo());
        this.comunicacao.setConfiguracaoEnotas(configuracaoEnotas);
        String retorno = this.comunicacao.cancelarNota(this.notaBean.getChaveNfse());
        RespostaEnotas respostaConsulta = RespostaEnotas.getInstanciaDeConsulta();
        if (retorno.contains("Cancelamento solicitado com sucesso")) {
            RespostaEnotas resposta = RespostaEnotas.getInstanciaDeConsulta();
            resposta.getData().setIdExterno(this.notaBean.getChaveNfse());
            respostaConsulta = this.atualizarStatusNota(resposta, true);
        } else if (retorno.contains("se encontra com o status = \"Cancelada\"")) {
            respostaConsulta.getData().setStatus(StatusNota.CANCELADA.getDescricao());
        } else {
            respostaConsulta.getData().setStatus("");
            respostaConsulta.getData().setMotivoStatus(retorno);
        }
        return respostaConsulta;
    }

    public boolean enviarNotaFiscalEletronica() {
        ConfiguracaoEnotasDto configuracaoEnotas = this.getConfiguracaoEnotas(this.notaBean.getFilial().getCodigo());
        this.comunicacao.setConfiguracaoEnotas(configuracaoEnotas);
        ArrayList<ErroCampoEnotas> camposObrigatoriosNaoPreenchidos = this.validacao.validar(this.notaBean);
        if (!camposObrigatoriosNaoPreenchidos.isEmpty()) {
            DialogoErrosEnotas dialogoErros = DialogoErrosEnotas.getInstancia(Laboratorio.getInstancia(), camposObrigatoriosNaoPreenchidos);
            dialogoErros.setVisible(true);
            if (!dialogoErros.isOk()) {
                return false;
            }
        }
        NotaServicoEnotasDto notaEnotas = this.conversor.converter(configuracaoEnotas, this.notaBean);
        this.debug("Converteu notaBean para NotaServicoEnotasDto");
        RespostaEnotas respostaSolicitacao = RespostaEnotas.getInstanciaDeConsulta();
        try {
            respostaSolicitacao = this.comunicacao.enviarSolicitacaoNFSe(notaEnotas);
            if (respostaSolicitacao == null) {
                Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel interpretar o retorno da prefeitura.\n", 2);
                this.notaBean.setSituacao("X");
                return false;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Falha no envio da solicita\u00e7\u00e3o a Enotas.\n" + e.getMessage(), e.getStackTrace());
            return false;
        }
        RespostaEnotas respostaConsulta = RespostaEnotas.getInstanciaDeConsulta();
        if (!this.solicitacaoRejeitada(respostaSolicitacao)) {
            try {
                respostaConsulta = this.atualizarStatusNota(respostaSolicitacao, false);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Falha na consulta da solicita\u00e7\u00e3o a Enotas.\n" + e.getMessage(), e.getStackTrace());
            }
        } else {
            Funcoes.mensagem(Laboratorio.getInstancia(), String.format("Nota fiscal rejeitada - motivo: %s", respostaSolicitacao.getMessage()), 2);
            return true;
        }
        return this.notaFiscalAutorizadaPeloEnotas(respostaConsulta);
    }

    private RespostaEnotas atualizarStatusNota(RespostaEnotas respostaSolicitacao, boolean statusCancelamento) throws Exception {
        StatusNota sn;
        Thread.sleep(500L);
        RespostaEnotas respostaConsulta = RespostaEnotas.getInstanciaDeConsulta();
        int tempo = this.validarTempoEsperaEstacao();
        int contador = tempo * 2;
        StatusNota statusNota = sn = statusCancelamento ? StatusNota.SOLICITANDO_CANCELAMENTO : StatusNota.SOLICITANDO_AUTORIZACAO;
        while (!sn.processamentoFinalizado(statusCancelamento)) {
            respostaConsulta = this.comunicacao.consultarNFSe(respostaSolicitacao.getData().getIdExterno());
            sn = StatusNota.fromString(respostaConsulta.getData().getStatus());
            this.debug(respostaConsulta.getData().getStatus());
            if (contador-- <= 0) break;
            Thread.sleep(500L);
        }
        return respostaConsulta;
    }

    private int validarTempoEsperaEstacao() {
        String tempoEsperaEstacao = ParametrosLocais.getParametro("tempoRetornoNfse");
        return !Funcoes.textoVazio(tempoEsperaEstacao) && Funcoes.isNumeric(tempoEsperaEstacao) && Integer.parseInt(tempoEsperaEstacao) > 0 ? Integer.valueOf(tempoEsperaEstacao) : 5;
    }

    public boolean notaFiscalAutorizada(String chaveNFSe) {
        RespostaEnotas respostaConsulta = this.consultarNotaFiscal(chaveNFSe);
        return this.notaFiscalAutorizadaPeloEnotas(respostaConsulta);
    }

    public RespostaEnotas consultarNotaFiscal(String chaveNFSe) {
        ConfiguracaoEnotasDto configuracaoEnotas = this.getConfiguracaoEnotas(this.notaBean.getFilial().getCodigo());
        this.comunicacao.setConfiguracaoEnotas(configuracaoEnotas);
        RespostaEnotas respostaConsulta = RespostaEnotas.getInstanciaDeConsulta();
        try {
            respostaConsulta = this.comunicacao.consultarNFSe(chaveNFSe);
            this.debug(respostaConsulta.getData().getStatus());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Falha na consulta da nota Id " + chaveNFSe + " - " + e.getMessage(), e.getStackTrace());
        }
        return respostaConsulta;
    }

    public byte[] baixarPdf() {
        byte[] bytePdf = null;
        try {
            ConfiguracaoEnotasDto configuracaoEnotas = this.getConfiguracaoEnotas(this.notaBean.getFilial().getCodigo());
            this.comunicacao.setConfiguracaoEnotas(configuracaoEnotas);
            RespostaEnotas respostaConsulta = this.comunicacao.consultarNFSe(this.notaBean.getChaveNfse());
            if (respostaConsulta.getData() != null && !Funcoes.textoVazio(respostaConsulta.getData().getLinkDownloadPDF())) {
                bytePdf = this.comunicacao.baixarDocumentos(respostaConsulta.getData().getLinkDownloadPDF());
            }
            if (bytePdf != null) {
                this.atualizarPDF(respostaConsulta.getData().getLinkDownloadPDF(), bytePdf);
            }
        }
        catch (Exception e) {
            this.debug("Falha ao tentar baixar PDF ");
        }
        return bytePdf;
    }

    public ConfiguracaoEnotasDto getConfiguracaoEnotas(int codFilial) {
        String confEnotas = this.dao.pesquisarConfiguracaoEnotas(codFilial);
        ConfiguracaoEnotasDto configuracaoEnotas = null;
        if (!Funcoes.textoVazio(confEnotas)) {
            configuracaoEnotas = new ConfiguracaoEnotasDto.Builder().enderecoAPI(StringUtil.getValor(confEnotas, "enderecoAPI")).codigoThread(Integer.valueOf(StringUtil.getValor(confEnotas, "codigoThread"))).chave(StringUtil.getValor(confEnotas, "chave")).empresaID(StringUtil.getValor(confEnotas, "empresaId")).ambienteProducao(StringUtil.getBoolean(confEnotas, "ambienteProducao")).ignorarFormatoListaServicos(StringUtil.getBoolean(confEnotas, "ignorarListaServico")).ignorarFormatoTributacao(StringUtil.getBoolean(confEnotas, "ignorarTributacao")).build();
        }
        return configuracaoEnotas;
    }

    private boolean solicitacaoRejeitada(RespostaEnotas respostaSolicitacao) {
        if (respostaSolicitacao.getHttpStatusCode() != 200) {
            this.notaRejeitadaNoJalis(respostaSolicitacao.getMessage());
            return true;
        }
        return false;
    }

    private boolean notaFiscalAutorizadaPeloEnotas(RespostaEnotas respostaConsulta) {
        if (respostaConsulta.getData() != null) {
            if (this.statusNegada(respostaConsulta)) {
                this.atualizarNotaNegada(respostaConsulta.getData());
            } else {
                if (this.statusAutorizada(respostaConsulta) && this.notaAutorizadaNoJalis(respostaConsulta)) {
                    this.processaAutorizada(respostaConsulta);
                    return true;
                }
                if (!Funcoes.textoVazio(respostaConsulta.getData().getIdExterno())) {
                    this.notaBean.setMotivoNfse(StatusNota.getStatus(respostaConsulta.getData().getStatus()));
                    this.notaBean.setChaveNfse(respostaConsulta.getData().getIdExterno());
                    this.notaBean.setSituacao("X");
                }
            }
            this.debug("Motivo retornado prefeitura: " + respostaConsulta.getData().getMotivoStatus());
            Funcoes.mensagem(Laboratorio.getInstancia(), String.format(this.getMensagem(respostaConsulta), respostaConsulta.getData().getMotivoStatus()), 2);
        }
        return false;
    }

    private void processaAutorizada(RespostaEnotas respostaConsulta) {
        this.atualizarPDF(respostaConsulta.getData().getLinkDownloadPDF(), null);
        this.atualizarXML(respostaConsulta.getData().getLinkDownloadXML());
        this.atualizarReceberPagar();
        Funcoes.mensagem(Laboratorio.getInstancia(), String.format("Nota fiscal autorizada com o n\u00famero \"%s\".", respostaConsulta.getData().getNumero()), 5);
    }

    private String getMensagem(RespostaEnotas respostaConsulta) {
        return respostaConsulta.getData().getStatus().equalsIgnoreCase(StatusNota.NEGADA.getDescricao()) ? "Nota fiscal negada pela prefeitura\nMotivo: %s" : StatusNota.getStatusComLegenda(respostaConsulta.getData().getStatus());
    }

    public void atualizarPDF(String linkDownloadPDF, byte[] pdfEmBytes) {
        try {
            if (pdfEmBytes == null) {
                pdfEmBytes = this.comunicacao.baixarDocumentos(linkDownloadPDF);
            }
            Long pdfOID = DBUtil.gravaLargeObject(pdfEmBytes, Conexao.getConnection());
            this.notaBean.setPdfRps(pdfOID);
            this.dao.atualizarPDF(this.notaBean);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), String.format("Falha ao atualizar PDF no Banco de dados - %s", e.getMessage()), e.getStackTrace());
        }
    }

    public void atualizarXML(String linkDownloadXML) {
        try {
            byte[] pdfEmBytes = this.comunicacao.baixarDocumentos(linkDownloadXML);
            Long xmlOID = DBUtil.gravaLargeObject(pdfEmBytes, Conexao.getConnection());
            this.notaBean.setXmlNfse(xmlOID);
            this.dao.atualizarXML(this.notaBean);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), String.format("Falha ao atualizar XML no Banco de dados - %s", e.getMessage()), e.getStackTrace());
        }
    }

    private boolean notaAutorizadaNoJalis(RespostaEnotas respostaConsulta) {
        DadosRespostaEnotas dados = respostaConsulta.getData();
        this.notaBean.setSituacao("A");
        this.notaBean.setNotaEnviada(true);
        this.notaBean.setChaveNfse(dados.getIdExterno());
        this.notaBean.setNumero(Long.valueOf(dados.getNumero()));
        this.notaBean.setMotivoNfse(dados.getStatus());
        this.notaBean.setDataStatusNfse(new Date());
        this.notaBean.setProtocoloNfse(dados.getCodigoVerificacao());
        this.notaBean.setNumeroRps(dados.getNumeroRps());
        this.notaBean.setChaveRpsNfse(dados.getIdentificador());
        try {
            this.dao.autorizarNotaJalis(this.notaBean);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), String.format("Falha ao autorizar a Nota fiscal no Banco de dados - %s", e.getMessage()), e.getStackTrace());
            return false;
        }
        return true;
    }

    private boolean notaRejeitadaNoJalis(String message) {
        this.notaBean.setMotivoNfse(message);
        this.notaBean.setDataStatusNfse(new Date());
        this.notaBean.setSituacao("R");
        try {
            this.dao.rejeitarNotaJalis(this.notaBean);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), String.format("Falha ao rejeitar a Nota fiscal no Banco de dados - %s", e.getMessage()), e.getStackTrace());
            return false;
        }
        return true;
    }

    private void atualizarNotaNegada(DadosRespostaEnotas dadosResposta) {
        this.notaBean.setMotivoNfse(dadosResposta.getMotivoStatus());
        this.notaBean.setDataStatusNfse(new Date());
        this.notaBean.setSituacao("R");
        this.notaBean.setChaveNfse(dadosResposta.getIdExterno());
        try {
            this.dao.rejeitarNotaJalis(this.notaBean);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), String.format("Falha ao rejeitar a Nota fiscal no Banco de dados - %s", e.getMessage()), e.getStackTrace());
        }
    }

    private void atualizarReceberPagar() {
        try {
            this.dao.atualizarReceberPagar(this.notaBean);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), String.format("Falha ao atualizar receber/pagar - %s", e.getMessage()), e.getStackTrace());
        }
    }

    private boolean statusNegada(RespostaEnotas respostaConsulta) {
        return respostaConsulta.getData().getStatus().equalsIgnoreCase(StatusNota.NEGADA.getDescricao());
    }

    private boolean statusAutorizada(RespostaEnotas respostaConsulta) {
        return respostaConsulta.getData().getStatus().equalsIgnoreCase(StatusNota.AUTORIZADA.getDescricao()) || respostaConsulta.getData().getStatus().equalsIgnoreCase(StatusNota.AUTORIZADA_AGUARDANDO_GERACAO_PDF.getDescricao());
    }

    private void debug(String mensagem) {
        if (DEBUG) {
            System.out.println("Debug: " + mensagem);
        }
    }
}

