/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento.integracao.enotas;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.faturamento.integracao.DadosEspeciaisNFSe;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.validador.ErroCampoEnotas;
import jalis.model.AbstractThreadBean;
import jalis.model.FabricaDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.service.AbstractThreadService;
import jalis.service.financeiro.faturamento.enotas.DialogoErrosEnotasService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.TitledBorder;

public class DialogoErrosEnotas
extends JDialog
implements ActionListener {
    private JButton buttonSalvar = new JButton("Salvar");
    private JButton buttonCancelar = new JButton("Cancelar");
    private JPanel panelErros = new JPanel(new GridBagLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private static boolean ok = false;
    private ArrayList<ErroCampoEnotas> erros = null;
    private static final int ALTURA_PADRAO = 20;
    private final DialogoErrosEnotasService service;

    public static DialogoErrosEnotas getInstancia(Component owner, ArrayList<ErroCampoEnotas> erros) {
        if (owner instanceof Frame) {
            return new DialogoErrosEnotas((Frame)owner, erros);
        }
        return new DialogoErrosEnotas((Dialog)owner, erros);
    }

    private DialogoErrosEnotas(Dialog owner, ArrayList<ErroCampoEnotas> erros) {
        super(owner, "Erros encontrados ao gerar a nota fiscal eletr\u00f4nica", true);
        this.erros = erros;
        this.service = new DialogoErrosEnotasService();
        this.construirTela();
    }

    private DialogoErrosEnotas(Frame owner, ArrayList<ErroCampoEnotas> erros) {
        super(owner, "Erros encontrados ao gerar a nota fiscal eletr\u00f4nica", true);
        this.erros = erros;
        this.service = new DialogoErrosEnotasService();
        this.construirTela();
    }

    private void construirTela() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(450, 450));
        this.setResizable(false);
        this.panelErros.setBorder(new TitledBorder("Erros"));
        this.add((Component)this.panelErros, "Center");
        this.add((Component)this.panelBotoes, "South");
        this.buttonSalvar.setMnemonic('S');
        this.buttonCancelar.addActionListener(this);
        this.buttonSalvar.addActionListener(this);
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
        this.construirComponentesDinamicos();
        this.pack();
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        Funcoes.montaEnter((JComponent)this.panelErros);
        ScreenUtil.centralizar(this);
    }

    private void construirComponentesDinamicos() {
        Insets insetLabelPri = new Insets(3, 3, 0, 0);
        Insets insetLabelSeg = new Insets(1, 3, 0, 3);
        Insets insetTextPri = new Insets(1, 3, 0, 0);
        Insets insetTextSeg = new Insets(1, 3, 0, 3);
        GridBagConstraints c = new GridBagConstraints();
        DadosEspeciaisNFSe dados = null;
        Object labelDados = null;
        HashMap listaClasses = new HashMap();
        for (int i = 0; i < this.erros.size(); ++i) {
            final ErroCampoEnotas erro = this.erros.get(i);
            dados = erro.getCampoEnotas().getBean() instanceof DadosEspeciaisNFSe ? (DadosEspeciaisNFSe)((Object)erro.getCampoEnotas().getBean()) : null;
            boolean naoPreenchido = false;
            String descErro = "";
            String msgErro = "";
            if (erro.getCampoEnotas().getBean() != null && erro.getCampoEnotas().getBean().isChavesPrimariasNaoPreenchidas()) {
                descErro = ((DadosEspeciaisNFSe)((Object)erro.getCampoEnotas().getBean())).getDescricaoTabela() + " n\u00e3o informado(a): ";
                msgErro = "<html>Erro: " + descErro + (dados != null ? "<br> Cadastro: " + ((DadosEspeciaisNFSe)((Object)erro.getCampoEnotas().getBeanPai())).getDescricaoCadastro() : "") + "</html>";
                if (listaClasses.containsKey(erro.getCampoEnotas().getBean().getClass()) && ((Class)listaClasses.get(erro.getCampoEnotas().getBean().getClass())).equals(erro.getCampoEnotas().getBeanPai().getClass())) {
                    this.erros.remove(i);
                    --i;
                    continue;
                }
                listaClasses.put(erro.getCampoEnotas().getBean().getClass(), erro.getCampoEnotas().getBeanPai().getClass());
                erro.setNullCadastro(true);
                naoPreenchido = true;
            } else {
                descErro = erro.getCampoEnotas().getNomeAmigavel() + " :";
                msgErro = "<html>Erro: " + erro.getDescricao() + (dados != null ? "<br> Cadastro: " + dados.getDescricaoCadastro() : "") + "</html>";
            }
            JLabel labelDesc = new JLabel(descErro);
            final JLabel labelErro = new JLabel(msgErro);
            final JLabel labelSelecionado = new JLabel();
            JComboBox<Object> combo = null;
            TTextField campo = null;
            if (erro.getCampoEnotas().getListaValores() != null && erro.getCampoEnotas().getListaValores().length > 0) {
                combo = new JComboBox<Object>(erro.getCampoEnotas().getListaValores());
                erro.setCombo(true);
                erro.setListaCombo(combo);
            } else {
                campo = new TTextField(30, erro.getCampoEnotas().getTipo().getTipoJalis());
                if (erro.getCampoEnotas() != null && erro.getCampoEnotas().getValor() != null) {
                    campo.setValidarConteudo(false);
                    campo.setText(erro.getCampoEnotas().getValor().toString());
                }
                erro.setTextCorrecao(campo);
            }
            JButton buttonSelecionado = ComponenteFactory.novoJButton(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogoErrosEnotas.this.buscaCadastro(labelSelecionado, erro);
                }
            }, true);
            int aux = 30;
            if (erro.isCombo()) {
                int tam = this.getTamanhoCombo(combo) + 25;
                combo.setPreferredSize(new Dimension(tam, 20));
                combo.setMinimumSize(new Dimension(tam, 20));
            } else {
                campo.setPreferredSize(new Dimension(aux * 10, 20));
                campo.setMinimumSize(new Dimension(aux * 10, 20));
            }
            JLabel label = new JLabel(ImagemUtils.carregaImagemJalis("error.png"));
            label.setPreferredSize(new Dimension(20, 20));
            label.setMinimumSize(new Dimension(20, 20));
            label.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    DialogoErrosEnotas.this.getContentPane().setCursor(Cursor.getDefaultCursor());
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    DialogoErrosEnotas.this.getContentPane().setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    JPopupMenu menu = new JPopupMenu();
                    Component c = (Component)e.getSource();
                    JMenuItem item = ComponenteFactory.novoJMenuItem(menu, labelErro.getText(), null);
                    item.setEnabled(false);
                    menu.show(c.getParent(), c.getX(), c.getY());
                }
            });
            if (i > 0) {
                ++c.gridy;
                c.insets = insetLabelSeg;
            } else {
                c.gridy = 0;
                c.insets = insetLabelPri;
            }
            c.gridx = 0;
            c.anchor = 17;
            c.fill = 0;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.panelErros.add((Component)labelDesc, c);
            c.insets = i > 0 ? insetTextSeg : insetTextPri;
            ++c.gridx;
            if (!naoPreenchido) {
                if (erro.isCombo()) {
                    this.panelErros.add(combo, c);
                } else {
                    this.panelErros.add((Component)campo, c);
                }
            } else {
                JPanel panelSelecao = new JPanel(new GridBagLayout());
                GridBagConstraints cSelecionado = new GridBagConstraints();
                cSelecionado.gridx = 0;
                cSelecionado.gridy = 0;
                cSelecionado.anchor = 17;
                cSelecionado.fill = 0;
                cSelecionado.gridheight = 1;
                cSelecionado.gridwidth = 1;
                cSelecionado.weightx = 0.0;
                cSelecionado.weighty = 0.0;
                buttonSelecionado.setPreferredSize(new Dimension(20, 20));
                buttonSelecionado.setMinimumSize(new Dimension(20, 20));
                panelSelecao.add((Component)buttonSelecionado, cSelecionado);
                ++cSelecionado.gridx;
                cSelecionado.fill = 2;
                cSelecionado.weightx = 1.0;
                labelSelecionado.setPreferredSize(new Dimension(150, 20));
                labelSelecionado.setMinimumSize(new Dimension(150, 20));
                labelSelecionado.setBorder(new TitledBorder(""));
                c.fill = 2;
                c.weightx = 1.0;
                panelSelecao.add((Component)labelSelecionado, cSelecionado);
                this.panelErros.add((Component)panelSelecao, c);
                c.fill = 0;
                c.weightx = 0.0;
            }
            c.insets = i > 0 ? insetLabelSeg : insetLabelPri;
            ++c.gridx;
            this.panelErros.add((Component)label, c);
        }
    }

    private void buscaCadastro(Component campo, ErroCampoEnotas erro) {
        AbstractThreadBean bean = erro.getCampoEnotas().getBean();
        try {
            AbstractThreadService service = FabricaDao.criarService(bean);
            AbstractThreadVO vo = service.pesquisaVO(this, (AbstractThreadVO)bean.clonar().toVO(), null, true);
            if (vo != null) {
                erro.setVo(vo);
                JLabel label = (JLabel)campo;
                label.setText(vo.toString());
            }
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi possivel carregar o cadastro. \n" + e.getMessage(), e.getStackTrace());
        }
    }

    private int getTamanhoCombo(JComboBox combo) {
        if (combo == null) {
            return 0;
        }
        int tamanhoMaximo = 0;
        for (int i = 0; i < combo.getItemCount(); ++i) {
            String valor = combo.getItemAt(i).toString();
            FontMetrics met = combo.getFontMetrics(combo.getFont());
            int width = met.stringWidth(valor);
            if (width <= tamanhoMaximo) continue;
            tamanhoMaximo = width;
        }
        return tamanhoMaximo;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonSalvar) {
            this.salvar();
        } else if (e.getSource() == this.buttonCancelar) {
            this.cancelar();
        }
    }

    private void cancelar() {
        if (Funcoes.mensagem(Laboratorio.getInstancia(), "A Nota Fiscal s\u00f3 poder\u00e1 ser gerada ap\u00f3s a corre\u00e7\u00e3o dos erros, deseja corrigir?", 4) == 1) {
            ok = false;
            this.setVisible(false);
        }
    }

    private void salvar() {
        if (this.camposPreenchidos()) {
            try {
                ok = this.service.salvar(this.erros);
                this.setVisible(false);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
        }
    }

    private boolean camposPreenchidos() {
        for (ErroCampoEnotas erro : this.erros) {
            if (!erro.isNullCadastro()) {
                TTextField aux = erro.getTextCorrecao();
                JComboBox comboAux = erro.getListaCombo();
                if (aux != null && !aux.isConteudoValido()) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), String.format("O conte\u00fado do campo %s \u00e9 inv\u00e1lido.", erro.getCampoEnotas().getNomeAmigavel()), 2);
                    ScreenUtil.requisitarFoco(aux);
                    return false;
                }
                if (comboAux != null && comboAux.getSelectedIndex() == -1) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), String.format("O item do campo %s deve ser selecionado.", erro.getCampoEnotas().getNomeAmigavel()), 2);
                    ScreenUtil.requisitarFoco(comboAux);
                    return false;
                }
                if (!(aux != null && !Funcoes.textoVazio(aux) || comboAux != null && comboAux.getSelectedIndex() != -1)) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), String.format("%s deve ser preenchido.", erro.getCampoEnotas().getNomeAmigavel()), 2);
                    ScreenUtil.requisitarFoco(aux);
                    return false;
                }
                if (!erro.getDescricao().contains("CEP") || aux.getText().length() == 9) continue;
                Funcoes.mensagem(Laboratorio.getInstancia(), String.format("%s inv\u00e1lido.", erro.getCampoEnotas().getNomeAmigavel()), 2);
                ScreenUtil.requisitarFoco(aux);
                return false;
            }
            if (erro.getVo() != null) continue;
            Funcoes.mensagem(Laboratorio.getInstancia(), ((DadosEspeciaisNFSe)((Object)erro.getCampoEnotas().getBean())).getDescricaoTabela().concat(" deve ser selecionado(a)."), 2);
            return false;
        }
        return true;
    }

    public boolean isOk() {
        return ok;
    }
}

