/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento.integracao.enotas;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.faturamento.integracao.ConfiguradorIntegracao;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConfiguradorEnotas
extends JDialog
implements ConfiguradorIntegracao {
    public static final String TAG_CONFIGURACAO = "configuracaoEnotas";
    public static final String TAG_ENDERECO_API = "enderecoAPI";
    public static final String TAG_CODIGO_THREAD = "codigoThread";
    public static final String TAG_CHAVE = "chave";
    public static final String TAG_EMPRESA_ID = "empresaId";
    public static final String TAG_AMBIENTE_PRODUCAO = "ambienteProducao";
    public static final String TAG_OBSERVACAO = "campoObs";
    public static final String TAG_IGNORAR_TRIBUTACAO = "ignorarTributacao";
    public static final String TAG_IGNORAR_LISTA_SERVICO = "ignorarListaServico";
    public static final String TITULO = "Configura\u00e7\u00e3o ENotas";
    private JPanel panel = new JPanel(new GridBagLayout());
    private JButton botaoCancelar = new JButton("Cancelar");
    private JButton botaoOK = new JButton("OK");
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JLabel labelEnderecoAPI = new JLabel("Endere\u00e7o API:");
    private JLabel labelCodigoThread = new JLabel("C\u00f3digo Thread:");
    private JLabel labelChave = new JLabel("Chave:");
    private JLabel labelEmpresaId = new JLabel("Empresa ID:");
    private JLabel labelObservacao = new JLabel("Campo Obs:");
    private JLabel labelCaracteres = new JLabel("caracteres");
    private TTextField textEnderecoAPI = new TTextField(200, 3);
    private TTextField textCodigoThread = new TTextField(10, 1);
    private TTextField textChave = new TTextField(200, 3);
    private TTextField textEmpresaId = new TTextField(200, 3);
    private TTextField textObservacao = new TTextField(4, 1);
    private JCheckBox checkAmbienteProducao = new JCheckBox("Emitir em ambiente de PRODU\u00c7\u00c2O");
    private JCheckBox checkIgnorarTributacao = new JCheckBox("<html>Ignorar formata\u00e7\u00e3o de <u>C\u00f3d. Tributa\u00e7\u00e3o Municipal</u></html>");
    private JCheckBox checkIgnorarListaServico = new JCheckBox("<html>Ignorar formata\u00e7\u00e3o de <u>Item da Lista de Servi\u00e7o</u></html>");
    private boolean ok = false;

    public static ConfiguradorEnotas novaInstancia(Window owner) {
        return owner instanceof JFrame ? new ConfiguradorEnotas((JFrame)owner, TITULO) : new ConfiguradorEnotas((JDialog)owner, TITULO);
    }

    private ConfiguradorEnotas(JDialog owner, String title) {
        super((Dialog)owner, title);
        this.montaTela();
    }

    private ConfiguradorEnotas(JFrame owner, String title) {
        super((Frame)owner, title);
        this.montaTela();
    }

    private void montaTela() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(420, 270);
        this.setModal(true);
        this.setResizable(false);
        this.setLocationRelativeTo(this.getOwner());
        this.panel.setBorder(new TitledBorder("Configura\u00e7\u00f5es"));
        this.adicionarBotoes();
        this.organizarComponentes();
        this.getContentPane().add((Component)this.panel, "Center");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        Funcoes.montaEnter((JComponent)this.panel);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
    }

    private void adicionarBotoes() {
        this.botaoOK.setMargin(new Insets(2, 2, 2, 2));
        this.botaoOK.setPreferredSize(new Dimension(40, 25));
        this.botaoCancelar.setMargin(new Insets(2, 2, 2, 2));
        this.botaoOK.setMnemonic('O');
        this.botaoCancelar.setMnemonic('C');
        this.botaoOK.addActionListener(this);
        this.botaoCancelar.addActionListener(this);
        this.panelBotoes.add(this.botaoOK);
        this.panelBotoes.add(this.botaoCancelar);
    }

    private void organizarComponentes() {
        Dimension dimensaoPadrao = new Dimension(300, 20);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(3, 1, 1, 1);
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        this.panel.add((Component)this.labelEnderecoAPI, c);
        c.gridx = 1;
        c.fill = 0;
        this.textEnderecoAPI.setPreferredSize(dimensaoPadrao);
        this.textEnderecoAPI.setMinimumSize(dimensaoPadrao);
        this.panel.add((Component)this.textEnderecoAPI, c);
        c.insets = new Insets(1, 1, 1, 1);
        ++c.gridy;
        c.gridx = 0;
        this.panel.add((Component)this.labelCodigoThread, c);
        c.gridx = 1;
        this.textCodigoThread.setPreferredSize(dimensaoPadrao);
        this.textCodigoThread.setMinimumSize(dimensaoPadrao);
        this.panel.add((Component)this.textCodigoThread, c);
        ++c.gridy;
        c.gridx = 0;
        this.panel.add((Component)this.labelChave, c);
        c.gridx = 1;
        this.textChave.setPreferredSize(dimensaoPadrao);
        this.textChave.setMinimumSize(dimensaoPadrao);
        this.panel.add((Component)this.textChave, c);
        ++c.gridy;
        c.gridx = 0;
        this.panel.add((Component)this.labelEmpresaId, c);
        c.gridx = 1;
        this.textEmpresaId.setPreferredSize(dimensaoPadrao);
        this.textEmpresaId.setMinimumSize(dimensaoPadrao);
        this.panel.add((Component)this.textEmpresaId, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 2;
        this.panel.add((Component)this.labelObservacao, c);
        c.gridx = 1;
        c.weightx = 1.0;
        this.textObservacao.setPreferredSize(new Dimension(100, 20));
        this.textObservacao.setMinimumSize(new Dimension(100, 20));
        this.panel.add((Component)this.textObservacao, c);
        c.gridx = 2;
        c.weightx = 0.0;
        this.panel.add((Component)this.labelCaracteres, c);
        c.fill = 2;
        c.weightx = 0.0;
        c.gridwidth = 2;
        ++c.gridy;
        c.gridx = 0;
        this.panel.add((Component)this.checkAmbienteProducao, c);
        ++c.gridy;
        this.panel.add((Component)this.checkIgnorarTributacao, c);
        ++c.gridy;
        this.panel.add((Component)this.checkIgnorarListaServico, c);
    }

    @Override
    public void setXML(String xml) {
        if (!Funcoes.textoVazio(xml)) {
            String enderecoAPI = StringUtil.getValor(xml, TAG_ENDERECO_API);
            String codigoThread = StringUtil.getValor(xml, TAG_CODIGO_THREAD);
            String chave = StringUtil.getValor(xml, TAG_CHAVE);
            String empresaId = StringUtil.getValor(xml, TAG_EMPRESA_ID);
            String observacao = StringUtil.getValor(xml, TAG_OBSERVACAO);
            boolean ambienteProducao = StringUtil.getBoolean(xml, TAG_AMBIENTE_PRODUCAO);
            boolean ignorarTributacao = StringUtil.getBoolean(xml, TAG_IGNORAR_TRIBUTACAO);
            boolean ignorarListaServico = StringUtil.getBoolean(xml, TAG_IGNORAR_LISTA_SERVICO);
            this.textEnderecoAPI.setText(!Funcoes.textoVazio(enderecoAPI) ? enderecoAPI : "");
            this.textCodigoThread.setText(!Funcoes.textoVazio(codigoThread) ? codigoThread : "");
            this.textChave.setText(!Funcoes.textoVazio(chave) ? chave : "");
            this.textEmpresaId.setText(!Funcoes.textoVazio(empresaId) ? empresaId : "");
            this.textObservacao.setText(!Funcoes.textoVazio(observacao) ? observacao : "");
            this.checkAmbienteProducao.setSelected(ambienteProducao);
            this.checkIgnorarListaServico.setSelected(ignorarListaServico);
            this.checkIgnorarTributacao.setSelected(ignorarTributacao);
        }
    }

    @Override
    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(TAG_CONFIGURACAO);
        xml.escrever(TAG_ENDERECO_API, this.textEnderecoAPI.getText());
        xml.escrever(TAG_CODIGO_THREAD, this.textCodigoThread.getText());
        xml.escrever(TAG_CHAVE, this.textChave.getText());
        xml.escrever(TAG_EMPRESA_ID, this.textEmpresaId.getText());
        xml.escrever(TAG_AMBIENTE_PRODUCAO, this.checkAmbienteProducao.isSelected() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        xml.escrever(TAG_IGNORAR_LISTA_SERVICO, this.checkIgnorarListaServico.isSelected() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        xml.escrever(TAG_IGNORAR_TRIBUTACAO, this.checkIgnorarTributacao.isSelected() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        xml.escrever(TAG_OBSERVACAO, this.textObservacao.getText());
        try {
            xml.fechar(TAG_CONFIGURACAO);
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel obter o xml de configura\u00e7\u00e3o ENotas. \n" + e.getMessage(), e.getStackTrace());
        }
        return xml.getXML();
    }

    @Override
    public boolean isOK() {
        return this.ok;
    }

    @Override
    public void exibirTela(boolean exibirTela) {
        this.setVisible(exibirTela);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.botaoCancelar) {
            this.exibirTela(false);
        } else if (e.getSource() == this.botaoOK && this.camposPreenchidos()) {
            this.ok = true;
            this.exibirTela(false);
        }
    }

    private boolean camposPreenchidos() {
        boolean campoNaoPreenchido;
        boolean bl = campoNaoPreenchido = Funcoes.textoVazio(this.textEnderecoAPI.getText()) || Funcoes.textoVazio(this.textCodigoThread.getText()) || Funcoes.textoVazio(this.textChave.getText()) || Funcoes.textoVazio(this.textEmpresaId.getText());
        if (campoNaoPreenchido) {
            Funcoes.mensagem(this, "Todos os campos precisam ser preenchidos", 2);
            TTextField naoPreenchido = this.getCampoNaoPreenchido();
            ScreenUtil.requisitarFoco(naoPreenchido);
            return false;
        }
        if (!Funcoes.textoVazio(this.textObservacao.getText()) && Integer.parseInt(this.textObservacao.getText()) > 8000) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "A quantidade m\u00e1xima permitida para o Campo Observa\u00e7\u00e3o \u00e9 de 8000 caracteres.", 2);
            ScreenUtil.requisitarFoco(this.textObservacao);
            return false;
        }
        return true;
    }

    private TTextField getCampoNaoPreenchido() {
        TTextField naoPreenchido = null;
        if (Funcoes.textoVazio(this.textEnderecoAPI.getText())) {
            naoPreenchido = this.textEnderecoAPI;
        } else if (Funcoes.textoVazio(this.textCodigoThread.getText())) {
            naoPreenchido = this.textCodigoThread;
        } else if (Funcoes.textoVazio(this.textChave.getText())) {
            naoPreenchido = this.textChave;
        } else if (Funcoes.textoVazio(this.textEmpresaId.getText())) {
            naoPreenchido = this.textEmpresaId;
        }
        return naoPreenchido;
    }
}

