/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento.integracao.enotas;

import jalis.laboratorio.financeiro.faturamento.integracao.enotas.OperacaoComunicacao;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.ConfiguracaoEnotasDto;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.NotaServicoEnotasDto;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.RespostaEnotas;
import jalis.util.Funcoes;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONObject;

public class ComunicacaoEnotas {
    private ConfiguracaoEnotasDto configuracaoEnotas;
    public static final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");

    public byte[] baixarDocumentos(String urlDownload) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            int bytesRead;
            HttpGet get = new HttpGet(urlDownload);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
            this.debug("baixarDocumentos respondeu http c\u00f3d: " + response.getStatusLine().getStatusCode());
            HttpEntity entity = response.getEntity();
            InputStream inputStream = entity.getContent();
            byte[] documentoEmBytes = new byte[8192];
            while ((bytesRead = inputStream.read(documentoEmBytes)) != -1) {
                baos.write(documentoEmBytes, 0, bytesRead);
            }
        }
        return baos.toByteArray();
    }

    public String cancelarNota(String idExterno) throws Exception {
        String retorno = "";
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            URI uri = new URIBuilder(OperacaoComunicacao.CANCELAMENTO.getUrlComRota(this.configuracaoEnotas.getEnderecoAPI())).addParameter("empresaId", this.configuracaoEnotas.getEmpresaID()).addParameter("idExterno", idExterno).build();
            HttpDelete delete = new HttpDelete(uri);
            String autenticacao = this.getAutenticacao();
            delete.setHeader("Authorization", "Basic " + autenticacao);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)delete);
            StringBuilder respJson = new StringBuilder();
            String line = null;
            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            while ((line = br.readLine()) != null) {
                respJson.append(line);
            }
            this.debug("resposta cancelamento: " + respJson.toString());
            retorno = respJson.toString();
        }
        return retorno;
    }

    public RespostaEnotas consultarNFSe(String idExterno) throws Exception {
        JSONObject respostaJson = new JSONObject();
        int statusCode = 0;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            URI uri = new URIBuilder(OperacaoComunicacao.CONSULTA.getUrlComRota(this.configuracaoEnotas.getEnderecoAPI())).addParameter("empresaId", this.configuracaoEnotas.getEmpresaID()).addParameter("idExterno", idExterno).build();
            HttpGet get = new HttpGet(uri);
            String autenticacao = this.getAutenticacao();
            get.setHeader("Authorization", "Basic " + autenticacao);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
            this.debug("consultarNFSe respondeu http c\u00f3d: " + response.getStatusLine().getStatusCode());
            StringBuilder respJson = new StringBuilder();
            String line = null;
            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            while ((line = br.readLine()) != null) {
                respJson.append(line);
            }
            this.debug("resposta consulta: " + respJson.toString());
            respostaJson = new JSONObject(respJson.toString());
            statusCode = response.getStatusLine().getStatusCode();
        }
        return RespostaEnotas.converterJSONParaRespostaEnotas(respostaJson, statusCode);
    }

    public RespostaEnotas enviarSolicitacaoNFSe(NotaServicoEnotasDto notaEnotas) throws Exception {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost post = new HttpPost(OperacaoComunicacao.EMISSAO.getUrlComRota(this.configuracaoEnotas.getEnderecoAPI()));
            String autenticacao = this.getAutenticacao();
            post.setHeader("Authorization", "Basic " + autenticacao);
            StringEntity jsonEntity = new StringEntity(notaEnotas.toJson(), ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)jsonEntity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            this.debug("enviarSolicitacaoNFSe respondeu http c\u00f3d: " + response.getStatusLine().getStatusCode());
            StringBuilder respJson = new StringBuilder();
            String line = null;
            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            while ((line = br.readLine()) != null) {
                respJson.append(line);
            }
            this.debug("resposta solicitacao: " + respJson.toString());
            if (this.isJSON(respJson.toString())) {
                JSONObject respostaJson = new JSONObject(respJson.toString());
                RespostaEnotas respostaEnotas = RespostaEnotas.converterJSONParaRespostaEnotas(respostaJson, response.getStatusLine().getStatusCode());
                return respostaEnotas;
            }
        }
        return null;
    }

    private boolean isJSON(String json) {
        try {
            new JSONObject(json);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getAutenticacao() {
        String autenticacao = this.configuracaoEnotas.getCodigoThread().toString().concat(":").concat(this.configuracaoEnotas.getChave());
        return DatatypeConverter.printBase64Binary((byte[])autenticacao.getBytes(StandardCharsets.UTF_8));
    }

    public void setConfiguracaoEnotas(ConfiguracaoEnotasDto configuracaoEnotas) {
        this.configuracaoEnotas = configuracaoEnotas;
    }

    private void debug(String mensagem) {
        if (DEBUG) {
            System.out.println("Debug: " + mensagem);
        }
    }
}

