/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento.integracao;

import jalis.comum.Conexao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.faturamento.integracao.DadosEspeciaisCombo;
import jalis.laboratorio.financeiro.faturamento.integracao.DadosEspeciaisNFSe;
import jalis.laboratorio.financeiro.faturamento.integracao.ErrosCampos;
import jalis.laboratorio.financeiro.faturamento.integracao.SistemaEmissaoNFSe;
import jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed.TecnospeedUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.FabricaDao;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.utils.DataBaseField;
import jalis.model.utils.DataBaseTable;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.service.AbstractThreadService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.TitledBorder;

public class DialogoErros
extends JDialog
implements ActionListener {
    private JButton buttonSalvar = new JButton("Salvar");
    private JButton buttonCancelar = new JButton("Cancelar");
    private JPanel panelErros = new JPanel(new GridBagLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private static boolean isOk = false;
    private ArrayList<ErrosCampos> erros = null;
    private SistemaEmissaoNFSe sistemaEmissaoNFSe = Laboratorio.sistemaEmissorNFSe;

    public DialogoErros(Dialog owner, ArrayList<ErrosCampos> erros) {
        super(owner, "Erros encontrados ao gerar a nota fiscal eletr\u00f4nica", true);
        this.erros = erros;
        this.montaTela();
    }

    public DialogoErros(Frame owner, ArrayList<ErrosCampos> erros) {
        super(owner, "Mensagens da nota fiscal eletr\u00f4nica", true);
        this.erros = erros;
        this.montaTela();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(450, 450));
        this.setResizable(false);
        this.panelErros.setBorder(new TitledBorder("Mensagens"));
        this.add((Component)this.panelErros, "Center");
        this.add((Component)this.panelBotoes, "South");
        this.buttonSalvar.setMnemonic('S');
        this.buttonSalvar.setMnemonic('C');
        this.buttonCancelar.addActionListener(this);
        this.buttonSalvar.addActionListener(this);
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
        this.preencherDados();
        this.pack();
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        Funcoes.montaEnter((JComponent)this.panelErros);
        ScreenUtil.centralizar(this);
    }

    private void preencherDados() {
        if (this.erros != null) {
            Insets insetLabelPri = new Insets(3, 3, 0, 0);
            Insets insetLabelSeg = new Insets(1, 3, 0, 3);
            Insets insetTextPri = new Insets(1, 3, 0, 0);
            Insets insetTextSeg = new Insets(1, 3, 0, 3);
            GridBagConstraints c = new GridBagConstraints();
            DadosEspeciaisNFSe dados = null;
            Object labelDados = null;
            HashMap listaClasses = new HashMap();
            for (int i = 0; i < this.erros.size(); ++i) {
                GridBagConstraints cSelecionado;
                JPanel panelSelecao;
                JLabel label;
                int aux;
                JButton buttonSelecionado;
                TTextField campo;
                JComboBox<Object> combo;
                JLabel labelSelecionado;
                JLabel labelErro;
                JLabel labelDesc;
                String msgErro;
                String descErro;
                boolean naoPreenchido;
                final ErrosCampos erro = this.erros.get(i);
                if (this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.NEOGRID) {
                    dados = erro.getCampoNeogrid().getBean() instanceof DadosEspeciaisNFSe ? (DadosEspeciaisNFSe)((Object)erro.getCampoNeogrid().getBean()) : null;
                    naoPreenchido = false;
                    descErro = "";
                    msgErro = "";
                    if (erro.getCampoNeogrid().getBean().isChavesPrimariasNaoPreenchidas()) {
                        descErro = ((DadosEspeciaisNFSe)((Object)erro.getCampoNeogrid().getBean())).getDescricaoTabela() + " n\u00e3o informado(a): ";
                        msgErro = "<html>Mensagem: " + descErro + (dados != null ? "<br> Cadastro: " + ((DadosEspeciaisNFSe)((Object)erro.getCampoNeogrid().getBeanPai())).getDescricaoCadastro() : "") + "</html>";
                        if (listaClasses.containsKey(erro.getCampoNeogrid().getBean().getClass()) && ((Class)listaClasses.get(erro.getCampoNeogrid().getBean().getClass())).equals(erro.getCampoNeogrid().getBeanPai().getClass())) {
                            this.erros.remove(i);
                            --i;
                            continue;
                        }
                        listaClasses.put(erro.getCampoNeogrid().getBean().getClass(), erro.getCampoNeogrid().getBeanPai().getClass());
                        erro.setNullCadastro(true);
                        naoPreenchido = true;
                    } else {
                        descErro = erro.getCampoNeogrid().getDescricao() + " :";
                        msgErro = "<html>Mensagem: " + erro.getDescricao() + (dados != null ? "<br> Cadastro: " + dados.getDescricaoCadastro() : "") + "</html>";
                    }
                    labelDesc = new JLabel(descErro);
                    labelErro = new JLabel(msgErro);
                    labelSelecionado = new JLabel();
                    combo = null;
                    campo = null;
                    if (erro.getCampoNeogrid().getLista() != null && erro.getCampoNeogrid().getLista().length > 0) {
                        combo = new JComboBox<Object>(erro.getCampoNeogrid().getLista());
                        erro.setCombo(true);
                        erro.setListaCombo(combo);
                    } else {
                        campo = new TTextField((int)erro.getCampoNeogrid().getTamanhoMaximo(), erro.getCampoNeogrid().getTipo());
                        if (erro.getCampoNeogrid() != null && erro.getCampoNeogrid().getValor() != null) {
                            campo.setValidarConteudo(false);
                            campo.setText(erro.getCampoNeogrid().getValor().toString());
                        }
                        erro.setTextCorrecao(campo);
                    }
                    buttonSelecionado = ComponenteFactory.novoJButton(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DialogoErros.this.buscaCadastro(labelSelecionado, erro);
                        }
                    }, true);
                    aux = erro.getCampoNeogrid().getTamanhoMaximo();
                    if (erro.getCampoNeogrid().getTamanhoMaximo() >= 30) {
                        aux = 30;
                    }
                    if (erro.isCombo()) {
                        int tam = this.getTamanhoCombo(combo) + 25;
                        combo.setPreferredSize(new Dimension(tam, 20));
                        combo.setMinimumSize(new Dimension(tam, 20));
                    } else {
                        campo.setPreferredSize(new Dimension(aux * 10, 20));
                        campo.setMinimumSize(new Dimension(aux * 10, 20));
                    }
                    label = new JLabel(ImagemUtils.carregaImagemJalis("error.png"));
                    label.setPreferredSize(new Dimension(20, 20));
                    label.setMinimumSize(new Dimension(20, 20));
                    label.addMouseListener(new MouseListener(){

                        @Override
                        public void mouseReleased(MouseEvent e) {
                        }

                        @Override
                        public void mousePressed(MouseEvent e) {
                        }

                        @Override
                        public void mouseExited(MouseEvent e) {
                            DialogoErros.this.getContentPane().setCursor(Cursor.getDefaultCursor());
                        }

                        @Override
                        public void mouseEntered(MouseEvent e) {
                            DialogoErros.this.getContentPane().setCursor(Cursor.getPredefinedCursor(12));
                        }

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            JPopupMenu menu = new JPopupMenu();
                            Component c = (Component)e.getSource();
                            JMenuItem item = ComponenteFactory.novoJMenuItem(menu, labelErro.getText(), null);
                            item.setEnabled(false);
                            menu.show(c.getParent(), c.getX(), c.getY());
                        }
                    });
                    if (i > 0) {
                        ++c.gridy;
                        c.insets = insetLabelSeg;
                    } else {
                        c.gridy = 0;
                        c.insets = insetLabelPri;
                    }
                    c.gridx = 0;
                    c.anchor = 17;
                    c.fill = 0;
                    c.gridheight = 1;
                    c.gridwidth = 1;
                    c.weightx = 0.0;
                    c.weighty = 0.0;
                    this.panelErros.add((Component)labelDesc, c);
                    c.insets = i > 0 ? insetTextSeg : insetTextPri;
                    ++c.gridx;
                    if (!naoPreenchido) {
                        if (erro.isCombo()) {
                            this.panelErros.add(combo, c);
                        } else {
                            this.panelErros.add((Component)campo, c);
                        }
                    } else {
                        panelSelecao = new JPanel(new GridBagLayout());
                        cSelecionado = new GridBagConstraints();
                        cSelecionado.gridx = 0;
                        cSelecionado.gridy = 0;
                        cSelecionado.anchor = 17;
                        cSelecionado.fill = 0;
                        cSelecionado.gridheight = 1;
                        cSelecionado.gridwidth = 1;
                        cSelecionado.weightx = 0.0;
                        cSelecionado.weighty = 0.0;
                        buttonSelecionado.setPreferredSize(new Dimension(20, 20));
                        buttonSelecionado.setMinimumSize(new Dimension(20, 20));
                        panelSelecao.add((Component)buttonSelecionado, cSelecionado);
                        ++cSelecionado.gridx;
                        cSelecionado.fill = 2;
                        cSelecionado.weightx = 1.0;
                        labelSelecionado.setPreferredSize(new Dimension(150, 20));
                        labelSelecionado.setMinimumSize(new Dimension(150, 20));
                        labelSelecionado.setBorder(new TitledBorder(""));
                        c.fill = 2;
                        c.weightx = 1.0;
                        panelSelecao.add((Component)labelSelecionado, cSelecionado);
                        this.panelErros.add((Component)panelSelecao, c);
                        c.fill = 0;
                        c.weightx = 0.0;
                    }
                    c.insets = i > 0 ? insetLabelSeg : insetLabelPri;
                    ++c.gridx;
                    this.panelErros.add((Component)label, c);
                    continue;
                }
                dados = erro.getCampoTecnospeed().getBean() instanceof DadosEspeciaisNFSe ? (DadosEspeciaisNFSe)((Object)erro.getCampoTecnospeed().getBean()) : null;
                naoPreenchido = false;
                descErro = "";
                msgErro = "";
                if (erro.getCampoTecnospeed().getBean() != null && erro.getCampoTecnospeed().getBean().isChavesPrimariasNaoPreenchidas()) {
                    descErro = ((DadosEspeciaisNFSe)((Object)erro.getCampoTecnospeed().getBean())).getDescricaoTabela() + " n\u00e3o informado(a): ";
                    msgErro = "<html>Mensagem: " + descErro + (dados != null ? "<br> Cadastro: " + ((DadosEspeciaisNFSe)((Object)erro.getCampoTecnospeed().getBeanPai())).getDescricaoCadastro() : "") + "</html>";
                    if (listaClasses.containsKey(erro.getCampoTecnospeed().getBean().getClass()) && ((Class)listaClasses.get(erro.getCampoTecnospeed().getBean().getClass())).equals(erro.getCampoTecnospeed().getBeanPai().getClass())) {
                        this.erros.remove(i);
                        --i;
                        continue;
                    }
                    listaClasses.put(erro.getCampoTecnospeed().getBean().getClass(), erro.getCampoTecnospeed().getBeanPai().getClass());
                    erro.setNullCadastro(true);
                    naoPreenchido = true;
                } else {
                    descErro = erro.getCampoTecnospeed().getNomeAmigavel() + " :";
                    msgErro = "<html>Mensagem: " + erro.getDescricao() + (dados != null ? "<br> Cadastro: " + dados.getDescricaoCadastro() : "") + "</html>";
                }
                labelDesc = new JLabel(descErro);
                labelErro = new JLabel(msgErro);
                labelSelecionado = new JLabel();
                combo = null;
                campo = null;
                if (erro.getCampoTecnospeed().getListaValores() != null && erro.getCampoTecnospeed().getListaValores().length > 0) {
                    combo = new JComboBox<Object>(erro.getCampoTecnospeed().getListaValores());
                    erro.setCombo(true);
                    erro.setListaCombo(combo);
                } else {
                    campo = new TTextField(30, erro.getCampoTecnospeed().getTipo().getTipoJalis());
                    if (erro.getCampoTecnospeed() != null && erro.getCampoTecnospeed().getValor() != null) {
                        campo.setValidarConteudo(false);
                        campo.setText(erro.getCampoTecnospeed().getValor().toString());
                    }
                    erro.setTextCorrecao(campo);
                }
                buttonSelecionado = ComponenteFactory.novoJButton(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DialogoErros.this.buscaCadastro(labelSelecionado, erro);
                    }
                }, true);
                aux = 30;
                if (erro.isCombo()) {
                    int tam = this.getTamanhoCombo(combo) + 25;
                    combo.setPreferredSize(new Dimension(tam, 20));
                    combo.setMinimumSize(new Dimension(tam, 20));
                } else {
                    campo.setPreferredSize(new Dimension(aux * 10, 20));
                    campo.setMinimumSize(new Dimension(aux * 10, 20));
                }
                label = new JLabel(ImagemUtils.carregaImagemJalis("error.png"));
                label.setPreferredSize(new Dimension(20, 20));
                label.setMinimumSize(new Dimension(20, 20));
                label.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        DialogoErros.this.getContentPane().setCursor(Cursor.getDefaultCursor());
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        DialogoErros.this.getContentPane().setCursor(Cursor.getPredefinedCursor(12));
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        JPopupMenu menu = new JPopupMenu();
                        Component c = (Component)e.getSource();
                        JMenuItem item = ComponenteFactory.novoJMenuItem(menu, labelErro.getText(), null);
                        item.setEnabled(false);
                        menu.show(c.getParent(), c.getX(), c.getY());
                    }
                });
                if (i > 0) {
                    ++c.gridy;
                    c.insets = insetLabelSeg;
                } else {
                    c.gridy = 0;
                    c.insets = insetLabelPri;
                }
                c.gridx = 0;
                c.anchor = 17;
                c.fill = 0;
                c.gridheight = 1;
                c.gridwidth = 1;
                c.weightx = 0.0;
                c.weighty = 0.0;
                this.panelErros.add((Component)labelDesc, c);
                c.insets = i > 0 ? insetTextSeg : insetTextPri;
                ++c.gridx;
                if (!naoPreenchido) {
                    if (erro.isCombo()) {
                        this.panelErros.add(combo, c);
                    } else {
                        this.panelErros.add((Component)campo, c);
                    }
                } else {
                    panelSelecao = new JPanel(new GridBagLayout());
                    cSelecionado = new GridBagConstraints();
                    cSelecionado.gridx = 0;
                    cSelecionado.gridy = 0;
                    cSelecionado.anchor = 17;
                    cSelecionado.fill = 0;
                    cSelecionado.gridheight = 1;
                    cSelecionado.gridwidth = 1;
                    cSelecionado.weightx = 0.0;
                    cSelecionado.weighty = 0.0;
                    buttonSelecionado.setPreferredSize(new Dimension(20, 20));
                    buttonSelecionado.setMinimumSize(new Dimension(20, 20));
                    panelSelecao.add((Component)buttonSelecionado, cSelecionado);
                    ++cSelecionado.gridx;
                    cSelecionado.fill = 2;
                    cSelecionado.weightx = 1.0;
                    labelSelecionado.setPreferredSize(new Dimension(150, 20));
                    labelSelecionado.setMinimumSize(new Dimension(150, 20));
                    labelSelecionado.setBorder(new TitledBorder(""));
                    c.fill = 2;
                    c.weightx = 1.0;
                    panelSelecao.add((Component)labelSelecionado, cSelecionado);
                    this.panelErros.add((Component)panelSelecao, c);
                    c.fill = 0;
                    c.weightx = 0.0;
                }
                c.insets = i > 0 ? insetLabelSeg : insetLabelPri;
                ++c.gridx;
                this.panelErros.add((Component)label, c);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonSalvar) {
            this.salvar();
        } else if (e.getSource() == this.buttonCancelar) {
            this.cancelar();
        }
    }

    private void cancelar() {
        if (Funcoes.mensagem(Laboratorio.getInstancia(), "A Nota Fiscal s\u00f3 poder\u00e1 ser gerada ap\u00f3s a corre\u00e7\u00e3o dos erros, deseja corrigir?", 4) == 1) {
            isOk = false;
            this.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void salvar() {
        if (!this.validaCampos()) {
            return;
        }
        Statement st = Conexao.getStatement();
        try {
            if (this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.NEOGRID) {
                for (ErrosCampos erro : this.erros) {
                    Field campoFilial = null;
                    String filial = null;
                    String tabela = null;
                    String coluna = null;
                    String valor = null;
                    JComboBox combo = null;
                    if (erro.isNullCadastro()) {
                        tabela = erro.getCampoNeogrid().getBeanPai().getClass().getAnnotation(DataBaseTable.class).value();
                        campoFilial = erro.getCampoNeogrid().getBeanPai().getFieldByColumnName("fil_codigo");
                        campoFilial.setAccessible(true);
                        filial = campoFilial.get(erro.getCampoNeogrid().getBeanPai()).toString();
                        coluna = erro.getCampoNeogrid().getBean().getFieldPrimaryKey();
                        valor = erro.getVo().getValorPrimaryKey().toString();
                    } else if (erro.isCombo()) {
                        tabela = erro.getCampoNeogrid().getBean().getClass().getAnnotation(DataBaseTable.class).value();
                        campoFilial = erro.getCampoNeogrid().getBean().getFieldByColumnName("fil_codigo");
                        campoFilial.setAccessible(true);
                        filial = campoFilial.get(erro.getCampoNeogrid().getBean()).toString();
                        coluna = erro.getCampoNeogrid().getField().getAnnotation(DataBaseField.class).value();
                        combo = erro.getListaCombo();
                    } else {
                        tabela = erro.getCampoNeogrid().getBean().getClass().getAnnotation(DataBaseTable.class).value();
                        campoFilial = erro.getCampoNeogrid().getBean().getFieldByColumnName("fil_codigo");
                        campoFilial.setAccessible(true);
                        filial = campoFilial.get(erro.getCampoNeogrid().getBean()).toString();
                        coluna = erro.getCampoNeogrid().getField().getAnnotation(DataBaseField.class).value();
                        valor = erro.getTextCorrecao().getText();
                    }
                    StringBuilder buf = new StringBuilder();
                    buf.append("update ");
                    buf.append(tabela);
                    buf.append(" set ").append(coluna).append(" = ");
                    if (erro.getCampoNeogrid().getTipo() == 3 || erro.getCampoNeogrid().getTipo() == 9 || erro.getCampoNeogrid().getTipo() == 8 || erro.getCampoNeogrid().getTipo() == 7 || erro.getCampoNeogrid().getTipo() == 15 || erro.getCampoNeogrid().getTipo() == 101) {
                        if (erro.isCombo()) {
                            buf.append(DBUtil.bdText(((DadosEspeciaisCombo)combo.getSelectedItem()).getCodigo().toString()));
                        } else {
                            buf.append(DBUtil.bdText(valor));
                        }
                    } else if (erro.getCampoNeogrid().getTipo() == 4) {
                        buf.append(" '").append(Funcoes.formataData("yyyy-MM-dd", valor)).append("' ");
                    } else if (erro.getCampoNeogrid().getTipo() == 2 || erro.getCampoNeogrid().getTipo() == 1 || erro.getCampoNeogrid().getTipo() == 10) {
                        if (erro.isCombo()) {
                            buf.append(((DadosEspeciaisCombo)combo.getSelectedItem()).getCodigo());
                        } else {
                            buf.append(Funcoes.limpaCampos(valor, new String[0]));
                        }
                    }
                    try {
                        buf.append(AbstractThreadDao.getWhere(erro.isNullCadastro() ? erro.getCampoNeogrid().getBeanPai() : erro.getCampoNeogrid().getBean()));
                    }
                    catch (Exception e) {
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Erro ao gerar update autom\u00e1tico.\n" + e.getMessage(), e.getStackTrace());
                    }
                    Conexao.executeUpdate(filial, st, buf.toString());
                }
            } else {
                for (ErrosCampos erro : this.erros) {
                    Field campoFilial = null;
                    String filial = null;
                    String tabela = null;
                    String coluna = null;
                    String valor = null;
                    JComboBox combo = null;
                    if (erro.isNullCadastro()) {
                        tabela = erro.getCampoTecnospeed().getBeanPai().getClass().getAnnotation(DataBaseTable.class).value();
                        campoFilial = erro.getCampoTecnospeed().getBeanPai().getFieldByColumnName("fil_codigo");
                        campoFilial.setAccessible(true);
                        filial = campoFilial.get(erro.getCampoTecnospeed().getBeanPai()).toString();
                        coluna = erro.getCampoTecnospeed().getBean().getFieldPrimaryKey();
                        valor = erro.getVo().getValorPrimaryKey().toString();
                    } else if (erro.isCombo()) {
                        tabela = erro.getCampoTecnospeed().getBean().getClass().getAnnotation(DataBaseTable.class).value();
                        campoFilial = erro.getCampoTecnospeed().getBean().getFieldByColumnName("fil_codigo");
                        campoFilial.setAccessible(true);
                        filial = campoFilial.get(erro.getCampoTecnospeed().getBean()).toString();
                        coluna = erro.getCampoTecnospeed().getField().getAnnotation(DataBaseField.class).value();
                        combo = erro.getListaCombo();
                    } else {
                        tabela = erro.getCampoTecnospeed().getBean().getClass().getAnnotation(DataBaseTable.class).value();
                        campoFilial = erro.getCampoTecnospeed().getBean().getFieldByColumnName("fil_codigo");
                        campoFilial.setAccessible(true);
                        filial = campoFilial.get(erro.getCampoTecnospeed().getBean()).toString();
                        coluna = erro.getCampoTecnospeed().getField().getAnnotation(DataBaseField.class).value();
                        valor = erro.getTextCorrecao().getText();
                    }
                    StringBuilder buf = new StringBuilder();
                    buf.append("update ");
                    buf.append(tabela);
                    buf.append(" set ").append(coluna).append(" = ");
                    if (erro.getCampoTecnospeed().getTipo().getTipoJalis() == 3 || erro.getCampoTecnospeed().getTipo().getTipoJalis() == 9 || erro.getCampoTecnospeed().getTipo().getTipoJalis() == 8 || erro.getCampoTecnospeed().getTipo().getTipoJalis() == 7 || erro.getCampoTecnospeed().getTipo().getTipoJalis() == 15 || erro.getCampoTecnospeed().getTipo().getTipoJalis() == 101) {
                        if (erro.isCombo()) {
                            buf.append(DBUtil.bdText(((DadosEspeciaisCombo)combo.getSelectedItem()).getCodigo().toString()));
                        } else if (erro.getCampoTecnospeed().getTipo().getTipoJalis() == TecnospeedUtil.TipoDado.CNPJ.getTipoJalis()) {
                            buf.append(DBUtil.bdText(StringUtil.limpaString(valor, new String[]{".", "-", "/"})));
                            NotaFiscalBean bean = (NotaFiscalBean)erro.getCampoTecnospeed().getBean();
                            bean.setCpfPagador(StringUtil.limpaString(valor, new String[]{".", "-", "/"}));
                        } else {
                            buf.append(DBUtil.bdText(valor));
                        }
                    } else if (erro.getCampoTecnospeed().getTipo().getTipoJalis() == 4) {
                        buf.append(" '").append(Funcoes.formataData("yyyy-MM-dd", valor)).append("' ");
                    } else if (erro.getCampoTecnospeed().getTipo().getTipoJalis() == 2 || erro.getCampoTecnospeed().getTipo().getTipoJalis() == 1 || erro.getCampoTecnospeed().getTipo().getTipoJalis() == 10) {
                        if (erro.isCombo()) {
                            buf.append(((DadosEspeciaisCombo)combo.getSelectedItem()).getCodigo());
                        } else {
                            buf.append(Funcoes.limpaCampos(valor, new String[0]));
                        }
                    }
                    try {
                        buf.append(AbstractThreadDao.getWhere(erro.isNullCadastro() ? erro.getCampoTecnospeed().getBeanPai() : erro.getCampoTecnospeed().getBean()));
                    }
                    catch (Exception e) {
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Erro ao gerar update autom\u00e1tico.\n" + e.getMessage(), e.getStackTrace());
                    }
                    Conexao.executeUpdate(filial, st, buf.toString());
                }
            }
            Conexao.arquivaSQL();
            isOk = true;
        }
        catch (Exception e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
                isOk = false;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        this.setVisible(false);
    }

    private void buscaCadastro(Component campo, ErrosCampos erro) {
        AbstractThreadBean bean = this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.NEOGRID ? erro.getCampoNeogrid().getBean() : erro.getCampoTecnospeed().getBean();
        try {
            AbstractThreadService service = FabricaDao.criarService(bean);
            AbstractThreadVO vo = service.pesquisaVO(this, (AbstractThreadVO)bean.clonar().toVO(), null, true);
            if (vo != null) {
                erro.setVo(vo);
                JLabel label = (JLabel)campo;
                label.setText(vo.toString());
            }
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi possivel carregar o cadastro. \n" + e.getMessage(), e.getStackTrace());
        }
    }

    private boolean validaCampos() {
        for (ErrosCampos erro : this.erros) {
            if (!erro.isNullCadastro()) {
                TTextField aux = erro.getTextCorrecao();
                JComboBox comboAux = erro.getListaCombo();
                if (aux != null && !aux.isConteudoValido()) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "O conte\u00fado do campo " + (this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.NEOGRID ? erro.getCampoNeogrid().getDescricao() : erro.getCampoTecnospeed().getNomeAmigavel()) + " \u00e9 inv\u00e1lido.", 2);
                    ScreenUtil.requisitarFoco(aux);
                    return false;
                }
                if (comboAux != null && comboAux.getSelectedIndex() == -1) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "O item do campo " + (this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.NEOGRID ? erro.getCampoNeogrid().getDescricao() : erro.getCampoTecnospeed().getNomeAmigavel()) + " deve ser selecionado.", 2);
                    ScreenUtil.requisitarFoco(comboAux);
                    return false;
                }
                if (aux != null && !Funcoes.textoVazio(aux) || comboAux != null && comboAux.getSelectedIndex() != -1) continue;
                Funcoes.mensagem(Laboratorio.getInstancia(), (this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.NEOGRID ? erro.getCampoNeogrid().getDescricao() : erro.getCampoTecnospeed().getNomeAmigavel()) + " deve ser preenchido.", 2);
                ScreenUtil.requisitarFoco(aux);
                return false;
            }
            if (erro.getVo() != null) continue;
            Funcoes.mensagem(Laboratorio.getInstancia(), ((DadosEspeciaisNFSe)((Object)(this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.NEOGRID ? erro.getCampoNeogrid().getBean() : erro.getCampoTecnospeed().getBean()))).getDescricaoTabela() + " deve ser selecionado(a).", 2);
            return false;
        }
        return true;
    }

    public static boolean isOk() {
        return isOk;
    }

    private int getTamanhoCombo(JComboBox combo) {
        if (combo == null) {
            return 0;
        }
        int tamanhoMaximo = 0;
        for (int i = 0; i < combo.getItemCount(); ++i) {
            String valor = combo.getItemAt(i).toString();
            FontMetrics met = combo.getFontMetrics(combo.getFont());
            int width = met.stringWidth(valor);
            if (width <= tamanhoMaximo) continue;
            tamanhoMaximo = width;
        }
        return tamanhoMaximo;
    }
}

