/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class TelaDeveGuiaExame
extends AbstractDialogoOKCancelar {
    private ModeloGridTable modeloExames;
    private JTable tableExames;
    private JScrollPane scrollExames;
    private final int POSICAO_DEVE_GUIA = 3;
    private final int POSICAO_OBJETO = 4;

    public TelaDeveGuiaExame(Frame pai, ArrayList<DadosExameFaturamento> dadosExames) {
        super(pai, "Marcar/Desmarcar exame sem guia");
        this.getPanelCentral().setLayout(new FlowLayout());
        this.modeloExames = new ModeloGridTable(new String[]{"Exame", "Descri\u00e7\u00e3o", "Material", "Deve guia", "Objeto"}){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Class[] valores = new Class[]{String.class, String.class, String.class, Boolean.class, DadosExameFaturamento.class};
                return valores[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                boolean[] valores = new boolean[]{false, false, false, true, false};
                return valores[columnIndex];
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    TelaDeveGuiaExame.this.tableExames.removeColumn(TelaDeveGuiaExame.this.tableExames.getColumn("Objeto"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (TelaDeveGuiaExame.this.tableExames != null) {
                        TelaDeveGuiaExame.this.tableExames.removeColumn(TelaDeveGuiaExame.this.tableExames.getColumn("Objeto"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.tableExames = new JTable(this.modeloExames);
        this.modeloExames.setColumnSize(new int[]{60, 0, 70, 80, 0}, this.tableExames);
        this.tableExames.removeColumn(this.tableExames.getColumnModel().getColumn(this.tableExames.getColumnCount() - 1));
        this.tableExames.getTableHeader().addMouseListener(this.modeloExames);
        this.scrollExames = new JScrollPane(this.tableExames);
        this.scrollExames.setPreferredSize(new Dimension(390, 180));
        this.scrollExames.setMinimumSize(new Dimension(390, 180));
        this.getPanelCentral().add(this.scrollExames);
        Funcoes.montaEnter((JComponent)this.getPanelCentral());
        this.setSize(new Dimension(420, 270));
        this.setLocationRelativeTo(pai);
        this.preencherDadosExames(dadosExames);
    }

    @Override
    protected boolean acaoOk() {
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            DadosExameFaturamento exame = (DadosExameFaturamento)this.modeloExames.getValueAt(i, 4);
            boolean deveGuia = (Boolean)this.modeloExames.getValueAt(i, 3);
            exame.setDeveGuia(deveGuia);
        }
        return true;
    }

    private void preencherDadosExames(ArrayList<DadosExameFaturamento> dados) {
        this.modeloExames.clear();
        for (int i = 0; dados != null && i < dados.size(); ++i) {
            DadosExameFaturamento exame = dados.get(i);
            this.modeloExames.addLine(new Object[]{exame.getCodigoExame(), exame.getNomeExame(), exame.getDescricaoMaterial(), exame.getDeveGuia(), exame});
        }
    }
}

