/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.laboratorio.financeiro.faturamento.CodigoMaterial;
import jalis.util.ConvenioUtil;
import jalis.util.ExameUtil;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class TelaAlterarValor
extends JDialog
implements ActionListener {
    private final JLabel label = new JLabel("Selecione os exames a serem atualizados: ");
    private final JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private final JButton buttonSalvar = ComponenteFactory.novoJButton("OK", 'O', this, null, null);
    private final JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private final ModeloGridTable modelo = new ModeloGridTable(new String[]{"S", "Exame", "Mat.", "Descri\u00e7\u00e3o"});
    private final JTable tabela = new JTable(this.modelo){

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        public Class getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }
    };
    private final JScrollPane scroll = new JScrollPane(this.tabela);
    private boolean ok = false;
    private DadosFaturamento dados;

    public TelaAlterarValor(Frame owner) {
        super(owner, "Selecionar exames");
        this.setModal(true);
        this.setSize(new Dimension(350, 450));
        this.setLocationRelativeTo(owner);
        this.montaTela();
        this.modelo.setColumnSize(new int[]{20, 50, 40, 0}, this.tabela);
        this.tabela.grabFocus();
    }

    private void montaTela() {
        this.setLayout(new GridBagLayout());
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.fill = 2;
        cons.anchor = 17;
        this.add((Component)this.label, cons);
        cons.gridy = 2;
        this.add((Component)this.panelBotoes, cons);
        cons.gridy = 1;
        cons.fill = 1;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        this.add((Component)this.scroll, cons);
        ((JPanel)this.getContentPane()).setBorder(ScreenUtil.criarBordaVazia());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean bl = this.ok = e.getSource() == this.buttonSalvar;
        if (this.ok) {
            for (int i = 0; i < this.dados.getExamesCount(); ++i) {
                if (!((Boolean)this.modelo.getValueAt(i, 0)).booleanValue()) continue;
                DadosExameFaturamento exm = this.dados.getExame(i);
                try {
                    DadosMaterial mat = ExameUtil.getDadosMaterial(String.valueOf(this.dados.getCodigoFilial()), exm.getCodigoMaterial());
                    DadosExames exame = ExameUtil.getDadosExame(String.valueOf(this.dados.getCodigoFilial()), exm.getCodigoExame(), mat);
                    DadosConvenios convenio = ConvenioUtil.getDadosConvenios(String.valueOf(this.dados.getCodigoFilial()), this.dados.getCodigoConvenio());
                    ExameUtil.calculaPrecoExame(String.valueOf(this.dados.getCodigoFilial()), exame, mat, convenio, false, true, false, this.dados.getRequisicao(), null, Integer.parseInt(exame.getCodMetodo()));
                    if (exm.getValorExame().compareTo(exame.getValorExame()) != 0 || exm.getValorCHExame().compareTo(exame.getValorCH()) != 0) {
                        exm.setDadosAlterados(true);
                        this.dados.setDadosAlterados(true);
                    }
                    exm.setValorExame(exame.getValorExame());
                    exm.setValorCHExame(exame.getValorCH());
                    exm.setValorCH(this.dados.getValorCHConvenio());
                    continue;
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ConferenciaFatura");
                }
            }
        }
        this.setVisible(false);
    }

    public boolean ok() {
        return this.ok;
    }

    private void adicionaExame(String codigo, int codigoMaterial, String abreviaturaMaterial, String descricao) {
        this.modelo.addLine(new Object[]{new Boolean(false), codigo, new CodigoMaterial(codigoMaterial, abreviaturaMaterial), descricao});
    }

    public void setDadosFaturamento(DadosFaturamento dados) {
        this.dados = dados;
        for (int i = 0; i < dados.getExamesCount(); ++i) {
            DadosExameFaturamento exm = dados.getExame(i);
            this.adicionaExame(exm.getCodigoExame(), exm.getCodigoMaterial(), exm.getAbreviaturaMaterial(), exm.getNomeExame());
        }
        this.tabela.setRowSelectionInterval(0, 0);
    }
}

