/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.ModeloGridTable;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class SelecionarExamesConferenciaGuias
extends AbstractDialogoOKCancelar {
    private static Integer COLUNAEXAME = 0;
    private static Integer COLUNAFATURADO = 3;
    private static Integer COLUNAREGISTRO = 4;
    private final ModeloGridTable modeloExame = new ModeloGridTable(new String[]{"C\u00f3d", "Mat.", "Descri\u00e7\u00e3o", "Fat."}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == COLUNAFATURADO) {
                return Boolean.class;
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == COLUNAFATURADO;
        }
    };
    private final JTable tableExame = new JTable(this.modeloExame);
    private JScrollPane scrollPaneExame = new JScrollPane(this.tableExame);
    private JPanel paneExames = new JPanel(new BorderLayout());
    private List<String> listaExames = new ArrayList<String>();

    public static SelecionarExamesConferenciaGuias novaInstancia(Window owner, String titulo) {
        if (owner instanceof JDialog) {
            return new SelecionarExamesConferenciaGuias((Dialog)((JDialog)owner), titulo);
        }
        return new SelecionarExamesConferenciaGuias((JFrame)owner, titulo);
    }

    public SelecionarExamesConferenciaGuias(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public SelecionarExamesConferenciaGuias(JFrame pai, String titulo) {
        super((Frame)pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(470, 420);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.getPanelCentral().setLayout(new BorderLayout());
        this.modeloExame.setColumnSize(new int[]{70, 60, 0, 60}, this.tableExame);
        this.tableExame.getTableHeader().setResizingAllowed(true);
        this.paneExames.add((Component)this.scrollPaneExame, "Center");
        this.paneExames.setBorder(new TitledBorder(""));
        this.getPanelCentral().add((Component)this.paneExames, "Center");
    }

    public void setListaExames(Registro[] requisicaoExames) {
        for (Registro registro : requisicaoExames) {
            String situacao = registro.getString("exr_situacao");
            if (!this.isConferidoImpresso(situacao)) continue;
            this.modeloExame.addLine(new Object[]{registro.getString("exa_codigo"), registro.getString("mco_abreviatura"), registro.getString("exa_descricao"), Boolean.TRUE, registro});
        }
    }

    private boolean isConferidoImpresso(String situacao) {
        return situacao.equals("C") || situacao.equals("I");
    }

    public Registro[] getExames() {
        Registro[] registros = new Registro[this.modeloExame.getRowCount()];
        for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
            Registro registro;
            boolean faturado = (Boolean)this.modeloExame.getValueAt(i, COLUNAFATURADO);
            if (!faturado) continue;
            registros[i] = registro = (Registro)this.modeloExame.getValueAt(i, COLUNAREGISTRO);
        }
        return registros;
    }
}

