/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

class SelecaoRequisicao
extends JDialog
implements ActionListener {
    private final int COLUNA_REQUISICAO = 0;
    private JScrollPane scrollRequisicoes = new JScrollPane();
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Requisi\u00e7\u00e3o", "Guia", "Paciente", "Conv\u00eanio", "Data Cadastro", "Data Fatura", "Exames", "Guias Exames"});
    private JTable tableRequisicoes = new JTable(this.modeloRequisicoes);
    private JPanel panelCentral = new JPanel(new BorderLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JButton buttonOk = new JButton("OK");
    private JButton buttonCancelar = new JButton("Cancelar");
    private ArrayList<DadosFaturamento> dados = null;
    private DadosFaturamento retorno = null;

    public SelecaoRequisicao(Window owner, ArrayList<DadosFaturamento> dados) throws Exception {
        super(owner, "Selecione a requisi\u00e7\u00e3o desejada");
        this.setModal(true);
        this.setSize(600, 300);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        if (dados == null) {
            throw new Exception("As requisi\u00e7\u00f5es n\u00e3o foram informadas.");
        }
        this.dados = dados;
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.panelCentral, "Center");
        panel.add((Component)this.panelBotoes, "South");
        this.panelCentral.setBorder(new TitledBorder("Requisi\u00e7\u00f5es localizadas"));
        this.panelCentral.add(this.scrollRequisicoes);
        this.panelBotoes.add(this.buttonOk);
        this.panelBotoes.add(this.buttonCancelar);
        this.scrollRequisicoes.setViewportView(this.tableRequisicoes);
        this.tableRequisicoes.getTableHeader().addMouseListener(this.modeloRequisicoes);
        this.tableRequisicoes.setAutoResizeMode(0);
        this.tableRequisicoes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (SelecaoRequisicao.this.tableRequisicoes.getSelectedRow() > -1 && e.getKeyCode() == 10) {
                    SelecaoRequisicao.this.buttonOk.doClick();
                }
            }
        });
        this.buttonOk.setMnemonic('O');
        this.buttonCancelar.setMnemonic('C');
        this.buttonOk.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        for (int i = 0; i < dados.size(); ++i) {
            DadosFaturamento requisicao = dados.get(i);
            if (requisicao == null) continue;
            ArrayList<DadosExameFaturamento> exames = requisicao.getExames();
            Collections.sort(exames);
            String stringExames = "";
            ArrayList<String> guias = new ArrayList<String>();
            for (int j = 0; j < exames.size(); ++j) {
                DadosExameFaturamento exame = exames.get(j);
                if (stringExames.length() > 0) {
                    stringExames = stringExames + ", ";
                }
                stringExames = stringExames + exame.getCodigoExame();
                if (exame.getCodigoGuia() == null || guias.contains(exame.getCodigoGuia())) continue;
                guias.add(exame.getCodigoGuia());
            }
            String stringGuias = "";
            for (String aux : guias) {
                if (stringGuias.length() > 0) {
                    stringGuias = stringGuias + ", ";
                }
                stringGuias = stringGuias + aux;
            }
            this.modeloRequisicoes.addLine(new Object[]{requisicao.getRequisicao(), requisicao.getGuiaPrincipal(), requisicao.getNomePaciente(), requisicao.getFantasiaConvenioPrincipal(), Funcoes.formataData("dd/MM/yyyy", requisicao.getDataRequisicao()), Funcoes.formataData("dd/MM/yyyy", requisicao.getDataFaturaRequisicao()), stringExames, stringGuias});
        }
        int[] tamCols = this.calculaTamanhoColunas();
        for (int i = 0; i < tamCols.length; ++i) {
            this.tableRequisicoes.getColumnModel().getColumn(i).setWidth(tamCols[i]);
            this.tableRequisicoes.getColumnModel().getColumn(i).setMaxWidth(tamCols[i]);
            this.tableRequisicoes.getColumnModel().getColumn(i).setMinWidth(tamCols[i]);
            this.tableRequisicoes.getColumnModel().getColumn(i).setPreferredWidth(tamCols[i]);
        }
    }

    public int[] calculaTamanhoColunas() {
        if (this.tableRequisicoes != null) {
            FontMetrics met = this.tableRequisicoes.getFontMetrics(this.tableRequisicoes.getFont());
            int[] tamCols = new int[this.modeloRequisicoes.getColumnCount()];
            for (int i = 0; i < tamCols.length; ++i) {
                int tamanho = met.stringWidth(this.modeloRequisicoes.getColumnName(i)) + 18;
                for (int j = 0; j < this.modeloRequisicoes.getRowCount(); ++j) {
                    int tmp = 15;
                    if (met != null && this.modeloRequisicoes.getValueAt(j, i) != null) {
                        tmp = met.stringWidth(this.modeloRequisicoes.getValueAt(j, i).toString()) + 10;
                    }
                    if (tmp <= tamanho) continue;
                    tamanho = tmp;
                }
                tamCols[i] = tamanho;
            }
            return tamCols;
        }
        return new int[0];
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() != this.buttonOk) {
            if (e.getSource() != this.buttonCancelar) return;
            this.setVisible(false);
            return;
        }
        if (this.validaSelecao()) {
            this.setRetorno();
            this.setVisible(false);
            return;
        }
        Funcoes.mensagem(this, "\u00c9 necess\u00e1rio selecionar uma requisi\u00e7\u00e3o.", 2);
    }

    private void setRetorno() {
        int row = this.tableRequisicoes.getSelectedRow();
        if (row > -1) {
            int codigoRequisicao = Integer.parseInt(this.modeloRequisicoes.getValueAt(row, 0).toString());
            for (int i = 0; i < this.dados.size(); ++i) {
                DadosFaturamento requisicao = this.dados.get(i);
                if (requisicao.getRequisicao() != codigoRequisicao) continue;
                this.retorno = requisicao;
                break;
            }
        }
    }

    private boolean validaSelecao() {
        int row = this.tableRequisicoes.getSelectedRow();
        return row > -1;
    }

    public DadosFaturamento getRetorno() {
        return this.retorno;
    }
}

