/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.laboratorio.financeiro.faturamento.DadosSetor;
import jalis.util.Funcoes;
import java.util.ArrayList;

public class ResumoFaturamento {
    ArrayList<DadosSetor> setores = new ArrayList();
    Double valorAdicional = 0.0;
    Double valorDesconto = 0.0;
    Double valorDespesa = 0.0;
    int qtdeParcelas = 0;

    public ResumoFaturamento(int qtdeParcelas) {
        this.qtdeParcelas = qtdeParcelas;
    }

    public void adicionaSetor(int codigo, String descricao, Double valor) {
        DadosSetor setor = new DadosSetor(codigo, descricao, valor);
        int pos = this.achaSetor(setor);
        if (pos > -1) {
            this.setores.get(pos).setValor(this.setores.get(pos).getValor() + setor.getValor());
        } else {
            this.setores.add(setor);
        }
    }

    private int achaSetor(DadosSetor d) {
        for (int i = 0; i < this.setores.size(); ++i) {
            if (!this.setores.get(i).getCodigo().equals(d.getCodigo())) continue;
            return i;
        }
        return -1;
    }

    public Double getValorAdicional() {
        return this.valorAdicional;
    }

    public void setValorAdicional(Double valorAdicional) {
        this.valorAdicional = valorAdicional;
    }

    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    public Double getValorDespesa() {
        return this.valorDespesa;
    }

    public void setValorDespesa(Double valorDespesa) {
        this.valorDespesa = valorDespesa;
    }

    public String getResumo() {
        StringBuilder buf = new StringBuilder();
        buf.append(Funcoes.preencheVazio("Cod", 4, 1));
        buf.append(" ").append(Funcoes.preencheVazio("Setor", 50, 2));
        buf.append(" ").append(Funcoes.preencheVazio("Acumulado", 10, 1));
        buf.append(" ").append(Funcoes.preencheVazio("Parcelado", 10, 1));
        buf.append("\n");
        for (DadosSetor d : this.setores) {
            buf.append(Funcoes.preencheVazio(String.valueOf(d.getCodigo()), 4, 1));
            buf.append(" ").append(Funcoes.preencheVazio(d.getDescricao(), 50, 2));
            buf.append(" ").append(Funcoes.preencheVazio(Funcoes.formataDecimal(d.getValor()), 10, 1));
            buf.append("\n");
        }
        buf.append("    ").append(Funcoes.preencheVazio("Valor adicional", 50, 2));
        buf.append(" ").append(Funcoes.preencheVazio(Funcoes.formataDecimal(this.valorAdicional), 10, 1));
        buf.append("\n");
        buf.append("    ").append(Funcoes.preencheVazio("Valor desconto", 50, 2));
        buf.append(" ").append(Funcoes.preencheVazio(Funcoes.formataDecimal(this.valorDesconto), 10, 1));
        buf.append("\n");
        buf.append("    ").append(Funcoes.preencheVazio("Valor despesa", 50, 2));
        buf.append(" ").append(Funcoes.preencheVazio(Funcoes.formataDecimal(this.valorDespesa), 10, 1));
        buf.append("\n");
        return buf.toString();
    }

    public String getResumoHTML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<style>  .fonte {    font-family: Verdana, Arial, Helvetica, sans-serif, Dialog;  }</style>");
        buf.append("<table border='0' class='fonte'>");
        buf.append("<tr><td align='right'><b>");
        buf.append(Funcoes.preencheVazio("Cod", 4, 1));
        buf.append("</b></td><td><b>").append("Setor");
        buf.append("</b></td><td align='right'><b>").append("Acumulado");
        buf.append("</b></td><td align='right'><b>").append("Parcelado");
        buf.append("</b></td></tr>");
        for (DadosSetor d : this.setores) {
            buf.append("<tr><td align='right'>");
            buf.append(Funcoes.preencheVazio(String.valueOf(d.getCodigo()), 4, 1));
            buf.append("</td><td>").append(d.getDescricao());
            buf.append("</td><td align='right'>").append(Funcoes.formataDecimal(d.getValor()));
            buf.append("</td><td align='right'>").append(Funcoes.formataDecimal(this.qtdeParcelas > 0 ? d.getValor() / (double)this.qtdeParcelas : 0.0));
            buf.append("</td></tr>");
        }
        buf.append("<tr><td>&nbsp;</td><td>").append("Valor adicional");
        buf.append("</td><td align='right'>").append(Funcoes.formataDecimal(this.valorAdicional));
        buf.append("</td><td align='right'>").append(Funcoes.formataDecimal(this.qtdeParcelas > 0 ? this.valorAdicional / (double)this.qtdeParcelas : 0.0));
        buf.append("</td></tr>");
        buf.append("<tr><td>&nbsp;</td><td>").append("Valor desconto");
        buf.append("</td><td align='right'>").append(Funcoes.formataDecimal(this.valorDesconto));
        buf.append("</td><td align='right'>").append(Funcoes.formataDecimal(this.qtdeParcelas > 0 ? this.valorDesconto / (double)this.qtdeParcelas : 0.0));
        buf.append("</td></tr>");
        buf.append("<tr><td>&nbsp;</td><td>").append("Valor despesa");
        buf.append("</td><td align='right'>").append(Funcoes.formataDecimal(this.valorDespesa));
        buf.append("</td><td align='right'>").append(Funcoes.formataDecimal(this.qtdeParcelas > 0 ? this.valorDespesa / (double)this.qtdeParcelas : 0.0));
        buf.append("</td></tr>");
        buf.append("</table>");
        return buf.toString();
    }
}

